# Tor browser manual link shown in the menu bar.
# Uses Title case.
menu-open-tor-manual =
    .label = Посібник для вебоглядача Tor
    .accesskey = П
tor-browser-home-heading-stable = Шукайте. Приватно.
tor-browser-home-heading-testing = Тест. Ретельно.
tor-browser-home-duck-duck-go-input =
    .placeholder = Пошук через DuckDuckGo
tor-browser-home-message-introduction = Ви готові до найприватнішого вебперегляду у світі.
# Tor browser manual link shown in the application menu (aka: hamburger menu).
# Uses Sentence case.
appmenu-open-tor-manual =
    .label = Посібник для браузера Tor
    .accesskey = П
# Shown in Home settings, corresponds to the default about:tor home page.
home-mode-choice-tor =
    .label = Домівка браузера Tor
# Tor Browser home page.
tor-browser-home-message-donate = Tor безплатний завдяки пожертвам таких людей, як ви. <a data-l10n-name="donate-link">Пожертвувати зараз</a>
# Tor Browser home page.
# Update message.
# <a data-l10n-name="update-link"> should contain the link text and close with </a>.
# $version (String) - The new tor browser version.
tor-browser-home-message-updated = Браузер Tor оновлено до { $version }. <a data-l10n-name="update-link">Перегляньте що нового</a>
# Tor Browser home page.
tor-browser-home-message-testing = Це нестабільна версія браузера Tor для тестування нових функцій. <a data-l10n-name="learn-more-link">Докладніше</a>
# Tor Browser home page.
tor-browser-home-message-news = Отримуйте останні новини від Tor прямо на свою поштову скриньку. <a data-l10n-name="news-link">Підписатися на новини Tor</a>
# Tor Browser home page.
# Toggle to switch from DuckDuckGo's plain ".com" domain to its ".onion" domain.
tor-browser-home-onionize-toggle =
    .label = Onionize
    .title = Пошук за допомогою onion-сайту
# Tor Browser home page.
# Only shown when underlying Tor process was not started by Tor Browser.
# "Tails" refers to the operating system, and should be translated as a brand name.
# <a data-l10n-name="tor-check-link"> should contain the link text and close with </a>.
tor-browser-home-tor-check-warning = Ваше з'єднання з Tor не керується браузером Tor. Деякі операційні системи (наприклад, Tails) керуватимуть ним замість вас, або ви могли налаштувати власну конфігурацію. <a data-l10n-name="tor-check-link">Перевірте своє з'єднання</a>
# Tor Bridges Settings
# Used for an image of a bridge emoji. Each bridge address can be hashed into four emojis shown to the user (bridgemoji feature). This string corresponds to a *single* such emoji. The "title" should just be emojiName. The "alt" should let screen readers know that the image is of a *single* emoji, as well as its name.
# $emojiName (String) - The name of the emoji, already localized.
tor-bridges-emoji-image =
    .alt = Emoji: { $emojiName }
    .title = { $emojiName }
# Tor Bridges Settings
# Shown at the start of a Tor bridge line.
# $type (String) - The Tor bridge type ("snowflake", "obfs4", "meek-azure").
tor-bridges-type-prefix = Міст { $type }:
# Tor Bridges Settings
# Here "Email" is a verb, short for "Send an email to". This is an instruction to send an email to the given address to receive a new bridge.
# $address (String) - The email address that should receive the email.
# E.g. in English, "Email bridges@torproject.org".
tor-bridges-provider-email-instruction = Електронна пошта { $address }
# Tor Bridges Settings
# Shown as a heading when the user has no current bridges.
tor-bridges-add-bridges-heading = Додати мости
# Tor Bridges Settings
# Shown as a heading when the user has existing bridges that can be replaced.
tor-bridges-replace-bridges-heading = Замінити ваші мости
# Tor Bridges Settings
# Shown at the start of a Tor bridge line, when the transport type is unknown (or "vanilla").
tor-bridges-type-prefix-generic = Міст Tor:
# Tor Bridges Settings
# The "..." menu button for an individual bridge row.
tor-bridges-individual-bridge-options-button =
    .title = Параметри мосту
# Tor Bridges Settings
# "Web" is the proper noun for the "World Wide Web".
tor-bridges-provider-web-name = Сайт
# Tor Bridges Settings
# Here "Message" is a verb, short for "Send a message to". This is an instruction to send a message to the given Telegram Messenger user to receive a new bridge.
# $telegramUserName (String) - The Telegram Messenger user name that should receive messages. Should be wrapped in '<a data-l10n-name="user">' and '</a>'.
# E.g. in English, "Message GetBridgesBot".
tor-bridges-provider-telegram-instruction = Повідомлення <a data-l10n-name="user">{ $telegramUserName }</a>
# Tor Bridges Settings
# "Telegram" is the common brand name of the Telegram Messenger application
tor-bridges-provider-telegram-name = Telegram
# Tor Bridges Settings
# Shown when one of the built-in bridges is in use.
tor-bridges-built-in-status-connected = З'єднано
# Tor Bridges Settings
# The emoji name to show on hover when a bridge emoji's name is unknown.
tor-bridges-emoji-unknown = Невідомо
# Tor Bridges Settings
# Shown when the bridge has been used for the most recent Tor circuit, i.e. the most recent bridge we have connected to.
tor-bridges-status-connected = З'єднано
# Tor Bridges Settings
# Button for the user to acknowledge a change in their "bridge pass".
tor-bridges-lox-got-it-button = Зрозуміло
# Tor Bridges Settings
# "Gmail" is the Google brand name. "Riseup" refers to the Riseup organisation at riseup.net.
tor-bridges-provider-email-name = Gmail або Riseup
# User provided bridge dialog.
# Short accessible name for the bridge addresses text area.
user-provide-bridge-dialog-textarea-addresses-label = Адреси мостів
# User provided bridge dialog.
# "Learn more" link shown in the "Add new bridges"/"Replace your bridges" dialog.
user-provide-bridge-dialog-learn-more = Докладніше
# Tor Bridges Settings
# Used when the bridge has no status, i.e. the *absence* of a status to report to the user. This is only visibly shown when the status cell has keyboard focus.
tor-bridges-status-none = Без статусу
# Tor Bridges Settings
tor-bridges-select-built-in-button = Вибрати вбудований міст…
# Tor Bridges Settings
# Shown for requested bridges and bridges added by the user.
tor-bridges-share-heading = Допоможіть іншим під'єднатися
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Shows the QR code for this one bridge.
tor-bridges-menu-item-qr-address = Показати QR-код
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Copies the single bridge address to clipboard.
tor-bridges-menu-item-copy-address = Копіювати адресу мосту
    .accesskey = C
# Tor Bridges Settings
tor-bridges-copy-addresses-button = Копіювати адреси
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Removes this one bridge.
tor-bridges-menu-item-remove-bridge = Вилучити міст
    .accesskey = R
# Tor Bridges Settings
# Update text for screen reader users when their bridges have changed in some arbitrary way.
tor-bridges-update-changed-bridges = Ваш міст Tor змінено.
# Tor Bridges Settings
tor-bridges-qr-addresses-button =
    .title = Показати QR-код
# Tor Bridges Settings
# Text shown just before a description of the most recent change to the list of user's bridges. Some white space will separate this text from the change description.
# This text is not visible, but is instead used for screen reader users.
# E.g. in English this could be "Recent update: One of your Tor bridges has been removed."
tor-bridges-update-area-intro = Недавнє оновлення:
# Tor Bridges Settings
# Update text for screen reader users when only one of their bridges has been removed.
tor-bridges-update-removed-one-bridge = Один з ваших мостів Tor вилучено.
# Tor Bridges Settings
# Update text for screen reader users when all of their bridges have been removed.
tor-bridges-update-removed-all-bridges = Усі ваші мости Tor вилучено.
# Tor Bridges Settings
tor-bridges-source-built-in = Вбудовані
# Tor Bridges Settings
# Toggle button for enabling and disabling the use of bridges.
tor-bridges-use-bridges =
    .label = Використовувати мости
# Tor Bridges Settings
tor-bridges-none-added = Немає доданих мостів
# Tor Bridges Settings
tor-bridges-your-bridges = Ваші мости
# Tor Bridges Settings
tor-bridges-source-user = Додано вами
# Tor Bridges Settings
# The "..." menu button for all current bridges.
tor-bridges-options-button =
    .title = Усі мости
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can copy all of their bridges.
tor-bridges-menu-item-copy-all-bridge-addresses = Копіювати адреси мостів
    .accesskey = C
# Tor Bridges Settings
# Only shown in the "..." menu for bridges added by the user.
tor-bridges-menu-item-edit-all-bridges = Змінити мости
    .accesskey = E
# Tor Bridges Settings
# Shown in the "..." menu for all current bridges.
tor-bridges-menu-item-remove-all-bridges = Вилучити всі мости
    .accesskey = R
# Tor Bridges Settings
tor-bridges-share-description = Поділитися своїми мостами з надійними контактами.
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can generate a QR code for all of their bridges.
tor-bridges-menu-item-qr-all-bridge-addresses = Показати QR-код
    .accesskey = Q
about-dialog-tor-project = { -brand-short-name } розроблено <label data-l10n-name="project-link">{ -vendor-short-name }</label>, некомерційна розробка, щоб захистити ваше приватне життя й онлайн-свободу.
about-dialog-help-out = Бажаєте допомогти? <label data-l10n-name="donate-link">Підтримати</label> або <label data-l10n-name="community-link">долучитися</label>!
about-dialog-questions-link = Питання?
about-dialog-grow-tor-network-link = Допоможіть мережі Tor розвиватися!
about-dialog-browser-license-link = Інформація про ліцензування
menu-new-tor-circuit =
    .label = Нова Схема Tor для цього сайту
    .accesskey = С
appmenuitem-new-tor-circuit =
    .label = Нова схема Tor для цього сайту
toolbar-new-tor-circuit =
    .label = Нова схема Tor для цього сайту
    .tooltiptext = { toolbar-new-tor-circuit.label }
tor-circuit-urlbar-button =
    .tooltiptext = Схема Tor
tor-circuit-panel-heading = Схема для { $host }
tor-circuit-panel-alias = Під’єднано до <a data-l10n-name="alias-link">{ $alias }</a>
tor-circuit-panel-node-list-introduction = Схема Tor
tor-circuit-panel-node-browser = Цей браузер
tor-circuit-panel-node-onion-relays = Ретранслятор сайтів Onion
tor-circuit-panel-node-typed-bridge = Міст: { $bridge-type }
tor-circuit-panel-node-bridge = Міст
tor-circuit-panel-node-region-guard = { $region } (сторожовий)
tor-circuit-panel-node-unknown-region = Невідомий регіон
tor-circuit-panel-new-button = Нова схема Tor для цього сайту
tor-circuit-panel-new-button-description-guard = Ваш сторожовий вузол не може змінюватися
tor-circuit-panel-new-button-description-bridge = Ваш міст може не змінитися
crypto-safety-prompt-title = Адресу криптовалюти скопійовано з небезпечного вебсайту
crypto-safety-prompt-body = Скопійований текст ({ $address }) — це адреса криптовалюти. Оскільки з'єднання з { $host } незахищене, адреса могла бути змінена і їй не варто довіряти. Ви можете спробувати встановити безпечне з'єднання, повторно під'єднавшись за допомогою нової схеми.
crypto-safety-prompt-reload-button = Перезавантажити вкладку з новою схемою
crypto-safety-prompt-dismiss-button = Відхилити попередження
# Tor Bridges Settings.
# "meek-azure" is a technical name, and likely should not be translated.
tor-bridges-built-in-meek-azure-name = meek-azure
# Built-in bridges dialog.
request-bridge-dialog-captcha-failed = Розв'язок неправильний. Повторіть спробу.
# Tor connection settings.
# Shown when the user is not connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-offline = Не в мережі
# Tor Bridges Settings.
tor-bridges-heading = Мости
# Common button used in bridge dialogs.
bridge-dialog-button-connect = Під'єднатися
# Built-in bridges dialog.
request-bridge-dialog-top-solve = Розв'яжіть CAPTCHA, щоб надіслати запит на отримання мосту.
# Tor connection settings.
tor-connection-browser-learn-more-link = Докладніше
# Tor connection settings.
tor-connection-quickstart-heading = Швидкий початок
# Tor connection settings.
# Prefix before the internet connection status.
# "Internet" is not a proper noun, but is capitalized because it is the start of a sentence.
tor-connection-internet-status-label = Інтернет:
# Tor connection settings.
# Button to test the internet connection.
# Here "Test" is a verb, as in "test the internet connection".
# Uses sentence case in English (US).
tor-connection-internet-status-test-button = Тест
# Tor connection settings.
# Shown when the user is connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connected = Під’єднано
# Tor connection settings.
# Shown when the user is not connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-not-connected = Немає з'єднання
# Tor connection settings.
# Shown when the user's Tor connection may be blocked.
# Uses sentence case in English (US).
tor-connection-network-status-blocked = Потенційно заблоковано
# Tor connection settings.
# Button shown when we are not yet connected to the Tor network.
# It will open a page to start connecting to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connect-button = Під'єднатися
# Tor Bridges Settings.
tor-bridges-overview = Мости допомагають вам безпечно отримати доступ до мережі Tor у місцях, де Tor заблоковано. Залежно від того, де ви знаходитесь, один міст може працювати краще, ніж інший.
# Tor Bridges Settings.
tor-bridges-learn-more-link = Докладніше
# Tor Bridges Settings.
# "obfs4" is a technical name, and likely should not be translated.
tor-bridges-built-in-obfs4-name = obfs4
# Tor Bridges Settings.
tor-bridges-built-in-obfs4-description = Робить ваш Tor-трафік схожим на випадкові дані. Може не працювати в регіонах з жорсткою цензурою.
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-name = Snowflake
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-description = Спрямовує ваше з'єднання через проксі-сервери Snowflake, щоб створити враження, ніби ви здійснюєте відеовиклик, наприклад.
# Tor Bridges Settings.
tor-bridges-built-in-meek-azure-description = Створює враження, що ви під'єднані до вебсайту Microsoft, а не використовуєте Tor. Може працювати в регіонах з жорсткою цензурою, але зазвичай дуже повільно.
# Warning dialog when removing all bridges.
remove-all-bridges-warning-title = Вилучити всі мости?
# Warning dialog when removing all bridges.
remove-all-bridges-warning-description = Якщо мости були отримані з torproject.org або додані вручну, цю дію не можливо скасувати
# Common button used in bridge dialogs.
bridge-dialog-button-submit = Надіслати
# Built-in bridges dialog.
request-bridge-dialog-top-wait = Зв'язуюся з BridgeDB. Будь ласка, зачекайте.
# Tor advanced settings.
tor-advanced-settings-heading = Розширені
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-port-input-label = Порт
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input-label = Ім'я користувача
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input-label = Пароль
# Tor connection settings.
# "Connection" refers to the Tor Browser's connection to the Tor network.
tor-connection-settings-heading = З'єднання
# Tor connection settings.
# Shown when the user is connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-online = В мережі
# Warning dialog when removing all bridges.
remove-all-bridges-warning-remove-button = Видалити
# Common button used in bridge dialogs.
bridge-dialog-button-accept = Гаразд
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-type-selector-label = Тип проксі-сервера
# Tor advanced connection settings dialog.
# "address" is a noun, referring to an network IP address.
tor-advanced-dialog-proxy-address-input-label = Адреса
# Tor advanced settings.
# Button that opens the advanced connection settings dialog.
# Uses sentence case in English (US).
tor-advanced-settings-button = Налаштування…
tor-connection-quickstart-checkbox =
    .label = Завжди з'єднувати автоматично
bridge-qr-dialog-title =
    .title = Сканувати QR-код
built-in-dialog-title =
    .title = Обрати вбудований міст
built-in-dialog-snowflake-radio-option =
    .label = Snowflake
built-in-dialog-meek-azure-radio-option =
    .label = meek-azure
request-bridge-dialog-title =
    .title = Запит на міст
request-bridge-dialog-captcha-input =
    .placeholder = Введіть символи з зображення
tor-log-dialog-copy-button-copied =
    .label = Скопійовано!
tor-advanced-dialog-proxy-socks4-menuitem =
    .label = SOCKS4
tor-advanced-dialog-proxy-socks5-menuitem =
    .label = SOCKS5
tor-advanced-dialog-proxy-http-menuitem =
    .label = HTTP/HTTPS
tor-advanced-dialog-proxy-address-input =
    .placeholder = IP-адреса або ім'я хосту
tor-advanced-dialog-proxy-username-input =
    .placeholder = Додатково
tor-advanced-dialog-proxy-password-input =
    .placeholder = Додатково
tor-advanced-dialog-firewall-checkbox =
    .label = Мій брандмауер дозволяє під'єднання лише до певних портів
tor-advanced-dialog-firewall-ports-input =
    .placeholder = Значення, розділені комами
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input-label = Дозволені порти
# Tor advanced connection settings dialog.
tor-advanced-dialog-title =
    .title = Налаштування з'єднання
# Built-in bridges dialog.
# "obfs4" is a technical name, and likely should not be translated.
built-in-dialog-obfs4-radio-option =
    .label = obfs4
# Tor connection settings.
# Prefix before the Tor network connection status.
# Uses sentence case in English (US).
tor-connection-network-status-label = Мережа Tor:
downloads-tor-warning-title = Будьте обережні відкриваючи завантаження
downloads-tor-warning-description = Деякі файли можуть під'єднуватися до інтернету під час відкриття без використання Tor. Щоб бути в безпеці, відкривайте файли в офлайн-режимі або використовуйте портативну операційну систему, наприклад, <a data-l10n-name="tails-link">Tails</a>.
downloads-tor-warning-dismiss-button = Зрозуміло
rulesets-warning-heading = Дійте з обережністю
rulesets-warning-description = Додавання або зміна наборів правил може призвести до того, що зловмисники захоплять ваш браузер. Виконуйте ці дії лише, якщо ви знаєте, що робите.
rulesets-warning-checkbox = Попереджати мене, коли я намагаюся отримати доступ до цих налаштувань
rulesets-warning-continue-button = Погодитися на ризик і продовжити
rulesets-side-panel-heading = Набори правил
rulesets-side-panel-no-rules = Наборів правил не знайдено
rulesets-update-last = Востаннє оновлено { DATETIME($date, dateStyle: "long") }
rulesets-update-never = Не оновлювався, або минуле оновлення було невдалим
rulesets-update-rule-disabled = Вимкнено
rulesets-details-edit-button = Змінити
rulesets-details-enable-checkbox = Увімкнути цей набір правил
rulesets-details-update-button = Перевірити наявність оновлень
rulesets-details-save-button = Зберегти
rulesets-details-cancel-button = Скасувати
rulesets-details-jwk-input =
    .placeholder = Ключ, що використовується для підписання цього набору правил у форматі JWK (JSON Web Key)
rulesets-details-jwk-input-invalid = JWK не вдалося розібрати, або це не дійсний ключ
rulesets-details-path = Префікс шляху
rulesets-details-path-input =
    .placeholder = Префікс URL, який містить файли, необхідні для роботи набору правил
rulesets-details-path-input-invalid = Префікс шляху не є дійсною URL-адресою HTTP(S)
rulesets-details-scope = Сфера
rulesets-details-scope-input =
    .placeholder = Регулярний вираз для сфери дії правил
rulesets-details-scope-input-invalid = Сферу не розпізнано як регулярний вираз
onion-neterror-not-found-description = Найімовірніше, що сайт onion офлайн. Зв'яжіться з його адміністратором.
onion-neterror-unreachable-description = Сайт onion недоступний через внутрішню помилку.
onion-neterror-disconnected-description = Найімовірніше, що сайт onion поза мережею. Зв'яжіться з його адміністратором.
onion-neterror-connection-failed-description = Сайт onion зайнятий або мережа Tor перевантажена. Спробуйте пізніше.
onion-neterror-missing-authentication-description = Доступ до сайту onion вимагає ключ, який не був наданий.
onion-neterror-incorrect-authetication-description = Наданий ключ неправильний або відкликаний. Зв'яжіться з адміністратором сайту onion.
onion-neterror-invalid-address-description = Вказана адреса сайту onion недійсна. Перевірте, чи ви ввели її правильно.
onion-neterror-timed-out-description = Неможливо з'єднатися з сайтом onion, імовірно, через погане з'єднання з мережею.
# Tor connection settings.
# Shown when testing the internet status.
# Uses sentence case in English (US).
tor-connection-internet-status-testing = Тестування…
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-not-found-header = Сайт onion не знайдено
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-page-title = Проблема завантаження сайту onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-unreachable-header = Неможливо отримати доступ до сайту onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-connection-failed-header = Неможливо під'єднатися до сайту onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-missing-authentication-header = Сайт onion вимагає автентифікації
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-disconnected-header = Сайт onion від'єднався
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-authorization-title = Необхідна авторизація
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk = JWK
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
# "Circuit" refers to a Tor network circuit.
onion-neterror-timed-out-header = Час створення схеми onion-сайту минув
# Tor Bridges Settings.
tor-bridges-add-addresses-description = Введіть адресу відомого вам мосту
# Tor Bridges Settings.
# Shown when the user has no current bridges.
# Opens a dialog where the user can provide a new bridge address or share code.
tor-bridges-add-new-button = Додати нові мости…
# Tor Bridges Settings.
tor-bridges-find-more-heading = Шукати нові мости
# Tor Bridges Settings.
# Shown when the user has existing bridges.
# Opens a dialog where the user can provide a new bridge address or share code to replace their current bridges.
tor-bridges-replace-button = Замінити мости…
# Tor Bridges Settings.
# "Tor Project" is the organisation name.
tor-bridges-find-more-description = Позаяк адреси мостів не загальнодоступні, вам потрібно звернутися по них до проєкту Tor.
tor-view-log-button = Переглянути журнал…
tor-log-dialog-title =
    .title = Журнал Tor
tor-connection-overview = { -brand-short-name } направляє ваш трафік через мережу Tor, якою керують тисячі волонтерів по всьому світу.
tor-bridges-request-button = Запит на мости…
tor-bridges-provider-web-instruction = Відвідати <a data-l10n-name="url">{ $url }</a>
tor-bridges-request-from-browser = Ви також можете отримати мости від бота, не виходячи з { -brand-short-name }.
onion-neterror-invalid-address-header = Недійсна адреса сайту onion
tor-connection-settings-category =
    .tooltiptext = { tor-connection-settings-heading }
onion-neterror-incorrect-authentication-header = Не вдалося автентифікувати onion-сайт
tor-view-log-description = Переглянути журнал Tor.
tor-connection-quickstart-description = Quickstart автоматично під'єднує { -brand-short-name } до мережі Tor під час запуску на основі останніх використовуваних налаштувань з'єднання.
built-in-dialog-introduction = { -brand-short-name } включає деякі особливі типи мостів, відомі як "додаткові передавачі", які можуть допомогти приховати факт користування Tor.
onion-site-authentication-prompt-learn-more = Докладніше
onion-site-authentication-prompt-remember-checkbox =
    .label = Запам'ятати цей ключ
onion-site-authentication-prompt-invalid-key = Введіть дійсний ключ (52 символи base32 або 44 символи base64)
onion-site-authentication-prompt-setting-key-failed = Неможливо налаштувати Tor з вашим ключем
onion-site-authentication-preferences-learn-more = Докладніше
onion-site-saved-keys-dialog-table-header-key =
    .label = Ключ
onion-site-saved-keys-dialog-remove-button = Вилучити
onion-site-saved-keys-dialog-remove-keys-error-message = Неможливо вилучити ключ
onion-site-saved-keys-dialog-title =
    .title = Ключі onion-сайту
onion-site-authentication-preferences-saved-keys-button = Збережені ключі…
onion-site-saved-keys-dialog-fetch-keys-error-message = Неможливо отримати ключі з Tor
page-info-onion-site-encryption-plain = З'єднання зашифроване (сайт Onion)
onion-site-authentication-preferences-overview = Деякі служби onion вимагають ідентифікувати себе за допомогою ключа (своєрідного пароля), перш ніж отримати до них доступ.
onion-site-saved-keys-dialog-remove-all-button = Вилучити всі
onion-site-authentication-prompt-cancel-button =
    .label = Скасувати
    .accesskey = С
onion-site-authentication-prompt-ok-button =
    .label = OK
    .accesskey = O
downloads-tor-warning-message-bar =
    .heading = Будьте обережні відкриваючи завантаження
    .message = Деякі файли можуть під'єднуватися до інтернету під час відкриття без використання Tor. Щоб бути в безпеці, відкривайте файли в офлайн-режимі або використовуйте портативну операційну систему, наприклад, Tails.
downloads-tor-warning-tails-link = Докладніше про Tails
tor-bridges-source-requested = Запитано від Tor
tor-bridges-lox-days-until-unlock =
    { $numDays ->
        [one] { $numDays } день до розблокування:
       *[other] { $numDays } днів до розблокування:
    }
tor-bridges-source-lox = Перепустка до мостів
tor-bridges-lox-description = За допомогою bridge pass bridge-бот надішле вам нові мости, коли ваші мости будуть заблоковані. Якщо ваші мости не заблоковано, ви розблокуєте запрошення, які дозволять вам ділитися мостами з довіреними контактами.
user-provide-bridge-dialog-add-title =
    .title = Додати нові мости
tor-bridges-lox-unlock-more-invites = Більше запрошень для ваших довірених контактів
tor-bridges-lox-blocked = Ваші заблоковані мости замінено
user-provide-bridge-dialog-textarea-addresses =
    .placeholder = Вставте сюди свої адреси мостів
user-provide-bridge-dialog-address-error = Неправильно відформатована адреса мосту в рядку { $line }.
user-provide-bridge-dialog-mixed-error = Не можна змішувати адреси міст із запрошенням.
user-provide-bridge-dialog-no-server-error = Не вдається під'єднатися до сервера пропуску до мостів.
tor-bridges-lox-unlock-two-bridges = +2 мости від мостового бота
tor-bridges-lox-upgrade = Ваш пропуск на міст оновлено!
tor-bridges-select-built-in-description = Виберіть один із вбудованих мостів { -brand-short-name }
user-provide-bridge-dialog-textarea-addresses-or-invite-label = Адреси мостів або запрошення
tor-bridges-lox-unlock-first-invites = Запрошення для ваших довірених контактів
tor-bridges-lox-show-invites-button = Показати запрошення
tor-bridges-lox-remaining-invites =
    { $numInvites ->
        [one] { $numInvites } Залишилося запрошення
       *[other] { $numInvites } Залишається запрошення
    }
tor-bridges-lox-new-bridges = Нові мости від бота bridge
tor-bridges-lox-new-invites =
    { $numInvites ->
        [one] Тепер у вас залишилося{ $numInvites } запрошення для ваших довірених контактів
       *[other] Тепер у вас залишилося { $numInvites } запрошень для ваших довірених контактів
    }
user-provide-bridge-dialog-description = Використовуйте мости, надані перевіреною організацією або кимось, кого ви знаєте.
user-provide-bridge-dialog-textarea-addresses-or-invite =
    .placeholder = Вставте сюди свої адреси мосту або запрошення на пропуск
user-provide-bridge-dialog-edit-title =
    .title = Редагувати свої мости
tor-bridges-lox-gained-two-bridges = +2 мости від мостового бота
user-provide-bridge-dialog-replace-title =
    .title = Замініть ваші мости
user-provide-bridge-dialog-multiple-invites-error = Не можна додати більше одного запрошення.
user-provide-bridge-dialog-invite-not-allowed-error = Неможливо включити запрошення на перепустку.
user-provide-bridge-dialog-generic-invite-error = Не вдалося активувати запрошення.
user-provide-bridge-dialog-bad-invite-error = Запрошення не прийнято. Спробуйте інше.
onion-site-saved-keys-dialog-intro = Наступні ключі сайту onion зберігаються на вашому комп’ютері.
tor-log-dialog-copy-button =
    .label = Копіювати журнал Tor до буфера обміну
tor-advanced-settings-description = Налаштуйте спосіб під'єднання { -brand-short-name } до Інтернету.
tor-advanced-dialog-introduction = Налаштуйте спосіб під'єднання { -brand-short-name } до Інтернету.
rulesets-side-panel-no-rules-description = Коли ви збережете набір правил у { -brand-short-name }, він з’явиться тут.
onion-site-authentication-preferences-heading = Аутентифікація onion-сайту
user-provide-bridge-dialog-result-invite = З вами поділилися наступними мостами.
user-provide-bridge-dialog-result-addresses = Наступні мости були введені вами.
built-in-dialog-current-bridge-label = Нинішній міст
    .aria-label = Поточний міст.
onion-site-authentication-urlbar-button =
    .tooltiptext = Відкрити панель автентифікації сайту onion
tor-advanced-dialog-proxy-checkbox =
    .label = Я використовую проксі для під'єднання до Інтернету
onion-site-authentication-prompt-key-input =
    .placeholder = Введіть свій закритий ключ для цього сайту
page-info-onion-site-encryption-with-bits = З’єднання зашифровано (сайт Onion, { $encryption-type }, { NUMBER($encryption-strength, useGrouping: "false") } бітових ключів, { $encryption-version })
dropped-support-notification-win-os-version-less-than-10-extended-13-5 = { -brand-short-name } 13.5 отримуватиме оновлення безпеки лише протягом обмеженого часу. Оновіть до Windows 10 або новішої версії, щоб отримати останню версію { -brand-short-name }.
user-provide-bridge-dialog-connecting = Під'єднання до сервера пропуску до мостів…
user-provide-bridge-dialog-next-button =
    .label = Далі
onion-site-authentication-prompt-description = Сайт onion { $onionsite } просить вас пройти автентифікацію.
onion-site-saved-keys-dialog-table-header-site =
    .label = Onion-cайт
dropped-support-notification-macos-version-less-than-10-15-extended-13-5 = { -brand-short-name } 13.5 отримуватиме оновлення безпеки лише протягом обмеженого часу. Оновіть macOS до 10.15 або новішої версії, щоб отримати останню версію { -brand-short-name }.
tor-connection-internet-status-unknown = Невідомий стан
tor-log-dialog-table =
    .aria-label = { tor-log-dialog-title.title }
tor-connection-automatic-heading = Автоматичне під'єднання
tor-connection-automatic-description = Автоматично під'єднуйтеся до мережі Tor під час запуску, використовуючи ваші поточні налаштування з'єднання.
tor-settings-failed-notification-cause-proxy = Причиною може бути недійсна інформація проксі.
tor-settings-failed-notification-cause-firewall = Це може бути через недійсну інформацію брандмауера.
tor-settings-failed-notification-body-default = Доки це не буде виправлено, ваше з’єднання Tor продовжуватиме використовувати налаштування за замовчуванням. Ви можете очистити проблемні налаштування, щоб відновити їх за замовчуванням, або перевірити журнал Tor, щоб знайти та розв'язати проблему самостійно.
tor-settings-failed-notification-button-undo = Скасувати зміни
tor-settings-failed-notification-button-clear = Очистити
tor-settings-failed-notification-button-fix-myself = Виправити себе
tor-settings-failed-notification-title-firewall = Не вдалося застосувати ваші налаштування брандмауера Tor
tor-settings-failed-notification-title-bridges = Не вдалося застосувати налаштування мосту Tor
tor-settings-failed-notification-cause-bridges = Це може бути через недійсну адресу мосту.
tor-settings-failed-notification-title-proxy = Не вдалося застосувати ваші налаштування проксі-сервера Tor
tor-settings-failed-notification-body-undo = До усунення проблеми ваше Tor-з'єднання продовжуватиме використовувати попередні налаштування. Ви можете або скасувати останні зміни, щоб відновити попередні робочі налаштування, або переглянути журнал Tor, щоб знайти та виправити проблему самостійно.
bridge-dialog-button-connect2 =
    .label = Під'єднатися
bridge-dialog-button-accept2 =
    .label = Гаразд
bridge-dialog-button-submit2 =
    .label = Надіслати
tor-bridges-built-in-meek-description = Під'єднує вас до мережі Tor через великого хмарного провайдера. Може працювати в регіонах із сильною цензурою, але зазвичай дуже повільно.
built-in-dialog-obfs4-radio-option2 =
    .label = { tor-bridges-built-in-obfs4-name }
built-in-dialog-snowflake-radio-option2 =
    .label = { tor-bridges-built-in-snowflake-name }
built-in-dialog-meek-radio-option2 =
    .label = { tor-bridges-built-in-meek-name }
tor-bridges-built-in-meek-name = meek
yec-donate-button = Пожертвувати зараз
yec-close-button =
    .title = Закрити
yec2025-title = Звільніть інтернет
yec2025-body = Підтримайте інструменти, які розривають ланцюги цензури та стеження. <b data-l10n-name="highlight">Зробіть пожертву проєкту Tor сьогодні.</b>
yec2025-matching = До 31 грудня ваш подарунок буде подвоєно, до 250 000 доларів!
