# Tor browser manual link shown in the menu bar.
# Uses Title case.
menu-open-tor-manual =
    .label = Manual do Navegador Tor
    .accesskey = M
tor-browser-home-heading-stable = Explore. Com privacidade.
tor-browser-home-heading-testing = Teste. Completamente.
tor-browser-home-duck-duck-go-input =
    .placeholder = Pesquisar com DuckDuckGo
tor-browser-home-message-introduction = Você está pronto para a maior experiência de navegação privada do mundo.
# Shown in Home settings, corresponds to the default about:tor home page.
home-mode-choice-tor =
    .label = Início do Navegador Tor
# Tor Browser home page.
tor-browser-home-message-donate = O uso do Tor é gratuito devido a doações de pessoas como você. <a data-l10n-name="donate-link">Fazer doação</a>
# Tor Browser home page.
# Update message.
# <a data-l10n-name="update-link"> should contain the link text and close with </a>.
# $version (String) - The new tor browser version.
tor-browser-home-message-updated = O navegador Tor foi atualizado para { $version }. <a data-l10n-name="update-link">Veja as novidades</a>
# Tor Browser home page.
tor-browser-home-message-testing = Esta é uma versão instável do navegador Tor para testar novos recursos. <a data-l10n-name="learn-more-link">Saber mais</a>
# Tor Browser home page.
tor-browser-home-message-news = Receba as últimas notícias do Tor diretamente na sua caixa de entrada. <a data-l10n-name="news-link">Inscreva-se para receber notícias do Tor</a>
# Tor browser manual link shown in the application menu (aka: hamburger menu).
# Uses Sentence case.
appmenu-open-tor-manual =
    .label = Manual do Navegador Tor Browser
    .accesskey = m
# Tor Browser home page.
# Only shown when underlying Tor process was not started by Tor Browser.
# "Tails" refers to the operating system, and should be translated as a brand name.
# <a data-l10n-name="tor-check-link"> should contain the link text and close with </a>.
tor-browser-home-tor-check-warning = Sua conexão com o Tor não está sendo gerenciada pelo Tor Browser. Alguns sistemas operacionais (como Tails) irão gerenciar isso para você, ou você pode ter definido uma configuração personalizada. <a data-l10n-name="tor-check-link">Testar sua conexão</a>
# Tor Browser home page.
# Toggle to switch from DuckDuckGo's plain ".com" domain to its ".onion" domain.
tor-browser-home-onionize-toggle =
    .label = Onionize
    .title = Pesquise usando o site onion
# Tor Bridges Settings
# Toggle button for enabling and disabling the use of bridges.
tor-bridges-use-bridges =
    .label = Usar pontes
# Tor Bridges Settings
tor-bridges-none-added = Nenhuma ponte adicionada
# Tor Bridges Settings
tor-bridges-your-bridges = Suas pontes
# Tor Bridges Settings
tor-bridges-source-user = Adicionado por você
# Tor Bridges Settings
tor-bridges-source-built-in = Integrada
# Tor Bridges Settings
tor-bridges-source-requested = Solicitado pelo Tor
# Tor Bridges Settings
# Here "Bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# This is shown when the user is getting their bridges from Lox.
tor-bridges-source-lox = Código da ponte
# Tor Bridges Settings
# The "..." menu button for all current bridges.
tor-bridges-options-button =
    .title = Todas as pontes
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can generate a QR code for all of their bridges.
tor-bridges-menu-item-qr-all-bridge-addresses = Mostrar código QR
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can copy all of their bridges.
tor-bridges-menu-item-copy-all-bridge-addresses = Copiar endereços da ponte
    .accesskey = C
# Tor Bridges Settings
# Only shown in the "..." menu for bridges added by the user.
tor-bridges-menu-item-edit-all-bridges = Editar pontes
    .accesskey = E
# Tor Bridges Settings
# Shown in the "..." menu for all current bridges.
tor-bridges-menu-item-remove-all-bridges = Remova todas as pontes
    .accesskey = R
# Tor Bridges Settings
# Shown when one of the built-in bridges is in use.
tor-bridges-built-in-status-connected = Conectado
# Tor Bridges Settings
# Shown at the start of a Tor bridge line.
# $type (String) - The Tor bridge type ("snowflake", "obfs4", "meek-azure").
tor-bridges-type-prefix = { $type } ponte:
# Tor Bridges Settings
# Shown at the start of a Tor bridge line, when the transport type is unknown (or "vanilla").
tor-bridges-type-prefix-generic = Ponte Tor:
# Tor Bridges Settings
# Used for an image of a bridge emoji. Each bridge address can be hashed into four emojis shown to the user (bridgemoji feature). This string corresponds to a *single* such emoji. The "title" should just be emojiName. The "alt" should let screen readers know that the image is of a *single* emoji, as well as its name.
# $emojiName (String) - The name of the emoji, already localized.
tor-bridges-emoji-image =
    .alt = Emoji: { $emojiName }
    .title = { $emojiName }
# Tor Bridges Settings
# The emoji name to show on hover when a bridge emoji's name is unknown.
tor-bridges-emoji-unknown = Desconhecido
# Tor Bridges Settings
# Shown when the bridge has been used for the most recent Tor circuit, i.e. the most recent bridge we have connected to.
tor-bridges-status-connected = Conectado
# Tor Bridges Settings
# Used when the bridge has no status, i.e. the *absence* of a status to report to the user. This is only visibly shown when the status cell has keyboard focus.
tor-bridges-status-none = Sem status
# Tor Bridges Settings
# The "..." menu button for an individual bridge row.
tor-bridges-individual-bridge-options-button =
    .title = Opções de ponte
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Shows the QR code for this one bridge.
tor-bridges-menu-item-qr-address = Mostrar código QR
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Copies the single bridge address to clipboard.
tor-bridges-menu-item-copy-address = Copiar endereço da ponte
    .accesskey = C
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Removes this one bridge.
tor-bridges-menu-item-remove-bridge = Remover ponte
    .accesskey = R
# Tor Bridges Settings
# Update text for screen reader users when all of their bridges have been removed.
tor-bridges-update-removed-all-bridges = Todas as suas pontes Tor foram removidas.
# Tor Bridges Settings
# Text shown just before a description of the most recent change to the list of user's bridges. Some white space will separate this text from the change description.
# This text is not visible, but is instead used for screen reader users.
# E.g. in English this could be "Recent update: One of your Tor bridges has been removed."
tor-bridges-update-area-intro = Atualização recente:
# Tor Bridges Settings
# Update text for screen reader users when only one of their bridges has been removed.
tor-bridges-update-removed-one-bridge = Uma de suas pontes Tor foi removida.
# Tor Bridges Settings
# Update text for screen reader users when their bridges have changed in some arbitrary way.
tor-bridges-update-changed-bridges = Suas pontes Tor mudaram.
# Tor Bridges Settings
# Shown for requested bridges and bridges added by the user.
tor-bridges-share-heading = Ajude outras pessoas a se conectar
# Tor Bridges Settings
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-show-invites-button = Mostrar convites
# Tor Bridges Settings
tor-bridges-select-built-in-button = Selecione uma ponte integrada…
# Tor Bridges Settings
# Shown as a heading when the user has no current bridges.
tor-bridges-add-bridges-heading = Adicionar pontes
# Built-in bridges dialog.
# Label attached to the built-in bridge option that is already in use.
# The "aria-label" should use the same text, but include some ending punctuation to separate it from the sentence that follows. This is used for screen reader users.
built-in-dialog-current-bridge-label = Ponte atual
    .aria-label = Ponte atual.
# Tor Bridges Settings
tor-bridges-share-description = Compartilhe suas pontes com contatos de confiança.
# Tor Bridges Settings
tor-bridges-copy-addresses-button = Copiar endereços
# Tor Bridges Settings
tor-bridges-qr-addresses-button =
    .title = Mostrar código QR
# Tor Bridges Settings
# The number of days until the user's "bridge pass" is upgraded.
# $numDays (Number) - The number of days until the next upgrade, an integer (1 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numDays". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numDays is "1" (singular) and the second form will be used if $numDays is anything else (plural).
tor-bridges-lox-days-until-unlock =
    { $numDays ->
        [one] { $numDays } dia até você desbloquear:
       *[other] { $numDays } dias até você desbloquear:
    }
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain access to invites for the first time.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-first-invites = Convites para seus contatos de confiança
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user already has invites.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-more-invites = Mais convites para seus contatos confiáveis
# Tor Bridges Settings
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-remaining-invites =
    { $numInvites ->
        [one] { $numInvites } convite restante
       *[other] { $numInvites } convites restantes
    }
# Tor Bridges Settings
# Shown when the user's "bridge pass" has been upgraded.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
tor-bridges-lox-upgrade = Seu código de ponte foi atualizado!
# Tor Bridges Settings
# Shown when the user's bridges accessed through "bridge pass" have been blocked.
tor-bridges-lox-blocked = Suas pontes bloqueadas foram substituídas
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain two more bridges in the future.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-unlock-two-bridges = +2 pontes no bot de ponte
# Tor Bridges Settings
# Shown *after* the user has had their blocked bridges replaced.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-new-bridges = Novas pontes no bot de ponte
# Tor Bridges Settings
# Shown *after* the user has gained two more bridges.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-gained-two-bridges = +2 pontes no bot de ponte
# Tor Bridges Settings
# Button for the user to acknowledge a change in their "bridge pass".
tor-bridges-lox-got-it-button = Entendi
# Tor Bridges Settings
# Shown as a heading when the user has existing bridges that can be replaced.
tor-bridges-replace-bridges-heading = Substituir suas pontes
# Tor Bridges Settings
tor-bridges-select-built-in-description = Escolha uma das pontes integradas de { -brand-short-name }
# Tor Bridges Settings
tor-bridges-add-addresses-description = Insira os endereços das pontes que você já conhece
# Tor Bridges Settings
# Shown when the user has no current bridges.
# Opens a dialog where the user can provide a new bridge address or share code.
tor-bridges-add-new-button = Adicionar novas pontes…
# Tor Bridges Settings
# Shown when the user has existing bridges.
# Opens a dialog where the user can provide a new bridge address or share code to replace their current bridges.
tor-bridges-replace-button = Substituir pontes…
# Tor Bridges Settings
tor-bridges-find-more-heading = Encontrar mais pontes
# Tor Bridges Settings
# "Tor Project" is the organisation name.
tor-bridges-find-more-description = Como muitos endereços de ponte não são públicos, pode ser necessário solicitar alguns ao Projeto Tor.
# Tor Bridges Settings
# Here "Message" is a verb, short for "Send a message to". This is an instruction to send a message to the given Telegram Messenger user to receive a new bridge.
# $telegramUserName (String) - The Telegram Messenger user name that should receive messages. Should be wrapped in '<a data-l10n-name="user">' and '</a>'.
# E.g. in English, "Message GetBridgesBot".
tor-bridges-provider-telegram-instruction = Mensagem <a data-l10n-name="user">{ $telegramUserName }</a>
# Tor Bridges Settings
# Instructions to visit the given website.
# $url (String) - The URL for Tor Project bridges. Should be wrapped in '<a data-l10n-name"url">' and '</a>'.
tor-bridges-provider-web-instruction = Acessar <a data-l10n-name="url">{ $url }</a>
# Tor Bridges Settings
# Here "Email" is a verb, short for "Send an email to". This is an instruction to send an email to the given address to receive a new bridge.
# $address (String) - The email address that should receive the email.
# E.g. in English, "Email bridges@torproject.org".
tor-bridges-provider-email-instruction = Email { $address }
# Tor Bridges Settings
tor-bridges-request-from-browser = Você também pode obter pontes no bot de ponte sem sair de { -brand-short-name }.
# Tor Bridges Settings
tor-bridges-request-button = Solicitar pontes…
# User provided bridge dialog.
# Used when the user is editing their existing bridge addresses.
user-provide-bridge-dialog-edit-title =
    .title = Editar suas pontes
# User provided bridge dialog.
# Used when the user has no existing bridges.
user-provide-bridge-dialog-add-title =
    .title = Adicionar novas pontes
# User provided bridge dialog.
# Used when the user is replacing their existing bridges with new ones.
user-provide-bridge-dialog-replace-title =
    .title = Substituir suas pontes
# User provided bridge dialog.
# Description shown when adding new bridges, replacing existing bridges, or editing existing bridges.
user-provide-bridge-dialog-description = Usar pontes fornecidas por uma organização confiável ou alguém que você conhece.
# User provided bridge dialog.
# Here "invite" is a noun, short for "invitation".
# Short accessible name for text area when it can accept either bridge address or a single "bridge pass" invite.
user-provide-bridge-dialog-textarea-addresses-or-invite-label = Endereços da ponte ou convite
# User provided bridge dialog.
# Placeholder shown when adding new bridge addresses.
user-provide-bridge-dialog-textarea-addresses =
    .placeholder = Colar os endereços da sua ponte aqui
# User provided bridge dialog.
# Error shown when one of the address lines is invalid.
# $line (Number) - The line number for the invalid address.
user-provide-bridge-dialog-address-error = Endereço da ponte formatado incorretamente na linha { $line }.
# User provided bridge dialog.
# Placeholder shown when the user can add new bridge addresses or a single "bridge pass" invite.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
# NOTE: "invite" is singular, whilst "addresses" is plural.
user-provide-bridge-dialog-textarea-addresses-or-invite =
    .placeholder = Colar os endereços da sua ponte ou um código de convite para acessar a ponte aqui
# User provided bridge dialog.
# Error shown when the user has entered more than one "bridge pass" invite.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-multiple-invites-error = Não é possível incluir mais de um convite.
# User provided bridge dialog.
# Error shown when the user has mixed their invite with addresses.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-mixed-error = Não é possível misturar endereços da ponte com um convite.
# User provided bridge dialog.
# Error shown when the user has entered an invite when it is not supported.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
user-provide-bridge-dialog-invite-not-allowed-error = Não é possível incluir o código de convite para a ponte.
# User provided bridge dialog.
# Error shown when the invite was not accepted by the server.
user-provide-bridge-dialog-bad-invite-error = O convite não foi aceito. Experimente um diferente.
# User provided bridge dialog.
# Error shown when the "bridge pass" server does not respond.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-no-server-error = Não é possível conectar-se ao servidor da ponte com esse código.
# User provided bridge dialog.
# Shown after the user has entered a "bridge pass" invite.
user-provide-bridge-dialog-result-invite = As seguintes pontes foram compartilhadas com você.
# User provided bridge dialog.
# Shown after the user has entered bridge addresses.
user-provide-bridge-dialog-result-addresses = As seguintes pontes foram inseridas por você.
# User provided bridge dialog.
# Generic error when an invite failed.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-generic-invite-error = Falha ao resgatar o convite.
# User provided bridge dialog.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-connecting = Conectando ao servidor da ponte com o código…
# User provided bridge dialog.
user-provide-bridge-dialog-next-button =
    .label = Próximo
# Tor Bridges Settings
# Shown when using a "bridge pass", i.e. using Lox.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-description = Com um código de ponte, o bot da ponte enviará novas pontes quando suas pontes forem bloqueadas. Se suas pontes não forem bloqueadas, você desbloqueará convites que permitem compartilhar pontes com contatos de confiança.
# Tor Bridges Settings
# Shown *after* a user's "bridge pass" has changed.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-new-invites =
    { $numInvites ->
        [one] Agora você tem { $numInvites } convite restante para seus contatos de confiança
       *[other] Agora você tem { $numInvites } convites restantes para seus contatos de confiança
    }
# Tor Bridges Settings
# "Telegram" is the common brand name of the Telegram Messenger application
tor-bridges-provider-telegram-name = Telegram
# Tor Bridges Settings
# "Gmail" is the Google brand name. "Riseup" refers to the Riseup organisation at riseup.net.
tor-bridges-provider-email-name = Gmail ou Riseup
# User provided bridge dialog.
# Short accessible name for the bridge addresses text area.
user-provide-bridge-dialog-textarea-addresses-label = Endereços da ponte
# User provided bridge dialog.
# "Learn more" link shown in the "Add new bridges"/"Replace your bridges" dialog.
user-provide-bridge-dialog-learn-more = Saiba mais
# Tor Bridges Settings
# "Web" is the proper noun for the "World Wide Web".
tor-bridges-provider-web-name = Web
about-dialog-tor-project = { -brand-short-name } foi programada por <label data-l10n-name="project-link">o/a { -vendor-short-name }</label>, uma organização sem fins lucrativos para defender a sua privacidade e liberdade na internet.
about-dialog-help-out = Você gostaria de ajudar? <label data-l10n-name="donate-link">Doar</label> ou <label data-l10n-name="community-link">envolver-se</label>!
about-dialog-questions-link = Perguntas?
about-dialog-grow-tor-network-link = Ajude a rede Tor a crescer!
about-dialog-browser-license-link = Informações de licenciamento
menu-new-tor-circuit =
    .label = Novo Circuito Tor para este Site
    .accesskey = C
appmenuitem-new-tor-circuit =
    .label = Novo Circuito Tor para este Site
toolbar-new-tor-circuit =
    .label = Novo Circuito Tor para este Site
    .tooltiptext = { toolbar-new-tor-circuit.label }
tor-circuit-urlbar-button =
    .tooltiptext = Circuito Tor
tor-circuit-panel-heading = Circuito para { $host }
tor-circuit-panel-alias = Conectado à <a data-l10n-name="alias-link">{ $alias }</a>
tor-circuit-panel-node-list-introduction = Circuito Tor
tor-circuit-panel-node-browser = Este navegador
tor-circuit-panel-node-onion-relays = Relés do site Onion
tor-circuit-panel-node-typed-bridge = Ponte: { $bridge-type }
tor-circuit-panel-node-bridge = Ponte
tor-circuit-panel-node-region-guard = { $region } (guarda)
tor-circuit-panel-node-unknown-region = Região desconhecida
tor-circuit-panel-new-button = Novo Circuito Tor para este Site
tor-circuit-panel-new-button-description-guard = O seu nó de guarda não pode ser alterado
tor-circuit-panel-new-button-description-bridge = Sua ponte não pode ser trocada
crypto-safety-prompt-title = Endereço de criptomoeda copiado de um site inseguro
crypto-safety-prompt-body = O texto copiado ({ $address }) parece ser um endereço de criptomoeda. Como a conexão com { $host } não é segura, o endereço pode ter sido modificado e não deve ser confiável. Você pode tentar estabelecer uma conexão segura reconectando-se com um novo circuito.
crypto-safety-prompt-reload-button = Recarregar guia com um novo circuito
crypto-safety-prompt-dismiss-button = Ignorar aviso
# Built-in bridges dialog.
request-bridge-dialog-captcha-failed = A solução não está correta. Por favor, tente novamente.
# Tor connection settings.
# Shown when the user is not connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-offline = Offline
# Tor Bridges Settings.
# "obfs4" is a technical name, and likely should not be translated.
tor-bridges-built-in-obfs4-name = obfs4
# Tor Bridges Settings.
tor-bridges-heading = Pontes
# Tor connection settings.
tor-connection-browser-learn-more-link = Saiba mais
# Tor Bridges Settings.
tor-bridges-built-in-obfs4-description = Faz seu tráfego Tor parecer com dados aleatórios. Pode não funcionar em regiões fortemente censuradas.
# Tor connection settings.
# "Connection" refers to the Tor Browser's connection to the Tor network.
tor-connection-settings-heading = Conexão
# Tor connection settings.
# Prefix before the internet connection status.
# "Internet" is not a proper noun, but is capitalized because it is the start of a sentence.
tor-connection-internet-status-label = Internet:
# Tor connection settings.
# Button to test the internet connection.
# Here "Test" is a verb, as in "test the internet connection".
# Uses sentence case in English (US).
tor-connection-internet-status-test-button = Testar
# Tor connection settings.
# Shown when the user is connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-online = Online
# Tor connection settings.
# Shown when the user is connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connected = Conectado
# Tor connection settings.
# Shown when the user is not connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-not-connected = Não conectado
# Tor connection settings.
# Shown when the user's Tor connection may be blocked.
# Uses sentence case in English (US).
tor-connection-network-status-blocked = Potencialmente bloqueado
# Tor connection settings.
# Button shown when we are not yet connected to the Tor network.
# It will open a page to start connecting to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connect-button = Conectar
# Tor Bridges Settings.
tor-bridges-overview = As pontes ajudam você a acessar a rede Tor com segurança em locais onde ela está bloqueada. Dependendo de onde você estiver, uma ponte pode funcionar melhor que outra.
# Tor Bridges Settings.
tor-bridges-learn-more-link = Saiba mais
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-name = Snowflake
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-description = Roteia sua conexão através de proxies Snowflake para fazer parecer que você está em uma videochamada, por exemplo.
# Tor Bridges Settings.
tor-bridges-built-in-meek-azure-description = Faz parecer que você está conectado a um site da Microsoft, em vez de usar o Tor. Pode funcionar em regiões fortemente censuradas, mas geralmente é muito lento.
# Warning dialog when removing all bridges.
remove-all-bridges-warning-remove-button = Remover
# Common button used in bridge dialogs.
bridge-dialog-button-connect = Conectar
# Common button used in bridge dialogs.
bridge-dialog-button-accept = OK
# Common button used in bridge dialogs.
bridge-dialog-button-submit = Enviar
# Tor advanced settings.
tor-advanced-settings-heading = Avançado
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-type-selector-label = Tipo de proxy
# Tor advanced connection settings dialog.
# "address" is a noun, referring to an network IP address.
tor-advanced-dialog-proxy-address-input-label = Endereço
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-port-input-label = Porta
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input-label = Nome de usuário
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input-label = Senha
# Tor connection settings.
tor-connection-quickstart-heading = Inicio rápido
# Tor Bridges Settings.
# "meek-azure" is a technical name, and likely should not be translated.
tor-bridges-built-in-meek-azure-name = meek-azure
# Warning dialog when removing all bridges.
remove-all-bridges-warning-title = Remover todas as pontes?
# Warning dialog when removing all bridges.
remove-all-bridges-warning-description = Se estas pontes foram recebidas de torproject.org ou adicionadas manualmente, esta ação não pode ser desfeita
# Built-in bridges dialog.
request-bridge-dialog-top-wait = Entrando em contato com o BridgeDB. Por favor, espere.
# Built-in bridges dialog.
request-bridge-dialog-top-solve = Resolva o CAPTCHA para solicitar uma ponte.
# Tor advanced settings.
# Button that opens the advanced connection settings dialog.
# Uses sentence case in English (US).
tor-advanced-settings-button = Configurações…
tor-connection-quickstart-checkbox =
    .label = Sempre conectar automaticamente
bridge-qr-dialog-title =
    .title = Digitalizar código QR
built-in-dialog-title =
    .title = Selecione uma ponte integrada
built-in-dialog-snowflake-radio-option =
    .label = Snowflake
built-in-dialog-meek-azure-radio-option =
    .label = meek-azure
request-bridge-dialog-title =
    .title = Ponte de solicitação
request-bridge-dialog-captcha-input =
    .placeholder = Digite os caracteres que aparecem na imagem
tor-log-dialog-copy-button-copied =
    .label = Copiado!
tor-advanced-dialog-proxy-socks4-menuitem =
    .label = SOCKS4
tor-advanced-dialog-proxy-socks5-menuitem =
    .label = SOCKS5
tor-advanced-dialog-proxy-http-menuitem =
    .label = HTTP/HTTPS
tor-advanced-dialog-proxy-address-input =
    .placeholder = Endereço IP ou Servidor
tor-advanced-dialog-proxy-username-input =
    .placeholder = Opcional
tor-advanced-dialog-proxy-password-input =
    .placeholder = Opcional
tor-advanced-dialog-firewall-checkbox =
    .label = A conexão de internet deste computador é filtrada por uma firewall que autoriza conexões somente a determinadas portas
tor-advanced-dialog-firewall-ports-input =
    .placeholder = Valores separados por vírgula
downloads-tor-warning-title = Tenha cuidado ao abrir downloads
downloads-tor-warning-description = Alguns arquivos podem conectar-se à Internet quando abertos sem utilizar o Tor. Por segurança, abra os arquivos quando estiver offline ou utilize um sistema operacional portátil como <a data-l10n-name="tails-link">Tails</a>.
downloads-tor-warning-dismiss-button = Entendi
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-view-log-description = Veja o registro do Tor.
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
# Uses sentence case in English (US).
tor-view-log-button = Ver registro…
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-overview = { -brand-short-name } roteia seu tráfego pela rede Tor, administrada por milhares de voluntários em todo o mundo.
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-quickstart-description = O Quickstart conecta { -brand-short-name } à rede Tor automaticamente quando iniciado, com base nas últimas configurações de conexão usadas.
# Built-in bridges dialog.
# "obfs4" is a technical name, and likely should not be translated.
built-in-dialog-obfs4-radio-option =
    .label = obfs4
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-copy-button =
    .label = Copiar registros do Tor para a área de transferência
# Tor advanced connection settings dialog.
tor-advanced-dialog-title =
    .title = Configurações de conexão
# Tor advanced connection settings dialog.
tor-advanced-dialog-introduction = Configure como { -brand-short-name } se conecta à Internet.
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-checkbox =
    .label = Eu uso um proxy para me conectar à internet
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input-label = Portas permitidas
# Tor connection settings.
# Prefix before the Tor network connection status.
# Uses sentence case in English (US).
tor-connection-network-status-label = Rede Tor:
# Built-in bridges dialog.
# -brand-short-name refers to 'Tor Browser', localized.
built-in-dialog-introduction = { -brand-short-name } inclui alguns tipos específicos de pontes conhecidas como “transportes conectáveis”, que podem ajudar a esconder o fato de que você está usando o Tor.
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-title =
    .title = Registro do Tor
# Tor advanced settings.
tor-advanced-settings-description = Configure como { -brand-short-name } se conecta à Internet.
rulesets-warning-heading = Prossiga com cuidado
rulesets-warning-description = Adicionar ou modificar conjuntos de regras pode fazer com que invasores invadam seu navegador. Prossiga somente se você souber o que está fazendo.
rulesets-warning-checkbox = Avise-me quando tentar acessar essas preferências
rulesets-warning-continue-button = Aceite o risco e continue
rulesets-side-panel-heading = Conjuntos de regras
rulesets-side-panel-no-rules = Nenhum conjunto de regras encontrado
rulesets-update-last = Ultima atualização { DATETIME($date, dateStyle: "long") }
rulesets-update-never = Desatualizado ou a última atualização falhou
rulesets-update-rule-disabled = Desativado
rulesets-details-edit-button = Editar
rulesets-details-enable-checkbox = Ativar este conjunto de regras
rulesets-details-update-button = Buscar atualizações
rulesets-details-save-button = Salvar
rulesets-details-cancel-button = Cancelar
rulesets-details-jwk-input =
    .placeholder = A chave usada para assinar este conjunto de regras no formato JWK (JSON Web Key)
rulesets-details-jwk-input-invalid = O JWK não pôde ser analisado ou não é uma chave válida
rulesets-details-path = Prefixo do caminho
rulesets-details-path-input =
    .placeholder = Prefixo de URL que contém os arquivos necessários para o conjunto de regras
rulesets-details-path-input-invalid = O prefixo do caminho não é um URL HTTP(S) válido
rulesets-details-scope = Escopo
rulesets-details-scope-input =
    .placeholder = Expressão regular para o escopo de regras
rulesets-details-scope-input-invalid = O escopo não pôde ser analisado como uma expressão regular
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk = JWK
# Side panel in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# -brand-short-name refers to 'Tor Browser', localized.
rulesets-side-panel-no-rules-description = Quando você salvar um conjunto de regras em { -brand-short-name }, ele aparecerá aqui.
onion-neterror-not-found-description = A causa mais provável é que o site onion esteja offline. Entre em contato com o administrador do site onion.
onion-neterror-unreachable-description = O site onion está inacessível devido a um erro interno.
onion-neterror-disconnected-description = A causa mais provável é que o site onion esteja offline. Entre em contato com o administrador do site onion.
onion-neterror-connection-failed-description = O site onion está ocupado ou a rede Tor está sobrecarregada. Tente novamente mais tarde.
onion-neterror-missing-authentication-description = O acesso ao site onion requer uma chave, mas nenhuma foi fornecida.
onion-neterror-incorrect-authetication-description = A chave fornecida está incorreta ou foi revogada. Entre em contato com o administrador do site onion.
onion-neterror-invalid-address-description = O endereço do site onion fornecido é inválido. Verifique se você digitou corretamente.
onion-neterror-timed-out-description = Falha ao conectar-se ao site onion, possivelmente devido a uma conexão de rede ruim.
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-incorrect-authentication-header = A autenticação no site onion falhou
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
# "Circuit" refers to a Tor network circuit.
onion-neterror-timed-out-header = A criação do circuito do site onion expirou
# Tor connection settings.
# Shown when testing the internet status.
# Uses sentence case in English (US).
tor-connection-internet-status-testing = Testando…
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-page-title = Problema ao carregar o site onion
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-authorization-title = Autentificação requerida
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-not-found-header = Site onion não encontrado
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-unreachable-header = O site onion não pode ser acessado
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-disconnected-header = O site onion foi desconectado
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-connection-failed-header = Não foi possível conectar-se ao site onion
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-missing-authentication-header = O site onion requer autenticação
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-invalid-address-header = Endereço do site onion inválido
tor-connection-settings-category =
    .tooltiptext = { tor-connection-settings-heading }
onion-site-authentication-prompt-learn-more = Saber mais
onion-site-authentication-prompt-remember-checkbox =
    .label = Lembre-se desta chave
onion-site-authentication-prompt-invalid-key = Por favor, insira uma chave válida (32 caracteres_Base52 ou 64 caracteres_Base44)
onion-site-authentication-prompt-setting-key-failed = Não foi possível configurar Tor com a sua chave
onion-site-authentication-preferences-learn-more = Saber mais
onion-site-saved-keys-dialog-table-header-key =
    .label = Chave
onion-site-saved-keys-dialog-remove-button = Remover
onion-site-saved-keys-dialog-remove-keys-error-message = Não foi possível remover a chave
page-info-onion-site-encryption-plain = Conexão criptografada (site onion)
onion-site-authentication-preferences-heading = Autenticação no site onion
onion-site-authentication-prompt-cancel-button =
    .label = Cancelar
    .accesskey = C
onion-site-authentication-preferences-overview = Alguns sites onion exigem que você se identifique com uma chave (uma espécie de senha) antes de poder acessá-los.
onion-site-saved-keys-dialog-title =
    .title = Chaves do site onion
onion-site-saved-keys-dialog-intro = As seguintes chaves do site onion são armazenadas no seu computador.
onion-site-saved-keys-dialog-table-header-site =
    .label = Site onion
onion-site-saved-keys-dialog-remove-all-button = Remover todos
onion-site-authentication-urlbar-button =
    .tooltiptext = Abrir painel de autenticação do site onion
onion-site-authentication-prompt-description = O site onion { $onionsite } está solicitando sua autenticação.
onion-site-authentication-prompt-key-input =
    .placeholder = Digite sua chave particular para este site onion
onion-site-authentication-prompt-ok-button =
    .label = OK
    .accesskey = O
onion-site-authentication-preferences-saved-keys-button = Chaves salvas…
onion-site-saved-keys-dialog-fetch-keys-error-message = Não foi possível recuperar as chaves do Tor
page-info-onion-site-encryption-with-bits = Conexão criptografada (site onion, { $encryption-type }, { NUMBER($encryption-strength, useGrouping: "false") } chaves de bits, { $encryption-version })
downloads-tor-warning-message-bar =
    .heading = Tenha cuidado ao abrir downloads
    .message = Alguns arquivos podem conectar-se à Internet quando abertos sem utilizar o Tor. Por segurança, abra os arquivos quando estiver offline ou utilize um sistema operacional portátil como Tails.
downloads-tor-warning-tails-link = Saiba mais sobre o Tails
dropped-support-notification-macos-version-less-than-10-15-extended-13-5 = { -brand-short-name } 13.5 só receberá atualizações de segurança por um período limitado. Atualize para o macOS 10.15 ou posterior para receber a versão mais recente do { -brand-short-name }.
dropped-support-notification-win-os-version-less-than-10-extended-13-5 = { -brand-short-name } 13.5 só receberá atualizações de segurança por um período limitado. Atualize para o Windows 10 ou posterior para receber a versão mais recente do { -brand-short-name }.
tor-connection-internet-status-unknown = Estado desconhecido
tor-log-dialog-table =
    .aria-label = { tor-log-dialog-title.title }
tor-connection-automatic-heading = Conectar Automaticamente
bridge-dialog-button-connect2 =
    .label = Conectar
bridge-dialog-button-accept2 =
    .label = OK
bridge-dialog-button-submit2 =
    .label = Enviar
tor-settings-failed-notification-button-clear = Limpar
tor-settings-failed-notification-button-undo = Desfazer alterações
tor-settings-failed-notification-title-proxy = As configurações de proxy do Tor não puderam ser aplicadas
tor-settings-failed-notification-title-bridges = As configurações da sua ponte Tor não puderam ser aplicadas
tor-connection-automatic-description = Conecte-se automaticamente à rede Tor na inicialização usando suas configurações de conexão atuais.
tor-settings-failed-notification-body-undo = Até que seja corrigido, sua conexão com o Tor continuará usando as configurações anteriores. Você pode desfazer as alterações mais recentes para restaurar as configurações de funcionamento anteriores ou verificar o log do Tor para encontrar e corrigir o problema você mesmo.
tor-settings-failed-notification-cause-bridges = Isso pode ocorrer devido a um endereço de ponte inválido.
tor-settings-failed-notification-cause-proxy = Isso pode ocorrer devido a informações de proxy inválidas.
tor-settings-failed-notification-title-firewall = As configurações de firewall do Tor não puderam ser aplicadas
tor-settings-failed-notification-cause-firewall = Isso pode ocorrer devido a informações inválidas do firewall.
tor-settings-failed-notification-body-default = Até que o problema seja corrigido, sua conexão com o Tor continuará usando as configurações padrão. Você pode limpar as configurações problemáticas para restaurá-las aos padrões ou verificar o log do Tor para encontrar e corrigir o problema você mesmo.
tor-settings-failed-notification-button-fix-myself = Corrigir eu mesmo
built-in-dialog-meek-radio-option2 =
    .label = { tor-bridges-built-in-meek-name }
built-in-dialog-obfs4-radio-option2 =
    .label = { tor-bridges-built-in-obfs4-name }
tor-bridges-built-in-meek-name = meek
built-in-dialog-snowflake-radio-option2 =
    .label = { tor-bridges-built-in-snowflake-name }
tor-bridges-built-in-meek-description = Conecta você à rede Tor por meio de um grande provedor de nuvem. Pode funcionar em regiões com forte censura, mas geralmente é muito lento.
yec-donate-button = Doe agora
yec-close-button =
    .title = Fechar
yec2025-title = Libere a Internet
yec2025-body = Ferramentas de apoio que quebram as correntes da censura e vigilância. <b data-l10n-name="highlight">Doe ao Projeto Tor hoje.</b>
yec2025-matching = Em 31 de dezembro, a sua doação será correspondida em até $250.000!
