tor-browser-home-heading-stable = 閲覧する。プライベートに。
tor-browser-home-heading-testing = テストする。徹底的に。
tor-browser-home-duck-duck-go-input =
    .placeholder = DuckDuckGo で検索
tor-browser-home-message-introduction = 世界で最もプライベートなブラウジングを行う準備が完了しました。
# Tor browser manual link shown in the menu bar.
# Uses Title case.
menu-open-tor-manual =
    .label = Tor Browser マニュアル
    .accesskey = M
# Tor browser manual link shown in the application menu (aka: hamburger menu).
# Uses Sentence case.
appmenu-open-tor-manual =
    .label = Tor Browser マニュアル
    .accesskey = m
# Tor Browser home page.
# Toggle to switch from DuckDuckGo's plain ".com" domain to its ".onion" domain.
tor-browser-home-onionize-toggle =
    .label = Onionize
    .title = Onion Site を使って検索します
# Shown in Home settings, corresponds to the default about:tor home page.
home-mode-choice-tor =
    .label = Tor Browser ホーム
# Tor Browser home page.
tor-browser-home-message-donate = Tor が無料で使えるのは、皆様の寄付のおかげです。<a data-l10n-name="donate-link">今すぐ寄付する</a>
# Tor Browser home page.
# Update message.
# <a data-l10n-name="update-link"> should contain the link text and close with </a>.
# $version (String) - The new tor browser version.
tor-browser-home-message-updated = Tor Browser が { $version } に更新されました。<a data-l10n-name="update-link">変更点を見る</a>
# Tor Browser home page.
tor-browser-home-message-testing = これは Tor Browser の新機能を試すための不安定版です。<a data-l10n-name="learn-more-link">詳細情報</a>
# Tor Browser home page.
tor-browser-home-message-news = Tor の最新ニュースを受信トレイに直接お届けします。<a data-l10n-name="news-link">Tor News に申し込む</a>
# Tor Browser home page.
# Only shown when underlying Tor process was not started by Tor Browser.
# "Tails" refers to the operating system, and should be translated as a brand name.
# <a data-l10n-name="tor-check-link"> should contain the link text and close with </a>.
tor-browser-home-tor-check-warning = Tor への接続は Tor Browser によって管理されていません。いくつかのオペレーティングシステム (Tails など) はこれを管理したり、カスタム設定をしたりすることができます。<a data-l10n-name="tor-check-link">接続テスト</a>
# Tor Bridges Settings
tor-bridges-none-added = 追加されたブリッジはありません
# Tor Bridges Settings
tor-bridges-your-bridges = あなたのブリッジ
# Tor Bridges Settings
tor-bridges-source-built-in = 内蔵
# Tor Bridges Settings
tor-bridges-source-requested = Tor から入手しました
# Tor Bridges Settings
tor-bridges-source-user = あなたによって追加されました
# Tor Bridges Settings
# The "..." menu button for all current bridges.
tor-bridges-options-button =
    .title = すべてのブリッジ
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can generate a QR code for all of their bridges.
tor-bridges-menu-item-qr-all-bridge-addresses = QR コードを表示
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can copy all of their bridges.
tor-bridges-menu-item-copy-all-bridge-addresses = ブリッジアドレスをコピー
    .accesskey = C
# Tor Bridges Settings
# Only shown in the "..." menu for bridges added by the user.
tor-bridges-menu-item-edit-all-bridges = ブリッジを編集
    .accesskey = E
# Tor Bridges Settings
# Shown in the "..." menu for all current bridges.
tor-bridges-menu-item-remove-all-bridges = すべてのブリッジを削除
    .accesskey = R
# Tor Bridges Settings
# Shown when one of the built-in bridges is in use.
tor-bridges-built-in-status-connected = 接続済み
# Tor Bridges Settings
# Shown at the start of a Tor bridge line.
# $type (String) - The Tor bridge type ("snowflake", "obfs4", "meek-azure").
tor-bridges-type-prefix = { $type } ブリッジ:
# Tor Bridges Settings
# Shown at the start of a Tor bridge line, when the transport type is unknown (or "vanilla").
tor-bridges-type-prefix-generic = Tor ブリッジ:
# Tor Bridges Settings
# Used for an image of a bridge emoji. Each bridge address can be hashed into four emojis shown to the user (bridgemoji feature). This string corresponds to a *single* such emoji. The "title" should just be emojiName. The "alt" should let screen readers know that the image is of a *single* emoji, as well as its name.
# $emojiName (String) - The name of the emoji, already localized.
tor-bridges-emoji-image =
    .alt = 絵文字: { $emojiName }
    .title = { $emojiName }
# Tor Bridges Settings
# Shown when the bridge has been used for the most recent Tor circuit, i.e. the most recent bridge we have connected to.
tor-bridges-status-connected = 接続済み
# Tor Bridges Settings
# Used when the bridge has no status, i.e. the *absence* of a status to report to the user. This is only visibly shown when the status cell has keyboard focus.
tor-bridges-status-none = ステータスがありません
# Tor Bridges Settings
# The "..." menu button for an individual bridge row.
tor-bridges-individual-bridge-options-button =
    .title = ブリッジのオプション
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Shows the QR code for this one bridge.
tor-bridges-menu-item-qr-address = QR コードを表示
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Removes this one bridge.
tor-bridges-menu-item-remove-bridge = ブリッジを削除
    .accesskey = R
# Tor Bridges Settings
# Text shown just before a description of the most recent change to the list of user's bridges. Some white space will separate this text from the change description.
# This text is not visible, but is instead used for screen reader users.
# E.g. in English this could be "Recent update: One of your Tor bridges has been removed."
tor-bridges-update-area-intro = 最近の更新:
# Tor Bridges Settings
# Shown when using a "bridge pass", i.e. using Lox.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-description = ブリッジパスを使用すると、ブリッジがブロックされた際に、ブリッジボットが新しいブリッジを送信します。ブリッジがブロックされなければ、信頼できる知り合いとブリッジを共有できる招待のロックが解除されます。
# Tor Bridges Settings
# Here "Bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# This is shown when the user is getting their bridges from Lox.
tor-bridges-source-lox = ブリッジパス
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Copies the single bridge address to clipboard.
tor-bridges-menu-item-copy-address = ブリッジアドレスをコピー
    .accesskey = C
# Tor Bridges Settings
# Toggle button for enabling and disabling the use of bridges.
tor-bridges-use-bridges =
    .label = ブリッジを使う
# Tor Bridges Settings
# Update text for screen reader users when only one of their bridges has been removed.
tor-bridges-update-removed-one-bridge = 1つの Tor ブリッジが削除されました。
# Tor Bridges Settings
# Update text for screen reader users when all of their bridges have been removed.
tor-bridges-update-removed-all-bridges = すべての Tor ブリッジが削除されました。
# Tor Bridges Settings
# Update text for screen reader users when their bridges have changed in some arbitrary way.
tor-bridges-update-changed-bridges = Tor ブリッジが変更されました。
# Tor Bridges Settings
# Shown for requested bridges and bridges added by the user.
tor-bridges-share-heading = 他の人の接続をサポートする
# Tor Bridges Settings
tor-bridges-share-description = 信頼できる知り合いとブリッジを共有します。
# Tor Bridges Settings
tor-bridges-copy-addresses-button = アドレスをコピー
# Tor Bridges Settings
tor-bridges-qr-addresses-button =
    .title = QR コードを表示
# Tor Bridges Settings
# The emoji name to show on hover when a bridge emoji's name is unknown.
tor-bridges-emoji-unknown = 不明
# Tor Bridges Settings
# The number of days until the user's "bridge pass" is upgraded.
# $numDays (Number) - The number of days until the next upgrade, an integer (1 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numDays". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numDays is "1" (singular) and the second form will be used if $numDays is anything else (plural).
tor-bridges-lox-days-until-unlock =
    { $numDays ->
        [one] { $numDays }日後に以下のロックが解除されます:
       *[other] { $numDays }日後に以下のロックが解除されます:
    }
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain access to invites for the first time.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-first-invites = 信頼できる知り合いの招待
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user already has invites.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-more-invites = 信頼できる知り合いの招待を増やす
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain two more bridges in the future.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-unlock-two-bridges = ブリッジボットからの+2個のブリッジ
# Tor Bridges Settings
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-remaining-invites =
    { $numInvites ->
        [one] { $numInvites }人を招待可能
       *[other] { $numInvites }人を招待可能
    }
# Tor Bridges Settings
# Shown *after* the user has had their blocked bridges replaced.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-new-bridges = ブリッジボットからの新しいブリッジ
# Tor Bridges Settings
# Button for the user to acknowledge a change in their "bridge pass".
tor-bridges-lox-got-it-button = 了解
# Tor Bridges Settings
# Shown as a heading when the user has no current bridges.
tor-bridges-add-bridges-heading = ブリッジを追加
# Tor Bridges Settings
tor-bridges-select-built-in-description = { -brand-short-name } の内蔵ブリッジのいずれかを選択する
# Tor Bridges Settings
tor-bridges-select-built-in-button = 内蔵ブリッジを選択…
# Tor Bridges Settings
tor-bridges-add-addresses-description = すでに知っているブリッジアドレスを入力する
# Tor Bridges Settings
# Shown when the user has no current bridges.
# Opens a dialog where the user can provide a new bridge address or share code.
tor-bridges-add-new-button = 新しいブリッジを追加…
# Tor Bridges Settings
tor-bridges-find-more-heading = 他のブリッジを探す
# Tor Bridges Settings
# "Tor Project" is the organisation name.
tor-bridges-find-more-description = 多くのブリッジアドレスは公開されていないため、Tor Project にリクエストする必要があるかもしれません。
# Tor Bridges Settings
# Shown when the user has existing bridges.
# Opens a dialog where the user can provide a new bridge address or share code to replace their current bridges.
tor-bridges-replace-button = ブリッジを置換…
# Tor Bridges Settings
# Shown when the user's bridges accessed through "bridge pass" have been blocked.
tor-bridges-lox-blocked = ブロックされたブリッジは置換されました
# Tor Bridges Settings
# Shown as a heading when the user has existing bridges that can be replaced.
tor-bridges-replace-bridges-heading = ブリッジを置換
# Tor Bridges Settings
# Here "Message" is a verb, short for "Send a message to". This is an instruction to send a message to the given Telegram Messenger user to receive a new bridge.
# $telegramUserName (String) - The Telegram Messenger user name that should receive messages. Should be wrapped in '<a data-l10n-name="user">' and '</a>'.
# E.g. in English, "Message GetBridgesBot".
tor-bridges-provider-telegram-instruction = <a data-l10n-name="user">{ $telegramUserName }</a> にメッセージを送信
# Tor Bridges Settings
# Instructions to visit the given website.
# $url (String) - The URL for Tor Project bridges. Should be wrapped in '<a data-l10n-name"url">' and '</a>'.
tor-bridges-provider-web-instruction = <a data-l10n-name="url">{ $url }</a> にアクセス
# Tor Bridges Settings
# Here "Email" is a verb, short for "Send an email to". This is an instruction to send an email to the given address to receive a new bridge.
# $address (String) - The email address that should receive the email.
# E.g. in English, "Email bridges@torproject.org".
tor-bridges-provider-email-instruction = { $address } にメールを送信
# User provided bridge dialog.
# Description shown when adding new bridges, replacing existing bridges, or editing existing bridges.
user-provide-bridge-dialog-description = 信頼できる組織または知り合いが提供するブリッジを使用します。
# User provided bridge dialog.
# "Learn more" link shown in the "Add new bridges"/"Replace your bridges" dialog.
user-provide-bridge-dialog-learn-more = 詳細情報
# User provided bridge dialog.
# Short accessible name for the bridge addresses text area.
user-provide-bridge-dialog-textarea-addresses-label = ブリッジアドレス
# User provided bridge dialog.
# Error shown when one of the address lines is invalid.
# $line (Number) - The line number for the invalid address.
user-provide-bridge-dialog-address-error = 行 { $line } のブリッジアドレスの書式が正しくありません。
# User provided bridge dialog.
# Error shown when the user has entered more than one "bridge pass" invite.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-multiple-invites-error = 複数の招待を含めることはできません。
# User provided bridge dialog.
# Error shown when the user has mixed their invite with addresses.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-mixed-error = ブリッジアドレスと招待を並立させることはできません。
# User provided bridge dialog.
# Error shown when the user has entered an invite when it is not supported.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
user-provide-bridge-dialog-invite-not-allowed-error = 招待ブリッジパスを含めることはできません。
# User provided bridge dialog.
# Error shown when the invite was not accepted by the server.
user-provide-bridge-dialog-bad-invite-error = 招待が受理されませんでした。別の招待をお試しください。
# User provided bridge dialog.
# Error shown when the "bridge pass" server does not respond.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-no-server-error = ブリッジパスサーバーに接続できません。
# User provided bridge dialog.
# Generic error when an invite failed.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-generic-invite-error = 招待の引き換えに失敗しました。
# User provided bridge dialog.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-connecting = ブリッジパスサーバーに接続しています…
# User provided bridge dialog.
# Shown after the user has entered a "bridge pass" invite.
user-provide-bridge-dialog-result-invite = 以下のブリッジが共有されました。
# User provided bridge dialog.
# Shown after the user has entered bridge addresses.
user-provide-bridge-dialog-result-addresses = 以下のブリッジが入力されました。
# User provided bridge dialog.
user-provide-bridge-dialog-next-button =
    .label = 次へ
# Tor Bridges Settings
# Shown *after* the user has gained two more bridges.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-gained-two-bridges = ブリッジボットからの+2個のブリッジ
# Tor Bridges Settings
# Shown when the user's "bridge pass" has been upgraded.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
tor-bridges-lox-upgrade = ブリッジパスがアップグレードされました！
# Tor Bridges Settings
# Shown *after* a user's "bridge pass" has changed.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-new-invites =
    { $numInvites ->
        [one] 残り{ $numInvites }人の信頼できる知り合いを招待可能
       *[other] 残り{ $numInvites }人の信頼できる知り合いを招待可能
    }
# Tor Bridges Settings
tor-bridges-request-from-browser = { -brand-short-name } の内部ページを離れることなく、ブリッジボットからブリッジを取得することもできます。
# User provided bridge dialog.
# Used when the user is editing their existing bridge addresses.
user-provide-bridge-dialog-edit-title =
    .title = ブリッジを編集
# Tor Bridges Settings
tor-bridges-request-button = ブリッジをリクエスト…
# User provided bridge dialog.
# Used when the user has no existing bridges.
user-provide-bridge-dialog-add-title =
    .title = 新しいブリッジを追加
# User provided bridge dialog.
# Used when the user is replacing their existing bridges with new ones.
user-provide-bridge-dialog-replace-title =
    .title = ブリッジを置換
# User provided bridge dialog.
# Here "invite" is a noun, short for "invitation".
# Short accessible name for text area when it can accept either bridge address or a single "bridge pass" invite.
user-provide-bridge-dialog-textarea-addresses-or-invite-label = ブリッジアドレスまたは招待
# User provided bridge dialog.
# Placeholder shown when adding new bridge addresses.
user-provide-bridge-dialog-textarea-addresses =
    .placeholder = ここにブリッジアドレスを貼り付けてください
# User provided bridge dialog.
# Placeholder shown when the user can add new bridge addresses or a single "bridge pass" invite.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
# NOTE: "invite" is singular, whilst "addresses" is plural.
user-provide-bridge-dialog-textarea-addresses-or-invite =
    .placeholder = ブリッジアドレスまたは招待ブリッジパスをここに貼り付けます
# Tor Bridges Settings
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-show-invites-button = 招待状を表示
# Tor Bridges Settings
# "Web" is the proper noun for the "World Wide Web".
tor-bridges-provider-web-name = ウェブ
# Tor Bridges Settings
# "Telegram" is the common brand name of the Telegram Messenger application
tor-bridges-provider-telegram-name = Telegram
# Tor Bridges Settings
# "Gmail" is the Google brand name. "Riseup" refers to the Riseup organisation at riseup.net.
tor-bridges-provider-email-name = Gmail または Riseup
# Built-in bridges dialog.
# Label attached to the built-in bridge option that is already in use.
# The "aria-label" should use the same text, but include some ending punctuation to separate it from the sentence that follows. This is used for screen reader users.
built-in-dialog-current-bridge-label = 現在のブリッジ
    .aria-label = 現在のブリッジ。
about-dialog-tor-project = { -brand-short-name } は、オンラインでのプライバシーと自由を守るために活動している非営利団体 <label data-l10n-name="project-link">{ -vendor-short-name }</label> によって開発されました。
about-dialog-help-out = 支援していただけますか？ <label data-l10n-name="donate-link">寄付</label>や<label data-l10n-name="community-link">コミュニティへの参加</label>をお願いします！
about-dialog-questions-link = 分からないことがありますか？
about-dialog-grow-tor-network-link = Tor ネットワークの発展にご協力ください！
about-dialog-browser-license-link = ライセンス情報
appmenuitem-new-tor-circuit =
    .label = このサイト用の Tor 回線を再構築
toolbar-new-tor-circuit =
    .label = このサイト用の Tor 回線を再構築
    .tooltiptext = { toolbar-new-tor-circuit.label }
tor-circuit-urlbar-button =
    .tooltiptext = Tor 回線
tor-circuit-panel-heading = { $host } の回線
tor-circuit-panel-alias = <a data-l10n-name="alias-link">{ $alias }</a> に接続済み
tor-circuit-panel-node-list-introduction = Tor 回線
tor-circuit-panel-node-browser = このブラウザー
tor-circuit-panel-node-onion-relays = Onion Site リレー
tor-circuit-panel-node-typed-bridge = ブリッジ: { $bridge-type }
tor-circuit-panel-node-bridge = ブリッジ
tor-circuit-panel-node-region-guard = { $region } (ガード)
tor-circuit-panel-node-unknown-region = 不明な地域
tor-circuit-panel-new-button = このサイト用の Tor 回線を再構築
tor-circuit-panel-new-button-description-guard = ガードノードが変更されない可能性があります
tor-circuit-panel-new-button-description-bridge = ブリッジが変更されない可能性があります
# New tor circuit.
# Shown in the File menu.
# Uses title case for English (US).
menu-new-tor-circuit =
    .label = このサイト用の Tor 回線を再構築
    .accesskey = C
crypto-safety-prompt-title = 安全でないウェブサイトからコピーされた暗号資産アドレス
crypto-safety-prompt-body = コピーされたテキスト ({ $address }) は暗号資産のアドレスのようです。{ $host } への接続は安全ではないので、アドレスは改ざんされている可能性があり、信頼すべきではありません。新しい回線で再接続することで、安全な接続の確立をお試しください。
crypto-safety-prompt-reload-button = 新しい回線を利用してタブを再読み込み
crypto-safety-prompt-dismiss-button = 警告を無視
# Tor advanced connection settings dialog.
# "address" is a noun, referring to an network IP address.
tor-advanced-dialog-proxy-address-input-label = アドレス
# Warning dialog when removing all bridges.
remove-all-bridges-warning-title = すべてのブリッジを削除しますか？
# Tor Bridges Settings.
tor-bridges-learn-more-link = 詳細情報
# Built-in bridges dialog.
request-bridge-dialog-top-wait = BridgeDB に接続しています。今しばらくお待ちください。
# Tor Bridges Settings.
tor-bridges-heading = ブリッジ
# Tor Bridges Settings.
tor-bridges-built-in-obfs4-description = Tor のトラフィックをランダムなデータのように見せます。検閲の厳しい地域では動作しない可能性があります。
# Tor advanced settings.
tor-advanced-settings-heading = 高度な設定
# Tor Bridges Settings.
tor-bridges-overview = ブリッジは Tor がブロックされている場所で、Tor ネットワークに安全にアクセスするのに役立ちます。あなたがお住まいの地域によって、最適に機能するブリッジは異なる可能性があります。
# Tor connection settings.
# "Connection" refers to the Tor Browser's connection to the Tor network.
tor-connection-settings-heading = 接続
# Tor connection settings.
tor-connection-quickstart-heading = QuickStart
# Tor connection settings.
# Prefix before the internet connection status.
# "Internet" is not a proper noun, but is capitalized because it is the start of a sentence.
tor-connection-internet-status-label = インターネット:
# Tor connection settings.
# Button to test the internet connection.
# Here "Test" is a verb, as in "test the internet connection".
# Uses sentence case in English (US).
tor-connection-internet-status-test-button = テスト
# Tor connection settings.
# Shown when the user is connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-online = オンライン
# Tor connection settings.
# Shown when the user is not connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-offline = オフライン
# Tor connection settings.
# Shown when the user is connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connected = 接続済み
# Tor connection settings.
# Shown when the user is not connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-not-connected = 接続されていません
# Tor connection settings.
# Shown when the user's Tor connection may be blocked.
# Uses sentence case in English (US).
tor-connection-network-status-blocked = ブロックされた可能性があります
# Tor connection settings.
# Button shown when we are not yet connected to the Tor network.
# It will open a page to start connecting to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connect-button = 接続
# Tor Bridges Settings.
# "obfs4" is a technical name, and likely should not be translated.
tor-bridges-built-in-obfs4-name = obfs4
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-name = Snowflake
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-description = Snowflake のプロキシを経由して接続をルーティングし、まるで通常のビデオ通話をしているように見せかけます。
# Tor Bridges Settings.
# "meek-azure" is a technical name, and likely should not be translated.
tor-bridges-built-in-meek-azure-name = meek-azure
# Tor Bridges Settings.
tor-bridges-built-in-meek-azure-description = Tor を使っているのではなく、Microsoft のウェブサイトに接続しているように見せかけます。検閲の厳しい地域でも使えるかもしれませんが、通常は非常に遅いです。
# Warning dialog when removing all bridges.
remove-all-bridges-warning-description = これらのブリッジが torproject.org から受け取ったもの、または手動で追加されたものである場合、このアクションは元に戻せません
# Warning dialog when removing all bridges.
remove-all-bridges-warning-remove-button = 削除
# Common button used in bridge dialogs.
bridge-dialog-button-connect = 接続
# Common button used in bridge dialogs.
bridge-dialog-button-accept = OK
# Common button used in bridge dialogs.
bridge-dialog-button-submit = 送信
# Built-in bridges dialog.
request-bridge-dialog-top-solve = ブリッジをリクエストするには CAPTCHA を解いてください。
# Built-in bridges dialog.
request-bridge-dialog-captcha-failed = 解答が正しくありません。もう一度お試しください。
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-type-selector-label = プロキシの種類
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-port-input-label = ポート
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input-label = ユーザー名
# Tor connection settings.
tor-connection-browser-learn-more-link = 詳細情報
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input-label = パスワード
# Tor advanced settings.
# Button that opens the advanced connection settings dialog.
# Uses sentence case in English (US).
tor-advanced-settings-button = 設定…
tor-connection-quickstart-checkbox =
    .label = 常に自動的に接続する
bridge-qr-dialog-title =
    .title = QR コードをスキャン
built-in-dialog-title =
    .title = 内蔵ブリッジを選択
built-in-dialog-snowflake-radio-option =
    .label = Snowflake
built-in-dialog-meek-azure-radio-option =
    .label = meek-azure
request-bridge-dialog-title =
    .title = ブリッジをリクエスト
request-bridge-dialog-captcha-input =
    .placeholder = 画像の文字を入力してください
tor-log-dialog-copy-button-copied =
    .label = コピーしました！
tor-advanced-dialog-proxy-socks4-menuitem =
    .label = SOCKS4
tor-advanced-dialog-proxy-socks5-menuitem =
    .label = SOCKS5
tor-advanced-dialog-proxy-http-menuitem =
    .label = HTTP/HTTPS
tor-advanced-dialog-proxy-address-input =
    .placeholder = IP アドレスまたはホスト名
tor-advanced-dialog-proxy-username-input =
    .placeholder = オプション
tor-advanced-dialog-proxy-password-input =
    .placeholder = オプション
tor-advanced-dialog-firewall-checkbox =
    .label = このコンピューターは特定のポートへの接続のみ許可するファイアウォールを経由しています
tor-advanced-dialog-firewall-ports-input =
    .placeholder = カンマ区切り
# Tor advanced settings.
tor-advanced-settings-description = { -brand-short-name } がインターネットに接続する方法を設定します。
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-checkbox =
    .label = インターネット接続にプロキシを使用する
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input-label = 許可されたポート
# Built-in bridges dialog.
# "obfs4" is a technical name, and likely should not be translated.
built-in-dialog-obfs4-radio-option =
    .label = obfs4
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-view-log-description = Tor ログを見る
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-title =
    .title = Tor ログ
# Tor advanced connection settings dialog.
tor-advanced-dialog-introduction = { -brand-short-name } がインターネットに接続する方法を設定します。
# Tor advanced connection settings dialog.
tor-advanced-dialog-title =
    .title = 接続設定
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-overview = { -brand-short-name } は通信トラフィックを Tor ネットワークを経由させて送信します。Tor ネットワークは世界中の何千ものボランティアによって運用されています。
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-quickstart-description = QuickStart は最後に使用した接続設定に基づいて、起動時に { -brand-short-name } を Tor ネットワークに自動的に接続します。
# Built-in bridges dialog.
# -brand-short-name refers to 'Tor Browser', localized.
built-in-dialog-introduction = { -brand-short-name } には、Tor を使用していることを隠すのに役立つ「Pluggable Transport」と呼ばれる特定のタイプのブリッジが内蔵されています。
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
# Uses sentence case in English (US).
tor-view-log-button = ログを表示…
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-copy-button =
    .label = Tor ログをクリップボードにコピーする
# Tor connection settings.
# Prefix before the Tor network connection status.
# Uses sentence case in English (US).
tor-connection-network-status-label = Tor ネットワーク:
downloads-tor-warning-title = 注意: ダウンロードしたファイルを開く際はご注意ください
downloads-tor-warning-description = Tor を使用せずにファイルを開くと、インターネットに接続される可能性があります。安全のため、オフラインでファイルを開くか、<a data-l10n-name="tails-link">Tails</a> のようなポータブルオペレーティングシステムををご利用ください。
downloads-tor-warning-dismiss-button = 了解
rulesets-warning-heading = ご注意ください
rulesets-warning-description = ルールセットを追加または変更すると、攻撃者があなたのブラウザーをハイジャックする可能性があります。あなたが行っている操作の意味を理解している場合のみ、操作を行ってください。
rulesets-warning-checkbox = これらの設定にアクセスしようとすると、警告が表示されます
rulesets-warning-continue-button = 危険を承知で続行
rulesets-side-panel-heading = ルールセット
rulesets-side-panel-no-rules = ルールセットが見つかりません
rulesets-update-last = 最終更新日時 { DATETIME($date, dateStyle: "long") }
rulesets-update-never = 一度も更新されていないか、最後の更新に失敗しました
rulesets-update-rule-disabled = 無効
rulesets-details-edit-button = 編集
rulesets-details-enable-checkbox = このルールセットを有効にする
rulesets-details-update-button = 更新を確認
rulesets-details-save-button = 保存
rulesets-details-cancel-button = キャンセル
rulesets-details-jwk-input =
    .placeholder = このルールセットを JWK (JSON Web Key) 形式で署名するために使用する鍵
rulesets-details-jwk-input-invalid = JWK を解析できないか、または有効な鍵ではありません
rulesets-details-path = パスプレフィックス
rulesets-details-path-input =
    .placeholder = ルールセットが必要とするファイルを含む URL プレフィックス
rulesets-details-path-input-invalid = パスプレフィックスが有効な HTTP(S) URL ではありません
rulesets-details-scope = スコープ
rulesets-details-scope-input =
    .placeholder = ルールのスコープを表す正規表現
rulesets-details-scope-input-invalid = スコープが正規表現として解析できませんでした
onion-neterror-not-found-description = おそらく、Onion Site がオフラインになっています。Onion Site の管理者にお問い合わせください。
onion-neterror-unreachable-description = 内部エラーにより Onion Site に接続できません。
onion-neterror-disconnected-description = おそらく、Onion Site がオフラインになっています。Onion Site の管理者にお問い合わせください。
onion-neterror-connection-failed-description = Onion Site が混雑しているか、 Tor ネットワークに大きな負荷がかかっています。時間をおいて再度お試しください。
onion-neterror-missing-authentication-description = Onion Site へのアクセスにキーが必要ですが、何も入力されませんでした。
onion-neterror-incorrect-authetication-description = 入力されたキーが正しくないか、またはキーが取り消されました。Onion Site の管理者にお問い合わせください。
onion-neterror-invalid-address-description = 入力された Onion Site アドレスは有効ではありません。アドレスが正しく入力されているかをご確認ください。
onion-neterror-timed-out-description = ネットワークの接続状態が不安定だったため、Onion Site への接続に失敗しました。
# Side panel in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# -brand-short-name refers to 'Tor Browser', localized.
rulesets-side-panel-no-rules-description = ルールセットを { -brand-short-name } に保存すると、ここに表示されます。
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-page-title = Onion Site の読み込み中に問題が発生しました
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk = JWK
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-not-found-header = Onion Site が見つかりません
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-connection-failed-header = Onion Site に接続できません
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-missing-authentication-header = Onion Site は認証を必要としています
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-unreachable-header = Onion Site に接続できません
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-invalid-address-header = 無効な Onion Site アドレスです
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
# "Circuit" refers to a Tor network circuit.
onion-neterror-timed-out-header = Onion Site の回線作成がタイムアウトしました
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-incorrect-authentication-header = Onion Site の認証に失敗しました
# Tor connection settings.
# Shown when testing the internet status.
# Uses sentence case in English (US).
tor-connection-internet-status-testing = 確認しています…
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-authorization-title = 認証が必要です
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-disconnected-header = Onion Site との接続が切断されました
tor-connection-settings-category =
    .tooltiptext = { tor-connection-settings-heading }
onion-site-authentication-prompt-learn-more = 詳細情報
onion-site-authentication-prompt-remember-checkbox =
    .label = このキーを保存する
onion-site-authentication-prompt-invalid-key = 有効なキーを入力してください (52 Base32 文字または 44 Base64 文字)
onion-site-authentication-prompt-setting-key-failed = あなたのキーで Tor を構成できませんでした
onion-site-authentication-preferences-learn-more = 詳細情報
onion-site-saved-keys-dialog-table-header-key =
    .label = キー
onion-site-saved-keys-dialog-remove-button = 削除
onion-site-saved-keys-dialog-remove-keys-error-message = キーを削除できません
onion-site-saved-keys-dialog-remove-all-button = すべて削除
onion-site-saved-keys-dialog-fetch-keys-error-message = Tor からキーを取得できません
onion-site-authentication-prompt-description = Onion Site { $onionsite } はあなたの認証を要求しています。
onion-site-authentication-urlbar-button =
    .tooltiptext = Onion Site 認証パネルを開く
onion-site-authentication-prompt-key-input =
    .placeholder = この Onion Site の秘密鍵を入力する
onion-site-authentication-prompt-ok-button =
    .label = OK
    .accesskey = O
onion-site-authentication-prompt-cancel-button =
    .label = キャンセル
    .accesskey = C
page-info-onion-site-encryption-plain = 接続が暗号化されています (Onion Site)
onion-site-authentication-preferences-heading = Onion Site 認証
onion-site-authentication-preferences-overview = 一部の Onion Site では、アクセスする前にキー(パスワードのようなもの)で本人確認をする必要があります。
onion-site-authentication-preferences-saved-keys-button = 保存されたキー…
onion-site-saved-keys-dialog-title =
    .title = Onion Site キー
onion-site-saved-keys-dialog-intro = 以下の Onion Site キーがコンピューターに保存されています。
page-info-onion-site-encryption-with-bits = 接続が暗号化されています (Onion Site、 { $encryption-type }、鍵長 { NUMBER($encryption-strength, useGrouping: "false") } bit 、{ $encryption-version })
onion-site-saved-keys-dialog-table-header-site =
    .label = Onion Site
downloads-tor-warning-message-bar =
    .heading = 注意: ダウンロードしたファイルを開く際はご注意ください
    .message = Tor を使用せずにファイルを開くと、インターネットに接続される可能性があります。安全のため、オフラインでファイルを開くか、Tails のようなポータブルオペレーティングシステムをご利用ください。
downloads-tor-warning-tails-link = Tails の詳細
dropped-support-notification-macos-version-less-than-10-15-extended-13-5 = { -brand-short-name } 13.5 では、限られた期間のみセキュリティ更新プログラムが提供されます。最新バージョンの { -brand-short-name } をご利用いただくには、macOS 10.15 以降にアップグレードしてください。
dropped-support-notification-win-os-version-less-than-10-extended-13-5 = { -brand-short-name } 13.5 では、限られた期間のみセキュリティ更新プログラムが提供されます。最新バージョンの { -brand-short-name } をご利用いただくには、Windows 10 以降にアップグレードしてください。
tor-connection-internet-status-unknown = 不明なステータス
tor-log-dialog-table =
    .aria-label = { tor-log-dialog-title.title }
tor-connection-automatic-heading = 自動的に接続する
tor-connection-automatic-description = 現在の接続設定を使用して、起動時に Tor ネットワークに自動的に接続します。
tor-settings-failed-notification-cause-bridges = 無効なブリッジアドレスが原因の可能性があります。
tor-settings-failed-notification-title-bridges = Tor のブリッジ設定を適用できませんでした
tor-settings-failed-notification-cause-proxy = 無効なプロキシ情報が原因の可能性があります。
tor-settings-failed-notification-title-proxy = Tor のプロキシ設定を適用できませんでした
tor-settings-failed-notification-title-firewall = Tor のファイアウォール設定を適用できませんでした
tor-settings-failed-notification-cause-firewall = 無効なファイアウォール情報が原因の可能性があります。
tor-settings-failed-notification-body-undo = 修正されるまで、Tor 接続は以前の設定を使い続けます。最新の変更を元に戻して以前の動作設定を復元するか、Tor ログを確認して自分で問題を見つけ修正します。
tor-settings-failed-notification-body-default = 修正されるまで、Tor 接続はデフォルトの設定を使い続けます。問題のある設定を削除してデフォルトに戻すか、Tor ログを確認して自分で問題を見つけ修正します。
tor-settings-failed-notification-button-undo = 変更を取り消す
tor-settings-failed-notification-button-clear = 削除
tor-settings-failed-notification-button-fix-myself = 自分で修正する
bridge-dialog-button-connect2 =
    .label = 接続
bridge-dialog-button-accept2 =
    .label = OK
bridge-dialog-button-submit2 =
    .label = 送信
built-in-dialog-meek-radio-option2 =
    .label = { tor-bridges-built-in-meek-name }
built-in-dialog-obfs4-radio-option2 =
    .label = { tor-bridges-built-in-obfs4-name }
tor-bridges-built-in-meek-name = meek
built-in-dialog-snowflake-radio-option2 =
    .label = { tor-bridges-built-in-snowflake-name }
tor-bridges-built-in-meek-description = 大手クラウドプロバイダー経由で Tor ネットワークに接続します。検閲の厳しい地域でも機能する可能性がありますが、通常は非常に低速です。
yec-donate-button = 今すぐ寄付する
yec-close-button =
    .title = 閉じる
yec2025-title = インターネットを、自由に。
yec2025-body = 検閲と監視の連鎖を断ち切るツールのサポートをお願いします。<b data-l10n-name="highlight">今すぐ Tor Project に寄付しましょう。</b>
yec2025-matching = 12 月 31 日まで、最大 25 万ドルまでマッチングギフトが行われます！
