# Tor browser manual link shown in the menu bar.
# Uses Title case.
menu-open-tor-manual =
    .label = Tor Browser rehberi
    .accesskey = B
tor-browser-home-heading-stable = Keşfedin. Gizlice.
tor-browser-home-heading-testing = Deneyimleyin. Enine boyuna.
tor-browser-home-duck-duck-go-input =
    .placeholder = DuckDuckGo ile arayın
tor-browser-home-message-introduction = Dünyanın en gizli İnternet gezinmesi deneyimine hazırsınız.
# Shown in Home settings, corresponds to the default about:tor home page.
home-mode-choice-tor =
    .label = Tor Browser girişi
# Tor Browser home page.
tor-browser-home-message-donate = Tor sizin gibi insanların bağışları ile ücretsiz olarak kullanılabiliyor. <a data-l10n-name="donate-link">Bağış yapın</a>
# Tor Browser home page.
# Update message.
# <a data-l10n-name="update-link"> should contain the link text and close with </a>.
# $version (String) - The new tor browser version.
tor-browser-home-message-updated = Tor Browser { $version } sürümüne güncellendi. <a data-l10n-name="update-link">Yeniliklere bakın</a>
# Tor Browser home page.
tor-browser-home-message-testing = Bu yeni özellikleri denemek için hazırlanmış kararsız bir Tor Browser sürümüdür. <a data-l10n-name="learn-more-link">Ayrıntılı bilgi alın</a>
# Tor Browser home page.
tor-browser-home-message-news = Güncel Tor haberlerini e-posta olarak alın. <a data-l10n-name="news-link">Tor duyurularına abone olun</a>
# Tor browser manual link shown in the application menu (aka: hamburger menu).
# Uses Sentence case.
appmenu-open-tor-manual =
    .label = Tor Browser rehberi
    .accesskey = b
# Tor Browser home page.
# Toggle to switch from DuckDuckGo's plain ".com" domain to its ".onion" domain.
tor-browser-home-onionize-toggle =
    .label = Onion yap
    .title = Onion sitesini kullanarak ara
# Tor Browser home page.
# Only shown when underlying Tor process was not started by Tor Browser.
# "Tails" refers to the operating system, and should be translated as a brand name.
# <a data-l10n-name="tor-check-link"> should contain the link text and close with </a>.
tor-browser-home-tor-check-warning = Tor bağlantınızı Tor Browser yönetmiyor. Bazı işletim sistemleri (Tails gibi) bunu sizin için yönetir veya özel bir yapılandırma ayarlamış olabilirsiniz. <a data-l10n-name="tor-check-link">Bağlantınızı sınayın</a>
# Tor Bridges Settings
# Toggle button for enabling and disabling the use of bridges.
tor-bridges-use-bridges =
    .label = Köprüler kullanılsın
# Tor Bridges Settings
tor-bridges-none-added = Henüz bir köprü eklenmemiş
# Tor Bridges Settings
tor-bridges-your-bridges = Köprüleriniz
# Tor Bridges Settings
tor-bridges-source-user = Sizin ekledikleriniz
# Tor Bridges Settings
tor-bridges-source-built-in = Hazır köprüler
# Tor Bridges Settings
tor-bridges-source-requested = Tor ağından istenmiş
# Tor Bridges Settings
# Here "Bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# This is shown when the user is getting their bridges from Lox.
tor-bridges-source-lox = Köprü bileti
# Tor Bridges Settings
# The "..." menu button for all current bridges.
tor-bridges-options-button =
    .title = Tüm köprüler
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can generate a QR code for all of their bridges.
tor-bridges-menu-item-qr-all-bridge-addresses = Kare kodu görüntüle
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can copy all of their bridges.
tor-bridges-menu-item-copy-all-bridge-addresses = Köprü adreslerini kopyala
    .accesskey = C
# Tor Bridges Settings
# Only shown in the "..." menu for bridges added by the user.
tor-bridges-menu-item-edit-all-bridges = Köprüleri düzenle
    .accesskey = E
# Tor Bridges Settings
# Shown in the "..." menu for all current bridges.
tor-bridges-menu-item-remove-all-bridges = Tüm köprüleri kaldır
    .accesskey = R
# Tor Bridges Settings
# Shown when one of the built-in bridges is in use.
tor-bridges-built-in-status-connected = Bağlantı kuruldu
# Tor Bridges Settings
# Shown at the start of a Tor bridge line.
# $type (String) - The Tor bridge type ("snowflake", "obfs4", "meek-azure").
tor-bridges-type-prefix = { $type } köprüsü:
# Tor Bridges Settings
# Shown at the start of a Tor bridge line, when the transport type is unknown (or "vanilla").
tor-bridges-type-prefix-generic = Tor köprüsü:
# Tor Bridges Settings
# Used for an image of a bridge emoji. Each bridge address can be hashed into four emojis shown to the user (bridgemoji feature). This string corresponds to a *single* such emoji. The "title" should just be emojiName. The "alt" should let screen readers know that the image is of a *single* emoji, as well as its name.
# $emojiName (String) - The name of the emoji, already localized.
tor-bridges-emoji-image =
    .alt = Emoji: { $emojiName }
    .title = { $emojiName }
# Tor Bridges Settings
# The emoji name to show on hover when a bridge emoji's name is unknown.
tor-bridges-emoji-unknown = Bilinmiyor
# Tor Bridges Settings
# Shown when the bridge has been used for the most recent Tor circuit, i.e. the most recent bridge we have connected to.
tor-bridges-status-connected = Bağlantı kuruldu
# Tor Bridges Settings
# Used when the bridge has no status, i.e. the *absence* of a status to report to the user. This is only visibly shown when the status cell has keyboard focus.
tor-bridges-status-none = Durum yok
# Tor Bridges Settings
# The "..." menu button for an individual bridge row.
tor-bridges-individual-bridge-options-button =
    .title = Köprü seçenekleri
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Shows the QR code for this one bridge.
tor-bridges-menu-item-qr-address = Kare kodu görüntüle
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Copies the single bridge address to clipboard.
tor-bridges-menu-item-copy-address = Köprü adresini kopyala
    .accesskey = C
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Removes this one bridge.
tor-bridges-menu-item-remove-bridge = Köprüyü kaldır
    .accesskey = R
# Tor Bridges Settings
# Text shown just before a description of the most recent change to the list of user's bridges. Some white space will separate this text from the change description.
# This text is not visible, but is instead used for screen reader users.
# E.g. in English this could be "Recent update: One of your Tor bridges has been removed."
tor-bridges-update-area-intro = Son güncelleme:
# Tor Bridges Settings
# Update text for screen reader users when all of their bridges have been removed.
tor-bridges-update-removed-all-bridges = Tüm Tor köprüleriniz kaldırıldı.
# Tor Bridges Settings
# Update text for screen reader users when their bridges have changed in some arbitrary way.
tor-bridges-update-changed-bridges = Tor köprüleriniz değişti.
# Tor Bridges Settings
# Shown for requested bridges and bridges added by the user.
tor-bridges-share-heading = Başkalarının bağlantı kurmasına yardımcı olun
# Tor Bridges Settings
tor-bridges-share-description = Köprülerinizi güvenilir kişilerle paylaşın.
# Tor Bridges Settings
tor-bridges-copy-addresses-button = Adresleri kopyala
# Tor Bridges Settings
tor-bridges-qr-addresses-button =
    .title = Kare kodu görüntüle
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain two more bridges in the future.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-unlock-two-bridges = Köprü botundan +2 köprü
# Tor Bridges Settings
# Update text for screen reader users when only one of their bridges has been removed.
tor-bridges-update-removed-one-bridge = Tor köprülerinizden biri kaldırıldı.
# Tor Bridges Settings
# Shown when using a "bridge pass", i.e. using Lox.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-description = Bir köprü biletiniz olduğunda, köprüleriniz engellenirse köprü botu size yeni köprüler gönderir. Köprüleriniz engellenmemişse, köprülerinizi güvenilir kişilerle paylaşmanızı sağlayan davetler gönderebilirsiniz.
# Tor Bridges Settings
# The number of days until the user's "bridge pass" is upgraded.
# $numDays (Number) - The number of days until the next upgrade, an integer (1 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numDays". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numDays is "1" (singular) and the second form will be used if $numDays is anything else (plural).
tor-bridges-lox-days-until-unlock =
    { $numDays ->
        [one] Kilidin açılmasına { $numDays } gün kaldı:
       *[other] Kilidin açılmasına { $numDays } gün kaldı:
    }
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain access to invites for the first time.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-first-invites = Güvenilir kişileriniz için davetler
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user already has invites.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-more-invites = Güvenilir kişileriniz için daha fazla davet
# Tor Bridges Settings
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-show-invites-button = Davetleri görüntüle
# Tor Bridges Settings
# Shown when the user's "bridge pass" has been upgraded.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
tor-bridges-lox-upgrade = Köprü biletiniz yükseltildi!
# Tor Bridges Settings
# Shown when the user's bridges accessed through "bridge pass" have been blocked.
tor-bridges-lox-blocked = Engellenen köprüleriniz değiştirildi
# Tor Bridges Settings
# Shown *after* the user has had their blocked bridges replaced.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-new-bridges = Köprü botundan yeni köprüler
# Tor Bridges Settings
# Shown *after* the user has gained two more bridges.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-gained-two-bridges = Köprü botundan +2 köprü
# Tor Bridges Settings
# Shown *after* a user's "bridge pass" has changed.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-new-invites =
    { $numInvites ->
        [one] Güvenilir kişilerinize gönderebileceğiniz { $numInvites } davet kaldı
       *[other] Güvenilir kişilerinize gönderebileceğiniz { $numInvites } davet kaldı
    }
# Tor Bridges Settings
# Button for the user to acknowledge a change in their "bridge pass".
tor-bridges-lox-got-it-button = Anladım
# Tor Bridges Settings
tor-bridges-select-built-in-button = Bir hazır köprü seçin…
# Tor Bridges Settings
tor-bridges-add-addresses-description = Bildiğiniz köprü adreslerini yazın
# Tor Bridges Settings
# Shown when the user has no current bridges.
# Opens a dialog where the user can provide a new bridge address or share code.
tor-bridges-add-new-button = Yeni köprüler ekle…
# Tor Bridges Settings
# "Tor Project" is the organisation name.
tor-bridges-find-more-description = Birçok köprü adresi herkese açık olmadığından, bazılarını Tor Projesinden istemeniz gerekebilir.
# Tor Bridges Settings
# "Telegram" is the common brand name of the Telegram Messenger application
tor-bridges-provider-telegram-name = Telegram
# Tor Bridges Settings
# "Web" is the proper noun for the "World Wide Web".
tor-bridges-provider-web-name = Site
# Tor Bridges Settings
# Instructions to visit the given website.
# $url (String) - The URL for Tor Project bridges. Should be wrapped in '<a data-l10n-name"url">' and '</a>'.
tor-bridges-provider-web-instruction = <a data-l10n-name="url">{ $url }</a> adresine gidin
# Tor Bridges Settings
# "Gmail" is the Google brand name. "Riseup" refers to the Riseup organisation at riseup.net.
tor-bridges-provider-email-name = Gmail ya da Riseup
# Tor Bridges Settings
# Here "Email" is a verb, short for "Send an email to". This is an instruction to send an email to the given address to receive a new bridge.
# $address (String) - The email address that should receive the email.
# E.g. in English, "Email bridges@torproject.org".
tor-bridges-provider-email-instruction = { $address } adresine e-posta gönderin
# Tor Bridges Settings
tor-bridges-request-from-browser = { -brand-short-name } içinden ayrılmadan da köprü botundan köprüler alabilirsiniz.
# Tor Bridges Settings
tor-bridges-request-button = Köprüler isteyin…
# User provided bridge dialog.
# Used when the user is editing their existing bridge addresses.
user-provide-bridge-dialog-edit-title =
    .title = Köprülerinizi düzenleyin
# User provided bridge dialog.
# Used when the user has no existing bridges.
user-provide-bridge-dialog-add-title =
    .title = Yeni köprüler ekle
# User provided bridge dialog.
# Used when the user is replacing their existing bridges with new ones.
user-provide-bridge-dialog-replace-title =
    .title = Köprülerinizi değiştirin
# User provided bridge dialog.
# Description shown when adding new bridges, replacing existing bridges, or editing existing bridges.
user-provide-bridge-dialog-description = Güvenilir bir kuruluş veya tanıdığınız biri tarafından verilen köprüleri kullanın.
# User provided bridge dialog.
# Short accessible name for the bridge addresses text area.
user-provide-bridge-dialog-textarea-addresses-label = Köprü adresleri
# User provided bridge dialog.
# Placeholder shown when adding new bridge addresses.
user-provide-bridge-dialog-textarea-addresses =
    .placeholder = Köprü adreslerinizi buraya yapıştırın
# User provided bridge dialog.
# Placeholder shown when the user can add new bridge addresses or a single "bridge pass" invite.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
# NOTE: "invite" is singular, whilst "addresses" is plural.
user-provide-bridge-dialog-textarea-addresses-or-invite =
    .placeholder = Köprü adreslerinizi ya da köprü bileti davetinizi buraya yapıştırın
# User provided bridge dialog.
# Error shown when one of the address lines is invalid.
# $line (Number) - The line number for the invalid address.
user-provide-bridge-dialog-address-error = { $line }. satırdaki köprü adresinin biçimi doğru değil.
# User provided bridge dialog.
# Error shown when the user has entered more than one "bridge pass" invite.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-multiple-invites-error = Birden fazla davet eklenemez.
# User provided bridge dialog.
# Error shown when the user has mixed their invite with addresses.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-mixed-error = Köprü adresleriyle davet bir arada kullanılamaz.
# User provided bridge dialog.
# Error shown when the user has entered an invite when it is not supported.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
user-provide-bridge-dialog-invite-not-allowed-error = Bir köprü bileti daveti eklenemez.
# User provided bridge dialog.
# Error shown when the invite was not accepted by the server.
user-provide-bridge-dialog-bad-invite-error = Davet kabul edilmedi. Başka bir davet deneyin.
# User provided bridge dialog.
# Error shown when the "bridge pass" server does not respond.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-no-server-error = Köprü bileti sunucusu ile bağlantı kurulamadı.
# User provided bridge dialog.
# Generic error when an invite failed.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-generic-invite-error = Davet kullanılamadı.
# User provided bridge dialog.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-connecting = Köprü bileti sunucusu ile bağlantı kuruluyor…
# User provided bridge dialog.
# Shown after the user has entered a "bridge pass" invite.
user-provide-bridge-dialog-result-invite = Şu köprüler sizinle paylaşıldı.
# User provided bridge dialog.
# Shown after the user has entered bridge addresses.
user-provide-bridge-dialog-result-addresses = Aşağıdaki köprüler sizin tarafınızdan eklendi.
# User provided bridge dialog.
user-provide-bridge-dialog-next-button =
    .label = Sonraki
# Tor Bridges Settings
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-remaining-invites =
    { $numInvites ->
        [one] { $numInvites } davet kaldı
       *[other] { $numInvites } davet kaldı
    }
# Tor Bridges Settings
# Shown as a heading when the user has no current bridges.
tor-bridges-add-bridges-heading = Köprüler ekleyin
# Tor Bridges Settings
# Shown as a heading when the user has existing bridges that can be replaced.
tor-bridges-replace-bridges-heading = Köprülerinizi değiştirin
# Tor Bridges Settings
tor-bridges-select-built-in-description = Hazır { -brand-short-name } köprülerinden birini seçin
# Tor Bridges Settings
# Shown when the user has existing bridges.
# Opens a dialog where the user can provide a new bridge address or share code to replace their current bridges.
tor-bridges-replace-button = Köprüleri değiştirin…
# Tor Bridges Settings
tor-bridges-find-more-heading = Daha fazla köprü bulun
# User provided bridge dialog.
# "Learn more" link shown in the "Add new bridges"/"Replace your bridges" dialog.
user-provide-bridge-dialog-learn-more = Ayrıntılı bilgi alın
# Tor Bridges Settings
# Here "Message" is a verb, short for "Send a message to". This is an instruction to send a message to the given Telegram Messenger user to receive a new bridge.
# $telegramUserName (String) - The Telegram Messenger user name that should receive messages. Should be wrapped in '<a data-l10n-name="user">' and '</a>'.
# E.g. in English, "Message GetBridgesBot".
tor-bridges-provider-telegram-instruction = <a data-l10n-name="user">{ $telegramUserName }</a> için ileti gönderin
# User provided bridge dialog.
# Here "invite" is a noun, short for "invitation".
# Short accessible name for text area when it can accept either bridge address or a single "bridge pass" invite.
user-provide-bridge-dialog-textarea-addresses-or-invite-label = Köprü adresleri ya da davet
# Built-in bridges dialog.
# Label attached to the built-in bridge option that is already in use.
# The "aria-label" should use the same text, but include some ending punctuation to separate it from the sentence that follows. This is used for screen reader users.
built-in-dialog-current-bridge-label = Geçerli köprü
    .aria-label = Geçerli köprü.
about-dialog-tor-project = { -brand-short-name } geliştiricisi <label data-l10n-name="project-link">{ -vendor-short-name }</label>, kar amacı gütmeyen, çevrim içi gizliliğinizi ve özgürlüğünüzü koruyan bir kuruluştur.
about-dialog-help-out = Yardım etmek ister misiniz? <label data-l10n-name="donate-link">Bağış yapın</label> ya da <label data-l10n-name="community-link">çalışmalarımıza katılın</label>!
about-dialog-questions-link = Sorularınız mı var?
about-dialog-grow-tor-network-link = Tor ağının büyümesine yardımcı olun!
about-dialog-browser-license-link = Lisans bilgileri
menu-new-tor-circuit =
    .label = Sitenin Tor devresini yenile
    .accesskey = d
appmenuitem-new-tor-circuit =
    .label = Sitenin Tor devresini yenile
toolbar-new-tor-circuit =
    .label = Sitenin Tor devresini yenile
    .tooltiptext = { toolbar-new-tor-circuit.label }
tor-circuit-urlbar-button =
    .tooltiptext = Tor devresi
tor-circuit-panel-heading = { $host } devresi
tor-circuit-panel-alias = <a data-l10n-name="alias-link">{ $alias }</a> ile bağlantı kuruldu
tor-circuit-panel-node-list-introduction = Tor devresi
tor-circuit-panel-node-browser = Bu tarayıcı
tor-circuit-panel-node-onion-relays = Onion sitesi aktarıcıları
tor-circuit-panel-node-typed-bridge = Köprü: { $bridge-type }
tor-circuit-panel-node-bridge = Köprü
tor-circuit-panel-node-region-guard = { $region } (koruma)
tor-circuit-panel-node-unknown-region = Bölge bilinmiyor
tor-circuit-panel-new-button = Sitenin Tor devresini yenile
tor-circuit-panel-new-button-description-guard = Koruma noktanız değişmeyebilir
tor-circuit-panel-new-button-description-bridge = Köprünüz değişmeyebilir
crypto-safety-prompt-title = Kripto para birimi adresi güvenli olmayan bir siteden kopyalandı
crypto-safety-prompt-body = Kopyalanan metin ({ $address }) bir kripto para birimi adresi gibi görünüyor. { $host }bağlantısı güvenli olmadığından, adres değiştirilmiş olabilir ve güvenilmemelidir. Yeni bir devre ile yeniden erişerek güvenli bir bağlantı kurmayı deneyebilirsiniz.
crypto-safety-prompt-reload-button = Sekmenin devresini yenile
crypto-safety-prompt-dismiss-button = Uyarıyı yok say
# Common button used in bridge dialogs.
bridge-dialog-button-connect = Bağlan
# Warning dialog when removing all bridges.
remove-all-bridges-warning-remove-button = Kaldır
# Tor Bridges Settings.
tor-bridges-overview = Köprüler, engellendiği yerlerde Tor ağına güvenli bir şekilde erişmenize yardımcı olur. Nerede bulunduğunuza bağlı olarak, bir köprü diğerinden daha iyi çalışabilir.
# Tor Bridges Settings.
# "meek-azure" is a technical name, and likely should not be translated.
tor-bridges-built-in-meek-azure-name = meek-azure
# Tor connection settings.
tor-connection-quickstart-heading = Hızlı başlangıç
# Tor Bridges Settings.
tor-bridges-learn-more-link = Ayrıntılı bilgi alın
# Tor connection settings.
# Shown when the user is connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-online = Çevrim içi
# Tor Bridges Settings.
tor-bridges-built-in-obfs4-description = Tor trafiğinizin rastgele veriler gibi görünmesini sağlar. Katı engelleme uygulanan bölgelerde çalışmayabilir.
# Tor Bridges Settings.
tor-bridges-built-in-meek-azure-description = Tor kullanıyor gibi değil bir Microsoft sitesine bağlıymışsınız gibi görünmenizi sağlar. Katı engelleme uygulanan bölgelerde çalışabilir, ancak genellikle çok yavaştır.
# Warning dialog when removing all bridges.
remove-all-bridges-warning-description = Bu köprüler torproject.org üzerinden alınmış ya da el ile eklenmiş ise bu işlem geri alınamaz
# Built-in bridges dialog.
request-bridge-dialog-top-wait = Lütfen köprü veri tabanı ile bağlantı kurulurken bekleyin.
# Tor advanced settings.
tor-advanced-settings-heading = Gelişmiş
# Tor advanced connection settings dialog.
# "address" is a noun, referring to an network IP address.
tor-advanced-dialog-proxy-address-input-label = Adres
# Tor connection settings.
# "Connection" refers to the Tor Browser's connection to the Tor network.
tor-connection-settings-heading = Bağlantı
# Tor connection settings.
tor-connection-browser-learn-more-link = Ayrıntılı bilgi alın
# Tor connection settings.
# Prefix before the internet connection status.
# "Internet" is not a proper noun, but is capitalized because it is the start of a sentence.
tor-connection-internet-status-label = İnternet:
# Tor connection settings.
# Button to test the internet connection.
# Here "Test" is a verb, as in "test the internet connection".
# Uses sentence case in English (US).
tor-connection-internet-status-test-button = Sına
# Tor connection settings.
# Shown when the user is not connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-offline = Çevrim dışı
# Tor connection settings.
# Shown when the user is connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connected = Bağlı
# Tor connection settings.
# Shown when the user is not connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-not-connected = Bağlı değil
# Tor connection settings.
# Shown when the user's Tor connection may be blocked.
# Uses sentence case in English (US).
tor-connection-network-status-blocked = Olası engelleme
# Tor connection settings.
# Button shown when we are not yet connected to the Tor network.
# It will open a page to start connecting to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connect-button = Bağlan
# Tor Bridges Settings.
tor-bridges-heading = Köprüler
# Tor Bridges Settings.
# "obfs4" is a technical name, and likely should not be translated.
tor-bridges-built-in-obfs4-name = obfs4
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-name = Snowflake
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-description = Örneğin, görüntülü arama yapıyormuşsunuz gibi görünmesi için bağlantınızı Snowflake vekil sunucuları üzerinden yönlendirir.
# Warning dialog when removing all bridges.
remove-all-bridges-warning-title = Tüm köprüler silinsin mi?
# Common button used in bridge dialogs.
bridge-dialog-button-accept = Tamam
# Common button used in bridge dialogs.
bridge-dialog-button-submit = Gönder
# Built-in bridges dialog.
request-bridge-dialog-top-solve = Köprü isteğinde bulunmak için güvenlik doğrulamasını tamamlayın.
# Built-in bridges dialog.
request-bridge-dialog-captcha-failed = Çözüm doğru değil. Lütfen yeniden deneyin.
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-type-selector-label = Vekil sunucu türü
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-port-input-label = Bağlantı noktası
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input-label = Kullanıcı adı
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input-label = Parola
# Tor advanced settings.
# Button that opens the advanced connection settings dialog.
# Uses sentence case in English (US).
tor-advanced-settings-button = Ayarlar…
tor-connection-quickstart-checkbox =
    .label = Bağlantı her zaman otomatik olarak kurulsun
bridge-qr-dialog-title =
    .title = Kare kodu tarayın
built-in-dialog-title =
    .title = Bir hazır köprü seçin
built-in-dialog-snowflake-radio-option =
    .label = Snowflake
built-in-dialog-meek-azure-radio-option =
    .label = meek-azure
request-bridge-dialog-title =
    .title = Köprü isteğinde bulunun
request-bridge-dialog-captcha-input =
    .placeholder = Görseldeki karakterleri yazın
tor-log-dialog-copy-button-copied =
    .label = Kopyalandı!
tor-advanced-dialog-proxy-socks4-menuitem =
    .label = SOCKS4
tor-advanced-dialog-proxy-socks5-menuitem =
    .label = SOCKS5
tor-advanced-dialog-proxy-http-menuitem =
    .label = HTTP/HTTPS
tor-advanced-dialog-proxy-address-input =
    .placeholder = IP adresi ya da sunucu adı
tor-advanced-dialog-proxy-username-input =
    .placeholder = İsteğe bağlı
tor-advanced-dialog-proxy-password-input =
    .placeholder = İsteğe bağlı
tor-advanced-dialog-firewall-checkbox =
    .label = Bu bilgisayarda yalnızca belirli bağlantı noktalarından bağlantı kurulmasına izin veren bir güvenlik duvarı var
tor-advanced-dialog-firewall-ports-input =
    .placeholder = Virgül ile ayrılmış değerler
downloads-tor-warning-title = İndirmeleri açarken dikkatli olun
downloads-tor-warning-description = Bazı dosyalar Tor kullanılmadan açıldığında İnternet ile bağlantı kurabilir. Güvende olmak için dosyaları çevrim dışı olduğunuzda açın ya da <a data-l10n-name="tails-link">Tails</a> gibi taşınabilir bir işletim sistemi kullanın.
downloads-tor-warning-dismiss-button = Anladım
rulesets-warning-heading = Dikkatli ilerleyin
rulesets-warning-description = Kural kümelerini eklemek ya da değiştirmek saldırganların tarayıcınıza sızmasına neden olabilir. Yalnızca ne yaptığınızı biliyorsanız ilerleyin.
rulesets-warning-checkbox = Bu seçeneklere erişmek istediğimde beni uyar
rulesets-warning-continue-button = Riski kabul ediyorum ve ilerlemek istiyorum
rulesets-side-panel-heading = Kural kümeleri
rulesets-side-panel-no-rules = Herhangi bir kural kümesi bulunamadı
rulesets-update-last = Son güncelleme: { DATETIME($date, dateStyle: "long") }
rulesets-update-never = Asla güncellenmemiş ya da son güncelleme yapılamamış
rulesets-update-rule-disabled = Devre dışı
rulesets-details-edit-button = Düzenle
rulesets-details-enable-checkbox = Bu kural kümesini etkinleştir
rulesets-details-update-button = Güncelleme denetimi
rulesets-details-save-button = Kaydet
rulesets-details-cancel-button = İptal
rulesets-details-jwk-input =
    .placeholder = Bu kural kümesini JWK (JSON Web Key) biçiminde imzalamak için kullanılan anahtar
rulesets-details-jwk-input-invalid = JWK işlenemedi ya da anahtar geçersiz
rulesets-details-path = Yol ön eki
rulesets-details-path-input =
    .placeholder = Kural kümesinin gerek duyduğu dosyaları içeren adres ön eki
rulesets-details-path-input-invalid = Yol ön eki geçerli bir HTTP(S) adresi değil
rulesets-details-scope = Kapsam
rulesets-details-scope-input =
    .placeholder = Kural kapsamının kurallı ifadesi
rulesets-details-scope-input-invalid = Kapsam bir kurallı ifade olarak işlenemedi
onion-neterror-not-found-description = Onion sitesi büyük olasılıkla çevrim dışı. Onion sitesinin yöneticisi ile görüşün.
onion-neterror-unreachable-description = Bir iç sorun nedeniyle onion sitesine erişilemiyor.
onion-neterror-disconnected-description = Onion sitesi büyük olasılıkla çevrim dışı. Onion sitesinin yöneticisi ile görüşün.
onion-neterror-connection-failed-description = Onion sitesi meşgul ya da Tor ağının yükü fazla. Bir süre sonra yeniden deneyin.
onion-neterror-missing-authentication-description = Onion sitesine erişmek için bir anahtar gerekiyor ancak herhangi bir anahtar belirtilmemiş.
onion-neterror-incorrect-authetication-description = Belirtilen anahtar hatalı ya da kullanımdan kaldırılmış. Onion sitesinin yöneticisi ile görüşün.
onion-neterror-invalid-address-description = Belirtilen onion sitesi adresi geçersiz. Lütfen adresi doğru yazdığınızdan emin olun.
onion-neterror-timed-out-description = Onion sitesi ile bağlantı kurulamadı. Büyük olasılıkla ağ bağlantısı kötü.
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-checkbox =
    .label = İnternete bağlanmak için bir vekil sunucu kullanıyorum
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-overview = { -brand-short-name } trafiğinizi dünya çapında binlerce gönüllü tarafından işletilen Tor ağı üzerinden yöneltir.
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-quickstart-description = Hızlı başlangıç, { -brand-short-name } başlatıldığında son kullandığınız bağlantı ayarlarına göre otomatik olarak Tor ağına bağlanmayı sağlar.
# Tor connection settings.
# Prefix before the Tor network connection status.
# Uses sentence case in English (US).
tor-connection-network-status-label = Tor ağı:
# Built-in bridges dialog.
# "obfs4" is a technical name, and likely should not be translated.
built-in-dialog-obfs4-radio-option =
    .label = obfs4
# Tor advanced settings.
tor-advanced-settings-description = { -brand-short-name } internet bağlantısını nasıl kuracak yapılandırın.
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-view-log-description = Tor günlüğünü görüntüleyin.
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-copy-button =
    .label = Tor günlüğünü panoya kopyala
# Tor advanced connection settings dialog.
tor-advanced-dialog-title =
    .title = Bağlantı ayarları
# Tor advanced connection settings dialog.
tor-advanced-dialog-introduction = { -brand-short-name } internet bağlantısını nasıl kuracak yapılandırın.
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input-label = Kullanılabilecek bağlantı noktaları
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
# "Circuit" refers to a Tor network circuit.
onion-neterror-timed-out-header = Onion sitesi devresi oluşturma işlemi zaman aşımına uğradı
# Tor connection settings.
# Shown when testing the internet status.
# Uses sentence case in English (US).
tor-connection-internet-status-testing = Sınanıyor…
# Built-in bridges dialog.
# -brand-short-name refers to 'Tor Browser', localized.
built-in-dialog-introduction = { -brand-short-name } içinde, Tor ağını kullandığınız gerçeğini gizlemeye yardımcı olabilecek “değiştirilebilir taşıyıcılar” olarak bilinen bazı özel köprü türleri bulunur.
# Side panel in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# -brand-short-name refers to 'Tor Browser', localized.
rulesets-side-panel-no-rules-description = { -brand-short-name } içinde bir kural kümesini kaydettiğinizde burada görünecektir.
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk = JWK
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-page-title = Onion sitesi yüklenirken sorun çıktı
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-authorization-title = Kimlik doğrulaması gerekli
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-not-found-header = Onion sitesi bulunamadı
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-unreachable-header = Onion sitesine erişilemedi
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-disconnected-header = Onion sitesinin bağlantısı kesildi
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-missing-authentication-header = Onion sitesi kimlik doğrulaması istiyor
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-connection-failed-header = Onion sitesi ile bağlantı kurulamadı
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-incorrect-authentication-header = Onion sitesinde kimlik doğrulanamadı
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-invalid-address-header = Onion sitesi adresi geçersiz
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
# Uses sentence case in English (US).
tor-view-log-button = Günlüğü görüntüle…
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-title =
    .title = Tor günlüğü
tor-connection-settings-category =
    .tooltiptext = { tor-connection-settings-heading }
onion-site-authentication-prompt-learn-more = Ayrıntılı bilgi alın
onion-site-authentication-prompt-remember-checkbox =
    .label = Bu anahtar hatırlansın
onion-site-authentication-prompt-invalid-key = Lütfen geçerli bir anahtar yazın (52 base32 karakteri ya da 44 base64 karakteri)
onion-site-authentication-prompt-setting-key-failed = Tor, anahtarınız ile yapılandırılamadı
onion-site-authentication-preferences-learn-more = Ayrıntılı bilgi alın
onion-site-saved-keys-dialog-table-header-key =
    .label = Anahtar
onion-site-saved-keys-dialog-remove-button = Sil
onion-site-saved-keys-dialog-remove-keys-error-message = Anahtar silinemedi
downloads-tor-warning-message-bar =
    .heading = İndirmeleri açarken dikkatli olun
    .message = Bazı dosyalar Tor kullanılmadan açıldığında İnternet ile bağlantı kurabilir. Güvende olmak için dosyaları çevrim dışı olduğunuzda açın ya da Tails gibi taşınabilir bir işletim sistemi kullanın.
page-info-onion-site-encryption-plain = Bağlantı şifrelenmiş (Onion hizmeti)
downloads-tor-warning-tails-link = Tails ile ilgili ayrıntılı bilgi alın
onion-site-authentication-preferences-overview = Bazı onion hizmetlerine erişmek için bir anahtar (bir tür parola) kullanarak kimliğinizi belirtmeniz gerekir.
onion-site-authentication-preferences-saved-keys-button = Kaydedilmiş anahtarlar…
onion-site-saved-keys-dialog-remove-all-button = Tümünü kaldır
onion-site-saved-keys-dialog-fetch-keys-error-message = Anahtarlar Tor üzerinden alınamadı
onion-site-authentication-urlbar-button =
    .tooltiptext = Onion sitesi kimlik doğrulama panosunu aç
onion-site-authentication-prompt-key-input =
    .placeholder = Onion sitesine kişisel anahtarınızı yazın
onion-site-authentication-prompt-ok-button =
    .label = Tamam
    .accesskey = O
onion-site-authentication-prompt-cancel-button =
    .label = İptal
    .accesskey = P
onion-site-authentication-preferences-heading = Onion sitesi kimlik doğrulaması
onion-site-saved-keys-dialog-title =
    .title = Onion sitesi anahtarları
page-info-onion-site-encryption-with-bits = Bağlantı şifrelenmiş (Onion sitesi, { $encryption-type }, { NUMBER($encryption-strength, useGrouping: "false") } bit anahtarlar, { $encryption-version })
onion-site-saved-keys-dialog-intro = Bilgisayarınızda şu onion site anahtarları kayıtlı.
onion-site-authentication-prompt-description = { $onionsite } onion sitesi kimliğinizi doğrulamanızı istiyor.
onion-site-saved-keys-dialog-table-header-site =
    .label = Onion sitesi
dropped-support-notification-macos-version-less-than-10-15-extended-13-5 = { -brand-short-name } 13.5 yalnızca sınırlı bir süre için güvenlik güncellemeleri alacak. Güncel { -brand-short-name } sürümünü almak için lütfen macOS 10.15 ya da üzerindeki bir sürüme yükseltin.
dropped-support-notification-win-os-version-less-than-10-extended-13-5 = { -brand-short-name } 13.5 yalnızca sınırlı bir süre için güvenlik güncellemeleri alacak. Güncel { -brand-short-name } sürümünü almak için lütfen Windows 10 ya da üzerindeki bir sürüme yükseltin.
tor-connection-internet-status-unknown = Bilinmeyen durum
tor-log-dialog-table =
    .aria-label = { tor-log-dialog-title.title }
tor-connection-automatic-heading = Otomatik bağlantı
tor-connection-automatic-description = Geçerli bağlantı ayarlarınız ile, başlangıçta otomatik olarak Tor ağına bağlanır.
tor-settings-failed-notification-title-bridges = Tor köprüsü ayarlarınız uygulanamadı
tor-settings-failed-notification-cause-bridges = Bu durum köprü adreslerinin geçersiz olmasından kaynaklanabilir.
tor-settings-failed-notification-title-proxy = Tor vekil sunucu ayarlarınız uygulanamadı
tor-settings-failed-notification-cause-proxy = Bu durum vekil sunucu bilgilerinin geçersiz olmasından kaynaklanabilir.
tor-settings-failed-notification-title-firewall = Tor güvenlik duvarı ayarlarınız uygulanamadı
tor-settings-failed-notification-cause-firewall = Bu durum güvenlik duvarı bilgilerinin geçersiz olmasından kaynaklanabilir.
tor-settings-failed-notification-body-undo = Düzeltilene kadar Tor bağlantınız önceki ayarlarınızı kullanmayı sürdürecek. Önceki çalışan ayarları geri yüklemek için son değişiklikleri geri alabilir ya da sorunu kendiniz bulup düzeltmek için Tor günlüğüne bakabilirsiniz.
tor-settings-failed-notification-body-default = Düzeltilene kadar Tor bağlantınız varsayılan ayarları kullanmayı sürdürecek. Sorunlu ayarları temizleyip varsayılan ayarları geri yükleyebilir ya da sorunu kendiniz bulup düzeltmek için Tor günlüğüne bakabilirsiniz.
tor-settings-failed-notification-button-undo = Değişiklikleri geri al
tor-settings-failed-notification-button-clear = Temizle
tor-settings-failed-notification-button-fix-myself = Ben düzelteceğim
bridge-dialog-button-connect2 =
    .label = Bağlan
bridge-dialog-button-accept2 =
    .label = Tamam
bridge-dialog-button-submit2 =
    .label = Gönder
built-in-dialog-meek-radio-option2 =
    .label = { tor-bridges-built-in-meek-name }
built-in-dialog-obfs4-radio-option2 =
    .label = { tor-bridges-built-in-obfs4-name }
tor-bridges-built-in-meek-name = meek
built-in-dialog-snowflake-radio-option2 =
    .label = { tor-bridges-built-in-snowflake-name }
tor-bridges-built-in-meek-description = Büyük bir bulut sağlayıcısı ile sizi Tor ağına bağlar. Yoğun sansür uygulanan bölgelerde çalışabilir, ancak genellikle çok yavaştır.
yec-donate-button = Bağış yapın
yec-close-button =
    .title = Kapat
yec2025-title = İnterneti özgürleştirin
yec2025-body = Sansür ve gözetim zincirlerini kıran araçları destekleyin. <b data-l10n-name="highlight">Tor Projesi için bağış yapın.</b>
yec2025-matching = 31 Aralık tarihine kadar 250.000 dolara kadar olan bağışlarınıza aynı tutarda destek verilecek!
