# Tor browser manual link shown in the menu bar.
# Uses Title case.
menu-open-tor-manual =
    .label = راهنمای مرورگر Tor
    .accesskey = ر
tor-browser-home-heading-stable = کاوش کنید. به‌صورت خصوصی.
tor-browser-home-heading-testing = بیازمایید. به‌طور کامل.
tor-browser-home-duck-duck-go-input =
    .placeholder = جست‌وجو با DuckDuckGo
tor-browser-home-message-introduction = شما برای خصوصی‌ترین تجربهٔ مرور اینترنت در جهان آماده‌اید.
# Shown in Home settings, corresponds to the default about:tor home page.
home-mode-choice-tor =
    .label = خانهٔ مرورگر Tor
# Tor browser manual link shown in the application menu (aka: hamburger menu).
# Uses Sentence case.
appmenu-open-tor-manual =
    .label = راهنمای مرورگر Tor
    .accesskey = ر
# Tor Browser home page.
# Toggle to switch from DuckDuckGo's plain ".com" domain to its ".onion" domain.
tor-browser-home-onionize-toggle =
    .label = ‏ Onion کردن
    .title = جست‌وجو با استفاده از سایت Onion
# Tor Browser home page.
# Update message.
# <a data-l10n-name="update-link"> should contain the link text and close with </a>.
# $version (String) - The new tor browser version.
tor-browser-home-message-updated = مرورگر Tor به { $version } ارتقا یافت. <a data-l10n-name="update-link">تازه‌ها را ببینید</a>
# Tor Browser home page.
tor-browser-home-message-donate = Tor به‌دلیل کمک‌های افرادی چون شما رایگان است. <a data-l10n-name="donate-link">اکنون حمایت کنید</a>
# Tor Browser home page.
tor-browser-home-message-news = دریافت جدیدترین اخبار Tor مستقیم در صندوق ورودی شما. <a data-l10n-name="news-link">ثبت‌نام برای اخبار Tor</a>
# Tor Browser home page.
tor-browser-home-message-testing = این نگارش مرورگر Tor ناپایدار و برای محک‌زدن ویژگی‌های جدید است. <a data-l10n-name="learn-more-link">بیشتر بدانید</a>
# Tor Browser home page.
# Only shown when underlying Tor process was not started by Tor Browser.
# "Tails" refers to the operating system, and should be translated as a brand name.
# <a data-l10n-name="tor-check-link"> should contain the link text and close with </a>.
tor-browser-home-tor-check-warning = اتصال شما به Tor توسط مرورگر Tor مدیریت نمی‌شود برخی از سیستم عامل‌ها (مانند Tails) اتصال را برای شما مدیریت می‌کنند. یا می‌توانید یک پیکربندی سفارشی تنظیم کنید. <a data-l10n-name="tor-check-link">اتصال خودتان را بیازمایید</a>
# Tor Bridges Settings
tor-bridges-source-built-in = توکار
# Tor Bridges Settings
# Shown when one of the built-in bridges is in use.
tor-bridges-built-in-status-connected = وصل‌شده
# Tor Bridges Settings
# "Gmail" is the Google brand name. "Riseup" refers to the Riseup organisation at riseup.net.
tor-bridges-provider-email-name = Gmail یا Riseup
# Tor Bridges Settings
# Here "Email" is a verb, short for "Send an email to". This is an instruction to send an email to the given address to receive a new bridge.
# $address (String) - The email address that should receive the email.
# E.g. in English, "Email bridges@torproject.org".
tor-bridges-provider-email-instruction = ارسال ایمیل به { $address }
# Tor Bridges Settings
# The emoji name to show on hover when a bridge emoji's name is unknown.
tor-bridges-emoji-unknown = ناشناخته
# Tor Bridges Settings
# Shown when the bridge has been used for the most recent Tor circuit, i.e. the most recent bridge we have connected to.
tor-bridges-status-connected = وصل‌شده
# Tor Bridges Settings
# Shown for requested bridges and bridges added by the user.
tor-bridges-share-heading = برای اتصال به دیگران کمک کنید
# Tor Bridges Settings
# Button for the user to acknowledge a change in their "bridge pass".
tor-bridges-lox-got-it-button = متوجه شدم
# Tor Bridges Settings
tor-bridges-select-built-in-button = انتخاب یک پل توکار…
# Tor Bridges Settings
# "Telegram" is the common brand name of the Telegram Messenger application
tor-bridges-provider-telegram-name = تلگرام
# Tor Bridges Settings
# "Web" is the proper noun for the "World Wide Web".
tor-bridges-provider-web-name = وب
# User provided bridge dialog.
# "Learn more" link shown in the "Add new bridges"/"Replace your bridges" dialog.
user-provide-bridge-dialog-learn-more = بیشتر بیاموزید
# User provided bridge dialog.
# Short accessible name for the bridge addresses text area.
user-provide-bridge-dialog-textarea-addresses-label = نشانی پل‌ها
about-dialog-tor-project = { -brand-short-name } را <label data-l10n-name="project-link">‎{ -vendor-short-name }‎ توسعه می‌دهد</label>، یک سازمان غیرانتفاعی که برای دفاع از حریم‌خصوصی و آزادی آنلاین شما تلاش می‌کند.
about-dialog-help-out = می‌خواهید کمک کنید؟ <label data-l10n-name="donate-link">حمایت</label> یا <label data-l10n-name="community-link">مشارکت کنید</label>!
about-dialog-questions-link = پرسشی دارید؟
about-dialog-grow-tor-network-link = کمک به رشد شبکه Tor!
about-dialog-browser-license-link = اطلاعات مربوط به پروانه
# User provided bridge dialog.
# Here "invite" is a noun, short for "invitation".
# Short accessible name for text area when it can accept either bridge address or a single "bridge pass" invite.
user-provide-bridge-dialog-textarea-addresses-or-invite-label = دعوت یا نشانی‌های پل
# Tor Bridges Settings
# Here "Message" is a verb, short for "Send a message to". This is an instruction to send a message to the given Telegram Messenger user to receive a new bridge.
# $telegramUserName (String) - The Telegram Messenger user name that should receive messages. Should be wrapped in '<a data-l10n-name="user">' and '</a>'.
# E.g. in English, "Message GetBridgesBot".
tor-bridges-provider-telegram-instruction = پیام به <a data-l10n-name="user">{ $telegramUserName }</a>
# User provided bridge dialog.
# Used when the user has no existing bridges.
user-provide-bridge-dialog-add-title =
    .title = افزودن پل‌های جدید
# User provided bridge dialog.
# Used when the user is replacing their existing bridges with new ones.
user-provide-bridge-dialog-replace-title =
    .title = جایگزین‌کردن پل‌هایتان
# Tor Bridges Settings
# Shown at the start of a Tor bridge line, when the transport type is unknown (or "vanilla").
tor-bridges-type-prefix-generic = پل Tor:
# Tor Bridges Settings
# Text shown just before a description of the most recent change to the list of user's bridges. Some white space will separate this text from the change description.
# This text is not visible, but is instead used for screen reader users.
# E.g. in English this could be "Recent update: One of your Tor bridges has been removed."
tor-bridges-update-area-intro = به‌روزرسانی اخیر:
# User provided bridge dialog.
user-provide-bridge-dialog-next-button =
    .label = بعدی
# Tor Bridges Settings
tor-bridges-your-bridges = پل‌های شما
# Tor Bridges Settings
tor-bridges-none-added = هیچ پلی افزوده نشد
# Tor Bridges Settings
tor-bridges-source-user = افزوده‌شده به‌دستان شما
# Tor Bridges Settings
tor-bridges-source-requested = درخواست‌شده از Tor
# Tor Bridges Settings
# Toggle button for enabling and disabling the use of bridges.
tor-bridges-use-bridges =
    .label = استفاده از پل‌ها
# Tor Bridges Settings
# The "..." menu button for all current bridges.
tor-bridges-options-button =
    .title = همهٔ پل‌ها
# Tor Bridges Settings
# Here "Bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# This is shown when the user is getting their bridges from Lox.
tor-bridges-source-lox = مجوز پل
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can generate a QR code for all of their bridges.
tor-bridges-menu-item-qr-all-bridge-addresses = نمایش کد QR
    .accesskey = ‏Q
# Tor Bridges Settings
# Shown at the start of a Tor bridge line.
# $type (String) - The Tor bridge type ("snowflake", "obfs4", "meek-azure").
tor-bridges-type-prefix = پل { $type }:
# Tor Bridges Settings
# Only shown in the "..." menu for bridges added by the user.
tor-bridges-menu-item-edit-all-bridges = ویرایش پل‌ها
    .accesskey = و
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can copy all of their bridges.
tor-bridges-menu-item-copy-all-bridge-addresses = رونوشت از نشانی پل‌ها
    .accesskey = ر
# Tor Bridges Settings
# Shown in the "..." menu for all current bridges.
tor-bridges-menu-item-remove-all-bridges = حذف همهٔ پل‌ها
    .accesskey = ح
# Tor Bridges Settings
# Used when the bridge has no status, i.e. the *absence* of a status to report to the user. This is only visibly shown when the status cell has keyboard focus.
tor-bridges-status-none = بدون وضعیت
# Tor Bridges Settings
# The "..." menu button for an individual bridge row.
tor-bridges-individual-bridge-options-button =
    .title = گزینه‌های پل
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Shows the QR code for this one bridge.
tor-bridges-menu-item-qr-address = نمایش کد QR
    .accesskey = ‏Q
# Tor Bridges Settings
# Used for an image of a bridge emoji. Each bridge address can be hashed into four emojis shown to the user (bridgemoji feature). This string corresponds to a *single* such emoji. The "title" should just be emojiName. The "alt" should let screen readers know that the image is of a *single* emoji, as well as its name.
# $emojiName (String) - The name of the emoji, already localized.
tor-bridges-emoji-image =
    .alt = شکلک: { $emojiName }
    .title = { $emojiName }
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Copies the single bridge address to clipboard.
tor-bridges-menu-item-copy-address = رونوشت از نشانی پل
    .accesskey = ر
# Tor Bridges Settings
tor-bridges-copy-addresses-button = تهیهٔ رونوشت از نشانی‌ها
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Removes this one bridge.
tor-bridges-menu-item-remove-bridge = حذف پل
    .accesskey = ح
# Tor Bridges Settings
# Update text for screen reader users when their bridges have changed in some arbitrary way.
tor-bridges-update-changed-bridges = پل‌های Tor شما تغییر یافته‌اند.
# Tor Bridges Settings
tor-bridges-qr-addresses-button =
    .title = نمایش کد QR
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain access to invites for the first time.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-first-invites = دعوت‌ها برای مخاطبین مورد اعتمادتان
# Tor Bridges Settings
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-show-invites-button = نمایش دعوت‌ها
# Tor Bridges Settings
# Shown when the user has existing bridges.
# Opens a dialog where the user can provide a new bridge address or share code to replace their current bridges.
tor-bridges-replace-button = جایگزینی پل‌ها…
# Tor Bridges Settings
# Shown as a heading when the user has existing bridges that can be replaced.
tor-bridges-replace-bridges-heading = پل‌هایتان را جایگزین کنید
# Tor Bridges Settings
# Shown when the user has no current bridges.
# Opens a dialog where the user can provide a new bridge address or share code.
tor-bridges-add-new-button = افزودن پل‌های جدید…
# Tor Bridges Settings
tor-bridges-find-more-heading = یافتن پل‌های بیشتر
# Tor Bridges Settings
# Instructions to visit the given website.
# $url (String) - The URL for Tor Project bridges. Should be wrapped in '<a data-l10n-name"url">' and '</a>'.
tor-bridges-provider-web-instruction = بازدید از <a data-l10n-name="url">{ $url }</a>
# Tor Bridges Settings
tor-bridges-request-button = درخواست پل‌ها…
# User provided bridge dialog.
# Used when the user is editing their existing bridge addresses.
user-provide-bridge-dialog-edit-title =
    .title = پل‌هایتان را ویرایش کنید
# User provided bridge dialog.
# Generic error when an invite failed.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-generic-invite-error = فعال‌سازی کد دعوت ناموفق بود.
# Tor Bridges Settings
# Shown as a heading when the user has no current bridges.
tor-bridges-add-bridges-heading = افزودن پل‌ها
appmenuitem-new-tor-circuit =
    .label = مدار جدید Tor برای این سایت
toolbar-new-tor-circuit =
    .label = مدار جدید Tor برای این سایت
    .tooltiptext = { toolbar-new-tor-circuit.label }
tor-circuit-urlbar-button =
    .tooltiptext = مدار Tor
tor-circuit-panel-heading = مدار برای { $host }
tor-circuit-panel-alias = وصل‌شده به <a data-l10n-name="alias-link">{ $alias }</a>
tor-circuit-panel-node-list-introduction = مدار Tor
tor-circuit-panel-node-browser = این مرورگر
tor-circuit-panel-node-onion-relays = رله‌های سایت Onion
tor-circuit-panel-node-typed-bridge = پل: { $bridge-type }
tor-circuit-panel-node-bridge = پل
tor-circuit-panel-node-region-guard = ‎{ $region } (محافظ)
tor-circuit-panel-node-unknown-region = منطقهٔ ناشناخته
tor-circuit-panel-new-button = مدار جدید Tor برای این سایت
tor-circuit-panel-new-button-description-guard = گره محافظتان نباید تغییر کند
tor-circuit-panel-new-button-description-bridge = پل شما نباید عوض شود
# Tor Bridges Settings
# Update text for screen reader users when only one of their bridges has been removed.
tor-bridges-update-removed-one-bridge = یکی از پل‌های Tor شما حذف شده است.
# Tor Bridges Settings
# Update text for screen reader users when all of their bridges have been removed.
tor-bridges-update-removed-all-bridges = همهٔ پل‌های Tor شما پاک شدند.
# Tor Bridges Settings
tor-bridges-share-description = پل‌های خود را با مخاطبان مورد‌اعتماد به‌اشتراک بگذارید.
crypto-safety-prompt-title = نشانی رمزارز از وب‌سایت ناامنی رونوشت شده است
crypto-safety-prompt-body = به نظر می‌رسد متن رونوشت‌شده ({ $address }) یک نشانی رمزارز باشد.از آنجایی که اتصال به { $host } امن نیست، شاید نشانی دست‌کاری شده و نباید به آن اعتماد کرد. می‌توانید با استفاده از اتصال دوباره توسط یک مدار جدید، برای برقراری یک اتصال امن را تلاش کنید.
crypto-safety-prompt-reload-button = بارگذاری مجدد زبانه با یک مدار جدید
crypto-safety-prompt-dismiss-button = ردکردن هشدار
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-type-selector-label = نوع پراکسی
# Tor connection settings.
# Shown when the user is not connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-not-connected = متصل نیست
# Tor advanced settings.
tor-advanced-settings-heading = پیشرفته
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-name = Snowflake
# Tor connection settings.
# "Connection" refers to the Tor Browser's connection to the Tor network.
tor-connection-settings-heading = اتصال
# Tor connection settings.
# Prefix before the internet connection status.
# "Internet" is not a proper noun, but is capitalized because it is the start of a sentence.
tor-connection-internet-status-label = اینترنت:
# Warning dialog when removing all bridges.
remove-all-bridges-warning-description = درصورتی که این پل‌ها از torproject.org دریافت شده یا دستی افزوده شده‌اند، این عمل امکان بازگردانی ندارد
# Warning dialog when removing all bridges.
remove-all-bridges-warning-remove-button = حذف
# Common button used in bridge dialogs.
bridge-dialog-button-connect = متصل‌شدن
# Tor advanced settings.
# Button that opens the advanced connection settings dialog.
# Uses sentence case in English (US).
tor-advanced-settings-button = تنظیمات…
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-port-input-label = درگاه
# Tor connection settings.
# Button shown when we are not yet connected to the Tor network.
# It will open a page to start connecting to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connect-button = اتصال
# Common button used in bridge dialogs.
bridge-dialog-button-submit = ثبت
# Tor connection settings.
tor-connection-browser-learn-more-link = بیشتر بیاموزید
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-description = ارتباطتان را از طریق پراکسی‌های Snowflake مسیردهی می‌کند تا این‌طور به نظر آید که به‌عنوان مثال، درحال انجام یک تماس تصویری هستید.
# Tor connection settings.
tor-connection-quickstart-heading = شروع سریع
# Tor Bridges Settings.
tor-bridges-built-in-obfs4-description = کاری می‌کند که ترافیک شما در Tor مانند اطلاعات تصادفی به نظر برسد. ممکن است در مناطق به‌شدت سانسورشده کار نکند.
# Tor connection settings.
# Button to test the internet connection.
# Here "Test" is a verb, as in "test the internet connection".
# Uses sentence case in English (US).
tor-connection-internet-status-test-button = آزمودن
# Tor connection settings.
# Shown when the user is connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-online = آنلاین
# Tor connection settings.
# Shown when the user is not connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-offline = آفلاین
# Tor connection settings.
# Shown when the user is connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connected = وصل شده
# Tor connection settings.
# Shown when the user's Tor connection may be blocked.
# Uses sentence case in English (US).
tor-connection-network-status-blocked = بالقوه مسدود شده است
# Tor Bridges Settings.
tor-bridges-heading = پل‌ها
# Tor Bridges Settings.
tor-bridges-overview = پل‌ها در وصل شدن امن به شبکه Tor در جاهایی که مسدود است کمکتان می‌کنند. بسته به این که کجایید، ممکن است پلی بهتر از پل دیگر کار کند.
# Tor Bridges Settings.
tor-bridges-learn-more-link = بیشتر بیاموزید
# Tor Bridges Settings.
# "obfs4" is a technical name, and likely should not be translated.
tor-bridges-built-in-obfs4-name = obfs4
# Tor Bridges Settings.
# "meek-azure" is a technical name, and likely should not be translated.
tor-bridges-built-in-meek-azure-name = meek-azure
# Tor Bridges Settings.
tor-bridges-built-in-meek-azure-description = این‌طور به نظر می‌رساند که به‌جای استفاده از Tor، به یکی از سایت‌های مایکروسافت وصل شده‌اید. ممکن است در مناطق به‌شدت سانسور‌شده جواب‌گو باشد، ولی معمولاً بسیار کند است.
# Warning dialog when removing all bridges.
remove-all-bridges-warning-title = همهٔ پل‌ها حذف شوند؟
# Common button used in bridge dialogs.
bridge-dialog-button-accept = تأیید
# Built-in bridges dialog.
request-bridge-dialog-top-wait = درحال تماس با BridgeDB. لطفاً منتظر بمانید.
# Built-in bridges dialog.
request-bridge-dialog-top-solve = برای درخواست یک پل، کپچا را حل کنید.
# Built-in bridges dialog.
request-bridge-dialog-captcha-failed = راه‌حل درست نیست. لطفاً دوباره تلاش کنید.
# Tor advanced connection settings dialog.
# "address" is a noun, referring to an network IP address.
tor-advanced-dialog-proxy-address-input-label = نشانی
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input-label = نام کاربری
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input-label = گذرواژه
tor-connection-quickstart-checkbox =
    .label = همیشه به‌صورت خودکار وصل شو
bridge-qr-dialog-title =
    .title = کد QR را اسکن کنید
built-in-dialog-title =
    .title = یک پل توکار انتخاب کنید
built-in-dialog-snowflake-radio-option =
    .label = Snowflake
built-in-dialog-meek-azure-radio-option =
    .label = meek-azure
request-bridge-dialog-title =
    .title = درخواست پل
request-bridge-dialog-captcha-input =
    .placeholder = نوسیه‌های موجود در تصویر را وارد کنید
tor-log-dialog-copy-button-copied =
    .label = رونویسی شد!
tor-advanced-dialog-proxy-socks4-menuitem =
    .label = ‏SOCKS4
tor-advanced-dialog-proxy-socks5-menuitem =
    .label = SOCKS5
tor-advanced-dialog-proxy-http-menuitem =
    .label = ‏HTTP/HTTPS
tor-advanced-dialog-proxy-address-input =
    .placeholder = نشانی IP یا نام میزبان
tor-advanced-dialog-proxy-username-input =
    .placeholder = اختیاری
tor-advanced-dialog-proxy-password-input =
    .placeholder = اختیاری
tor-advanced-dialog-firewall-checkbox =
    .label = ارتباطات این رایانه از طریق یک فایروال عبور می‌کند که تنها اجازه اتصال به درگاه‌های مشخصی را می‌دهد
tor-advanced-dialog-firewall-ports-input =
    .placeholder = مقدارهای جدا‌شده با ویرگول
downloads-tor-warning-title = در بازکردن بارگیری‌ها احتیاط کنید
downloads-tor-warning-description = برخی فایل‌ها هنگام بازکردن ممکن است بدون استفاده از Tor به اینترنت وصل شوند. برای ایمنی، این فایل‌ها را هنگام آفلاین بودن یا با استفاده از یک سیستم‌عامل قابل حمل همچون <a data-l10n-name="tails-link">Tails</a> باز کنید.
downloads-tor-warning-dismiss-button = موجه شدم
rulesets-warning-heading = با احتیاط ادامه دهید
rulesets-warning-description = افزودن یا تغییر قوانین می‌تواند باعث شود که مهاجمان مرورگر شما را بربایند. فقط درصورتی که می‌دانید درحال انجام چه کاری هستید، ادامه دهید.
rulesets-warning-checkbox = هنگامی که من برای دسترسی به این تنظیمات پیشرفته تلاش می‌کنم به من هشدار بده
rulesets-warning-continue-button = خطر را بپذیرید و ادامه دهید
rulesets-side-panel-heading = مجموعهٔ قوانین
rulesets-side-panel-no-rules = هیچ مجموعهٔ قانونی پیدا نشد
rulesets-update-last = آخرین به‌روزرسانی در { DATETIME($date, dateStyle: "long") }
rulesets-update-never = هرگز به‌روزرسانی نشده است، یا آخرین به‌روزرسانی ناموفق بوده است
rulesets-update-rule-disabled = غیرفعال
rulesets-details-edit-button = ویرایش
rulesets-details-enable-checkbox = این مجموعهٔ قوانین را فعال کنید
rulesets-details-update-button = به‌روزرسانی‌ها را بررسی کنید
rulesets-details-save-button = ذخیره
rulesets-details-cancel-button = لغو
rulesets-details-jwk-input =
    .placeholder = کلید مورد استفاده برای امضا این مجموعهٔ قوانین در قالب JWK ‏(JSON Web Key)
rulesets-details-jwk-input-invalid = JWK نتوانست تجزیه شود، یا اینکه آن یک کلید معتبر نیست
rulesets-details-path = پیشوند مسیر
rulesets-details-path-input =
    .placeholder = پیشوند نشانی که حاوی فایل‌های مورد نیاز مجموعهٔ قوانین است
rulesets-details-path-input-invalid = پیشوند مسیر، یک URL معتبر HTTP(S) نیست
rulesets-details-scope = دامنه
rulesets-details-scope-input =
    .placeholder = عبارت باقاعده در قلمرو قوانین
rulesets-details-scope-input-invalid = دامنه را نمی‌توان به‌عنوان یک عبارت باقاعده تجزیه کرد
onion-neterror-not-found-description = دلیل احتمالی آن است که سایت Onion آفلاین است. با مدیر سایت Onion تماس بگیرید.
onion-neterror-unreachable-description = سایت Onion به دلیل خطای داخلی قابل دسترسی نیست.
onion-neterror-disconnected-description = احتمالاً دلیل آن این است که سایت Onion آفلاین است. با مدیر سایت Onion تماس بگیرید.
onion-neterror-connection-failed-description = سایت Onion مشغول بوده یا بار روی شبکهٔ Tor بیش از حد است. بعداً دوباره تلاش کنید.
onion-neterror-missing-authentication-description = دسترسی به سایت Onion نیازمند یک کلید است، ولی هیچ کلیدی ارائه نشده است.
onion-neterror-incorrect-authetication-description = کلید ارائه‌شده نادرست بوده یا باطل ‌شده است. با مدیر سایت Onion تماس بگیرید.
onion-neterror-invalid-address-description = نشانی سایت Onion ارائه‌شده نامعتبر است. لطفاً بررسی کنید که به‌درستی آن را وارد کرده‌‌اید.
onion-neterror-timed-out-description = اتصال به سایت Onion ناموفق بود، احتمالاً به‌خاطر اتصال ضعیف شبکه.
# Tor connection settings.
# Prefix before the Tor network connection status.
# Uses sentence case in English (US).
tor-connection-network-status-label = شبکهٔ Tor:
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input-label = درگاه‌های مجاز
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk = JWK
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-authorization-title = نیازمند اصالت‌سنجی
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-disconnected-header = سایت Onion قطع شد
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-invalid-address-header = نشانی نامعتبر سایت Onion
# Tor Bridges Settings.
# This is shown as a list item after "N days until you unlock:" when the user already has invites.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-more-invites = دعوت‌های بیشتر برای مخاطبین مورد اعتمادتتان
# User provided bridge dialog.
# Error shown when the user has mixed their invite with addresses.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-mixed-error = نمی‌توان نشانی پل‌ها را با یک دعوت ترکیب کرد.
# User provided bridge dialog.
# Error shown when the user has entered more than one "bridge pass" invite.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-multiple-invites-error = نمی‌تواند شامل بیش از یک دعوت باشد.
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-title =
    .title = گزارش Tor
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
# Uses sentence case in English (US).
tor-view-log-button = مشاهدهٔ گزارش…
# Built-in bridges dialog.
# "obfs4" is a technical name, and likely should not be translated.
built-in-dialog-obfs4-radio-option =
    .label = obfs4
# Tor advanced connection settings dialog.
tor-advanced-dialog-title =
    .title = تنظیمات اتصال
# Built-in bridges dialog.
# Label attached to the built-in bridge option that is already in use.
# The "aria-label" should use the same text, but include some ending punctuation to separate it from the sentence that follows. This is used for screen reader users.
built-in-dialog-current-bridge-label = پل کنونی
    .aria-label = پل کنونی.
# User provided bridge dialog.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-connecting = درحال اتصال به سرور مجوز پل…
# User provided bridge dialog.
# Placeholder shown when adding new bridge addresses.
user-provide-bridge-dialog-textarea-addresses =
    .placeholder = نشانی پل‌هایتان را اینجا جای‌گذاری کنید
# Tor Bridges Settings.
# Shown when the user's "bridge pass" has been upgraded.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
tor-bridges-lox-upgrade = مجوز پل شما ارتقا یافت!
# Tor Bridges Settings.
# Shown when the user's bridges accessed through "bridge pass" have been blocked.
tor-bridges-lox-blocked = پل‌های مسدودتان جایگزین شدند
# Tor Bridges Settings.
# Shown *after* the user has had their blocked bridges replaced.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-new-bridges = پل‌های جدید از ربات پل
# Tor Bridges Settings.
# Shown *after* the user has gained two more bridges.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-gained-two-bridges = +۲ پل دیگر از ربات پل
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-not-found-header = سایت Onion پیدا نشد
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-missing-authentication-header = سایت Onion نیازمند اصالت‌سنجی است
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-incorrect-authentication-header = اصالت‌سنجی سایت Onion ناموفق بود
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-unreachable-header = نمی‌توان به سایت Onion دسترسی پیدا کرد
# Tor Bridges Settings.
# This is shown as a list item after "N days until you unlock:" when the user will gain two more bridges in the future.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-unlock-two-bridges = +۲ پل دیگر از ربات پل
# Tor Bridges Settings.
tor-bridges-add-addresses-description = نشانی پل‌هایی که از پیش می‌دانید را وارد کنید
# User provided bridge dialog.
# Error shown when the user has entered an invite when it is not supported.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
user-provide-bridge-dialog-invite-not-allowed-error = نمی‌تواند شامل یک دعوت مجوز پل باشد.
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
# "Circuit" refers to a Tor network circuit.
onion-neterror-timed-out-header = مهلت ایجاد مدار سایت Onion به سر رسید
# Tor connection settings.
# Shown when testing the internet status.
# Uses sentence case in English (US).
tor-connection-internet-status-testing = آزمودن…
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-view-log-description = بازدید از گزارش Tor.
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-page-title = مشکل در بارگذاری سایت Onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-connection-failed-header = اتصال به سایت Onion امکان‌پذیر نیست
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-copy-button =
    .label = رونوشت از گزارش Tor به کلیپ‌بورد
# User provided bridge dialog.
# Error shown when the "bridge pass" server does not respond.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-no-server-error = اتصال به سرور مجوز پل امکان‌پذیر نیست.
# User provided bridge dialog.
# Shown after the user has entered a "bridge pass" invite.
user-provide-bridge-dialog-result-invite = پل‌های زیر با شما اشتراک‌گذاری شده‌اند.
# User provided bridge dialog.
# Shown after the user has entered bridge addresses.
user-provide-bridge-dialog-result-addresses = پل‌های زیر به‌دستان شما وارد شده‌اند.
# Tor Bridges Settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-bridges-select-built-in-description = یکی از پل‌های توکار { -brand-short-name } را انتخاب کنید
# User provided bridge dialog.
# Error shown when the invite was not accepted by the server.
user-provide-bridge-dialog-bad-invite-error = دعوت پذیرفته نشد. یکی دیگر را امتحان کنید.
# User provided bridge dialog.
# Description shown when adding new bridges, replacing existing bridges, or editing existing bridges.
user-provide-bridge-dialog-description = از پل‌هایی استفاده کنید که توسط یک سازمان قابل اعتماد یا فردی که می‌شناسید، ارائه شده‌اند.
# User provided bridge dialog.
# Error shown when one of the address lines is invalid.
# $line (Number) - The line number for the invalid address.
user-provide-bridge-dialog-address-error = نشانی پل با قالب‌بندی نادرست در خط { $line }.
# New tor circuit.
# Shown in the File menu.
# Uses title case for English (US).
menu-new-tor-circuit =
    .label = مدار جدید Tor برای این سایت
    .accesskey = م
# Side panel in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# -brand-short-name refers to 'Tor Browser', localized.
rulesets-side-panel-no-rules-description = وقتی یک مجموعهٔ قوانین را در ‎{ -brand-short-name } ذخیره می‌کنید، در اینجا نشان داده می‌شود.
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-quickstart-description = شروع سریع ‎{ -brand-short-name } را هنگام راه‌اندازی، براساس آخرین تنظیمات اتصال استفاده‌شده توسط شما، به‌صورت خودکار به شبکهٔ Torمتصل می‌کند.
# Tor advanced connection settings dialog.
tor-advanced-dialog-introduction = نحوهٔ اتصال { -brand-short-name } به اینترنت را تنظیم کنید.
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-checkbox =
    .label = من از پراکسی برای اتصال به اینترنت استفاده می‌کنم
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-overview = { -brand-short-name } ترافیک شما را از طریق شبکه Tor که توسط هزاران داوطلب در سراسر جهان اداره می شود، هدایت می کند.
# Built-in bridges dialog.
# -brand-short-name refers to 'Tor Browser', localized.
built-in-dialog-introduction = ‎{ -brand-short-name } شامل انواع خاصی از پل‌ها است که به‌عنوان «حامل‌های انتقال‌پذیر» شناخته می‌شوند، که می‌توانند به پنهان‌کردن این حقیقت که از Tor استفاده می‌کنید کمک کنند.
# Tor advanced settings.
tor-advanced-settings-description = نحوهٔ اتصال ‎{ -brand-short-name } به اینترنت را پیکربندی کنید.
# Tor Bridges Settings.
tor-bridges-request-from-browser = همچنین می‌توانید از ربات پل بدون ترک ‎{ -brand-short-name }، پل‌ها را دریافت کنید.
# Tor Bridges Settings.
# "Tor Project" is the organisation name.
tor-bridges-find-more-description = ازآنجایی‌که بسیاری از پل‌ها عمومی نیستند، ممکن است لازم باشد تعدادی پل از پروژهٔ Tor درخواست کنید.
# Tor Bridges Settings.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-remaining-invites =
    { $numInvites ->
        [one] { $numInvites } دعوت باقی‌مانده
       *[other] { $numInvites } دعوت باقی‌مانده
    }
# Tor Bridges Settings.
# The number of days until the user's "bridge pass" is upgraded.
# $numDays (Number) - The number of days until the next upgrade, an integer (1 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numDays". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numDays is "1" (singular) and the second form will be used if $numDays is anything else (plural).
tor-bridges-lox-days-until-unlock =
    { $numDays ->
        [one] { $numDays } روز تا باز‌کردن قفل:
       *[other] { $numDays } روز تا باز‌کردن قفل:
    }
# Tor Bridges Settings.
# Shown when using a "bridge pass", i.e. using Lox.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-description = با مجوز پل، هنگامی که پل‌های شما مسدود می‌شوند، ربات پل، پل‌های جدیدی را برای شما ارسال می‌کند. اگر پل‌های شما مسدود نشدند، قفل دعوت‌هایی را باز خواهید کرد که به شما امکان داده پل‌ها را با مخاطبین مورد اعتماد اشتراک‌گذاری کنید.
# Tor Bridges Settings.
# Shown *after* a user's "bridge pass" has changed.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-new-invites =
    { $numInvites ->
        [one] اکنون { $numInvites } دعوت باقی‌مانده برای مخاطبین قابل‌اعتمادتان دارید
       *[other] اکنون { $numInvites } دعوت باقی‌مانده برای مخاطبین قابل‌اعتمادتان دارید
    }
# User provided bridge dialog.
# Placeholder shown when the user can add new bridge addresses or a single "bridge pass" invite.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
# NOTE: "invite" is singular, whilst "addresses" is plural.
user-provide-bridge-dialog-textarea-addresses-or-invite =
    .placeholder = نشانی پل‌ها یا یک دعوت مجوز پل خود را اینجا جای‌گذاری کنید
tor-connection-settings-category =
    .tooltiptext = { tor-connection-settings-heading }
onion-site-authentication-prompt-learn-more = بیشتر بیاموزید
onion-site-authentication-prompt-remember-checkbox =
    .label = این کلید را به‌خاطر بسپار
onion-site-authentication-prompt-invalid-key = لطفاً یک کلید معتبر وارد کنید (۵۲ نویسهٔ مبنای۳۲ یا ۴۴ نویسهٔ مبنای۶۴)
onion-site-authentication-prompt-setting-key-failed = پیکربندی Tor با کلید شما امکان‌پذیر نیست
onion-site-authentication-preferences-learn-more = بیشتر بیاموزید
onion-site-saved-keys-dialog-table-header-key =
    .label = کلید
onion-site-saved-keys-dialog-remove-button = حذف
onion-site-saved-keys-dialog-remove-keys-error-message = حذف کلید ناموفق بود
downloads-tor-warning-message-bar =
    .heading = در بازکردن بارگیری‌ها هشیار باشید
    .message = برخی فایل‌ها هنگام بازشدن ممکن است بدون استفاده از Tor، به اینترنت وصل شوند. برای ایمن‌ماندن، فایل‌ها را هنگام آفلاین‌بودن یا با استفاده از سیستم‌عامل‌های قابل حملی چون Tails باز کنید.
downloads-tor-warning-tails-link = در مورد Tails بیشتر بیاموزید
onion-site-authentication-preferences-saved-keys-button = کلیدهای ذخیره‌شده…
onion-site-saved-keys-dialog-remove-all-button = حذف همه
onion-site-saved-keys-dialog-fetch-keys-error-message = بازیابی کلیدها از Tor امکان‌پذیر نیست
page-info-onion-site-encryption-plain = اتصال رمزگذاری شد (سایت Onion)
onion-site-authentication-preferences-heading = اصالت‌سنجی سایت Onion
onion-site-authentication-preferences-overview = برخی سایت‌های Onion نیاز دارند تا خودتان را با یک کلید (نوعی گذرواژه) پیش از دسترسی به آن‌ها شناسایی کنید.
onion-site-saved-keys-dialog-table-header-site =
    .label = سایت Onion
onion-site-authentication-urlbar-button =
    .tooltiptext = پانل اصالت‌سنجی سایت Onion را باز کنید
onion-site-authentication-prompt-description = سایت Onion‏ { $onionsite } اصالت‌سنجیتان را درخواست می‌کند.
onion-site-authentication-prompt-key-input =
    .placeholder = کلید خصوصیتان برای سایت Onion را وارد کنید
onion-site-authentication-prompt-ok-button =
    .label = قبول
    .accesskey = ق
onion-site-authentication-prompt-cancel-button =
    .label = لغو
    .accesskey = ل
onion-site-saved-keys-dialog-title =
    .title = کلیدهای سایت Onion
onion-site-saved-keys-dialog-intro = کلیدهای سایت Onion زیر روی رایانه‌ٔتان ذخیره شده‌اند.
page-info-onion-site-encryption-with-bits = اتصال رمزگذاری شده است (سایت Onion* { $encryption-type }، کلیدهای { NUMBER($encryption-strength, useGrouping: "false") } بیتی، { $encryption-version })
dropped-support-notification-macos-version-less-than-10-15-extended-13-5 = نسخهٔ ‎ { -brand-short-name } 13.5 فقط برای مدتی محدود به‌روزرسانی‌های امنیتی را دریافت خواهد کرد. لطفاً برای دریافت جدیدترین نسخه‌های ‎{ -brand-short-name } به نسخهٔ ۱۰.۱۵ یا بالاتر macOS ارتقا دهید.
dropped-support-notification-win-os-version-less-than-10-extended-13-5 = نسخهٔ ‎{ -brand-short-name } 13.5 فقط برای مدتی محدود به‌روزرسانی‌های امنیتی را دریافت خواهد کرد. لطفاً برای دریافت جدیدترین نسخه‌های ‎{ -brand-short-name } به نسخهٔ ۱۰ یا بالاتر ویندوز ارتقا دهید.
tor-connection-internet-status-unknown = وضعیت ناشناخته
tor-log-dialog-table =
    .aria-label = { tor-log-dialog-title.title }
bridge-dialog-button-connect2 =
    .label = اتصال
bridge-dialog-button-accept2 =
    .label = قبول
bridge-dialog-button-submit2 =
    .label = ثبت
tor-connection-automatic-heading = اتصال به‌صورت خودکار
tor-connection-automatic-description = هنگام راه‌اندازی، به‌صورت خودکار با استفاده از تنظیمات اتصال کنونی، به شبکهٔ Tor متصل شود.
tor-settings-failed-notification-button-fix-myself = خودم درستش می‌کنم
tor-settings-failed-notification-title-bridges = تنظیمات پل Tor شما نتوانست اعمال شود
tor-settings-failed-notification-cause-bridges = این ممکن است به‌دلیل وارد‌کردن نشانی نامعتبر پل باشد.
tor-settings-failed-notification-title-proxy = تنظیمات پراکسی Tor شما نتوانست اعمال شود
tor-settings-failed-notification-cause-proxy = این ممکن است به‌دلیل اطلاعات نامعتبر پراکسی باشد.
tor-settings-failed-notification-title-firewall = تنظیمات فایروال Tor شما نتوانست اعمال شود
tor-settings-failed-notification-cause-firewall = این ممکن است به‌دلیل اطلاعات نامعتبر فایروال باشد.
tor-settings-failed-notification-body-undo = تا زمان برطرف‌شدن مشکل، اتصال Tor شما همچنان از تنظیمات قبلی استفاده خواهد کرد. شما می‌توانید آخرین تغییرات را به تنظیمات کاری قبلی بازگردانی کنید یا با بررسی گزارش Tor مشکل را خودتان برطرف کنید.
tor-settings-failed-notification-body-default = تا زمان برطرف‌شدن مشکل، اتصال Tor شما همچنان از تنظیمات پیش‌فرض استفاده خواهد کرد. می‌توانید تنظیمات مشکل‌ساز را پاک کرده تا به حالت پیش‌فرض برگردد یا با بررسی گزارش Tor مشکل را خودتان برطرف کنید.
tor-settings-failed-notification-button-undo = لغو تغییرات
tor-settings-failed-notification-button-clear = پاک‌کردن
built-in-dialog-meek-radio-option2 =
    .label = { tor-bridges-built-in-meek-name }
built-in-dialog-obfs4-radio-option2 =
    .label = { tor-bridges-built-in-obfs4-name }
tor-bridges-built-in-meek-name = meek
built-in-dialog-snowflake-radio-option2 =
    .label = { tor-bridges-built-in-snowflake-name }
tor-bridges-built-in-meek-description = شما را از طریق یک ارائه‌دهنده بزرگ خدمات ابری به شبکه Tor متصل می‌کند. ممکن است در منطقه‌هایی با سانسور شدید کار کند، اما معمولا بسیار کند است.
yec-donate-button = هم‌اکنون حمایت کنید
yec-close-button =
    .title = بستن
yec2025-title = اینترنت را آزاد کنید
yec2025-body = از ابزارهایی که زنجیر سانسور و نظارت را می‌شکنند، پشتیبانی کنید. <b data-l10n-name="highlight">همین امروز به پروژهTor کمک مالی کنید.</b>
yec2025-matching = تا ۳۱ دسامبر، هدیه شما تا سقف ۲۵۰،۰۰۰ دلار تطبیق داده خواهد شد!
