# Tor browser manual link shown in the menu bar.
# Uses Title case.
menu-open-tor-manual =
    .label = Doracak Shfletuesi Tor
    .accesskey = D
tor-browser-home-heading-stable = Eksploroni. Privatisht.
tor-browser-home-heading-testing = Testojeni. Plotësisht.
tor-browser-home-duck-duck-go-input =
    .placeholder = Kërko me DuckDuckGo
tor-browser-home-message-introduction = Jeni gati për shfletimin më privat në botë.
# Tor browser manual link shown in the application menu (aka: hamburger menu).
# Uses Sentence case.
appmenu-open-tor-manual =
    .label = Doracak Shfletuesi Tor
    .accesskey = d
# Tor Browser home page.
# Toggle to switch from DuckDuckGo's plain ".com" domain to its ".onion" domain.
tor-browser-home-onionize-toggle =
    .label = Onion-izojeni
    .title = Kërkoni duke përdorur sajtin Onion
# Tor Browser home page.
# Only shown when underlying Tor process was not started by Tor Browser.
# "Tails" refers to the operating system, and should be translated as a brand name.
# <a data-l10n-name="tor-check-link"> should contain the link text and close with </a>.
tor-browser-home-tor-check-warning = Lidhja juaj me Tor-in nuk po administrohet nga Shfletuesi Tor. Disa sisteme operativë (Tails, fjala vjen) do ta bëjë këtë për ju, ose mund të keni ujdisur një formësim vetjak. <a data-l10n-name="tor-check-link">Testoni lidhjen tuaj</a>
# Shown in Home settings, corresponds to the default about:tor home page.
home-mode-choice-tor =
    .label = Shtëpia e Shfletuesit Tor
# Tor Browser home page.
tor-browser-home-message-donate = Tor-i mund të përdoret pa pagesë, falë dhurimeve nga persona si ju. <a data-l10n-name="donate-link">Dhuroni që tani</a>
# Tor Browser home page.
# Update message.
# <a data-l10n-name="update-link"> should contain the link text and close with </a>.
# $version (String) - The new tor browser version.
tor-browser-home-message-updated = Shfletuesi Tor është përditësuar me { $version }. <a data-l10n-name="update-link">Shihni ç’ka të re</a>
# Tor Browser home page.
tor-browser-home-message-testing = Ky është një version jo i qëndrueshëm i Shfletuesit Tor, për testim veçorish të reja. <a data-l10n-name="learn-more-link">Mësoni më tepër</a>
# Tor Browser home page.
tor-browser-home-message-news = Merrni lajmet më të reja nga Tor-i drejt e në email-in tuaj. <a data-l10n-name="news-link">Regjistrouni për lajme Tor</a>
# Tor Bridges Settings
tor-bridges-none-added = S’u shtuan ura
# Tor Bridges Settings
tor-bridges-your-bridges = Urat tuaja
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can generate a QR code for all of their bridges.
tor-bridges-menu-item-qr-all-bridge-addresses = Shfaq kod QR
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for all current bridges.
tor-bridges-menu-item-remove-all-bridges = Hiqi krejt urat
    .accesskey = H
# Tor Bridges Settings
# Shown when one of the built-in bridges is in use.
tor-bridges-built-in-status-connected = I lidhur
# Tor Bridges Settings
# Shown at the start of a Tor bridge line.
# $type (String) - The Tor bridge type ("snowflake", "obfs4", "meek-azure").
tor-bridges-type-prefix = Urë { $type }:
# Tor Bridges Settings
# Shown at the start of a Tor bridge line, when the transport type is unknown (or "vanilla").
tor-bridges-type-prefix-generic = Urë Tor:
# Tor Bridges Settings
# The "..." menu button for an individual bridge row.
tor-bridges-individual-bridge-options-button =
    .title = Mundësi ure
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain access to invites for the first time.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-first-invites = Ftesa prej kontaktesh tuajt të besuarve
# Tor Bridges Settings
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-remaining-invites =
    { $numInvites ->
        [one] Edhe { $numInvites } ftesë
       *[other] Edhe { $numInvites } ftesa
    }
# Tor Bridges Settings
tor-bridges-select-built-in-button = Përzgjidhni një urë të brendshme…
# Tor Bridges Settings
tor-bridges-add-addresses-description = Jepni adresa urash që e dini tashmë
# Tor Bridges Settings
# "Telegram" is the common brand name of the Telegram Messenger application
tor-bridges-provider-telegram-name = Telegram
# Tor Bridges Settings
# Here "Message" is a verb, short for "Send a message to". This is an instruction to send a message to the given Telegram Messenger user to receive a new bridge.
# $telegramUserName (String) - The Telegram Messenger user name that should receive messages. Should be wrapped in '<a data-l10n-name="user">' and '</a>'.
# E.g. in English, "Message GetBridgesBot".
tor-bridges-provider-telegram-instruction = Mesazh <a data-l10n-name="user">{ $telegramUserName }</a>
# Tor Bridges Settings
# "Gmail" is the Google brand name. "Riseup" refers to the Riseup organisation at riseup.net.
tor-bridges-provider-email-name = Gmail, ose Riseup
# Tor Bridges Settings
# Here "Email" is a verb, short for "Send an email to". This is an instruction to send an email to the given address to receive a new bridge.
# $address (String) - The email address that should receive the email.
# E.g. in English, "Email bridges@torproject.org".
tor-bridges-provider-email-instruction = Dërgo një email te { $address }
# Tor Bridges Settings
tor-bridges-request-button = Kërkoni ura…
# User provided bridge dialog.
# Used when the user is replacing their existing bridges with new ones.
user-provide-bridge-dialog-replace-title =
    .title = Zëvendësoni urat tuaja
# User provided bridge dialog.
# Description shown when adding new bridges, replacing existing bridges, or editing existing bridges.
user-provide-bridge-dialog-description = Përdorni ura të dhëna nga një ent i besuar, ose dikush që e njihni.
# User provided bridge dialog.
# "Learn more" link shown in the "Add new bridges"/"Replace your bridges" dialog.
user-provide-bridge-dialog-learn-more = Mësoni më tepër
# User provided bridge dialog.
# Error shown when the user has entered more than one "bridge pass" invite.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-multiple-invites-error = S’mund të përfshihet më tepër se një ftesë.
# User provided bridge dialog.
# Shown after the user has entered a "bridge pass" invite.
user-provide-bridge-dialog-result-invite = Urat vijuese qenë ndarë me ju.
# User provided bridge dialog.
# Shown after the user has entered bridge addresses.
user-provide-bridge-dialog-result-addresses = Urat vijuese qenë dhënë nga ju.
# User provided bridge dialog.
user-provide-bridge-dialog-next-button =
    .label = Pasuesi
# Tor Bridges Settings
# Toggle button for enabling and disabling the use of bridges.
tor-bridges-use-bridges =
    .label = Përdorni ura
# Tor Bridges Settings
tor-bridges-source-user = Shtuar nga ju
# Tor Bridges Settings
tor-bridges-source-built-in = E brendshme
# Tor Bridges Settings
tor-bridges-source-requested = Kërkuar nga Tor-i
# Tor Bridges Settings
# The "..." menu button for all current bridges.
tor-bridges-options-button =
    .title = Krejt urat
# Tor Bridges Settings
# The emoji name to show on hover when a bridge emoji's name is unknown.
tor-bridges-emoji-unknown = E panjohur
# Tor Bridges Settings
# Shown when the bridge has been used for the most recent Tor circuit, i.e. the most recent bridge we have connected to.
tor-bridges-status-connected = I lidhur
# Tor Bridges Settings
# Used when the bridge has no status, i.e. the *absence* of a status to report to the user. This is only visibly shown when the status cell has keyboard focus.
tor-bridges-status-none = S’ka gjendje
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Shows the QR code for this one bridge.
tor-bridges-menu-item-qr-address = Shfaq kod QR
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Copies the single bridge address to clipboard.
tor-bridges-menu-item-copy-address = Kopjo adresë ure
    .accesskey = K
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Removes this one bridge.
tor-bridges-menu-item-remove-bridge = Hiqe urën
    .accesskey = H
# Tor Bridges Settings
# Text shown just before a description of the most recent change to the list of user's bridges. Some white space will separate this text from the change description.
# This text is not visible, but is instead used for screen reader users.
# E.g. in English this could be "Recent update: One of your Tor bridges has been removed."
tor-bridges-update-area-intro = Përditësim së fundi:
# Tor Bridges Settings
# Shown for requested bridges and bridges added by the user.
tor-bridges-share-heading = Ndihmoni të tjerët të lidhen
# Tor Bridges Settings
tor-bridges-copy-addresses-button = Kopjo adresa
# Tor Bridges Settings
tor-bridges-qr-addresses-button =
    .title = Shfaq kod QR
# Tor Bridges Settings
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-show-invites-button = Shfaq ftesa
# Tor Bridges Settings
# Shown *after* the user has had their blocked bridges replaced.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-new-bridges = Ura të reja nga roboti i urave
# Tor Bridges Settings
# Shown *after* the user has gained two more bridges.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-gained-two-bridges = +2 ura nga roboti i urave
# Tor Bridges Settings
# Button for the user to acknowledge a change in their "bridge pass".
tor-bridges-lox-got-it-button = E mora vesh
# Tor Bridges Settings
# Shown as a heading when the user has no current bridges.
tor-bridges-add-bridges-heading = Shtoni ura
# Tor Bridges Settings
# Shown as a heading when the user has existing bridges that can be replaced.
tor-bridges-replace-bridges-heading = Zëvendësoni urat tuaja
# Tor Bridges Settings
# Shown when the user has no current bridges.
# Opens a dialog where the user can provide a new bridge address or share code.
tor-bridges-add-new-button = Shtoni ura të reja…
# Tor Bridges Settings
# Shown when the user has existing bridges.
# Opens a dialog where the user can provide a new bridge address or share code to replace their current bridges.
tor-bridges-replace-button = Zëvendësoni ura…
# Tor Bridges Settings
tor-bridges-find-more-heading = Gjeni më tepër ura
# Tor Bridges Settings
# "Tor Project" is the organisation name.
tor-bridges-find-more-description = Ngaqë mjaft adresa urash s’janë publike, mund t’ju duhet të kërkoni të tilla nga Projekti Tor.
# Tor Bridges Settings
# "Web" is the proper noun for the "World Wide Web".
tor-bridges-provider-web-name = Web
# Tor Bridges Settings
# Instructions to visit the given website.
# $url (String) - The URL for Tor Project bridges. Should be wrapped in '<a data-l10n-name"url">' and '</a>'.
tor-bridges-provider-web-instruction = Vizitoni <a data-l10n-name="url">{ $url }</a>
# Tor Bridges Settings
tor-bridges-request-from-browser = Mundet të merrni ura edhe nga roboti i urave, pa dalë nga { -brand-short-name }.
# User provided bridge dialog.
# Used when the user is editing their existing bridge addresses.
user-provide-bridge-dialog-edit-title =
    .title = Përpunoni urat tuaja
# User provided bridge dialog.
# Used when the user has no existing bridges.
user-provide-bridge-dialog-add-title =
    .title = Shtoni ura të reja
# User provided bridge dialog.
# Short accessible name for the bridge addresses text area.
user-provide-bridge-dialog-textarea-addresses-label = Adresa urash
# User provided bridge dialog.
# Here "invite" is a noun, short for "invitation".
# Short accessible name for text area when it can accept either bridge address or a single "bridge pass" invite.
user-provide-bridge-dialog-textarea-addresses-or-invite-label = Adresa urash, ose ftesë
# User provided bridge dialog.
# Placeholder shown when adding new bridge addresses.
user-provide-bridge-dialog-textarea-addresses =
    .placeholder = Ngjitni këtu adresat e urave tuaja
# User provided bridge dialog.
# Error shown when the invite was not accepted by the server.
user-provide-bridge-dialog-bad-invite-error = Ftesa s’u pranua. Provoni një tjetër.
# User provided bridge dialog.
# Generic error when an invite failed.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-generic-invite-error = S’u arrit të përdoret ftesë.
# User provided bridge dialog.
# Error shown when one of the address lines is invalid.
# $line (Number) - The line number for the invalid address.
user-provide-bridge-dialog-address-error = Adresë ure e formësuar jo saktë te rreshti { $line }.
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can copy all of their bridges.
tor-bridges-menu-item-copy-all-bridge-addresses = Kopjo adresa ure
    .accesskey = K
# Tor Bridges Settings
# Only shown in the "..." menu for bridges added by the user.
tor-bridges-menu-item-edit-all-bridges = Përpunoni ura
    .accesskey = P
# Tor Bridges Settings
# Here "Bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# This is shown when the user is getting their bridges from Lox.
tor-bridges-source-lox = Lejekalim urash
# Tor Bridges Settings
# Used for an image of a bridge emoji. Each bridge address can be hashed into four emojis shown to the user (bridgemoji feature). This string corresponds to a *single* such emoji. The "title" should just be emojiName. The "alt" should let screen readers know that the image is of a *single* emoji, as well as its name.
# $emojiName (String) - The name of the emoji, already localized.
tor-bridges-emoji-image =
    .alt = Emoji: { $emojiName }
    .title = { $emojiName }
# Tor Bridges Settings
# Update text for screen reader users when only one of their bridges has been removed.
tor-bridges-update-removed-one-bridge = Një nga urat tuaja Tor është hequr.
# Tor Bridges Settings
# Update text for screen reader users when all of their bridges have been removed.
tor-bridges-update-removed-all-bridges = Janë hequr krejt urat tuaja Tor.
# Tor Bridges Settings
# Update text for screen reader users when their bridges have changed in some arbitrary way.
tor-bridges-update-changed-bridges = Urat tuaja Tor janë ndryshuar.
# Tor Bridges Settings
tor-bridges-share-description = Ndajini urat tuaja me kontakte të besuar.
# Tor Bridges Settings
# Shown when using a "bridge pass", i.e. using Lox.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-description = Me një lejekalim urash, roboti i urave do t’ju dërgojë ura, kur bllokohen urat tuaja. Nëse urat tuaja nuk bllokohen, do të shkyçni ftesa, që ju lejojnë të ndani ura me kontakte të besuar.
# Tor Bridges Settings
# The number of days until the user's "bridge pass" is upgraded.
# $numDays (Number) - The number of days until the next upgrade, an integer (1 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numDays". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numDays is "1" (singular) and the second form will be used if $numDays is anything else (plural).
tor-bridges-lox-days-until-unlock =
    { $numDays ->
        [one] { $numDays } ditë deri sa ta shkyçni:
       *[other] { $numDays } ditë deri sa ta shkyçni:
    }
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain two more bridges in the future.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-unlock-two-bridges = +2 ura nga roboti i urave
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user already has invites.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-more-invites = Më tepër ftesa për kontaktet tuaja të besuar
# Tor Bridges Settings
# Shown when the user's bridges accessed through "bridge pass" have been blocked.
tor-bridges-lox-blocked = Urat tuaja të bllokuara janë zëvendësuar
# Tor Bridges Settings
# Shown when the user's "bridge pass" has been upgraded.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
tor-bridges-lox-upgrade = Lejekalimi juaj i urave është përmirësuar!
# Tor Bridges Settings
# Shown *after* a user's "bridge pass" has changed.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-new-invites =
    { $numInvites ->
        [one] Keni edhe { $numInvites } ftesë për kontaktet tuaja të besuara
       *[other] Keni edhe { $numInvites } ftesa për kontaktet tuaja të besuara
    }
# Tor Bridges Settings
tor-bridges-select-built-in-description = Zgjidhni prej një nga urat e brendshme të { -brand-short-name }-it
# User provided bridge dialog.
# Placeholder shown when the user can add new bridge addresses or a single "bridge pass" invite.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
# NOTE: "invite" is singular, whilst "addresses" is plural.
user-provide-bridge-dialog-textarea-addresses-or-invite =
    .placeholder = Ngjitni këtu adresat e urave tuaja, ose një ftesë lejekalim urash
# User provided bridge dialog.
# Error shown when the user has mixed their invite with addresses.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-mixed-error = S’mund të përzihen adresa urash me një ftesë.
# User provided bridge dialog.
# Error shown when the user has entered an invite when it is not supported.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
user-provide-bridge-dialog-invite-not-allowed-error = S’mund të përfshihet një ftesë lejekalimi urash.
# User provided bridge dialog.
# Error shown when the "bridge pass" server does not respond.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-no-server-error = S’arrihet të lidhet me shërbyes lejekalimesh urash.
# User provided bridge dialog.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-connecting = Po lidhet me shërbyes lejekalimesh urash…
about-dialog-tor-project = { -brand-short-name } zhvillohet nga <label data-l10n-name="project-link"> { -vendor-short-name }</label>, një ent jofitimprurës që punon për të mbrojtur privatësinë tuaj dhe lirinë internetore.
about-dialog-help-out = Doni të ndihmoni? <label data-l10n-name="donate-link">Dhuroni</label> ose <label data-l10n-name="community-link">përfshihuni</label>!
about-dialog-questions-link = Pyetje?
about-dialog-grow-tor-network-link = Ndihmojeni rrjetin Tor të Fuqizohet!
about-dialog-browser-license-link = Të dhëna Licencimi
# Built-in bridges dialog.
# Label attached to the built-in bridge option that is already in use.
# The "aria-label" should use the same text, but include some ending punctuation to separate it from the sentence that follows. This is used for screen reader users.
built-in-dialog-current-bridge-label = Ura e tanishme
    .aria-label = Ura e tanishme.
menu-new-tor-circuit =
    .label = Qark i Ri Tor për këtë Sajt
    .accesskey = Q
appmenuitem-new-tor-circuit =
    .label = Qark të ri Tor për këtë sajt
toolbar-new-tor-circuit =
    .label = Qark të ri Tor për këtë sajt
    .tooltiptext = { toolbar-new-tor-circuit.label }
tor-circuit-urlbar-button =
    .tooltiptext = Qark TOR
tor-circuit-panel-heading = Qark për { $host }
tor-circuit-panel-alias = I lidhur me <a data-l10n-name="alias-link">{ $alias }</a>
tor-circuit-panel-node-list-introduction = Qark TOR
tor-circuit-panel-node-browser = Ky shfletues
tor-circuit-panel-node-onion-relays = Rele sajti Onion
tor-circuit-panel-node-typed-bridge = Urë: { $bridge-type }
tor-circuit-panel-node-bridge = Urë
tor-circuit-panel-node-region-guard = { $region } (guard)
tor-circuit-panel-node-unknown-region = Rajon i panjohur
tor-circuit-panel-new-button = Qark të ri Tor për këtë sajt
tor-circuit-panel-new-button-description-guard = Nyja juaj guard mund të mos ndryshojë
tor-circuit-panel-new-button-description-bridge = Ura juaj mund të mos ndryshojë
crypto-safety-prompt-title = Adresa e kriptomonedhës u kopjua prej një sajti jo të sigurt
crypto-safety-prompt-body = Teksti i kopjuar ({ $address }) duket të jetë një adresë kriptomonedhe. Ngaqë lidhja me { $host } s’është e siguruar, adresa mund të jetë ndryshuar dhe s’duhet besuar. Mund të provoni të vendosni një lidhje të siguruar duke u rilidhur me një qark të ri.
crypto-safety-prompt-reload-button = Ringarko Skedën me një Qark të Ri
crypto-safety-prompt-dismiss-button = Hidhe Tej Sinjalizimin
# Tor Bridges Settings.
tor-bridges-learn-more-link = Mësoni më tepër
# Common button used in bridge dialogs.
bridge-dialog-button-connect = Lidhu
# Common button used in bridge dialogs.
bridge-dialog-button-accept = OK
# Tor connection settings.
# "Connection" refers to the Tor Browser's connection to the Tor network.
tor-connection-settings-heading = Lidhje
# Tor connection settings.
tor-connection-browser-learn-more-link = Mësoni më tepër
# Tor connection settings.
tor-connection-quickstart-heading = Nisje e shpejtë
# Tor connection settings.
# Shown when the user is connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-online = I lidhur
# Tor connection settings.
# Shown when the user is not connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-offline = Jo i lidhur
# Tor connection settings.
# Shown when the user is connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connected = I lidhur
# Tor connection settings.
# Shown when the user is not connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-not-connected = Jo i lidhur
# Tor connection settings.
# Shown when the user's Tor connection may be blocked.
# Uses sentence case in English (US).
tor-connection-network-status-blocked = Potencialisht i bllokuar
# Tor connection settings.
# Button shown when we are not yet connected to the Tor network.
# It will open a page to start connecting to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connect-button = Lidhu
# Tor Bridges Settings.
tor-bridges-overview = Urat ju ndihmojnë të hyni në mënyrë të siguruar në rrjetin Tor në vende ku Tor-i është i bllokuar. Në varësi të vendit ku gjendeni, një urë mund të punojë më mirë se një tjetër.
# Tor Bridges Settings.
# "obfs4" is a technical name, and likely should not be translated.
tor-bridges-built-in-obfs4-name = obfs4
# Tor Bridges Settings.
tor-bridges-built-in-obfs4-description = E bën trafikun e Tor-it tuaj të duket si të dhëna kuturu. Mund të mos funksionojë në rajone shumë të censuruar.
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-name = Snowflake
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-description = E kalon lidhjen tuaj përmes ndërmjetësish Snowflake, për ta bërë të duket sikur po bëni një thirrje video, për shembull.
# Tor Bridges Settings.
# "meek-azure" is a technical name, and likely should not be translated.
tor-bridges-built-in-meek-azure-name = meek-azure
# Tor Bridges Settings.
tor-bridges-built-in-meek-azure-description = E bën të duket sikur po lidheni te një sajt Microsoft, në vend të përdorimit të Tor-it. Mund të funksionojë në rajone të censuruara, por zakonisht është shumë e ngadaltë.
# Warning dialog when removing all bridges.
remove-all-bridges-warning-title = Të hiqen krejt urat?
# Warning dialog when removing all bridges.
remove-all-bridges-warning-description = Nëse këto ura qenë marrë nga torproject.org, ose qenë shtuar dorazi, ky veprim s’mund të zhbëhet
# Built-in bridges dialog.
request-bridge-dialog-top-wait = Po lidhet me BridgeDB. Ju lutemi, Pritni.
# Built-in bridges dialog.
request-bridge-dialog-top-solve = Që të kërkoni një urë, zgjidhni CAPTCHA-n.
# Built-in bridges dialog.
request-bridge-dialog-captcha-failed = Zgjidhja s’është e saktë. Ju lutemi, riprovoni.
# Tor advanced settings.
tor-advanced-settings-heading = Të mëtejshme
# Tor advanced settings.
# Button that opens the advanced connection settings dialog.
# Uses sentence case in English (US).
tor-advanced-settings-button = Rregullime…
# Tor advanced connection settings dialog.
# "address" is a noun, referring to an network IP address.
tor-advanced-dialog-proxy-address-input-label = Adresë
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-port-input-label = Portë
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input-label = Emër përdoruesi
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input-label = Fjalëkalim
# Tor connection settings.
# Prefix before the internet connection status.
# "Internet" is not a proper noun, but is capitalized because it is the start of a sentence.
tor-connection-internet-status-label = Internet:
# Tor connection settings.
# Button to test the internet connection.
# Here "Test" is a verb, as in "test the internet connection".
# Uses sentence case in English (US).
tor-connection-internet-status-test-button = Testoje
# Tor Bridges Settings.
tor-bridges-heading = Ura
# Warning dialog when removing all bridges.
remove-all-bridges-warning-remove-button = Hiqe
# Common button used in bridge dialogs.
bridge-dialog-button-submit = Parashtroje
tor-connection-quickstart-checkbox =
    .label = Lidhu përherë automatikisht
bridge-qr-dialog-title =
    .title = Skanoni kodin QR
built-in-dialog-title =
    .title = Përzgjidhni një Urë të Brendshme
built-in-dialog-snowflake-radio-option =
    .label = Snowflake
built-in-dialog-meek-azure-radio-option =
    .label = meek-azure
request-bridge-dialog-title =
    .title = Kërkoni Urë
request-bridge-dialog-captcha-input =
    .placeholder = Jepni shenjat prej figure
tor-log-dialog-copy-button-copied =
    .label = U kopjua!
tor-advanced-dialog-proxy-socks4-menuitem =
    .label = SOCKS4
tor-advanced-dialog-proxy-socks5-menuitem =
    .label = SOCKS5
tor-advanced-dialog-proxy-http-menuitem =
    .label = HTTP/HTTPS
tor-advanced-dialog-proxy-address-input =
    .placeholder = Adresë IP ose emërstrehë
tor-advanced-dialog-proxy-username-input =
    .placeholder = Opsional
tor-advanced-dialog-proxy-password-input =
    .placeholder = Opsional
tor-advanced-dialog-firewall-checkbox =
    .label = Ky kompjuter filtrohet nga një firewall që lejon vetëm lidhje te disa porta të caktuara
tor-advanced-dialog-firewall-ports-input =
    .placeholder = Vlera të ndara me presje
downloads-tor-warning-title = Jini i kujdesshëm, kur hapni shkarkime
downloads-tor-warning-description = Disa kartela mund të lidhen në internet, kur hapen pa përdorur Tor-in. Për të qenë të parrezik, hapini kartelat teksa jeni jashtë interneti, ose përdorni një sistem operativ të bartshëm, fjala vjen, <a data-l10n-name="tails-link">Tails</a>.
downloads-tor-warning-dismiss-button = E mora vesh
rulesets-warning-heading = Vazhdoni me Kujdes
rulesets-warning-description = Shtimi ose ndryshimi i grupeve të rregullave mund të sjellë marrjen peng të shfletuesit tuaj nga agresorë. Ecni më tej vetëm nëse e dini se ç’po bëni.
rulesets-warning-checkbox = Sinjalizomë, kur përpiqem të prek këto parapëlqime
rulesets-warning-continue-button = Pranoni Rrezikun dhe Vazhdoni
rulesets-side-panel-heading = Grupe rregullash
rulesets-side-panel-no-rules = S’u gjetën grupe rregullash
rulesets-update-last = Përditësuar së fundi më { DATETIME($date, dateStyle: "long") }
rulesets-update-never = Pa u përditësuar ndonjëherë, ose përditësimi i fundit dështoi
rulesets-update-rule-disabled = I çaktivizuar
rulesets-details-edit-button = Përpunojeni
rulesets-details-enable-checkbox = Aktivizoje këtë grup rregullash
rulesets-details-update-button = Kontrollo për Përditësime
rulesets-details-save-button = Ruaje
rulesets-details-cancel-button = Anuloje
rulesets-details-jwk-input =
    .placeholder = Kyçi i përdorur për të nënshkruar këtë grup rregullash, në formatin (Kyç Web JSON)
rulesets-details-jwk-input-invalid = S’u përtyp dot JWK, ose s’është kyç i pavlefshëm
rulesets-details-path = Parashtesë Shtegu
rulesets-details-path-input =
    .placeholder = Parashtesë URL-je që përmban kartelat e nevojshme nga grupi i rregullave
rulesets-details-path-input-invalid = Parashtesa e shtegut s’është URL HTTP(S) e vlefshme
rulesets-details-scope = Fushëveprim
rulesets-details-scope-input =
    .placeholder = Shprehje e rregullt për fushëveprimin e rregullave
rulesets-details-scope-input-invalid = Fushëveprimi s’u përtyp dot si një shprehje e rregullt
onion-neterror-not-found-description = Shkaku më i mundshëm është që sajti onion të jetë jashtë linje. Lidhuni me përgjegjësin e sajtit onion.
onion-neterror-unreachable-description = Sajti onion s’kapet dot, për shkak të një gabimi të brendshëm.
onion-neterror-disconnected-description = Shkaku më i mundshëm është që sajti onion të jetë jashtë linje. Lidhuni me përgjegjësin e sajtit onion.
onion-neterror-connection-failed-description = Sajti onion është i zënë, ose rrjeti Tor është i mbingarkuar. Riprovoni më vonë.
onion-neterror-missing-authentication-description = Hyrja te sajti onion lyp një kyç, por s’u dha ndonjë i tillë.
onion-neterror-incorrect-authetication-description = Kyçi i dhënë është i pasaktë, ose është shfuqizuar. Lidhuni me përgjegjësin e sajtit onion.
onion-neterror-invalid-address-description = Adresa e dhënë e sajtit onion është e pavlefshme. Ju lutemi, kontrolloni nëse e keni dhënë saktë.
onion-neterror-timed-out-description = S’u arrit të lidhej te sajti onion, mundet për shkak lidhjeje të dobët me rrjetin.
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-unreachable-header = S’kapet dot sajt Onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-disconnected-header = Sajti onion u shkëput
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-connection-failed-header = S’arrihet të bëhet lidhja me sajtin onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-incorrect-authentication-header = Mirëfilltësimi i sajtit onion dështoi
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-invalid-address-header = Adresë e pavlefshme sajti onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
# "Circuit" refers to a Tor network circuit.
onion-neterror-timed-out-header = Mbaroi koha e krijimit të qarkut për sajt onion
# Tor connection settings.
# Prefix before the Tor network connection status.
# Uses sentence case in English (US).
tor-connection-network-status-label = Rrjeti Tor:
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-view-log-description = Shihni regjistrin e Tor-it.
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-overview = { -brand-short-name }-i e kalon trafikun tuaj përmes rrjetit Tor, mbajtur në këmbë nga mijëra vullnetarë anembanë botës.
# Built-in bridges dialog.
# -brand-short-name refers to 'Tor Browser', localized.
built-in-dialog-introduction = { -brand-short-name } përfshin disa lloje specifike urash të njohura si “transporte shtojcë”, të cilët mund të fshehin faktin që po përdorni Tor-in.
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-copy-button =
    .label = Kopjoje Regjistrin e Tor-it në të papastër
# Tor advanced connection settings dialog.
tor-advanced-dialog-introduction = Formësoni se si lidhet { -brand-short-name }-i në internet.
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input-label = Porta të lejuara
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-quickstart-description = Kur niset, Quickstart-i bën automatikisht lidhjen e { -brand-short-name }-it me Rrjetin Tor, bazuar në rregullimet e përdorur herën e fundit për lidhje.
# Built-in bridges dialog.
# "obfs4" is a technical name, and likely should not be translated.
built-in-dialog-obfs4-radio-option =
    .label = obfs4
# Tor advanced settings.
tor-advanced-settings-description = Formësoni se si lidhet { -brand-short-name }-i në internet.
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
# Uses sentence case in English (US).
tor-view-log-button = Shihni regjistër…
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-title =
    .title = Regjistër Tor-i
# Tor advanced connection settings dialog.
tor-advanced-dialog-title =
    .title = Rregullime lidhjeje
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-checkbox =
    .label = Për t’u lidhur në Internet, unë përdor një ndërmjetës
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-type-selector-label = Lloj ndërmjetësi
# Side panel in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# -brand-short-name refers to 'Tor Browser', localized.
rulesets-side-panel-no-rules-description = Kur të keni një grup rregullash në { -brand-short-name }, ai do të shfaqet këtu.
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk = JWK
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-page-title = Problem me ngarkimin e sajtit Onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-authorization-title = Lypset mirëfilltësim
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-not-found-header = S’u gjet sajt Onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-missing-authentication-header = Sajti onion lyp mirëfilltësim
# Tor connection settings.
# Shown when testing the internet status.
# Uses sentence case in English (US).
tor-connection-internet-status-testing = Po provohet…
tor-connection-settings-category =
    .tooltiptext = { tor-connection-settings-heading }
onion-site-authentication-prompt-learn-more = Mësoni më tepër
onion-site-authentication-prompt-remember-checkbox =
    .label = Mbaje mend këtë kyç
onion-site-authentication-prompt-invalid-key = Ju lutemi, jepni një kyç të vlefshëm (52 shenja base32 ose 44 shenja base64)
onion-site-authentication-prompt-setting-key-failed = S’arrihet të formësohet Tor-i me kyçin tuaj
onion-site-authentication-preferences-learn-more = Mësoni më tepër
onion-site-saved-keys-dialog-table-header-key =
    .label = Kyç
onion-site-saved-keys-dialog-remove-button = Hiqe
onion-site-saved-keys-dialog-remove-keys-error-message = S’arrihet të hiqet kyçi
downloads-tor-warning-message-bar =
    .heading = Jini i kujdesshëm, kur hapni shkarkime
    .message = Disa kartela mund të lidhen në internet, kur hapen pa përdorur Tor-in. Për të qenë të parrezik, hapini kartelat teksa jeni jashtë interneti, ose përdorni një sistem operativ të bartshëm, fjala vjen, Tails.
onion-site-authentication-preferences-saved-keys-button = Kyçe të ruajtur…
downloads-tor-warning-tails-link = Mësoni më tepër mbi Tails
onion-site-saved-keys-dialog-fetch-keys-error-message = S’arrihet të merren kyçe prej Tor-i
onion-site-saved-keys-dialog-remove-all-button = Hiqi krejt
onion-site-authentication-urlbar-button =
    .tooltiptext = Hap panel mirëfilltësimi sajti Onion
onion-site-authentication-prompt-description = Sajti Onion { $onionsite } po kërkon që ju të bëni mirëfilltësimin.
onion-site-authentication-prompt-key-input =
    .placeholder = Jepni kyçin tuaj privat për këtë sajt Onion
onion-site-authentication-prompt-ok-button =
    .label = OK
    .accesskey = O
onion-site-authentication-preferences-heading = Mirëfilltësim sajti Onion
onion-site-authentication-prompt-cancel-button =
    .label = Anuloje
    .accesskey = C
onion-site-authentication-preferences-overview = Disa sajte Onion lypin që ju të identifikoni veten me një kyç (njëfarë fjalëkalimi), para se të mund të hyni në ta.
page-info-onion-site-encryption-plain = Lidhje e fshehtëzuar (sajt Onion)
onion-site-saved-keys-dialog-title =
    .title = Kyçe sajti Onion
onion-site-saved-keys-dialog-intro = Kyçet vijues të sajtit Onion janë depozituar në kompjuterin tuaj.
onion-site-saved-keys-dialog-table-header-site =
    .label = Sajt Onion
page-info-onion-site-encryption-with-bits = Lidhje e fshehtëzuar (sajt Onion, { $encryption-type }, kyçe { NUMBER($encryption-strength, useGrouping: "false") } bit, { $encryption-version })
dropped-support-notification-macos-version-less-than-10-15-extended-13-5 = { -brand-short-name } 13.5 do të përfitojë përditësime sigurie vetëm për një kohë të kufizuar. Ju lutemi, që të merrni versionin më të ri të { -brand-short-name }, përmirësojeni me macOS 10.15 ose të mëvonshëm.
dropped-support-notification-win-os-version-less-than-10-extended-13-5 = { -brand-short-name } 13.5 do të përfitojë përditësime sigurie vetëm për një kohë të kufizuar. Ju lutemi, që të merrni versionin më të ri të { -brand-short-name }, përmirësojeni me Windows 10 ose të mëvonshëm.
tor-connection-internet-status-unknown = Status i panjohur
tor-log-dialog-table =
    .aria-label = { tor-log-dialog-title.title }
bridge-dialog-button-connect2 =
    .label = Lidhu
bridge-dialog-button-accept2 =
    .label = OK
bridge-dialog-button-submit2 =
    .label = Parashtroje
built-in-dialog-meek-radio-option2 =
    .label = { tor-bridges-built-in-meek-name }
built-in-dialog-obfs4-radio-option2 =
    .label = { tor-bridges-built-in-obfs4-name }
tor-bridges-built-in-meek-name = meek
built-in-dialog-snowflake-radio-option2 =
    .label = { tor-bridges-built-in-snowflake-name }
tor-connection-automatic-heading = Lidhu vetvetiu
yec-donate-button = Dhuroni që tani
tor-settings-failed-notification-button-clear = Spastroji
yec-close-button =
    .title = Mbylle
yec2025-title = Çlironi internetin
yec2025-body = Përkrahni mjete që thyejnë zinxhirët e censurimit dhe survejimit. <b data-l10n-name="highlight">Dhuroni sot për Projektin Tor.</b>
yec2025-matching = Deri më 31 dhjetor, për dhurimin tuaj, për vlera deri 250 mijë dollarë, do të ketë një kundërdhurim në po atë vlerë!
tor-connection-automatic-description = Lidhuni automatikisht te rrjeti Tor gjatë nisjes, duke përdorur rregullimet tuaja të tanishme për lidhjen.
tor-bridges-built-in-meek-description = Ju lidh me rrjetin Tor përmes një shërbimi të madh në re. Mund të funksionojë në zona të censuruara fort, por zakonisht është shumë i ngadaltë.
tor-settings-failed-notification-title-bridges = Rregullimet tuaja për urë Tor s’u aplikuan dot
tor-settings-failed-notification-cause-bridges = Kjo mund të vijë nga një adresë e pavlefshme ure.
tor-settings-failed-notification-title-proxy = Rregullimet tuaja për ndërmjetës Tor s’u aplikuan dot
tor-settings-failed-notification-cause-proxy = Kjo mund të vijë nga informacion të pavlefshëm ndërmjetësi.
tor-settings-failed-notification-title-firewall = Rregullimet tuaja për firewall Tor s’u aplikuan dot
tor-settings-failed-notification-cause-firewall = Kjo mund të vijë nga informacion i pavlefshëm për firewall-in.
tor-settings-failed-notification-body-undo = Deri sa të ndreqet, lidhja juaj Tor do të vazhdojë të përdorë rregullimet tuaja të mëparshme. Mundeni ose të zhbëni ndryshimet e fundit, që të rikthehen rregullimet e mëparshme funksionale, ose të kontrolloni regjistrin e Tor-it që të gjeni dhe ndreqni vetë problemin.
tor-settings-failed-notification-body-default = Deri sa të ndreqet, lidhja juaj Tor do të vazhdojë të përdorë rregullimet parazgjedhje. Mundeni ose të spastroni rregullimet problematike, që të rikthehen ato parazgjedhje, ose të kontrolloni regjistrin e Tor-it, që të gjeni dhe ndreqni ju vetë problemin.
tor-settings-failed-notification-button-undo = Zhbëji ndryshimet
tor-settings-failed-notification-button-fix-myself = I ndreq vetë
