tor-browser-home-heading-stable = Исследуйте. Приватно.
tor-browser-home-heading-testing = Протестируйте. Тщательно.
tor-browser-home-duck-duck-go-input =
    .placeholder = Поиск с помощью DuckDuckGo
tor-browser-home-message-introduction = Вы готовы к самому приватному просмотру веб-страниц в мире.
# Shown in Home settings, corresponds to the default about:tor home page.
home-mode-choice-tor =
    .label = Домашняя страница браузера Tor
# Tor Browser home page.
tor-browser-home-message-donate = Tor можно использовать бесплатно благодаря пожертвованиям таких людей, как вы. <a data-l10n-name="donate-link">Сделайте пожертвование сейчас</a>
# Tor Browser home page.
# Update message.
# <a data-l10n-name="update-link"> should contain the link text and close with </a>.
# $version (String) - The new tor browser version.
tor-browser-home-message-updated = Браузер Tor обновлен до { $version }. <a data-l10n-name="update-link">Посмотрите, что нового</a>
# Tor Browser home page.
tor-browser-home-message-testing = Это нестабильная версия браузера Tor для тестирования новых функций. <a data-l10n-name="learn-more-link">Подробнее</a>
# Tor browser manual link shown in the menu bar.
# Uses Title case.
menu-open-tor-manual =
    .label = Руководство по браузеру Tor
    .accesskey = M
# Tor Browser home page.
tor-browser-home-message-news = Получайте последние новости от Tor прямо в свой почтовый ящик. <a data-l10n-name="news-link">Подпишитесь на новости Tor</a>
# Tor browser manual link shown in the application menu (aka: hamburger menu).
# Uses Sentence case.
appmenu-open-tor-manual =
    .label = Руководство по браузеру Tor
    .accesskey = m
# Tor Browser home page.
# Toggle to switch from DuckDuckGo's plain ".com" domain to its ".onion" domain.
tor-browser-home-onionize-toggle =
    .label = Onionize
    .title = Поиск с помощью onion-сайта
# Tor Browser home page.
# Only shown when underlying Tor process was not started by Tor Browser.
# "Tails" refers to the operating system, and should be translated as a brand name.
# <a data-l10n-name="tor-check-link"> should contain the link text and close with </a>.
tor-browser-home-tor-check-warning = Ваше подключение к Tor не управляется браузером Tor. Некоторые операционные системы (например, Tails) сделают это за вас, или вы можете настроить собственную конфигурацию. <a data-l10n-name="tor-check-link">Проверить соединение</a>
about-dialog-tor-project = { -brand-short-name } разработан <label data-l10n-name="project-link">{ -vendor-short-name }</label>, некоммерческой организацией, защищающей вашу приватность и свободу онлайн.
about-dialog-help-out = Хотите помочь? <label data-l10n-name="donate-link">Пожертвуйте</label> или <label data-l10n-name="community-link">присоединяйтесь</label>!
about-dialog-questions-link = Вопросы?
about-dialog-grow-tor-network-link = Помогите сети Tor стать больше!
about-dialog-browser-license-link = Информация о лицензии
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Shows the QR code for this one bridge.
tor-bridges-menu-item-qr-address = Показать QR-код
    .accesskey = Q
menu-new-tor-circuit =
    .label = Новая цепочка Tor для этого cайта
    .accesskey = ц
appmenuitem-new-tor-circuit =
    .label = Новая цепочка Tor для этого cайта
toolbar-new-tor-circuit =
    .label = Новая цепочка Tor для этого cайта
    .tooltiptext = { toolbar-new-tor-circuit.label }
tor-circuit-urlbar-button =
    .tooltiptext = Цепочка Tor
tor-circuit-panel-heading = Цепочка для { $host }
tor-circuit-panel-alias = Подключено к <a data-l10n-name="alias-link">{ $alias }</a>
tor-circuit-panel-node-list-introduction = Цепочка Tor
tor-circuit-panel-node-browser = Этот браузер
tor-circuit-panel-node-onion-relays = Реле сайта onion
tor-circuit-panel-node-typed-bridge = Мост: { $bridge-type }
tor-circuit-panel-node-bridge = Мост
tor-circuit-panel-node-region-guard = { $region } (страж)
tor-circuit-panel-node-unknown-region = Неизвестный регион
tor-circuit-panel-new-button = Новая цепочка Tor для этого cайта
tor-circuit-panel-new-button-description-guard = Ваш сторожевой узел может не измениться
tor-circuit-panel-new-button-description-bridge = Ваш мост может не измениться
# Tor Bridges Settings
# The emoji name to show on hover when a bridge emoji's name is unknown.
tor-bridges-emoji-unknown = Неизвестный
# Tor Bridges Settings
# Shown when the bridge has been used for the most recent Tor circuit, i.e. the most recent bridge we have connected to.
tor-bridges-status-connected = Подключён
# Tor Bridges Settings
# "Telegram" is the common brand name of the Telegram Messenger application
tor-bridges-provider-telegram-name = Telegram
# Tor Bridges Settings
# "Web" is the proper noun for the "World Wide Web".
tor-bridges-provider-web-name = Сайт
# Tor Bridges Settings
# "Gmail" is the Google brand name. "Riseup" refers to the Riseup organisation at riseup.net.
tor-bridges-provider-email-name = Gmail или Riseup
# User provided bridge dialog.
# Short accessible name for the bridge addresses text area.
user-provide-bridge-dialog-textarea-addresses-label = Адреса мостов
# Tor Bridges Settings
tor-bridges-source-built-in = Встроенный
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can generate a QR code for all of their bridges.
tor-bridges-menu-item-qr-all-bridge-addresses = Показать QR-код
    .accesskey = Q
# Tor Bridges Settings
# Shown when one of the built-in bridges is in use.
tor-bridges-built-in-status-connected = Подключено
# Tor Bridges Settings
# Shown for requested bridges and bridges added by the user.
tor-bridges-share-heading = Помочь другим подключиться
# Tor Bridges Settings
# Button for the user to acknowledge a change in their "bridge pass".
tor-bridges-lox-got-it-button = Понятно
# User provided bridge dialog.
# "Learn more" link shown in the "Add new bridges"/"Replace your bridges" dialog.
user-provide-bridge-dialog-learn-more = Узнать больше
# Tor Bridges Settings
# Used when the bridge has no status, i.e. the *absence* of a status to report to the user. This is only visibly shown when the status cell has keyboard focus.
tor-bridges-status-none = Без статуса
# Tor Bridges Settings
# Toggle button for enabling and disabling the use of bridges.
tor-bridges-use-bridges =
    .label = Использовать мосты
# Tor Bridges Settings
tor-bridges-none-added = Нет добавленных мостов
# Tor Bridges Settings
tor-bridges-source-user = Добавлено вами
# Tor Bridges Settings
tor-bridges-source-requested = Запрошено у Tor
# Tor Bridges Settings
tor-bridges-your-bridges = Ваши мосты
crypto-safety-prompt-title = Адрес криптовалютного кошелька скопирован с незащищенного вебсайта
crypto-safety-prompt-body = Скопированный текст ({ $address }) похож на адрес криптовалютного кошелька. Соединение с { $host } не защищено, содержимое сайта могло быть подменено и не является доверенным. Вы можете попробовать установить защищенное соединение, подключившись с новой цепочкой.
crypto-safety-prompt-reload-button = Перезагрузить вкладку с новой цепочкой
crypto-safety-prompt-dismiss-button = Закрыть предупреждение
# Tor Bridges Settings
tor-bridges-select-built-in-button = Выбрать встроенный мост…
# Tor Bridges Settings
# Shown as a heading when the user has no current bridges.
tor-bridges-add-bridges-heading = Добавить мосты
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can copy all of their bridges.
tor-bridges-menu-item-copy-all-bridge-addresses = Копировать адреса мостов
    .accesskey = C
# Tor Bridges Settings
# Only shown in the "..." menu for bridges added by the user.
tor-bridges-menu-item-edit-all-bridges = Редактировать мосты
    .accesskey = E
# Tor Bridges Settings
# Shown at the start of a Tor bridge line.
# $type (String) - The Tor bridge type ("snowflake", "obfs4", "meek-azure").
tor-bridges-type-prefix = Мост { $type }:
# Tor Bridges Settings
# Used for an image of a bridge emoji. Each bridge address can be hashed into four emojis shown to the user (bridgemoji feature). This string corresponds to a *single* such emoji. The "title" should just be emojiName. The "alt" should let screen readers know that the image is of a *single* emoji, as well as its name.
# $emojiName (String) - The name of the emoji, already localized.
tor-bridges-emoji-image =
    .alt = Emoji: { $emojiName }
    .title = { $emojiName }
# Tor Bridges Settings
# Shown in the "..." menu for all current bridges.
tor-bridges-menu-item-remove-all-bridges = Удалить все мосты
    .accesskey = R
# Tor Bridges Settings
tor-bridges-qr-addresses-button =
    .title = Показать QR-код
# Tor Bridges Settings
tor-bridges-select-built-in-description = Выберите один из встроенных в { -brand-short-name } мостов
# Tor Bridges Settings
# The "..." menu button for all current bridges.
tor-bridges-options-button =
    .title = Все мосты
# Tor Bridges Settings
# Shown at the start of a Tor bridge line, when the transport type is unknown (or "vanilla").
tor-bridges-type-prefix-generic = Мост Tor:
# Tor Bridges Settings
# Shown as a heading when the user has existing bridges that can be replaced.
tor-bridges-replace-bridges-heading = Заменить свои мосты
# Tor Bridges Settings
# Here "Bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# This is shown when the user is getting their bridges from Lox.
tor-bridges-source-lox = Подписка на мосты
# Tor Bridges Settings
# Here "Message" is a verb, short for "Send a message to". This is an instruction to send a message to the given Telegram Messenger user to receive a new bridge.
# $telegramUserName (String) - The Telegram Messenger user name that should receive messages. Should be wrapped in '<a data-l10n-name="user">' and '</a>'.
# E.g. in English, "Message GetBridgesBot".
tor-bridges-provider-telegram-instruction = Отправить сообщение <a data-l10n-name="user">{ $telegramUserName }</a>
# Tor Bridges Settings
tor-bridges-request-button = Запросить мосты…
# Tor Bridges Settings
# Instructions to visit the given website.
# $url (String) - The URL for Tor Project bridges. Should be wrapped in '<a data-l10n-name"url">' and '</a>'.
tor-bridges-provider-web-instruction = Посетить <a data-l10n-name="url">{ $url }</a>
# Tor Bridges Settings
# Here "Email" is a verb, short for "Send an email to". This is an instruction to send an email to the given address to receive a new bridge.
# $address (String) - The email address that should receive the email.
# E.g. in English, "Email bridges@torproject.org".
tor-bridges-provider-email-instruction = Отправить email { $address }
# Tor Bridges Settings
tor-bridges-request-from-browser = Вы также можете получить мосты в боте мостов, не выходя из { -brand-short-name }.
# Tor Bridges Settings
tor-bridges-add-addresses-description = Введите адреса мостов, которые вы уже знаете
# Tor Bridges Settings
# Shown when the user has no current bridges.
# Opens a dialog where the user can provide a new bridge address or share code.
tor-bridges-add-new-button = Добавить новые мосты…
# Tor connection settings.
# Shown when the user is not connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-not-connected = Не подключено
# Tor Bridges Settings.
# "obfs4" is a technical name, and likely should not be translated.
tor-bridges-built-in-obfs4-name = obfs4
# Tor connection settings.
tor-connection-browser-learn-more-link = Узнать больше
# Tor connection settings.
# Prefix before the internet connection status.
# "Internet" is not a proper noun, but is capitalized because it is the start of a sentence.
tor-connection-internet-status-label = Интернет:
# Tor connection settings.
# Button to test the internet connection.
# Here "Test" is a verb, as in "test the internet connection".
# Uses sentence case in English (US).
tor-connection-internet-status-test-button = Тест
# Tor connection settings.
# Shown when the user is connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-online = Онлайн
# Tor connection settings.
# Shown when the user is not connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-offline = Офлайн
# Tor connection settings.
# Shown when the user's Tor connection may be blocked.
# Uses sentence case in English (US).
tor-connection-network-status-blocked = Потенциально заблокирован
# Tor connection settings.
# Button shown when we are not yet connected to the Tor network.
# It will open a page to start connecting to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connect-button = Соединиться
# Tor Bridges Settings.
tor-bridges-learn-more-link = Узнать больше
# Tor Bridges Settings.
tor-bridges-built-in-obfs4-description = Делает ваш трафик Tor случайно выглядящим. Может не работать в жёстко цензурируемых регионах.
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-name = Snowflake
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-description = Перенаправляет ваше соединение через прокси-серверы Snowflake, чтобы оно выглядело так, как будто вы, например, совершаете видеозвонок.
# Tor Bridges Settings.
# "meek-azure" is a technical name, and likely should not be translated.
tor-bridges-built-in-meek-azure-name = meek-azure
# Tor Bridges Settings.
tor-bridges-built-in-meek-azure-description = Создаёт вид подключения к страницам Microsoft вместо использования Tor. Может работать в жёстко цензурируемых регионах, но обычно работает очень медленно.
# Warning dialog when removing all bridges.
remove-all-bridges-warning-title = Удалить все мосты?
# Warning dialog when removing all bridges.
remove-all-bridges-warning-description = Если мосты были получены с torproject.org или были добавлены вручную, это действие нельзя отменить
# Warning dialog when removing all bridges.
remove-all-bridges-warning-remove-button = Удалить
# Common button used in bridge dialogs.
bridge-dialog-button-connect = Подключиться
# Common button used in bridge dialogs.
bridge-dialog-button-accept = ОК
# Common button used in bridge dialogs.
bridge-dialog-button-submit = Отправить
# Built-in bridges dialog.
request-bridge-dialog-top-wait = Обращение к BridgeDB. Пожалуйста, подождите.
# Built-in bridges dialog.
request-bridge-dialog-top-solve = Решите CAPTCHA для запроса моста.
# Built-in bridges dialog.
request-bridge-dialog-captcha-failed = Решение не является правильным. Пожалуйста, попробуйте еще раз.
# Tor advanced settings.
tor-advanced-settings-heading = Продвинутые
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-type-selector-label = Тип прокси
# Tor advanced connection settings dialog.
# "address" is a noun, referring to an network IP address.
tor-advanced-dialog-proxy-address-input-label = Адрес
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input-label = Пароль
# Tor connection settings.
# "Connection" refers to the Tor Browser's connection to the Tor network.
tor-connection-settings-heading = Подключение
# Tor connection settings.
tor-connection-quickstart-heading = Быстрый старт
# Tor connection settings.
# Shown when the user is connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connected = Подключено
# Tor Bridges Settings.
tor-bridges-heading = Мосты
# Tor Bridges Settings.
tor-bridges-overview = Мосты помогают вам получить безопасный доступ к сети Tor в местах, где Tor заблокирован. В зависимости от того, где вы находитесь, один мост может работать лучше, чем другой.
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-port-input-label = Порт
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input-label = Имя пользователя
# Tor advanced settings.
# Button that opens the advanced connection settings dialog.
# Uses sentence case in English (US).
tor-advanced-settings-button = Настройки…
tor-connection-quickstart-checkbox =
    .label = Всегда подключаться автоматически
bridge-qr-dialog-title =
    .title = Сканировать QR-код
built-in-dialog-title =
    .title = Выбрать встроенный мост
built-in-dialog-snowflake-radio-option =
    .label = Snowflake
built-in-dialog-meek-azure-radio-option =
    .label = meek-azure
request-bridge-dialog-title =
    .title = Запросить мост
request-bridge-dialog-captcha-input =
    .placeholder = Введите символы с изображения
tor-log-dialog-copy-button-copied =
    .label = Скопировано!
tor-advanced-dialog-proxy-socks4-menuitem =
    .label = SOCKS4
tor-advanced-dialog-proxy-socks5-menuitem =
    .label = SOCKS5
tor-advanced-dialog-proxy-http-menuitem =
    .label = HTTP/HTTPS
tor-advanced-dialog-proxy-address-input =
    .placeholder = IP-адрес или имя хоста
tor-advanced-dialog-proxy-username-input =
    .placeholder = Опционально
tor-advanced-dialog-proxy-password-input =
    .placeholder = Опционально
tor-advanced-dialog-firewall-checkbox =
    .label = Мой компьютер соединяется чере межсетевой экран, который разрешает подключения только к определённым портам
tor-advanced-dialog-firewall-ports-input =
    .placeholder = Значения, разделённые запятыми
downloads-tor-warning-title = Будьте осторожнее при открытии загруженных файлов
downloads-tor-warning-description = Некоторые файлы могут подключаться к Интернету при открытии без использования Tor. Чтобы быть в безопасности, открывайте файлы в автономном режиме или используйте портативную операционную систему, такую как <a data-l10n-name="tails-link">Tails</a>.
downloads-tor-warning-dismiss-button = Понятно
rulesets-warning-heading = Действуйте с осторожностью
rulesets-warning-description = Добавление или изменение наборов правил может привести тому, что злоумышленники захватят ваш браузер. Продолжайте только в том случае, если вы знаете, что делаете.
rulesets-warning-checkbox = Предупреждать меня, когда я пытаюсь получить доступ к этим настройкам
rulesets-warning-continue-button = Принять риск и продолжить
rulesets-side-panel-heading = Наборы правил
rulesets-side-panel-no-rules = Наборов правил не найдено
rulesets-update-last = Последнее обновление { DATETIME($date, dateStyle: "long") }
rulesets-update-never = Никогда не обновлялся, или последнее обновление не удалось
rulesets-update-rule-disabled = Отключен
rulesets-details-edit-button = Редактировать
rulesets-details-enable-checkbox = Включить этот набор правил
rulesets-details-update-button = Проверить наличие обновлений
rulesets-details-save-button = Сохранить
rulesets-details-cancel-button = Отменить
rulesets-details-jwk-input =
    .placeholder = Ключ, используемый для подписи этого набора правил, — в формате JWK (JSON Web Key)
rulesets-details-jwk-input-invalid = JWK не удалось обработать, или он не является действительным ключом
rulesets-details-path = Префикс пути
rulesets-details-path-input =
    .placeholder = Префикс URL, содержащий файлы, необходимые набору правил
rulesets-details-path-input-invalid = Префикс пути не является допустимым URL-адресом HTTP(S)
rulesets-details-scope = Область
rulesets-details-scope-input =
    .placeholder = Регулярное выражение для области действия правил
rulesets-details-scope-input-invalid = Область не удалось разобрать как регулярное выражение
onion-neterror-not-found-description = Наиболее вероятной причиной является то, что сайт onion офлайн. Обратитесь к администратору сайта onion.
onion-neterror-unreachable-description = Сайт onion недоступен из-за внутренней ошибки.
onion-neterror-disconnected-description = Наиболее вероятной причиной является то, что сайт onion офлайн. Обратитесь к администратору сайта onion.
onion-neterror-connection-failed-description = Сайт onion занят или сеть Tor перегружена. Повторите попытку позже.
onion-neterror-missing-authentication-description = Для доступа к сайту onion требуется ключ, но его не предоставили.
onion-neterror-incorrect-authetication-description = Предоставленный ключ неверен или был отозван. Обратитесь к администратору сайта onion.
onion-neterror-invalid-address-description = Указанный адрес сайта onion недействителен. Пожалуйста, проверьте, правильно ли вы его ввели.
onion-neterror-timed-out-description = Не удалось подключиться к сайту onion, возможно, из-за плохого сетевого соединения.
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-overview = { -brand-short-name } перенаправляет ваш трафик через сеть Tor, которую поддерживают тысячи добровольцев по всему миру.
# Tor connection settings.
# Shown when testing the internet status.
# Uses sentence case in English (US).
tor-connection-internet-status-testing = Проверка…
# Tor Bridges Settings.
# The "..." menu button for an individual bridge row.
tor-bridges-individual-bridge-options-button =
    .title = Опции моста
# Tor Bridges Settings.
# Shown in the "..." menu for an individual bridge. Copies the single bridge address to clipboard.
tor-bridges-menu-item-copy-address = Скопировать адреса моста
    .accesskey = C
# Tor Bridges Settings.
# Shown in the "..." menu for an individual bridge. Removes this one bridge.
tor-bridges-menu-item-remove-bridge = Убрать мост
    .accesskey = R
# Tor connection settings.
# Prefix before the Tor network connection status.
# Uses sentence case in English (US).
tor-connection-network-status-label = Сеть Tor:
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-quickstart-description = "Быстрый старт" автоматически подключает { -brand-short-name } к сети Tor при запуске, основываясь на последних использованных настройках подключения.
# Tor Bridges Settings.
# This is shown as a list item after "N days until you unlock:" when the user will gain two more bridges in the future.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-unlock-two-bridges = +2 моста от бота мостов
# Tor Bridges Settings.
# This is shown as a list item after "N days until you unlock:" when the user already has invites.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-more-invites = Больше приглашений для ваших надежных контактов
# Tor Bridges Settings.
# Shown *after* the user has gained two more bridges.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-gained-two-bridges = +2 моста от бота мостов
# Tor Bridges Settings.
# Shown when the user has existing bridges.
# Opens a dialog where the user can provide a new bridge address or share code to replace their current bridges.
tor-bridges-replace-button = Заменить мосты…
# User provided bridge dialog.
# Used when the user has no existing bridges.
user-provide-bridge-dialog-add-title =
    .title = Добавить новые мосты
# User provided bridge dialog.
# Used when the user is replacing their existing bridges with new ones.
user-provide-bridge-dialog-replace-title =
    .title = Заменить свои мосты
# Tor Bridges Settings.
# Shown when the user's bridges accessed through "bridge pass" have been blocked.
tor-bridges-lox-blocked = Ваши заблокированные мосты были заменены
# User provided bridge dialog.
# Description shown when adding new bridges, replacing existing bridges, or editing existing bridges.
user-provide-bridge-dialog-description = Используйте мосты, предоставленные надежной организацией или знакомым человеком.
# User provided bridge dialog.
# Here "invite" is a noun, short for "invitation".
# Short accessible name for text area when it can accept either bridge address or a single "bridge pass" invite.
user-provide-bridge-dialog-textarea-addresses-or-invite-label = Адреса мостов или приглашение
# User provided bridge dialog.
# Error shown when one of the address lines is invalid.
# $line (Number) - The line number for the invalid address.
user-provide-bridge-dialog-address-error = Неправильно отформатированный адрес моста в строке { $line }.
# User provided bridge dialog.
# Error shown when the user has mixed their invite with addresses.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-mixed-error = Невозможно одновременно использовать адреса мостов и приглашение.
# Tor Bridges Settings.
# Shown *after* the user has had their blocked bridges replaced.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-new-bridges = Новые мосты от бота мостов
# Tor Bridges Settings.
# Update text for screen reader users when their bridges have changed in some arbitrary way.
tor-bridges-update-changed-bridges = Ваши мосты Tor изменились.
# Tor Bridges Settings.
tor-bridges-share-description = Поделитесь своими мостами с надежными контактами.
# Tor Bridges Settings.
tor-bridges-copy-addresses-button = Скопировать адреса
# Tor Bridges Settings.
tor-bridges-find-more-heading = Найти другие мосты
# User provided bridge dialog.
# Placeholder shown when adding new bridge addresses.
user-provide-bridge-dialog-textarea-addresses =
    .placeholder = Вставьте сюда адреса ваших мостов
# User provided bridge dialog.
# Used when the user is editing their existing bridge addresses.
user-provide-bridge-dialog-edit-title =
    .title = Редактировать свои мосты
# User provided bridge dialog.
# Error shown when the user has entered more than one "bridge pass" invite.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-multiple-invites-error = Невозможно включить более одного приглашения.
# Tor Bridges Settings.
# Update text for screen reader users when all of their bridges have been removed.
tor-bridges-update-removed-all-bridges = Все ваши мосты Tor были удалены.
# Tor Bridges Settings.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-show-invites-button = Показать приглашения
# Tor Bridges Settings.
# Update text for screen reader users when only one of their bridges has been removed.
tor-bridges-update-removed-one-bridge = Один из ваших мостов Tor был удален.
# Tor Bridges Settings.
# Shown when using a "bridge pass", i.e. using Lox.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-description = С подпиской на мосты бот будет присылать вам новые мосты, когда ваши мосты будут заблокированы. Если ваши мосты не будут блокироваться, вы разблокируете приглашения, которые позволят вам делиться мостами с надежными контактами.
# Tor Bridges Settings.
# The number of days until the user's "bridge pass" is upgraded.
# $numDays (Number) - The number of days until the next upgrade, an integer (1 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numDays". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numDays is "1" (singular) and the second form will be used if $numDays is anything else (plural).
tor-bridges-lox-days-until-unlock =
    { $numDays ->
        [one] { $numDays } день до разблокировки:
       *[other] { $numDays } дней до разблокировки:
    }
# Tor Bridges Settings.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-remaining-invites =
    { $numInvites ->
        [one] { $numInvites } приглашение осталось
       *[other] { $numInvites } приглашений осталось
    }
# Tor Bridges Settings.
# Shown *after* a user's "bridge pass" has changed.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-new-invites =
    { $numInvites ->
        [one] Теперь у вас осталось { $numInvites } приглашение для ваших доверенных контактов
       *[other] Теперь у вас осталось { $numInvites } приглашений для ваших доверенных контактов
    }
# User provided bridge dialog.
# Error shown when the invite was not accepted by the server.
user-provide-bridge-dialog-bad-invite-error = Приглашение не было принято. Попробуйте другое.
# User provided bridge dialog.
# Error shown when the "bridge pass" server does not respond.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-no-server-error = Невозможно подключиться к серверу подписки на мосты.
# User provided bridge dialog.
# Placeholder shown when the user can add new bridge addresses or a single "bridge pass" invite.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
# NOTE: "invite" is singular, whilst "addresses" is plural.
user-provide-bridge-dialog-textarea-addresses-or-invite =
    .placeholder = Вставьте сюда адреса своих мостов или приглашение подписки на мосты
# User provided bridge dialog.
# Error shown when the user has entered an invite when it is not supported.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
user-provide-bridge-dialog-invite-not-allowed-error = Невозможно включить приглашение на подписку на мосты.
# Tor Bridges Settings.
# Text shown just before a description of the most recent change to the list of user's bridges. Some white space will separate this text from the change description.
# This text is not visible, but is instead used for screen reader users.
# E.g. in English this could be "Recent update: One of your Tor bridges has been removed."
tor-bridges-update-area-intro = Последнее обновление:
# Tor Bridges Settings.
# This is shown as a list item after "N days until you unlock:" when the user will gain access to invites for the first time.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-first-invites = Приглашения для ваших надежных контактов
# Tor Bridges Settings.
# Shown when the user's "bridge pass" has been upgraded.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
tor-bridges-lox-upgrade = Ваш подписка на мосты была обновлена!
# Tor Bridges Settings.
# "Tor Project" is the organisation name.
tor-bridges-find-more-description = Поскольку многие адреса мостов не являются общедоступными, вам, возможно, нужно будет запросить их у проекта Tor.
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-unreachable-header = На сайт onion невозможно попасть
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-connection-failed-header = Невозможно подключиться к сайту onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-missing-authentication-header = Сайт onion требует аутентификации
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-invalid-address-header = Неверный адрес сайта onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
# "Circuit" refers to a Tor network circuit.
onion-neterror-timed-out-header = Время создания цепочки сайта onion истекло
# Built-in bridges dialog.
# Label attached to the built-in bridge option that is already in use.
# The "aria-label" should use the same text, but include some ending punctuation to separate it from the sentence that follows. This is used for screen reader users.
built-in-dialog-current-bridge-label = Текущий мост
    .aria-label = Текущий мост.
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-copy-button =
    .label = Копировать лог Tor в буфер обмена
# Tor advanced settings.
tor-advanced-settings-description = Настройте, как { -brand-short-name } подключается к Интернету.
# User provided bridge dialog.
# Generic error when an invite failed.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-generic-invite-error = Не удалось активировать приглашение.
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-view-log-description = Посмотрите лог Tor.
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-title =
    .title = Лог Tor
# Tor advanced connection settings dialog.
tor-advanced-dialog-title =
    .title = Настройки подключения
# Tor advanced connection settings dialog.
tor-advanced-dialog-introduction = Настройте, как { -brand-short-name } подключается к Интернету.
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input-label = Разрешенные порты
# User provided bridge dialog.
# Shown after the user has entered a "bridge pass" invite.
user-provide-bridge-dialog-result-invite = С вами поделились следующими мостами.
# User provided bridge dialog.
# Shown after the user has entered bridge addresses.
user-provide-bridge-dialog-result-addresses = Вы ввели следующие мосты.
# User provided bridge dialog.
user-provide-bridge-dialog-next-button =
    .label = Далее
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk = JWK
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-not-found-header = Сайт onion не найден
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-disconnected-header = Cайт onion отключился
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-incorrect-authentication-header = Аутентификация на сайте onion не удалась
# Side panel in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# -brand-short-name refers to 'Tor Browser', localized.
rulesets-side-panel-no-rules-description = Когда вы сохраните набор правил в { -brand-short-name }, он отобразится здесь.
# User provided bridge dialog.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-connecting = Соединение с сервером подписки на мосты…
# Built-in bridges dialog.
# -brand-short-name refers to 'Tor Browser', localized.
built-in-dialog-introduction = { -brand-short-name } включает некоторые особые типы мостов, известные как "подключаемые транспорты", которые могут помочь скрыть факт использования Tor.
# Built-in bridges dialog.
# "obfs4" is a technical name, and likely should not be translated.
built-in-dialog-obfs4-radio-option =
    .label = obfs4
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
# Uses sentence case in English (US).
tor-view-log-button = Просмотр лога…
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-checkbox =
    .label = Я использую прокси-сервер для подключения к Интернету
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-page-title = Проблема с загрузкой сайта Onion
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-authorization-title = Требуется аутентификация
tor-connection-settings-category =
    .tooltiptext = { tor-connection-settings-heading }
onion-site-authentication-prompt-learn-more = Узнать больше
onion-site-authentication-prompt-remember-checkbox =
    .label = Запомнить этот ключ
onion-site-authentication-prompt-invalid-key = Пожалуйста, введите правильный ключ (52 символа base32 или 44 символа base64)
onion-site-authentication-prompt-setting-key-failed = Не удается настроить Tor с вашим ключом
onion-site-authentication-preferences-learn-more = Узнать больше
onion-site-saved-keys-dialog-table-header-key =
    .label = Ключ
onion-site-saved-keys-dialog-remove-button = Удалить
onion-site-saved-keys-dialog-remove-keys-error-message = Невозможно удалить ключ
downloads-tor-warning-message-bar =
    .heading = Будьте осторожнее при открытии загруженных файлов
    .message = Некоторые файлы могут подключаться к Интернету при открытии без использования Tor. Чтобы быть в безопасности, открывайте файлы в автономном режиме или используйте портативную операционную систему, такую как Tails.
downloads-tor-warning-tails-link = Узнайте больше о Tails
onion-site-authentication-urlbar-button =
    .tooltiptext = Открыть панель аутентификации сайта onion
onion-site-authentication-prompt-key-input =
    .placeholder = Ввести ваш приватный ключ для этого сайта onion
onion-site-authentication-prompt-ok-button =
    .label = OK
    .accesskey = O
onion-site-authentication-prompt-description = Сайт onion { $onionsite } запрашивает аутентификацию.
page-info-onion-site-encryption-plain = Соединение зашифровано (Сайт Onion)
onion-site-saved-keys-dialog-title =
    .title = Ключи сайтов onion
onion-site-saved-keys-dialog-fetch-keys-error-message = Не удалось получить ключи из Tor
onion-site-saved-keys-dialog-table-header-site =
    .label = Сайт onion
onion-site-authentication-preferences-overview = Некоторые сайты onion требуют идентификации с помощью ключа (пароля), перед тем, как вы сможете получить к ним доступ.
onion-site-authentication-preferences-saved-keys-button = Сохранённые ключи…
onion-site-saved-keys-dialog-intro = Следующие ключи сайтов onion хранятся на вашем компьютере.
onion-site-saved-keys-dialog-remove-all-button = Удалить всё
onion-site-authentication-preferences-heading = Аутентификация на сайте Onion
page-info-onion-site-encryption-with-bits = Соединение зашифровано (Сайт Onion, { $encryption-type }, { NUMBER($encryption-strength, useGrouping: "false") } ключи битов { $encryption-version }
tor-connection-internet-status-unknown = Неизвестный статус
dropped-support-notification-macos-version-less-than-10-15-extended-13-5 = Обновления для системы безопасности { -brand-short-name } 13.5 будут доступны только в течение ограниченного времени. Пожалуйста, обновитесь до macOS 10.15 или более поздней версии, чтобы получить последнюю версию { -brand-short-name }.
dropped-support-notification-win-os-version-less-than-10-extended-13-5 = Обновления для системы безопасности { -brand-short-name } 13.5 будут доступны только в течение ограниченного времени. Пожалуйста, обновитесь до Windows 10 или более поздней версии, чтобы получить последнюю версию { -brand-short-name }.
onion-site-authentication-prompt-cancel-button =
    .label = Закрыть
    .accesskey = З
tor-log-dialog-table =
    .aria-label = { tor-log-dialog-title.title }
tor-connection-automatic-heading = Соединяться автоматически
tor-connection-automatic-description = Автоматически подключаться к сети Tor при запуске, используя ваши текущие настройки подключения.
bridge-dialog-button-connect2 =
    .label = Подключиться
bridge-dialog-button-accept2 =
    .label = ОК
bridge-dialog-button-submit2 =
    .label = Отправить
tor-settings-failed-notification-button-undo = Отменить изменения
tor-settings-failed-notification-body-default = До устранения неполадок ваше подключение Tor будет продолжать использовать настройки по умолчанию. Вы можете сбросить проблемные настройки до значений по умолчанию, либо проверить журнал Tor, чтобы найти и устранить проблему самостоятельно.
tor-settings-failed-notification-body-undo = До устранения неполадок ваше подключение Tor будет продолжать использовать предыдущие настройки. Вы можете отменить последние изменения, чтобы восстановить предыдущие рабочие настройки, либо проверить журнал Tor, чтобы найти и устранить проблему самостоятельно.
tor-settings-failed-notification-cause-bridges = Это может быть связано с неверным адресом моста.
tor-settings-failed-notification-cause-proxy = Это может быть связано с неверной информацией прокси.
tor-settings-failed-notification-title-bridges = Не удалось применить настройки мостов Tor
tor-settings-failed-notification-title-proxy = Не удалось применить настройки прокси-сервера Tor
tor-settings-failed-notification-cause-firewall = Это может быть связано с неверной информацией брандмауэра.
tor-settings-failed-notification-title-firewall = Не удалось применить настройки брандмауэра Tor
tor-settings-failed-notification-button-fix-myself = Исправить самостоятельно
tor-settings-failed-notification-button-clear = Очистить
built-in-dialog-meek-radio-option2 =
    .label = { tor-bridges-built-in-meek-name }
built-in-dialog-obfs4-radio-option2 =
    .label = { tor-bridges-built-in-obfs4-name }
tor-bridges-built-in-meek-name = meek
built-in-dialog-snowflake-radio-option2 =
    .label = { tor-bridges-built-in-snowflake-name }
tor-bridges-built-in-meek-description = Подключает вас к сети Tor через крупного облачного провайдера. Может работать в регионах с жёсткой цензурой, но обычно очень медленно.
yec-donate-button = Сделать пожертвование
yec-close-button =
    .title = Закрыть
yec2025-title = Освободите Интернет
yec2025-body = Поддержите инструменты, которые разрушают цепи цензуры и слежки. <b data-l10n-name="highlight">Сделайте пожертвование проекту Tor сегодня же.</b>
yec2025-matching = До 31 декабря ваше пожертвование будет удвоено, до 250 000 долларов!
