# Tor browser manual link shown in the menu bar.
# Uses Title case.
menu-open-tor-manual =
    .label = Manuale di Tor Browser
    .accesskey = M
tor-browser-home-heading-stable = Naviga. Privatamente.
tor-browser-home-heading-testing = Verifica. Accuratamente.
tor-browser-home-duck-duck-go-input =
    .placeholder = Cerca con DuckDuckGo
tor-browser-home-message-introduction = Sei pronto per l'esperienza di navigazione più privata al mondo.
# Tor browser manual link shown in the application menu (aka: hamburger menu).
# Uses Sentence case.
appmenu-open-tor-manual =
    .label = Manuale di Tor Browser
    .accesskey = M
# Shown in Home settings, corresponds to the default about:tor home page.
home-mode-choice-tor =
    .label = Home di Tor Browser
# Tor Browser home page.
tor-browser-home-message-donate = Tor è gratuito grazie alle donazioni di persone come te. <a data-l10n-name="donate-link">Dona ora</a>
# Tor Browser home page.
# Update message.
# <a data-l10n-name="update-link"> should contain the link text and close with </a>.
# $version (String) - The new tor browser version.
tor-browser-home-message-updated = Tor Browser è stato aggiornato alla versione { $version }. <a data-l10n-name="update-link">Scopri le novità</a>
# Tor Browser home page.
tor-browser-home-message-testing = Questa è una versione non stabile di Tor Browser per testare nuove funzionalità. <a data-l10n-name="learn-more-link">Ulteriori informazioni</a>
# Tor Browser home page.
tor-browser-home-message-news = Ricevi le ultime notizie da Tor direttamente nella tua casella di posta. <a data-l10n-name="news-link">Iscriviti alle Tor News</a>
# Tor Browser home page.
# Toggle to switch from DuckDuckGo's plain ".com" domain to its ".onion" domain.
tor-browser-home-onionize-toggle =
    .label = Onionizza
    .title = Cerca utilizzando il sito onion
# Tor Browser home page.
# Only shown when underlying Tor process was not started by Tor Browser.
# "Tails" refers to the operating system, and should be translated as a brand name.
# <a data-l10n-name="tor-check-link"> should contain the link text and close with </a>.
tor-browser-home-tor-check-warning = La tua connessione a Tor non è gestita da Tor Browser. Alcuni sistemi operativi (come Tails) la gestiscono per te, o potresti aver impostato una configurazione personalizzata. <a data-l10n-name="tor-check-link">Prova la tua connessione</a>
# Tor Bridges Settings
# Toggle button for enabling and disabling the use of bridges.
tor-bridges-use-bridges =
    .label = Usa i bridge
# Tor Bridges Settings
tor-bridges-none-added = Nessun bridge aggiunto
# Tor Bridges Settings
tor-bridges-your-bridges = I tuoi bridge
# Tor Bridges Settings
tor-bridges-source-user = Aggiunto da te
# Tor Bridges Settings
tor-bridges-source-built-in = Integrato
# Tor Bridges Settings
tor-bridges-source-requested = Richiesto da Tor
# Tor Bridges Settings
# Here "Bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# This is shown when the user is getting their bridges from Lox.
tor-bridges-source-lox = Token per bridge
# Tor Bridges Settings
# The "..." menu button for all current bridges.
tor-bridges-options-button =
    .title = Tutti i bridge
# Tor Bridges Settings
# Only shown in the "..." menu for bridges added by the user.
tor-bridges-menu-item-edit-all-bridges = Modifica i bridge
    .accesskey = E
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can generate a QR code for all of their bridges.
tor-bridges-menu-item-qr-all-bridge-addresses = Mostra codice QR
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can copy all of their bridges.
tor-bridges-menu-item-copy-all-bridge-addresses = Copia indirizzi bridge
    .accesskey = C
# Tor Bridges Settings
# Shown in the "..." menu for all current bridges.
tor-bridges-menu-item-remove-all-bridges = Rimuovi tutti i bridge
    .accesskey = R
# Tor Bridges Settings
# Shown when one of the built-in bridges is in use.
tor-bridges-built-in-status-connected = Connesso
# Tor Bridges Settings
# Shown at the start of a Tor bridge line.
# $type (String) - The Tor bridge type ("snowflake", "obfs4", "meek-azure").
tor-bridges-type-prefix = Bridge { $type }:
# Tor Bridges Settings
# Shown at the start of a Tor bridge line, when the transport type is unknown (or "vanilla").
tor-bridges-type-prefix-generic = Bridge Tor:
# Tor Bridges Settings
# Used for an image of a bridge emoji. Each bridge address can be hashed into four emojis shown to the user (bridgemoji feature). This string corresponds to a *single* such emoji. The "title" should just be emojiName. The "alt" should let screen readers know that the image is of a *single* emoji, as well as its name.
# $emojiName (String) - The name of the emoji, already localized.
tor-bridges-emoji-image =
    .alt = Emoji: { $emojiName }
    .title = { $emojiName }
# Tor Bridges Settings
# The "..." menu button for an individual bridge row.
tor-bridges-individual-bridge-options-button =
    .title = opzioni bridge
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Shows the QR code for this one bridge.
tor-bridges-menu-item-qr-address = Mostra codice QR
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Copies the single bridge address to clipboard.
tor-bridges-menu-item-copy-address = Copia indirizzo bridge
    .accesskey = C
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Removes this one bridge.
tor-bridges-menu-item-remove-bridge = Rimuovi bridge
    .accesskey = R
# Tor Bridges Settings
# Text shown just before a description of the most recent change to the list of user's bridges. Some white space will separate this text from the change description.
# This text is not visible, but is instead used for screen reader users.
# E.g. in English this could be "Recent update: One of your Tor bridges has been removed."
tor-bridges-update-area-intro = Modifica recente:
# Tor Bridges Settings
# Update text for screen reader users when only one of their bridges has been removed.
tor-bridges-update-removed-one-bridge = Uno dei tuoi bridge Tor è stato rimosso.
# Tor Bridges Settings
# Update text for screen reader users when all of their bridges have been removed.
tor-bridges-update-removed-all-bridges = Tutti i tuoi bridge Tor sono stati rimossi.
# Tor Bridges Settings
tor-bridges-share-description = Condividi i tuoi bridge con contatti fidati.
# Tor Bridges Settings
tor-bridges-copy-addresses-button = Copia indirizzi
# Tor Bridges Settings
tor-bridges-qr-addresses-button =
    .title = Mostra codice QR
# Tor Bridges Settings
# The number of days until the user's "bridge pass" is upgraded.
# $numDays (Number) - The number of days until the next upgrade, an integer (1 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numDays". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numDays is "1" (singular) and the second form will be used if $numDays is anything else (plural).
tor-bridges-lox-days-until-unlock =
    { $numDays ->
        [one] { $numDays } giorno allo sblocco:
       *[other] { $numDays } giorni allo sblocco:
    }
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain two more bridges in the future.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-unlock-two-bridges = +2 bridge dal bot dei bridge
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain access to invites for the first time.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-first-invites = Inviti per i tuoi contatti fidati
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user already has invites.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-more-invites = Altri inviti per i tuoi contatti fidati
# Tor Bridges Settings
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-remaining-invites =
    { $numInvites ->
        [one] { $numInvites } invito rimasto
       *[other] { $numInvites } inviti rimasti
    }
# Tor Bridges Settings
# Shown when the user's "bridge pass" has been upgraded.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
tor-bridges-lox-upgrade = Il tuo token per bridge è stato aggiornato!
# Tor Bridges Settings
# Shown when the user's bridges accessed through "bridge pass" have been blocked.
tor-bridges-lox-blocked = I tuoi bridge bloccati sono stati sostituiti
# Tor Bridges Settings
# Shown *after* the user has had their blocked bridges replaced.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-new-bridges = Nuovi bridge dal bot dei bridge
# Tor Bridges Settings
# Shown *after* the user has gained two more bridges.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-gained-two-bridges = +2 bridge dal bot dei bridge
# Tor Bridges Settings
# Shown as a heading when the user has no current bridges.
tor-bridges-add-bridges-heading = Aggiungi dei bridge
# Tor Bridges Settings
# Shown as a heading when the user has existing bridges that can be replaced.
tor-bridges-replace-bridges-heading = Sostituisci i tuoi bridge
# Tor Bridges Settings
tor-bridges-select-built-in-description = Scegli uno dei bridge integrati di { -brand-short-name }
# Tor Bridges Settings
# Update text for screen reader users when their bridges have changed in some arbitrary way.
tor-bridges-update-changed-bridges = I tuoi bridge Tor sono cambiati.
# Tor Bridges Settings
# Shown when using a "bridge pass", i.e. using Lox.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-description = Con un token per bridge, il bot dei bridge ti invierà bridge nuovi quando i tuoi vengono bloccati. Se i tuoi non vengono bloccati, sbloccherai inviti che ti consentono di condividere i bridge con contatti fidati.
# Tor Bridges Settings
# Shown *after* a user's "bridge pass" has changed.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-new-invites =
    { $numInvites ->
        [one] Ora hai { $numInvites } invito rimasto per i tuoi contatti fidati
       *[other] Ora hai { $numInvites } inviti rimasti per i tuoi contatti fidati
    }
# Tor Bridges Settings
# The emoji name to show on hover when a bridge emoji's name is unknown.
tor-bridges-emoji-unknown = Sconosciuto
# Tor Bridges Settings
# Shown when the bridge has been used for the most recent Tor circuit, i.e. the most recent bridge we have connected to.
tor-bridges-status-connected = Connesso
# Tor Bridges Settings
# Shown for requested bridges and bridges added by the user.
tor-bridges-share-heading = Aiuta altri a connettersi
# Tor Bridges Settings
# Button for the user to acknowledge a change in their "bridge pass".
tor-bridges-lox-got-it-button = Capito
# Tor Bridges Settings
# Used when the bridge has no status, i.e. the *absence* of a status to report to the user. This is only visibly shown when the status cell has keyboard focus.
tor-bridges-status-none = Nessuno stato
# Tor Bridges Settings
tor-bridges-select-built-in-button = Seleziona un bridge integrato…
# Tor Bridges Settings
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-show-invites-button = Mostra inviti
# Tor Bridges Settings
tor-bridges-add-addresses-description = Inserisci gli indirizzi bridge che conosci già
# Tor Bridges Settings
# Shown when the user has no current bridges.
# Opens a dialog where the user can provide a new bridge address or share code.
tor-bridges-add-new-button = Aggiungi nuovi bridge…
# Tor Bridges Settings
# Shown when the user has existing bridges.
# Opens a dialog where the user can provide a new bridge address or share code to replace their current bridges.
tor-bridges-replace-button = Sostituisci bridge…
# Tor Bridges Settings
tor-bridges-find-more-heading = Trova altri bridge
# Tor Bridges Settings
# "Tor Project" is the organisation name.
tor-bridges-find-more-description = Dato che molti indirizzi bridge non sono pubblici, potresti doverne richiedere al Tor Project.
# Tor Bridges Settings
# Here "Message" is a verb, short for "Send a message to". This is an instruction to send a message to the given Telegram Messenger user to receive a new bridge.
# $telegramUserName (String) - The Telegram Messenger user name that should receive messages. Should be wrapped in '<a data-l10n-name="user">' and '</a>'.
# E.g. in English, "Message GetBridgesBot".
tor-bridges-provider-telegram-instruction = Scrivi a <a data-l10n-name="user">{ $telegramUserName }</a>
# Tor Bridges Settings
# Here "Email" is a verb, short for "Send an email to". This is an instruction to send an email to the given address to receive a new bridge.
# $address (String) - The email address that should receive the email.
# E.g. in English, "Email bridges@torproject.org".
tor-bridges-provider-email-instruction = Invia un'email a { $address }
# Tor Bridges Settings
tor-bridges-request-from-browser = Puoi anche ricevere bridge dal bot dei bridge senza lasciare { -brand-short-name }.
# Tor Bridges Settings
tor-bridges-request-button = Richiedi bridge…
# User provided bridge dialog.
# Used when the user is editing their existing bridge addresses.
user-provide-bridge-dialog-edit-title =
    .title = Modifica i tuoi bridge
# User provided bridge dialog.
# Used when the user has no existing bridges.
user-provide-bridge-dialog-add-title =
    .title = Aggiungi nuovi bridge
# User provided bridge dialog.
# Description shown when adding new bridges, replacing existing bridges, or editing existing bridges.
user-provide-bridge-dialog-description = Usa bridge forniti da un'organizzazione fidata o qualcuno che conosci.
# User provided bridge dialog.
# "Learn more" link shown in the "Add new bridges"/"Replace your bridges" dialog.
user-provide-bridge-dialog-learn-more = Maggiori informazioni
# User provided bridge dialog.
# Here "invite" is a noun, short for "invitation".
# Short accessible name for text area when it can accept either bridge address or a single "bridge pass" invite.
user-provide-bridge-dialog-textarea-addresses-or-invite-label = Indirizzi bridge o invito
# User provided bridge dialog.
# Placeholder shown when adding new bridge addresses.
user-provide-bridge-dialog-textarea-addresses =
    .placeholder = Incolla gli indirizzi bridge qui
# User provided bridge dialog.
# Error shown when one of the address lines is invalid.
# $line (Number) - The line number for the invalid address.
user-provide-bridge-dialog-address-error = Indirizzo bridge formattato non correttamente alla riga { $line }.
# User provided bridge dialog.
# Error shown when the user has entered more than one "bridge pass" invite.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-multiple-invites-error = Non si può includere più di un invito.
# User provided bridge dialog.
# Error shown when the user has mixed their invite with addresses.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-mixed-error = Non si può mescolare indirizzi bridge e inviti.
# User provided bridge dialog.
# Error shown when the user has entered an invite when it is not supported.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
user-provide-bridge-dialog-invite-not-allowed-error = Non si può includere un invito.
# User provided bridge dialog.
# Error shown when the invite was not accepted by the server.
user-provide-bridge-dialog-bad-invite-error = Invito non accettato. Provane un altro.
# User provided bridge dialog.
# Error shown when the "bridge pass" server does not respond.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-no-server-error = Impossibile connettere al server dei token per bridge.
# User provided bridge dialog.
# Generic error when an invite failed.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-generic-invite-error = Riscatto dell'invito fallito.
# User provided bridge dialog.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-connecting = Connessione al server dei token per bridge…
# User provided bridge dialog.
# Shown after the user has entered a "bridge pass" invite.
user-provide-bridge-dialog-result-invite = I seguenti bridge sono stati condivisi con te.
# User provided bridge dialog.
# Shown after the user has entered bridge addresses.
user-provide-bridge-dialog-result-addresses = I seguenti bridge sono stati inseriti da te.
# User provided bridge dialog.
user-provide-bridge-dialog-next-button =
    .label = Successivo
# Tor Bridges Settings
# Instructions to visit the given website.
# $url (String) - The URL for Tor Project bridges. Should be wrapped in '<a data-l10n-name"url">' and '</a>'.
tor-bridges-provider-web-instruction = Visita <a data-l10n-name="url">{ $url }</a>
# User provided bridge dialog.
# Used when the user is replacing their existing bridges with new ones.
user-provide-bridge-dialog-replace-title =
    .title = Sostituisci i tuoi bridge
# User provided bridge dialog.
# Placeholder shown when the user can add new bridge addresses or a single "bridge pass" invite.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
# NOTE: "invite" is singular, whilst "addresses" is plural.
user-provide-bridge-dialog-textarea-addresses-or-invite =
    .placeholder = Incolla gli indirizzi bridge o l'invito qui
# Tor Bridges Settings
# "Telegram" is the common brand name of the Telegram Messenger application
tor-bridges-provider-telegram-name = Telegram
# Tor Bridges Settings
# "Gmail" is the Google brand name. "Riseup" refers to the Riseup organisation at riseup.net.
tor-bridges-provider-email-name = Gmail o Riseup
# User provided bridge dialog.
# Short accessible name for the bridge addresses text area.
user-provide-bridge-dialog-textarea-addresses-label = Indirizzi bridge
# Tor Bridges Settings
# "Web" is the proper noun for the "World Wide Web".
tor-bridges-provider-web-name = Web
about-dialog-tor-project = { -brand-short-name } è sviluppato dal <label data-l10n-name="project-link">{ -vendor-short-name }</label>, una no profit che lavora per difendere la tua privacy e la tua libertà online.
about-dialog-help-out = Vuoi aiutare? <label data-l10n-name="donate-link">Dona</label> o <label data-l10n-name="community-link">partecipa</label>!
about-dialog-questions-link = Domande?
about-dialog-grow-tor-network-link = Aiuta la rete Tor a crescere!
about-dialog-browser-license-link = Informazioni sulla licenza
# Built-in bridges dialog.
# Label attached to the built-in bridge option that is already in use.
# The "aria-label" should use the same text, but include some ending punctuation to separate it from the sentence that follows. This is used for screen reader users.
built-in-dialog-current-bridge-label = Bridge attuale
    .aria-label = Bridge attuale.
menu-new-tor-circuit =
    .label = Nuovo circuito Tor per questo sito
    .accesskey = c
appmenuitem-new-tor-circuit =
    .label = Nuovo circuito Tor per questo sito
toolbar-new-tor-circuit =
    .label = Nuovo circuito Tor per questo sito
    .tooltiptext = { toolbar-new-tor-circuit.label }
tor-circuit-urlbar-button =
    .tooltiptext = Circuito Tor
tor-circuit-panel-heading = Circuito per { $host }
tor-circuit-panel-alias = Connesso a <a data-l10n-name="alias-link">{ $alias }</a>
tor-circuit-panel-node-list-introduction = Circuito Tor
tor-circuit-panel-node-browser = Questo browser
tor-circuit-panel-node-onion-relays = Relay sito Onion
tor-circuit-panel-node-typed-bridge = Bridge: { $bridge-type }
tor-circuit-panel-node-bridge = Bridge
tor-circuit-panel-node-region-guard = { $region } (guardia)
tor-circuit-panel-node-unknown-region = Regione sconosciuta
tor-circuit-panel-new-button = Nuovo circuito Tor per questo sito
tor-circuit-panel-new-button-description-guard = Il tuo nodo guard potrebbe non cambiare
tor-circuit-panel-new-button-description-bridge = Il tuo nodo bridge potrebbe non cambiare
crypto-safety-prompt-title = Indirizzo di criptovaluta copiato da un sito insicuro
crypto-safety-prompt-body = Il testo copiato ({ $address }) sembra essere un indirizzo di criptovaluta. Siccome la connessione a { $host } non è sicura, l'indirizzo potrebbe essere stato modificato e non dovrebbe essere considerato sicuro. Puoi provare a stabilire una connessione sicura riconnettendoti attraverso un nuovo circuito.
crypto-safety-prompt-reload-button = Ricarica scheda con un nuovo circuito
crypto-safety-prompt-dismiss-button = Chiudi avviso
# Tor connection settings.
# Shown when the user is not connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-not-connected = Non connesso
# Tor connection settings.
tor-connection-browser-learn-more-link = Maggiori informazioni
# Tor connection settings.
# Button shown when we are not yet connected to the Tor network.
# It will open a page to start connecting to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connect-button = Avvia
# Tor connection settings.
tor-connection-quickstart-heading = Avvio rapido
# Built-in bridges dialog.
request-bridge-dialog-top-solve = Risolvi il CAPTCHA per richiedere un bridge.
# Tor advanced settings.
tor-advanced-settings-heading = Avanzate
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-port-input-label = Porta
# Tor advanced connection settings dialog.
# "address" is a noun, referring to an network IP address.
tor-advanced-dialog-proxy-address-input-label = Indirizzo
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-type-selector-label = Tipo di proxy
# Tor connection settings.
# "Connection" refers to the Tor Browser's connection to the Tor network.
tor-connection-settings-heading = Connessione
# Tor connection settings.
# Prefix before the internet connection status.
# "Internet" is not a proper noun, but is capitalized because it is the start of a sentence.
tor-connection-internet-status-label = Internet:
# Tor Bridges Settings.
tor-bridges-learn-more-link = Per saperne di più
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-description = Indirizza la tua connessione tramite proxy Snowflake per fare in modo che tu stia facendo una video chiamata, per esempio.
# Tor Bridges Settings.
# "meek-azure" is a technical name, and likely should not be translated.
tor-bridges-built-in-meek-azure-name = meek-azure
# Common button used in bridge dialogs.
bridge-dialog-button-connect = Connetti
# Built-in bridges dialog.
request-bridge-dialog-top-wait = Contattando BridgeDB. Attendere, prego.
# Built-in bridges dialog.
request-bridge-dialog-captcha-failed = La soluzione è sbagliata. Riprova.
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input-label = Nome utente
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input-label = Password
# Tor connection settings.
# Shown when the user's Tor connection may be blocked.
# Uses sentence case in English (US).
tor-connection-network-status-blocked = Potenzialmente bloccato
# Tor connection settings.
# Button to test the internet connection.
# Here "Test" is a verb, as in "test the internet connection".
# Uses sentence case in English (US).
tor-connection-internet-status-test-button = Test
# Tor connection settings.
# Shown when the user is connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-online = Online
# Tor connection settings.
# Shown when the user is not connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-offline = Offline
# Tor connection settings.
# Shown when the user is connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connected = Connesso
# Tor Bridges Settings.
tor-bridges-heading = Bridge
# Tor Bridges Settings.
tor-bridges-overview = I bridge consentono di accedere in modo sicuro alla rete Tor nei luoghi in cui Tor è bloccato. A seconda del luogo in cui ti trovi, un bridge potrebbe funzionare meglio di un altro.
# Tor Bridges Settings.
# "obfs4" is a technical name, and likely should not be translated.
tor-bridges-built-in-obfs4-name = obfs4
# Tor Bridges Settings.
tor-bridges-built-in-obfs4-description = Fa in modo che il tuo traffico Tor sembri dati casuali. Potrebbe non funzionare in regioni con censura elevata.
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-name = Snowflake
# Tor Bridges Settings.
tor-bridges-built-in-meek-azure-description = Fa in modo che sembri che tu sia connesso a un sito web Microsoft anziché alla rete Tor. Potrebbe funzionare in regioni con censura elevata, ma di solito è molto lento.
# Warning dialog when removing all bridges.
remove-all-bridges-warning-title = Rimuovere tutti i bridge?
# Warning dialog when removing all bridges.
remove-all-bridges-warning-description = Se questi bridge erano stati ottenuti da torproject.org o aggiunti manualmente, questa azione non potrà essere annullata
# Warning dialog when removing all bridges.
remove-all-bridges-warning-remove-button = Rimuovi
# Common button used in bridge dialogs.
bridge-dialog-button-accept = OK
# Common button used in bridge dialogs.
bridge-dialog-button-submit = Invia
# Tor advanced settings.
# Button that opens the advanced connection settings dialog.
# Uses sentence case in English (US).
tor-advanced-settings-button = Impostazioni…
tor-connection-quickstart-checkbox =
    .label = Connetti sempre automaticamente
bridge-qr-dialog-title =
    .title = Scansiona il codice QR
built-in-dialog-title =
    .title = Seleziona un bridge integrato
built-in-dialog-snowflake-radio-option =
    .label = Snowflake
built-in-dialog-meek-azure-radio-option =
    .label = meek-azure
request-bridge-dialog-title =
    .title = Richiedi bridge
request-bridge-dialog-captcha-input =
    .placeholder = Inserisci i caratteri dell'immagine
tor-log-dialog-copy-button-copied =
    .label = Copiato!
tor-advanced-dialog-proxy-socks4-menuitem =
    .label = SOCKS4
tor-advanced-dialog-proxy-socks5-menuitem =
    .label = SOCKS5
tor-advanced-dialog-proxy-http-menuitem =
    .label = HTTP/HTTPS
tor-advanced-dialog-proxy-address-input =
    .placeholder = Indirizzo IP oppure nome host
tor-advanced-dialog-proxy-username-input =
    .placeholder = Facoltativo
tor-advanced-dialog-proxy-password-input =
    .placeholder = Facoltativo
tor-advanced-dialog-firewall-checkbox =
    .label = Questo computer passa attraverso un firewall che permette solo connessioni a determinate porte
tor-advanced-dialog-firewall-ports-input =
    .placeholder = Valori separati da una virgola
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input-label = Porte consentite
# Tor advanced connection settings dialog.
tor-advanced-dialog-title =
    .title = Impostazioni di connessione
# Built-in bridges dialog.
# "obfs4" is a technical name, and likely should not be translated.
built-in-dialog-obfs4-radio-option =
    .label = obfs4
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
# Uses sentence case in English (US).
tor-view-log-button = Vedi registro…
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-view-log-description = Vedi il registro di Tor.
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-quickstart-description = L'avvio rapido connette { -brand-short-name } alla rete Tor automaticamente quando viene aperto, in base alle tue ultime impostazioni di connessione.
# Built-in bridges dialog.
# -brand-short-name refers to 'Tor Browser', localized.
built-in-dialog-introduction = { -brand-short-name } include alcune tipi specifici di bridge nominati “pluggable transports”, che possono aiutare a nascondere il fatto che stai usando Tor.
# Tor advanced settings.
tor-advanced-settings-description = Configura come { -brand-short-name } si connette ad internet.
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-title =
    .title = registro di Tor
# Tor advanced connection settings dialog.
tor-advanced-dialog-introduction = Configura come { -brand-short-name } si connette ad internet.
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-checkbox =
    .label = Uso un proxy per connettermi a internet
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-overview = { -brand-short-name } instrada il traffico attraverso la rete Tor, gestita da migliaia di volontari in tutto il mondo.
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-copy-button =
    .label = Copia registro di Tor negli appunti
# Tor connection settings.
# Prefix before the Tor network connection status.
# Uses sentence case in English (US).
tor-connection-network-status-label = Rete Tor:
downloads-tor-warning-title = Sii cauto quando apri i download
downloads-tor-warning-description = Alcuni tipi di file possono far sì che le applicazioni si connettano a Internet senza usare Tor. Per essere al sicuro, apri i file scaricati solo offline, o usa un sistema operativo portatile come <a data-l10n-name="tails-link">Tails</a>.
downloads-tor-warning-dismiss-button = Capito
rulesets-warning-heading = Procedi con cautela
rulesets-warning-description = L'aggiunta o modifica di regole può causare il dirottamento del browser da parte di aggressori. Procedi solo se sai cosa stai facendo.
rulesets-warning-checkbox = Avvisami quando tento di accedere a queste preferenze
rulesets-warning-continue-button = Accetta il rischio e continua
rulesets-side-panel-heading = Set di regole
rulesets-side-panel-no-rules = Nessun set trovato
rulesets-update-last = Ultimo aggiornamento { DATETIME($date, dateStyle: "long") }
rulesets-update-never = Mai aggiornato, o ultimo aggiornamento fallito
rulesets-update-rule-disabled = Disattivato
rulesets-details-edit-button = Modifica
rulesets-details-enable-checkbox = Attiva questo set di regole
rulesets-details-update-button = Cerca aggiornamenti
rulesets-details-save-button = Salva
rulesets-details-cancel-button = Annulla
rulesets-details-jwk-input =
    .placeholder = La chiave usata per firmare questo set nel formato JWK (JSON Web Key)
rulesets-details-jwk-input-invalid = Impossibile leggere il JWK, o non è una chiave valida
rulesets-details-path = Prefisso del percorso
rulesets-details-path-input =
    .placeholder = Prefisso URL che contiene i file necessari al set di regole
rulesets-details-path-input-invalid = Il prefisso del percorso non è un URL HTTP(S) valido
rulesets-details-scope = Ambito
rulesets-details-scope-input =
    .placeholder = Espressione regolare per l'ambito delle regole
rulesets-details-scope-input-invalid = Impossibile leggere l'ambito come espressione regolare
onion-neterror-not-found-description = La causa più probabile è che il sito Onion sia offline. Contatta l'amministratore del sito Onion.
onion-neterror-unreachable-description = Il sito onion non è raggiungibile per un errore interno.
onion-neterror-disconnected-description = La causa più probabile è che il sito onion sia offline. Contatta l'amministratore del sito onion.
onion-neterror-connection-failed-description = Il sito onion è occupato o la rete Tor è sovraccarica. Riprova più tardi.
onion-neterror-missing-authentication-description = L'accesso al sito onion richiede una chiave ma non ne è stata fornita nessuna.
onion-neterror-incorrect-authetication-description = La chiave fornita non è corretta o è stata revocata. Contatta l'amministratore del sito onion.
onion-neterror-invalid-address-description = L'indirizzo onion fornito non è valido. Controlla di averlo inserito correttamente.
onion-neterror-timed-out-description = Connessione al sito onion fallita, probabilmente per una connessione di rete debole.
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-unreachable-header = Il sito onion non può essere raggiunto
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-disconnected-header = Il sito onion si è disconnesso
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-connection-failed-header = Impossibile connettersi al sito onion
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-incorrect-authentication-header = Autenticazione sul sito onion fallita
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-invalid-address-header = Indirizzo del sito onion non valido
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk = JWK
# Tor connection settings.
# Shown when testing the internet status.
# Uses sentence case in English (US).
tor-connection-internet-status-testing = Test in corso…
# Side panel in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# -brand-short-name refers to 'Tor Browser', localized.
rulesets-side-panel-no-rules-description = Quando salvi un set di regole in { -brand-short-name }, verrà mostrato qui.
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-page-title = Problema nel caricamento del sito onion
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-authorization-title = Autenticazione necessaria
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-not-found-header = Sito onion non trovato
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-missing-authentication-header = Il sito onion richiede un'autenticazione
# Onionsite error page.
# "Onionsite" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
# "Circuit" refers to a Tor network circuit.
onion-neterror-timed-out-header = Creazione circuito del sito onion scaduta
tor-connection-settings-category =
    .tooltiptext = { tor-connection-settings-heading }
onion-site-authentication-prompt-learn-more = Per saperne di più
onion-site-authentication-prompt-remember-checkbox =
    .label = Ricorda questa chiave
onion-site-authentication-prompt-invalid-key = Per favore inserisci una chiave valida (52 caratteri base32 o 44 caratteri base64)
onion-site-authentication-prompt-setting-key-failed = Impossibile configurare Tor con la tua chiave
onion-site-authentication-preferences-learn-more = Per saperne di più
onion-site-saved-keys-dialog-table-header-key =
    .label = Chiave
onion-site-saved-keys-dialog-remove-button = Rimuovi
onion-site-saved-keys-dialog-remove-keys-error-message = Impossibile rimuovere la chiave
downloads-tor-warning-message-bar =
    .heading = Fai attenzione quando apri i download
    .message = Alcuni tipi di file possono far sì che le applicazioni si connettano a Internet senza usare Tor. Per essere al sicuro, apri i file scaricati solo offline, o usa un sistema operativo portatile come Tails.
onion-site-authentication-urlbar-button =
    .tooltiptext = Apri il pannello di autenticazione del sito onion
onion-site-authentication-prompt-description = Il sito onion { $onionsite } ti sta chiedendo l'autenticazione.
onion-site-authentication-prompt-key-input =
    .placeholder = Inserisci la tua chiave privata per questo sito onion
onion-site-authentication-prompt-ok-button =
    .label = OK
    .accesskey = O
onion-site-authentication-prompt-cancel-button =
    .label = Annulla
    .accesskey = A
page-info-onion-site-encryption-plain = Connessione cifrata (Sito onion)
onion-site-authentication-preferences-heading = Autenticazione ai siti onion
onion-site-authentication-preferences-overview = Alcuni siti onion richiedono che ti identifichi con una chiave (una specie di password) prima di potervi accedere.
page-info-onion-site-encryption-with-bits = Connessione cifrata (Sito onion, { $encryption-type }, chiavi a { NUMBER($encryption-strength, useGrouping: "false") } bit, { $encryption-version })
onion-site-authentication-preferences-saved-keys-button = Chiavi salvate…
downloads-tor-warning-tails-link = Maggiori informazioni su Tails
onion-site-saved-keys-dialog-intro = Le seguenti chiavi di siti onion sono salvata nel tuo computer.
onion-site-saved-keys-dialog-table-header-site =
    .label = Sito onion
onion-site-saved-keys-dialog-title =
    .title = Chiavi siti onion
onion-site-saved-keys-dialog-remove-all-button = Rimuovi tutti
onion-site-saved-keys-dialog-fetch-keys-error-message = Impossibile recuperare le chiavi da Tor
dropped-support-notification-macos-version-less-than-10-15-extended-13-5 = { -brand-short-name } 13.5 riceverà gli aggiornamenti di sicurezza per un periodo ti tempo limitato. Aggiorna a macOS 10.15 o successivo per ricevere l'ultima versione di { -brand-short-name }.
dropped-support-notification-win-os-version-less-than-10-extended-13-5 = { -brand-short-name } 13.5 riceverà gli aggiornamenti di sicurezza per un periodo ti tempo limitato. Aggiorna a Windows 10 o successivo per ricevere l'ultima versione di { -brand-short-name }.
tor-connection-internet-status-unknown = Stato sconosciuto
tor-log-dialog-table =
    .aria-label = { tor-log-dialog-title.title }
bridge-dialog-button-connect2 =
    .label = Connetti
bridge-dialog-button-accept2 =
    .label = OK
bridge-dialog-button-submit2 =
    .label = Invia
tor-connection-automatic-heading = Connetti automaticamente
tor-connection-automatic-description = Connettiti automaticamente alla rete Tor all’avvio utilizzando le impostazioni di connessione correnti.
tor-settings-failed-notification-cause-bridges = Ciò potrebbe essere dovuto a un indirizzo bridge non valido.
tor-settings-failed-notification-title-bridges = Non è stato possibile applicare le impostazioni del bridge Tor
tor-settings-failed-notification-title-proxy = Non è stato possibile applicare le impostazioni del proxy Tor
tor-settings-failed-notification-cause-proxy = Ciò potrebbe essere dovuto a informazioni proxy non valide.
tor-settings-failed-notification-cause-firewall = Ciò potrebbe essere dovuto a informazioni non valide del firewall.
tor-settings-failed-notification-title-firewall = Non è stato possibile applicare le impostazioni del firewall Tor
tor-settings-failed-notification-body-undo = Fino a quando non verrà risolto il problema, la connessione Tor continuerà a utilizzare le impostazioni precedenti. È possibile annullare le ultime modifiche per ripristinare le impostazioni precedenti funzionanti oppure controllare il registro Tor per individuare e risolvere il problema autonomamente.
tor-settings-failed-notification-body-default = Fino a quando il problema non sarà risolto, la connessione Tor continuerà a utilizzare le impostazioni predefinite. È possibile cancellare le impostazioni problematiche per ripristinare quelle predefinite oppure controllare il registro Tor per individuare e risolvere il problema autonomamente.
tor-settings-failed-notification-button-undo = Annulla modifiche
tor-settings-failed-notification-button-clear = Pulisci
tor-settings-failed-notification-button-fix-myself = Riparami
built-in-dialog-meek-radio-option2 =
    .label = { tor-bridges-built-in-meek-name }
built-in-dialog-obfs4-radio-option2 =
    .label = { tor-bridges-built-in-obfs4-name }
tor-bridges-built-in-meek-name = meek
built-in-dialog-snowflake-radio-option2 =
    .label = { tor-bridges-built-in-snowflake-name }
yec-donate-button = Dona ora
yec-close-button =
    .title = Chiudi
yec2025-title = Liberiamo Internet
yec2025-body = Supporta strumenti che spezzano le catene della censura e della sorveglianza. <b data-l10n-name="highlight">Dona oggi a Tor Project.</b>
yec2025-matching = Fino al 31 dicembre, la tua donazione sarà raddoppiata fino a un massimo di 250.000 dollari!
tor-bridges-built-in-meek-description = Ti permette di connetterti alla rete Tor attraverso un grande cloud provider. Consigliato in zone sottoposte a censura, ma di solito è molto lento.
