tor-browser-home-heading-stable = Prohlížejte v soukromí.
tor-browser-home-heading-testing = Otestovat. Důkladně.
tor-browser-home-duck-duck-go-input =
    .placeholder = Vyhledejte s DuckDuckGo
tor-browser-home-message-introduction = Vše je připraveno pro maximální soukromí Vašeho prohlížení.
# Shown in Home settings, corresponds to the default about:tor home page.
home-mode-choice-tor =
    .label = Prohlížeč Tor domovská stránka
# Tor Browser home page.
tor-browser-home-message-donate = Tor je možné používat bezplatně díky finančním příspěvkům od lidí, jako jste vy. <a data-l10n-name="donate-link">Přispějte nyní</a>
# Tor Browser home page.
# Update message.
# <a data-l10n-name="update-link"> should contain the link text and close with </a>.
# $version (String) - The new tor browser version.
tor-browser-home-message-updated = Prohlížeč Tor byl aktualizován na verzi { $version }. <a data-l10n-name="update-link">Podívejte se co je nového</a>
# Tor Browser home page.
tor-browser-home-message-testing = Toto je nestabilní verze Prohlížeče Tor, určená pro zkoušení nových funkcí. <a data-l10n-name="learn-more-link">Více informací</a>
# Tor browser manual link shown in the menu bar.
# Uses Title case.
menu-open-tor-manual =
    .label = Prohlížeč Tor Manuál
    .accesskey = M
# Tor Browser home page.
tor-browser-home-message-news = Přijímejte nejnovější zprávy od Tor přímo do vaší schránky. <a data-l10n-name="news-link">Přihlásit se k odběru zpráv Tor</a>
# Tor browser manual link shown in the application menu (aka: hamburger menu).
# Uses Sentence case.
appmenu-open-tor-manual =
    .label = Prohlížeč Tor manuál
    .accesskey = m
# Tor Browser home page.
# Toggle to switch from DuckDuckGo's plain ".com" domain to its ".onion" domain.
tor-browser-home-onionize-toggle =
    .label = Onionize
    .title = Vyhledávání pomocí onion stránky
# Tor Browser home page.
# Only shown when underlying Tor process was not started by Tor Browser.
# "Tails" refers to the operating system, and should be translated as a brand name.
# <a data-l10n-name="tor-check-link"> should contain the link text and close with </a>.
tor-browser-home-tor-check-warning = Vaše připojení k síti Tor není spravováno Prohlížečem Tor. Některé operační systémy (např. Tails) provádějí správu vlastním způsobem a nebo máte vlastní konfiguraci. <a data-l10n-name="tor-check-link">Otestujte své připojení</a>
about-dialog-tor-project = Aplikace { -brand-short-name } je vyvíjena <label data-l10n-name="project-link">společností { -vendor-short-name }</label>, neziskovou organizací chránící vaše soukromí a svobodu na internetu.
about-dialog-help-out = Chcete pomoci? <label data-l10n-name="donate-link">Přispějte</label> nebo <label data-l10n-name="community-link">se zapojte</label>!
about-dialog-questions-link = Otázky?
about-dialog-grow-tor-network-link = Pomozte síti Tor růst!
about-dialog-browser-license-link = Informace o licencích
# Tor Bridges Settings
# Here "Bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# This is shown when the user is getting their bridges from Lox.
tor-bridges-source-lox = Přístup k mostům
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can generate a QR code for all of their bridges.
tor-bridges-menu-item-qr-all-bridge-addresses = Ukázat QR kód
    .accesskey = Q
# Tor Bridges Settings
# Used for an image of a bridge emoji. Each bridge address can be hashed into four emojis shown to the user (bridgemoji feature). This string corresponds to a *single* such emoji. The "title" should just be emojiName. The "alt" should let screen readers know that the image is of a *single* emoji, as well as its name.
# $emojiName (String) - The name of the emoji, already localized.
tor-bridges-emoji-image =
    .alt = Emoji: { $emojiName }
    .title = { $emojiName }
# Tor Bridges Settings
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-remaining-invites =
    { $numInvites ->
        [one] { $numInvites } zbývající pozvánka
       *[other] { $numInvites } zbývajících pozvánek
    }
# Tor Bridges Settings
# Shown *after* a user's "bridge pass" has changed.
# Here "invite" is a noun, short for "invitation".
# $numInvites (Number) - The number of invites remaining, an integer (0 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numInvites". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numInvites is "1" (singular) and the second form will be used if $numInvites is anything else (plural).
tor-bridges-lox-new-invites =
    { $numInvites ->
        [one] Nyní máte { $numInvites } zbývající pozvánku pro vaše důvěryhodné kontakty
       *[other] Nyní máte { $numInvites } zbývajících pozvánek pro vaše důvěryhodné kontakty
    }
# Tor Bridges Settings
tor-bridges-copy-addresses-button = Kopírovat adresy
# Tor Bridges Settings
# Shown when using a "bridge pass", i.e. using Lox.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-description = Díky Přístupu k mostům vám robot mostů pošle nové mosty, jakmile budou vaše mosty blokovány. Pokud vaše mosty nejsou blokovány, odemknete pozvánky, které vám umožní sdílet mosty s důvěryhodnými kontakty.
# Tor Bridges Settings
# Update text for screen reader users when all of their bridges have been removed.
tor-bridges-update-removed-all-bridges = Všechny vaše mosty Tor byly odebrány.
# Tor Bridges Settings
# Update text for screen reader users when their bridges have changed in some arbitrary way.
tor-bridges-update-changed-bridges = Vaše mosty Tor byly změněny.
# Tor Bridges Settings
# Toggle button for enabling and disabling the use of bridges.
tor-bridges-use-bridges =
    .label = Použít mosty
# Tor Bridges Settings
tor-bridges-none-added = Nebyl přidán ani jeden most
# Tor Bridges Settings
tor-bridges-your-bridges = Vaše mosty
# Tor Bridges Settings
tor-bridges-source-user = Vámi přidané
# Tor Bridges Settings
tor-bridges-source-built-in = Vestavěné
# Tor Bridges Settings
tor-bridges-source-requested = Obdržené od Tor
# Tor Bridges Settings
# The "..." menu button for all current bridges.
tor-bridges-options-button =
    .title = Všechny mosty
# Tor Bridges Settings
# Shown in the "..." menu for all bridges when the user can copy all of their bridges.
tor-bridges-menu-item-copy-all-bridge-addresses = Kopírovat adresy mostů
    .accesskey = C
# Tor Bridges Settings
# Only shown in the "..." menu for bridges added by the user.
tor-bridges-menu-item-edit-all-bridges = Upravit mosty
    .accesskey = E
# Tor Bridges Settings
# Shown in the "..." menu for all current bridges.
tor-bridges-menu-item-remove-all-bridges = Odebrat všechny mosty
    .accesskey = R
# Tor Bridges Settings
# Shown at the start of a Tor bridge line.
# $type (String) - The Tor bridge type ("snowflake", "obfs4", "meek-azure").
tor-bridges-type-prefix = { $type } most:
# Tor Bridges Settings
# Shown at the start of a Tor bridge line, when the transport type is unknown (or "vanilla").
tor-bridges-type-prefix-generic = Tor most:
# Tor Bridges Settings
# The emoji name to show on hover when a bridge emoji's name is unknown.
tor-bridges-emoji-unknown = Neznámé
# Tor Bridges Settings
# The "..." menu button for an individual bridge row.
tor-bridges-individual-bridge-options-button =
    .title = Možnosti mostu
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Shows the QR code for this one bridge.
tor-bridges-menu-item-qr-address = Ukázat QR kód
    .accesskey = Q
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Copies the single bridge address to clipboard.
tor-bridges-menu-item-copy-address = Kopírovat adresu mostu
    .accesskey = C
# Tor Bridges Settings
# Shown in the "..." menu for an individual bridge. Removes this one bridge.
tor-bridges-menu-item-remove-bridge = Odebrat most
    .accesskey = R
# Tor Bridges Settings
# Text shown just before a description of the most recent change to the list of user's bridges. Some white space will separate this text from the change description.
# This text is not visible, but is instead used for screen reader users.
# E.g. in English this could be "Recent update: One of your Tor bridges has been removed."
tor-bridges-update-area-intro = Nejnovější aktualizace:
# Tor Bridges Settings
# Update text for screen reader users when only one of their bridges has been removed.
tor-bridges-update-removed-one-bridge = Jeden z vašich mostů Tor byl odebrán.
# Tor Bridges Settings
tor-bridges-share-description = Sdílejte své mosty s důvěryhodnými kontakty.
# Tor Bridges Settings
tor-bridges-qr-addresses-button =
    .title = Ukázat QR kód
# Tor Bridges Settings
# The number of days until the user's "bridge pass" is upgraded.
# $numDays (Number) - The number of days until the next upgrade, an integer (1 or higher).
# The "[one]" and "[other]" are special Fluent syntax to mark plural categories that depend on the value of "$numDays". You can use any number of plural categories that work for your locale: "[zero]", "[one]", "[two]", "[few]", "[many]" and/or "[other]". The "*" marks a category as default, and is required.
# See https://projectfluent.org/fluent/guide/selectors.html .
# So in English, the first form will be used if $numDays is "1" (singular) and the second form will be used if $numDays is anything else (plural).
tor-bridges-lox-days-until-unlock =
    { $numDays ->
        [one] { $numDays } den do odemknutí:
       *[other] { $numDays } dnů do odemknutí:
    }
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain two more bridges in the future.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-unlock-two-bridges = +2 mosty od robota mostů
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user will gain access to invites for the first time.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-first-invites = Pozvánek pro vaše důvěryhodné kontakty
# Tor Bridges Settings
# This is shown as a list item after "N days until you unlock:" when the user already has invites.
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-unlock-more-invites = Více pozvánek pro vaše důvěryhodné kontakty
# Tor Bridges Settings
# Here "invites" is a noun, short for "invitations".
tor-bridges-lox-show-invites-button = Zobrazit pozvánky
# Tor Bridges Settings
# Shown when the user's "bridge pass" has been upgraded.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
tor-bridges-lox-upgrade = Váš přístup k mostům byl navýšen!
# Tor Bridges Settings
# Shown when the user's bridges accessed through "bridge pass" have been blocked.
tor-bridges-lox-blocked = Vaše blokované mosty byly nahrazeny
# Tor Bridges Settings
# Shown *after* the user has had their blocked bridges replaced.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-new-bridges = Nové mosty od robota mostů
# Tor Bridges Settings
# Shown *after* the user has gained two more bridges.
# Here "bridge bot" refers to a service that automatically gives out bridges for the user to use, i.e. the Lox authority.
tor-bridges-lox-gained-two-bridges = +2 mosty od robota mostů
# Tor Bridges Settings
# Button for the user to acknowledge a change in their "bridge pass".
tor-bridges-lox-got-it-button = Rozumím
# Tor Bridges Settings
# Shown as a heading when the user has no current bridges.
tor-bridges-add-bridges-heading = Přidat mosty
# Tor Bridges Settings
# Shown as a heading when the user has existing bridges that can be replaced.
tor-bridges-replace-bridges-heading = Nahradit vaše mosty
# Tor Bridges Settings
tor-bridges-select-built-in-description = Vyberte z { -brand-short-name } vestavěných mostů
# Tor Bridges Settings
# Used when the bridge has no status, i.e. the *absence* of a status to report to the user. This is only visibly shown when the status cell has keyboard focus.
tor-bridges-status-none = Žádný stav
# Tor Bridges Settings
tor-bridges-select-built-in-button = Vyberte vestavěný most…
# Tor Bridges Settings
# Shown when one of the built-in bridges is in use.
tor-bridges-built-in-status-connected = Připojeno
# Tor Bridges Settings
# Shown when the bridge has been used for the most recent Tor circuit, i.e. the most recent bridge we have connected to.
tor-bridges-status-connected = Připojeno
# Tor Bridges Settings
# Shown for requested bridges and bridges added by the user.
tor-bridges-share-heading = Pomozte ostatním připojit se
# User provided bridge dialog.
# Used when the user is replacing their existing bridges with new ones.
user-provide-bridge-dialog-replace-title =
    .title = Nahraďte vaše mosty
# Tor Bridges Settings
# Instructions to visit the given website.
# $url (String) - The URL for Tor Project bridges. Should be wrapped in '<a data-l10n-name"url">' and '</a>'.
tor-bridges-provider-web-instruction = Navštivte <a data-l10n-name="url">{ $url }</a>
# User provided bridge dialog.
# Used when the user is editing their existing bridge addresses.
user-provide-bridge-dialog-edit-title =
    .title = Upravte vaše mosty
# User provided bridge dialog.
# Used when the user has no existing bridges.
user-provide-bridge-dialog-add-title =
    .title = Přidejte nové mosty
# User provided bridge dialog.
# Description shown when adding new bridges, replacing existing bridges, or editing existing bridges.
user-provide-bridge-dialog-description = Použijte mosty poskytnuté důvěryhodnou organizací nebo někým, koho znáte.
# User provided bridge dialog.
# "Learn more" link shown in the "Add new bridges"/"Replace your bridges" dialog.
user-provide-bridge-dialog-learn-more = Více informací
# User provided bridge dialog.
# Short accessible name for the bridge addresses text area.
user-provide-bridge-dialog-textarea-addresses-label = Adresy mostů
# User provided bridge dialog.
# Placeholder shown when the user can add new bridge addresses or a single "bridge pass" invite.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
# NOTE: "invite" is singular, whilst "addresses" is plural.
user-provide-bridge-dialog-textarea-addresses-or-invite =
    .placeholder = Vložte sem adresy vašich mostů nebo pozvánku přístupu k mostům
# User provided bridge dialog.
# Error shown when the user has entered an invite when it is not supported.
# Here "bridge pass invite" is a noun: a bridge pass invite can be shared with other users to give them their own bridge pass, so they can get access to tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
# And "invite" is simply short for "invitation".
user-provide-bridge-dialog-invite-not-allowed-error = Není možná zahrnout pozvánku přístupu k mostům.
# User provided bridge dialog.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-connecting = Připojování k serveru přístupu k mostům…
# Built-in bridges dialog.
# Label attached to the built-in bridge option that is already in use.
# The "aria-label" should use the same text, but include some ending punctuation to separate it from the sentence that follows. This is used for screen reader users.
built-in-dialog-current-bridge-label = Aktuální most
    .aria-label = Aktuální most.
# Tor Bridges Settings
tor-bridges-add-addresses-description = Zadejte adresy mostů, které již znáte
# Tor Bridges Settings
# Shown when the user has no current bridges.
# Opens a dialog where the user can provide a new bridge address or share code.
tor-bridges-add-new-button = Přidejte nové mosty…
# Tor Bridges Settings
# Shown when the user has existing bridges.
# Opens a dialog where the user can provide a new bridge address or share code to replace their current bridges.
tor-bridges-replace-button = Nahraďte mosty…
# Tor Bridges Settings
tor-bridges-find-more-heading = Najít více mostů
# Tor Bridges Settings
# "Tor Project" is the organisation name.
tor-bridges-find-more-description = Protože adresy mnoha mostů nejsou veřejně dostupné, může být potřeba požádat o některé od Tor Project.
# Tor Bridges Settings
# "Telegram" is the common brand name of the Telegram Messenger application
tor-bridges-provider-telegram-name = Telegram
# Tor Bridges Settings
# Here "Message" is a verb, short for "Send a message to". This is an instruction to send a message to the given Telegram Messenger user to receive a new bridge.
# $telegramUserName (String) - The Telegram Messenger user name that should receive messages. Should be wrapped in '<a data-l10n-name="user">' and '</a>'.
# E.g. in English, "Message GetBridgesBot".
tor-bridges-provider-telegram-instruction = Zpráva pro <a data-l10n-name="user">{ $telegramUserName }</a>
# Tor Bridges Settings
# "Gmail" is the Google brand name. "Riseup" refers to the Riseup organisation at riseup.net.
tor-bridges-provider-email-name = Gmail nebo Riseup
# Tor Bridges Settings
# Here "Email" is a verb, short for "Send an email to". This is an instruction to send an email to the given address to receive a new bridge.
# $address (String) - The email address that should receive the email.
# E.g. in English, "Email bridges@torproject.org".
tor-bridges-provider-email-instruction = E-mail pro { $address }
# Tor Bridges Settings
tor-bridges-request-from-browser = Také můžete získat mosty od robota mostů bez opuštění { -brand-short-name }.
# Tor Bridges Settings
tor-bridges-request-button = Požádat o mosty…
# User provided bridge dialog.
# Here "invite" is a noun, short for "invitation".
# Short accessible name for text area when it can accept either bridge address or a single "bridge pass" invite.
user-provide-bridge-dialog-textarea-addresses-or-invite-label = Adresy mostů nebo pozvánka
# User provided bridge dialog.
# Placeholder shown when adding new bridge addresses.
user-provide-bridge-dialog-textarea-addresses =
    .placeholder = Vložte sem adresy vašich mostů
# User provided bridge dialog.
# Error shown when one of the address lines is invalid.
# $line (Number) - The line number for the invalid address.
user-provide-bridge-dialog-address-error = Nesprávný formát adresy mostu na řádku { $line }.
# User provided bridge dialog.
# Error shown when the user has entered more than one "bridge pass" invite.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-multiple-invites-error = Není možné zahrnout více než jednu pozvánku.
# User provided bridge dialog.
# Error shown when the user has mixed their invite with addresses.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-mixed-error = Není možné míchat adresy mostů s pozvánkou.
# User provided bridge dialog.
# Error shown when the invite was not accepted by the server.
user-provide-bridge-dialog-bad-invite-error = Zahrnutí nebylo akceptováno. Zkuste jiný.
# User provided bridge dialog.
# Error shown when the "bridge pass" server does not respond.
# Here "bridge pass" is a noun: a bridge pass gives users access to some tor bridges.
# So "pass" is referring to something that gives permission or access. Similar to "token", "permit" or "voucher", but for permanent use rather than one-time.
user-provide-bridge-dialog-no-server-error = Nepodařilo se připojit k serveru přístupu k mostům.
# User provided bridge dialog.
# Generic error when an invite failed.
# Here "invite" is a noun, short for "invitation".
user-provide-bridge-dialog-generic-invite-error = Selhalo přijetí pozvánky.
# User provided bridge dialog.
# Shown after the user has entered a "bridge pass" invite.
user-provide-bridge-dialog-result-invite = Následující mosty byly s vámi sdíleny.
# User provided bridge dialog.
# Shown after the user has entered bridge addresses.
user-provide-bridge-dialog-result-addresses = Následující mosty byly zadány vámi.
# User provided bridge dialog.
user-provide-bridge-dialog-next-button =
    .label = Další
# Tor Bridges Settings
# "Web" is the proper noun for the "World Wide Web".
tor-bridges-provider-web-name = Web
menu-new-tor-circuit =
    .label = Nová trasa Tor pro tuto stránku
    .accesskey = t
appmenuitem-new-tor-circuit =
    .label = Nová trasa Tor pro tuto stránku
toolbar-new-tor-circuit =
    .label = Nová trasa Tor pro tuto stránku
    .tooltiptext = { toolbar-new-tor-circuit.label }
tor-circuit-urlbar-button =
    .tooltiptext = Řetězec sítí Tor
tor-circuit-panel-heading = Trasa pro { $host }
tor-circuit-panel-alias = Připojeno k <a data-l10n-name="alias-link">{ $alias }</a>
tor-circuit-panel-node-list-introduction = Řetězec sítí Tor
tor-circuit-panel-node-browser = Tento prohlížeč
tor-circuit-panel-node-onion-relays = Relays Onion stránky
tor-circuit-panel-node-typed-bridge = Most: { $bridge-type }
tor-circuit-panel-node-bridge = Most
tor-circuit-panel-node-region-guard = { $region } (guard)
tor-circuit-panel-node-unknown-region = Neznámý region
tor-circuit-panel-new-button = Nová trasa Tor pro tuto stránku
tor-circuit-panel-new-button-description-guard = Váš uzel typu [Guard] se nemusí změnit
tor-circuit-panel-new-button-description-bridge = Váš most se nemusí změnit
crypto-safety-prompt-title = Adresa kryptoměny kopírovaná z nezabezpečené webové stránky
crypto-safety-prompt-body = Zkopírovaný text ({ $address }) se zdá být adresou kryptoměny. Jelikož připojení k { $host } není bezpečné, mohla být adresa změněna a nemělo by jí být důvěřováno. Můžete zkusit navázat bezpečné spojení opětovným připojením přes novou trasu Tor.
crypto-safety-prompt-reload-button = Znovu načíst panel pomocí nové trasy
crypto-safety-prompt-dismiss-button = Skrýt varování
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-type-selector-label = Typ proxy
# Tor connection settings.
tor-connection-browser-learn-more-link = Zjistit více
# Tor connection settings.
# "Connection" refers to the Tor Browser's connection to the Tor network.
tor-connection-settings-heading = Připojení
# Tor Bridges Settings.
tor-bridges-learn-more-link = Zjistit více
# Tor Bridges Settings.
# "obfs4" is a technical name, and likely should not be translated.
tor-bridges-built-in-obfs4-name = obfs4
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-description = Přesměruje vaše připojení skrze proxy servery Snowflake, čímž zajistí že to bude vypadat, jako když máte například video hovor.
# Tor connection settings.
# Shown when the user is connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-online = Online
# Tor connection settings.
tor-connection-quickstart-heading = Rychlý start
# Tor connection settings.
# Prefix before the internet connection status.
# "Internet" is not a proper noun, but is capitalized because it is the start of a sentence.
tor-connection-internet-status-label = Internet:
# Tor Bridges Settings.
tor-bridges-heading = Mosty
# Tor Bridges Settings.
tor-bridges-overview = Mosty vám pomáhají bezpečně přistoupit k síti Tor na místech, kde je Tor blokován. Podle toho, kde se nacházíte, mohou některé mosty fungovat lépe než jiné.
# Tor Bridges Settings.
tor-bridges-built-in-obfs4-description = Zajistí, že váš datový přenos Tor bude vypadat jako náhodná data. Toto nemusí fungovat v oblastech silné cenzury.
# Built-in bridges dialog.
request-bridge-dialog-top-wait = Kontaktování BridgeDB. Čekejte prosím.
# Built-in bridges dialog.
request-bridge-dialog-top-solve = Pro vyžádání mostu prosím opište kód CAPTCHA.
# Tor advanced connection settings dialog.
# "address" is a noun, referring to an network IP address.
tor-advanced-dialog-proxy-address-input-label = Adresa
# Tor connection settings.
# Shown when the user is not connected to the internet.
# Uses sentence case in English (US).
tor-connection-internet-status-offline = Offline
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-username-input-label = Uživatelské jméno
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-port-input-label = Port
# Tor connection settings.
# Shown when the user is connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connected = Připojeno
# Tor connection settings.
# Shown when the user is not connected to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-not-connected = Nepřipojeno
# Built-in bridges dialog.
request-bridge-dialog-captcha-failed = Neopsali jste kód správně. Zkuste to prosím znovu.
# Tor connection settings.
# Button to test the internet connection.
# Here "Test" is a verb, as in "test the internet connection".
# Uses sentence case in English (US).
tor-connection-internet-status-test-button = Test
# Tor connection settings.
# Shown when the user's Tor connection may be blocked.
# Uses sentence case in English (US).
tor-connection-network-status-blocked = Potenciálně Blokováno
# Tor connection settings.
# Button shown when we are not yet connected to the Tor network.
# It will open a page to start connecting to the Tor network.
# Uses sentence case in English (US).
tor-connection-network-status-connect-button = Připojit
# Tor Bridges Settings.
# "Snowflake" is a proper noun for a type of Tor bridge, and likely should not be translated.
tor-bridges-built-in-snowflake-name = Snowflake
# Tor Bridges Settings.
# "meek-azure" is a technical name, and likely should not be translated.
tor-bridges-built-in-meek-azure-name = meek-azure
# Tor Bridges Settings.
tor-bridges-built-in-meek-azure-description = Zajistí, že to bude vypadat, jako když jste připojeni k webové stránce Microsoftu, místo toho že používáte Tor. Může fungovat v oblastech se silnou cenzurou, ale rychlost je obvykle velmi nízká.
# Warning dialog when removing all bridges.
remove-all-bridges-warning-title = Odebrat Všechny Mosty?
# Warning dialog when removing all bridges.
remove-all-bridges-warning-description = Pokud byly tyto mosty získány z torproject.org a nebo přidány manuálně, tuto akci nejde vzít zpět
# Warning dialog when removing all bridges.
remove-all-bridges-warning-remove-button = Odstranit
# Common button used in bridge dialogs.
bridge-dialog-button-connect = Připojit
# Common button used in bridge dialogs.
bridge-dialog-button-accept = OK
# Common button used in bridge dialogs.
bridge-dialog-button-submit = Potvrdit
# Tor advanced settings.
tor-advanced-settings-heading = Rozšířené
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-password-input-label = Heslo
# Tor advanced settings.
# Button that opens the advanced connection settings dialog.
# Uses sentence case in English (US).
tor-advanced-settings-button = Nastavení…
tor-connection-quickstart-checkbox =
    .label = Vždy připojit automaticky
bridge-qr-dialog-title =
    .title = Skenovat QR kód
built-in-dialog-title =
    .title = Vyberte vestavěný most
built-in-dialog-snowflake-radio-option =
    .label = Snowflake
built-in-dialog-meek-azure-radio-option =
    .label = meek-azure
request-bridge-dialog-title =
    .title = Požádat o most
request-bridge-dialog-captcha-input =
    .placeholder = Zadejte písmena z obrázku
tor-log-dialog-copy-button-copied =
    .label = Zkopírováno!
tor-advanced-dialog-proxy-socks4-menuitem =
    .label = SOCKS4
tor-advanced-dialog-proxy-socks5-menuitem =
    .label = SOCKS5
tor-advanced-dialog-proxy-http-menuitem =
    .label = HTTP/HTTPS
tor-advanced-dialog-proxy-address-input =
    .placeholder = IP adresa nebo název serveru
tor-advanced-dialog-proxy-username-input =
    .placeholder = Volitelné
tor-advanced-dialog-proxy-password-input =
    .placeholder = Volitelné
tor-advanced-dialog-firewall-checkbox =
    .label = Tento počítač používá firewall, který povoluje připojení pouze přes některé porty
tor-advanced-dialog-firewall-ports-input =
    .placeholder = Hodnoty oddělené čárkami
downloads-tor-warning-title = Buďte opatrní při otevírání stažených dat
downloads-tor-warning-description = Některé soubory se mohou připojit do internetu přímo pokud je otevřete mimo Tor. Abyste byli v bezpečí, otevřete soubory když jste odpojeni od internetu v režimu offline a nebo použijte přenosný operační systém jako je <a data-l10n-name="tails-link">Tails</a>.
downloads-tor-warning-dismiss-button = Rozumím
rulesets-warning-heading = Pokračujte po uvážení
rulesets-warning-description = Přidávání nebo úprava sad pravidel může umožnit útočníkům zneužít váš prohlížeč. Pokračujte pouze pokud více, co děláte.
rulesets-warning-checkbox = Varujte mě, když se pokusím o přístup k těmto nastavením
rulesets-warning-continue-button = Souhlasit s rizikem a pokračovat
rulesets-side-panel-heading = Sady pravidel
rulesets-side-panel-no-rules = Sady pravidel nenalezeny
rulesets-update-last = Naposledy aktualizováno { DATETIME($date, dateStyle: "long") }
rulesets-update-never = Nikdy neaktualizováno a nebo poslední aktualizace selhala
rulesets-update-rule-disabled = Vypnuto
rulesets-details-edit-button = Upravit
rulesets-details-enable-checkbox = Zapnout tuto sadu pravidel
rulesets-details-update-button = Zkontrolovat aktualizace
rulesets-details-save-button = Uložit
rulesets-details-cancel-button = Zrušit
rulesets-details-jwk-input =
    .placeholder = Klíč použitý pro podepsání této sady pravidel v JWK (JSON Web Key) formátu
rulesets-details-jwk-input-invalid = JWK nemůže být zpracován a nebo nejde o platný klíč
rulesets-details-path = Předpona cesty
rulesets-details-path-input =
    .placeholder = URL předpona, která obsahuje soubory, potřebné pro sadu pravidel
rulesets-details-path-input-invalid = Předpona cesty není platnou HTTP(S) adresou
rulesets-details-scope = Rámec
rulesets-details-scope-input =
    .placeholder = Regulární výraz pro rámec pravidel
rulesets-details-scope-input-invalid = Rámec nemohl být zpracován jako regulární výraz
onion-neterror-not-found-description = Nejpravděpodobnější příčinou je, že onion stránka je offline. Kontaktuje správce onion stránky.
onion-neterror-unreachable-description = Onion stránka je nedostupná kvůli interní chybě.
onion-neterror-disconnected-description = Nejpravděpodobnější příčinou je, že onion stránka je offline. Kontaktuje správce onion stránky.
onion-neterror-connection-failed-description = Onion stránka je zaneprázdněná, nebo je síť Tor přetížená. Zkuste to později.
onion-neterror-missing-authentication-description = Přístup k onion stránce vyžaduje klíč, ale žádný nebyl poskytnut.
onion-neterror-incorrect-authetication-description = Poskytnutý klíč je nesprávný, nebo byl zrušen. Kontaktujte správce onion stránky.
onion-neterror-invalid-address-description = Zadaná adresa onion stránky je neplatná. Prosím zkontrolujte, že je zadaná správně.
onion-neterror-timed-out-description = Spojení s onion stránkou selhalo, možná kvůli slabému připojení k síti.
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-quickstart-description = Quickstart automaticky připojí { -brand-short-name } k síti Tor při spuštění na základě vašich posledních změn nastavení připojení.
# Tor connection settings.
# -brand-short-name refers to 'Tor Browser', localized.
tor-connection-overview = { -brand-short-name } přesměrovává váš provoz skrz síť Tor, která je provozovaná tísíci dobrovolníky po celém světě.
# Tor connection settings.
# Shown when testing the internet status.
# Uses sentence case in English (US).
tor-connection-internet-status-testing = Testování…
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-page-title = Problém při načítání onion stránky
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-unreachable-header = Onion stránka je nedosažitelná
# Built-in bridges dialog.
# -brand-short-name refers to 'Tor Browser', localized.
built-in-dialog-introduction = { -brand-short-name } zahrnuje některé specifické typy mostů známé jako “pluggable transports”, které mohou pomoci utajit fakt, že používáte Tor.
# Tor advanced connection settings dialog.
tor-advanced-dialog-introduction = Nastavte jak se má { -brand-short-name } připojovat k internetu.
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-title =
    .title = Tor log
# Tor advanced connection settings dialog.
tor-advanced-dialog-proxy-checkbox =
    .label = Používám proxy pro připojení k internetu
# Tor advanced connection settings dialog.
tor-advanced-dialog-title =
    .title = Nastavení připojení
# Tor advanced settings.
tor-advanced-settings-description = Nastavte jak se má { -brand-short-name } připojovat k internetu.
# Tor log dialog.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-log-dialog-copy-button =
    .label = Kopírovat Tor log do schránky
# Tor connection settings.
# Prefix before the Tor network connection status.
# Uses sentence case in English (US).
tor-connection-network-status-label = Síť Tor:
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
tor-view-log-description = Zobrazit Tor log.
# Tor advanced settings.
# "log" is a noun, referring to the recorded text output of the Tor process.
# Uses sentence case in English (US).
tor-view-log-button = Zobrazit log…
# Tor advanced connection settings dialog.
tor-advanced-dialog-firewall-ports-input-label = Povolené porty
# Built-in bridges dialog.
# "obfs4" is a technical name, and likely should not be translated.
built-in-dialog-obfs4-radio-option =
    .label = obfs4
# Side panel in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# -brand-short-name refers to 'Tor Browser', localized.
rulesets-side-panel-no-rules-description = Když uložíte sadu pravidel v { -brand-short-name }, bude vidět zde.
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-not-found-header = Onion stránka nenalezena
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-authorization-title = Vyžadováno ověření
# Ruleset details in about:rulesets. In Tor Browser, each ruleset is a set of rules for converting a ".tor.onion" address to a normal ".onion" address (used by SecureDrop). The feature is taken from the discontinued "HTTPS Everywhere".
# "JWK" refers to "JSON Web Key" and likely should not be translated.
rulesets-details-jwk = JWK
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-disconnected-header = Onion stránka se odpojila
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-connection-failed-header = Není možné se připojit k onion stránce
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-missing-authentication-header = Onion stránka vyžaduje autentizaci
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-incorrect-authentication-header = Autentizace onion stránky selhala
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
onion-neterror-invalid-address-header = Neplatná adresa onion stránky
# Onion site error page.
# "Onion site" is an abbreviation of "onion website": a website whose domain URL ends in ".onion", which is reachable through the Tor network.
# "Circuit" refers to a Tor network circuit.
onion-neterror-timed-out-header = Vypršel čas při vytváření trasy onion stránky
tor-connection-settings-category =
    .tooltiptext = { tor-connection-settings-heading }
onion-site-authentication-prompt-learn-more = Zjistit více
onion-site-authentication-prompt-remember-checkbox =
    .label = Zapamatovat si tento klíč
onion-site-authentication-prompt-invalid-key = Zadejte prosím platný klíč (52 znaků base32, nebo 44 znaků base64)
onion-site-authentication-prompt-setting-key-failed = Tor s vaším klíčem nelze nastavit
onion-site-authentication-preferences-learn-more = Zjistit více
onion-site-saved-keys-dialog-table-header-key =
    .label = Klíč
onion-site-saved-keys-dialog-remove-button = Odstranit
onion-site-saved-keys-dialog-remove-keys-error-message = Klíč nelze odstranit
downloads-tor-warning-message-bar =
    .heading = Buďte opatrní při otevírání stažených dat
    .message = Některé soubory se mohou připojit do internetu přímo pokud je otevřete mimo Tor. Abyste byli v bezpečí, otevřete soubory když jste odpojeni od internetu v režimu offline a nebo použijte přenosný operační systém jako je Tails.
onion-site-authentication-prompt-key-input =
    .placeholder = Zadejte váš soukromý klíč pro tuto onion stránku
page-info-onion-site-encryption-plain = Šifrované spojení (onion stránka)
onion-site-authentication-prompt-cancel-button =
    .label = Zrušit
    .accesskey = Z
onion-site-authentication-preferences-heading = Onion stránka - autentizace
onion-site-authentication-preferences-overview = Některé onion stránky vyžadují, abyste se před přístupem k nim identifikovali pomocí klíče (což je jakési heslo).
onion-site-saved-keys-dialog-title =
    .title = Klíče onion stránky
onion-site-saved-keys-dialog-intro = Ve vašem počítači jsou uloženy následující klíče onion stránek.
onion-site-saved-keys-dialog-table-header-site =
    .label = Onion stránka
onion-site-authentication-urlbar-button =
    .tooltiptext = Otevřít panel autentizace onion stránky
onion-site-authentication-prompt-ok-button =
    .label = OK
    .accesskey = O
onion-site-authentication-prompt-description = Onion stránka { $onionsite } žádá, abyste se autentizovali.
page-info-onion-site-encryption-with-bits = Šifrované spojení (Onion stránka, { $encryption-type }, { NUMBER($encryption-strength, useGrouping: "false") }bitové klíče, { $encryption-version })
onion-site-authentication-preferences-saved-keys-button = Uložené klíče…
onion-site-saved-keys-dialog-fetch-keys-error-message = Nelze načíst klíče z Toru
onion-site-saved-keys-dialog-remove-all-button = Odebrat vše
downloads-tor-warning-tails-link = Zjistěte více o Tails
dropped-support-notification-macos-version-less-than-10-15-extended-13-5 = { -brand-short-name } 13.5 obdrží pouze bezpečnostní aktualizace a navíc jen po omezený čas. Prosím proveďte upgrade na macOS 10.15 nebo novější pro obdržení nejnovější verze { -brand-short-name }.
dropped-support-notification-win-os-version-less-than-10-extended-13-5 = { -brand-short-name } 13.5 obdrží pouze bezpečnostní aktualizace a navíc jen po omezený čas. Prosím proveďte upgrade na Windows 10 nebo novější pro obdržení nejnovější verze { -brand-short-name }.
tor-log-dialog-table =
    .aria-label = { tor-log-dialog-title.title }
tor-connection-automatic-heading = Připojit automaticky
tor-connection-automatic-description = Automatické připojení k síti Tor při spuštění pomocí aktuálního nastavení připojení.
tor-connection-internet-status-unknown = Neznámý stav
bridge-dialog-button-connect2 =
    .label = Připojit
bridge-dialog-button-accept2 =
    .label = OK
bridge-dialog-button-submit2 =
    .label = Potvrdit
tor-settings-failed-notification-title-firewall = Vaše nastavení Tor firewallu nemohou být použita
tor-settings-failed-notification-cause-firewall = Důvodem může být neplatná informace o firewallu.
tor-settings-failed-notification-button-undo = Zrušit změny
tor-settings-failed-notification-button-clear = Smazat
tor-settings-failed-notification-body-undo = Do doby než to bude opraveno, bude vaše připojení Tor používat předchozí nastavení. Můžete buď zrušit nejnovější změny, abyste obnovili předchozí funkční nastavení, a nebo zkontrolujte Tor log a zkuste sami nalézt a opravit problém.
tor-settings-failed-notification-title-proxy = Vaše nastavení Tor proxy nemohou být použita
tor-settings-failed-notification-cause-bridges = Důvodem může být neplatná adresa mostu.
tor-settings-failed-notification-title-bridges = Vaše nastavení mostů Tor nemohou být použita
tor-settings-failed-notification-button-fix-myself = Opravím svépomocí
tor-settings-failed-notification-body-default = Do doby než to bude opraveno, bude vaše připojení Tor používat předchozí nastavení. Můžete buď smazat problematické nastavení pro obnovení do výchozího stavu a nebo zkontrolujte Tor log a zkuste problém nalézt a opravit sami.
tor-settings-failed-notification-cause-proxy = Důvodem může být neplatná informace o proxy.
built-in-dialog-meek-radio-option2 =
    .label = { tor-bridges-built-in-meek-name }
built-in-dialog-obfs4-radio-option2 =
    .label = { tor-bridges-built-in-obfs4-name }
tor-bridges-built-in-meek-name = meek
built-in-dialog-snowflake-radio-option2 =
    .label = { tor-bridges-built-in-snowflake-name }
tor-bridges-built-in-meek-description = Připojí vás k síti Tor skrze velkého poskytovatele cloudu. Může to fungovat ve značně cenzurovaných místech, je to ale obvykle velmi pomalé.
yec-donate-button = Přispějte nyní
yec-close-button =
    .title = Zavřít
yec2025-title = Osvoboďte internet
yec2025-body = Podpořte nástroje, které rozbíjejí řetězy cenzury a dohledu. <b data-l10n-name="highlight">Přispějte dnes na Tor Project.</b>
yec2025-matching = Do 31. prosince bude váš dar dorovnán 1:1, až do výše $250 000!
