import { DmgOptions, MacPackager, PlatformPackager } from "app-builder-lib";
import { TmpDir } from "builder-util";
export { DmgTarget } from "./dmg";
export declare function getDmgTemplatePath(): string;
export declare function getDmgVendorPath(): string;
export declare function attachAndExecute(dmgPath: string, readWrite: boolean, task: (devicePath: string) => Promise<any>): Promise<any>;
export declare function detach(name: string): Promise<string | null>;
export declare function computeBackground(packager: PlatformPackager<any>): Promise<string>;
type DmgBuilderConfig = {
    appPath: string;
    artifactPath: string;
    volumeName: string;
    specification: DmgOptions;
    packager: MacPackager;
};
export declare function customizeDmg({ appPath, artifactPath, volumeName, specification, packager }: DmgBuilderConfig): Promise<boolean>;
export declare function transformBackgroundFileIfNeed(file: string, tmpDir: TmpDir): Promise<string>;
export declare function getImageSizeUsingSips(background: string): Promise<{
    width: number;
    height: number;
}>;
