//// Automatically generated by generate-swift-syntax
//// Do not edit directly!
//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

import SwiftSyntax

@resultBuilder
public struct AccessorDeclListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = AccessorDeclSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = AccessorDeclListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension AccessorDeclListSyntax {
  init(@AccessorDeclListBuilder itemsBuilder: () throws -> AccessorDeclListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct ArrayElementListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = ArrayElementSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = ArrayElementListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension ArrayElementListSyntax {
  init(@ArrayElementListBuilder itemsBuilder: () throws -> ArrayElementListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct AttributeListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = AttributeListSyntax.Element
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = AttributeListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: AttributeSyntax) -> Self.Component {
    return buildExpression(.init(expression))
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: IfConfigDeclSyntax) -> Self.Component {
    return buildExpression(.init(expression))
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension AttributeListSyntax {
  init(@AttributeListBuilder itemsBuilder: () throws -> AttributeListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct AvailabilityArgumentListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = AvailabilityArgumentSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = AvailabilityArgumentListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension AvailabilityArgumentListSyntax {
  init(@AvailabilityArgumentListBuilder itemsBuilder: () throws -> AvailabilityArgumentListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct CatchClauseListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = CatchClauseSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = CatchClauseListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension CatchClauseListSyntax {
  init(@CatchClauseListBuilder itemsBuilder: () throws -> CatchClauseListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct CatchItemListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = CatchItemSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = CatchItemListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension CatchItemListSyntax {
  init(@CatchItemListBuilder itemsBuilder: () throws -> CatchItemListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct ClosureCaptureListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = ClosureCaptureSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = ClosureCaptureListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension ClosureCaptureListSyntax {
  init(@ClosureCaptureListBuilder itemsBuilder: () throws -> ClosureCaptureListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct ClosureParameterListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = ClosureParameterSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = ClosureParameterListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension ClosureParameterListSyntax {
  init(@ClosureParameterListBuilder itemsBuilder: () throws -> ClosureParameterListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct ClosureShorthandParameterListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = ClosureShorthandParameterSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = ClosureShorthandParameterListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension ClosureShorthandParameterListSyntax {
  init(@ClosureShorthandParameterListBuilder itemsBuilder: () throws -> ClosureShorthandParameterListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct CodeBlockItemListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = CodeBlockItemSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = CodeBlockItemListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension CodeBlockItemListSyntax {
  init(@CodeBlockItemListBuilder itemsBuilder: () throws -> CodeBlockItemListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct CompositionTypeElementListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = CompositionTypeElementSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = CompositionTypeElementListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension CompositionTypeElementListSyntax {
  init(@CompositionTypeElementListBuilder itemsBuilder: () throws -> CompositionTypeElementListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct ConditionElementListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = ConditionElementSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = ConditionElementListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension ConditionElementListSyntax {
  init(@ConditionElementListBuilder itemsBuilder: () throws -> ConditionElementListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct DeclModifierListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = DeclModifierSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = DeclModifierListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension DeclModifierListSyntax {
  init(@DeclModifierListBuilder itemsBuilder: () throws -> DeclModifierListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct DeclNameArgumentListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = DeclNameArgumentSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = DeclNameArgumentListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension DeclNameArgumentListSyntax {
  init(@DeclNameArgumentListBuilder itemsBuilder: () throws -> DeclNameArgumentListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct DesignatedTypeListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = DesignatedTypeSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = DesignatedTypeListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension DesignatedTypeListSyntax {
  init(@DesignatedTypeListBuilder itemsBuilder: () throws -> DesignatedTypeListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct DictionaryElementListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = DictionaryElementSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = DictionaryElementListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension DictionaryElementListSyntax {
  init(@DictionaryElementListBuilder itemsBuilder: () throws -> DictionaryElementListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct DifferentiabilityArgumentListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = DifferentiabilityArgumentSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = DifferentiabilityArgumentListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension DifferentiabilityArgumentListSyntax {
  init(@DifferentiabilityArgumentListBuilder itemsBuilder: () throws -> DifferentiabilityArgumentListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct DocumentationAttributeArgumentListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = DocumentationAttributeArgumentSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = DocumentationAttributeArgumentListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension DocumentationAttributeArgumentListSyntax {
  init(@DocumentationAttributeArgumentListBuilder itemsBuilder: () throws -> DocumentationAttributeArgumentListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct EffectsAttributeArgumentListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = TokenSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = EffectsAttributeArgumentListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension EffectsAttributeArgumentListSyntax {
  init(@EffectsAttributeArgumentListBuilder itemsBuilder: () throws -> EffectsAttributeArgumentListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct EnumCaseElementListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = EnumCaseElementSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = EnumCaseElementListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension EnumCaseElementListSyntax {
  init(@EnumCaseElementListBuilder itemsBuilder: () throws -> EnumCaseElementListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct EnumCaseParameterListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = EnumCaseParameterSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = EnumCaseParameterListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension EnumCaseParameterListSyntax {
  init(@EnumCaseParameterListBuilder itemsBuilder: () throws -> EnumCaseParameterListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct ExprListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = ExprSyntaxProtocol
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = ExprListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension ExprListSyntax {
  init(@ExprListBuilder itemsBuilder: () throws -> ExprListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct FunctionParameterListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = FunctionParameterSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = FunctionParameterListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension FunctionParameterListSyntax {
  init(@FunctionParameterListBuilder itemsBuilder: () throws -> FunctionParameterListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct GenericArgumentListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = GenericArgumentSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = GenericArgumentListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension GenericArgumentListSyntax {
  init(@GenericArgumentListBuilder itemsBuilder: () throws -> GenericArgumentListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct GenericParameterListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = GenericParameterSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = GenericParameterListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension GenericParameterListSyntax {
  init(@GenericParameterListBuilder itemsBuilder: () throws -> GenericParameterListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct GenericRequirementListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = GenericRequirementSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = GenericRequirementListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension GenericRequirementListSyntax {
  init(@GenericRequirementListBuilder itemsBuilder: () throws -> GenericRequirementListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct IfConfigClauseListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = IfConfigClauseSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = IfConfigClauseListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension IfConfigClauseListSyntax {
  init(@IfConfigClauseListBuilder itemsBuilder: () throws -> IfConfigClauseListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct ImportPathComponentListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = ImportPathComponentSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = ImportPathComponentListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension ImportPathComponentListSyntax {
  init(@ImportPathComponentListBuilder itemsBuilder: () throws -> ImportPathComponentListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct InheritedTypeListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = InheritedTypeSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = InheritedTypeListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension InheritedTypeListSyntax {
  init(@InheritedTypeListBuilder itemsBuilder: () throws -> InheritedTypeListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct KeyPathComponentListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = KeyPathComponentSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = KeyPathComponentListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension KeyPathComponentListSyntax {
  init(@KeyPathComponentListBuilder itemsBuilder: () throws -> KeyPathComponentListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct LabeledExprListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = LabeledExprSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = LabeledExprListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension LabeledExprListSyntax {
  init(@LabeledExprListBuilder itemsBuilder: () throws -> LabeledExprListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct MemberBlockItemListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = MemberBlockItemSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = MemberBlockItemListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension MemberBlockItemListSyntax {
  init(@MemberBlockItemListBuilder itemsBuilder: () throws -> MemberBlockItemListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct MultipleTrailingClosureElementListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = MultipleTrailingClosureElementSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = MultipleTrailingClosureElementListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension MultipleTrailingClosureElementListSyntax {
  init(@MultipleTrailingClosureElementListBuilder itemsBuilder: () throws -> MultipleTrailingClosureElementListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct ObjCSelectorPieceListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = ObjCSelectorPieceSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = ObjCSelectorPieceListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension ObjCSelectorPieceListSyntax {
  init(@ObjCSelectorPieceListBuilder itemsBuilder: () throws -> ObjCSelectorPieceListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct PatternBindingListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = PatternBindingSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = PatternBindingListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension PatternBindingListSyntax {
  init(@PatternBindingListBuilder itemsBuilder: () throws -> PatternBindingListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct PlatformVersionItemListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = PlatformVersionItemSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = PlatformVersionItemListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension PlatformVersionItemListSyntax {
  init(@PlatformVersionItemListBuilder itemsBuilder: () throws -> PlatformVersionItemListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct PrecedenceGroupAttributeListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = PrecedenceGroupAttributeListSyntax.Element
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = PrecedenceGroupAttributeListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: PrecedenceGroupRelationSyntax) -> Self.Component {
    return buildExpression(.init(expression))
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: PrecedenceGroupAssignmentSyntax) -> Self.Component {
    return buildExpression(.init(expression))
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: PrecedenceGroupAssociativitySyntax) -> Self.Component {
    return buildExpression(.init(expression))
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension PrecedenceGroupAttributeListSyntax {
  init(@PrecedenceGroupAttributeListBuilder itemsBuilder: () throws -> PrecedenceGroupAttributeListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct PrecedenceGroupNameListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = PrecedenceGroupNameSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = PrecedenceGroupNameListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension PrecedenceGroupNameListSyntax {
  init(@PrecedenceGroupNameListBuilder itemsBuilder: () throws -> PrecedenceGroupNameListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct PrimaryAssociatedTypeListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = PrimaryAssociatedTypeSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = PrimaryAssociatedTypeListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension PrimaryAssociatedTypeListSyntax {
  init(@PrimaryAssociatedTypeListBuilder itemsBuilder: () throws -> PrimaryAssociatedTypeListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct SimpleStringLiteralSegmentListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = StringSegmentSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = SimpleStringLiteralSegmentListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension SimpleStringLiteralSegmentListSyntax {
  init(@SimpleStringLiteralSegmentListBuilder itemsBuilder: () throws -> SimpleStringLiteralSegmentListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct SpecializeAttributeArgumentListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = SpecializeAttributeArgumentListSyntax.Element
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = SpecializeAttributeArgumentListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: LabeledSpecializeArgumentSyntax) -> Self.Component {
    return buildExpression(.init(expression))
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: SpecializeAvailabilityArgumentSyntax) -> Self.Component {
    return buildExpression(.init(expression))
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: SpecializeTargetFunctionArgumentSyntax) -> Self.Component {
    return buildExpression(.init(expression))
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: GenericWhereClauseSyntax) -> Self.Component {
    return buildExpression(.init(expression))
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension SpecializeAttributeArgumentListSyntax {
  init(@SpecializeAttributeArgumentListBuilder itemsBuilder: () throws -> SpecializeAttributeArgumentListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct StringLiteralSegmentListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = StringLiteralSegmentListSyntax.Element
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = StringLiteralSegmentListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: StringSegmentSyntax) -> Self.Component {
    return buildExpression(.init(expression))
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: ExpressionSegmentSyntax) -> Self.Component {
    return buildExpression(.init(expression))
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension StringLiteralSegmentListSyntax {
  init(@StringLiteralSegmentListBuilder itemsBuilder: () throws -> StringLiteralSegmentListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct SwitchCaseItemListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = SwitchCaseItemSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = SwitchCaseItemListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension SwitchCaseItemListSyntax {
  init(@SwitchCaseItemListBuilder itemsBuilder: () throws -> SwitchCaseItemListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct SwitchCaseListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = SwitchCaseListSyntax.Element
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = SwitchCaseListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: SwitchCaseSyntax) -> Self.Component {
    return buildExpression(.init(expression))
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: IfConfigDeclSyntax) -> Self.Component {
    return buildExpression(.init(expression))
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension SwitchCaseListSyntax {
  init(@SwitchCaseListBuilder itemsBuilder: () throws -> SwitchCaseListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct TuplePatternElementListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = TuplePatternElementSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = TuplePatternElementListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension TuplePatternElementListSyntax {
  init(@TuplePatternElementListBuilder itemsBuilder: () throws -> TuplePatternElementListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct TupleTypeElementListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = TupleTypeElementSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = TupleTypeElementListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    let lastIndex = component.count - 1
    return .init(component.enumerated().map { index, source in
      return index < lastIndex ? source.ensuringTrailingComma() : source
      })
  }
}

public extension TupleTypeElementListSyntax {
  init(@TupleTypeElementListBuilder itemsBuilder: () throws -> TupleTypeElementListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct UnexpectedNodesBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = SyntaxProtocol
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = UnexpectedNodesSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension UnexpectedNodesSyntax {
  init(@UnexpectedNodesBuilder itemsBuilder: () throws -> UnexpectedNodesSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct VersionComponentListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = VersionComponentSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = VersionComponentListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension VersionComponentListSyntax {
  init(@VersionComponentListBuilder itemsBuilder: () throws -> VersionComponentListSyntax) rethrows {
    self = try itemsBuilder()
  }
}

@resultBuilder
public struct YieldedExpressionListBuilder {
  /// The type of individual statement expressions in the transformed function,
  /// which defaults to Component if buildExpression() is not provided.
  public typealias Expression = YieldedExpressionSyntax
  
  /// The type of a partial result, which will be carried through all of the
  /// build methods.
  public typealias Component = [Expression]
  
  /// The type of the final returned result, which defaults to Component if
  /// buildFinalResult() is not provided.
  public typealias FinalResult = YieldedExpressionListSyntax
  
  /// Required by every result builder to build combined results from
  /// statement blocks.
  public static func buildBlock(_ components: Self.Component...) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, provides contextual type information for statement
  /// expressions to translate them into partial results.
  public static func buildExpression(_ expression: Self.Expression) -> Self.Component {
    return [expression]
  }
  
  /// Add all the elements of `expression` to this result builder, effectively flattening them.
  ///
  /// - Note: This overload is disfavored to resolve an ambiguity when both the final result and
  ///   the elements are expressible by string interpolation. In that case we favor creating a
  ///   single element from the string literal.
  @_disfavoredOverload
  public static func buildExpression(_ expression: Self.FinalResult) -> Self.Component {
    return expression.map {
      $0
    }
  }
  
  /// Enables support for `if` statements that do not have an `else`.
  public static func buildOptional(_ component: Self.Component?) -> Self.Component {
    return component ?? []
  }
  
  /// With buildEither(second:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(first component: Self.Component) -> Self.Component {
    return component
  }
  
  /// With buildEither(first:), enables support for 'if-else' and 'switch'
  /// statements by folding conditional results into a single result.
  public static func buildEither(second component: Self.Component) -> Self.Component {
    return component
  }
  
  /// Enables support for 'for..in' loops by combining the
  /// results of all iterations into a single result.
  public static func buildArray(_ components: [Self.Component]) -> Self.Component {
    return components.flatMap {
      $0
    }
  }
  
  /// If declared, this will be called on the partial result of an 'if'
  /// #available' block to allow the result builder to erase type
  /// information.
  public static func buildLimitedAvailability(_ component: Self.Component) -> Self.Component {
    return component
  }
  
  /// If declared, this will be called on the partial result from the outermost
  /// block statement to produce the final returned result.
  public static func buildFinalResult(_ component: Component) -> FinalResult {
    return .init(component)
  }
}

public extension YieldedExpressionListSyntax {
  init(@YieldedExpressionListBuilder itemsBuilder: () throws -> YieldedExpressionListSyntax) rethrows {
    self = try itemsBuilder()
  }
}
