//// Automatically generated by generate-swift-syntax
//// Do not edit directly!
//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

// MARK: - TernaryExprSyntax

/// ### Children
/// 
///  - `condition`: ``ExprSyntax``
///  - `questionMark`: `'?'`
///  - `thenExpression`: ``ExprSyntax``
///  - `colon`: `':'`
///  - `elseExpression`: ``ExprSyntax``
public struct TernaryExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .ternaryExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeCondition: UnexpectedNodesSyntax? = nil,
      condition: some ExprSyntaxProtocol,
      _ unexpectedBetweenConditionAndQuestionMark: UnexpectedNodesSyntax? = nil,
      questionMark: TokenSyntax = .infixQuestionMarkToken(),
      _ unexpectedBetweenQuestionMarkAndThenExpression: UnexpectedNodesSyntax? = nil,
      thenExpression: some ExprSyntaxProtocol,
      _ unexpectedBetweenThenExpressionAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax = .colonToken(),
      _ unexpectedBetweenColonAndElseExpression: UnexpectedNodesSyntax? = nil,
      elseExpression: some ExprSyntaxProtocol,
      _ unexpectedAfterElseExpression: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeCondition, 
            condition, 
            unexpectedBetweenConditionAndQuestionMark, 
            questionMark, 
            unexpectedBetweenQuestionMarkAndThenExpression, 
            thenExpression, 
            unexpectedBetweenThenExpressionAndColon, 
            colon, 
            unexpectedBetweenColonAndElseExpression, 
            elseExpression, 
            unexpectedAfterElseExpression
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeCondition?.raw, 
          condition.raw, 
          unexpectedBetweenConditionAndQuestionMark?.raw, 
          questionMark.raw, 
          unexpectedBetweenQuestionMarkAndThenExpression?.raw, 
          thenExpression.raw, 
          unexpectedBetweenThenExpressionAndColon?.raw, 
          colon.raw, 
          unexpectedBetweenColonAndElseExpression?.raw, 
          elseExpression.raw, 
          unexpectedAfterElseExpression?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.ternaryExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeCondition: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(TernaryExprSyntax.self)
    }
  }
  
  public var condition: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(TernaryExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenConditionAndQuestionMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(TernaryExprSyntax.self)
    }
  }
  
  public var questionMark: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(TernaryExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenQuestionMarkAndThenExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(TernaryExprSyntax.self)
    }
  }
  
  public var thenExpression: ExprSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(TernaryExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenThenExpressionAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(TernaryExprSyntax.self)
    }
  }
  
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(TernaryExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndElseExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(TernaryExprSyntax.self)
    }
  }
  
  public var elseExpression: ExprSyntax {
    get {
      return Syntax(self).child(at: 9)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(TernaryExprSyntax.self)
    }
  }
  
  public var unexpectedAfterElseExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(TernaryExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeCondition, 
          \Self.condition, 
          \Self.unexpectedBetweenConditionAndQuestionMark, 
          \Self.questionMark, 
          \Self.unexpectedBetweenQuestionMarkAndThenExpression, 
          \Self.thenExpression, 
          \Self.unexpectedBetweenThenExpressionAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndElseExpression, 
          \Self.elseExpression, 
          \Self.unexpectedAfterElseExpression
        ])
  }
}

// MARK: - ThenStmtSyntax

/// A statement used to indicate the produced value from an if/switch
/// expression.
/// 
///  Written as:
/// ```swift
/// then <expr>
/// ```
///
/// ### Children
/// 
///  - `thenKeyword`: `'then'`
///  - `expression`: ``ExprSyntax``
public struct ThenStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .thenStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeThenKeyword: UnexpectedNodesSyntax? = nil,
      thenKeyword: TokenSyntax = .keyword(.then),
      _ unexpectedBetweenThenKeywordAndExpression: UnexpectedNodesSyntax? = nil,
      expression: some ExprSyntaxProtocol,
      _ unexpectedAfterExpression: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeThenKeyword, 
            thenKeyword, 
            unexpectedBetweenThenKeywordAndExpression, 
            expression, 
            unexpectedAfterExpression
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeThenKeyword?.raw, 
          thenKeyword.raw, 
          unexpectedBetweenThenKeywordAndExpression?.raw, 
          expression.raw, 
          unexpectedAfterExpression?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.thenStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeThenKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ThenStmtSyntax.self)
    }
  }
  
  public var thenKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ThenStmtSyntax.self)
    }
  }
  
  public var unexpectedBetweenThenKeywordAndExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ThenStmtSyntax.self)
    }
  }
  
  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ThenStmtSyntax.self)
    }
  }
  
  public var unexpectedAfterExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ThenStmtSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeThenKeyword, 
          \Self.thenKeyword, 
          \Self.unexpectedBetweenThenKeywordAndExpression, 
          \Self.expression, 
          \Self.unexpectedAfterExpression
        ])
  }
}

// MARK: - ThrowStmtSyntax

/// ### Children
/// 
///  - `throwKeyword`: `'throw'`
///  - `expression`: ``ExprSyntax``
public struct ThrowStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .throwStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeThrowKeyword: UnexpectedNodesSyntax? = nil,
      throwKeyword: TokenSyntax = .keyword(.throw),
      _ unexpectedBetweenThrowKeywordAndExpression: UnexpectedNodesSyntax? = nil,
      expression: some ExprSyntaxProtocol,
      _ unexpectedAfterExpression: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeThrowKeyword, 
            throwKeyword, 
            unexpectedBetweenThrowKeywordAndExpression, 
            expression, 
            unexpectedAfterExpression
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeThrowKeyword?.raw, 
          throwKeyword.raw, 
          unexpectedBetweenThrowKeywordAndExpression?.raw, 
          expression.raw, 
          unexpectedAfterExpression?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.throwStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeThrowKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ThrowStmtSyntax.self)
    }
  }
  
  public var throwKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ThrowStmtSyntax.self)
    }
  }
  
  public var unexpectedBetweenThrowKeywordAndExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ThrowStmtSyntax.self)
    }
  }
  
  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ThrowStmtSyntax.self)
    }
  }
  
  public var unexpectedAfterExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ThrowStmtSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeThrowKeyword, 
          \Self.throwKeyword, 
          \Self.unexpectedBetweenThrowKeywordAndExpression, 
          \Self.expression, 
          \Self.unexpectedAfterExpression
        ])
  }
}

// MARK: - TryExprSyntax

/// ### Children
/// 
///  - `tryKeyword`: `'try'`
///  - `questionOrExclamationMark`: (`'?'` | `'!'`)?
///  - `expression`: ``ExprSyntax``
public struct TryExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .tryExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeTryKeyword: UnexpectedNodesSyntax? = nil,
      tryKeyword: TokenSyntax = .keyword(.try),
      _ unexpectedBetweenTryKeywordAndQuestionOrExclamationMark: UnexpectedNodesSyntax? = nil,
      questionOrExclamationMark: TokenSyntax? = nil,
      _ unexpectedBetweenQuestionOrExclamationMarkAndExpression: UnexpectedNodesSyntax? = nil,
      expression: some ExprSyntaxProtocol,
      _ unexpectedAfterExpression: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeTryKeyword, 
            tryKeyword, 
            unexpectedBetweenTryKeywordAndQuestionOrExclamationMark, 
            questionOrExclamationMark, 
            unexpectedBetweenQuestionOrExclamationMarkAndExpression, 
            expression, 
            unexpectedAfterExpression
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeTryKeyword?.raw, 
          tryKeyword.raw, 
          unexpectedBetweenTryKeywordAndQuestionOrExclamationMark?.raw, 
          questionOrExclamationMark?.raw, 
          unexpectedBetweenQuestionOrExclamationMarkAndExpression?.raw, 
          expression.raw, 
          unexpectedAfterExpression?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.tryExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeTryKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(TryExprSyntax.self)
    }
  }
  
  public var tryKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(TryExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenTryKeywordAndQuestionOrExclamationMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(TryExprSyntax.self)
    }
  }
  
  public var questionOrExclamationMark: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(TryExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenQuestionOrExclamationMarkAndExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(TryExprSyntax.self)
    }
  }
  
  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(TryExprSyntax.self)
    }
  }
  
  public var unexpectedAfterExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(TryExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeTryKeyword, 
          \Self.tryKeyword, 
          \Self.unexpectedBetweenTryKeywordAndQuestionOrExclamationMark, 
          \Self.questionOrExclamationMark, 
          \Self.unexpectedBetweenQuestionOrExclamationMarkAndExpression, 
          \Self.expression, 
          \Self.unexpectedAfterExpression
        ])
  }
}

// MARK: - TupleExprSyntax

/// ### Children
/// 
///  - `leftParen`: `'('`
///  - `elements`: ``LabeledExprListSyntax``
///  - `rightParen`: `')'`
public struct TupleExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .tupleExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLeftParen: UnexpectedNodesSyntax? = nil,
      leftParen: TokenSyntax = .leftParenToken(),
      _ unexpectedBetweenLeftParenAndElements: UnexpectedNodesSyntax? = nil,
      elements: LabeledExprListSyntax,
      _ unexpectedBetweenElementsAndRightParen: UnexpectedNodesSyntax? = nil,
      rightParen: TokenSyntax = .rightParenToken(),
      _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLeftParen, 
            leftParen, 
            unexpectedBetweenLeftParenAndElements, 
            elements, 
            unexpectedBetweenElementsAndRightParen, 
            rightParen, 
            unexpectedAfterRightParen
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLeftParen?.raw, 
          leftParen.raw, 
          unexpectedBetweenLeftParenAndElements?.raw, 
          elements.raw, 
          unexpectedBetweenElementsAndRightParen?.raw, 
          rightParen.raw, 
          unexpectedAfterRightParen?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.tupleExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(TupleExprSyntax.self)
    }
  }
  
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(TupleExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftParenAndElements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(TupleExprSyntax.self)
    }
  }
  
  public var elements: LabeledExprListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(LabeledExprListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(TupleExprSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `elements`
  /// collection.
  ///
  /// - param element: The new `Element` to add to the node's
  ///                  `elements` collection.
  /// - returns: A copy of the receiver with the provided `Element`
  ///            appended to its `elements` collection.
  @available(*, deprecated, message: "Use node.elements.append(newElement) instead")
  public func addElement(_ element: LabeledExprSyntax) -> TupleExprSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.labeledExprList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(TupleExprSyntax.self)
  }
  
  public var unexpectedBetweenElementsAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(TupleExprSyntax.self)
    }
  }
  
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(TupleExprSyntax.self)
    }
  }
  
  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(TupleExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLeftParen, 
          \Self.leftParen, 
          \Self.unexpectedBetweenLeftParenAndElements, 
          \Self.elements, 
          \Self.unexpectedBetweenElementsAndRightParen, 
          \Self.rightParen, 
          \Self.unexpectedAfterRightParen
        ])
  }
}

// MARK: - TuplePatternElementSyntax

/// ### Children
/// 
///  - `label`: `<identifier>`?
///  - `colon`: `':'`?
///  - `pattern`: ``PatternSyntax``
///  - `trailingComma`: `','`?
///
/// ### Contained in
/// 
///  - ``TuplePatternElementListSyntax``
public struct TuplePatternElementSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .tuplePatternElement else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLabel: UnexpectedNodesSyntax? = nil,
      label: TokenSyntax? = nil,
      _ unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax? = nil,
      _ unexpectedBetweenColonAndPattern: UnexpectedNodesSyntax? = nil,
      pattern: some PatternSyntaxProtocol,
      _ unexpectedBetweenPatternAndTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingComma: TokenSyntax? = nil,
      _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLabel, 
            label, 
            unexpectedBetweenLabelAndColon, 
            colon, 
            unexpectedBetweenColonAndPattern, 
            pattern, 
            unexpectedBetweenPatternAndTrailingComma, 
            trailingComma, 
            unexpectedAfterTrailingComma
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLabel?.raw, 
          label?.raw, 
          unexpectedBetweenLabelAndColon?.raw, 
          colon?.raw, 
          unexpectedBetweenColonAndPattern?.raw, 
          pattern.raw, 
          unexpectedBetweenPatternAndTrailingComma?.raw, 
          trailingComma?.raw, 
          unexpectedAfterTrailingComma?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.tuplePatternElement,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(TuplePatternElementSyntax.self)
    }
  }
  
  public var label: TokenSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(TuplePatternElementSyntax.self)
    }
  }
  
  public var unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(TuplePatternElementSyntax.self)
    }
  }
  
  public var colon: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(TuplePatternElementSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndPattern: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(TuplePatternElementSyntax.self)
    }
  }
  
  public var pattern: PatternSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(PatternSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(TuplePatternElementSyntax.self)
    }
  }
  
  public var unexpectedBetweenPatternAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(TuplePatternElementSyntax.self)
    }
  }
  
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(TuplePatternElementSyntax.self)
    }
  }
  
  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(TuplePatternElementSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLabel, 
          \Self.label, 
          \Self.unexpectedBetweenLabelAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndPattern, 
          \Self.pattern, 
          \Self.unexpectedBetweenPatternAndTrailingComma, 
          \Self.trailingComma, 
          \Self.unexpectedAfterTrailingComma
        ])
  }
}

// MARK: - TuplePatternSyntax

/// ### Children
/// 
///  - `leftParen`: `'('`
///  - `elements`: ``TuplePatternElementListSyntax``
///  - `rightParen`: `')'`
public struct TuplePatternSyntax: PatternSyntaxProtocol, SyntaxHashable, _LeafPatternSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .tuplePattern else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLeftParen: UnexpectedNodesSyntax? = nil,
      leftParen: TokenSyntax = .leftParenToken(),
      _ unexpectedBetweenLeftParenAndElements: UnexpectedNodesSyntax? = nil,
      elements: TuplePatternElementListSyntax,
      _ unexpectedBetweenElementsAndRightParen: UnexpectedNodesSyntax? = nil,
      rightParen: TokenSyntax = .rightParenToken(),
      _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLeftParen, 
            leftParen, 
            unexpectedBetweenLeftParenAndElements, 
            elements, 
            unexpectedBetweenElementsAndRightParen, 
            rightParen, 
            unexpectedAfterRightParen
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLeftParen?.raw, 
          leftParen.raw, 
          unexpectedBetweenLeftParenAndElements?.raw, 
          elements.raw, 
          unexpectedBetweenElementsAndRightParen?.raw, 
          rightParen.raw, 
          unexpectedAfterRightParen?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.tuplePattern,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(TuplePatternSyntax.self)
    }
  }
  
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(TuplePatternSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftParenAndElements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(TuplePatternSyntax.self)
    }
  }
  
  public var elements: TuplePatternElementListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TuplePatternElementListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(TuplePatternSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `elements`
  /// collection.
  ///
  /// - param element: The new `Element` to add to the node's
  ///                  `elements` collection.
  /// - returns: A copy of the receiver with the provided `Element`
  ///            appended to its `elements` collection.
  @available(*, deprecated, message: "Use node.elements.append(newElement) instead")
  public func addElement(_ element: TuplePatternElementSyntax) -> TuplePatternSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.tuplePatternElementList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(TuplePatternSyntax.self)
  }
  
  public var unexpectedBetweenElementsAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(TuplePatternSyntax.self)
    }
  }
  
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(TuplePatternSyntax.self)
    }
  }
  
  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(TuplePatternSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLeftParen, 
          \Self.leftParen, 
          \Self.unexpectedBetweenLeftParenAndElements, 
          \Self.elements, 
          \Self.unexpectedBetweenElementsAndRightParen, 
          \Self.rightParen, 
          \Self.unexpectedAfterRightParen
        ])
  }
}

// MARK: - TupleTypeElementSyntax

/// ### Children
/// 
///  - `inoutKeyword`: `'inout'`?
///  - `firstName`: (`<identifier>` | `'_'`)?
///  - `secondName`: (`<identifier>` | `'_'`)?
///  - `colon`: `':'`?
///  - `type`: ``TypeSyntax``
///  - `ellipsis`: `'...'`?
///  - `trailingComma`: `','`?
///
/// ### Contained in
/// 
///  - ``TupleTypeElementListSyntax``
public struct TupleTypeElementSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .tupleTypeElement else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeInoutKeyword: UnexpectedNodesSyntax? = nil,
      inoutKeyword: TokenSyntax? = nil,
      _ unexpectedBetweenInoutKeywordAndFirstName: UnexpectedNodesSyntax? = nil,
      firstName: TokenSyntax? = nil,
      _ unexpectedBetweenFirstNameAndSecondName: UnexpectedNodesSyntax? = nil,
      secondName: TokenSyntax? = nil,
      _ unexpectedBetweenSecondNameAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax? = nil,
      _ unexpectedBetweenColonAndType: UnexpectedNodesSyntax? = nil,
      type: some TypeSyntaxProtocol,
      _ unexpectedBetweenTypeAndEllipsis: UnexpectedNodesSyntax? = nil,
      ellipsis: TokenSyntax? = nil,
      _ unexpectedBetweenEllipsisAndTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingComma: TokenSyntax? = nil,
      _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeInoutKeyword, 
            inoutKeyword, 
            unexpectedBetweenInoutKeywordAndFirstName, 
            firstName, 
            unexpectedBetweenFirstNameAndSecondName, 
            secondName, 
            unexpectedBetweenSecondNameAndColon, 
            colon, 
            unexpectedBetweenColonAndType, 
            type, 
            unexpectedBetweenTypeAndEllipsis, 
            ellipsis, 
            unexpectedBetweenEllipsisAndTrailingComma, 
            trailingComma, 
            unexpectedAfterTrailingComma
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeInoutKeyword?.raw, 
          inoutKeyword?.raw, 
          unexpectedBetweenInoutKeywordAndFirstName?.raw, 
          firstName?.raw, 
          unexpectedBetweenFirstNameAndSecondName?.raw, 
          secondName?.raw, 
          unexpectedBetweenSecondNameAndColon?.raw, 
          colon?.raw, 
          unexpectedBetweenColonAndType?.raw, 
          type.raw, 
          unexpectedBetweenTypeAndEllipsis?.raw, 
          ellipsis?.raw, 
          unexpectedBetweenEllipsisAndTrailingComma?.raw, 
          trailingComma?.raw, 
          unexpectedAfterTrailingComma?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.tupleTypeElement,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeInoutKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeElementSyntax.self)
    }
  }
  
  public var inoutKeyword: TokenSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeElementSyntax.self)
    }
  }
  
  public var unexpectedBetweenInoutKeywordAndFirstName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeElementSyntax.self)
    }
  }
  
  public var firstName: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeElementSyntax.self)
    }
  }
  
  public var unexpectedBetweenFirstNameAndSecondName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeElementSyntax.self)
    }
  }
  
  public var secondName: TokenSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeElementSyntax.self)
    }
  }
  
  public var unexpectedBetweenSecondNameAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeElementSyntax.self)
    }
  }
  
  public var colon: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeElementSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeElementSyntax.self)
    }
  }
  
  public var type: TypeSyntax {
    get {
      return Syntax(self).child(at: 9)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeElementSyntax.self)
    }
  }
  
  public var unexpectedBetweenTypeAndEllipsis: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeElementSyntax.self)
    }
  }
  
  public var ellipsis: TokenSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeElementSyntax.self)
    }
  }
  
  public var unexpectedBetweenEllipsisAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeElementSyntax.self)
    }
  }
  
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeElementSyntax.self)
    }
  }
  
  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeElementSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeInoutKeyword, 
          \Self.inoutKeyword, 
          \Self.unexpectedBetweenInoutKeywordAndFirstName, 
          \Self.firstName, 
          \Self.unexpectedBetweenFirstNameAndSecondName, 
          \Self.secondName, 
          \Self.unexpectedBetweenSecondNameAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndType, 
          \Self.type, 
          \Self.unexpectedBetweenTypeAndEllipsis, 
          \Self.ellipsis, 
          \Self.unexpectedBetweenEllipsisAndTrailingComma, 
          \Self.trailingComma, 
          \Self.unexpectedAfterTrailingComma
        ])
  }
}

// MARK: - TupleTypeSyntax

/// ### Children
/// 
///  - `leftParen`: `'('`
///  - `elements`: ``TupleTypeElementListSyntax``
///  - `rightParen`: `')'`
public struct TupleTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .tupleType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLeftParen: UnexpectedNodesSyntax? = nil,
      leftParen: TokenSyntax = .leftParenToken(),
      _ unexpectedBetweenLeftParenAndElements: UnexpectedNodesSyntax? = nil,
      elements: TupleTypeElementListSyntax,
      _ unexpectedBetweenElementsAndRightParen: UnexpectedNodesSyntax? = nil,
      rightParen: TokenSyntax = .rightParenToken(),
      _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLeftParen, 
            leftParen, 
            unexpectedBetweenLeftParenAndElements, 
            elements, 
            unexpectedBetweenElementsAndRightParen, 
            rightParen, 
            unexpectedAfterRightParen
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLeftParen?.raw, 
          leftParen.raw, 
          unexpectedBetweenLeftParenAndElements?.raw, 
          elements.raw, 
          unexpectedBetweenElementsAndRightParen?.raw, 
          rightParen.raw, 
          unexpectedAfterRightParen?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.tupleType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeSyntax.self)
    }
  }
  
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftParenAndElements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeSyntax.self)
    }
  }
  
  public var elements: TupleTypeElementListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TupleTypeElementListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `elements`
  /// collection.
  ///
  /// - param element: The new `Element` to add to the node's
  ///                  `elements` collection.
  /// - returns: A copy of the receiver with the provided `Element`
  ///            appended to its `elements` collection.
  @available(*, deprecated, message: "Use node.elements.append(newElement) instead")
  public func addElement(_ element: TupleTypeElementSyntax) -> TupleTypeSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.tupleTypeElementList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(TupleTypeSyntax.self)
  }
  
  public var unexpectedBetweenElementsAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeSyntax.self)
    }
  }
  
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeSyntax.self)
    }
  }
  
  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(TupleTypeSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLeftParen, 
          \Self.leftParen, 
          \Self.unexpectedBetweenLeftParenAndElements, 
          \Self.elements, 
          \Self.unexpectedBetweenElementsAndRightParen, 
          \Self.rightParen, 
          \Self.unexpectedAfterRightParen
        ])
  }
}

// MARK: - TypeAliasDeclSyntax

/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `typealiasKeyword`: `'typealias'`
///  - `name`: `<identifier>`
///  - `genericParameterClause`: ``GenericParameterClauseSyntax``?
///  - `initializer`: ``TypeInitializerClauseSyntax``
///  - `genericWhereClause`: ``GenericWhereClauseSyntax``?
public struct TypeAliasDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .typeAliasDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - genericParameterClause: The parameter clause that defines the generic parameters.
  ///   - genericWhereClause: A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
      attributes: AttributeListSyntax = [],
      _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
      modifiers: DeclModifierListSyntax = [],
      _ unexpectedBetweenModifiersAndTypealiasKeyword: UnexpectedNodesSyntax? = nil,
      typealiasKeyword: TokenSyntax = .keyword(.typealias),
      _ unexpectedBetweenTypealiasKeywordAndName: UnexpectedNodesSyntax? = nil,
      name: TokenSyntax,
      _ unexpectedBetweenNameAndGenericParameterClause: UnexpectedNodesSyntax? = nil,
      genericParameterClause: GenericParameterClauseSyntax? = nil,
      _ unexpectedBetweenGenericParameterClauseAndInitializer: UnexpectedNodesSyntax? = nil,
      initializer: TypeInitializerClauseSyntax,
      _ unexpectedBetweenInitializerAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
      genericWhereClause: GenericWhereClauseSyntax? = nil,
      _ unexpectedAfterGenericWhereClause: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAttributes, 
            attributes, 
            unexpectedBetweenAttributesAndModifiers, 
            modifiers, 
            unexpectedBetweenModifiersAndTypealiasKeyword, 
            typealiasKeyword, 
            unexpectedBetweenTypealiasKeywordAndName, 
            name, 
            unexpectedBetweenNameAndGenericParameterClause, 
            genericParameterClause, 
            unexpectedBetweenGenericParameterClauseAndInitializer, 
            initializer, 
            unexpectedBetweenInitializerAndGenericWhereClause, 
            genericWhereClause, 
            unexpectedAfterGenericWhereClause
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAttributes?.raw, 
          attributes.raw, 
          unexpectedBetweenAttributesAndModifiers?.raw, 
          modifiers.raw, 
          unexpectedBetweenModifiersAndTypealiasKeyword?.raw, 
          typealiasKeyword.raw, 
          unexpectedBetweenTypealiasKeywordAndName?.raw, 
          name.raw, 
          unexpectedBetweenNameAndGenericParameterClause?.raw, 
          genericParameterClause?.raw, 
          unexpectedBetweenGenericParameterClauseAndInitializer?.raw, 
          initializer.raw, 
          unexpectedBetweenInitializerAndGenericWhereClause?.raw, 
          genericWhereClause?.raw, 
          unexpectedAfterGenericWhereClause?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.typeAliasDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(TypeAliasDeclSyntax.self)
    }
  }
  
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(TypeAliasDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> TypeAliasDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(TypeAliasDeclSyntax.self)
  }
  
  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(TypeAliasDeclSyntax.self)
    }
  }
  
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(TypeAliasDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> TypeAliasDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(TypeAliasDeclSyntax.self)
  }
  
  public var unexpectedBetweenModifiersAndTypealiasKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(TypeAliasDeclSyntax.self)
    }
  }
  
  public var typealiasKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(TypeAliasDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenTypealiasKeywordAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(TypeAliasDeclSyntax.self)
    }
  }
  
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(TypeAliasDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenNameAndGenericParameterClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(TypeAliasDeclSyntax.self)
    }
  }
  
  /// The parameter clause that defines the generic parameters.
  public var genericParameterClause: GenericParameterClauseSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(GenericParameterClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(TypeAliasDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenGenericParameterClauseAndInitializer: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(TypeAliasDeclSyntax.self)
    }
  }
  
  public var initializer: TypeInitializerClauseSyntax {
    get {
      return Syntax(self).child(at: 11)!.cast(TypeInitializerClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), arena: SyntaxArena()).cast(TypeAliasDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenInitializerAndGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), arena: SyntaxArena()).cast(TypeAliasDeclSyntax.self)
    }
  }
  
  /// A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
  public var genericWhereClause: GenericWhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(GenericWhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), arena: SyntaxArena()).cast(TypeAliasDeclSyntax.self)
    }
  }
  
  public var unexpectedAfterGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), arena: SyntaxArena()).cast(TypeAliasDeclSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAttributes, 
          \Self.attributes, 
          \Self.unexpectedBetweenAttributesAndModifiers, 
          \Self.modifiers, 
          \Self.unexpectedBetweenModifiersAndTypealiasKeyword, 
          \Self.typealiasKeyword, 
          \Self.unexpectedBetweenTypealiasKeywordAndName, 
          \Self.name, 
          \Self.unexpectedBetweenNameAndGenericParameterClause, 
          \Self.genericParameterClause, 
          \Self.unexpectedBetweenGenericParameterClauseAndInitializer, 
          \Self.initializer, 
          \Self.unexpectedBetweenInitializerAndGenericWhereClause, 
          \Self.genericWhereClause, 
          \Self.unexpectedAfterGenericWhereClause
        ])
  }
}

// MARK: - TypeAnnotationSyntax

/// ### Children
/// 
///  - `colon`: `':'`
///  - `type`: ``TypeSyntax``
///
/// ### Contained in
/// 
///  - ``ForStmtSyntax``.``ForStmtSyntax/typeAnnotation``
///  - ``MatchingPatternConditionSyntax``.``MatchingPatternConditionSyntax/typeAnnotation``
///  - ``OptionalBindingConditionSyntax``.``OptionalBindingConditionSyntax/typeAnnotation``
///  - ``PatternBindingSyntax``.``PatternBindingSyntax/typeAnnotation``
public struct TypeAnnotationSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .typeAnnotation else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax = .colonToken(),
      _ unexpectedBetweenColonAndType: UnexpectedNodesSyntax? = nil,
      type: some TypeSyntaxProtocol,
      _ unexpectedAfterType: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeColon, 
            colon, 
            unexpectedBetweenColonAndType, 
            type, 
            unexpectedAfterType
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeColon?.raw, 
          colon.raw, 
          unexpectedBetweenColonAndType?.raw, 
          type.raw, 
          unexpectedAfterType?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.typeAnnotation,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(TypeAnnotationSyntax.self)
    }
  }
  
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(TypeAnnotationSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(TypeAnnotationSyntax.self)
    }
  }
  
  public var type: TypeSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(TypeAnnotationSyntax.self)
    }
  }
  
  public var unexpectedAfterType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(TypeAnnotationSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndType, 
          \Self.type, 
          \Self.unexpectedAfterType
        ])
  }
}

// MARK: - TypeEffectSpecifiersSyntax

/// ### Children
/// 
///  - `asyncSpecifier`: `'async'`?
///  - `throwsSpecifier`: `'throws'`?
///
/// ### Contained in
/// 
///  - ``ArrowExprSyntax``.``ArrowExprSyntax/effectSpecifiers``
///  - ``ClosureSignatureSyntax``.``ClosureSignatureSyntax/effectSpecifiers``
///  - ``FunctionTypeSyntax``.``FunctionTypeSyntax/effectSpecifiers``
public struct TypeEffectSpecifiersSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .typeEffectSpecifiers else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAsyncSpecifier: UnexpectedNodesSyntax? = nil,
      asyncSpecifier: TokenSyntax? = nil,
      _ unexpectedBetweenAsyncSpecifierAndThrowsSpecifier: UnexpectedNodesSyntax? = nil,
      throwsSpecifier: TokenSyntax? = nil,
      _ unexpectedAfterThrowsSpecifier: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAsyncSpecifier, 
            asyncSpecifier, 
            unexpectedBetweenAsyncSpecifierAndThrowsSpecifier, 
            throwsSpecifier, 
            unexpectedAfterThrowsSpecifier
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAsyncSpecifier?.raw, 
          asyncSpecifier?.raw, 
          unexpectedBetweenAsyncSpecifierAndThrowsSpecifier?.raw, 
          throwsSpecifier?.raw, 
          unexpectedAfterThrowsSpecifier?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.typeEffectSpecifiers,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAsyncSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(TypeEffectSpecifiersSyntax.self)
    }
  }
  
  public var asyncSpecifier: TokenSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(TypeEffectSpecifiersSyntax.self)
    }
  }
  
  public var unexpectedBetweenAsyncSpecifierAndThrowsSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(TypeEffectSpecifiersSyntax.self)
    }
  }
  
  public var throwsSpecifier: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(TypeEffectSpecifiersSyntax.self)
    }
  }
  
  public var unexpectedAfterThrowsSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(TypeEffectSpecifiersSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAsyncSpecifier, 
          \Self.asyncSpecifier, 
          \Self.unexpectedBetweenAsyncSpecifierAndThrowsSpecifier, 
          \Self.throwsSpecifier, 
          \Self.unexpectedAfterThrowsSpecifier
        ])
  }
}

// MARK: - TypeExprSyntax

/// ### Children
/// 
///  - `type`: ``TypeSyntax``
public struct TypeExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .typeExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeType: UnexpectedNodesSyntax? = nil,
      type: some TypeSyntaxProtocol,
      _ unexpectedAfterType: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (unexpectedBeforeType, type, unexpectedAfterType))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeType?.raw, type.raw, unexpectedAfterType?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.typeExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(TypeExprSyntax.self)
    }
  }
  
  public var type: TypeSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(TypeExprSyntax.self)
    }
  }
  
  public var unexpectedAfterType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(TypeExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([\Self.unexpectedBeforeType, \Self.type, \Self.unexpectedAfterType])
  }
}

// MARK: - TypeInitializerClauseSyntax

/// ### Children
/// 
///  - `equal`: `'='`
///  - `value`: ``TypeSyntax``
///
/// ### Contained in
/// 
///  - ``AssociatedTypeDeclSyntax``.``AssociatedTypeDeclSyntax/initializer``
///  - ``TypeAliasDeclSyntax``.``TypeAliasDeclSyntax/initializer``
public struct TypeInitializerClauseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .typeInitializerClause else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeEqual: UnexpectedNodesSyntax? = nil,
      equal: TokenSyntax = .equalToken(),
      _ unexpectedBetweenEqualAndValue: UnexpectedNodesSyntax? = nil,
      value: some TypeSyntaxProtocol,
      _ unexpectedAfterValue: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeEqual, 
            equal, 
            unexpectedBetweenEqualAndValue, 
            value, 
            unexpectedAfterValue
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeEqual?.raw, 
          equal.raw, 
          unexpectedBetweenEqualAndValue?.raw, 
          value.raw, 
          unexpectedAfterValue?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.typeInitializerClause,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeEqual: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(TypeInitializerClauseSyntax.self)
    }
  }
  
  public var equal: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(TypeInitializerClauseSyntax.self)
    }
  }
  
  public var unexpectedBetweenEqualAndValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(TypeInitializerClauseSyntax.self)
    }
  }
  
  public var value: TypeSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(TypeInitializerClauseSyntax.self)
    }
  }
  
  public var unexpectedAfterValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(TypeInitializerClauseSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeEqual, 
          \Self.equal, 
          \Self.unexpectedBetweenEqualAndValue, 
          \Self.value, 
          \Self.unexpectedAfterValue
        ])
  }
}

// MARK: - UnavailableFromAsyncAttributeArgumentsSyntax

/// The arguments for the '@_unavailableFromAsync' attribute
///
/// ### Children
/// 
///  - `messageLabel`: `'message'`
///  - `colon`: `':'`
///  - `message`: ``StringLiteralExprSyntax``
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct UnavailableFromAsyncAttributeArgumentsSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .unavailableFromAsyncAttributeArguments else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeMessageLabel: UnexpectedNodesSyntax? = nil,
      messageLabel: TokenSyntax = .keyword(.message),
      _ unexpectedBetweenMessageLabelAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax = .colonToken(),
      _ unexpectedBetweenColonAndMessage: UnexpectedNodesSyntax? = nil,
      message: StringLiteralExprSyntax,
      _ unexpectedAfterMessage: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeMessageLabel, 
            messageLabel, 
            unexpectedBetweenMessageLabelAndColon, 
            colon, 
            unexpectedBetweenColonAndMessage, 
            message, 
            unexpectedAfterMessage
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeMessageLabel?.raw, 
          messageLabel.raw, 
          unexpectedBetweenMessageLabelAndColon?.raw, 
          colon.raw, 
          unexpectedBetweenColonAndMessage?.raw, 
          message.raw, 
          unexpectedAfterMessage?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.unavailableFromAsyncAttributeArguments,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeMessageLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(UnavailableFromAsyncAttributeArgumentsSyntax.self)
    }
  }
  
  public var messageLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(UnavailableFromAsyncAttributeArgumentsSyntax.self)
    }
  }
  
  public var unexpectedBetweenMessageLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(UnavailableFromAsyncAttributeArgumentsSyntax.self)
    }
  }
  
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(UnavailableFromAsyncAttributeArgumentsSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndMessage: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(UnavailableFromAsyncAttributeArgumentsSyntax.self)
    }
  }
  
  public var message: StringLiteralExprSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(StringLiteralExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(UnavailableFromAsyncAttributeArgumentsSyntax.self)
    }
  }
  
  public var unexpectedAfterMessage: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(UnavailableFromAsyncAttributeArgumentsSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeMessageLabel, 
          \Self.messageLabel, 
          \Self.unexpectedBetweenMessageLabelAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndMessage, 
          \Self.message, 
          \Self.unexpectedAfterMessage
        ])
  }
}

// MARK: - UnderscorePrivateAttributeArgumentsSyntax

/// The arguments for the '@_private' attribute
///
/// ### Children
/// 
///  - `sourceFileLabel`: `'sourceFile'`
///  - `colon`: `':'`
///  - `filename`: ``StringLiteralExprSyntax``
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct UnderscorePrivateAttributeArgumentsSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .underscorePrivateAttributeArguments else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeSourceFileLabel: UnexpectedNodesSyntax? = nil,
      sourceFileLabel: TokenSyntax = .keyword(.sourceFile),
      _ unexpectedBetweenSourceFileLabelAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax = .colonToken(),
      _ unexpectedBetweenColonAndFilename: UnexpectedNodesSyntax? = nil,
      filename: StringLiteralExprSyntax,
      _ unexpectedAfterFilename: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeSourceFileLabel, 
            sourceFileLabel, 
            unexpectedBetweenSourceFileLabelAndColon, 
            colon, 
            unexpectedBetweenColonAndFilename, 
            filename, 
            unexpectedAfterFilename
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeSourceFileLabel?.raw, 
          sourceFileLabel.raw, 
          unexpectedBetweenSourceFileLabelAndColon?.raw, 
          colon.raw, 
          unexpectedBetweenColonAndFilename?.raw, 
          filename.raw, 
          unexpectedAfterFilename?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.underscorePrivateAttributeArguments,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeSourceFileLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(UnderscorePrivateAttributeArgumentsSyntax.self)
    }
  }
  
  public var sourceFileLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(UnderscorePrivateAttributeArgumentsSyntax.self)
    }
  }
  
  public var unexpectedBetweenSourceFileLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(UnderscorePrivateAttributeArgumentsSyntax.self)
    }
  }
  
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(UnderscorePrivateAttributeArgumentsSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndFilename: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(UnderscorePrivateAttributeArgumentsSyntax.self)
    }
  }
  
  public var filename: StringLiteralExprSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(StringLiteralExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(UnderscorePrivateAttributeArgumentsSyntax.self)
    }
  }
  
  public var unexpectedAfterFilename: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(UnderscorePrivateAttributeArgumentsSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeSourceFileLabel, 
          \Self.sourceFileLabel, 
          \Self.unexpectedBetweenSourceFileLabelAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndFilename, 
          \Self.filename, 
          \Self.unexpectedAfterFilename
        ])
  }
}

// MARK: - UnresolvedAsExprSyntax

/// ### Children
/// 
///  - `asKeyword`: `'as'`
///  - `questionOrExclamationMark`: (`'?'` | `'!'`)?
public struct UnresolvedAsExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .unresolvedAsExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAsKeyword: UnexpectedNodesSyntax? = nil,
      asKeyword: TokenSyntax = .keyword(.as),
      _ unexpectedBetweenAsKeywordAndQuestionOrExclamationMark: UnexpectedNodesSyntax? = nil,
      questionOrExclamationMark: TokenSyntax? = nil,
      _ unexpectedAfterQuestionOrExclamationMark: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAsKeyword, 
            asKeyword, 
            unexpectedBetweenAsKeywordAndQuestionOrExclamationMark, 
            questionOrExclamationMark, 
            unexpectedAfterQuestionOrExclamationMark
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAsKeyword?.raw, 
          asKeyword.raw, 
          unexpectedBetweenAsKeywordAndQuestionOrExclamationMark?.raw, 
          questionOrExclamationMark?.raw, 
          unexpectedAfterQuestionOrExclamationMark?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.unresolvedAsExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAsKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(UnresolvedAsExprSyntax.self)
    }
  }
  
  public var asKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(UnresolvedAsExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenAsKeywordAndQuestionOrExclamationMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(UnresolvedAsExprSyntax.self)
    }
  }
  
  public var questionOrExclamationMark: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(UnresolvedAsExprSyntax.self)
    }
  }
  
  public var unexpectedAfterQuestionOrExclamationMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(UnresolvedAsExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAsKeyword, 
          \Self.asKeyword, 
          \Self.unexpectedBetweenAsKeywordAndQuestionOrExclamationMark, 
          \Self.questionOrExclamationMark, 
          \Self.unexpectedAfterQuestionOrExclamationMark
        ])
  }
}

// MARK: - UnresolvedIsExprSyntax

/// ### Children
/// 
///  - `isKeyword`: `'is'`
public struct UnresolvedIsExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .unresolvedIsExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeIsKeyword: UnexpectedNodesSyntax? = nil,
      isKeyword: TokenSyntax = .keyword(.is),
      _ unexpectedAfterIsKeyword: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (unexpectedBeforeIsKeyword, isKeyword, unexpectedAfterIsKeyword))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeIsKeyword?.raw, isKeyword.raw, unexpectedAfterIsKeyword?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.unresolvedIsExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeIsKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(UnresolvedIsExprSyntax.self)
    }
  }
  
  public var isKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(UnresolvedIsExprSyntax.self)
    }
  }
  
  public var unexpectedAfterIsKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(UnresolvedIsExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([\Self.unexpectedBeforeIsKeyword, \Self.isKeyword, \Self.unexpectedAfterIsKeyword])
  }
}

// MARK: - UnresolvedTernaryExprSyntax

/// ### Children
/// 
///  - `questionMark`: `'?'`
///  - `thenExpression`: ``ExprSyntax``
///  - `colon`: `':'`
public struct UnresolvedTernaryExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .unresolvedTernaryExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeQuestionMark: UnexpectedNodesSyntax? = nil,
      questionMark: TokenSyntax = .infixQuestionMarkToken(),
      _ unexpectedBetweenQuestionMarkAndThenExpression: UnexpectedNodesSyntax? = nil,
      thenExpression: some ExprSyntaxProtocol,
      _ unexpectedBetweenThenExpressionAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax = .colonToken(),
      _ unexpectedAfterColon: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeQuestionMark, 
            questionMark, 
            unexpectedBetweenQuestionMarkAndThenExpression, 
            thenExpression, 
            unexpectedBetweenThenExpressionAndColon, 
            colon, 
            unexpectedAfterColon
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeQuestionMark?.raw, 
          questionMark.raw, 
          unexpectedBetweenQuestionMarkAndThenExpression?.raw, 
          thenExpression.raw, 
          unexpectedBetweenThenExpressionAndColon?.raw, 
          colon.raw, 
          unexpectedAfterColon?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.unresolvedTernaryExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeQuestionMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(UnresolvedTernaryExprSyntax.self)
    }
  }
  
  public var questionMark: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(UnresolvedTernaryExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenQuestionMarkAndThenExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(UnresolvedTernaryExprSyntax.self)
    }
  }
  
  public var thenExpression: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(UnresolvedTernaryExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenThenExpressionAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(UnresolvedTernaryExprSyntax.self)
    }
  }
  
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(UnresolvedTernaryExprSyntax.self)
    }
  }
  
  public var unexpectedAfterColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(UnresolvedTernaryExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeQuestionMark, 
          \Self.questionMark, 
          \Self.unexpectedBetweenQuestionMarkAndThenExpression, 
          \Self.thenExpression, 
          \Self.unexpectedBetweenThenExpressionAndColon, 
          \Self.colon, 
          \Self.unexpectedAfterColon
        ])
  }
}

// MARK: - ValueBindingPatternSyntax

/// ### Children
/// 
///  - `bindingSpecifier`: (`'let'` | `'var'` | `'inout'` | `'_mutating'` | `'_borrowing'` | `'_consuming'`)
///  - `pattern`: ``PatternSyntax``
public struct ValueBindingPatternSyntax: PatternSyntaxProtocol, SyntaxHashable, _LeafPatternSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .valueBindingPattern else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeBindingSpecifier: UnexpectedNodesSyntax? = nil,
      bindingSpecifier: TokenSyntax,
      _ unexpectedBetweenBindingSpecifierAndPattern: UnexpectedNodesSyntax? = nil,
      pattern: some PatternSyntaxProtocol,
      _ unexpectedAfterPattern: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeBindingSpecifier, 
            bindingSpecifier, 
            unexpectedBetweenBindingSpecifierAndPattern, 
            pattern, 
            unexpectedAfterPattern
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeBindingSpecifier?.raw, 
          bindingSpecifier.raw, 
          unexpectedBetweenBindingSpecifierAndPattern?.raw, 
          pattern.raw, 
          unexpectedAfterPattern?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.valueBindingPattern,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeBindingSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ValueBindingPatternSyntax.self)
    }
  }
  
  public var bindingSpecifier: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ValueBindingPatternSyntax.self)
    }
  }
  
  public var unexpectedBetweenBindingSpecifierAndPattern: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ValueBindingPatternSyntax.self)
    }
  }
  
  public var pattern: PatternSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(PatternSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ValueBindingPatternSyntax.self)
    }
  }
  
  public var unexpectedAfterPattern: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ValueBindingPatternSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeBindingSpecifier, 
          \Self.bindingSpecifier, 
          \Self.unexpectedBetweenBindingSpecifierAndPattern, 
          \Self.pattern, 
          \Self.unexpectedAfterPattern
        ])
  }
}

// MARK: - VariableDeclSyntax

/// Declaration of one or more variables
/// 
/// The core of a variable declaration consists of a binding specifier (`let` or `var`),
/// followed by any number of pattern bindings, which define the variables.
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `bindingSpecifier`: (`'let'` | `'var'` | `'inout'` | `'_mutating'` | `'_borrowing'` | `'_consuming'`)
///  - `bindings`: ``PatternBindingListSyntax``
public struct VariableDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .variableDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - bindingSpecifier: The specifier that defines the type of the variables declared (`let` or `var`).
  ///   - bindings: The pattern bindings that define the actual variables.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
      attributes: AttributeListSyntax = [],
      _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
      modifiers: DeclModifierListSyntax = [],
      _ unexpectedBetweenModifiersAndBindingSpecifier: UnexpectedNodesSyntax? = nil,
      bindingSpecifier: TokenSyntax,
      _ unexpectedBetweenBindingSpecifierAndBindings: UnexpectedNodesSyntax? = nil,
      bindings: PatternBindingListSyntax,
      _ unexpectedAfterBindings: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAttributes, 
            attributes, 
            unexpectedBetweenAttributesAndModifiers, 
            modifiers, 
            unexpectedBetweenModifiersAndBindingSpecifier, 
            bindingSpecifier, 
            unexpectedBetweenBindingSpecifierAndBindings, 
            bindings, 
            unexpectedAfterBindings
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAttributes?.raw, 
          attributes.raw, 
          unexpectedBetweenAttributesAndModifiers?.raw, 
          modifiers.raw, 
          unexpectedBetweenModifiersAndBindingSpecifier?.raw, 
          bindingSpecifier.raw, 
          unexpectedBetweenBindingSpecifierAndBindings?.raw, 
          bindings.raw, 
          unexpectedAfterBindings?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.variableDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(VariableDeclSyntax.self)
    }
  }
  
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(VariableDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> VariableDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(VariableDeclSyntax.self)
  }
  
  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(VariableDeclSyntax.self)
    }
  }
  
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(VariableDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> VariableDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(VariableDeclSyntax.self)
  }
  
  public var unexpectedBetweenModifiersAndBindingSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(VariableDeclSyntax.self)
    }
  }
  
  /// The specifier that defines the type of the variables declared (`let` or `var`).
  public var bindingSpecifier: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(VariableDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenBindingSpecifierAndBindings: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(VariableDeclSyntax.self)
    }
  }
  
  /// The pattern bindings that define the actual variables.
  /// 
  /// The pattern bindings contain the declared variables’ names, their types,
  /// initializers and accessors.
  /// 
  /// A variable declaration can contain multiple pattern bindings, because it’s possible
  /// to define multiple variables after a single `let` keyword, for example
  /// 
  /// ```swift
  /// let x: Int = 1, y: Int = 2
  /// ```
  public var bindings: PatternBindingListSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(PatternBindingListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(VariableDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `bindings`
  /// collection.
  ///
  /// - param element: The new `Binding` to add to the node's
  ///                  `bindings` collection.
  /// - returns: A copy of the receiver with the provided `Binding`
  ///            appended to its `bindings` collection.
  @available(*, deprecated, message: "Use node.bindings.append(newElement) instead")
  public func addBinding(_ element: PatternBindingSyntax) -> VariableDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[7] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.patternBindingList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 7, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(VariableDeclSyntax.self)
  }
  
  public var unexpectedAfterBindings: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(VariableDeclSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAttributes, 
          \Self.attributes, 
          \Self.unexpectedBetweenAttributesAndModifiers, 
          \Self.modifiers, 
          \Self.unexpectedBetweenModifiersAndBindingSpecifier, 
          \Self.bindingSpecifier, 
          \Self.unexpectedBetweenBindingSpecifierAndBindings, 
          \Self.bindings, 
          \Self.unexpectedAfterBindings
        ])
  }
}

// MARK: - VersionComponentSyntax

/// An element to represent a single component in a version, like `.1`.
///
/// ### Children
/// 
///  - `period`: `'.'`
///  - `number`: `<integerLiteral>`
///
/// ### Contained in
/// 
///  - ``VersionComponentListSyntax``
public struct VersionComponentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .versionComponent else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - period: The period of this version component
  ///   - number: The version number of this component
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforePeriod: UnexpectedNodesSyntax? = nil,
      period: TokenSyntax = .periodToken(),
      _ unexpectedBetweenPeriodAndNumber: UnexpectedNodesSyntax? = nil,
      number: TokenSyntax,
      _ unexpectedAfterNumber: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforePeriod, 
            period, 
            unexpectedBetweenPeriodAndNumber, 
            number, 
            unexpectedAfterNumber
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforePeriod?.raw, 
          period.raw, 
          unexpectedBetweenPeriodAndNumber?.raw, 
          number.raw, 
          unexpectedAfterNumber?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.versionComponent,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforePeriod: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(VersionComponentSyntax.self)
    }
  }
  
  /// The period of this version component
  public var period: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(VersionComponentSyntax.self)
    }
  }
  
  public var unexpectedBetweenPeriodAndNumber: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(VersionComponentSyntax.self)
    }
  }
  
  /// The version number of this component
  public var number: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(VersionComponentSyntax.self)
    }
  }
  
  public var unexpectedAfterNumber: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(VersionComponentSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforePeriod, 
          \Self.period, 
          \Self.unexpectedBetweenPeriodAndNumber, 
          \Self.number, 
          \Self.unexpectedAfterNumber
        ])
  }
}

// MARK: - VersionTupleSyntax

/// A version number like `1.2.0`. Only the first version component is required. There might be an arbitrary number of following components.
///
/// ### Children
/// 
///  - `major`: `<integerLiteral>`
///  - `components`: ``VersionComponentListSyntax``
///
/// ### Contained in
/// 
///  - ``AvailabilityLabeledArgumentSyntax``.``AvailabilityLabeledArgumentSyntax/value``
///  - ``CanImportVersionInfoSyntax``.``CanImportVersionInfoSyntax/version``
///  - ``PlatformVersionSyntax``.``PlatformVersionSyntax/version``
public struct VersionTupleSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .versionTuple else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - major: The major version.
  ///   - components: Any version components that are not the major version . For example, for `1.2.0`, this will contain `.2.0`
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeMajor: UnexpectedNodesSyntax? = nil,
      major: TokenSyntax,
      _ unexpectedBetweenMajorAndComponents: UnexpectedNodesSyntax? = nil,
      components: VersionComponentListSyntax,
      _ unexpectedAfterComponents: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeMajor, 
            major, 
            unexpectedBetweenMajorAndComponents, 
            components, 
            unexpectedAfterComponents
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeMajor?.raw, 
          major.raw, 
          unexpectedBetweenMajorAndComponents?.raw, 
          components.raw, 
          unexpectedAfterComponents?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.versionTuple,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeMajor: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(VersionTupleSyntax.self)
    }
  }
  
  /// The major version.
  public var major: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(VersionTupleSyntax.self)
    }
  }
  
  public var unexpectedBetweenMajorAndComponents: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(VersionTupleSyntax.self)
    }
  }
  
  /// Any version components that are not the major version . For example, for `1.2.0`, this will contain `.2.0`
  public var components: VersionComponentListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(VersionComponentListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(VersionTupleSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `components`
  /// collection.
  ///
  /// - param element: The new `VersionComponent` to add to the node's
  ///                  `components` collection.
  /// - returns: A copy of the receiver with the provided `VersionComponent`
  ///            appended to its `components` collection.
  @available(*, deprecated, message: "Use node.components.append(newElement) instead")
  public func addVersionComponent(_ element: VersionComponentSyntax) -> VersionTupleSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.versionComponentList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(VersionTupleSyntax.self)
  }
  
  public var unexpectedAfterComponents: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(VersionTupleSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeMajor, 
          \Self.major, 
          \Self.unexpectedBetweenMajorAndComponents, 
          \Self.components, 
          \Self.unexpectedAfterComponents
        ])
  }
}

// MARK: - WhereClauseSyntax

/// ### Children
/// 
///  - `whereKeyword`: `'where'`
///  - `condition`: ``ExprSyntax``
///
/// ### Contained in
/// 
///  - ``CatchItemSyntax``.``CatchItemSyntax/whereClause``
///  - ``ForStmtSyntax``.``ForStmtSyntax/whereClause``
///  - ``SwitchCaseItemSyntax``.``SwitchCaseItemSyntax/whereClause``
public struct WhereClauseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .whereClause else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeWhereKeyword: UnexpectedNodesSyntax? = nil,
      whereKeyword: TokenSyntax = .keyword(.where),
      _ unexpectedBetweenWhereKeywordAndCondition: UnexpectedNodesSyntax? = nil,
      condition: some ExprSyntaxProtocol,
      _ unexpectedAfterCondition: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeWhereKeyword, 
            whereKeyword, 
            unexpectedBetweenWhereKeywordAndCondition, 
            condition, 
            unexpectedAfterCondition
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeWhereKeyword?.raw, 
          whereKeyword.raw, 
          unexpectedBetweenWhereKeywordAndCondition?.raw, 
          condition.raw, 
          unexpectedAfterCondition?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.whereClause,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeWhereKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(WhereClauseSyntax.self)
    }
  }
  
  public var whereKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(WhereClauseSyntax.self)
    }
  }
  
  public var unexpectedBetweenWhereKeywordAndCondition: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(WhereClauseSyntax.self)
    }
  }
  
  public var condition: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(WhereClauseSyntax.self)
    }
  }
  
  public var unexpectedAfterCondition: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(WhereClauseSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeWhereKeyword, 
          \Self.whereKeyword, 
          \Self.unexpectedBetweenWhereKeywordAndCondition, 
          \Self.condition, 
          \Self.unexpectedAfterCondition
        ])
  }
}

// MARK: - WhileStmtSyntax

/// ### Children
/// 
///  - `whileKeyword`: `'while'`
///  - `conditions`: ``ConditionElementListSyntax``
///  - `body`: ``CodeBlockSyntax``
public struct WhileStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .whileStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeWhileKeyword: UnexpectedNodesSyntax? = nil,
      whileKeyword: TokenSyntax = .keyword(.while),
      _ unexpectedBetweenWhileKeywordAndConditions: UnexpectedNodesSyntax? = nil,
      conditions: ConditionElementListSyntax,
      _ unexpectedBetweenConditionsAndBody: UnexpectedNodesSyntax? = nil,
      body: CodeBlockSyntax,
      _ unexpectedAfterBody: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeWhileKeyword, 
            whileKeyword, 
            unexpectedBetweenWhileKeywordAndConditions, 
            conditions, 
            unexpectedBetweenConditionsAndBody, 
            body, 
            unexpectedAfterBody
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeWhileKeyword?.raw, 
          whileKeyword.raw, 
          unexpectedBetweenWhileKeywordAndConditions?.raw, 
          conditions.raw, 
          unexpectedBetweenConditionsAndBody?.raw, 
          body.raw, 
          unexpectedAfterBody?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.whileStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeWhileKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(WhileStmtSyntax.self)
    }
  }
  
  public var whileKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(WhileStmtSyntax.self)
    }
  }
  
  public var unexpectedBetweenWhileKeywordAndConditions: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(WhileStmtSyntax.self)
    }
  }
  
  public var conditions: ConditionElementListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ConditionElementListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(WhileStmtSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `conditions`
  /// collection.
  ///
  /// - param element: The new `Condition` to add to the node's
  ///                  `conditions` collection.
  /// - returns: A copy of the receiver with the provided `Condition`
  ///            appended to its `conditions` collection.
  @available(*, deprecated, message: "Use node.conditions.append(newElement) instead")
  public func addCondition(_ element: ConditionElementSyntax) -> WhileStmtSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.conditionElementList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(WhileStmtSyntax.self)
  }
  
  public var unexpectedBetweenConditionsAndBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(WhileStmtSyntax.self)
    }
  }
  
  public var body: CodeBlockSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(CodeBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(WhileStmtSyntax.self)
    }
  }
  
  public var unexpectedAfterBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(WhileStmtSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeWhileKeyword, 
          \Self.whileKeyword, 
          \Self.unexpectedBetweenWhileKeywordAndConditions, 
          \Self.conditions, 
          \Self.unexpectedBetweenConditionsAndBody, 
          \Self.body, 
          \Self.unexpectedAfterBody
        ])
  }
}

// MARK: - WildcardPatternSyntax

/// ### Children
/// 
///  - `wildcard`: `'_'`
public struct WildcardPatternSyntax: PatternSyntaxProtocol, SyntaxHashable, _LeafPatternSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .wildcardPattern else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeWildcard: UnexpectedNodesSyntax? = nil,
      wildcard: TokenSyntax = .wildcardToken(),
      _ unexpectedAfterWildcard: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (unexpectedBeforeWildcard, wildcard, unexpectedAfterWildcard))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeWildcard?.raw, wildcard.raw, unexpectedAfterWildcard?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.wildcardPattern,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeWildcard: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(WildcardPatternSyntax.self)
    }
  }
  
  public var wildcard: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(WildcardPatternSyntax.self)
    }
  }
  
  public var unexpectedAfterWildcard: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(WildcardPatternSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([\Self.unexpectedBeforeWildcard, \Self.wildcard, \Self.unexpectedAfterWildcard])
  }
}

// MARK: - YieldStmtSyntax

/// ### Children
/// 
///  - `yieldKeyword`: `'yield'`
///  - `yieldedExpressions`: (``YieldedExpressionsClauseSyntax`` | ``ExprSyntax``)
public struct YieldStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public enum YieldedExpressions: SyntaxChildChoices, SyntaxHashable {
    case `multiple`(YieldedExpressionsClauseSyntax)
    case `single`(ExprSyntax)
    
    public var _syntaxNode: Syntax {
      switch self {
      case .multiple(let node):
        return node._syntaxNode
      case .single(let node):
        return node._syntaxNode
      }
    }
    
    public init(_ node: YieldedExpressionsClauseSyntax) {
      self = .multiple(node)
    }
    
    public init(_ node: some ExprSyntaxProtocol) {
      self = .single(ExprSyntax(node))
    }
    
    public init?(_ node: some SyntaxProtocol) {
      if let node = node.as(YieldedExpressionsClauseSyntax.self) {
        self = .multiple(node)
        return
      }
      if let node = node.as(ExprSyntax.self) {
        self = .single(node)
        return
      }
      return nil
    }
    
    public static var structure: SyntaxNodeStructure {
      return .choices([.node(YieldedExpressionsClauseSyntax.self), .node(ExprSyntax.self)])
    }
  }
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .yieldStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeYieldKeyword: UnexpectedNodesSyntax? = nil,
      yieldKeyword: TokenSyntax = .keyword(.yield),
      _ unexpectedBetweenYieldKeywordAndYieldedExpressions: UnexpectedNodesSyntax? = nil,
      yieldedExpressions: YieldedExpressions,
      _ unexpectedAfterYieldedExpressions: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeYieldKeyword, 
            yieldKeyword, 
            unexpectedBetweenYieldKeywordAndYieldedExpressions, 
            yieldedExpressions, 
            unexpectedAfterYieldedExpressions
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeYieldKeyword?.raw, 
          yieldKeyword.raw, 
          unexpectedBetweenYieldKeywordAndYieldedExpressions?.raw, 
          yieldedExpressions.raw, 
          unexpectedAfterYieldedExpressions?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.yieldStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeYieldKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(YieldStmtSyntax.self)
    }
  }
  
  public var yieldKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(YieldStmtSyntax.self)
    }
  }
  
  public var unexpectedBetweenYieldKeywordAndYieldedExpressions: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(YieldStmtSyntax.self)
    }
  }
  
  public var yieldedExpressions: YieldedExpressions {
    get {
      return Syntax(self).child(at: 3)!.cast(YieldedExpressions.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(YieldStmtSyntax.self)
    }
  }
  
  public var unexpectedAfterYieldedExpressions: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(YieldStmtSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeYieldKeyword, 
          \Self.yieldKeyword, 
          \Self.unexpectedBetweenYieldKeywordAndYieldedExpressions, 
          \Self.yieldedExpressions, 
          \Self.unexpectedAfterYieldedExpressions
        ])
  }
}

// MARK: - YieldedExpressionSyntax

/// ### Children
/// 
///  - `expression`: ``ExprSyntax``
///  - `comma`: `','`?
///
/// ### Contained in
/// 
///  - ``YieldedExpressionListSyntax``
public struct YieldedExpressionSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .yieldedExpression else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeExpression: UnexpectedNodesSyntax? = nil,
      expression: some ExprSyntaxProtocol,
      _ unexpectedBetweenExpressionAndComma: UnexpectedNodesSyntax? = nil,
      comma: TokenSyntax? = nil,
      _ unexpectedAfterComma: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeExpression, 
            expression, 
            unexpectedBetweenExpressionAndComma, 
            comma, 
            unexpectedAfterComma
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeExpression?.raw, 
          expression.raw, 
          unexpectedBetweenExpressionAndComma?.raw, 
          comma?.raw, 
          unexpectedAfterComma?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.yieldedExpression,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(YieldedExpressionSyntax.self)
    }
  }
  
  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(YieldedExpressionSyntax.self)
    }
  }
  
  public var unexpectedBetweenExpressionAndComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(YieldedExpressionSyntax.self)
    }
  }
  
  public var comma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(YieldedExpressionSyntax.self)
    }
  }
  
  public var unexpectedAfterComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(YieldedExpressionSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeExpression, 
          \Self.expression, 
          \Self.unexpectedBetweenExpressionAndComma, 
          \Self.comma, 
          \Self.unexpectedAfterComma
        ])
  }
}

// MARK: - YieldedExpressionsClauseSyntax

/// ### Children
/// 
///  - `leftParen`: `'('`
///  - `elements`: ``YieldedExpressionListSyntax``
///  - `rightParen`: `')'`
///
/// ### Contained in
/// 
///  - ``YieldStmtSyntax``.``YieldStmtSyntax/yieldedExpressions``
public struct YieldedExpressionsClauseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .yieldedExpressionsClause else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLeftParen: UnexpectedNodesSyntax? = nil,
      leftParen: TokenSyntax = .leftParenToken(),
      _ unexpectedBetweenLeftParenAndElements: UnexpectedNodesSyntax? = nil,
      elements: YieldedExpressionListSyntax,
      _ unexpectedBetweenElementsAndRightParen: UnexpectedNodesSyntax? = nil,
      rightParen: TokenSyntax = .rightParenToken(),
      _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLeftParen, 
            leftParen, 
            unexpectedBetweenLeftParenAndElements, 
            elements, 
            unexpectedBetweenElementsAndRightParen, 
            rightParen, 
            unexpectedAfterRightParen
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLeftParen?.raw, 
          leftParen.raw, 
          unexpectedBetweenLeftParenAndElements?.raw, 
          elements.raw, 
          unexpectedBetweenElementsAndRightParen?.raw, 
          rightParen.raw, 
          unexpectedAfterRightParen?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.yieldedExpressionsClause,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(YieldedExpressionsClauseSyntax.self)
    }
  }
  
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(YieldedExpressionsClauseSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftParenAndElements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(YieldedExpressionsClauseSyntax.self)
    }
  }
  
  public var elements: YieldedExpressionListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(YieldedExpressionListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(YieldedExpressionsClauseSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `elements`
  /// collection.
  ///
  /// - param element: The new `Element` to add to the node's
  ///                  `elements` collection.
  /// - returns: A copy of the receiver with the provided `Element`
  ///            appended to its `elements` collection.
  @available(*, deprecated, message: "Use node.elements.append(newElement) instead")
  public func addElement(_ element: YieldedExpressionSyntax) -> YieldedExpressionsClauseSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.yieldedExpressionList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(YieldedExpressionsClauseSyntax.self)
  }
  
  public var unexpectedBetweenElementsAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(YieldedExpressionsClauseSyntax.self)
    }
  }
  
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(YieldedExpressionsClauseSyntax.self)
    }
  }
  
  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(YieldedExpressionsClauseSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLeftParen, 
          \Self.leftParen, 
          \Self.unexpectedBetweenLeftParenAndElements, 
          \Self.elements, 
          \Self.unexpectedBetweenElementsAndRightParen, 
          \Self.rightParen, 
          \Self.unexpectedAfterRightParen
        ])
  }
}
