//// Automatically generated by generate-swift-syntax
//// Do not edit directly!
//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

// MARK: - KeyPathComponentSyntax

/// ### Children
/// 
///  - `period`: `'.'`?
///  - `component`: (``KeyPathPropertyComponentSyntax`` | ``KeyPathSubscriptComponentSyntax`` | ``KeyPathOptionalComponentSyntax``)
///
/// ### Contained in
/// 
///  - ``KeyPathComponentListSyntax``
public struct KeyPathComponentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Component: SyntaxChildChoices, SyntaxHashable {
    case `property`(KeyPathPropertyComponentSyntax)
    case `subscript`(KeyPathSubscriptComponentSyntax)
    case `optional`(KeyPathOptionalComponentSyntax)
    
    public var _syntaxNode: Syntax {
      switch self {
      case .property(let node):
        return node._syntaxNode
      case .subscript(let node):
        return node._syntaxNode
      case .optional(let node):
        return node._syntaxNode
      }
    }
    
    public init(_ node: KeyPathPropertyComponentSyntax) {
      self = .property(node)
    }
    
    public init(_ node: KeyPathSubscriptComponentSyntax) {
      self = .subscript(node)
    }
    
    public init(_ node: KeyPathOptionalComponentSyntax) {
      self = .optional(node)
    }
    
    public init?(_ node: some SyntaxProtocol) {
      if let node = node.as(KeyPathPropertyComponentSyntax.self) {
        self = .property(node)
        return
      }
      if let node = node.as(KeyPathSubscriptComponentSyntax.self) {
        self = .subscript(node)
        return
      }
      if let node = node.as(KeyPathOptionalComponentSyntax.self) {
        self = .optional(node)
        return
      }
      return nil
    }
    
    public static var structure: SyntaxNodeStructure {
      return .choices([.node(KeyPathPropertyComponentSyntax.self), .node(KeyPathSubscriptComponentSyntax.self), .node(KeyPathOptionalComponentSyntax.self)])
    }
  }
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .keyPathComponent else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforePeriod: UnexpectedNodesSyntax? = nil,
      period: TokenSyntax? = nil,
      _ unexpectedBetweenPeriodAndComponent: UnexpectedNodesSyntax? = nil,
      component: Component,
      _ unexpectedAfterComponent: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforePeriod, 
            period, 
            unexpectedBetweenPeriodAndComponent, 
            component, 
            unexpectedAfterComponent
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforePeriod?.raw, 
          period?.raw, 
          unexpectedBetweenPeriodAndComponent?.raw, 
          component.raw, 
          unexpectedAfterComponent?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.keyPathComponent,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforePeriod: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathComponentSyntax.self)
    }
  }
  
  public var period: TokenSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathComponentSyntax.self)
    }
  }
  
  public var unexpectedBetweenPeriodAndComponent: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathComponentSyntax.self)
    }
  }
  
  public var component: Component {
    get {
      return Syntax(self).child(at: 3)!.cast(Component.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathComponentSyntax.self)
    }
  }
  
  public var unexpectedAfterComponent: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathComponentSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforePeriod, 
          \Self.period, 
          \Self.unexpectedBetweenPeriodAndComponent, 
          \Self.component, 
          \Self.unexpectedAfterComponent
        ])
  }
}

// MARK: - KeyPathExprSyntax

/// ### Children
/// 
///  - `backslash`: `'\'`
///  - `root`: ``TypeSyntax``?
///  - `components`: ``KeyPathComponentListSyntax``
public struct KeyPathExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .keyPathExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeBackslash: UnexpectedNodesSyntax? = nil,
      backslash: TokenSyntax = .backslashToken(),
      _ unexpectedBetweenBackslashAndRoot: UnexpectedNodesSyntax? = nil,
      root: (some TypeSyntaxProtocol)? = TypeSyntax?.none,
      _ unexpectedBetweenRootAndComponents: UnexpectedNodesSyntax? = nil,
      components: KeyPathComponentListSyntax,
      _ unexpectedAfterComponents: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeBackslash, 
            backslash, 
            unexpectedBetweenBackslashAndRoot, 
            root, 
            unexpectedBetweenRootAndComponents, 
            components, 
            unexpectedAfterComponents
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeBackslash?.raw, 
          backslash.raw, 
          unexpectedBetweenBackslashAndRoot?.raw, 
          root?.raw, 
          unexpectedBetweenRootAndComponents?.raw, 
          components.raw, 
          unexpectedAfterComponents?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.keyPathExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeBackslash: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathExprSyntax.self)
    }
  }
  
  public var backslash: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenBackslashAndRoot: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathExprSyntax.self)
    }
  }
  
  public var root: TypeSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenRootAndComponents: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathExprSyntax.self)
    }
  }
  
  public var components: KeyPathComponentListSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(KeyPathComponentListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathExprSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `components`
  /// collection.
  ///
  /// - param element: The new `KeyPathComponent` to add to the node's
  ///                  `components` collection.
  /// - returns: A copy of the receiver with the provided `KeyPathComponent`
  ///            appended to its `components` collection.
  @available(*, deprecated, message: "Use node.components.append(newElement) instead")
  public func addKeyPathComponent(_ element: KeyPathComponentSyntax) -> KeyPathExprSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[5] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.keyPathComponentList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 5, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(KeyPathExprSyntax.self)
  }
  
  public var unexpectedAfterComponents: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeBackslash, 
          \Self.backslash, 
          \Self.unexpectedBetweenBackslashAndRoot, 
          \Self.root, 
          \Self.unexpectedBetweenRootAndComponents, 
          \Self.components, 
          \Self.unexpectedAfterComponents
        ])
  }
}

// MARK: - KeyPathOptionalComponentSyntax

/// ### Children
/// 
///  - `questionOrExclamationMark`: (`'?'` | `'!'`)
///
/// ### Contained in
/// 
///  - ``KeyPathComponentSyntax``.``KeyPathComponentSyntax/component``
public struct KeyPathOptionalComponentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .keyPathOptionalComponent else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeQuestionOrExclamationMark: UnexpectedNodesSyntax? = nil,
      questionOrExclamationMark: TokenSyntax,
      _ unexpectedAfterQuestionOrExclamationMark: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (unexpectedBeforeQuestionOrExclamationMark, questionOrExclamationMark, unexpectedAfterQuestionOrExclamationMark))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeQuestionOrExclamationMark?.raw, questionOrExclamationMark.raw, unexpectedAfterQuestionOrExclamationMark?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.keyPathOptionalComponent,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeQuestionOrExclamationMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathOptionalComponentSyntax.self)
    }
  }
  
  public var questionOrExclamationMark: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathOptionalComponentSyntax.self)
    }
  }
  
  public var unexpectedAfterQuestionOrExclamationMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathOptionalComponentSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([\Self.unexpectedBeforeQuestionOrExclamationMark, \Self.questionOrExclamationMark, \Self.unexpectedAfterQuestionOrExclamationMark])
  }
}

// MARK: - KeyPathPropertyComponentSyntax

/// ### Children
/// 
///  - `declName`: ``DeclReferenceExprSyntax``
///  - `genericArgumentClause`: ``GenericArgumentClauseSyntax``?
///
/// ### Contained in
/// 
///  - ``KeyPathComponentSyntax``.``KeyPathComponentSyntax/component``
public struct KeyPathPropertyComponentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .keyPathPropertyComponent else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeDeclName: UnexpectedNodesSyntax? = nil,
      declName: DeclReferenceExprSyntax,
      _ unexpectedBetweenDeclNameAndGenericArgumentClause: UnexpectedNodesSyntax? = nil,
      genericArgumentClause: GenericArgumentClauseSyntax? = nil,
      _ unexpectedAfterGenericArgumentClause: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeDeclName, 
            declName, 
            unexpectedBetweenDeclNameAndGenericArgumentClause, 
            genericArgumentClause, 
            unexpectedAfterGenericArgumentClause
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeDeclName?.raw, 
          declName.raw, 
          unexpectedBetweenDeclNameAndGenericArgumentClause?.raw, 
          genericArgumentClause?.raw, 
          unexpectedAfterGenericArgumentClause?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.keyPathPropertyComponent,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeDeclName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathPropertyComponentSyntax.self)
    }
  }
  
  public var declName: DeclReferenceExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(DeclReferenceExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathPropertyComponentSyntax.self)
    }
  }
  
  public var unexpectedBetweenDeclNameAndGenericArgumentClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathPropertyComponentSyntax.self)
    }
  }
  
  public var genericArgumentClause: GenericArgumentClauseSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(GenericArgumentClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathPropertyComponentSyntax.self)
    }
  }
  
  public var unexpectedAfterGenericArgumentClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathPropertyComponentSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeDeclName, 
          \Self.declName, 
          \Self.unexpectedBetweenDeclNameAndGenericArgumentClause, 
          \Self.genericArgumentClause, 
          \Self.unexpectedAfterGenericArgumentClause
        ])
  }
}

// MARK: - KeyPathSubscriptComponentSyntax

/// ### Children
/// 
///  - `leftSquare`: `'['`
///  - `arguments`: ``LabeledExprListSyntax``
///  - `rightSquare`: `']'`
///
/// ### Contained in
/// 
///  - ``KeyPathComponentSyntax``.``KeyPathComponentSyntax/component``
public struct KeyPathSubscriptComponentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .keyPathSubscriptComponent else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? = nil,
      leftSquare: TokenSyntax = .leftSquareToken(),
      _ unexpectedBetweenLeftSquareAndArguments: UnexpectedNodesSyntax? = nil,
      arguments: LabeledExprListSyntax,
      _ unexpectedBetweenArgumentsAndRightSquare: UnexpectedNodesSyntax? = nil,
      rightSquare: TokenSyntax = .rightSquareToken(),
      _ unexpectedAfterRightSquare: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLeftSquare, 
            leftSquare, 
            unexpectedBetweenLeftSquareAndArguments, 
            arguments, 
            unexpectedBetweenArgumentsAndRightSquare, 
            rightSquare, 
            unexpectedAfterRightSquare
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLeftSquare?.raw, 
          leftSquare.raw, 
          unexpectedBetweenLeftSquareAndArguments?.raw, 
          arguments.raw, 
          unexpectedBetweenArgumentsAndRightSquare?.raw, 
          rightSquare.raw, 
          unexpectedAfterRightSquare?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.keyPathSubscriptComponent,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathSubscriptComponentSyntax.self)
    }
  }
  
  public var leftSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathSubscriptComponentSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftSquareAndArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathSubscriptComponentSyntax.self)
    }
  }
  
  public var arguments: LabeledExprListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(LabeledExprListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathSubscriptComponentSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `arguments`
  /// collection.
  ///
  /// - param element: The new `Argument` to add to the node's
  ///                  `arguments` collection.
  /// - returns: A copy of the receiver with the provided `Argument`
  ///            appended to its `arguments` collection.
  @available(*, deprecated, message: "Use node.arguments.append(newElement) instead")
  public func addArgument(_ element: LabeledExprSyntax) -> KeyPathSubscriptComponentSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.labeledExprList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(KeyPathSubscriptComponentSyntax.self)
  }
  
  public var unexpectedBetweenArgumentsAndRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathSubscriptComponentSyntax.self)
    }
  }
  
  public var rightSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathSubscriptComponentSyntax.self)
    }
  }
  
  public var unexpectedAfterRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(KeyPathSubscriptComponentSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLeftSquare, 
          \Self.leftSquare, 
          \Self.unexpectedBetweenLeftSquareAndArguments, 
          \Self.arguments, 
          \Self.unexpectedBetweenArgumentsAndRightSquare, 
          \Self.rightSquare, 
          \Self.unexpectedAfterRightSquare
        ])
  }
}

// MARK: - LabeledExprSyntax

/// ### Children
/// 
///  - `label`: (`<identifier>` | `'_'`)?
///  - `colon`: `':'`?
///  - `expression`: ``ExprSyntax``
///  - `trailingComma`: `','`?
///
/// ### Contained in
/// 
///  - ``LabeledExprListSyntax``
public struct LabeledExprSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .labeledExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLabel: UnexpectedNodesSyntax? = nil,
      label: TokenSyntax? = nil,
      _ unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax? = nil,
      _ unexpectedBetweenColonAndExpression: UnexpectedNodesSyntax? = nil,
      expression: some ExprSyntaxProtocol,
      _ unexpectedBetweenExpressionAndTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingComma: TokenSyntax? = nil,
      _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLabel, 
            label, 
            unexpectedBetweenLabelAndColon, 
            colon, 
            unexpectedBetweenColonAndExpression, 
            expression, 
            unexpectedBetweenExpressionAndTrailingComma, 
            trailingComma, 
            unexpectedAfterTrailingComma
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLabel?.raw, 
          label?.raw, 
          unexpectedBetweenLabelAndColon?.raw, 
          colon?.raw, 
          unexpectedBetweenColonAndExpression?.raw, 
          expression.raw, 
          unexpectedBetweenExpressionAndTrailingComma?.raw, 
          trailingComma?.raw, 
          unexpectedAfterTrailingComma?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.labeledExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(LabeledExprSyntax.self)
    }
  }
  
  public var label: TokenSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(LabeledExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(LabeledExprSyntax.self)
    }
  }
  
  public var colon: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(LabeledExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(LabeledExprSyntax.self)
    }
  }
  
  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(LabeledExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenExpressionAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(LabeledExprSyntax.self)
    }
  }
  
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(LabeledExprSyntax.self)
    }
  }
  
  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(LabeledExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLabel, 
          \Self.label, 
          \Self.unexpectedBetweenLabelAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndExpression, 
          \Self.expression, 
          \Self.unexpectedBetweenExpressionAndTrailingComma, 
          \Self.trailingComma, 
          \Self.unexpectedAfterTrailingComma
        ])
  }
}

// MARK: - LabeledSpecializeArgumentSyntax

/// A labeled argument for the `@_specialize` attribute like `exported: true`
///
/// ### Children
/// 
///  - `label`: (`'target'` | `'availability'` | `'exported'` | `'kind'` | `'spi'` | `'spiModule'` | `'available'`)
///  - `colon`: `':'`
///  - `value`: ``TokenSyntax``
///  - `trailingComma`: `','`?
///
/// ### Contained in
/// 
///  - ``SpecializeAttributeArgumentListSyntax``
public struct LabeledSpecializeArgumentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .labeledSpecializeArgument else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - label: The label of the argument
  ///   - colon: The colon separating the label and the value
  ///   - value: The value for this argument
  ///   - trailingComma: A trailing comma if this argument is followed by another one
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLabel: UnexpectedNodesSyntax? = nil,
      label: TokenSyntax,
      _ unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax = .colonToken(),
      _ unexpectedBetweenColonAndValue: UnexpectedNodesSyntax? = nil,
      value: TokenSyntax,
      _ unexpectedBetweenValueAndTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingComma: TokenSyntax? = nil,
      _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLabel, 
            label, 
            unexpectedBetweenLabelAndColon, 
            colon, 
            unexpectedBetweenColonAndValue, 
            value, 
            unexpectedBetweenValueAndTrailingComma, 
            trailingComma, 
            unexpectedAfterTrailingComma
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLabel?.raw, 
          label.raw, 
          unexpectedBetweenLabelAndColon?.raw, 
          colon.raw, 
          unexpectedBetweenColonAndValue?.raw, 
          value.raw, 
          unexpectedBetweenValueAndTrailingComma?.raw, 
          trailingComma?.raw, 
          unexpectedAfterTrailingComma?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.labeledSpecializeArgument,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(LabeledSpecializeArgumentSyntax.self)
    }
  }
  
  /// The label of the argument
  public var label: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(LabeledSpecializeArgumentSyntax.self)
    }
  }
  
  public var unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(LabeledSpecializeArgumentSyntax.self)
    }
  }
  
  /// The colon separating the label and the value
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(LabeledSpecializeArgumentSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(LabeledSpecializeArgumentSyntax.self)
    }
  }
  
  /// The value for this argument
  public var value: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(LabeledSpecializeArgumentSyntax.self)
    }
  }
  
  public var unexpectedBetweenValueAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(LabeledSpecializeArgumentSyntax.self)
    }
  }
  
  /// A trailing comma if this argument is followed by another one
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(LabeledSpecializeArgumentSyntax.self)
    }
  }
  
  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(LabeledSpecializeArgumentSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLabel, 
          \Self.label, 
          \Self.unexpectedBetweenLabelAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndValue, 
          \Self.value, 
          \Self.unexpectedBetweenValueAndTrailingComma, 
          \Self.trailingComma, 
          \Self.unexpectedAfterTrailingComma
        ])
  }
}

// MARK: - LabeledStmtSyntax

/// ### Children
/// 
///  - `label`: `<identifier>`
///  - `colon`: `':'`
///  - `statement`: ``StmtSyntax``
public struct LabeledStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .labeledStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLabel: UnexpectedNodesSyntax? = nil,
      label: TokenSyntax,
      _ unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax = .colonToken(),
      _ unexpectedBetweenColonAndStatement: UnexpectedNodesSyntax? = nil,
      statement: some StmtSyntaxProtocol,
      _ unexpectedAfterStatement: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLabel, 
            label, 
            unexpectedBetweenLabelAndColon, 
            colon, 
            unexpectedBetweenColonAndStatement, 
            statement, 
            unexpectedAfterStatement
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLabel?.raw, 
          label.raw, 
          unexpectedBetweenLabelAndColon?.raw, 
          colon.raw, 
          unexpectedBetweenColonAndStatement?.raw, 
          statement.raw, 
          unexpectedAfterStatement?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.labeledStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(LabeledStmtSyntax.self)
    }
  }
  
  public var label: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(LabeledStmtSyntax.self)
    }
  }
  
  public var unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(LabeledStmtSyntax.self)
    }
  }
  
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(LabeledStmtSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndStatement: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(LabeledStmtSyntax.self)
    }
  }
  
  public var statement: StmtSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(StmtSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(LabeledStmtSyntax.self)
    }
  }
  
  public var unexpectedAfterStatement: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(LabeledStmtSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLabel, 
          \Self.label, 
          \Self.unexpectedBetweenLabelAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndStatement, 
          \Self.statement, 
          \Self.unexpectedAfterStatement
        ])
  }
}

// MARK: - LayoutRequirementSyntax

/// ### Children
/// 
///  - `type`: ``TypeSyntax``
///  - `colon`: `':'`
///  - `layoutSpecifier`: (`'_Trivial'` | `'_TrivialAtMost'` | `'_UnknownLayout'` | `'_RefCountedObject'` | `'_NativeRefCountedObject'` | `'_Class'` | `'_NativeClass'`)
///  - `leftParen`: `'('`?
///  - `size`: `<integerLiteral>`?
///  - `comma`: `','`?
///  - `alignment`: `<integerLiteral>`?
///  - `rightParen`: `')'`?
///
/// ### Contained in
/// 
///  - ``GenericRequirementSyntax``.``GenericRequirementSyntax/requirement``
public struct LayoutRequirementSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .layoutRequirement else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeType: UnexpectedNodesSyntax? = nil,
      type: some TypeSyntaxProtocol,
      _ unexpectedBetweenTypeAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax = .colonToken(),
      _ unexpectedBetweenColonAndLayoutSpecifier: UnexpectedNodesSyntax? = nil,
      layoutSpecifier: TokenSyntax,
      _ unexpectedBetweenLayoutSpecifierAndLeftParen: UnexpectedNodesSyntax? = nil,
      leftParen: TokenSyntax? = nil,
      _ unexpectedBetweenLeftParenAndSize: UnexpectedNodesSyntax? = nil,
      size: TokenSyntax? = nil,
      _ unexpectedBetweenSizeAndComma: UnexpectedNodesSyntax? = nil,
      comma: TokenSyntax? = nil,
      _ unexpectedBetweenCommaAndAlignment: UnexpectedNodesSyntax? = nil,
      alignment: TokenSyntax? = nil,
      _ unexpectedBetweenAlignmentAndRightParen: UnexpectedNodesSyntax? = nil,
      rightParen: TokenSyntax? = nil,
      _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeType, 
            type, 
            unexpectedBetweenTypeAndColon, 
            colon, 
            unexpectedBetweenColonAndLayoutSpecifier, 
            layoutSpecifier, 
            unexpectedBetweenLayoutSpecifierAndLeftParen, 
            leftParen, 
            unexpectedBetweenLeftParenAndSize, 
            size, 
            unexpectedBetweenSizeAndComma, 
            comma, 
            unexpectedBetweenCommaAndAlignment, 
            alignment, 
            unexpectedBetweenAlignmentAndRightParen, 
            rightParen, 
            unexpectedAfterRightParen
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeType?.raw, 
          type.raw, 
          unexpectedBetweenTypeAndColon?.raw, 
          colon.raw, 
          unexpectedBetweenColonAndLayoutSpecifier?.raw, 
          layoutSpecifier.raw, 
          unexpectedBetweenLayoutSpecifierAndLeftParen?.raw, 
          leftParen?.raw, 
          unexpectedBetweenLeftParenAndSize?.raw, 
          size?.raw, 
          unexpectedBetweenSizeAndComma?.raw, 
          comma?.raw, 
          unexpectedBetweenCommaAndAlignment?.raw, 
          alignment?.raw, 
          unexpectedBetweenAlignmentAndRightParen?.raw, 
          rightParen?.raw, 
          unexpectedAfterRightParen?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.layoutRequirement,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public var type: TypeSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public var unexpectedBetweenTypeAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndLayoutSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public var layoutSpecifier: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public var unexpectedBetweenLayoutSpecifierAndLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public var leftParen: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftParenAndSize: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public var size: TokenSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public var unexpectedBetweenSizeAndComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public var comma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public var unexpectedBetweenCommaAndAlignment: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public var alignment: TokenSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public var unexpectedBetweenAlignmentAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public var rightParen: TokenSyntax? {
    get {
      return Syntax(self).child(at: 15)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 15, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 16)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 16, with: Syntax(value), arena: SyntaxArena()).cast(LayoutRequirementSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeType, 
          \Self.type, 
          \Self.unexpectedBetweenTypeAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndLayoutSpecifier, 
          \Self.layoutSpecifier, 
          \Self.unexpectedBetweenLayoutSpecifierAndLeftParen, 
          \Self.leftParen, 
          \Self.unexpectedBetweenLeftParenAndSize, 
          \Self.size, 
          \Self.unexpectedBetweenSizeAndComma, 
          \Self.comma, 
          \Self.unexpectedBetweenCommaAndAlignment, 
          \Self.alignment, 
          \Self.unexpectedBetweenAlignmentAndRightParen, 
          \Self.rightParen, 
          \Self.unexpectedAfterRightParen
        ])
  }
}

// MARK: - MacroDeclSyntax

/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `macroKeyword`: `'macro'`
///  - `name`: `<identifier>`
///  - `genericParameterClause`: ``GenericParameterClauseSyntax``?
///  - `signature`: ``FunctionSignatureSyntax``
///  - `definition`: ``InitializerClauseSyntax``?
///  - `genericWhereClause`: ``GenericWhereClauseSyntax``?
public struct MacroDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .macroDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - genericParameterClause: The parameter clause that defines the generic parameters.
  ///   - genericWhereClause: A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
      attributes: AttributeListSyntax = [],
      _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
      modifiers: DeclModifierListSyntax = [],
      _ unexpectedBetweenModifiersAndMacroKeyword: UnexpectedNodesSyntax? = nil,
      macroKeyword: TokenSyntax = .keyword(.macro),
      _ unexpectedBetweenMacroKeywordAndName: UnexpectedNodesSyntax? = nil,
      name: TokenSyntax,
      _ unexpectedBetweenNameAndGenericParameterClause: UnexpectedNodesSyntax? = nil,
      genericParameterClause: GenericParameterClauseSyntax? = nil,
      _ unexpectedBetweenGenericParameterClauseAndSignature: UnexpectedNodesSyntax? = nil,
      signature: FunctionSignatureSyntax,
      _ unexpectedBetweenSignatureAndDefinition: UnexpectedNodesSyntax? = nil,
      definition: InitializerClauseSyntax? = nil,
      _ unexpectedBetweenDefinitionAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
      genericWhereClause: GenericWhereClauseSyntax? = nil,
      _ unexpectedAfterGenericWhereClause: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAttributes, 
            attributes, 
            unexpectedBetweenAttributesAndModifiers, 
            modifiers, 
            unexpectedBetweenModifiersAndMacroKeyword, 
            macroKeyword, 
            unexpectedBetweenMacroKeywordAndName, 
            name, 
            unexpectedBetweenNameAndGenericParameterClause, 
            genericParameterClause, 
            unexpectedBetweenGenericParameterClauseAndSignature, 
            signature, 
            unexpectedBetweenSignatureAndDefinition, 
            definition, 
            unexpectedBetweenDefinitionAndGenericWhereClause, 
            genericWhereClause, 
            unexpectedAfterGenericWhereClause
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAttributes?.raw, 
          attributes.raw, 
          unexpectedBetweenAttributesAndModifiers?.raw, 
          modifiers.raw, 
          unexpectedBetweenModifiersAndMacroKeyword?.raw, 
          macroKeyword.raw, 
          unexpectedBetweenMacroKeywordAndName?.raw, 
          name.raw, 
          unexpectedBetweenNameAndGenericParameterClause?.raw, 
          genericParameterClause?.raw, 
          unexpectedBetweenGenericParameterClauseAndSignature?.raw, 
          signature.raw, 
          unexpectedBetweenSignatureAndDefinition?.raw, 
          definition?.raw, 
          unexpectedBetweenDefinitionAndGenericWhereClause?.raw, 
          genericWhereClause?.raw, 
          unexpectedAfterGenericWhereClause?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.macroDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> MacroDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(MacroDeclSyntax.self)
  }
  
  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> MacroDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(MacroDeclSyntax.self)
  }
  
  public var unexpectedBetweenModifiersAndMacroKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  public var macroKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenMacroKeywordAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenNameAndGenericParameterClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  /// The parameter clause that defines the generic parameters.
  public var genericParameterClause: GenericParameterClauseSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(GenericParameterClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenGenericParameterClauseAndSignature: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  public var signature: FunctionSignatureSyntax {
    get {
      return Syntax(self).child(at: 11)!.cast(FunctionSignatureSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenSignatureAndDefinition: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  public var definition: InitializerClauseSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(InitializerClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenDefinitionAndGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  /// A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
  public var genericWhereClause: GenericWhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 15)?.cast(GenericWhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 15, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  public var unexpectedAfterGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 16)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 16, with: Syntax(value), arena: SyntaxArena()).cast(MacroDeclSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAttributes, 
          \Self.attributes, 
          \Self.unexpectedBetweenAttributesAndModifiers, 
          \Self.modifiers, 
          \Self.unexpectedBetweenModifiersAndMacroKeyword, 
          \Self.macroKeyword, 
          \Self.unexpectedBetweenMacroKeywordAndName, 
          \Self.name, 
          \Self.unexpectedBetweenNameAndGenericParameterClause, 
          \Self.genericParameterClause, 
          \Self.unexpectedBetweenGenericParameterClauseAndSignature, 
          \Self.signature, 
          \Self.unexpectedBetweenSignatureAndDefinition, 
          \Self.definition, 
          \Self.unexpectedBetweenDefinitionAndGenericWhereClause, 
          \Self.genericWhereClause, 
          \Self.unexpectedAfterGenericWhereClause
        ])
  }
}

// MARK: - MacroExpansionDeclSyntax

/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `pound`: `'#'`
///  - `macroName`: `<identifier>`
///  - `genericArgumentClause`: ``GenericArgumentClauseSyntax``?
///  - `leftParen`: `'('`?
///  - `arguments`: ``LabeledExprListSyntax``
///  - `rightParen`: `')'`?
///  - `trailingClosure`: ``ClosureExprSyntax``?
///  - `additionalTrailingClosures`: ``MultipleTrailingClosureElementListSyntax``
public struct MacroExpansionDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .macroExpansionDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - pound: The `#` sign.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
      attributes: AttributeListSyntax = [],
      _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
      modifiers: DeclModifierListSyntax = [],
      _ unexpectedBetweenModifiersAndPound: UnexpectedNodesSyntax? = nil,
      pound: TokenSyntax = .poundToken(),
      _ unexpectedBetweenPoundAndMacroName: UnexpectedNodesSyntax? = nil,
      macroName: TokenSyntax,
      _ unexpectedBetweenMacroNameAndGenericArgumentClause: UnexpectedNodesSyntax? = nil,
      genericArgumentClause: GenericArgumentClauseSyntax? = nil,
      _ unexpectedBetweenGenericArgumentClauseAndLeftParen: UnexpectedNodesSyntax? = nil,
      leftParen: TokenSyntax? = nil,
      _ unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? = nil,
      arguments: LabeledExprListSyntax,
      _ unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? = nil,
      rightParen: TokenSyntax? = nil,
      _ unexpectedBetweenRightParenAndTrailingClosure: UnexpectedNodesSyntax? = nil,
      trailingClosure: ClosureExprSyntax? = nil,
      _ unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
      additionalTrailingClosures: MultipleTrailingClosureElementListSyntax = [],
      _ unexpectedAfterAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAttributes, 
            attributes, 
            unexpectedBetweenAttributesAndModifiers, 
            modifiers, 
            unexpectedBetweenModifiersAndPound, 
            pound, 
            unexpectedBetweenPoundAndMacroName, 
            macroName, 
            unexpectedBetweenMacroNameAndGenericArgumentClause, 
            genericArgumentClause, 
            unexpectedBetweenGenericArgumentClauseAndLeftParen, 
            leftParen, 
            unexpectedBetweenLeftParenAndArguments, 
            arguments, 
            unexpectedBetweenArgumentsAndRightParen, 
            rightParen, 
            unexpectedBetweenRightParenAndTrailingClosure, 
            trailingClosure, 
            unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures, 
            additionalTrailingClosures, 
            unexpectedAfterAdditionalTrailingClosures
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAttributes?.raw, 
          attributes.raw, 
          unexpectedBetweenAttributesAndModifiers?.raw, 
          modifiers.raw, 
          unexpectedBetweenModifiersAndPound?.raw, 
          pound.raw, 
          unexpectedBetweenPoundAndMacroName?.raw, 
          macroName.raw, 
          unexpectedBetweenMacroNameAndGenericArgumentClause?.raw, 
          genericArgumentClause?.raw, 
          unexpectedBetweenGenericArgumentClauseAndLeftParen?.raw, 
          leftParen?.raw, 
          unexpectedBetweenLeftParenAndArguments?.raw, 
          arguments.raw, 
          unexpectedBetweenArgumentsAndRightParen?.raw, 
          rightParen?.raw, 
          unexpectedBetweenRightParenAndTrailingClosure?.raw, 
          trailingClosure?.raw, 
          unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures?.raw, 
          additionalTrailingClosures.raw, 
          unexpectedAfterAdditionalTrailingClosures?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.macroExpansionDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> MacroExpansionDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(MacroExpansionDeclSyntax.self)
  }
  
  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> MacroExpansionDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(MacroExpansionDeclSyntax.self)
  }
  
  public var unexpectedBetweenModifiersAndPound: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  /// The `#` sign.
  public var pound: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenPoundAndMacroName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  public var macroName: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenMacroNameAndGenericArgumentClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  public var genericArgumentClause: GenericArgumentClauseSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(GenericArgumentClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenGenericArgumentClauseAndLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  public var leftParen: TokenSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  public var arguments: LabeledExprListSyntax {
    get {
      return Syntax(self).child(at: 13)!.cast(LabeledExprListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `arguments`
  /// collection.
  ///
  /// - param element: The new `Argument` to add to the node's
  ///                  `arguments` collection.
  /// - returns: A copy of the receiver with the provided `Argument`
  ///            appended to its `arguments` collection.
  @available(*, deprecated, message: "Use node.arguments.append(newElement) instead")
  public func addArgument(_ element: LabeledExprSyntax) -> MacroExpansionDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[13] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.labeledExprList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 13, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(MacroExpansionDeclSyntax.self)
  }
  
  public var unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  public var rightParen: TokenSyntax? {
    get {
      return Syntax(self).child(at: 15)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 15, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenRightParenAndTrailingClosure: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 16)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 16, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  public var trailingClosure: ClosureExprSyntax? {
    get {
      return Syntax(self).child(at: 17)?.cast(ClosureExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 17, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 18)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 18, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  public var additionalTrailingClosures: MultipleTrailingClosureElementListSyntax {
    get {
      return Syntax(self).child(at: 19)!.cast(MultipleTrailingClosureElementListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 19, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `additionalTrailingClosures`
  /// collection.
  ///
  /// - param element: The new `AdditionalTrailingClosure` to add to the node's
  ///                  `additionalTrailingClosures` collection.
  /// - returns: A copy of the receiver with the provided `AdditionalTrailingClosure`
  ///            appended to its `additionalTrailingClosures` collection.
  @available(*, deprecated, message: "Use node.additionalTrailingClosures.append(newElement) instead")
  public func addAdditionalTrailingClosure(_ element: MultipleTrailingClosureElementSyntax) -> MacroExpansionDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[19] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.multipleTrailingClosureElementList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 19, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(MacroExpansionDeclSyntax.self)
  }
  
  public var unexpectedAfterAdditionalTrailingClosures: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 20)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 20, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionDeclSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAttributes, 
          \Self.attributes, 
          \Self.unexpectedBetweenAttributesAndModifiers, 
          \Self.modifiers, 
          \Self.unexpectedBetweenModifiersAndPound, 
          \Self.pound, 
          \Self.unexpectedBetweenPoundAndMacroName, 
          \Self.macroName, 
          \Self.unexpectedBetweenMacroNameAndGenericArgumentClause, 
          \Self.genericArgumentClause, 
          \Self.unexpectedBetweenGenericArgumentClauseAndLeftParen, 
          \Self.leftParen, 
          \Self.unexpectedBetweenLeftParenAndArguments, 
          \Self.arguments, 
          \Self.unexpectedBetweenArgumentsAndRightParen, 
          \Self.rightParen, 
          \Self.unexpectedBetweenRightParenAndTrailingClosure, 
          \Self.trailingClosure, 
          \Self.unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures, 
          \Self.additionalTrailingClosures, 
          \Self.unexpectedAfterAdditionalTrailingClosures
        ])
  }
}

// MARK: - MacroExpansionExprSyntax

/// ### Children
/// 
///  - `pound`: `'#'`
///  - `macroName`: `<identifier>`
///  - `genericArgumentClause`: ``GenericArgumentClauseSyntax``?
///  - `leftParen`: `'('`?
///  - `arguments`: ``LabeledExprListSyntax``
///  - `rightParen`: `')'`?
///  - `trailingClosure`: ``ClosureExprSyntax``?
///  - `additionalTrailingClosures`: ``MultipleTrailingClosureElementListSyntax``
public struct MacroExpansionExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .macroExpansionExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - pound: The `#` sign.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforePound: UnexpectedNodesSyntax? = nil,
      pound: TokenSyntax = .poundToken(),
      _ unexpectedBetweenPoundAndMacroName: UnexpectedNodesSyntax? = nil,
      macroName: TokenSyntax,
      _ unexpectedBetweenMacroNameAndGenericArgumentClause: UnexpectedNodesSyntax? = nil,
      genericArgumentClause: GenericArgumentClauseSyntax? = nil,
      _ unexpectedBetweenGenericArgumentClauseAndLeftParen: UnexpectedNodesSyntax? = nil,
      leftParen: TokenSyntax? = nil,
      _ unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? = nil,
      arguments: LabeledExprListSyntax,
      _ unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? = nil,
      rightParen: TokenSyntax? = nil,
      _ unexpectedBetweenRightParenAndTrailingClosure: UnexpectedNodesSyntax? = nil,
      trailingClosure: ClosureExprSyntax? = nil,
      _ unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
      additionalTrailingClosures: MultipleTrailingClosureElementListSyntax = [],
      _ unexpectedAfterAdditionalTrailingClosures: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforePound, 
            pound, 
            unexpectedBetweenPoundAndMacroName, 
            macroName, 
            unexpectedBetweenMacroNameAndGenericArgumentClause, 
            genericArgumentClause, 
            unexpectedBetweenGenericArgumentClauseAndLeftParen, 
            leftParen, 
            unexpectedBetweenLeftParenAndArguments, 
            arguments, 
            unexpectedBetweenArgumentsAndRightParen, 
            rightParen, 
            unexpectedBetweenRightParenAndTrailingClosure, 
            trailingClosure, 
            unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures, 
            additionalTrailingClosures, 
            unexpectedAfterAdditionalTrailingClosures
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforePound?.raw, 
          pound.raw, 
          unexpectedBetweenPoundAndMacroName?.raw, 
          macroName.raw, 
          unexpectedBetweenMacroNameAndGenericArgumentClause?.raw, 
          genericArgumentClause?.raw, 
          unexpectedBetweenGenericArgumentClauseAndLeftParen?.raw, 
          leftParen?.raw, 
          unexpectedBetweenLeftParenAndArguments?.raw, 
          arguments.raw, 
          unexpectedBetweenArgumentsAndRightParen?.raw, 
          rightParen?.raw, 
          unexpectedBetweenRightParenAndTrailingClosure?.raw, 
          trailingClosure?.raw, 
          unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures?.raw, 
          additionalTrailingClosures.raw, 
          unexpectedAfterAdditionalTrailingClosures?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.macroExpansionExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforePound: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  /// The `#` sign.
  public var pound: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenPoundAndMacroName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  public var macroName: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenMacroNameAndGenericArgumentClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  public var genericArgumentClause: GenericArgumentClauseSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(GenericArgumentClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenGenericArgumentClauseAndLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  public var leftParen: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  public var arguments: LabeledExprListSyntax {
    get {
      return Syntax(self).child(at: 9)!.cast(LabeledExprListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `arguments`
  /// collection.
  ///
  /// - param element: The new `Argument` to add to the node's
  ///                  `arguments` collection.
  /// - returns: A copy of the receiver with the provided `Argument`
  ///            appended to its `arguments` collection.
  @available(*, deprecated, message: "Use node.arguments.append(newElement) instead")
  public func addArgument(_ element: LabeledExprSyntax) -> MacroExpansionExprSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[9] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.labeledExprList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 9, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(MacroExpansionExprSyntax.self)
  }
  
  public var unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  public var rightParen: TokenSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenRightParenAndTrailingClosure: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  public var trailingClosure: ClosureExprSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(ClosureExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  public var additionalTrailingClosures: MultipleTrailingClosureElementListSyntax {
    get {
      return Syntax(self).child(at: 15)!.cast(MultipleTrailingClosureElementListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 15, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `additionalTrailingClosures`
  /// collection.
  ///
  /// - param element: The new `AdditionalTrailingClosure` to add to the node's
  ///                  `additionalTrailingClosures` collection.
  /// - returns: A copy of the receiver with the provided `AdditionalTrailingClosure`
  ///            appended to its `additionalTrailingClosures` collection.
  @available(*, deprecated, message: "Use node.additionalTrailingClosures.append(newElement) instead")
  public func addAdditionalTrailingClosure(_ element: MultipleTrailingClosureElementSyntax) -> MacroExpansionExprSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[15] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.multipleTrailingClosureElementList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 15, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(MacroExpansionExprSyntax.self)
  }
  
  public var unexpectedAfterAdditionalTrailingClosures: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 16)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 16, with: Syntax(value), arena: SyntaxArena()).cast(MacroExpansionExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforePound, 
          \Self.pound, 
          \Self.unexpectedBetweenPoundAndMacroName, 
          \Self.macroName, 
          \Self.unexpectedBetweenMacroNameAndGenericArgumentClause, 
          \Self.genericArgumentClause, 
          \Self.unexpectedBetweenGenericArgumentClauseAndLeftParen, 
          \Self.leftParen, 
          \Self.unexpectedBetweenLeftParenAndArguments, 
          \Self.arguments, 
          \Self.unexpectedBetweenArgumentsAndRightParen, 
          \Self.rightParen, 
          \Self.unexpectedBetweenRightParenAndTrailingClosure, 
          \Self.trailingClosure, 
          \Self.unexpectedBetweenTrailingClosureAndAdditionalTrailingClosures, 
          \Self.additionalTrailingClosures, 
          \Self.unexpectedAfterAdditionalTrailingClosures
        ])
  }
}

// MARK: - MatchingPatternConditionSyntax

/// ### Children
/// 
///  - `caseKeyword`: `'case'`
///  - `pattern`: ``PatternSyntax``
///  - `typeAnnotation`: ``TypeAnnotationSyntax``?
///  - `initializer`: ``InitializerClauseSyntax``
///
/// ### Contained in
/// 
///  - ``ConditionElementSyntax``.``ConditionElementSyntax/condition``
public struct MatchingPatternConditionSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .matchingPatternCondition else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeCaseKeyword: UnexpectedNodesSyntax? = nil,
      caseKeyword: TokenSyntax = .keyword(.case),
      _ unexpectedBetweenCaseKeywordAndPattern: UnexpectedNodesSyntax? = nil,
      pattern: some PatternSyntaxProtocol,
      _ unexpectedBetweenPatternAndTypeAnnotation: UnexpectedNodesSyntax? = nil,
      typeAnnotation: TypeAnnotationSyntax? = nil,
      _ unexpectedBetweenTypeAnnotationAndInitializer: UnexpectedNodesSyntax? = nil,
      initializer: InitializerClauseSyntax,
      _ unexpectedAfterInitializer: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeCaseKeyword, 
            caseKeyword, 
            unexpectedBetweenCaseKeywordAndPattern, 
            pattern, 
            unexpectedBetweenPatternAndTypeAnnotation, 
            typeAnnotation, 
            unexpectedBetweenTypeAnnotationAndInitializer, 
            initializer, 
            unexpectedAfterInitializer
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeCaseKeyword?.raw, 
          caseKeyword.raw, 
          unexpectedBetweenCaseKeywordAndPattern?.raw, 
          pattern.raw, 
          unexpectedBetweenPatternAndTypeAnnotation?.raw, 
          typeAnnotation?.raw, 
          unexpectedBetweenTypeAnnotationAndInitializer?.raw, 
          initializer.raw, 
          unexpectedAfterInitializer?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.matchingPatternCondition,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeCaseKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(MatchingPatternConditionSyntax.self)
    }
  }
  
  public var caseKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(MatchingPatternConditionSyntax.self)
    }
  }
  
  public var unexpectedBetweenCaseKeywordAndPattern: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(MatchingPatternConditionSyntax.self)
    }
  }
  
  public var pattern: PatternSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(PatternSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(MatchingPatternConditionSyntax.self)
    }
  }
  
  public var unexpectedBetweenPatternAndTypeAnnotation: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(MatchingPatternConditionSyntax.self)
    }
  }
  
  public var typeAnnotation: TypeAnnotationSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(TypeAnnotationSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(MatchingPatternConditionSyntax.self)
    }
  }
  
  public var unexpectedBetweenTypeAnnotationAndInitializer: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(MatchingPatternConditionSyntax.self)
    }
  }
  
  public var initializer: InitializerClauseSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(InitializerClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(MatchingPatternConditionSyntax.self)
    }
  }
  
  public var unexpectedAfterInitializer: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(MatchingPatternConditionSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeCaseKeyword, 
          \Self.caseKeyword, 
          \Self.unexpectedBetweenCaseKeywordAndPattern, 
          \Self.pattern, 
          \Self.unexpectedBetweenPatternAndTypeAnnotation, 
          \Self.typeAnnotation, 
          \Self.unexpectedBetweenTypeAnnotationAndInitializer, 
          \Self.initializer, 
          \Self.unexpectedAfterInitializer
        ])
  }
}

// MARK: - MemberAccessExprSyntax

/// An expression that access a member like a function or a property.
///
/// ### Children
/// 
///  - `base`: ``ExprSyntax``?
///  - `period`: `'.'`
///  - `declName`: ``DeclReferenceExprSyntax``
public struct MemberAccessExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .memberAccessExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - base: The base of the member access, optionally specified.
  ///   - declName: The name of the referenced function or a property.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeBase: UnexpectedNodesSyntax? = nil,
      base: (some ExprSyntaxProtocol)? = ExprSyntax?.none,
      _ unexpectedBetweenBaseAndPeriod: UnexpectedNodesSyntax? = nil,
      period: TokenSyntax = .periodToken(),
      _ unexpectedBetweenPeriodAndDeclName: UnexpectedNodesSyntax? = nil,
      declName: DeclReferenceExprSyntax,
      _ unexpectedAfterDeclName: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeBase, 
            base, 
            unexpectedBetweenBaseAndPeriod, 
            period, 
            unexpectedBetweenPeriodAndDeclName, 
            declName, 
            unexpectedAfterDeclName
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeBase?.raw, 
          base?.raw, 
          unexpectedBetweenBaseAndPeriod?.raw, 
          period.raw, 
          unexpectedBetweenPeriodAndDeclName?.raw, 
          declName.raw, 
          unexpectedAfterDeclName?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.memberAccessExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeBase: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(MemberAccessExprSyntax.self)
    }
  }
  
  /// The base of the member access, optionally specified.
  public var base: ExprSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(MemberAccessExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenBaseAndPeriod: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(MemberAccessExprSyntax.self)
    }
  }
  
  public var period: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(MemberAccessExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenPeriodAndDeclName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(MemberAccessExprSyntax.self)
    }
  }
  
  /// The name of the referenced function or a property.
  public var declName: DeclReferenceExprSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(DeclReferenceExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(MemberAccessExprSyntax.self)
    }
  }
  
  public var unexpectedAfterDeclName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(MemberAccessExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeBase, 
          \Self.base, 
          \Self.unexpectedBetweenBaseAndPeriod, 
          \Self.period, 
          \Self.unexpectedBetweenPeriodAndDeclName, 
          \Self.declName, 
          \Self.unexpectedAfterDeclName
        ])
  }
}

// MARK: - MemberBlockItemSyntax

/// A member declaration of a type consisting of a declaration and an optional semicolon;
///
/// ### Children
/// 
///  - `decl`: ``DeclSyntax``
///  - `semicolon`: `';'`?
///
/// ### Contained in
/// 
///  - ``MemberBlockItemListSyntax``
public struct MemberBlockItemSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .memberBlockItem else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - decl: The declaration of the type member.
  ///   - semicolon: An optional trailing semicolon.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeDecl: UnexpectedNodesSyntax? = nil,
      decl: some DeclSyntaxProtocol,
      _ unexpectedBetweenDeclAndSemicolon: UnexpectedNodesSyntax? = nil,
      semicolon: TokenSyntax? = nil,
      _ unexpectedAfterSemicolon: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeDecl, 
            decl, 
            unexpectedBetweenDeclAndSemicolon, 
            semicolon, 
            unexpectedAfterSemicolon
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeDecl?.raw, 
          decl.raw, 
          unexpectedBetweenDeclAndSemicolon?.raw, 
          semicolon?.raw, 
          unexpectedAfterSemicolon?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.memberBlockItem,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeDecl: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(MemberBlockItemSyntax.self)
    }
  }
  
  /// The declaration of the type member.
  public var decl: DeclSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(DeclSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(MemberBlockItemSyntax.self)
    }
  }
  
  public var unexpectedBetweenDeclAndSemicolon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(MemberBlockItemSyntax.self)
    }
  }
  
  /// An optional trailing semicolon.
  public var semicolon: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(MemberBlockItemSyntax.self)
    }
  }
  
  public var unexpectedAfterSemicolon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(MemberBlockItemSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeDecl, 
          \Self.decl, 
          \Self.unexpectedBetweenDeclAndSemicolon, 
          \Self.semicolon, 
          \Self.unexpectedAfterSemicolon
        ])
  }
}

// MARK: - MemberBlockSyntax

/// ### Children
/// 
///  - `leftBrace`: `'{'`
///  - `members`: ``MemberBlockItemListSyntax``
///  - `rightBrace`: `'}'`
///
/// ### Contained in
/// 
///  - ``ActorDeclSyntax``.``ActorDeclSyntax/memberBlock``
///  - ``ClassDeclSyntax``.``ClassDeclSyntax/memberBlock``
///  - ``EnumDeclSyntax``.``EnumDeclSyntax/memberBlock``
///  - ``ExtensionDeclSyntax``.``ExtensionDeclSyntax/memberBlock``
///  - ``ProtocolDeclSyntax``.``ProtocolDeclSyntax/memberBlock``
///  - ``StructDeclSyntax``.``StructDeclSyntax/memberBlock``
public struct MemberBlockSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .memberBlock else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLeftBrace: UnexpectedNodesSyntax? = nil,
      leftBrace: TokenSyntax = .leftBraceToken(),
      _ unexpectedBetweenLeftBraceAndMembers: UnexpectedNodesSyntax? = nil,
      members: MemberBlockItemListSyntax,
      _ unexpectedBetweenMembersAndRightBrace: UnexpectedNodesSyntax? = nil,
      rightBrace: TokenSyntax = .rightBraceToken(),
      _ unexpectedAfterRightBrace: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLeftBrace, 
            leftBrace, 
            unexpectedBetweenLeftBraceAndMembers, 
            members, 
            unexpectedBetweenMembersAndRightBrace, 
            rightBrace, 
            unexpectedAfterRightBrace
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLeftBrace?.raw, 
          leftBrace.raw, 
          unexpectedBetweenLeftBraceAndMembers?.raw, 
          members.raw, 
          unexpectedBetweenMembersAndRightBrace?.raw, 
          rightBrace.raw, 
          unexpectedAfterRightBrace?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.memberBlock,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLeftBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(MemberBlockSyntax.self)
    }
  }
  
  public var leftBrace: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(MemberBlockSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftBraceAndMembers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(MemberBlockSyntax.self)
    }
  }
  
  public var members: MemberBlockItemListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(MemberBlockItemListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(MemberBlockSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `members`
  /// collection.
  ///
  /// - param element: The new `Member` to add to the node's
  ///                  `members` collection.
  /// - returns: A copy of the receiver with the provided `Member`
  ///            appended to its `members` collection.
  @available(*, deprecated, message: "Use node.members.append(newElement) instead")
  public func addMember(_ element: MemberBlockItemSyntax) -> MemberBlockSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.memberBlockItemList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(MemberBlockSyntax.self)
  }
  
  public var unexpectedBetweenMembersAndRightBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(MemberBlockSyntax.self)
    }
  }
  
  public var rightBrace: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(MemberBlockSyntax.self)
    }
  }
  
  public var unexpectedAfterRightBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(MemberBlockSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLeftBrace, 
          \Self.leftBrace, 
          \Self.unexpectedBetweenLeftBraceAndMembers, 
          \Self.members, 
          \Self.unexpectedBetweenMembersAndRightBrace, 
          \Self.rightBrace, 
          \Self.unexpectedAfterRightBrace
        ])
  }
}

// MARK: - MemberTypeSyntax

/// ### Children
/// 
///  - `baseType`: ``TypeSyntax``
///  - `period`: `'.'`
///  - `name`: (`<identifier>` | `'self'`)
///  - `genericArgumentClause`: ``GenericArgumentClauseSyntax``?
public struct MemberTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .memberType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeBaseType: UnexpectedNodesSyntax? = nil,
      baseType: some TypeSyntaxProtocol,
      _ unexpectedBetweenBaseTypeAndPeriod: UnexpectedNodesSyntax? = nil,
      period: TokenSyntax = .periodToken(),
      _ unexpectedBetweenPeriodAndName: UnexpectedNodesSyntax? = nil,
      name: TokenSyntax,
      _ unexpectedBetweenNameAndGenericArgumentClause: UnexpectedNodesSyntax? = nil,
      genericArgumentClause: GenericArgumentClauseSyntax? = nil,
      _ unexpectedAfterGenericArgumentClause: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeBaseType, 
            baseType, 
            unexpectedBetweenBaseTypeAndPeriod, 
            period, 
            unexpectedBetweenPeriodAndName, 
            name, 
            unexpectedBetweenNameAndGenericArgumentClause, 
            genericArgumentClause, 
            unexpectedAfterGenericArgumentClause
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeBaseType?.raw, 
          baseType.raw, 
          unexpectedBetweenBaseTypeAndPeriod?.raw, 
          period.raw, 
          unexpectedBetweenPeriodAndName?.raw, 
          name.raw, 
          unexpectedBetweenNameAndGenericArgumentClause?.raw, 
          genericArgumentClause?.raw, 
          unexpectedAfterGenericArgumentClause?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.memberType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeBaseType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(MemberTypeSyntax.self)
    }
  }
  
  public var baseType: TypeSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(MemberTypeSyntax.self)
    }
  }
  
  public var unexpectedBetweenBaseTypeAndPeriod: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(MemberTypeSyntax.self)
    }
  }
  
  public var period: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(MemberTypeSyntax.self)
    }
  }
  
  public var unexpectedBetweenPeriodAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(MemberTypeSyntax.self)
    }
  }
  
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(MemberTypeSyntax.self)
    }
  }
  
  public var unexpectedBetweenNameAndGenericArgumentClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(MemberTypeSyntax.self)
    }
  }
  
  public var genericArgumentClause: GenericArgumentClauseSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(GenericArgumentClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(MemberTypeSyntax.self)
    }
  }
  
  public var unexpectedAfterGenericArgumentClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(MemberTypeSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeBaseType, 
          \Self.baseType, 
          \Self.unexpectedBetweenBaseTypeAndPeriod, 
          \Self.period, 
          \Self.unexpectedBetweenPeriodAndName, 
          \Self.name, 
          \Self.unexpectedBetweenNameAndGenericArgumentClause, 
          \Self.genericArgumentClause, 
          \Self.unexpectedAfterGenericArgumentClause
        ])
  }
}

// MARK: - MetatypeTypeSyntax

/// ### Children
/// 
///  - `baseType`: ``TypeSyntax``
///  - `period`: `'.'`
///  - `metatypeSpecifier`: (`'Type'` | `'Protocol'`)
public struct MetatypeTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .metatypeType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeBaseType: UnexpectedNodesSyntax? = nil,
      baseType: some TypeSyntaxProtocol,
      _ unexpectedBetweenBaseTypeAndPeriod: UnexpectedNodesSyntax? = nil,
      period: TokenSyntax = .periodToken(),
      _ unexpectedBetweenPeriodAndMetatypeSpecifier: UnexpectedNodesSyntax? = nil,
      metatypeSpecifier: TokenSyntax,
      _ unexpectedAfterMetatypeSpecifier: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeBaseType, 
            baseType, 
            unexpectedBetweenBaseTypeAndPeriod, 
            period, 
            unexpectedBetweenPeriodAndMetatypeSpecifier, 
            metatypeSpecifier, 
            unexpectedAfterMetatypeSpecifier
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeBaseType?.raw, 
          baseType.raw, 
          unexpectedBetweenBaseTypeAndPeriod?.raw, 
          period.raw, 
          unexpectedBetweenPeriodAndMetatypeSpecifier?.raw, 
          metatypeSpecifier.raw, 
          unexpectedAfterMetatypeSpecifier?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.metatypeType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeBaseType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(MetatypeTypeSyntax.self)
    }
  }
  
  public var baseType: TypeSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(MetatypeTypeSyntax.self)
    }
  }
  
  public var unexpectedBetweenBaseTypeAndPeriod: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(MetatypeTypeSyntax.self)
    }
  }
  
  public var period: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(MetatypeTypeSyntax.self)
    }
  }
  
  public var unexpectedBetweenPeriodAndMetatypeSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(MetatypeTypeSyntax.self)
    }
  }
  
  public var metatypeSpecifier: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(MetatypeTypeSyntax.self)
    }
  }
  
  public var unexpectedAfterMetatypeSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(MetatypeTypeSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeBaseType, 
          \Self.baseType, 
          \Self.unexpectedBetweenBaseTypeAndPeriod, 
          \Self.period, 
          \Self.unexpectedBetweenPeriodAndMetatypeSpecifier, 
          \Self.metatypeSpecifier, 
          \Self.unexpectedAfterMetatypeSpecifier
        ])
  }
}

// MARK: - MissingDeclSyntax

/// In case the source code is missing a declaration, this node stands in place of the missing declaration.
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `placeholder`: `<identifier>`
public struct MissingDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .missingDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attributes: If there were standalone attributes without a declaration to attach them to, the ``MissingDeclSyntax`` will contain these.
  ///   - modifiers: If there were standalone modifiers without a declaration to attach them to, the ``MissingDeclSyntax`` will contain these.
  ///   - placeholder: A placeholder, i.e. `<#decl#>`, that can be inserted into the source code to represent the missing declaration.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
      attributes: AttributeListSyntax = [],
      _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
      modifiers: DeclModifierListSyntax = [],
      _ unexpectedBetweenModifiersAndPlaceholder: UnexpectedNodesSyntax? = nil,
      placeholder: TokenSyntax,
      _ unexpectedAfterPlaceholder: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAttributes, 
            attributes, 
            unexpectedBetweenAttributesAndModifiers, 
            modifiers, 
            unexpectedBetweenModifiersAndPlaceholder, 
            placeholder, 
            unexpectedAfterPlaceholder
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAttributes?.raw, 
          attributes.raw, 
          unexpectedBetweenAttributesAndModifiers?.raw, 
          modifiers.raw, 
          unexpectedBetweenModifiersAndPlaceholder?.raw, 
          placeholder.raw, 
          unexpectedAfterPlaceholder?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.missingDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(MissingDeclSyntax.self)
    }
  }
  
  /// If there were standalone attributes without a declaration to attach them to, the ``MissingDeclSyntax`` will contain these.
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(MissingDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> MissingDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(MissingDeclSyntax.self)
  }
  
  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(MissingDeclSyntax.self)
    }
  }
  
  /// If there were standalone modifiers without a declaration to attach them to, the ``MissingDeclSyntax`` will contain these.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(MissingDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> MissingDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(MissingDeclSyntax.self)
  }
  
  public var unexpectedBetweenModifiersAndPlaceholder: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(MissingDeclSyntax.self)
    }
  }
  
  /// A placeholder, i.e. `<#decl#>`, that can be inserted into the source code to represent the missing declaration.
  /// 
  /// This token should always have `presence = .missing`.
  public var placeholder: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(MissingDeclSyntax.self)
    }
  }
  
  public var unexpectedAfterPlaceholder: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(MissingDeclSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAttributes, 
          \Self.attributes, 
          \Self.unexpectedBetweenAttributesAndModifiers, 
          \Self.modifiers, 
          \Self.unexpectedBetweenModifiersAndPlaceholder, 
          \Self.placeholder, 
          \Self.unexpectedAfterPlaceholder
        ])
  }
}

// MARK: - MissingExprSyntax

/// In case the source code is missing an expression, this node stands in place of the missing expression.
///
/// ### Children
/// 
///  - `placeholder`: `<identifier>`
public struct MissingExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .missingExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - placeholder: A placeholder, i.e. `<#expression#>`, that can be inserted into the source code to represent the missing expression.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforePlaceholder: UnexpectedNodesSyntax? = nil,
      placeholder: TokenSyntax,
      _ unexpectedAfterPlaceholder: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (unexpectedBeforePlaceholder, placeholder, unexpectedAfterPlaceholder))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforePlaceholder?.raw, placeholder.raw, unexpectedAfterPlaceholder?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.missingExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforePlaceholder: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(MissingExprSyntax.self)
    }
  }
  
  /// A placeholder, i.e. `<#expression#>`, that can be inserted into the source code to represent the missing expression.
  /// 
  /// This token should always have `presence = .missing`.
  public var placeholder: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(MissingExprSyntax.self)
    }
  }
  
  public var unexpectedAfterPlaceholder: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(MissingExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([\Self.unexpectedBeforePlaceholder, \Self.placeholder, \Self.unexpectedAfterPlaceholder])
  }
}

// MARK: - MissingPatternSyntax

/// In case the source code is missing a pattern, this node stands in place of the missing pattern.
///
/// ### Children
/// 
///  - `placeholder`: `<identifier>`
public struct MissingPatternSyntax: PatternSyntaxProtocol, SyntaxHashable, _LeafPatternSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .missingPattern else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - placeholder: A placeholder, i.e. `<#pattern#>`, that can be inserted into the source code to represent the missing pattern.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforePlaceholder: UnexpectedNodesSyntax? = nil,
      placeholder: TokenSyntax,
      _ unexpectedAfterPlaceholder: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (unexpectedBeforePlaceholder, placeholder, unexpectedAfterPlaceholder))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforePlaceholder?.raw, placeholder.raw, unexpectedAfterPlaceholder?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.missingPattern,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforePlaceholder: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(MissingPatternSyntax.self)
    }
  }
  
  /// A placeholder, i.e. `<#pattern#>`, that can be inserted into the source code to represent the missing pattern.
  /// 
  /// This token should always have `presence = .missing`.
  public var placeholder: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(MissingPatternSyntax.self)
    }
  }
  
  public var unexpectedAfterPlaceholder: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(MissingPatternSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([\Self.unexpectedBeforePlaceholder, \Self.placeholder, \Self.unexpectedAfterPlaceholder])
  }
}

// MARK: - MissingStmtSyntax

/// In case the source code is missing a statement, this node stands in place of the missing statement.
///
/// ### Children
/// 
///  - `placeholder`: `<identifier>`
public struct MissingStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .missingStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - placeholder: A placeholder, i.e. `<#statement#>`, that can be inserted into the source code to represent the missing pattern.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforePlaceholder: UnexpectedNodesSyntax? = nil,
      placeholder: TokenSyntax,
      _ unexpectedAfterPlaceholder: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (unexpectedBeforePlaceholder, placeholder, unexpectedAfterPlaceholder))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforePlaceholder?.raw, placeholder.raw, unexpectedAfterPlaceholder?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.missingStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforePlaceholder: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(MissingStmtSyntax.self)
    }
  }
  
  /// A placeholder, i.e. `<#statement#>`, that can be inserted into the source code to represent the missing pattern.
  /// 
  /// This token should always have `presence = .missing`.
  public var placeholder: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(MissingStmtSyntax.self)
    }
  }
  
  public var unexpectedAfterPlaceholder: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(MissingStmtSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([\Self.unexpectedBeforePlaceholder, \Self.placeholder, \Self.unexpectedAfterPlaceholder])
  }
}

// MARK: - MissingSyntax

/// In case the source code is missing a syntax node, this node stands in place of the missing node.
///
/// ### Children
/// 
///  - `placeholder`: `<identifier>`
public struct MissingSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .missing else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - placeholder: A placeholder, i.e. `<#syntax#>`, that can be inserted into the source code to represent the missing pattern.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforePlaceholder: UnexpectedNodesSyntax? = nil,
      placeholder: TokenSyntax,
      _ unexpectedAfterPlaceholder: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (unexpectedBeforePlaceholder, placeholder, unexpectedAfterPlaceholder))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforePlaceholder?.raw, placeholder.raw, unexpectedAfterPlaceholder?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.missing,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforePlaceholder: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(MissingSyntax.self)
    }
  }
  
  /// A placeholder, i.e. `<#syntax#>`, that can be inserted into the source code to represent the missing pattern.
  /// 
  /// This token should always have `presence = .missing`
  public var placeholder: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(MissingSyntax.self)
    }
  }
  
  public var unexpectedAfterPlaceholder: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(MissingSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([\Self.unexpectedBeforePlaceholder, \Self.placeholder, \Self.unexpectedAfterPlaceholder])
  }
}

// MARK: - MissingTypeSyntax

/// In case the source code is missing a type, this node stands in place of the missing type.
///
/// ### Children
/// 
///  - `placeholder`: `<identifier>`
public struct MissingTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .missingType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - placeholder: A placeholder, i.e. `<#type#>`, that can be inserted into the source code to represent the missing type.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforePlaceholder: UnexpectedNodesSyntax? = nil,
      placeholder: TokenSyntax,
      _ unexpectedAfterPlaceholder: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (unexpectedBeforePlaceholder, placeholder, unexpectedAfterPlaceholder))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforePlaceholder?.raw, placeholder.raw, unexpectedAfterPlaceholder?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.missingType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforePlaceholder: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(MissingTypeSyntax.self)
    }
  }
  
  /// A placeholder, i.e. `<#type#>`, that can be inserted into the source code to represent the missing type.
  /// 
  /// This token should always have `presence = .missing`.
  public var placeholder: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(MissingTypeSyntax.self)
    }
  }
  
  public var unexpectedAfterPlaceholder: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(MissingTypeSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([\Self.unexpectedBeforePlaceholder, \Self.placeholder, \Self.unexpectedAfterPlaceholder])
  }
}

// MARK: - MultipleTrailingClosureElementSyntax

/// ### Children
/// 
///  - `label`: (`<identifier>` | `'_'`)
///  - `colon`: `':'`
///  - `closure`: ``ClosureExprSyntax``
///
/// ### Contained in
/// 
///  - ``MultipleTrailingClosureElementListSyntax``
public struct MultipleTrailingClosureElementSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .multipleTrailingClosureElement else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLabel: UnexpectedNodesSyntax? = nil,
      label: TokenSyntax,
      _ unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax = .colonToken(),
      _ unexpectedBetweenColonAndClosure: UnexpectedNodesSyntax? = nil,
      closure: ClosureExprSyntax,
      _ unexpectedAfterClosure: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLabel, 
            label, 
            unexpectedBetweenLabelAndColon, 
            colon, 
            unexpectedBetweenColonAndClosure, 
            closure, 
            unexpectedAfterClosure
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLabel?.raw, 
          label.raw, 
          unexpectedBetweenLabelAndColon?.raw, 
          colon.raw, 
          unexpectedBetweenColonAndClosure?.raw, 
          closure.raw, 
          unexpectedAfterClosure?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.multipleTrailingClosureElement,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(MultipleTrailingClosureElementSyntax.self)
    }
  }
  
  public var label: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(MultipleTrailingClosureElementSyntax.self)
    }
  }
  
  public var unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(MultipleTrailingClosureElementSyntax.self)
    }
  }
  
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(MultipleTrailingClosureElementSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndClosure: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(MultipleTrailingClosureElementSyntax.self)
    }
  }
  
  public var closure: ClosureExprSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(ClosureExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(MultipleTrailingClosureElementSyntax.self)
    }
  }
  
  public var unexpectedAfterClosure: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(MultipleTrailingClosureElementSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLabel, 
          \Self.label, 
          \Self.unexpectedBetweenLabelAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndClosure, 
          \Self.closure, 
          \Self.unexpectedAfterClosure
        ])
  }
}

// MARK: - NamedOpaqueReturnTypeSyntax

/// ### Children
/// 
///  - `genericParameterClause`: ``GenericParameterClauseSyntax``
///  - `type`: ``TypeSyntax``
public struct NamedOpaqueReturnTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .namedOpaqueReturnType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - genericParameterClause: The parameter clause that defines the generic parameters.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeGenericParameterClause: UnexpectedNodesSyntax? = nil,
      genericParameterClause: GenericParameterClauseSyntax,
      _ unexpectedBetweenGenericParameterClauseAndType: UnexpectedNodesSyntax? = nil,
      type: some TypeSyntaxProtocol,
      _ unexpectedAfterType: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeGenericParameterClause, 
            genericParameterClause, 
            unexpectedBetweenGenericParameterClauseAndType, 
            type, 
            unexpectedAfterType
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeGenericParameterClause?.raw, 
          genericParameterClause.raw, 
          unexpectedBetweenGenericParameterClauseAndType?.raw, 
          type.raw, 
          unexpectedAfterType?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.namedOpaqueReturnType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeGenericParameterClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(NamedOpaqueReturnTypeSyntax.self)
    }
  }
  
  /// The parameter clause that defines the generic parameters.
  public var genericParameterClause: GenericParameterClauseSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(GenericParameterClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(NamedOpaqueReturnTypeSyntax.self)
    }
  }
  
  public var unexpectedBetweenGenericParameterClauseAndType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(NamedOpaqueReturnTypeSyntax.self)
    }
  }
  
  public var type: TypeSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(NamedOpaqueReturnTypeSyntax.self)
    }
  }
  
  public var unexpectedAfterType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(NamedOpaqueReturnTypeSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeGenericParameterClause, 
          \Self.genericParameterClause, 
          \Self.unexpectedBetweenGenericParameterClauseAndType, 
          \Self.type, 
          \Self.unexpectedAfterType
        ])
  }
}

// MARK: - NilLiteralExprSyntax

/// ### Children
/// 
///  - `nilKeyword`: `'nil'`
public struct NilLiteralExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .nilLiteralExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeNilKeyword: UnexpectedNodesSyntax? = nil,
      nilKeyword: TokenSyntax = .keyword(.nil),
      _ unexpectedAfterNilKeyword: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (unexpectedBeforeNilKeyword, nilKeyword, unexpectedAfterNilKeyword))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeNilKeyword?.raw, nilKeyword.raw, unexpectedAfterNilKeyword?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.nilLiteralExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeNilKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(NilLiteralExprSyntax.self)
    }
  }
  
  public var nilKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(NilLiteralExprSyntax.self)
    }
  }
  
  public var unexpectedAfterNilKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(NilLiteralExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([\Self.unexpectedBeforeNilKeyword, \Self.nilKeyword, \Self.unexpectedAfterNilKeyword])
  }
}
