//// Automatically generated by generate-swift-syntax
//// Do not edit directly!
//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

// MARK: - CanImportExprSyntax

/// ### Children
/// 
///  - `canImportKeyword`: `'canImport'`
///  - `leftParen`: `'('`
///  - `importPath`: `<identifier>`
///  - `versionInfo`: ``CanImportVersionInfoSyntax``?
///  - `rightParen`: `')'`
public struct CanImportExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .canImportExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeCanImportKeyword: UnexpectedNodesSyntax? = nil,
      canImportKeyword: TokenSyntax = .keyword(.canImport),
      _ unexpectedBetweenCanImportKeywordAndLeftParen: UnexpectedNodesSyntax? = nil,
      leftParen: TokenSyntax = .leftParenToken(),
      _ unexpectedBetweenLeftParenAndImportPath: UnexpectedNodesSyntax? = nil,
      importPath: TokenSyntax,
      _ unexpectedBetweenImportPathAndVersionInfo: UnexpectedNodesSyntax? = nil,
      versionInfo: CanImportVersionInfoSyntax? = nil,
      _ unexpectedBetweenVersionInfoAndRightParen: UnexpectedNodesSyntax? = nil,
      rightParen: TokenSyntax = .rightParenToken(),
      _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeCanImportKeyword, 
            canImportKeyword, 
            unexpectedBetweenCanImportKeywordAndLeftParen, 
            leftParen, 
            unexpectedBetweenLeftParenAndImportPath, 
            importPath, 
            unexpectedBetweenImportPathAndVersionInfo, 
            versionInfo, 
            unexpectedBetweenVersionInfoAndRightParen, 
            rightParen, 
            unexpectedAfterRightParen
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeCanImportKeyword?.raw, 
          canImportKeyword.raw, 
          unexpectedBetweenCanImportKeywordAndLeftParen?.raw, 
          leftParen.raw, 
          unexpectedBetweenLeftParenAndImportPath?.raw, 
          importPath.raw, 
          unexpectedBetweenImportPathAndVersionInfo?.raw, 
          versionInfo?.raw, 
          unexpectedBetweenVersionInfoAndRightParen?.raw, 
          rightParen.raw, 
          unexpectedAfterRightParen?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.canImportExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeCanImportKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(CanImportExprSyntax.self)
    }
  }
  
  public var canImportKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(CanImportExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenCanImportKeywordAndLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(CanImportExprSyntax.self)
    }
  }
  
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(CanImportExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftParenAndImportPath: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(CanImportExprSyntax.self)
    }
  }
  
  public var importPath: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(CanImportExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenImportPathAndVersionInfo: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(CanImportExprSyntax.self)
    }
  }
  
  public var versionInfo: CanImportVersionInfoSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(CanImportVersionInfoSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(CanImportExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenVersionInfoAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(CanImportExprSyntax.self)
    }
  }
  
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 9)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(CanImportExprSyntax.self)
    }
  }
  
  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(CanImportExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeCanImportKeyword, 
          \Self.canImportKeyword, 
          \Self.unexpectedBetweenCanImportKeywordAndLeftParen, 
          \Self.leftParen, 
          \Self.unexpectedBetweenLeftParenAndImportPath, 
          \Self.importPath, 
          \Self.unexpectedBetweenImportPathAndVersionInfo, 
          \Self.versionInfo, 
          \Self.unexpectedBetweenVersionInfoAndRightParen, 
          \Self.rightParen, 
          \Self.unexpectedAfterRightParen
        ])
  }
}

// MARK: - CanImportVersionInfoSyntax

/// ### Children
/// 
///  - `comma`: `','`
///  - `label`: (`'_version'` | `'_underlyingVersion'`)
///  - `colon`: `':'`
///  - `version`: ``VersionTupleSyntax``
///
/// ### Contained in
/// 
///  - ``CanImportExprSyntax``.``CanImportExprSyntax/versionInfo``
public struct CanImportVersionInfoSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .canImportVersionInfo else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeComma: UnexpectedNodesSyntax? = nil,
      comma: TokenSyntax = .commaToken(),
      _ unexpectedBetweenCommaAndLabel: UnexpectedNodesSyntax? = nil,
      label: TokenSyntax,
      _ unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax = .colonToken(),
      _ unexpectedBetweenColonAndVersion: UnexpectedNodesSyntax? = nil,
      version: VersionTupleSyntax,
      _ unexpectedAfterVersion: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeComma, 
            comma, 
            unexpectedBetweenCommaAndLabel, 
            label, 
            unexpectedBetweenLabelAndColon, 
            colon, 
            unexpectedBetweenColonAndVersion, 
            version, 
            unexpectedAfterVersion
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeComma?.raw, 
          comma.raw, 
          unexpectedBetweenCommaAndLabel?.raw, 
          label.raw, 
          unexpectedBetweenLabelAndColon?.raw, 
          colon.raw, 
          unexpectedBetweenColonAndVersion?.raw, 
          version.raw, 
          unexpectedAfterVersion?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.canImportVersionInfo,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(CanImportVersionInfoSyntax.self)
    }
  }
  
  public var comma: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(CanImportVersionInfoSyntax.self)
    }
  }
  
  public var unexpectedBetweenCommaAndLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(CanImportVersionInfoSyntax.self)
    }
  }
  
  public var label: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(CanImportVersionInfoSyntax.self)
    }
  }
  
  public var unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(CanImportVersionInfoSyntax.self)
    }
  }
  
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(CanImportVersionInfoSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndVersion: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(CanImportVersionInfoSyntax.self)
    }
  }
  
  public var version: VersionTupleSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(VersionTupleSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(CanImportVersionInfoSyntax.self)
    }
  }
  
  public var unexpectedAfterVersion: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(CanImportVersionInfoSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeComma, 
          \Self.comma, 
          \Self.unexpectedBetweenCommaAndLabel, 
          \Self.label, 
          \Self.unexpectedBetweenLabelAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndVersion, 
          \Self.version, 
          \Self.unexpectedAfterVersion
        ])
  }
}

// MARK: - CatchClauseSyntax

/// ### Children
/// 
///  - `catchKeyword`: `'catch'`
///  - `catchItems`: ``CatchItemListSyntax``
///  - `body`: ``CodeBlockSyntax``
///
/// ### Contained in
/// 
///  - ``CatchClauseListSyntax``
public struct CatchClauseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .catchClause else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeCatchKeyword: UnexpectedNodesSyntax? = nil,
      catchKeyword: TokenSyntax = .keyword(.catch),
      _ unexpectedBetweenCatchKeywordAndCatchItems: UnexpectedNodesSyntax? = nil,
      catchItems: CatchItemListSyntax = [],
      _ unexpectedBetweenCatchItemsAndBody: UnexpectedNodesSyntax? = nil,
      body: CodeBlockSyntax,
      _ unexpectedAfterBody: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeCatchKeyword, 
            catchKeyword, 
            unexpectedBetweenCatchKeywordAndCatchItems, 
            catchItems, 
            unexpectedBetweenCatchItemsAndBody, 
            body, 
            unexpectedAfterBody
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeCatchKeyword?.raw, 
          catchKeyword.raw, 
          unexpectedBetweenCatchKeywordAndCatchItems?.raw, 
          catchItems.raw, 
          unexpectedBetweenCatchItemsAndBody?.raw, 
          body.raw, 
          unexpectedAfterBody?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.catchClause,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeCatchKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(CatchClauseSyntax.self)
    }
  }
  
  public var catchKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(CatchClauseSyntax.self)
    }
  }
  
  public var unexpectedBetweenCatchKeywordAndCatchItems: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(CatchClauseSyntax.self)
    }
  }
  
  public var catchItems: CatchItemListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(CatchItemListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(CatchClauseSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `catchItems`
  /// collection.
  ///
  /// - param element: The new `CatchItem` to add to the node's
  ///                  `catchItems` collection.
  /// - returns: A copy of the receiver with the provided `CatchItem`
  ///            appended to its `catchItems` collection.
  @available(*, deprecated, message: "Use node.catchItems.append(newElement) instead")
  public func addCatchItem(_ element: CatchItemSyntax) -> CatchClauseSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.catchItemList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(CatchClauseSyntax.self)
  }
  
  public var unexpectedBetweenCatchItemsAndBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(CatchClauseSyntax.self)
    }
  }
  
  public var body: CodeBlockSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(CodeBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(CatchClauseSyntax.self)
    }
  }
  
  public var unexpectedAfterBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(CatchClauseSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeCatchKeyword, 
          \Self.catchKeyword, 
          \Self.unexpectedBetweenCatchKeywordAndCatchItems, 
          \Self.catchItems, 
          \Self.unexpectedBetweenCatchItemsAndBody, 
          \Self.body, 
          \Self.unexpectedAfterBody
        ])
  }
}

// MARK: - CatchItemSyntax

/// ### Children
/// 
///  - `pattern`: ``PatternSyntax``?
///  - `whereClause`: ``WhereClauseSyntax``?
///  - `trailingComma`: `','`?
///
/// ### Contained in
/// 
///  - ``CatchItemListSyntax``
public struct CatchItemSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .catchItem else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforePattern: UnexpectedNodesSyntax? = nil,
      pattern: (some PatternSyntaxProtocol)? = PatternSyntax?.none,
      _ unexpectedBetweenPatternAndWhereClause: UnexpectedNodesSyntax? = nil,
      whereClause: WhereClauseSyntax? = nil,
      _ unexpectedBetweenWhereClauseAndTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingComma: TokenSyntax? = nil,
      _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforePattern, 
            pattern, 
            unexpectedBetweenPatternAndWhereClause, 
            whereClause, 
            unexpectedBetweenWhereClauseAndTrailingComma, 
            trailingComma, 
            unexpectedAfterTrailingComma
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforePattern?.raw, 
          pattern?.raw, 
          unexpectedBetweenPatternAndWhereClause?.raw, 
          whereClause?.raw, 
          unexpectedBetweenWhereClauseAndTrailingComma?.raw, 
          trailingComma?.raw, 
          unexpectedAfterTrailingComma?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.catchItem,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforePattern: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(CatchItemSyntax.self)
    }
  }
  
  public var pattern: PatternSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(PatternSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(CatchItemSyntax.self)
    }
  }
  
  public var unexpectedBetweenPatternAndWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(CatchItemSyntax.self)
    }
  }
  
  public var whereClause: WhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(WhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(CatchItemSyntax.self)
    }
  }
  
  public var unexpectedBetweenWhereClauseAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(CatchItemSyntax.self)
    }
  }
  
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(CatchItemSyntax.self)
    }
  }
  
  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(CatchItemSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforePattern, 
          \Self.pattern, 
          \Self.unexpectedBetweenPatternAndWhereClause, 
          \Self.whereClause, 
          \Self.unexpectedBetweenWhereClauseAndTrailingComma, 
          \Self.trailingComma, 
          \Self.unexpectedAfterTrailingComma
        ])
  }
}

// MARK: - ClassDeclSyntax

/// A `class` declaration
/// 
/// An example of a class declaration is
/// 
/// ```swift
/// class SomeClass {
///   let someMember: String
/// 
///   init(someMember: String) {
///     self.someMember = someMember
///   }
/// 
///   func foo() {
///     print(someMember)
///   }
/// 
///   static func bar() -> Int {
///     return 1
///   }
/// }
/// ```
/// 
/// A class declaration may be declared without any members.
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `classKeyword`: `'class'`
///  - `name`: `<identifier>`
///  - `genericParameterClause`: ``GenericParameterClauseSyntax``?
///  - `inheritanceClause`: ``InheritanceClauseSyntax``?
///  - `genericWhereClause`: ``GenericWhereClauseSyntax``?
///  - `memberBlock`: ``MemberBlockSyntax``
public struct ClassDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .classDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attributes: Attributes attached to the class declaration, such as an `@available` attribute.
  ///   - modifiers: Modifiers attached to the class declaration, such as `public`.
  ///   - classKeyword: The `class` keyword for this declaration.
  ///   - name: The name of the class.
  ///   - genericParameterClause: The generic parameters, if any, of the class declaration.
  ///   - inheritanceClause: The inheritance clause describing one or more conformances for this class declaration.
  ///   - genericWhereClause: The `where` clause that applies to the generic parameters of this class declaration.
  ///   - memberBlock: The members of the class declaration. As class extension declarations may declare additional members, the contents of this member block isn't guaranteed to be a complete list of members for this type.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
      attributes: AttributeListSyntax = [],
      _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
      modifiers: DeclModifierListSyntax = [],
      _ unexpectedBetweenModifiersAndClassKeyword: UnexpectedNodesSyntax? = nil,
      classKeyword: TokenSyntax = .keyword(.class),
      _ unexpectedBetweenClassKeywordAndName: UnexpectedNodesSyntax? = nil,
      name: TokenSyntax,
      _ unexpectedBetweenNameAndGenericParameterClause: UnexpectedNodesSyntax? = nil,
      genericParameterClause: GenericParameterClauseSyntax? = nil,
      _ unexpectedBetweenGenericParameterClauseAndInheritanceClause: UnexpectedNodesSyntax? = nil,
      inheritanceClause: InheritanceClauseSyntax? = nil,
      _ unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
      genericWhereClause: GenericWhereClauseSyntax? = nil,
      _ unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? = nil,
      memberBlock: MemberBlockSyntax,
      _ unexpectedAfterMemberBlock: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAttributes, 
            attributes, 
            unexpectedBetweenAttributesAndModifiers, 
            modifiers, 
            unexpectedBetweenModifiersAndClassKeyword, 
            classKeyword, 
            unexpectedBetweenClassKeywordAndName, 
            name, 
            unexpectedBetweenNameAndGenericParameterClause, 
            genericParameterClause, 
            unexpectedBetweenGenericParameterClauseAndInheritanceClause, 
            inheritanceClause, 
            unexpectedBetweenInheritanceClauseAndGenericWhereClause, 
            genericWhereClause, 
            unexpectedBetweenGenericWhereClauseAndMemberBlock, 
            memberBlock, 
            unexpectedAfterMemberBlock
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAttributes?.raw, 
          attributes.raw, 
          unexpectedBetweenAttributesAndModifiers?.raw, 
          modifiers.raw, 
          unexpectedBetweenModifiersAndClassKeyword?.raw, 
          classKeyword.raw, 
          unexpectedBetweenClassKeywordAndName?.raw, 
          name.raw, 
          unexpectedBetweenNameAndGenericParameterClause?.raw, 
          genericParameterClause?.raw, 
          unexpectedBetweenGenericParameterClauseAndInheritanceClause?.raw, 
          inheritanceClause?.raw, 
          unexpectedBetweenInheritanceClauseAndGenericWhereClause?.raw, 
          genericWhereClause?.raw, 
          unexpectedBetweenGenericWhereClauseAndMemberBlock?.raw, 
          memberBlock.raw, 
          unexpectedAfterMemberBlock?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.classDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  /// Attributes attached to the class declaration, such as an `@available` attribute.
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> ClassDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(ClassDeclSyntax.self)
  }
  
  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  /// Modifiers attached to the class declaration, such as `public`.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> ClassDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(ClassDeclSyntax.self)
  }
  
  public var unexpectedBetweenModifiersAndClassKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  /// The `class` keyword for this declaration.
  public var classKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenClassKeywordAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  /// The name of the class.
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenNameAndGenericParameterClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  /// The generic parameters, if any, of the class declaration.
  public var genericParameterClause: GenericParameterClauseSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(GenericParameterClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenGenericParameterClauseAndInheritanceClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  /// The inheritance clause describing one or more conformances for this class declaration.
  public var inheritanceClause: InheritanceClauseSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(InheritanceClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  /// The `where` clause that applies to the generic parameters of this class declaration.
  public var genericWhereClause: GenericWhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(GenericWhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  /// The members of the class declaration. As class extension declarations may declare additional members, the contents of this member block isn't guaranteed to be a complete list of members for this type.
  public var memberBlock: MemberBlockSyntax {
    get {
      return Syntax(self).child(at: 15)!.cast(MemberBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 15, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  public var unexpectedAfterMemberBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 16)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 16, with: Syntax(value), arena: SyntaxArena()).cast(ClassDeclSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAttributes, 
          \Self.attributes, 
          \Self.unexpectedBetweenAttributesAndModifiers, 
          \Self.modifiers, 
          \Self.unexpectedBetweenModifiersAndClassKeyword, 
          \Self.classKeyword, 
          \Self.unexpectedBetweenClassKeywordAndName, 
          \Self.name, 
          \Self.unexpectedBetweenNameAndGenericParameterClause, 
          \Self.genericParameterClause, 
          \Self.unexpectedBetweenGenericParameterClauseAndInheritanceClause, 
          \Self.inheritanceClause, 
          \Self.unexpectedBetweenInheritanceClauseAndGenericWhereClause, 
          \Self.genericWhereClause, 
          \Self.unexpectedBetweenGenericWhereClauseAndMemberBlock, 
          \Self.memberBlock, 
          \Self.unexpectedAfterMemberBlock
        ])
  }
}

// MARK: - ClassRestrictionTypeSyntax

/// ### Children
/// 
///  - `classKeyword`: `'class'`
public struct ClassRestrictionTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .classRestrictionType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeClassKeyword: UnexpectedNodesSyntax? = nil,
      classKeyword: TokenSyntax = .keyword(.class),
      _ unexpectedAfterClassKeyword: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (unexpectedBeforeClassKeyword, classKeyword, unexpectedAfterClassKeyword))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeClassKeyword?.raw, classKeyword.raw, unexpectedAfterClassKeyword?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.classRestrictionType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeClassKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ClassRestrictionTypeSyntax.self)
    }
  }
  
  public var classKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ClassRestrictionTypeSyntax.self)
    }
  }
  
  public var unexpectedAfterClassKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ClassRestrictionTypeSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([\Self.unexpectedBeforeClassKeyword, \Self.classKeyword, \Self.unexpectedAfterClassKeyword])
  }
}

// MARK: - ClosureCaptureClauseSyntax

/// ### Children
/// 
///  - `leftSquare`: `'['`
///  - `items`: ``ClosureCaptureListSyntax``
///  - `rightSquare`: `']'`
///
/// ### Contained in
/// 
///  - ``ClosureSignatureSyntax``.``ClosureSignatureSyntax/capture``
public struct ClosureCaptureClauseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .closureCaptureClause else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? = nil,
      leftSquare: TokenSyntax = .leftSquareToken(),
      _ unexpectedBetweenLeftSquareAndItems: UnexpectedNodesSyntax? = nil,
      items: ClosureCaptureListSyntax,
      _ unexpectedBetweenItemsAndRightSquare: UnexpectedNodesSyntax? = nil,
      rightSquare: TokenSyntax = .rightSquareToken(),
      _ unexpectedAfterRightSquare: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLeftSquare, 
            leftSquare, 
            unexpectedBetweenLeftSquareAndItems, 
            items, 
            unexpectedBetweenItemsAndRightSquare, 
            rightSquare, 
            unexpectedAfterRightSquare
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLeftSquare?.raw, 
          leftSquare.raw, 
          unexpectedBetweenLeftSquareAndItems?.raw, 
          items.raw, 
          unexpectedBetweenItemsAndRightSquare?.raw, 
          rightSquare.raw, 
          unexpectedAfterRightSquare?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.closureCaptureClause,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureClauseSyntax.self)
    }
  }
  
  public var leftSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureClauseSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftSquareAndItems: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureClauseSyntax.self)
    }
  }
  
  public var items: ClosureCaptureListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ClosureCaptureListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureClauseSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `items`
  /// collection.
  ///
  /// - param element: The new `Item` to add to the node's
  ///                  `items` collection.
  /// - returns: A copy of the receiver with the provided `Item`
  ///            appended to its `items` collection.
  @available(*, deprecated, message: "Use node.items.append(newElement) instead")
  public func addItem(_ element: ClosureCaptureSyntax) -> ClosureCaptureClauseSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.closureCaptureList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(ClosureCaptureClauseSyntax.self)
  }
  
  public var unexpectedBetweenItemsAndRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureClauseSyntax.self)
    }
  }
  
  public var rightSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureClauseSyntax.self)
    }
  }
  
  public var unexpectedAfterRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureClauseSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLeftSquare, 
          \Self.leftSquare, 
          \Self.unexpectedBetweenLeftSquareAndItems, 
          \Self.items, 
          \Self.unexpectedBetweenItemsAndRightSquare, 
          \Self.rightSquare, 
          \Self.unexpectedAfterRightSquare
        ])
  }
}

// MARK: - ClosureCaptureSpecifierSyntax

/// ### Children
/// 
///  - `specifier`: (`'weak'` | `'unowned'`)
///  - `leftParen`: `'('`?
///  - `detail`: (`'safe'` | `'unsafe'`)?
///  - `rightParen`: `')'`?
///
/// ### Contained in
/// 
///  - ``ClosureCaptureSyntax``.``ClosureCaptureSyntax/specifier``
public struct ClosureCaptureSpecifierSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .closureCaptureSpecifier else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeSpecifier: UnexpectedNodesSyntax? = nil,
      specifier: TokenSyntax,
      _ unexpectedBetweenSpecifierAndLeftParen: UnexpectedNodesSyntax? = nil,
      leftParen: TokenSyntax? = nil,
      _ unexpectedBetweenLeftParenAndDetail: UnexpectedNodesSyntax? = nil,
      detail: TokenSyntax? = nil,
      _ unexpectedBetweenDetailAndRightParen: UnexpectedNodesSyntax? = nil,
      rightParen: TokenSyntax? = nil,
      _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeSpecifier, 
            specifier, 
            unexpectedBetweenSpecifierAndLeftParen, 
            leftParen, 
            unexpectedBetweenLeftParenAndDetail, 
            detail, 
            unexpectedBetweenDetailAndRightParen, 
            rightParen, 
            unexpectedAfterRightParen
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeSpecifier?.raw, 
          specifier.raw, 
          unexpectedBetweenSpecifierAndLeftParen?.raw, 
          leftParen?.raw, 
          unexpectedBetweenLeftParenAndDetail?.raw, 
          detail?.raw, 
          unexpectedBetweenDetailAndRightParen?.raw, 
          rightParen?.raw, 
          unexpectedAfterRightParen?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.closureCaptureSpecifier,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSpecifierSyntax.self)
    }
  }
  
  public var specifier: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSpecifierSyntax.self)
    }
  }
  
  public var unexpectedBetweenSpecifierAndLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSpecifierSyntax.self)
    }
  }
  
  public var leftParen: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSpecifierSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftParenAndDetail: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSpecifierSyntax.self)
    }
  }
  
  public var detail: TokenSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSpecifierSyntax.self)
    }
  }
  
  public var unexpectedBetweenDetailAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSpecifierSyntax.self)
    }
  }
  
  public var rightParen: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSpecifierSyntax.self)
    }
  }
  
  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSpecifierSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeSpecifier, 
          \Self.specifier, 
          \Self.unexpectedBetweenSpecifierAndLeftParen, 
          \Self.leftParen, 
          \Self.unexpectedBetweenLeftParenAndDetail, 
          \Self.detail, 
          \Self.unexpectedBetweenDetailAndRightParen, 
          \Self.rightParen, 
          \Self.unexpectedAfterRightParen
        ])
  }
}

// MARK: - ClosureCaptureSyntax

/// ### Children
/// 
///  - `specifier`: ``ClosureCaptureSpecifierSyntax``?
///  - `name`: `<identifier>`?
///  - `equal`: `'='`?
///  - `expression`: ``ExprSyntax``
///  - `trailingComma`: `','`?
///
/// ### Contained in
/// 
///  - ``ClosureCaptureListSyntax``
public struct ClosureCaptureSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .closureCapture else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeSpecifier: UnexpectedNodesSyntax? = nil,
      specifier: ClosureCaptureSpecifierSyntax? = nil,
      _ unexpectedBetweenSpecifierAndName: UnexpectedNodesSyntax? = nil,
      name: TokenSyntax? = nil,
      _ unexpectedBetweenNameAndEqual: UnexpectedNodesSyntax? = nil,
      equal: TokenSyntax? = nil,
      _ unexpectedBetweenEqualAndExpression: UnexpectedNodesSyntax? = nil,
      expression: some ExprSyntaxProtocol,
      _ unexpectedBetweenExpressionAndTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingComma: TokenSyntax? = nil,
      _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeSpecifier, 
            specifier, 
            unexpectedBetweenSpecifierAndName, 
            name, 
            unexpectedBetweenNameAndEqual, 
            equal, 
            unexpectedBetweenEqualAndExpression, 
            expression, 
            unexpectedBetweenExpressionAndTrailingComma, 
            trailingComma, 
            unexpectedAfterTrailingComma
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeSpecifier?.raw, 
          specifier?.raw, 
          unexpectedBetweenSpecifierAndName?.raw, 
          name?.raw, 
          unexpectedBetweenNameAndEqual?.raw, 
          equal?.raw, 
          unexpectedBetweenEqualAndExpression?.raw, 
          expression.raw, 
          unexpectedBetweenExpressionAndTrailingComma?.raw, 
          trailingComma?.raw, 
          unexpectedAfterTrailingComma?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.closureCapture,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSyntax.self)
    }
  }
  
  public var specifier: ClosureCaptureSpecifierSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(ClosureCaptureSpecifierSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSyntax.self)
    }
  }
  
  public var unexpectedBetweenSpecifierAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSyntax.self)
    }
  }
  
  public var name: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSyntax.self)
    }
  }
  
  public var unexpectedBetweenNameAndEqual: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSyntax.self)
    }
  }
  
  public var equal: TokenSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSyntax.self)
    }
  }
  
  public var unexpectedBetweenEqualAndExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSyntax.self)
    }
  }
  
  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSyntax.self)
    }
  }
  
  public var unexpectedBetweenExpressionAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSyntax.self)
    }
  }
  
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSyntax.self)
    }
  }
  
  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(ClosureCaptureSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeSpecifier, 
          \Self.specifier, 
          \Self.unexpectedBetweenSpecifierAndName, 
          \Self.name, 
          \Self.unexpectedBetweenNameAndEqual, 
          \Self.equal, 
          \Self.unexpectedBetweenEqualAndExpression, 
          \Self.expression, 
          \Self.unexpectedBetweenExpressionAndTrailingComma, 
          \Self.trailingComma, 
          \Self.unexpectedAfterTrailingComma
        ])
  }
}

// MARK: - ClosureExprSyntax

/// ### Children
/// 
///  - `leftBrace`: `'{'`
///  - `signature`: ``ClosureSignatureSyntax``?
///  - `statements`: ``CodeBlockItemListSyntax``
///  - `rightBrace`: `'}'`
///
/// ### Contained in
/// 
///  - ``FunctionCallExprSyntax``.``FunctionCallExprSyntax/trailingClosure``
///  - ``MacroExpansionDeclSyntax``.``MacroExpansionDeclSyntax/trailingClosure``
///  - ``MacroExpansionExprSyntax``.``MacroExpansionExprSyntax/trailingClosure``
///  - ``MultipleTrailingClosureElementSyntax``.``MultipleTrailingClosureElementSyntax/closure``
///  - ``SubscriptCallExprSyntax``.``SubscriptCallExprSyntax/trailingClosure``
public struct ClosureExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .closureExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLeftBrace: UnexpectedNodesSyntax? = nil,
      leftBrace: TokenSyntax = .leftBraceToken(),
      _ unexpectedBetweenLeftBraceAndSignature: UnexpectedNodesSyntax? = nil,
      signature: ClosureSignatureSyntax? = nil,
      _ unexpectedBetweenSignatureAndStatements: UnexpectedNodesSyntax? = nil,
      statements: CodeBlockItemListSyntax,
      _ unexpectedBetweenStatementsAndRightBrace: UnexpectedNodesSyntax? = nil,
      rightBrace: TokenSyntax = .rightBraceToken(),
      _ unexpectedAfterRightBrace: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLeftBrace, 
            leftBrace, 
            unexpectedBetweenLeftBraceAndSignature, 
            signature, 
            unexpectedBetweenSignatureAndStatements, 
            statements, 
            unexpectedBetweenStatementsAndRightBrace, 
            rightBrace, 
            unexpectedAfterRightBrace
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLeftBrace?.raw, 
          leftBrace.raw, 
          unexpectedBetweenLeftBraceAndSignature?.raw, 
          signature?.raw, 
          unexpectedBetweenSignatureAndStatements?.raw, 
          statements.raw, 
          unexpectedBetweenStatementsAndRightBrace?.raw, 
          rightBrace.raw, 
          unexpectedAfterRightBrace?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.closureExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLeftBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ClosureExprSyntax.self)
    }
  }
  
  public var leftBrace: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ClosureExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftBraceAndSignature: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ClosureExprSyntax.self)
    }
  }
  
  public var signature: ClosureSignatureSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(ClosureSignatureSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ClosureExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenSignatureAndStatements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ClosureExprSyntax.self)
    }
  }
  
  public var statements: CodeBlockItemListSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(CodeBlockItemListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(ClosureExprSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `statements`
  /// collection.
  ///
  /// - param element: The new `Statement` to add to the node's
  ///                  `statements` collection.
  /// - returns: A copy of the receiver with the provided `Statement`
  ///            appended to its `statements` collection.
  @available(*, deprecated, message: "Use node.statements.append(newElement) instead")
  public func addStatement(_ element: CodeBlockItemSyntax) -> ClosureExprSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[5] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.codeBlockItemList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 5, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(ClosureExprSyntax.self)
  }
  
  public var unexpectedBetweenStatementsAndRightBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(ClosureExprSyntax.self)
    }
  }
  
  public var rightBrace: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(ClosureExprSyntax.self)
    }
  }
  
  public var unexpectedAfterRightBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(ClosureExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLeftBrace, 
          \Self.leftBrace, 
          \Self.unexpectedBetweenLeftBraceAndSignature, 
          \Self.signature, 
          \Self.unexpectedBetweenSignatureAndStatements, 
          \Self.statements, 
          \Self.unexpectedBetweenStatementsAndRightBrace, 
          \Self.rightBrace, 
          \Self.unexpectedAfterRightBrace
        ])
  }
}

// MARK: - ClosureParameterClauseSyntax

/// ### Children
/// 
///  - `leftParen`: `'('`
///  - `parameters`: ``ClosureParameterListSyntax``
///  - `rightParen`: `')'`
///
/// ### Contained in
/// 
///  - ``ClosureSignatureSyntax``.``ClosureSignatureSyntax/parameterClause``
public struct ClosureParameterClauseSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .closureParameterClause else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - leftParen: The '(' to open the parameter clause.
  ///   - parameters: The actual parameters.
  ///   - rightParen: The ')' to close the parameter clause.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLeftParen: UnexpectedNodesSyntax? = nil,
      leftParen: TokenSyntax = .leftParenToken(),
      _ unexpectedBetweenLeftParenAndParameters: UnexpectedNodesSyntax? = nil,
      parameters: ClosureParameterListSyntax,
      _ unexpectedBetweenParametersAndRightParen: UnexpectedNodesSyntax? = nil,
      rightParen: TokenSyntax = .rightParenToken(),
      _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLeftParen, 
            leftParen, 
            unexpectedBetweenLeftParenAndParameters, 
            parameters, 
            unexpectedBetweenParametersAndRightParen, 
            rightParen, 
            unexpectedAfterRightParen
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLeftParen?.raw, 
          leftParen.raw, 
          unexpectedBetweenLeftParenAndParameters?.raw, 
          parameters.raw, 
          unexpectedBetweenParametersAndRightParen?.raw, 
          rightParen.raw, 
          unexpectedAfterRightParen?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.closureParameterClause,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterClauseSyntax.self)
    }
  }
  
  /// The '(' to open the parameter clause.
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterClauseSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftParenAndParameters: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterClauseSyntax.self)
    }
  }
  
  /// The actual parameters.
  public var parameters: ClosureParameterListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ClosureParameterListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterClauseSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `parameters`
  /// collection.
  ///
  /// - param element: The new `Parameter` to add to the node's
  ///                  `parameters` collection.
  /// - returns: A copy of the receiver with the provided `Parameter`
  ///            appended to its `parameters` collection.
  @available(*, deprecated, message: "Use node.parameters.append(newElement) instead")
  public func addParameter(_ element: ClosureParameterSyntax) -> ClosureParameterClauseSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.closureParameterList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(ClosureParameterClauseSyntax.self)
  }
  
  public var unexpectedBetweenParametersAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterClauseSyntax.self)
    }
  }
  
  /// The ')' to close the parameter clause.
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterClauseSyntax.self)
    }
  }
  
  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterClauseSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLeftParen, 
          \Self.leftParen, 
          \Self.unexpectedBetweenLeftParenAndParameters, 
          \Self.parameters, 
          \Self.unexpectedBetweenParametersAndRightParen, 
          \Self.rightParen, 
          \Self.unexpectedAfterRightParen
        ])
  }
}

// MARK: - ClosureParameterSyntax

/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `firstName`: (`<identifier>` | `'_'`)
///  - `secondName`: (`<identifier>` | `'_'`)?
///  - `colon`: `':'`?
///  - `type`: ``TypeSyntax``?
///  - `ellipsis`: `'...'`?
///  - `trailingComma`: `','`?
///
/// ### Contained in
/// 
///  - ``ClosureParameterListSyntax``
public struct ClosureParameterSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .closureParameter else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - firstName: The label of this parameter that will be used when the closure is called.
  ///   - secondName: If this is specified, it is the name by which the parameter can be referenced inside the closure body. If it is `nil`, the closure parameter is referenced by the first name.
  ///   - colon: The colon separating the parameter's name and type.
  ///   - type: The type of the parameter.
  ///   - ellipsis: If the parameter is variadic, `...` to indicate that.
  ///   - trailingComma: If the parameter is followed by another parameter, the comma separating them.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
      attributes: AttributeListSyntax = [],
      _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
      modifiers: DeclModifierListSyntax = [],
      _ unexpectedBetweenModifiersAndFirstName: UnexpectedNodesSyntax? = nil,
      firstName: TokenSyntax,
      _ unexpectedBetweenFirstNameAndSecondName: UnexpectedNodesSyntax? = nil,
      secondName: TokenSyntax? = nil,
      _ unexpectedBetweenSecondNameAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax? = nil,
      _ unexpectedBetweenColonAndType: UnexpectedNodesSyntax? = nil,
      type: (some TypeSyntaxProtocol)? = TypeSyntax?.none,
      _ unexpectedBetweenTypeAndEllipsis: UnexpectedNodesSyntax? = nil,
      ellipsis: TokenSyntax? = nil,
      _ unexpectedBetweenEllipsisAndTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingComma: TokenSyntax? = nil,
      _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAttributes, 
            attributes, 
            unexpectedBetweenAttributesAndModifiers, 
            modifiers, 
            unexpectedBetweenModifiersAndFirstName, 
            firstName, 
            unexpectedBetweenFirstNameAndSecondName, 
            secondName, 
            unexpectedBetweenSecondNameAndColon, 
            colon, 
            unexpectedBetweenColonAndType, 
            type, 
            unexpectedBetweenTypeAndEllipsis, 
            ellipsis, 
            unexpectedBetweenEllipsisAndTrailingComma, 
            trailingComma, 
            unexpectedAfterTrailingComma
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAttributes?.raw, 
          attributes.raw, 
          unexpectedBetweenAttributesAndModifiers?.raw, 
          modifiers.raw, 
          unexpectedBetweenModifiersAndFirstName?.raw, 
          firstName.raw, 
          unexpectedBetweenFirstNameAndSecondName?.raw, 
          secondName?.raw, 
          unexpectedBetweenSecondNameAndColon?.raw, 
          colon?.raw, 
          unexpectedBetweenColonAndType?.raw, 
          type?.raw, 
          unexpectedBetweenTypeAndEllipsis?.raw, 
          ellipsis?.raw, 
          unexpectedBetweenEllipsisAndTrailingComma?.raw, 
          trailingComma?.raw, 
          unexpectedAfterTrailingComma?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.closureParameter,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> ClosureParameterSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(ClosureParameterSyntax.self)
  }
  
  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> ClosureParameterSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(ClosureParameterSyntax.self)
  }
  
  public var unexpectedBetweenModifiersAndFirstName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  /// The label of this parameter that will be used when the closure is called.
  public var firstName: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  public var unexpectedBetweenFirstNameAndSecondName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  /// If this is specified, it is the name by which the parameter can be referenced inside the closure body. If it is `nil`, the closure parameter is referenced by the first name.
  public var secondName: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  public var unexpectedBetweenSecondNameAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  /// The colon separating the parameter's name and type.
  public var colon: TokenSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  /// The type of the parameter.
  public var type: TypeSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  public var unexpectedBetweenTypeAndEllipsis: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  /// If the parameter is variadic, `...` to indicate that.
  public var ellipsis: TokenSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  public var unexpectedBetweenEllipsisAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  /// If the parameter is followed by another parameter, the comma separating them.
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 15)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 15, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 16)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 16, with: Syntax(value), arena: SyntaxArena()).cast(ClosureParameterSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAttributes, 
          \Self.attributes, 
          \Self.unexpectedBetweenAttributesAndModifiers, 
          \Self.modifiers, 
          \Self.unexpectedBetweenModifiersAndFirstName, 
          \Self.firstName, 
          \Self.unexpectedBetweenFirstNameAndSecondName, 
          \Self.secondName, 
          \Self.unexpectedBetweenSecondNameAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndType, 
          \Self.type, 
          \Self.unexpectedBetweenTypeAndEllipsis, 
          \Self.ellipsis, 
          \Self.unexpectedBetweenEllipsisAndTrailingComma, 
          \Self.trailingComma, 
          \Self.unexpectedAfterTrailingComma
        ])
  }
}

// MARK: - ClosureShorthandParameterSyntax

/// ### Children
/// 
///  - `name`: (`<identifier>` | `'_'`)
///  - `trailingComma`: `','`?
///
/// ### Contained in
/// 
///  - ``ClosureShorthandParameterListSyntax``
public struct ClosureShorthandParameterSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .closureShorthandParameter else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeName: UnexpectedNodesSyntax? = nil,
      name: TokenSyntax,
      _ unexpectedBetweenNameAndTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingComma: TokenSyntax? = nil,
      _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeName, 
            name, 
            unexpectedBetweenNameAndTrailingComma, 
            trailingComma, 
            unexpectedAfterTrailingComma
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeName?.raw, 
          name.raw, 
          unexpectedBetweenNameAndTrailingComma?.raw, 
          trailingComma?.raw, 
          unexpectedAfterTrailingComma?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.closureShorthandParameter,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ClosureShorthandParameterSyntax.self)
    }
  }
  
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ClosureShorthandParameterSyntax.self)
    }
  }
  
  public var unexpectedBetweenNameAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ClosureShorthandParameterSyntax.self)
    }
  }
  
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ClosureShorthandParameterSyntax.self)
    }
  }
  
  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ClosureShorthandParameterSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeName, 
          \Self.name, 
          \Self.unexpectedBetweenNameAndTrailingComma, 
          \Self.trailingComma, 
          \Self.unexpectedAfterTrailingComma
        ])
  }
}

// MARK: - ClosureSignatureSyntax

/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `capture`: ``ClosureCaptureClauseSyntax``?
///  - `parameterClause`: (``ClosureShorthandParameterListSyntax`` | ``ClosureParameterClauseSyntax``)?
///  - `effectSpecifiers`: ``TypeEffectSpecifiersSyntax``?
///  - `returnClause`: ``ReturnClauseSyntax``?
///  - `inKeyword`: `'in'`
///
/// ### Contained in
/// 
///  - ``ClosureExprSyntax``.``ClosureExprSyntax/signature``
public struct ClosureSignatureSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum ParameterClause: SyntaxChildChoices, SyntaxHashable {
    case `simpleInput`(ClosureShorthandParameterListSyntax)
    case `parameterClause`(ClosureParameterClauseSyntax)
    
    public var _syntaxNode: Syntax {
      switch self {
      case .simpleInput(let node):
        return node._syntaxNode
      case .parameterClause(let node):
        return node._syntaxNode
      }
    }
    
    public init(_ node: ClosureShorthandParameterListSyntax) {
      self = .simpleInput(node)
    }
    
    public init(_ node: ClosureParameterClauseSyntax) {
      self = .parameterClause(node)
    }
    
    public init?(_ node: some SyntaxProtocol) {
      if let node = node.as(ClosureShorthandParameterListSyntax.self) {
        self = .simpleInput(node)
        return
      }
      if let node = node.as(ClosureParameterClauseSyntax.self) {
        self = .parameterClause(node)
        return
      }
      return nil
    }
    
    public static var structure: SyntaxNodeStructure {
      return .choices([.node(ClosureShorthandParameterListSyntax.self), .node(ClosureParameterClauseSyntax.self)])
    }
  }
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .closureSignature else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
      attributes: AttributeListSyntax = [],
      _ unexpectedBetweenAttributesAndCapture: UnexpectedNodesSyntax? = nil,
      capture: ClosureCaptureClauseSyntax? = nil,
      _ unexpectedBetweenCaptureAndParameterClause: UnexpectedNodesSyntax? = nil,
      parameterClause: ParameterClause? = nil,
      _ unexpectedBetweenParameterClauseAndEffectSpecifiers: UnexpectedNodesSyntax? = nil,
      effectSpecifiers: TypeEffectSpecifiersSyntax? = nil,
      _ unexpectedBetweenEffectSpecifiersAndReturnClause: UnexpectedNodesSyntax? = nil,
      returnClause: ReturnClauseSyntax? = nil,
      _ unexpectedBetweenReturnClauseAndInKeyword: UnexpectedNodesSyntax? = nil,
      inKeyword: TokenSyntax = .keyword(.in),
      _ unexpectedAfterInKeyword: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAttributes, 
            attributes, 
            unexpectedBetweenAttributesAndCapture, 
            capture, 
            unexpectedBetweenCaptureAndParameterClause, 
            parameterClause, 
            unexpectedBetweenParameterClauseAndEffectSpecifiers, 
            effectSpecifiers, 
            unexpectedBetweenEffectSpecifiersAndReturnClause, 
            returnClause, 
            unexpectedBetweenReturnClauseAndInKeyword, 
            inKeyword, 
            unexpectedAfterInKeyword
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAttributes?.raw, 
          attributes.raw, 
          unexpectedBetweenAttributesAndCapture?.raw, 
          capture?.raw, 
          unexpectedBetweenCaptureAndParameterClause?.raw, 
          parameterClause?.raw, 
          unexpectedBetweenParameterClauseAndEffectSpecifiers?.raw, 
          effectSpecifiers?.raw, 
          unexpectedBetweenEffectSpecifiersAndReturnClause?.raw, 
          returnClause?.raw, 
          unexpectedBetweenReturnClauseAndInKeyword?.raw, 
          inKeyword.raw, 
          unexpectedAfterInKeyword?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.closureSignature,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ClosureSignatureSyntax.self)
    }
  }
  
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ClosureSignatureSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> ClosureSignatureSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(ClosureSignatureSyntax.self)
  }
  
  public var unexpectedBetweenAttributesAndCapture: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ClosureSignatureSyntax.self)
    }
  }
  
  public var capture: ClosureCaptureClauseSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(ClosureCaptureClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ClosureSignatureSyntax.self)
    }
  }
  
  public var unexpectedBetweenCaptureAndParameterClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ClosureSignatureSyntax.self)
    }
  }
  
  public var parameterClause: ParameterClause? {
    get {
      return Syntax(self).child(at: 5)?.cast(ParameterClause.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(ClosureSignatureSyntax.self)
    }
  }
  
  public var unexpectedBetweenParameterClauseAndEffectSpecifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(ClosureSignatureSyntax.self)
    }
  }
  
  public var effectSpecifiers: TypeEffectSpecifiersSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TypeEffectSpecifiersSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(ClosureSignatureSyntax.self)
    }
  }
  
  public var unexpectedBetweenEffectSpecifiersAndReturnClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(ClosureSignatureSyntax.self)
    }
  }
  
  public var returnClause: ReturnClauseSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(ReturnClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(ClosureSignatureSyntax.self)
    }
  }
  
  public var unexpectedBetweenReturnClauseAndInKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(ClosureSignatureSyntax.self)
    }
  }
  
  public var inKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 11)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), arena: SyntaxArena()).cast(ClosureSignatureSyntax.self)
    }
  }
  
  public var unexpectedAfterInKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), arena: SyntaxArena()).cast(ClosureSignatureSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAttributes, 
          \Self.attributes, 
          \Self.unexpectedBetweenAttributesAndCapture, 
          \Self.capture, 
          \Self.unexpectedBetweenCaptureAndParameterClause, 
          \Self.parameterClause, 
          \Self.unexpectedBetweenParameterClauseAndEffectSpecifiers, 
          \Self.effectSpecifiers, 
          \Self.unexpectedBetweenEffectSpecifiersAndReturnClause, 
          \Self.returnClause, 
          \Self.unexpectedBetweenReturnClauseAndInKeyword, 
          \Self.inKeyword, 
          \Self.unexpectedAfterInKeyword
        ])
  }
}

// MARK: - CodeBlockItemSyntax

/// A CodeBlockItem is any Syntax node that appears on its own line inside a CodeBlock.
///
/// ### Children
/// 
///  - `item`: (``DeclSyntax`` | ``StmtSyntax`` | ``ExprSyntax``)
///  - `semicolon`: `';'`?
///
/// ### Contained in
/// 
///  - ``CodeBlockItemListSyntax``
public struct CodeBlockItemSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Item: SyntaxChildChoices, SyntaxHashable {
    case `decl`(DeclSyntax)
    case `stmt`(StmtSyntax)
    case `expr`(ExprSyntax)
    
    public var _syntaxNode: Syntax {
      switch self {
      case .decl(let node):
        return node._syntaxNode
      case .stmt(let node):
        return node._syntaxNode
      case .expr(let node):
        return node._syntaxNode
      }
    }
    
    public init(_ node: some DeclSyntaxProtocol) {
      self = .decl(DeclSyntax(node))
    }
    
    public init(_ node: some StmtSyntaxProtocol) {
      self = .stmt(StmtSyntax(node))
    }
    
    public init(_ node: some ExprSyntaxProtocol) {
      self = .expr(ExprSyntax(node))
    }
    
    public init?(_ node: some SyntaxProtocol) {
      if let node = node.as(DeclSyntax.self) {
        self = .decl(node)
        return
      }
      if let node = node.as(StmtSyntax.self) {
        self = .stmt(node)
        return
      }
      if let node = node.as(ExprSyntax.self) {
        self = .expr(node)
        return
      }
      return nil
    }
    
    public static var structure: SyntaxNodeStructure {
      return .choices([.node(DeclSyntax.self), .node(StmtSyntax.self), .node(ExprSyntax.self)])
    }
  }
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .codeBlockItem else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - item: The underlying node inside the code block.
  ///   - semicolon: If present, the trailing semicolon at the end of the item.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeItem: UnexpectedNodesSyntax? = nil,
      item: Item,
      _ unexpectedBetweenItemAndSemicolon: UnexpectedNodesSyntax? = nil,
      semicolon: TokenSyntax? = nil,
      _ unexpectedAfterSemicolon: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeItem, 
            item, 
            unexpectedBetweenItemAndSemicolon, 
            semicolon, 
            unexpectedAfterSemicolon
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeItem?.raw, 
          item.raw, 
          unexpectedBetweenItemAndSemicolon?.raw, 
          semicolon?.raw, 
          unexpectedAfterSemicolon?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.codeBlockItem,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeItem: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(CodeBlockItemSyntax.self)
    }
  }
  
  /// The underlying node inside the code block.
  public var item: Item {
    get {
      return Syntax(self).child(at: 1)!.cast(Item.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(CodeBlockItemSyntax.self)
    }
  }
  
  public var unexpectedBetweenItemAndSemicolon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(CodeBlockItemSyntax.self)
    }
  }
  
  /// If present, the trailing semicolon at the end of the item.
  public var semicolon: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(CodeBlockItemSyntax.self)
    }
  }
  
  public var unexpectedAfterSemicolon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(CodeBlockItemSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeItem, 
          \Self.item, 
          \Self.unexpectedBetweenItemAndSemicolon, 
          \Self.semicolon, 
          \Self.unexpectedAfterSemicolon
        ])
  }
}

// MARK: - CodeBlockSyntax

/// ### Children
/// 
///  - `leftBrace`: `'{'`
///  - `statements`: ``CodeBlockItemListSyntax``
///  - `rightBrace`: `'}'`
///
/// ### Contained in
/// 
///  - ``AccessorDeclSyntax``.``AccessorDeclSyntax/body``
///  - ``CatchClauseSyntax``.``CatchClauseSyntax/body``
///  - ``DeferStmtSyntax``.``DeferStmtSyntax/body``
///  - ``DeinitializerDeclSyntax``.``DeinitializerDeclSyntax/body``
///  - ``DoStmtSyntax``.``DoStmtSyntax/body``
///  - ``ForStmtSyntax``.``ForStmtSyntax/body``
///  - ``FunctionDeclSyntax``.``FunctionDeclSyntax/body``
///  - ``GuardStmtSyntax``.``GuardStmtSyntax/body``
///  - ``IfExprSyntax``.``IfExprSyntax/body``
///  - ``IfExprSyntax``.``IfExprSyntax/elseBody``
///  - ``InitializerDeclSyntax``.``InitializerDeclSyntax/body``
///  - ``RepeatStmtSyntax``.``RepeatStmtSyntax/body``
///  - ``WhileStmtSyntax``.``WhileStmtSyntax/body``
public struct CodeBlockSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .codeBlock else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLeftBrace: UnexpectedNodesSyntax? = nil,
      leftBrace: TokenSyntax = .leftBraceToken(),
      _ unexpectedBetweenLeftBraceAndStatements: UnexpectedNodesSyntax? = nil,
      statements: CodeBlockItemListSyntax,
      _ unexpectedBetweenStatementsAndRightBrace: UnexpectedNodesSyntax? = nil,
      rightBrace: TokenSyntax = .rightBraceToken(),
      _ unexpectedAfterRightBrace: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLeftBrace, 
            leftBrace, 
            unexpectedBetweenLeftBraceAndStatements, 
            statements, 
            unexpectedBetweenStatementsAndRightBrace, 
            rightBrace, 
            unexpectedAfterRightBrace
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLeftBrace?.raw, 
          leftBrace.raw, 
          unexpectedBetweenLeftBraceAndStatements?.raw, 
          statements.raw, 
          unexpectedBetweenStatementsAndRightBrace?.raw, 
          rightBrace.raw, 
          unexpectedAfterRightBrace?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.codeBlock,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLeftBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(CodeBlockSyntax.self)
    }
  }
  
  public var leftBrace: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(CodeBlockSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftBraceAndStatements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(CodeBlockSyntax.self)
    }
  }
  
  public var statements: CodeBlockItemListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(CodeBlockItemListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(CodeBlockSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `statements`
  /// collection.
  ///
  /// - param element: The new `Statement` to add to the node's
  ///                  `statements` collection.
  /// - returns: A copy of the receiver with the provided `Statement`
  ///            appended to its `statements` collection.
  @available(*, deprecated, message: "Use node.statements.append(newElement) instead")
  public func addStatement(_ element: CodeBlockItemSyntax) -> CodeBlockSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.codeBlockItemList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(CodeBlockSyntax.self)
  }
  
  public var unexpectedBetweenStatementsAndRightBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(CodeBlockSyntax.self)
    }
  }
  
  public var rightBrace: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(CodeBlockSyntax.self)
    }
  }
  
  public var unexpectedAfterRightBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(CodeBlockSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLeftBrace, 
          \Self.leftBrace, 
          \Self.unexpectedBetweenLeftBraceAndStatements, 
          \Self.statements, 
          \Self.unexpectedBetweenStatementsAndRightBrace, 
          \Self.rightBrace, 
          \Self.unexpectedAfterRightBrace
        ])
  }
}

// MARK: - CompositionTypeElementSyntax

/// ### Children
/// 
///  - `type`: ``TypeSyntax``
///  - `ampersand`: ``TokenSyntax``?
///
/// ### Contained in
/// 
///  - ``CompositionTypeElementListSyntax``
public struct CompositionTypeElementSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .compositionTypeElement else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeType: UnexpectedNodesSyntax? = nil,
      type: some TypeSyntaxProtocol,
      _ unexpectedBetweenTypeAndAmpersand: UnexpectedNodesSyntax? = nil,
      ampersand: TokenSyntax? = nil,
      _ unexpectedAfterAmpersand: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeType, 
            type, 
            unexpectedBetweenTypeAndAmpersand, 
            ampersand, 
            unexpectedAfterAmpersand
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeType?.raw, 
          type.raw, 
          unexpectedBetweenTypeAndAmpersand?.raw, 
          ampersand?.raw, 
          unexpectedAfterAmpersand?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.compositionTypeElement,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(CompositionTypeElementSyntax.self)
    }
  }
  
  public var type: TypeSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(CompositionTypeElementSyntax.self)
    }
  }
  
  public var unexpectedBetweenTypeAndAmpersand: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(CompositionTypeElementSyntax.self)
    }
  }
  
  public var ampersand: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(CompositionTypeElementSyntax.self)
    }
  }
  
  public var unexpectedAfterAmpersand: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(CompositionTypeElementSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeType, 
          \Self.type, 
          \Self.unexpectedBetweenTypeAndAmpersand, 
          \Self.ampersand, 
          \Self.unexpectedAfterAmpersand
        ])
  }
}

// MARK: - CompositionTypeSyntax

/// ### Children
/// 
///  - `elements`: ``CompositionTypeElementListSyntax``
public struct CompositionTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .compositionType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeElements: UnexpectedNodesSyntax? = nil,
      elements: CompositionTypeElementListSyntax,
      _ unexpectedAfterElements: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (unexpectedBeforeElements, elements, unexpectedAfterElements))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeElements?.raw, elements.raw, unexpectedAfterElements?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.compositionType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeElements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(CompositionTypeSyntax.self)
    }
  }
  
  public var elements: CompositionTypeElementListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(CompositionTypeElementListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(CompositionTypeSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `elements`
  /// collection.
  ///
  /// - param element: The new `Element` to add to the node's
  ///                  `elements` collection.
  /// - returns: A copy of the receiver with the provided `Element`
  ///            appended to its `elements` collection.
  @available(*, deprecated, message: "Use node.elements.append(newElement) instead")
  public func addElement(_ element: CompositionTypeElementSyntax) -> CompositionTypeSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.compositionTypeElementList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(CompositionTypeSyntax.self)
  }
  
  public var unexpectedAfterElements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(CompositionTypeSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([\Self.unexpectedBeforeElements, \Self.elements, \Self.unexpectedAfterElements])
  }
}

// MARK: - ConditionElementSyntax

/// ### Children
/// 
///  - `condition`: (``ExprSyntax`` | ``AvailabilityConditionSyntax`` | ``MatchingPatternConditionSyntax`` | ``OptionalBindingConditionSyntax``)
///  - `trailingComma`: `','`?
///
/// ### Contained in
/// 
///  - ``ConditionElementListSyntax``
public struct ConditionElementSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Condition: SyntaxChildChoices, SyntaxHashable {
    case `expression`(ExprSyntax)
    case `availability`(AvailabilityConditionSyntax)
    case `matchingPattern`(MatchingPatternConditionSyntax)
    case `optionalBinding`(OptionalBindingConditionSyntax)
    
    public var _syntaxNode: Syntax {
      switch self {
      case .expression(let node):
        return node._syntaxNode
      case .availability(let node):
        return node._syntaxNode
      case .matchingPattern(let node):
        return node._syntaxNode
      case .optionalBinding(let node):
        return node._syntaxNode
      }
    }
    
    public init(_ node: some ExprSyntaxProtocol) {
      self = .expression(ExprSyntax(node))
    }
    
    public init(_ node: AvailabilityConditionSyntax) {
      self = .availability(node)
    }
    
    public init(_ node: MatchingPatternConditionSyntax) {
      self = .matchingPattern(node)
    }
    
    public init(_ node: OptionalBindingConditionSyntax) {
      self = .optionalBinding(node)
    }
    
    public init?(_ node: some SyntaxProtocol) {
      if let node = node.as(ExprSyntax.self) {
        self = .expression(node)
        return
      }
      if let node = node.as(AvailabilityConditionSyntax.self) {
        self = .availability(node)
        return
      }
      if let node = node.as(MatchingPatternConditionSyntax.self) {
        self = .matchingPattern(node)
        return
      }
      if let node = node.as(OptionalBindingConditionSyntax.self) {
        self = .optionalBinding(node)
        return
      }
      return nil
    }
    
    public static var structure: SyntaxNodeStructure {
      return .choices([
            .node(ExprSyntax.self), 
            .node(AvailabilityConditionSyntax.self), 
            .node(MatchingPatternConditionSyntax.self), 
            .node(OptionalBindingConditionSyntax.self)
          ])
    }
  }
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .conditionElement else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeCondition: UnexpectedNodesSyntax? = nil,
      condition: Condition,
      _ unexpectedBetweenConditionAndTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingComma: TokenSyntax? = nil,
      _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeCondition, 
            condition, 
            unexpectedBetweenConditionAndTrailingComma, 
            trailingComma, 
            unexpectedAfterTrailingComma
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeCondition?.raw, 
          condition.raw, 
          unexpectedBetweenConditionAndTrailingComma?.raw, 
          trailingComma?.raw, 
          unexpectedAfterTrailingComma?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.conditionElement,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeCondition: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ConditionElementSyntax.self)
    }
  }
  
  public var condition: Condition {
    get {
      return Syntax(self).child(at: 1)!.cast(Condition.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ConditionElementSyntax.self)
    }
  }
  
  public var unexpectedBetweenConditionAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ConditionElementSyntax.self)
    }
  }
  
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ConditionElementSyntax.self)
    }
  }
  
  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ConditionElementSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeCondition, 
          \Self.condition, 
          \Self.unexpectedBetweenConditionAndTrailingComma, 
          \Self.trailingComma, 
          \Self.unexpectedAfterTrailingComma
        ])
  }
}

// MARK: - ConformanceRequirementSyntax

/// ### Children
/// 
///  - `leftType`: ``TypeSyntax``
///  - `colon`: `':'`
///  - `rightType`: ``TypeSyntax``
///
/// ### Contained in
/// 
///  - ``GenericRequirementSyntax``.``GenericRequirementSyntax/requirement``
public struct ConformanceRequirementSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .conformanceRequirement else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLeftType: UnexpectedNodesSyntax? = nil,
      leftType: some TypeSyntaxProtocol,
      _ unexpectedBetweenLeftTypeAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax = .colonToken(),
      _ unexpectedBetweenColonAndRightType: UnexpectedNodesSyntax? = nil,
      rightType: some TypeSyntaxProtocol,
      _ unexpectedAfterRightType: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLeftType, 
            leftType, 
            unexpectedBetweenLeftTypeAndColon, 
            colon, 
            unexpectedBetweenColonAndRightType, 
            rightType, 
            unexpectedAfterRightType
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLeftType?.raw, 
          leftType.raw, 
          unexpectedBetweenLeftTypeAndColon?.raw, 
          colon.raw, 
          unexpectedBetweenColonAndRightType?.raw, 
          rightType.raw, 
          unexpectedAfterRightType?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.conformanceRequirement,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLeftType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ConformanceRequirementSyntax.self)
    }
  }
  
  public var leftType: TypeSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ConformanceRequirementSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftTypeAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ConformanceRequirementSyntax.self)
    }
  }
  
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ConformanceRequirementSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndRightType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ConformanceRequirementSyntax.self)
    }
  }
  
  public var rightType: TypeSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(ConformanceRequirementSyntax.self)
    }
  }
  
  public var unexpectedAfterRightType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(ConformanceRequirementSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLeftType, 
          \Self.leftType, 
          \Self.unexpectedBetweenLeftTypeAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndRightType, 
          \Self.rightType, 
          \Self.unexpectedAfterRightType
        ])
  }
}

// MARK: - ConsumeExprSyntax

/// ### Children
/// 
///  - `consumeKeyword`: (`'_move'` | `'consume'`)
///  - `expression`: ``ExprSyntax``
public struct ConsumeExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .consumeExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeConsumeKeyword: UnexpectedNodesSyntax? = nil,
      consumeKeyword: TokenSyntax,
      _ unexpectedBetweenConsumeKeywordAndExpression: UnexpectedNodesSyntax? = nil,
      expression: some ExprSyntaxProtocol,
      _ unexpectedAfterExpression: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeConsumeKeyword, 
            consumeKeyword, 
            unexpectedBetweenConsumeKeywordAndExpression, 
            expression, 
            unexpectedAfterExpression
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeConsumeKeyword?.raw, 
          consumeKeyword.raw, 
          unexpectedBetweenConsumeKeywordAndExpression?.raw, 
          expression.raw, 
          unexpectedAfterExpression?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.consumeExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeConsumeKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ConsumeExprSyntax.self)
    }
  }
  
  public var consumeKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ConsumeExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenConsumeKeywordAndExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ConsumeExprSyntax.self)
    }
  }
  
  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ConsumeExprSyntax.self)
    }
  }
  
  public var unexpectedAfterExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ConsumeExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeConsumeKeyword, 
          \Self.consumeKeyword, 
          \Self.unexpectedBetweenConsumeKeywordAndExpression, 
          \Self.expression, 
          \Self.unexpectedAfterExpression
        ])
  }
}

// MARK: - ContinueStmtSyntax

/// ### Children
/// 
///  - `continueKeyword`: `'continue'`
///  - `label`: `<identifier>`?
public struct ContinueStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .continueStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeContinueKeyword: UnexpectedNodesSyntax? = nil,
      continueKeyword: TokenSyntax = .keyword(.continue),
      _ unexpectedBetweenContinueKeywordAndLabel: UnexpectedNodesSyntax? = nil,
      label: TokenSyntax? = nil,
      _ unexpectedAfterLabel: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeContinueKeyword, 
            continueKeyword, 
            unexpectedBetweenContinueKeywordAndLabel, 
            label, 
            unexpectedAfterLabel
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeContinueKeyword?.raw, 
          continueKeyword.raw, 
          unexpectedBetweenContinueKeywordAndLabel?.raw, 
          label?.raw, 
          unexpectedAfterLabel?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.continueStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeContinueKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ContinueStmtSyntax.self)
    }
  }
  
  public var continueKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ContinueStmtSyntax.self)
    }
  }
  
  public var unexpectedBetweenContinueKeywordAndLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ContinueStmtSyntax.self)
    }
  }
  
  public var label: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ContinueStmtSyntax.self)
    }
  }
  
  public var unexpectedAfterLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ContinueStmtSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeContinueKeyword, 
          \Self.continueKeyword, 
          \Self.unexpectedBetweenContinueKeywordAndLabel, 
          \Self.label, 
          \Self.unexpectedAfterLabel
        ])
  }
}

// MARK: - ConventionAttributeArgumentsSyntax

/// The arguments for the '@convention(...)'.
///
/// ### Children
/// 
///  - `conventionLabel`: `<identifier>`
///  - `comma`: `','`?
///  - `cTypeLabel`: `'cType'`?
///  - `colon`: `':'`?
///  - `cTypeString`: ``StringLiteralExprSyntax``?
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct ConventionAttributeArgumentsSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .conventionAttributeArguments else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - conventionLabel: The convention label.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeConventionLabel: UnexpectedNodesSyntax? = nil,
      conventionLabel: TokenSyntax,
      _ unexpectedBetweenConventionLabelAndComma: UnexpectedNodesSyntax? = nil,
      comma: TokenSyntax? = nil,
      _ unexpectedBetweenCommaAndCTypeLabel: UnexpectedNodesSyntax? = nil,
      cTypeLabel: TokenSyntax? = nil,
      _ unexpectedBetweenCTypeLabelAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax? = nil,
      _ unexpectedBetweenColonAndCTypeString: UnexpectedNodesSyntax? = nil,
      cTypeString: StringLiteralExprSyntax? = nil,
      _ unexpectedAfterCTypeString: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeConventionLabel, 
            conventionLabel, 
            unexpectedBetweenConventionLabelAndComma, 
            comma, 
            unexpectedBetweenCommaAndCTypeLabel, 
            cTypeLabel, 
            unexpectedBetweenCTypeLabelAndColon, 
            colon, 
            unexpectedBetweenColonAndCTypeString, 
            cTypeString, 
            unexpectedAfterCTypeString
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeConventionLabel?.raw, 
          conventionLabel.raw, 
          unexpectedBetweenConventionLabelAndComma?.raw, 
          comma?.raw, 
          unexpectedBetweenCommaAndCTypeLabel?.raw, 
          cTypeLabel?.raw, 
          unexpectedBetweenCTypeLabelAndColon?.raw, 
          colon?.raw, 
          unexpectedBetweenColonAndCTypeString?.raw, 
          cTypeString?.raw, 
          unexpectedAfterCTypeString?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.conventionAttributeArguments,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeConventionLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ConventionAttributeArgumentsSyntax.self)
    }
  }
  
  /// The convention label.
  public var conventionLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ConventionAttributeArgumentsSyntax.self)
    }
  }
  
  public var unexpectedBetweenConventionLabelAndComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ConventionAttributeArgumentsSyntax.self)
    }
  }
  
  public var comma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ConventionAttributeArgumentsSyntax.self)
    }
  }
  
  public var unexpectedBetweenCommaAndCTypeLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ConventionAttributeArgumentsSyntax.self)
    }
  }
  
  public var cTypeLabel: TokenSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(ConventionAttributeArgumentsSyntax.self)
    }
  }
  
  public var unexpectedBetweenCTypeLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(ConventionAttributeArgumentsSyntax.self)
    }
  }
  
  public var colon: TokenSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(ConventionAttributeArgumentsSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndCTypeString: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(ConventionAttributeArgumentsSyntax.self)
    }
  }
  
  public var cTypeString: StringLiteralExprSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(StringLiteralExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(ConventionAttributeArgumentsSyntax.self)
    }
  }
  
  public var unexpectedAfterCTypeString: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(ConventionAttributeArgumentsSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeConventionLabel, 
          \Self.conventionLabel, 
          \Self.unexpectedBetweenConventionLabelAndComma, 
          \Self.comma, 
          \Self.unexpectedBetweenCommaAndCTypeLabel, 
          \Self.cTypeLabel, 
          \Self.unexpectedBetweenCTypeLabelAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndCTypeString, 
          \Self.cTypeString, 
          \Self.unexpectedAfterCTypeString
        ])
  }
}

// MARK: - ConventionWitnessMethodAttributeArgumentsSyntax

/// The arguments for the '@convention(witness_method: ...)'.
///
/// ### Children
/// 
///  - `witnessMethodLabel`: `'witness_method'`
///  - `colon`: `':'`
///  - `protocolName`: `<identifier>`
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct ConventionWitnessMethodAttributeArgumentsSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .conventionWitnessMethodAttributeArguments else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeWitnessMethodLabel: UnexpectedNodesSyntax? = nil,
      witnessMethodLabel: TokenSyntax = .keyword(.witness_method),
      _ unexpectedBetweenWitnessMethodLabelAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax = .colonToken(),
      _ unexpectedBetweenColonAndProtocolName: UnexpectedNodesSyntax? = nil,
      protocolName: TokenSyntax,
      _ unexpectedAfterProtocolName: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeWitnessMethodLabel, 
            witnessMethodLabel, 
            unexpectedBetweenWitnessMethodLabelAndColon, 
            colon, 
            unexpectedBetweenColonAndProtocolName, 
            protocolName, 
            unexpectedAfterProtocolName
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeWitnessMethodLabel?.raw, 
          witnessMethodLabel.raw, 
          unexpectedBetweenWitnessMethodLabelAndColon?.raw, 
          colon.raw, 
          unexpectedBetweenColonAndProtocolName?.raw, 
          protocolName.raw, 
          unexpectedAfterProtocolName?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.conventionWitnessMethodAttributeArguments,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeWitnessMethodLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ConventionWitnessMethodAttributeArgumentsSyntax.self)
    }
  }
  
  public var witnessMethodLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ConventionWitnessMethodAttributeArgumentsSyntax.self)
    }
  }
  
  public var unexpectedBetweenWitnessMethodLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ConventionWitnessMethodAttributeArgumentsSyntax.self)
    }
  }
  
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ConventionWitnessMethodAttributeArgumentsSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndProtocolName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ConventionWitnessMethodAttributeArgumentsSyntax.self)
    }
  }
  
  public var protocolName: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(ConventionWitnessMethodAttributeArgumentsSyntax.self)
    }
  }
  
  public var unexpectedAfterProtocolName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(ConventionWitnessMethodAttributeArgumentsSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeWitnessMethodLabel, 
          \Self.witnessMethodLabel, 
          \Self.unexpectedBetweenWitnessMethodLabelAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndProtocolName, 
          \Self.protocolName, 
          \Self.unexpectedAfterProtocolName
        ])
  }
}

// MARK: - CopyExprSyntax

/// ### Children
/// 
///  - `copyKeyword`: `'copy'`
///  - `expression`: ``ExprSyntax``
public struct CopyExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .copyExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeCopyKeyword: UnexpectedNodesSyntax? = nil,
      copyKeyword: TokenSyntax = .keyword(.copy),
      _ unexpectedBetweenCopyKeywordAndExpression: UnexpectedNodesSyntax? = nil,
      expression: some ExprSyntaxProtocol,
      _ unexpectedAfterExpression: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeCopyKeyword, 
            copyKeyword, 
            unexpectedBetweenCopyKeywordAndExpression, 
            expression, 
            unexpectedAfterExpression
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeCopyKeyword?.raw, 
          copyKeyword.raw, 
          unexpectedBetweenCopyKeywordAndExpression?.raw, 
          expression.raw, 
          unexpectedAfterExpression?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.copyExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeCopyKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(CopyExprSyntax.self)
    }
  }
  
  public var copyKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(CopyExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenCopyKeywordAndExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(CopyExprSyntax.self)
    }
  }
  
  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(CopyExprSyntax.self)
    }
  }
  
  public var unexpectedAfterExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(CopyExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeCopyKeyword, 
          \Self.copyKeyword, 
          \Self.unexpectedBetweenCopyKeywordAndExpression, 
          \Self.expression, 
          \Self.unexpectedAfterExpression
        ])
  }
}
