//// Automatically generated by generate-swift-syntax
//// Do not edit directly!
//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

// MARK: - AccessorBlockSyntax

/// ### Children
/// 
///  - `leftBrace`: `'{'`
///  - `accessors`: (``AccessorDeclListSyntax`` | ``CodeBlockItemListSyntax``)
///  - `rightBrace`: `'}'`
///
/// ### Contained in
/// 
///  - ``PatternBindingSyntax``.``PatternBindingSyntax/accessorBlock``
///  - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/accessorBlock``
public struct AccessorBlockSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Accessors: SyntaxChildChoices, SyntaxHashable {
    case `accessors`(AccessorDeclListSyntax)
    case `getter`(CodeBlockItemListSyntax)
    
    public var _syntaxNode: Syntax {
      switch self {
      case .accessors(let node):
        return node._syntaxNode
      case .getter(let node):
        return node._syntaxNode
      }
    }
    
    public init(_ node: AccessorDeclListSyntax) {
      self = .accessors(node)
    }
    
    public init(_ node: CodeBlockItemListSyntax) {
      self = .getter(node)
    }
    
    public init?(_ node: some SyntaxProtocol) {
      if let node = node.as(AccessorDeclListSyntax.self) {
        self = .accessors(node)
        return
      }
      if let node = node.as(CodeBlockItemListSyntax.self) {
        self = .getter(node)
        return
      }
      return nil
    }
    
    public static var structure: SyntaxNodeStructure {
      return .choices([.node(AccessorDeclListSyntax.self), .node(CodeBlockItemListSyntax.self)])
    }
  }
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .accessorBlock else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLeftBrace: UnexpectedNodesSyntax? = nil,
      leftBrace: TokenSyntax = .leftBraceToken(),
      _ unexpectedBetweenLeftBraceAndAccessors: UnexpectedNodesSyntax? = nil,
      accessors: Accessors,
      _ unexpectedBetweenAccessorsAndRightBrace: UnexpectedNodesSyntax? = nil,
      rightBrace: TokenSyntax = .rightBraceToken(),
      _ unexpectedAfterRightBrace: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLeftBrace, 
            leftBrace, 
            unexpectedBetweenLeftBraceAndAccessors, 
            accessors, 
            unexpectedBetweenAccessorsAndRightBrace, 
            rightBrace, 
            unexpectedAfterRightBrace
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLeftBrace?.raw, 
          leftBrace.raw, 
          unexpectedBetweenLeftBraceAndAccessors?.raw, 
          accessors.raw, 
          unexpectedBetweenAccessorsAndRightBrace?.raw, 
          rightBrace.raw, 
          unexpectedAfterRightBrace?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.accessorBlock,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLeftBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(AccessorBlockSyntax.self)
    }
  }
  
  public var leftBrace: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(AccessorBlockSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftBraceAndAccessors: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(AccessorBlockSyntax.self)
    }
  }
  
  public var accessors: Accessors {
    get {
      return Syntax(self).child(at: 3)!.cast(Accessors.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(AccessorBlockSyntax.self)
    }
  }
  
  public var unexpectedBetweenAccessorsAndRightBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(AccessorBlockSyntax.self)
    }
  }
  
  public var rightBrace: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(AccessorBlockSyntax.self)
    }
  }
  
  public var unexpectedAfterRightBrace: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(AccessorBlockSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLeftBrace, 
          \Self.leftBrace, 
          \Self.unexpectedBetweenLeftBraceAndAccessors, 
          \Self.accessors, 
          \Self.unexpectedBetweenAccessorsAndRightBrace, 
          \Self.rightBrace, 
          \Self.unexpectedAfterRightBrace
        ])
  }
}

// MARK: - AccessorDeclSyntax

/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifier`: ``DeclModifierSyntax``?
///  - `accessorSpecifier`: (`'get'` | `'set'` | `'didSet'` | `'willSet'` | `'unsafeAddress'` | `'addressWithOwner'` | `'addressWithNativeOwner'` | `'unsafeMutableAddress'` | `'mutableAddressWithOwner'` | `'mutableAddressWithNativeOwner'` | `'_read'` | `'_modify'` | `'init'`)
///  - `parameters`: ``AccessorParametersSyntax``?
///  - `effectSpecifiers`: ``AccessorEffectSpecifiersSyntax``?
///  - `body`: ``CodeBlockSyntax``?
///
/// ### Contained in
/// 
///  - ``AccessorDeclListSyntax``
public struct AccessorDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .accessorDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
      attributes: AttributeListSyntax = [],
      _ unexpectedBetweenAttributesAndModifier: UnexpectedNodesSyntax? = nil,
      modifier: DeclModifierSyntax? = nil,
      _ unexpectedBetweenModifierAndAccessorSpecifier: UnexpectedNodesSyntax? = nil,
      accessorSpecifier: TokenSyntax,
      _ unexpectedBetweenAccessorSpecifierAndParameters: UnexpectedNodesSyntax? = nil,
      parameters: AccessorParametersSyntax? = nil,
      _ unexpectedBetweenParametersAndEffectSpecifiers: UnexpectedNodesSyntax? = nil,
      effectSpecifiers: AccessorEffectSpecifiersSyntax? = nil,
      _ unexpectedBetweenEffectSpecifiersAndBody: UnexpectedNodesSyntax? = nil,
      body: CodeBlockSyntax? = nil,
      _ unexpectedAfterBody: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAttributes, 
            attributes, 
            unexpectedBetweenAttributesAndModifier, 
            modifier, 
            unexpectedBetweenModifierAndAccessorSpecifier, 
            accessorSpecifier, 
            unexpectedBetweenAccessorSpecifierAndParameters, 
            parameters, 
            unexpectedBetweenParametersAndEffectSpecifiers, 
            effectSpecifiers, 
            unexpectedBetweenEffectSpecifiersAndBody, 
            body, 
            unexpectedAfterBody
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAttributes?.raw, 
          attributes.raw, 
          unexpectedBetweenAttributesAndModifier?.raw, 
          modifier?.raw, 
          unexpectedBetweenModifierAndAccessorSpecifier?.raw, 
          accessorSpecifier.raw, 
          unexpectedBetweenAccessorSpecifierAndParameters?.raw, 
          parameters?.raw, 
          unexpectedBetweenParametersAndEffectSpecifiers?.raw, 
          effectSpecifiers?.raw, 
          unexpectedBetweenEffectSpecifiersAndBody?.raw, 
          body?.raw, 
          unexpectedAfterBody?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.accessorDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }
  
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> AccessorDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(AccessorDeclSyntax.self)
  }
  
  public var unexpectedBetweenAttributesAndModifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }
  
  public var modifier: DeclModifierSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(DeclModifierSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenModifierAndAccessorSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }
  
  public var accessorSpecifier: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenAccessorSpecifierAndParameters: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }
  
  public var parameters: AccessorParametersSyntax? {
    get {
      return Syntax(self).child(at: 7)?.cast(AccessorParametersSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenParametersAndEffectSpecifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }
  
  public var effectSpecifiers: AccessorEffectSpecifiersSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(AccessorEffectSpecifiersSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenEffectSpecifiersAndBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }
  
  public var body: CodeBlockSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(CodeBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), arena: SyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }
  
  public var unexpectedAfterBody: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), arena: SyntaxArena()).cast(AccessorDeclSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAttributes, 
          \Self.attributes, 
          \Self.unexpectedBetweenAttributesAndModifier, 
          \Self.modifier, 
          \Self.unexpectedBetweenModifierAndAccessorSpecifier, 
          \Self.accessorSpecifier, 
          \Self.unexpectedBetweenAccessorSpecifierAndParameters, 
          \Self.parameters, 
          \Self.unexpectedBetweenParametersAndEffectSpecifiers, 
          \Self.effectSpecifiers, 
          \Self.unexpectedBetweenEffectSpecifiersAndBody, 
          \Self.body, 
          \Self.unexpectedAfterBody
        ])
  }
}

// MARK: - AccessorEffectSpecifiersSyntax

/// ### Children
/// 
///  - `asyncSpecifier`: `'async'`?
///  - `throwsSpecifier`: `'throws'`?
///
/// ### Contained in
/// 
///  - ``AccessorDeclSyntax``.``AccessorDeclSyntax/effectSpecifiers``
public struct AccessorEffectSpecifiersSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .accessorEffectSpecifiers else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAsyncSpecifier: UnexpectedNodesSyntax? = nil,
      asyncSpecifier: TokenSyntax? = nil,
      _ unexpectedBetweenAsyncSpecifierAndThrowsSpecifier: UnexpectedNodesSyntax? = nil,
      throwsSpecifier: TokenSyntax? = nil,
      _ unexpectedAfterThrowsSpecifier: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAsyncSpecifier, 
            asyncSpecifier, 
            unexpectedBetweenAsyncSpecifierAndThrowsSpecifier, 
            throwsSpecifier, 
            unexpectedAfterThrowsSpecifier
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAsyncSpecifier?.raw, 
          asyncSpecifier?.raw, 
          unexpectedBetweenAsyncSpecifierAndThrowsSpecifier?.raw, 
          throwsSpecifier?.raw, 
          unexpectedAfterThrowsSpecifier?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.accessorEffectSpecifiers,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAsyncSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(AccessorEffectSpecifiersSyntax.self)
    }
  }
  
  public var asyncSpecifier: TokenSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(AccessorEffectSpecifiersSyntax.self)
    }
  }
  
  public var unexpectedBetweenAsyncSpecifierAndThrowsSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(AccessorEffectSpecifiersSyntax.self)
    }
  }
  
  public var throwsSpecifier: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(AccessorEffectSpecifiersSyntax.self)
    }
  }
  
  public var unexpectedAfterThrowsSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(AccessorEffectSpecifiersSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAsyncSpecifier, 
          \Self.asyncSpecifier, 
          \Self.unexpectedBetweenAsyncSpecifierAndThrowsSpecifier, 
          \Self.throwsSpecifier, 
          \Self.unexpectedAfterThrowsSpecifier
        ])
  }
}

// MARK: - AccessorParametersSyntax

/// ### Children
/// 
///  - `leftParen`: `'('`
///  - `name`: `<identifier>`
///  - `rightParen`: `')'`
///
/// ### Contained in
/// 
///  - ``AccessorDeclSyntax``.``AccessorDeclSyntax/parameters``
public struct AccessorParametersSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .accessorParameters else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLeftParen: UnexpectedNodesSyntax? = nil,
      leftParen: TokenSyntax = .leftParenToken(),
      _ unexpectedBetweenLeftParenAndName: UnexpectedNodesSyntax? = nil,
      name: TokenSyntax,
      _ unexpectedBetweenNameAndRightParen: UnexpectedNodesSyntax? = nil,
      rightParen: TokenSyntax = .rightParenToken(),
      _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLeftParen, 
            leftParen, 
            unexpectedBetweenLeftParenAndName, 
            name, 
            unexpectedBetweenNameAndRightParen, 
            rightParen, 
            unexpectedAfterRightParen
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLeftParen?.raw, 
          leftParen.raw, 
          unexpectedBetweenLeftParenAndName?.raw, 
          name.raw, 
          unexpectedBetweenNameAndRightParen?.raw, 
          rightParen.raw, 
          unexpectedAfterRightParen?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.accessorParameters,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(AccessorParametersSyntax.self)
    }
  }
  
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(AccessorParametersSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftParenAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(AccessorParametersSyntax.self)
    }
  }
  
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(AccessorParametersSyntax.self)
    }
  }
  
  public var unexpectedBetweenNameAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(AccessorParametersSyntax.self)
    }
  }
  
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(AccessorParametersSyntax.self)
    }
  }
  
  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(AccessorParametersSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLeftParen, 
          \Self.leftParen, 
          \Self.unexpectedBetweenLeftParenAndName, 
          \Self.name, 
          \Self.unexpectedBetweenNameAndRightParen, 
          \Self.rightParen, 
          \Self.unexpectedAfterRightParen
        ])
  }
}

// MARK: - ActorDeclSyntax

/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `actorKeyword`: `'actor'`
///  - `name`: `<identifier>`
///  - `genericParameterClause`: ``GenericParameterClauseSyntax``?
///  - `inheritanceClause`: ``InheritanceClauseSyntax``?
///  - `genericWhereClause`: ``GenericWhereClauseSyntax``?
///  - `memberBlock`: ``MemberBlockSyntax``
public struct ActorDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .actorDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - genericParameterClause: The parameter clause that defines the generic parameters.
  ///   - genericWhereClause: A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
      attributes: AttributeListSyntax = [],
      _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
      modifiers: DeclModifierListSyntax = [],
      _ unexpectedBetweenModifiersAndActorKeyword: UnexpectedNodesSyntax? = nil,
      actorKeyword: TokenSyntax = .keyword(.actor),
      _ unexpectedBetweenActorKeywordAndName: UnexpectedNodesSyntax? = nil,
      name: TokenSyntax,
      _ unexpectedBetweenNameAndGenericParameterClause: UnexpectedNodesSyntax? = nil,
      genericParameterClause: GenericParameterClauseSyntax? = nil,
      _ unexpectedBetweenGenericParameterClauseAndInheritanceClause: UnexpectedNodesSyntax? = nil,
      inheritanceClause: InheritanceClauseSyntax? = nil,
      _ unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
      genericWhereClause: GenericWhereClauseSyntax? = nil,
      _ unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? = nil,
      memberBlock: MemberBlockSyntax,
      _ unexpectedAfterMemberBlock: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAttributes, 
            attributes, 
            unexpectedBetweenAttributesAndModifiers, 
            modifiers, 
            unexpectedBetweenModifiersAndActorKeyword, 
            actorKeyword, 
            unexpectedBetweenActorKeywordAndName, 
            name, 
            unexpectedBetweenNameAndGenericParameterClause, 
            genericParameterClause, 
            unexpectedBetweenGenericParameterClauseAndInheritanceClause, 
            inheritanceClause, 
            unexpectedBetweenInheritanceClauseAndGenericWhereClause, 
            genericWhereClause, 
            unexpectedBetweenGenericWhereClauseAndMemberBlock, 
            memberBlock, 
            unexpectedAfterMemberBlock
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAttributes?.raw, 
          attributes.raw, 
          unexpectedBetweenAttributesAndModifiers?.raw, 
          modifiers.raw, 
          unexpectedBetweenModifiersAndActorKeyword?.raw, 
          actorKeyword.raw, 
          unexpectedBetweenActorKeywordAndName?.raw, 
          name.raw, 
          unexpectedBetweenNameAndGenericParameterClause?.raw, 
          genericParameterClause?.raw, 
          unexpectedBetweenGenericParameterClauseAndInheritanceClause?.raw, 
          inheritanceClause?.raw, 
          unexpectedBetweenInheritanceClauseAndGenericWhereClause?.raw, 
          genericWhereClause?.raw, 
          unexpectedBetweenGenericWhereClauseAndMemberBlock?.raw, 
          memberBlock.raw, 
          unexpectedAfterMemberBlock?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.actorDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> ActorDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(ActorDeclSyntax.self)
  }
  
  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> ActorDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(ActorDeclSyntax.self)
  }
  
  public var unexpectedBetweenModifiersAndActorKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  public var actorKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenActorKeywordAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenNameAndGenericParameterClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  /// The parameter clause that defines the generic parameters.
  public var genericParameterClause: GenericParameterClauseSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(GenericParameterClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenGenericParameterClauseAndInheritanceClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  public var inheritanceClause: InheritanceClauseSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(InheritanceClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenInheritanceClauseAndGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  /// A `where` clause that places additional constraints on generic parameters like `where Element: Hashable`.
  public var genericWhereClause: GenericWhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(GenericWhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenGenericWhereClauseAndMemberBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  public var memberBlock: MemberBlockSyntax {
    get {
      return Syntax(self).child(at: 15)!.cast(MemberBlockSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 15, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  public var unexpectedAfterMemberBlock: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 16)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 16, with: Syntax(value), arena: SyntaxArena()).cast(ActorDeclSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAttributes, 
          \Self.attributes, 
          \Self.unexpectedBetweenAttributesAndModifiers, 
          \Self.modifiers, 
          \Self.unexpectedBetweenModifiersAndActorKeyword, 
          \Self.actorKeyword, 
          \Self.unexpectedBetweenActorKeywordAndName, 
          \Self.name, 
          \Self.unexpectedBetweenNameAndGenericParameterClause, 
          \Self.genericParameterClause, 
          \Self.unexpectedBetweenGenericParameterClauseAndInheritanceClause, 
          \Self.inheritanceClause, 
          \Self.unexpectedBetweenInheritanceClauseAndGenericWhereClause, 
          \Self.genericWhereClause, 
          \Self.unexpectedBetweenGenericWhereClauseAndMemberBlock, 
          \Self.memberBlock, 
          \Self.unexpectedAfterMemberBlock
        ])
  }
}

// MARK: - ArrayElementSyntax

/// ### Children
/// 
///  - `expression`: ``ExprSyntax``
///  - `trailingComma`: `','`?
///
/// ### Contained in
/// 
///  - ``ArrayElementListSyntax``
public struct ArrayElementSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .arrayElement else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeExpression: UnexpectedNodesSyntax? = nil,
      expression: some ExprSyntaxProtocol,
      _ unexpectedBetweenExpressionAndTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingComma: TokenSyntax? = nil,
      _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeExpression, 
            expression, 
            unexpectedBetweenExpressionAndTrailingComma, 
            trailingComma, 
            unexpectedAfterTrailingComma
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeExpression?.raw, 
          expression.raw, 
          unexpectedBetweenExpressionAndTrailingComma?.raw, 
          trailingComma?.raw, 
          unexpectedAfterTrailingComma?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.arrayElement,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ArrayElementSyntax.self)
    }
  }
  
  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ArrayElementSyntax.self)
    }
  }
  
  public var unexpectedBetweenExpressionAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ArrayElementSyntax.self)
    }
  }
  
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ArrayElementSyntax.self)
    }
  }
  
  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ArrayElementSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeExpression, 
          \Self.expression, 
          \Self.unexpectedBetweenExpressionAndTrailingComma, 
          \Self.trailingComma, 
          \Self.unexpectedAfterTrailingComma
        ])
  }
}

// MARK: - ArrayExprSyntax

/// ### Children
/// 
///  - `leftSquare`: `'['`
///  - `elements`: ``ArrayElementListSyntax``
///  - `rightSquare`: `']'`
public struct ArrayExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .arrayExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? = nil,
      leftSquare: TokenSyntax = .leftSquareToken(),
      _ unexpectedBetweenLeftSquareAndElements: UnexpectedNodesSyntax? = nil,
      elements: ArrayElementListSyntax,
      _ unexpectedBetweenElementsAndRightSquare: UnexpectedNodesSyntax? = nil,
      rightSquare: TokenSyntax = .rightSquareToken(),
      _ unexpectedAfterRightSquare: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLeftSquare, 
            leftSquare, 
            unexpectedBetweenLeftSquareAndElements, 
            elements, 
            unexpectedBetweenElementsAndRightSquare, 
            rightSquare, 
            unexpectedAfterRightSquare
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLeftSquare?.raw, 
          leftSquare.raw, 
          unexpectedBetweenLeftSquareAndElements?.raw, 
          elements.raw, 
          unexpectedBetweenElementsAndRightSquare?.raw, 
          rightSquare.raw, 
          unexpectedAfterRightSquare?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.arrayExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ArrayExprSyntax.self)
    }
  }
  
  public var leftSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ArrayExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftSquareAndElements: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ArrayExprSyntax.self)
    }
  }
  
  public var elements: ArrayElementListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ArrayElementListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ArrayExprSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `elements`
  /// collection.
  ///
  /// - param element: The new `Element` to add to the node's
  ///                  `elements` collection.
  /// - returns: A copy of the receiver with the provided `Element`
  ///            appended to its `elements` collection.
  @available(*, deprecated, message: "Use node.elements.append(newElement) instead")
  public func addElement(_ element: ArrayElementSyntax) -> ArrayExprSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.arrayElementList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(ArrayExprSyntax.self)
  }
  
  public var unexpectedBetweenElementsAndRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ArrayExprSyntax.self)
    }
  }
  
  public var rightSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(ArrayExprSyntax.self)
    }
  }
  
  public var unexpectedAfterRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(ArrayExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLeftSquare, 
          \Self.leftSquare, 
          \Self.unexpectedBetweenLeftSquareAndElements, 
          \Self.elements, 
          \Self.unexpectedBetweenElementsAndRightSquare, 
          \Self.rightSquare, 
          \Self.unexpectedAfterRightSquare
        ])
  }
}

// MARK: - ArrayTypeSyntax

/// ### Children
/// 
///  - `leftSquare`: `'['`
///  - `element`: ``TypeSyntax``
///  - `rightSquare`: `']'`
public struct ArrayTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .arrayType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? = nil,
      leftSquare: TokenSyntax = .leftSquareToken(),
      _ unexpectedBetweenLeftSquareAndElement: UnexpectedNodesSyntax? = nil,
      element: some TypeSyntaxProtocol,
      _ unexpectedBetweenElementAndRightSquare: UnexpectedNodesSyntax? = nil,
      rightSquare: TokenSyntax = .rightSquareToken(),
      _ unexpectedAfterRightSquare: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLeftSquare, 
            leftSquare, 
            unexpectedBetweenLeftSquareAndElement, 
            element, 
            unexpectedBetweenElementAndRightSquare, 
            rightSquare, 
            unexpectedAfterRightSquare
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLeftSquare?.raw, 
          leftSquare.raw, 
          unexpectedBetweenLeftSquareAndElement?.raw, 
          element.raw, 
          unexpectedBetweenElementAndRightSquare?.raw, 
          rightSquare.raw, 
          unexpectedAfterRightSquare?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.arrayType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLeftSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ArrayTypeSyntax.self)
    }
  }
  
  public var leftSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ArrayTypeSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftSquareAndElement: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ArrayTypeSyntax.self)
    }
  }
  
  public var element: TypeSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ArrayTypeSyntax.self)
    }
  }
  
  public var unexpectedBetweenElementAndRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ArrayTypeSyntax.self)
    }
  }
  
  public var rightSquare: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(ArrayTypeSyntax.self)
    }
  }
  
  public var unexpectedAfterRightSquare: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(ArrayTypeSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLeftSquare, 
          \Self.leftSquare, 
          \Self.unexpectedBetweenLeftSquareAndElement, 
          \Self.element, 
          \Self.unexpectedBetweenElementAndRightSquare, 
          \Self.rightSquare, 
          \Self.unexpectedAfterRightSquare
        ])
  }
}

// MARK: - ArrowExprSyntax

/// ### Children
/// 
///  - `effectSpecifiers`: ``TypeEffectSpecifiersSyntax``?
///  - `arrow`: `'->'`
public struct ArrowExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .arrowExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeEffectSpecifiers: UnexpectedNodesSyntax? = nil,
      effectSpecifiers: TypeEffectSpecifiersSyntax? = nil,
      _ unexpectedBetweenEffectSpecifiersAndArrow: UnexpectedNodesSyntax? = nil,
      arrow: TokenSyntax = .arrowToken(),
      _ unexpectedAfterArrow: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeEffectSpecifiers, 
            effectSpecifiers, 
            unexpectedBetweenEffectSpecifiersAndArrow, 
            arrow, 
            unexpectedAfterArrow
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeEffectSpecifiers?.raw, 
          effectSpecifiers?.raw, 
          unexpectedBetweenEffectSpecifiersAndArrow?.raw, 
          arrow.raw, 
          unexpectedAfterArrow?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.arrowExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeEffectSpecifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(ArrowExprSyntax.self)
    }
  }
  
  public var effectSpecifiers: TypeEffectSpecifiersSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TypeEffectSpecifiersSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(ArrowExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenEffectSpecifiersAndArrow: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(ArrowExprSyntax.self)
    }
  }
  
  public var arrow: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(ArrowExprSyntax.self)
    }
  }
  
  public var unexpectedAfterArrow: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(ArrowExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeEffectSpecifiers, 
          \Self.effectSpecifiers, 
          \Self.unexpectedBetweenEffectSpecifiersAndArrow, 
          \Self.arrow, 
          \Self.unexpectedAfterArrow
        ])
  }
}

// MARK: - AsExprSyntax

/// ### Children
/// 
///  - `expression`: ``ExprSyntax``
///  - `asKeyword`: `'as'`
///  - `questionOrExclamationMark`: (`'?'` | `'!'`)?
///  - `type`: ``TypeSyntax``
public struct AsExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .asExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeExpression: UnexpectedNodesSyntax? = nil,
      expression: some ExprSyntaxProtocol,
      _ unexpectedBetweenExpressionAndAsKeyword: UnexpectedNodesSyntax? = nil,
      asKeyword: TokenSyntax = .keyword(.as),
      _ unexpectedBetweenAsKeywordAndQuestionOrExclamationMark: UnexpectedNodesSyntax? = nil,
      questionOrExclamationMark: TokenSyntax? = nil,
      _ unexpectedBetweenQuestionOrExclamationMarkAndType: UnexpectedNodesSyntax? = nil,
      type: some TypeSyntaxProtocol,
      _ unexpectedAfterType: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeExpression, 
            expression, 
            unexpectedBetweenExpressionAndAsKeyword, 
            asKeyword, 
            unexpectedBetweenAsKeywordAndQuestionOrExclamationMark, 
            questionOrExclamationMark, 
            unexpectedBetweenQuestionOrExclamationMarkAndType, 
            type, 
            unexpectedAfterType
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeExpression?.raw, 
          expression.raw, 
          unexpectedBetweenExpressionAndAsKeyword?.raw, 
          asKeyword.raw, 
          unexpectedBetweenAsKeywordAndQuestionOrExclamationMark?.raw, 
          questionOrExclamationMark?.raw, 
          unexpectedBetweenQuestionOrExclamationMarkAndType?.raw, 
          type.raw, 
          unexpectedAfterType?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.asExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(AsExprSyntax.self)
    }
  }
  
  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(AsExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenExpressionAndAsKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(AsExprSyntax.self)
    }
  }
  
  public var asKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(AsExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenAsKeywordAndQuestionOrExclamationMark: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(AsExprSyntax.self)
    }
  }
  
  public var questionOrExclamationMark: TokenSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(AsExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenQuestionOrExclamationMarkAndType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(AsExprSyntax.self)
    }
  }
  
  public var type: TypeSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(AsExprSyntax.self)
    }
  }
  
  public var unexpectedAfterType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(AsExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeExpression, 
          \Self.expression, 
          \Self.unexpectedBetweenExpressionAndAsKeyword, 
          \Self.asKeyword, 
          \Self.unexpectedBetweenAsKeywordAndQuestionOrExclamationMark, 
          \Self.questionOrExclamationMark, 
          \Self.unexpectedBetweenQuestionOrExclamationMarkAndType, 
          \Self.type, 
          \Self.unexpectedAfterType
        ])
  }
}

// MARK: - AssignmentExprSyntax

/// ### Children
/// 
///  - `equal`: `'='`
public struct AssignmentExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .assignmentExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeEqual: UnexpectedNodesSyntax? = nil,
      equal: TokenSyntax = .equalToken(),
      _ unexpectedAfterEqual: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (unexpectedBeforeEqual, equal, unexpectedAfterEqual))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeEqual?.raw, equal.raw, unexpectedAfterEqual?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.assignmentExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeEqual: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(AssignmentExprSyntax.self)
    }
  }
  
  public var equal: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(AssignmentExprSyntax.self)
    }
  }
  
  public var unexpectedAfterEqual: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(AssignmentExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([\Self.unexpectedBeforeEqual, \Self.equal, \Self.unexpectedAfterEqual])
  }
}

// MARK: - AssociatedTypeDeclSyntax

/// An `associatedtype` declaration
/// 
/// An example of an associatedtype declaration is
/// 
/// ```swift
/// associatedtype Item
/// ```
/// 
/// An associated type declaration may contain a type initializer clause which represents a default type assignment for the associated type.
/// 
/// ```swift
/// associatedtype Item = Int
/// ```
/// 
/// An associated type declaration may be declared with an inheritance clause which specifies the required conformances.
/// 
/// ```swift
/// associatedtype Iterator: IteratorProtocol
/// ```
/// 
/// A generic where clause may be present, here is an example which shows an associated type containing an inheritance clauses and a generic where clause.
/// 
/// ```swift
/// associatedtype Iterator: IteratorProtocol where Iterator.Element == Item
/// ```
///
/// ### Children
/// 
///  - `attributes`: ``AttributeListSyntax``
///  - `modifiers`: ``DeclModifierListSyntax``
///  - `associatedtypeKeyword`: `'associatedtype'`
///  - `name`: `<identifier>`
///  - `inheritanceClause`: ``InheritanceClauseSyntax``?
///  - `initializer`: ``TypeInitializerClauseSyntax``?
///  - `genericWhereClause`: ``GenericWhereClauseSyntax``?
public struct AssociatedTypeDeclSyntax: DeclSyntaxProtocol, SyntaxHashable, _LeafDeclSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .associatedTypeDecl else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - attributes: Attributes attached to the associated type declaration.
  ///   - modifiers: Modifiers attached to the associated type declaration.
  ///   - associatedtypeKeyword: The `associatedtype` keyword for this declaration.
  ///   - name: The name of this associated type.
  ///   - inheritanceClause: The inheritance clause describing conformances for this associated type declaration.
  ///   - initializer: The type initializer clause for this associated type declaration which represents a default type assignment for the associated type.
  ///   - genericWhereClause: The `where` clause that applies to the generic parameters of this associated type declaration.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAttributes: UnexpectedNodesSyntax? = nil,
      attributes: AttributeListSyntax = [],
      _ unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? = nil,
      modifiers: DeclModifierListSyntax = [],
      _ unexpectedBetweenModifiersAndAssociatedtypeKeyword: UnexpectedNodesSyntax? = nil,
      associatedtypeKeyword: TokenSyntax = .keyword(.associatedtype),
      _ unexpectedBetweenAssociatedtypeKeywordAndName: UnexpectedNodesSyntax? = nil,
      name: TokenSyntax,
      _ unexpectedBetweenNameAndInheritanceClause: UnexpectedNodesSyntax? = nil,
      inheritanceClause: InheritanceClauseSyntax? = nil,
      _ unexpectedBetweenInheritanceClauseAndInitializer: UnexpectedNodesSyntax? = nil,
      initializer: TypeInitializerClauseSyntax? = nil,
      _ unexpectedBetweenInitializerAndGenericWhereClause: UnexpectedNodesSyntax? = nil,
      genericWhereClause: GenericWhereClauseSyntax? = nil,
      _ unexpectedAfterGenericWhereClause: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAttributes, 
            attributes, 
            unexpectedBetweenAttributesAndModifiers, 
            modifiers, 
            unexpectedBetweenModifiersAndAssociatedtypeKeyword, 
            associatedtypeKeyword, 
            unexpectedBetweenAssociatedtypeKeywordAndName, 
            name, 
            unexpectedBetweenNameAndInheritanceClause, 
            inheritanceClause, 
            unexpectedBetweenInheritanceClauseAndInitializer, 
            initializer, 
            unexpectedBetweenInitializerAndGenericWhereClause, 
            genericWhereClause, 
            unexpectedAfterGenericWhereClause
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAttributes?.raw, 
          attributes.raw, 
          unexpectedBetweenAttributesAndModifiers?.raw, 
          modifiers.raw, 
          unexpectedBetweenModifiersAndAssociatedtypeKeyword?.raw, 
          associatedtypeKeyword.raw, 
          unexpectedBetweenAssociatedtypeKeywordAndName?.raw, 
          name.raw, 
          unexpectedBetweenNameAndInheritanceClause?.raw, 
          inheritanceClause?.raw, 
          unexpectedBetweenInheritanceClauseAndInitializer?.raw, 
          initializer?.raw, 
          unexpectedBetweenInitializerAndGenericWhereClause?.raw, 
          genericWhereClause?.raw, 
          unexpectedAfterGenericWhereClause?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.associatedTypeDecl,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }
  
  /// Attributes attached to the associated type declaration.
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> AssociatedTypeDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[1] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 1, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(AssociatedTypeDeclSyntax.self)
  }
  
  public var unexpectedBetweenAttributesAndModifiers: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }
  
  /// Modifiers attached to the associated type declaration.
  public var modifiers: DeclModifierListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(DeclModifierListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `modifiers`
  /// collection.
  ///
  /// - param element: The new `Modifier` to add to the node's
  ///                  `modifiers` collection.
  /// - returns: A copy of the receiver with the provided `Modifier`
  ///            appended to its `modifiers` collection.
  @available(*, deprecated, message: "Use node.modifiers.append(newElement) instead")
  public func addModifier(_ element: DeclModifierSyntax) -> AssociatedTypeDeclSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.declModifierList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(AssociatedTypeDeclSyntax.self)
  }
  
  public var unexpectedBetweenModifiersAndAssociatedtypeKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }
  
  /// The `associatedtype` keyword for this declaration.
  public var associatedtypeKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenAssociatedtypeKeywordAndName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }
  
  /// The name of this associated type.
  public var name: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenNameAndInheritanceClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }
  
  /// The inheritance clause describing conformances for this associated type declaration.
  public var inheritanceClause: InheritanceClauseSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(InheritanceClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenInheritanceClauseAndInitializer: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }
  
  /// The type initializer clause for this associated type declaration which represents a default type assignment for the associated type.
  public var initializer: TypeInitializerClauseSyntax? {
    get {
      return Syntax(self).child(at: 11)?.cast(TypeInitializerClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 11, with: Syntax(value), arena: SyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }
  
  public var unexpectedBetweenInitializerAndGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 12)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 12, with: Syntax(value), arena: SyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }
  
  /// The `where` clause that applies to the generic parameters of this associated type declaration.
  public var genericWhereClause: GenericWhereClauseSyntax? {
    get {
      return Syntax(self).child(at: 13)?.cast(GenericWhereClauseSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 13, with: Syntax(value), arena: SyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }
  
  public var unexpectedAfterGenericWhereClause: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 14)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 14, with: Syntax(value), arena: SyntaxArena()).cast(AssociatedTypeDeclSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAttributes, 
          \Self.attributes, 
          \Self.unexpectedBetweenAttributesAndModifiers, 
          \Self.modifiers, 
          \Self.unexpectedBetweenModifiersAndAssociatedtypeKeyword, 
          \Self.associatedtypeKeyword, 
          \Self.unexpectedBetweenAssociatedtypeKeywordAndName, 
          \Self.name, 
          \Self.unexpectedBetweenNameAndInheritanceClause, 
          \Self.inheritanceClause, 
          \Self.unexpectedBetweenInheritanceClauseAndInitializer, 
          \Self.initializer, 
          \Self.unexpectedBetweenInitializerAndGenericWhereClause, 
          \Self.genericWhereClause, 
          \Self.unexpectedAfterGenericWhereClause
        ])
  }
}

// MARK: - AttributeSyntax

/// An `@` attribute.
///
/// ### Children
/// 
///  - `atSign`: `'@'`
///  - `attributeName`: ``TypeSyntax``
///  - `leftParen`: `'('`?
///  - `arguments`: (``LabeledExprListSyntax`` | ``TokenSyntax`` | ``StringLiteralExprSyntax`` | ``AvailabilityArgumentListSyntax`` | ``SpecializeAttributeArgumentListSyntax`` | ``ObjCSelectorPieceListSyntax`` | ``ImplementsAttributeArgumentsSyntax`` | ``DifferentiableAttributeArgumentsSyntax`` | ``DerivativeAttributeArgumentsSyntax`` | ``BackDeployedAttributeArgumentsSyntax`` | ``ConventionAttributeArgumentsSyntax`` | ``ConventionWitnessMethodAttributeArgumentsSyntax`` | ``OpaqueReturnTypeOfAttributeArgumentsSyntax`` | ``ExposeAttributeArgumentsSyntax`` | ``OriginallyDefinedInAttributeArgumentsSyntax`` | ``UnderscorePrivateAttributeArgumentsSyntax`` | ``DynamicReplacementAttributeArgumentsSyntax`` | ``UnavailableFromAsyncAttributeArgumentsSyntax`` | ``EffectsAttributeArgumentListSyntax`` | ``DocumentationAttributeArgumentListSyntax``)?
///  - `rightParen`: `')'`?
///
/// ### Contained in
/// 
///  - ``AttributeListSyntax``
///  - ``SwitchCaseSyntax``.``SwitchCaseSyntax/attribute``
public struct AttributeSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Arguments: SyntaxChildChoices, SyntaxHashable {
    case `argumentList`(LabeledExprListSyntax)
    case `token`(TokenSyntax)
    case `string`(StringLiteralExprSyntax)
    case `availability`(AvailabilityArgumentListSyntax)
    case `specializeArguments`(SpecializeAttributeArgumentListSyntax)
    case `objCName`(ObjCSelectorPieceListSyntax)
    case `implementsArguments`(ImplementsAttributeArgumentsSyntax)
    case `differentiableArguments`(DifferentiableAttributeArgumentsSyntax)
    case `derivativeRegistrationArguments`(DerivativeAttributeArgumentsSyntax)
    case `backDeployedArguments`(BackDeployedAttributeArgumentsSyntax)
    case `conventionArguments`(ConventionAttributeArgumentsSyntax)
    case `conventionWitnessMethodArguments`(ConventionWitnessMethodAttributeArgumentsSyntax)
    case `opaqueReturnTypeOfAttributeArguments`(OpaqueReturnTypeOfAttributeArgumentsSyntax)
    case `exposeAttributeArguments`(ExposeAttributeArgumentsSyntax)
    case `originallyDefinedInArguments`(OriginallyDefinedInAttributeArgumentsSyntax)
    case `underscorePrivateAttributeArguments`(UnderscorePrivateAttributeArgumentsSyntax)
    case `dynamicReplacementArguments`(DynamicReplacementAttributeArgumentsSyntax)
    case `unavailableFromAsyncArguments`(UnavailableFromAsyncAttributeArgumentsSyntax)
    case `effectsArguments`(EffectsAttributeArgumentListSyntax)
    case `documentationArguments`(DocumentationAttributeArgumentListSyntax)
    
    public var _syntaxNode: Syntax {
      switch self {
      case .argumentList(let node):
        return node._syntaxNode
      case .token(let node):
        return node._syntaxNode
      case .string(let node):
        return node._syntaxNode
      case .availability(let node):
        return node._syntaxNode
      case .specializeArguments(let node):
        return node._syntaxNode
      case .objCName(let node):
        return node._syntaxNode
      case .implementsArguments(let node):
        return node._syntaxNode
      case .differentiableArguments(let node):
        return node._syntaxNode
      case .derivativeRegistrationArguments(let node):
        return node._syntaxNode
      case .backDeployedArguments(let node):
        return node._syntaxNode
      case .conventionArguments(let node):
        return node._syntaxNode
      case .conventionWitnessMethodArguments(let node):
        return node._syntaxNode
      case .opaqueReturnTypeOfAttributeArguments(let node):
        return node._syntaxNode
      case .exposeAttributeArguments(let node):
        return node._syntaxNode
      case .originallyDefinedInArguments(let node):
        return node._syntaxNode
      case .underscorePrivateAttributeArguments(let node):
        return node._syntaxNode
      case .dynamicReplacementArguments(let node):
        return node._syntaxNode
      case .unavailableFromAsyncArguments(let node):
        return node._syntaxNode
      case .effectsArguments(let node):
        return node._syntaxNode
      case .documentationArguments(let node):
        return node._syntaxNode
      }
    }
    
    public init(_ node: LabeledExprListSyntax) {
      self = .argumentList(node)
    }
    
    public init(_ node: TokenSyntax) {
      self = .token(node)
    }
    
    public init(_ node: StringLiteralExprSyntax) {
      self = .string(node)
    }
    
    public init(_ node: AvailabilityArgumentListSyntax) {
      self = .availability(node)
    }
    
    public init(_ node: SpecializeAttributeArgumentListSyntax) {
      self = .specializeArguments(node)
    }
    
    public init(_ node: ObjCSelectorPieceListSyntax) {
      self = .objCName(node)
    }
    
    public init(_ node: ImplementsAttributeArgumentsSyntax) {
      self = .implementsArguments(node)
    }
    
    public init(_ node: DifferentiableAttributeArgumentsSyntax) {
      self = .differentiableArguments(node)
    }
    
    public init(_ node: DerivativeAttributeArgumentsSyntax) {
      self = .derivativeRegistrationArguments(node)
    }
    
    public init(_ node: BackDeployedAttributeArgumentsSyntax) {
      self = .backDeployedArguments(node)
    }
    
    public init(_ node: ConventionAttributeArgumentsSyntax) {
      self = .conventionArguments(node)
    }
    
    public init(_ node: ConventionWitnessMethodAttributeArgumentsSyntax) {
      self = .conventionWitnessMethodArguments(node)
    }
    
    public init(_ node: OpaqueReturnTypeOfAttributeArgumentsSyntax) {
      self = .opaqueReturnTypeOfAttributeArguments(node)
    }
    
    public init(_ node: ExposeAttributeArgumentsSyntax) {
      self = .exposeAttributeArguments(node)
    }
    
    public init(_ node: OriginallyDefinedInAttributeArgumentsSyntax) {
      self = .originallyDefinedInArguments(node)
    }
    
    public init(_ node: UnderscorePrivateAttributeArgumentsSyntax) {
      self = .underscorePrivateAttributeArguments(node)
    }
    
    public init(_ node: DynamicReplacementAttributeArgumentsSyntax) {
      self = .dynamicReplacementArguments(node)
    }
    
    public init(_ node: UnavailableFromAsyncAttributeArgumentsSyntax) {
      self = .unavailableFromAsyncArguments(node)
    }
    
    public init(_ node: EffectsAttributeArgumentListSyntax) {
      self = .effectsArguments(node)
    }
    
    public init(_ node: DocumentationAttributeArgumentListSyntax) {
      self = .documentationArguments(node)
    }
    
    public init?(_ node: some SyntaxProtocol) {
      if let node = node.as(LabeledExprListSyntax.self) {
        self = .argumentList(node)
        return
      }
      if let node = node.as(TokenSyntax.self) {
        self = .token(node)
        return
      }
      if let node = node.as(StringLiteralExprSyntax.self) {
        self = .string(node)
        return
      }
      if let node = node.as(AvailabilityArgumentListSyntax.self) {
        self = .availability(node)
        return
      }
      if let node = node.as(SpecializeAttributeArgumentListSyntax.self) {
        self = .specializeArguments(node)
        return
      }
      if let node = node.as(ObjCSelectorPieceListSyntax.self) {
        self = .objCName(node)
        return
      }
      if let node = node.as(ImplementsAttributeArgumentsSyntax.self) {
        self = .implementsArguments(node)
        return
      }
      if let node = node.as(DifferentiableAttributeArgumentsSyntax.self) {
        self = .differentiableArguments(node)
        return
      }
      if let node = node.as(DerivativeAttributeArgumentsSyntax.self) {
        self = .derivativeRegistrationArguments(node)
        return
      }
      if let node = node.as(BackDeployedAttributeArgumentsSyntax.self) {
        self = .backDeployedArguments(node)
        return
      }
      if let node = node.as(ConventionAttributeArgumentsSyntax.self) {
        self = .conventionArguments(node)
        return
      }
      if let node = node.as(ConventionWitnessMethodAttributeArgumentsSyntax.self) {
        self = .conventionWitnessMethodArguments(node)
        return
      }
      if let node = node.as(OpaqueReturnTypeOfAttributeArgumentsSyntax.self) {
        self = .opaqueReturnTypeOfAttributeArguments(node)
        return
      }
      if let node = node.as(ExposeAttributeArgumentsSyntax.self) {
        self = .exposeAttributeArguments(node)
        return
      }
      if let node = node.as(OriginallyDefinedInAttributeArgumentsSyntax.self) {
        self = .originallyDefinedInArguments(node)
        return
      }
      if let node = node.as(UnderscorePrivateAttributeArgumentsSyntax.self) {
        self = .underscorePrivateAttributeArguments(node)
        return
      }
      if let node = node.as(DynamicReplacementAttributeArgumentsSyntax.self) {
        self = .dynamicReplacementArguments(node)
        return
      }
      if let node = node.as(UnavailableFromAsyncAttributeArgumentsSyntax.self) {
        self = .unavailableFromAsyncArguments(node)
        return
      }
      if let node = node.as(EffectsAttributeArgumentListSyntax.self) {
        self = .effectsArguments(node)
        return
      }
      if let node = node.as(DocumentationAttributeArgumentListSyntax.self) {
        self = .documentationArguments(node)
        return
      }
      return nil
    }
    
    public static var structure: SyntaxNodeStructure {
      return .choices([
            .node(LabeledExprListSyntax.self), 
            .node(TokenSyntax.self), 
            .node(StringLiteralExprSyntax.self), 
            .node(AvailabilityArgumentListSyntax.self), 
            .node(SpecializeAttributeArgumentListSyntax.self), 
            .node(ObjCSelectorPieceListSyntax.self), 
            .node(ImplementsAttributeArgumentsSyntax.self), 
            .node(DifferentiableAttributeArgumentsSyntax.self), 
            .node(DerivativeAttributeArgumentsSyntax.self), 
            .node(BackDeployedAttributeArgumentsSyntax.self), 
            .node(ConventionAttributeArgumentsSyntax.self), 
            .node(ConventionWitnessMethodAttributeArgumentsSyntax.self), 
            .node(OpaqueReturnTypeOfAttributeArgumentsSyntax.self), 
            .node(ExposeAttributeArgumentsSyntax.self), 
            .node(OriginallyDefinedInAttributeArgumentsSyntax.self), 
            .node(UnderscorePrivateAttributeArgumentsSyntax.self), 
            .node(DynamicReplacementAttributeArgumentsSyntax.self), 
            .node(UnavailableFromAsyncAttributeArgumentsSyntax.self), 
            .node(EffectsAttributeArgumentListSyntax.self), 
            .node(DocumentationAttributeArgumentListSyntax.self)
          ])
    }
  }
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .attribute else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - atSign: The `@` sign.
  ///   - attributeName: The name of the attribute.
  ///   - leftParen: If the attribute takes arguments, the opening parenthesis.
  ///   - arguments: The arguments of the attribute.
  ///   - rightParen: If the attribute takes arguments, the closing parenthesis.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAtSign: UnexpectedNodesSyntax? = nil,
      atSign: TokenSyntax = .atSignToken(),
      _ unexpectedBetweenAtSignAndAttributeName: UnexpectedNodesSyntax? = nil,
      attributeName: some TypeSyntaxProtocol,
      _ unexpectedBetweenAttributeNameAndLeftParen: UnexpectedNodesSyntax? = nil,
      leftParen: TokenSyntax? = nil,
      _ unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? = nil,
      arguments: Arguments? = nil,
      _ unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? = nil,
      rightParen: TokenSyntax? = nil,
      _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAtSign, 
            atSign, 
            unexpectedBetweenAtSignAndAttributeName, 
            attributeName, 
            unexpectedBetweenAttributeNameAndLeftParen, 
            leftParen, 
            unexpectedBetweenLeftParenAndArguments, 
            arguments, 
            unexpectedBetweenArgumentsAndRightParen, 
            rightParen, 
            unexpectedAfterRightParen
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAtSign?.raw, 
          atSign.raw, 
          unexpectedBetweenAtSignAndAttributeName?.raw, 
          attributeName.raw, 
          unexpectedBetweenAttributeNameAndLeftParen?.raw, 
          leftParen?.raw, 
          unexpectedBetweenLeftParenAndArguments?.raw, 
          arguments?.raw, 
          unexpectedBetweenArgumentsAndRightParen?.raw, 
          rightParen?.raw, 
          unexpectedAfterRightParen?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.attribute,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAtSign: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(AttributeSyntax.self)
    }
  }
  
  /// The `@` sign.
  public var atSign: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(AttributeSyntax.self)
    }
  }
  
  public var unexpectedBetweenAtSignAndAttributeName: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(AttributeSyntax.self)
    }
  }
  
  /// The name of the attribute.
  public var attributeName: TypeSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(AttributeSyntax.self)
    }
  }
  
  public var unexpectedBetweenAttributeNameAndLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(AttributeSyntax.self)
    }
  }
  
  /// If the attribute takes arguments, the opening parenthesis.
  public var leftParen: TokenSyntax? {
    get {
      return Syntax(self).child(at: 5)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(AttributeSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftParenAndArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(AttributeSyntax.self)
    }
  }
  
  /// The arguments of the attribute.
  /// 
  /// In case of user-defined attributes, such as macros, property wrappers or result builders,
  /// this is always either an `argumentList` of type ``LabeledExprListSyntax`` or `nil`.
  public var arguments: Arguments? {
    get {
      return Syntax(self).child(at: 7)?.cast(Arguments.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(AttributeSyntax.self)
    }
  }
  
  public var unexpectedBetweenArgumentsAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(AttributeSyntax.self)
    }
  }
  
  /// If the attribute takes arguments, the closing parenthesis.
  public var rightParen: TokenSyntax? {
    get {
      return Syntax(self).child(at: 9)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 9, with: Syntax(value), arena: SyntaxArena()).cast(AttributeSyntax.self)
    }
  }
  
  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 10)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 10, with: Syntax(value), arena: SyntaxArena()).cast(AttributeSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAtSign, 
          \Self.atSign, 
          \Self.unexpectedBetweenAtSignAndAttributeName, 
          \Self.attributeName, 
          \Self.unexpectedBetweenAttributeNameAndLeftParen, 
          \Self.leftParen, 
          \Self.unexpectedBetweenLeftParenAndArguments, 
          \Self.arguments, 
          \Self.unexpectedBetweenArgumentsAndRightParen, 
          \Self.rightParen, 
          \Self.unexpectedAfterRightParen
        ])
  }
}

// MARK: - AttributedTypeSyntax

/// ### Children
/// 
///  - `specifier`: (`'inout'` | `'__shared'` | `'__owned'` | `'isolated'` | `'_const'` | `'borrowing'` | `'consuming'`)?
///  - `attributes`: ``AttributeListSyntax``
///  - `baseType`: ``TypeSyntax``
public struct AttributedTypeSyntax: TypeSyntaxProtocol, SyntaxHashable, _LeafTypeSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .attributedType else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeSpecifier: UnexpectedNodesSyntax? = nil,
      specifier: TokenSyntax? = nil,
      _ unexpectedBetweenSpecifierAndAttributes: UnexpectedNodesSyntax? = nil,
      attributes: AttributeListSyntax = [],
      _ unexpectedBetweenAttributesAndBaseType: UnexpectedNodesSyntax? = nil,
      baseType: some TypeSyntaxProtocol,
      _ unexpectedAfterBaseType: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeSpecifier, 
            specifier, 
            unexpectedBetweenSpecifierAndAttributes, 
            attributes, 
            unexpectedBetweenAttributesAndBaseType, 
            baseType, 
            unexpectedAfterBaseType
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeSpecifier?.raw, 
          specifier?.raw, 
          unexpectedBetweenSpecifierAndAttributes?.raw, 
          attributes.raw, 
          unexpectedBetweenAttributesAndBaseType?.raw, 
          baseType.raw, 
          unexpectedAfterBaseType?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.attributedType,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeSpecifier: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(AttributedTypeSyntax.self)
    }
  }
  
  public var specifier: TokenSyntax? {
    get {
      return Syntax(self).child(at: 1)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(AttributedTypeSyntax.self)
    }
  }
  
  public var unexpectedBetweenSpecifierAndAttributes: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(AttributedTypeSyntax.self)
    }
  }
  
  public var attributes: AttributeListSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(AttributeListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(AttributedTypeSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `attributes`
  /// collection.
  ///
  /// - param element: The new `Attribute` to add to the node's
  ///                  `attributes` collection.
  /// - returns: A copy of the receiver with the provided `Attribute`
  ///            appended to its `attributes` collection.
  @available(*, deprecated, message: "Use node.attributes.append(newElement) instead")
  public func addAttribute(_ element: Syntax) -> AttributedTypeSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[3] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.attributeList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 3, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(AttributedTypeSyntax.self)
  }
  
  public var unexpectedBetweenAttributesAndBaseType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(AttributedTypeSyntax.self)
    }
  }
  
  public var baseType: TypeSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(TypeSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(AttributedTypeSyntax.self)
    }
  }
  
  public var unexpectedAfterBaseType: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(AttributedTypeSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeSpecifier, 
          \Self.specifier, 
          \Self.unexpectedBetweenSpecifierAndAttributes, 
          \Self.attributes, 
          \Self.unexpectedBetweenAttributesAndBaseType, 
          \Self.baseType, 
          \Self.unexpectedAfterBaseType
        ])
  }
}

// MARK: - AvailabilityArgumentSyntax

/// A single argument to an `@available` argument like `*`, `iOS 10.1`, or `message: "This has been deprecated"`.
///
/// ### Children
/// 
///  - `argument`: ((`<binaryOperator>` | `<identifier>`) | ``PlatformVersionSyntax`` | ``AvailabilityLabeledArgumentSyntax``)
///  - `trailingComma`: `','`?
///
/// ### Contained in
/// 
///  - ``AvailabilityArgumentListSyntax``
public struct AvailabilityArgumentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Argument: SyntaxChildChoices, SyntaxHashable {
    case `token`(TokenSyntax)
    case `availabilityVersionRestriction`(PlatformVersionSyntax)
    case `availabilityLabeledArgument`(AvailabilityLabeledArgumentSyntax)
    
    public var _syntaxNode: Syntax {
      switch self {
      case .token(let node):
        return node._syntaxNode
      case .availabilityVersionRestriction(let node):
        return node._syntaxNode
      case .availabilityLabeledArgument(let node):
        return node._syntaxNode
      }
    }
    
    public init(_ node: TokenSyntax) {
      self = .token(node)
    }
    
    public init(_ node: PlatformVersionSyntax) {
      self = .availabilityVersionRestriction(node)
    }
    
    public init(_ node: AvailabilityLabeledArgumentSyntax) {
      self = .availabilityLabeledArgument(node)
    }
    
    public init?(_ node: some SyntaxProtocol) {
      if let node = node.as(TokenSyntax.self) {
        self = .token(node)
        return
      }
      if let node = node.as(PlatformVersionSyntax.self) {
        self = .availabilityVersionRestriction(node)
        return
      }
      if let node = node.as(AvailabilityLabeledArgumentSyntax.self) {
        self = .availabilityLabeledArgument(node)
        return
      }
      return nil
    }
    
    public static var structure: SyntaxNodeStructure {
      return .choices([.node(TokenSyntax.self), .node(PlatformVersionSyntax.self), .node(AvailabilityLabeledArgumentSyntax.self)])
    }
  }
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .availabilityArgument else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - argument: The actual argument
  ///   - trailingComma: A trailing comma if the argument is followed by another argument
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeArgument: UnexpectedNodesSyntax? = nil,
      argument: Argument,
      _ unexpectedBetweenArgumentAndTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingComma: TokenSyntax? = nil,
      _ unexpectedAfterTrailingComma: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeArgument, 
            argument, 
            unexpectedBetweenArgumentAndTrailingComma, 
            trailingComma, 
            unexpectedAfterTrailingComma
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeArgument?.raw, 
          argument.raw, 
          unexpectedBetweenArgumentAndTrailingComma?.raw, 
          trailingComma?.raw, 
          unexpectedAfterTrailingComma?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.availabilityArgument,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeArgument: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityArgumentSyntax.self)
    }
  }
  
  /// The actual argument
  public var argument: Argument {
    get {
      return Syntax(self).child(at: 1)!.cast(Argument.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityArgumentSyntax.self)
    }
  }
  
  public var unexpectedBetweenArgumentAndTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityArgumentSyntax.self)
    }
  }
  
  /// A trailing comma if the argument is followed by another argument
  public var trailingComma: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityArgumentSyntax.self)
    }
  }
  
  public var unexpectedAfterTrailingComma: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityArgumentSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeArgument, 
          \Self.argument, 
          \Self.unexpectedBetweenArgumentAndTrailingComma, 
          \Self.trailingComma, 
          \Self.unexpectedAfterTrailingComma
        ])
  }
}

// MARK: - AvailabilityConditionSyntax

/// ### Children
/// 
///  - `availabilityKeyword`: (`'#available'` | `'#unavailable'`)
///  - `leftParen`: `'('`
///  - `availabilityArguments`: ``AvailabilityArgumentListSyntax``
///  - `rightParen`: `')'`
///
/// ### Contained in
/// 
///  - ``ConditionElementSyntax``.``ConditionElementSyntax/condition``
public struct AvailabilityConditionSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .availabilityCondition else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAvailabilityKeyword: UnexpectedNodesSyntax? = nil,
      availabilityKeyword: TokenSyntax,
      _ unexpectedBetweenAvailabilityKeywordAndLeftParen: UnexpectedNodesSyntax? = nil,
      leftParen: TokenSyntax = .leftParenToken(),
      _ unexpectedBetweenLeftParenAndAvailabilityArguments: UnexpectedNodesSyntax? = nil,
      availabilityArguments: AvailabilityArgumentListSyntax,
      _ unexpectedBetweenAvailabilityArgumentsAndRightParen: UnexpectedNodesSyntax? = nil,
      rightParen: TokenSyntax = .rightParenToken(),
      _ unexpectedAfterRightParen: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAvailabilityKeyword, 
            availabilityKeyword, 
            unexpectedBetweenAvailabilityKeywordAndLeftParen, 
            leftParen, 
            unexpectedBetweenLeftParenAndAvailabilityArguments, 
            availabilityArguments, 
            unexpectedBetweenAvailabilityArgumentsAndRightParen, 
            rightParen, 
            unexpectedAfterRightParen
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAvailabilityKeyword?.raw, 
          availabilityKeyword.raw, 
          unexpectedBetweenAvailabilityKeywordAndLeftParen?.raw, 
          leftParen.raw, 
          unexpectedBetweenLeftParenAndAvailabilityArguments?.raw, 
          availabilityArguments.raw, 
          unexpectedBetweenAvailabilityArgumentsAndRightParen?.raw, 
          rightParen.raw, 
          unexpectedAfterRightParen?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.availabilityCondition,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAvailabilityKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }
  
  public var availabilityKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }
  
  public var unexpectedBetweenAvailabilityKeywordAndLeftParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }
  
  public var leftParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }
  
  public var unexpectedBetweenLeftParenAndAvailabilityArguments: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }
  
  public var availabilityArguments: AvailabilityArgumentListSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(AvailabilityArgumentListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `availabilityArguments`
  /// collection.
  ///
  /// - param element: The new `AvailabilityArgument` to add to the node's
  ///                  `availabilityArguments` collection.
  /// - returns: A copy of the receiver with the provided `AvailabilityArgument`
  ///            appended to its `availabilityArguments` collection.
  @available(*, deprecated, message: "Use node.availabilityArguments.append(newElement) instead")
  public func addAvailabilityArgument(_ element: AvailabilityArgumentSyntax) -> AvailabilityConditionSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[5] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.availabilityArgumentList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 5, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(AvailabilityConditionSyntax.self)
  }
  
  public var unexpectedBetweenAvailabilityArgumentsAndRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }
  
  public var rightParen: TokenSyntax {
    get {
      return Syntax(self).child(at: 7)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 7, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }
  
  public var unexpectedAfterRightParen: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 8)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 8, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityConditionSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAvailabilityKeyword, 
          \Self.availabilityKeyword, 
          \Self.unexpectedBetweenAvailabilityKeywordAndLeftParen, 
          \Self.leftParen, 
          \Self.unexpectedBetweenLeftParenAndAvailabilityArguments, 
          \Self.availabilityArguments, 
          \Self.unexpectedBetweenAvailabilityArgumentsAndRightParen, 
          \Self.rightParen, 
          \Self.unexpectedAfterRightParen
        ])
  }
}

// MARK: - AvailabilityLabeledArgumentSyntax

/// An argument to an `@available` attribute that consists of a label and a value, e.g. `message: "This has been deprecated"`.
///
/// ### Children
/// 
///  - `label`: (`'message'` | `'renamed'` | `'introduced'` | `'obsoleted'` | `'deprecated'`)
///  - `colon`: `':'`
///  - `value`: (``SimpleStringLiteralExprSyntax`` | ``VersionTupleSyntax``)
///
/// ### Contained in
/// 
///  - ``AvailabilityArgumentSyntax``.``AvailabilityArgumentSyntax/argument``
public struct AvailabilityLabeledArgumentSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public enum Value: SyntaxChildChoices, SyntaxHashable {
    case `string`(SimpleStringLiteralExprSyntax)
    case `version`(VersionTupleSyntax)
    
    public var _syntaxNode: Syntax {
      switch self {
      case .string(let node):
        return node._syntaxNode
      case .version(let node):
        return node._syntaxNode
      }
    }
    
    public init(_ node: SimpleStringLiteralExprSyntax) {
      self = .string(node)
    }
    
    public init(_ node: VersionTupleSyntax) {
      self = .version(node)
    }
    
    public init?(_ node: some SyntaxProtocol) {
      if let node = node.as(SimpleStringLiteralExprSyntax.self) {
        self = .string(node)
        return
      }
      if let node = node.as(VersionTupleSyntax.self) {
        self = .version(node)
        return
      }
      return nil
    }
    
    public static var structure: SyntaxNodeStructure {
      return .choices([.node(SimpleStringLiteralExprSyntax.self), .node(VersionTupleSyntax.self)])
    }
  }
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .availabilityLabeledArgument else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - label: The label of the argument
  ///   - colon: The colon separating label and value
  ///   - value: The value of this labeled argument
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLabel: UnexpectedNodesSyntax? = nil,
      label: TokenSyntax,
      _ unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax = .colonToken(),
      _ unexpectedBetweenColonAndValue: UnexpectedNodesSyntax? = nil,
      value: Value,
      _ unexpectedAfterValue: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeLabel, 
            label, 
            unexpectedBetweenLabelAndColon, 
            colon, 
            unexpectedBetweenColonAndValue, 
            value, 
            unexpectedAfterValue
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeLabel?.raw, 
          label.raw, 
          unexpectedBetweenLabelAndColon?.raw, 
          colon.raw, 
          unexpectedBetweenColonAndValue?.raw, 
          value.raw, 
          unexpectedAfterValue?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.availabilityLabeledArgument,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityLabeledArgumentSyntax.self)
    }
  }
  
  /// The label of the argument
  public var label: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityLabeledArgumentSyntax.self)
    }
  }
  
  public var unexpectedBetweenLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityLabeledArgumentSyntax.self)
    }
  }
  
  /// The colon separating label and value
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityLabeledArgumentSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityLabeledArgumentSyntax.self)
    }
  }
  
  /// The value of this labeled argument
  public var value: Value {
    get {
      return Syntax(self).child(at: 5)!.cast(Value.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityLabeledArgumentSyntax.self)
    }
  }
  
  public var unexpectedAfterValue: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(AvailabilityLabeledArgumentSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeLabel, 
          \Self.label, 
          \Self.unexpectedBetweenLabelAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndValue, 
          \Self.value, 
          \Self.unexpectedAfterValue
        ])
  }
}

// MARK: - AwaitExprSyntax

/// ### Children
/// 
///  - `awaitKeyword`: `'await'`
///  - `expression`: ``ExprSyntax``
public struct AwaitExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .awaitExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeAwaitKeyword: UnexpectedNodesSyntax? = nil,
      awaitKeyword: TokenSyntax = .keyword(.await),
      _ unexpectedBetweenAwaitKeywordAndExpression: UnexpectedNodesSyntax? = nil,
      expression: some ExprSyntaxProtocol,
      _ unexpectedAfterExpression: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeAwaitKeyword, 
            awaitKeyword, 
            unexpectedBetweenAwaitKeywordAndExpression, 
            expression, 
            unexpectedAfterExpression
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeAwaitKeyword?.raw, 
          awaitKeyword.raw, 
          unexpectedBetweenAwaitKeywordAndExpression?.raw, 
          expression.raw, 
          unexpectedAfterExpression?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.awaitExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeAwaitKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(AwaitExprSyntax.self)
    }
  }
  
  public var awaitKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(AwaitExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenAwaitKeywordAndExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(AwaitExprSyntax.self)
    }
  }
  
  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(AwaitExprSyntax.self)
    }
  }
  
  public var unexpectedAfterExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(AwaitExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeAwaitKeyword, 
          \Self.awaitKeyword, 
          \Self.unexpectedBetweenAwaitKeywordAndExpression, 
          \Self.expression, 
          \Self.unexpectedAfterExpression
        ])
  }
}

// MARK: - BackDeployedAttributeArgumentsSyntax

/// A collection of arguments for the `@backDeployed` attribute
///
/// ### Children
/// 
///  - `beforeLabel`: `'before'`
///  - `colon`: `':'`
///  - `platforms`: ``PlatformVersionItemListSyntax``
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct BackDeployedAttributeArgumentsSyntax: SyntaxProtocol, SyntaxHashable, _LeafSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .backDeployedAttributeArguments else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - beforeLabel: The "before" label.
  ///   - colon: The colon separating "before" and the parameter list.
  ///   - platforms: The list of OS versions in which the declaration became ABI stable.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeBeforeLabel: UnexpectedNodesSyntax? = nil,
      beforeLabel: TokenSyntax = .keyword(.before),
      _ unexpectedBetweenBeforeLabelAndColon: UnexpectedNodesSyntax? = nil,
      colon: TokenSyntax = .colonToken(),
      _ unexpectedBetweenColonAndPlatforms: UnexpectedNodesSyntax? = nil,
      platforms: PlatformVersionItemListSyntax,
      _ unexpectedAfterPlatforms: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeBeforeLabel, 
            beforeLabel, 
            unexpectedBetweenBeforeLabelAndColon, 
            colon, 
            unexpectedBetweenColonAndPlatforms, 
            platforms, 
            unexpectedAfterPlatforms
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeBeforeLabel?.raw, 
          beforeLabel.raw, 
          unexpectedBetweenBeforeLabelAndColon?.raw, 
          colon.raw, 
          unexpectedBetweenColonAndPlatforms?.raw, 
          platforms.raw, 
          unexpectedAfterPlatforms?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.backDeployedAttributeArguments,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeBeforeLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(BackDeployedAttributeArgumentsSyntax.self)
    }
  }
  
  /// The "before" label.
  public var beforeLabel: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(BackDeployedAttributeArgumentsSyntax.self)
    }
  }
  
  public var unexpectedBetweenBeforeLabelAndColon: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(BackDeployedAttributeArgumentsSyntax.self)
    }
  }
  
  /// The colon separating "before" and the parameter list.
  public var colon: TokenSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(BackDeployedAttributeArgumentsSyntax.self)
    }
  }
  
  public var unexpectedBetweenColonAndPlatforms: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(BackDeployedAttributeArgumentsSyntax.self)
    }
  }
  
  /// The list of OS versions in which the declaration became ABI stable.
  public var platforms: PlatformVersionItemListSyntax {
    get {
      return Syntax(self).child(at: 5)!.cast(PlatformVersionItemListSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 5, with: Syntax(value), arena: SyntaxArena()).cast(BackDeployedAttributeArgumentsSyntax.self)
    }
  }
  
  /// Adds the provided `element` to the node's `platforms`
  /// collection.
  ///
  /// - param element: The new `Platform` to add to the node's
  ///                  `platforms` collection.
  /// - returns: A copy of the receiver with the provided `Platform`
  ///            appended to its `platforms` collection.
  @available(*, deprecated, message: "Use node.platforms.append(newElement) instead")
  public func addPlatform(_ element: PlatformVersionItemSyntax) -> BackDeployedAttributeArgumentsSyntax {
    var collection: RawSyntax
    let arena = SyntaxArena()
    if let col = raw.layoutView!.children[5] {
      collection = col.layoutView!.appending(element.raw, arena: arena)
    } else {
      collection = RawSyntax.makeLayout(kind: SyntaxKind.platformVersionItemList,
                                        from: [element.raw], arena: arena)
    }
    return Syntax(self)
      .replacingChild(
        at: 5, 
        with: collection, 
        rawNodeArena: arena, 
        allocationArena: arena
      )
      .cast(BackDeployedAttributeArgumentsSyntax.self)
  }
  
  public var unexpectedAfterPlatforms: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 6)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 6, with: Syntax(value), arena: SyntaxArena()).cast(BackDeployedAttributeArgumentsSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeBeforeLabel, 
          \Self.beforeLabel, 
          \Self.unexpectedBetweenBeforeLabelAndColon, 
          \Self.colon, 
          \Self.unexpectedBetweenColonAndPlatforms, 
          \Self.platforms, 
          \Self.unexpectedAfterPlatforms
        ])
  }
}

// MARK: - BinaryOperatorExprSyntax

/// ### Children
/// 
///  - `operator`: `<binaryOperator>`
public struct BinaryOperatorExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .binaryOperatorExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeOperator: UnexpectedNodesSyntax? = nil,
      operator: TokenSyntax,
      _ unexpectedAfterOperator: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (unexpectedBeforeOperator, `operator`, unexpectedAfterOperator))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeOperator?.raw, `operator`.raw, unexpectedAfterOperator?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.binaryOperatorExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeOperator: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(BinaryOperatorExprSyntax.self)
    }
  }
  
  public var `operator`: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(BinaryOperatorExprSyntax.self)
    }
  }
  
  public var unexpectedAfterOperator: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(BinaryOperatorExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([\Self.unexpectedBeforeOperator, \Self.operator, \Self.unexpectedAfterOperator])
  }
}

// MARK: - BooleanLiteralExprSyntax

/// ### Children
/// 
///  - `literal`: (`'true'` | `'false'`)
public struct BooleanLiteralExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .booleanLiteralExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeLiteral: UnexpectedNodesSyntax? = nil,
      literal: TokenSyntax,
      _ unexpectedAfterLiteral: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (unexpectedBeforeLiteral, literal, unexpectedAfterLiteral))) { (arena, _) in
      let layout: [RawSyntax?] = [unexpectedBeforeLiteral?.raw, literal.raw, unexpectedAfterLiteral?.raw]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.booleanLiteralExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeLiteral: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(BooleanLiteralExprSyntax.self)
    }
  }
  
  public var literal: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(BooleanLiteralExprSyntax.self)
    }
  }
  
  public var unexpectedAfterLiteral: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(BooleanLiteralExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([\Self.unexpectedBeforeLiteral, \Self.literal, \Self.unexpectedAfterLiteral])
  }
}

// MARK: - BorrowExprSyntax

/// ### Children
/// 
///  - `borrowKeyword`: `'_borrow'`
///  - `expression`: ``ExprSyntax``
public struct BorrowExprSyntax: ExprSyntaxProtocol, SyntaxHashable, _LeafExprSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .borrowExpr else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeBorrowKeyword: UnexpectedNodesSyntax? = nil,
      borrowKeyword: TokenSyntax = .keyword(._borrow),
      _ unexpectedBetweenBorrowKeywordAndExpression: UnexpectedNodesSyntax? = nil,
      expression: some ExprSyntaxProtocol,
      _ unexpectedAfterExpression: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeBorrowKeyword, 
            borrowKeyword, 
            unexpectedBetweenBorrowKeywordAndExpression, 
            expression, 
            unexpectedAfterExpression
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeBorrowKeyword?.raw, 
          borrowKeyword.raw, 
          unexpectedBetweenBorrowKeywordAndExpression?.raw, 
          expression.raw, 
          unexpectedAfterExpression?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.borrowExpr,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeBorrowKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(BorrowExprSyntax.self)
    }
  }
  
  public var borrowKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(BorrowExprSyntax.self)
    }
  }
  
  public var unexpectedBetweenBorrowKeywordAndExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(BorrowExprSyntax.self)
    }
  }
  
  public var expression: ExprSyntax {
    get {
      return Syntax(self).child(at: 3)!.cast(ExprSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(BorrowExprSyntax.self)
    }
  }
  
  public var unexpectedAfterExpression: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(BorrowExprSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeBorrowKeyword, 
          \Self.borrowKeyword, 
          \Self.unexpectedBetweenBorrowKeywordAndExpression, 
          \Self.expression, 
          \Self.unexpectedAfterExpression
        ])
  }
}

// MARK: - BreakStmtSyntax

/// ### Children
/// 
///  - `breakKeyword`: `'break'`
///  - `label`: `<identifier>`?
public struct BreakStmtSyntax: StmtSyntaxProtocol, SyntaxHashable, _LeafStmtSyntaxNodeProtocol {
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .breakStmt else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  /// - Parameters:
  ///   - leadingTrivia: Trivia to be prepended to the leading trivia of the node’s first token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  ///   - trailingTrivia: Trivia to be appended to the trailing trivia of the node’s last token. If the node is empty, there is no token to attach the trivia to and the parameter is ignored.
  public init(
      leadingTrivia: Trivia? = nil,
      _ unexpectedBeforeBreakKeyword: UnexpectedNodesSyntax? = nil,
      breakKeyword: TokenSyntax = .keyword(.break),
      _ unexpectedBetweenBreakKeywordAndLabel: UnexpectedNodesSyntax? = nil,
      label: TokenSyntax? = nil,
      _ unexpectedAfterLabel: UnexpectedNodesSyntax? = nil,
      trailingTrivia: Trivia? = nil
    
  ) {
    // Extend the lifetime of all parameters so their arenas don't get destroyed
    // before they can be added as children of the new arena.
    self = withExtendedLifetime((SyntaxArena(), (
            unexpectedBeforeBreakKeyword, 
            breakKeyword, 
            unexpectedBetweenBreakKeywordAndLabel, 
            label, 
            unexpectedAfterLabel
          ))) { (arena, _) in
      let layout: [RawSyntax?] = [
          unexpectedBeforeBreakKeyword?.raw, 
          breakKeyword.raw, 
          unexpectedBetweenBreakKeywordAndLabel?.raw, 
          label?.raw, 
          unexpectedAfterLabel?.raw
        ]
      let raw = RawSyntax.makeLayout(
        kind: SyntaxKind.breakStmt,
        from: layout,
        arena: arena,
        leadingTrivia: leadingTrivia,
        trailingTrivia: trailingTrivia
        
      )
      return Syntax.forRoot(raw, rawNodeArena: arena).cast(Self.self)
    }
  }
  
  public var unexpectedBeforeBreakKeyword: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 0)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 0, with: Syntax(value), arena: SyntaxArena()).cast(BreakStmtSyntax.self)
    }
  }
  
  public var breakKeyword: TokenSyntax {
    get {
      return Syntax(self).child(at: 1)!.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 1, with: Syntax(value), arena: SyntaxArena()).cast(BreakStmtSyntax.self)
    }
  }
  
  public var unexpectedBetweenBreakKeywordAndLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 2)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 2, with: Syntax(value), arena: SyntaxArena()).cast(BreakStmtSyntax.self)
    }
  }
  
  public var label: TokenSyntax? {
    get {
      return Syntax(self).child(at: 3)?.cast(TokenSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 3, with: Syntax(value), arena: SyntaxArena()).cast(BreakStmtSyntax.self)
    }
  }
  
  public var unexpectedAfterLabel: UnexpectedNodesSyntax? {
    get {
      return Syntax(self).child(at: 4)?.cast(UnexpectedNodesSyntax.self)
    }
    set(value) {
      self = Syntax(self).replacingChild(at: 4, with: Syntax(value), arena: SyntaxArena()).cast(BreakStmtSyntax.self)
    }
  }
  
  public static var structure: SyntaxNodeStructure {
    return .layout([
          \Self.unexpectedBeforeBreakKeyword, 
          \Self.breakKeyword, 
          \Self.unexpectedBetweenBreakKeywordAndLabel, 
          \Self.label, 
          \Self.unexpectedAfterLabel
        ])
  }
}
