//// Automatically generated by generate-swift-syntax
//// Do not edit directly!
//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

/// Check that the `layout` is valid for the given 'SyntaxKind'.
///
/// Note that this only validates the immediate children.
/// Results in an assertion failure if the layout is invalid.
func validateLayout(layout: RawSyntaxBuffer, as kind: SyntaxKind) {
  #if SWIFTSYNTAX_ENABLE_RAWSYNTAX_VALIDATION
  enum TokenChoice: CustomStringConvertible {
    case keyword(StaticString)
    case tokenKind(RawTokenKind)
    

    var description: String {
      switch self {
      case .keyword(let keyword):
        return "keyword('\(keyword)')"
      case .tokenKind(let kind):
        return "\(kind)"
      }
    }
  }
  enum ValidationError: CustomStringConvertible {
    case expectedNonNil(expectedKind: RawSyntaxNodeProtocol.Type, file: StaticString, line: UInt)
    case kindMismatch(expectedKind: RawSyntaxNodeProtocol.Type, actualKind: SyntaxKind, file: StaticString, line: UInt)
    case tokenMismatch(expectedTokenChoices: [TokenChoice], actualKind: RawTokenKind, actualText: SyntaxText, file: StaticString, line: UInt)
    

    var description: String {
      switch self {
      case .expectedNonNil(expectedKind: let expectedKind, file: _, line: _):
        return "Expected non-nil node of type \(expectedKind) but received nil"
      case .kindMismatch(
          expectedKind: let expectedKind, 
          actualKind: let actualKind, 
          file: _, 
          line: _
        ):
        return "Expected node of type \(expectedKind) but received \(actualKind)"
      case .tokenMismatch(
          expectedTokenChoices: let tokenChoices, 
          actualKind: let actualKind, 
          actualText: let actualText, 
          file: _, 
          line: _
        ):
        return "Expected token with one of \(tokenChoices) but received \(actualKind) with text '\(actualText)'"
      }
    }
    

    var fileAndLine: (StaticString, UInt) {
      switch self {
      case .expectedNonNil(expectedKind: _, file: let file, line: let line):
        return (file, line)
      case .kindMismatch(
          expectedKind: _, 
          actualKind: _, 
          file: let file, 
          line: let line
        ):
        return (file, line)
      case .tokenMismatch(
          expectedTokenChoices: _, 
          actualKind: _, 
          actualText: _, 
          file: let file, 
          line: let line
        ):
        return (file, line)
      }
    }
  }
  func verify<Node: RawSyntaxNodeProtocol>(
      _ raw: RawSyntax?, 
      as _: Node.Type, 
      file: StaticString = #file, 
      line: UInt = #line
    ) -> ValidationError? {
    guard let raw = raw else {
      return .expectedNonNil(expectedKind: Node.self, file: file, line: line)
    }
    guard Node.isKindOf(raw) else {
      return .kindMismatch(
          expectedKind: Node.self, 
          actualKind: raw.kind, 
          file: file, 
          line: line
        )
    }
    return nil
  }
  func verify<Node: RawSyntaxNodeProtocol>(
      _ raw: RawSyntax?, 
      as _: Node?.Type, 
      file: StaticString = #file, 
      line: UInt = #line
    ) -> ValidationError? {
    if raw != nil {
      return verify(
          raw, 
          as: Node.self, 
          file: file, 
          line: line
        )
    }
    return nil
  }
  func verify(
      _ raw: RawSyntax?, 
      as _: RawTokenSyntax?.Type, 
      tokenChoices: [TokenChoice], 
      file: StaticString = #file, 
      line: UInt = #line
    ) -> ValidationError? {
    // Validation of token choice is currently causing assertion failures where
    // the list of expected token choices in the syntax tree doesn't match those
    // the parser generates. Disable the verification for now until all issues
    // regarding it are fixed.
    if raw != nil {
      return verify(
          raw, 
          as: RawTokenSyntax.self, 
          tokenChoices: tokenChoices, 
          file: file, 
          line: line
        )
    }
    return nil
  }
  func verify(
      _ raw: RawSyntax?, 
      as _: RawTokenSyntax.Type, 
      tokenChoices: [TokenChoice], 
      file: StaticString = #file, 
      line: UInt = #line
    ) -> ValidationError? {
    // Validation of token choice is currently causing assertion failures where
    // the list of expected token choices in the syntax tree doesn't match those
    // the parser generates. Disable the verification for now until all issues
    // regarding it are fixed.
    guard let raw = raw else {
      return .expectedNonNil(expectedKind: RawTokenSyntax.self, file: file, line: line)
    }
    if let error = verify(raw, as: RawTokenSyntax?.self) {
      return error
    }
    let tokenView = raw.tokenView!
    for tokenChoice in tokenChoices {
      switch tokenChoice {
      case .tokenKind(let tokenKind):
        if raw.tokenView?.rawKind == tokenKind {
          return nil
        }
      case .keyword(let keyword):
        if tokenView.rawKind == .keyword && tokenView.rawText == SyntaxText(keyword) {
          return nil
        }
      }
    }
    return ValidationError.tokenMismatch(
        expectedTokenChoices: tokenChoices, 
        actualKind: tokenView.rawKind, 
        actualText: tokenView.rawText, 
        file: file, 
        line: line
      )
  }
  func assertNoError(_ nodeKind: SyntaxKind, _ index: Int, _ error: ValidationError?) {
    if let error {
      let (file, line) = error.fileAndLine
      assertionFailure("""
        Error validating child at index \(index) of \(nodeKind):
        \(error.description)
        """, file: file, line: line)
    }
  }
  func assertAnyHasNoError(_ nodeKind: SyntaxKind, _ index: Int, _ errors: [ValidationError?]) {
    let nonNilErrors = errors.compactMap({
        $0
      })
    if nonNilErrors.count == errors.count, let firstError = nonNilErrors.first {
      let (file, line) = firstError.fileAndLine
      assertionFailure("""
        Error validating child at index \(index) of \(nodeKind):
        Node did not satisfy any node choice requirement.
        Validation failures:
        \(nonNilErrors.map({ "- \($0.description)" }).joined(separator: "\n"))
        """, file: file, line: line)
      _ = 1
    }
  }
  switch kind {
  case .token:
    assertionFailure("validateLayout for .token kind is not supported")
  case .accessorBlock:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftBrace)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 3, [
        verify(layout[3], as: RawSyntax.self)])
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightBrace)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .accessorDeclList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawAccessorDeclSyntax.self))
    }
  case .accessorDecl:
    assert(layout.count == 13)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [
            .keyword("get"), 
            .keyword("set"), 
            .keyword("didSet"), 
            .keyword("willSet"), 
            .keyword("unsafeAddress"), 
            .keyword("addressWithOwner"), 
            .keyword("addressWithNativeOwner"), 
            .keyword("unsafeMutableAddress"), 
            .keyword("mutableAddressWithOwner"), 
            .keyword("mutableAddressWithNativeOwner"), 
            .keyword("_read"), 
            .keyword("_modify"), 
            .keyword("init")
          ]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawAccessorParametersSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawAccessorEffectSpecifiersSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawCodeBlockSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
  case .accessorEffectSpecifiers:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.keyword("async")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.keyword("throws")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .accessorParameters:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .actorDecl:
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("actor")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawInheritanceClauseSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawMemberBlockSyntax.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  case .arrayElementList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawArrayElementSyntax.self))
    }
  case .arrayElement:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .arrayExpr:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftSquare)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawArrayElementListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightSquare)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .arrayType:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftSquare)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightSquare)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .arrowExpr:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeEffectSpecifiersSyntax?.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.arrow)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .asExpr:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.keyword("as")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.postfixQuestionMark), .tokenKind(.exclamationMark)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTypeSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .assignmentExpr:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.equal)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .associatedTypeDecl:
    assert(layout.count == 15)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("associatedtype")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawInheritanceClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTypeInitializerClauseSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
  case .attributeList:
    for (index, element) in layout.enumerated() {
      assertAnyHasNoError(kind, index, [
          verify(element, as: RawAttributeSyntax.self),
          verify(element, as: RawIfConfigDeclSyntax.self)])
    }
  case .attribute:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.atSign)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 7, [
        verify(layout[7], as: RawSyntax?.self)])
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .attributedType:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [
            .keyword("inout"), 
            .keyword("__shared"), 
            .keyword("__owned"), 
            .keyword("isolated"), 
            .keyword("_const"), 
            .keyword("borrowing"), 
            .keyword("consuming")
          ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawAttributeListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTypeSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .availabilityArgumentList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawAvailabilityArgumentSyntax.self))
    }
  case .availabilityArgument:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 1, [
        verify(layout[1], as: RawSyntax.self)])
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .availabilityCondition:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.poundAvailable), .tokenKind(.poundUnavailable)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawAvailabilityArgumentListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .availabilityLabeledArgument:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
            .keyword("message"), 
            .keyword("renamed"), 
            .keyword("introduced"), 
            .keyword("obsoleted"), 
            .keyword("deprecated")
          ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 5, [
        verify(layout[5], as: RawSyntax.self)])
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .awaitExpr:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("await")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .backDeployedAttributeArguments:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("before")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawPlatformVersionItemListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .binaryOperatorExpr:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.binaryOperator)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .booleanLiteralExpr:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("true"), .keyword("false")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .borrowExpr:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("_borrow")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .breakStmt:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("break")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .canImportExpr:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("canImport")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawCanImportVersionInfoSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .canImportVersionInfo:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.keyword("_version"), .keyword("_underlyingVersion")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawVersionTupleSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .catchClauseList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawCatchClauseSyntax.self))
    }
  case .catchClause:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("catch")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawCatchItemListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .catchItemList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawCatchItemSyntax.self))
    }
  case .catchItem:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawPatternSyntax?.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawWhereClauseSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .classDecl:
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("class")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawInheritanceClauseSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawMemberBlockSyntax.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  case .classRestrictionType:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("class")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .closureCaptureClause:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftSquare)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawClosureCaptureListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightSquare)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .closureCaptureList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawClosureCaptureSyntax.self))
    }
  case .closureCaptureSpecifier:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("weak"), .keyword("unowned")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.keyword("safe"), .keyword("unsafe")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .closureCapture:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawClosureCaptureSpecifierSyntax?.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.equal)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawExprSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .closureExpr:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftBrace)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawClosureSignatureSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawCodeBlockItemListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightBrace)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .closureParameterClause:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawClosureParameterListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .closureParameterList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawClosureParameterSyntax.self))
    }
  case .closureParameter:
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTypeSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.ellipsis)]))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  case .closureShorthandParameterList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawClosureShorthandParameterSyntax.self))
    }
  case .closureShorthandParameter:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .closureSignature:
    assert(layout.count == 13)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawClosureCaptureClauseSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 5, [
        verify(layout[5], as: RawSyntax?.self)])
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTypeEffectSpecifiersSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawReturnClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTokenSyntax.self, tokenChoices: [.keyword("in")]))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
  case .codeBlockItemList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawCodeBlockItemSyntax.self))
    }
  case .codeBlockItem:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 1, [
        verify(layout[1], as: RawSyntax.self)])
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.semicolon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .codeBlock:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftBrace)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawCodeBlockItemListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightBrace)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .compositionTypeElementList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawCompositionTypeElementSyntax.self))
    }
  case .compositionTypeElement:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .compositionType:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawCompositionTypeElementListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .conditionElementList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawConditionElementSyntax.self))
    }
  case .conditionElement:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 1, [
        verify(layout[1], as: RawSyntax.self)])
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .conformanceRequirement:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTypeSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .consumeExpr:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("_move"), .keyword("consume")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .continueStmt:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("continue")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .conventionAttributeArguments:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.keyword("cType")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawStringLiteralExprSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .conventionWitnessMethodAttributeArguments:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("witness_method")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .copyExpr:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("copy")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .declModifierDetail:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .declModifierList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawDeclModifierSyntax.self))
    }
  case .declModifier:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
            .keyword("__consuming"), 
            .keyword("__setter_access"), 
            .keyword("_const"), 
            .keyword("_local"), 
            .keyword("actor"), 
            .keyword("async"), 
            .keyword("borrowing"), 
            .keyword("class"), 
            .keyword("consuming"), 
            .keyword("convenience"), 
            .keyword("distributed"), 
            .keyword("dynamic"), 
            .keyword("fileprivate"), 
            .keyword("final"), 
            .keyword("indirect"), 
            .keyword("infix"), 
            .keyword("internal"), 
            .keyword("isolated"), 
            .keyword("lazy"), 
            .keyword("mutating"), 
            .keyword("nonisolated"), 
            .keyword("nonmutating"), 
            .keyword("open"), 
            .keyword("optional"), 
            .keyword("override"), 
            .keyword("package"), 
            .keyword("postfix"), 
            .keyword("prefix"), 
            .keyword("private"), 
            .keyword("public"), 
            .keyword("reasync"), 
            .keyword("required"), 
            .keyword("static"), 
            .keyword("unowned"), 
            .keyword("weak")
          ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierDetailSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .declNameArgumentList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawDeclNameArgumentSyntax.self))
    }
  case .declNameArgument:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .declNameArguments:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclNameArgumentListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .declReferenceExpr:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
            .tokenKind(.identifier), 
            .keyword("self"), 
            .keyword("Self"), 
            .keyword("init"), 
            .tokenKind(.dollarIdentifier), 
            .tokenKind(.binaryOperator), 
            .tokenKind(.integerLiteral)
          ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclNameArgumentsSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .deferStmt:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("defer")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .deinitializerDecl:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("deinit")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawDeinitializerEffectSpecifiersSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawCodeBlockSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .deinitializerEffectSpecifiers:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.keyword("async")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .derivativeAttributeArguments:
    assert(layout.count == 15)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("of")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.period)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax?.self, tokenChoices: [.keyword("get"), .keyword("set")]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawDifferentiabilityWithRespectToArgumentSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
  case .designatedTypeList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawDesignatedTypeSyntax.self))
    }
  case .designatedType:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .dictionaryElementList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawDictionaryElementSyntax.self))
    }
  case .dictionaryElement:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .dictionaryExpr:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftSquare)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 3, [
        verify(layout[3], as: RawSyntax.self)])
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightSquare)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .dictionaryType:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftSquare)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTypeSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightSquare)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .differentiabilityArgumentList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawDifferentiabilityArgumentSyntax.self))
    }
  case .differentiabilityArgument:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.integerLiteral), .keyword("self")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .differentiabilityArguments:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDifferentiabilityArgumentListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .differentiabilityWithRespectToArgument:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("wrt")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 5, [
        verify(layout[5], as: RawSyntax.self)])
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .differentiableAttributeArguments:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.keyword("_forward"), .keyword("reverse"), .keyword("_linear")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawDifferentiabilityWithRespectToArgumentSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .discardAssignmentExpr:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.wildcard)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .discardStmt:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("discard")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .doStmt:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("do")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawCatchClauseListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .documentationAttributeArgumentList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawDocumentationAttributeArgumentSyntax.self))
    }
  case .documentationAttributeArgument:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("visibility"), .keyword("metadata")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 5, [
        verify(layout[5], as: RawSyntax.self)])
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .dynamicReplacementAttributeArguments:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("for")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawDeclReferenceExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .editorPlaceholderDecl:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .editorPlaceholderExpr:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .effectsAttributeArgumentList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawTokenSyntax.self))
    }
  case .enumCaseDecl:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("case")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawEnumCaseElementListSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .enumCaseElementList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawEnumCaseElementSyntax.self))
    }
  case .enumCaseElement:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawEnumCaseParameterClauseSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawInitializerClauseSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .enumCaseParameterClause:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawEnumCaseParameterListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .enumCaseParameterList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawEnumCaseParameterSyntax.self))
    }
  case .enumCaseParameter:
    assert(layout.count == 15)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTypeSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawInitializerClauseSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
  case .enumDecl:
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("enum")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawInheritanceClauseSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawMemberBlockSyntax.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  case .exposeAttributeArguments:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawStringLiteralExprSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .exprList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawExprSyntax.self))
    }
  case .expressionPattern:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .expressionSegment:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.backslash)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rawStringPoundDelimiter)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawLabeledExprListSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .expressionStmt:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .extensionDecl:
    assert(layout.count == 15)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("extension")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTypeSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawInheritanceClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawMemberBlockSyntax.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
  case .fallThroughStmt:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("fallthrough")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .floatLiteralExpr:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.floatLiteral)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .forStmt:
    assert(layout.count == 21)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("for")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.keyword("try")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.keyword("await")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.keyword("case")]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawPatternSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTypeAnnotationSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawTokenSyntax.self, tokenChoices: [.keyword("in")]))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawExprSyntax.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 17, verify(layout[17], as: RawWhereClauseSyntax?.self))
    assertNoError(kind, 18, verify(layout[18], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 19, verify(layout[19], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 20, verify(layout[20], as: RawUnexpectedNodesSyntax?.self))
  case .forceUnwrapExpr:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.exclamationMark)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .functionCallExpr:
    assert(layout.count == 13)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawLabeledExprListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawClosureExprSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawMultipleTrailingClosureElementListSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
  case .functionDecl:
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("func")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [
            .tokenKind(.identifier), 
            .tokenKind(.binaryOperator), 
            .tokenKind(.prefixOperator), 
            .tokenKind(.postfixOperator)
          ]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawFunctionSignatureSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawCodeBlockSyntax?.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  case .functionEffectSpecifiers:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.keyword("async"), .keyword("reasync")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.keyword("throws"), .keyword("rethrows")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .functionParameterClause:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawFunctionParameterListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .functionParameterList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawFunctionParameterSyntax.self))
    }
  case .functionParameter:
    assert(layout.count == 19)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTypeSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.ellipsis)]))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawInitializerClauseSyntax?.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 17, verify(layout[17], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 18, verify(layout[18], as: RawUnexpectedNodesSyntax?.self))
  case .functionSignature:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawFunctionParameterClauseSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawFunctionEffectSpecifiersSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawReturnClauseSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .functionType:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTupleTypeElementListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTypeEffectSpecifiersSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawReturnClauseSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .genericArgumentClause:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftAngle)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawGenericArgumentListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightAngle)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .genericArgumentList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawGenericArgumentSyntax.self))
    }
  case .genericArgument:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .genericParameterClause:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftAngle)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawGenericParameterListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightAngle)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .genericParameterList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawGenericParameterSyntax.self))
    }
  case .genericParameter:
    assert(layout.count == 13)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.keyword("each")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTypeSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
  case .genericRequirementList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawGenericRequirementSyntax.self))
    }
  case .genericRequirement:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 1, [
        verify(layout[1], as: RawSyntax.self)])
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .genericSpecializationExpr:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawGenericArgumentClauseSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .genericWhereClause:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("where")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawGenericRequirementListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .guardStmt:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("guard")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawConditionElementListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("else")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .identifierPattern:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier), .keyword("self"), .keyword("init")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .identifierType:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
            .tokenKind(.identifier), 
            .keyword("Self"), 
            .keyword("Any"), 
            .tokenKind(.wildcard)
          ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawGenericArgumentClauseSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .ifConfigClauseList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawIfConfigClauseSyntax.self))
    }
  case .ifConfigClause:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.poundIf), .tokenKind(.poundElseif), .tokenKind(.poundElse)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 5, [
        verify(layout[5], as: RawSyntax?.self)])
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .ifConfigDecl:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawIfConfigClauseListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.poundEndif)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .ifExpr:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("if")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawConditionElementListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.keyword("else")]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 9, [
        verify(layout[9], as: RawSyntax?.self)])
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .implementsAttributeArguments:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawDeclReferenceExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .implicitlyUnwrappedOptionalType:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.exclamationMark)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .importDecl:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("import")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [
            .keyword("typealias"), 
            .keyword("struct"), 
            .keyword("class"), 
            .keyword("enum"), 
            .keyword("protocol"), 
            .keyword("var"), 
            .keyword("let"), 
            .keyword("func"), 
            .keyword("inout")
          ]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawImportPathComponentListSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .importPathComponentList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawImportPathComponentSyntax.self))
    }
  case .importPathComponent:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
            .tokenKind(.identifier), 
            .tokenKind(.binaryOperator), 
            .tokenKind(.prefixOperator), 
            .tokenKind(.postfixOperator)
          ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.period)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .inOutExpr:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.prefixAmpersand)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .infixOperatorExpr:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .inheritanceClause:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawInheritedTypeListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .inheritedTypeList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawInheritedTypeSyntax.self))
    }
  case .inheritedType:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .initializerClause:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.equal)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .initializerDecl:
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("init")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.postfixQuestionMark), .tokenKind(.exclamationMark)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawFunctionSignatureSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawCodeBlockSyntax?.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  case .integerLiteralExpr:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.integerLiteral)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .isExpr:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.keyword("is")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTypeSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .isTypePattern:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("is")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .keyPathComponentList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawKeyPathComponentSyntax.self))
    }
  case .keyPathComponent:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.period)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 3, [
        verify(layout[3], as: RawSyntax.self)])
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .keyPathExpr:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.backslash)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawKeyPathComponentListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .keyPathOptionalComponent:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.postfixQuestionMark), .tokenKind(.exclamationMark)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .keyPathPropertyComponent:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawDeclReferenceExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawGenericArgumentClauseSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .keyPathSubscriptComponent:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftSquare)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawLabeledExprListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightSquare)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .labeledExprList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawLabeledExprSyntax.self))
    }
  case .labeledExpr:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .labeledSpecializeArgument:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
            .keyword("target"), 
            .keyword("availability"), 
            .keyword("exported"), 
            .keyword("kind"), 
            .keyword("spi"), 
            .keyword("spiModule"), 
            .keyword("available")
          ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .labeledStmt:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawStmtSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .layoutRequirement:
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [
            .keyword("_Trivial"), 
            .keyword("_TrivialAtMost"), 
            .keyword("_UnknownLayout"), 
            .keyword("_RefCountedObject"), 
            .keyword("_NativeRefCountedObject"), 
            .keyword("_Class"), 
            .keyword("_NativeClass")
          ]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.integerLiteral)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.integerLiteral)]))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  case .macroDecl:
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("macro")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawFunctionSignatureSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawInitializerClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  case .macroExpansionDecl:
    assert(layout.count == 21)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.pound)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericArgumentClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawLabeledExprListSyntax.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 17, verify(layout[17], as: RawClosureExprSyntax?.self))
    assertNoError(kind, 18, verify(layout[18], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 19, verify(layout[19], as: RawMultipleTrailingClosureElementListSyntax.self))
    assertNoError(kind, 20, verify(layout[20], as: RawUnexpectedNodesSyntax?.self))
  case .macroExpansionExpr:
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.pound)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawGenericArgumentClauseSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawLabeledExprListSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawClosureExprSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawMultipleTrailingClosureElementListSyntax.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  case .matchingPatternCondition:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("case")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawPatternSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTypeAnnotationSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawInitializerClauseSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .memberAccessExpr:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax?.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.period)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawDeclReferenceExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .memberBlockItemList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawMemberBlockItemSyntax.self))
    }
  case .memberBlockItem:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawDeclSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.semicolon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .memberBlock:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftBrace)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawMemberBlockItemListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightBrace)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .memberType:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.period)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier), .keyword("self")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawGenericArgumentClauseSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .metatypeType:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.period)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("Type"), .keyword("Protocol")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .missingDecl:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .missingExpr:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .missingPattern:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .missingStmt:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .missing:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .missingType:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .multipleTrailingClosureElementList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawMultipleTrailingClosureElementSyntax.self))
    }
  case .multipleTrailingClosureElement:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawClosureExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .namedOpaqueReturnType:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawGenericParameterClauseSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .nilLiteralExpr:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("nil")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .objCSelectorPieceList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawObjCSelectorPieceSyntax.self))
    }
  case .objCSelectorPiece:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .opaqueReturnTypeOfAttributeArguments:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawStringLiteralExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.integerLiteral)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .operatorDecl:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("prefix"), .keyword("postfix"), .keyword("infix")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.keyword("operator")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.binaryOperator), .tokenKind(.prefixOperator), .tokenKind(.postfixOperator)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawOperatorPrecedenceAndTypesSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .operatorPrecedenceAndTypes:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawDesignatedTypeListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .optionalBindingCondition:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
            .keyword("let"), 
            .keyword("var"), 
            .keyword("inout"), 
            .keyword("_mutating"), 
            .keyword("_borrowing"), 
            .keyword("_consuming")
          ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawPatternSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTypeAnnotationSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawInitializerClauseSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .optionalChainingExpr:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.postfixQuestionMark)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .optionalType:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.postfixQuestionMark)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .originallyDefinedInAttributeArguments:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("module")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawStringLiteralExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawPlatformVersionItemListSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .packElementExpr:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("each")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .packElementType:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("each")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .packExpansionExpr:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("repeat")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .packExpansionType:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("repeat")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .patternBindingList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawPatternBindingSyntax.self))
    }
  case .patternBinding:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawPatternSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeAnnotationSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawInitializerClauseSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawAccessorBlockSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .patternExpr:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawPatternSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .platformVersionItemList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawPlatformVersionItemSyntax.self))
    }
  case .platformVersionItem:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawPlatformVersionSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .platformVersion:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawVersionTupleSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .postfixIfConfigExpr:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax?.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawIfConfigDeclSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .postfixOperatorExpr:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.postfixOperator)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .poundSourceLocationArguments:
    assert(layout.count == 15)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("file")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawSimpleStringLiteralExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax.self, tokenChoices: [.keyword("line")]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.integerLiteral)]))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
  case .poundSourceLocation:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.poundSourceLocation)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawPoundSourceLocationArgumentsSyntax?.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .precedenceGroupAssignment:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("assignment")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("true"), .keyword("false")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .precedenceGroupAssociativity:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("associativity")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("left"), .keyword("right"), .keyword("none")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .precedenceGroupAttributeList:
    for (index, element) in layout.enumerated() {
      assertAnyHasNoError(kind, index, [
          verify(element, as: RawPrecedenceGroupRelationSyntax.self),
          verify(element, as: RawPrecedenceGroupAssignmentSyntax.self),
          verify(element, as: RawPrecedenceGroupAssociativitySyntax.self)])
    }
  case .precedenceGroupDecl:
    assert(layout.count == 15)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("precedencegroup")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftBrace)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawPrecedenceGroupAttributeListSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightBrace)]))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
  case .precedenceGroupNameList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawPrecedenceGroupNameSyntax.self))
    }
  case .precedenceGroupName:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .precedenceGroupRelation:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("higherThan"), .keyword("lowerThan")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawPrecedenceGroupNameListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .prefixOperatorExpr:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.prefixOperator)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .primaryAssociatedTypeClause:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftAngle)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawPrimaryAssociatedTypeListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightAngle)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .primaryAssociatedTypeList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawPrimaryAssociatedTypeSyntax.self))
    }
  case .primaryAssociatedType:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .protocolDecl:
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("protocol")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawPrimaryAssociatedTypeClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawInheritanceClauseSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawMemberBlockSyntax.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  case .regexLiteralExpr:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.regexPoundDelimiter)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.regexSlash)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.regexLiteralPattern)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.regexSlash)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.regexPoundDelimiter)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .repeatStmt:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("repeat")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("while")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawExprSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .returnClause:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.arrow)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .returnStmt:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("return")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .sameTypeRequirement:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.binaryOperator), .tokenKind(.prefixOperator), .tokenKind(.postfixOperator)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTypeSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .sequenceExpr:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .simpleStringLiteralExpr:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.stringQuote), .tokenKind(.multilineStringQuote)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawSimpleStringLiteralSegmentListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.stringQuote), .tokenKind(.multilineStringQuote)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .simpleStringLiteralSegmentList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawStringSegmentSyntax.self))
    }
  case .someOrAnyType:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("some"), .keyword("any")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .sourceFile:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.shebang)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawCodeBlockItemListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.endOfFile)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .specializeAttributeArgumentList:
    for (index, element) in layout.enumerated() {
      assertAnyHasNoError(kind, index, [
            verify(element, as: RawLabeledSpecializeArgumentSyntax.self),
            verify(element, as: RawSpecializeAvailabilityArgumentSyntax.self),
            verify(element, as: RawSpecializeTargetFunctionArgumentSyntax.self),
            verify(element, as: RawGenericWhereClauseSyntax.self)
          ])
    }
  case .specializeAvailabilityArgument:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("availability")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawAvailabilityArgumentListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.semicolon)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .specializeTargetFunctionArgument:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("target")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawDeclReferenceExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .stringLiteralExpr:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rawStringPoundDelimiter)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.stringQuote), .tokenKind(.multilineStringQuote), .tokenKind(.singleQuote)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawStringLiteralSegmentListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.stringQuote), .tokenKind(.multilineStringQuote), .tokenKind(.singleQuote)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.rawStringPoundDelimiter)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .stringLiteralSegmentList:
    for (index, element) in layout.enumerated() {
      assertAnyHasNoError(kind, index, [
          verify(element, as: RawStringSegmentSyntax.self),
          verify(element, as: RawExpressionSegmentSyntax.self)])
    }
  case .stringSegment:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.stringSegment)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .structDecl:
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("struct")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawInheritanceClauseSyntax?.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawMemberBlockSyntax.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  case .subscriptCallExpr:
    assert(layout.count == 13)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftSquare)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawLabeledExprListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightSquare)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawClosureExprSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawMultipleTrailingClosureElementListSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
  case .subscriptDecl:
    assert(layout.count == 17)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("subscript")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawFunctionParameterClauseSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawReturnClauseSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 15, verify(layout[15], as: RawAccessorBlockSyntax?.self))
    assertNoError(kind, 16, verify(layout[16], as: RawUnexpectedNodesSyntax?.self))
  case .superExpr:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("super")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .suppressedType:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.prefixOperator)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .switchCaseItemList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawSwitchCaseItemSyntax.self))
    }
  case .switchCaseItem:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawPatternSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawWhereClauseSyntax?.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .switchCaseLabel:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("case")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawSwitchCaseItemListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .switchCaseList:
    for (index, element) in layout.enumerated() {
      assertAnyHasNoError(kind, index, [
          verify(element, as: RawSwitchCaseSyntax.self),
          verify(element, as: RawIfConfigDeclSyntax.self)])
    }
  case .switchCase:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeSyntax?.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 3, [
        verify(layout[3], as: RawSyntax.self)])
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawCodeBlockItemListSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .switchDefaultLabel:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("default")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .switchExpr:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("switch")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftBrace)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawSwitchCaseListSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightBrace)]))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .ternaryExpr:
    assert(layout.count == 11)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.infixQuestionMark)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawExprSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
  case .thenStmt:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("then")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .throwStmt:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("throw")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .tryExpr:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("try")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.postfixQuestionMark), .tokenKind(.exclamationMark)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .tupleExpr:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawLabeledExprListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .tuplePatternElementList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawTuplePatternElementSyntax.self))
    }
  case .tuplePatternElement:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawPatternSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .tuplePattern:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTuplePatternElementListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .tupleTypeElementList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawTupleTypeElementSyntax.self))
    }
  case .tupleTypeElement:
    assert(layout.count == 15)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.keyword("inout")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.identifier), .tokenKind(.wildcard)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawTypeSyntax.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.ellipsis)]))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
  case .tupleType:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTupleTypeElementListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .typeAliasDecl:
    assert(layout.count == 15)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.keyword("typealias")]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.identifier)]))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 9, verify(layout[9], as: RawGenericParameterClauseSyntax?.self))
    assertNoError(kind, 10, verify(layout[10], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 11, verify(layout[11], as: RawTypeInitializerClauseSyntax.self))
    assertNoError(kind, 12, verify(layout[12], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 13, verify(layout[13], as: RawGenericWhereClauseSyntax?.self))
    assertNoError(kind, 14, verify(layout[14], as: RawUnexpectedNodesSyntax?.self))
  case .typeAnnotation:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .typeEffectSpecifiers:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax?.self, tokenChoices: [.keyword("async")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.keyword("throws")]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .typeExpr:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTypeSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .typeInitializerClause:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.equal)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTypeSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .unavailableFromAsyncAttributeArguments:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("message")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawStringLiteralExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .underscorePrivateAttributeArguments:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("sourceFile")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawStringLiteralExprSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .unexpectedNodes:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawSyntax.self))
    }
  case .unresolvedAsExpr:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("as")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.postfixQuestionMark), .tokenKind(.exclamationMark)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .unresolvedIsExpr:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("is")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .unresolvedTernaryExpr:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.infixQuestionMark)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.colon)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .valueBindingPattern:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [
            .keyword("let"), 
            .keyword("var"), 
            .keyword("inout"), 
            .keyword("_mutating"), 
            .keyword("_borrowing"), 
            .keyword("_consuming")
          ]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawPatternSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .variableDecl:
    assert(layout.count == 9)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawAttributeListSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawDeclModifierListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [
            .keyword("let"), 
            .keyword("var"), 
            .keyword("inout"), 
            .keyword("_mutating"), 
            .keyword("_borrowing"), 
            .keyword("_consuming")
          ]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 7, verify(layout[7], as: RawPatternBindingListSyntax.self))
    assertNoError(kind, 8, verify(layout[8], as: RawUnexpectedNodesSyntax?.self))
  case .versionComponentList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawVersionComponentSyntax.self))
    }
  case .versionComponent:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.period)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.integerLiteral)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .versionTuple:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.integerLiteral)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawVersionComponentListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .whereClause:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("where")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawExprSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .whileStmt:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("while")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawConditionElementListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawCodeBlockSyntax.self))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  case .wildcardPattern:
    assert(layout.count == 3)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.wildcard)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
  case .yieldStmt:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.keyword("yield")]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertAnyHasNoError(kind, 3, [
        verify(layout[3], as: RawSyntax.self)])
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .yieldedExpressionList:
    for (index, element) in layout.enumerated() {
      assertNoError(kind, index, verify(element, as: RawYieldedExpressionSyntax.self))
    }
  case .yieldedExpression:
    assert(layout.count == 5)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawExprSyntax.self))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawTokenSyntax?.self, tokenChoices: [.tokenKind(.comma)]))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
  case .yieldedExpressionsClause:
    assert(layout.count == 7)
    assertNoError(kind, 0, verify(layout[0], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 1, verify(layout[1], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.leftParen)]))
    assertNoError(kind, 2, verify(layout[2], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 3, verify(layout[3], as: RawYieldedExpressionListSyntax.self))
    assertNoError(kind, 4, verify(layout[4], as: RawUnexpectedNodesSyntax?.self))
    assertNoError(kind, 5, verify(layout[5], as: RawTokenSyntax.self, tokenChoices: [.tokenKind(.rightParen)]))
    assertNoError(kind, 6, verify(layout[6], as: RawUnexpectedNodesSyntax?.self))
  }
  #endif
}
