//// Automatically generated by generate-swift-syntax
//// Do not edit directly!
//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

/// The enum describes how the ``SyntaxVisitor`` should continue after visiting
/// the current node.
public enum SyntaxVisitorContinueKind {
  /// The visitor should visit the descendants of the current node.
  case visitChildren
  /// The visitor should avoid visiting the descendants of the current node.
  case skipChildren
}

open class SyntaxVisitor {
  public let viewMode: SyntaxTreeViewMode
  
  public init(viewMode: SyntaxTreeViewMode) {
    self.viewMode = viewMode
  }
  
  /// Walk all nodes of the given syntax tree, calling the corresponding `visit`
  /// function for every node that is being visited.
  public func walk(_ node: some SyntaxProtocol) {
    visit(Syntax(node))
  }
  
  /// Visiting ``AccessorBlockSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AccessorBlockSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``AccessorBlockSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AccessorBlockSyntax) {
  }
  
  /// Visiting ``AccessorDeclListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AccessorDeclListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``AccessorDeclListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AccessorDeclListSyntax) {
  }
  
  /// Visiting ``AccessorDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AccessorDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``AccessorDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AccessorDeclSyntax) {
  }
  
  /// Visiting ``AccessorEffectSpecifiersSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AccessorEffectSpecifiersSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``AccessorEffectSpecifiersSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AccessorEffectSpecifiersSyntax) {
  }
  
  /// Visiting ``AccessorParametersSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AccessorParametersSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``AccessorParametersSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AccessorParametersSyntax) {
  }
  
  /// Visiting ``ActorDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ActorDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ActorDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ActorDeclSyntax) {
  }
  
  /// Visiting ``ArrayElementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ArrayElementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ArrayElementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ArrayElementListSyntax) {
  }
  
  /// Visiting ``ArrayElementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ArrayElementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ArrayElementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ArrayElementSyntax) {
  }
  
  /// Visiting ``ArrayExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ArrayExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ArrayExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ArrayExprSyntax) {
  }
  
  /// Visiting ``ArrayTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ArrayTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ArrayTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ArrayTypeSyntax) {
  }
  
  /// Visiting ``ArrowExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ArrowExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ArrowExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ArrowExprSyntax) {
  }
  
  /// Visiting ``AsExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AsExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``AsExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AsExprSyntax) {
  }
  
  /// Visiting ``AssignmentExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AssignmentExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``AssignmentExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AssignmentExprSyntax) {
  }
  
  /// Visiting ``AssociatedTypeDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AssociatedTypeDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``AssociatedTypeDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AssociatedTypeDeclSyntax) {
  }
  
  /// Visiting ``AttributeListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AttributeListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``AttributeListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AttributeListSyntax) {
  }
  
  /// Visiting ``AttributeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AttributeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``AttributeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AttributeSyntax) {
  }
  
  /// Visiting ``AttributedTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AttributedTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``AttributedTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AttributedTypeSyntax) {
  }
  
  /// Visiting ``AvailabilityArgumentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AvailabilityArgumentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``AvailabilityArgumentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AvailabilityArgumentListSyntax) {
  }
  
  /// Visiting ``AvailabilityArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AvailabilityArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``AvailabilityArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AvailabilityArgumentSyntax) {
  }
  
  /// Visiting ``AvailabilityConditionSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AvailabilityConditionSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``AvailabilityConditionSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AvailabilityConditionSyntax) {
  }
  
  /// Visiting ``AvailabilityLabeledArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AvailabilityLabeledArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``AvailabilityLabeledArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AvailabilityLabeledArgumentSyntax) {
  }
  
  /// Visiting ``AwaitExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: AwaitExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``AwaitExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: AwaitExprSyntax) {
  }
  
  /// Visiting ``BackDeployedAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: BackDeployedAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``BackDeployedAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: BackDeployedAttributeArgumentsSyntax) {
  }
  
  /// Visiting ``BinaryOperatorExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: BinaryOperatorExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``BinaryOperatorExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: BinaryOperatorExprSyntax) {
  }
  
  /// Visiting ``BooleanLiteralExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: BooleanLiteralExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``BooleanLiteralExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: BooleanLiteralExprSyntax) {
  }
  
  /// Visiting ``BorrowExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: BorrowExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``BorrowExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: BorrowExprSyntax) {
  }
  
  /// Visiting ``BreakStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: BreakStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``BreakStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: BreakStmtSyntax) {
  }
  
  /// Visiting ``CanImportExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CanImportExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``CanImportExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CanImportExprSyntax) {
  }
  
  /// Visiting ``CanImportVersionInfoSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CanImportVersionInfoSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``CanImportVersionInfoSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CanImportVersionInfoSyntax) {
  }
  
  /// Visiting ``CatchClauseListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CatchClauseListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``CatchClauseListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CatchClauseListSyntax) {
  }
  
  /// Visiting ``CatchClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CatchClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``CatchClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CatchClauseSyntax) {
  }
  
  /// Visiting ``CatchItemListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CatchItemListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``CatchItemListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CatchItemListSyntax) {
  }
  
  /// Visiting ``CatchItemSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CatchItemSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``CatchItemSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CatchItemSyntax) {
  }
  
  /// Visiting ``ClassDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClassDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ClassDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClassDeclSyntax) {
  }
  
  /// Visiting ``ClassRestrictionTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClassRestrictionTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ClassRestrictionTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClassRestrictionTypeSyntax) {
  }
  
  /// Visiting ``ClosureCaptureClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureCaptureClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ClosureCaptureClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureCaptureClauseSyntax) {
  }
  
  /// Visiting ``ClosureCaptureListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureCaptureListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ClosureCaptureListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureCaptureListSyntax) {
  }
  
  /// Visiting ``ClosureCaptureSpecifierSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureCaptureSpecifierSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ClosureCaptureSpecifierSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureCaptureSpecifierSyntax) {
  }
  
  /// Visiting ``ClosureCaptureSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureCaptureSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ClosureCaptureSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureCaptureSyntax) {
  }
  
  /// Visiting ``ClosureExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ClosureExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureExprSyntax) {
  }
  
  /// Visiting ``ClosureParameterClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureParameterClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ClosureParameterClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureParameterClauseSyntax) {
  }
  
  /// Visiting ``ClosureParameterListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureParameterListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ClosureParameterListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureParameterListSyntax) {
  }
  
  /// Visiting ``ClosureParameterSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureParameterSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ClosureParameterSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureParameterSyntax) {
  }
  
  /// Visiting ``ClosureShorthandParameterListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureShorthandParameterListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ClosureShorthandParameterListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureShorthandParameterListSyntax) {
  }
  
  /// Visiting ``ClosureShorthandParameterSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureShorthandParameterSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ClosureShorthandParameterSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureShorthandParameterSyntax) {
  }
  
  /// Visiting ``ClosureSignatureSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ClosureSignatureSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ClosureSignatureSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ClosureSignatureSyntax) {
  }
  
  /// Visiting ``CodeBlockItemListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CodeBlockItemListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``CodeBlockItemListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CodeBlockItemListSyntax) {
  }
  
  /// Visiting ``CodeBlockItemSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CodeBlockItemSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``CodeBlockItemSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CodeBlockItemSyntax) {
  }
  
  /// Visiting ``CodeBlockSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CodeBlockSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``CodeBlockSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CodeBlockSyntax) {
  }
  
  /// Visiting ``CompositionTypeElementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CompositionTypeElementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``CompositionTypeElementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CompositionTypeElementListSyntax) {
  }
  
  /// Visiting ``CompositionTypeElementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CompositionTypeElementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``CompositionTypeElementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CompositionTypeElementSyntax) {
  }
  
  /// Visiting ``CompositionTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CompositionTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``CompositionTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CompositionTypeSyntax) {
  }
  
  /// Visiting ``ConditionElementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ConditionElementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ConditionElementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ConditionElementListSyntax) {
  }
  
  /// Visiting ``ConditionElementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ConditionElementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ConditionElementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ConditionElementSyntax) {
  }
  
  /// Visiting ``ConformanceRequirementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ConformanceRequirementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ConformanceRequirementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ConformanceRequirementSyntax) {
  }
  
  /// Visiting ``ConsumeExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ConsumeExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ConsumeExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ConsumeExprSyntax) {
  }
  
  /// Visiting ``ContinueStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ContinueStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ContinueStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ContinueStmtSyntax) {
  }
  
  /// Visiting ``ConventionAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ConventionAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ConventionAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ConventionAttributeArgumentsSyntax) {
  }
  
  /// Visiting ``ConventionWitnessMethodAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ConventionWitnessMethodAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ConventionWitnessMethodAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ConventionWitnessMethodAttributeArgumentsSyntax) {
  }
  
  /// Visiting ``CopyExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: CopyExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``CopyExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: CopyExprSyntax) {
  }
  
  /// Visiting ``DeclModifierDetailSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeclModifierDetailSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DeclModifierDetailSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeclModifierDetailSyntax) {
  }
  
  /// Visiting ``DeclModifierListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeclModifierListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DeclModifierListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeclModifierListSyntax) {
  }
  
  /// Visiting ``DeclModifierSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeclModifierSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DeclModifierSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeclModifierSyntax) {
  }
  
  /// Visiting ``DeclNameArgumentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeclNameArgumentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DeclNameArgumentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeclNameArgumentListSyntax) {
  }
  
  /// Visiting ``DeclNameArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeclNameArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DeclNameArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeclNameArgumentSyntax) {
  }
  
  /// Visiting ``DeclNameArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeclNameArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DeclNameArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeclNameArgumentsSyntax) {
  }
  
  /// Visiting ``DeclReferenceExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeclReferenceExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DeclReferenceExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeclReferenceExprSyntax) {
  }
  
  /// Visiting ``DeferStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeferStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DeferStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeferStmtSyntax) {
  }
  
  /// Visiting ``DeinitializerDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeinitializerDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DeinitializerDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeinitializerDeclSyntax) {
  }
  
  /// Visiting ``DeinitializerEffectSpecifiersSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DeinitializerEffectSpecifiersSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DeinitializerEffectSpecifiersSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DeinitializerEffectSpecifiersSyntax) {
  }
  
  /// Visiting ``DerivativeAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DerivativeAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DerivativeAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DerivativeAttributeArgumentsSyntax) {
  }
  
  /// Visiting ``DesignatedTypeListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DesignatedTypeListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DesignatedTypeListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DesignatedTypeListSyntax) {
  }
  
  /// Visiting ``DesignatedTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DesignatedTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DesignatedTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DesignatedTypeSyntax) {
  }
  
  /// Visiting ``DictionaryElementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DictionaryElementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DictionaryElementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DictionaryElementListSyntax) {
  }
  
  /// Visiting ``DictionaryElementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DictionaryElementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DictionaryElementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DictionaryElementSyntax) {
  }
  
  /// Visiting ``DictionaryExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DictionaryExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DictionaryExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DictionaryExprSyntax) {
  }
  
  /// Visiting ``DictionaryTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DictionaryTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DictionaryTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DictionaryTypeSyntax) {
  }
  
  /// Visiting ``DifferentiabilityArgumentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DifferentiabilityArgumentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DifferentiabilityArgumentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DifferentiabilityArgumentListSyntax) {
  }
  
  /// Visiting ``DifferentiabilityArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DifferentiabilityArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DifferentiabilityArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DifferentiabilityArgumentSyntax) {
  }
  
  /// Visiting ``DifferentiabilityArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DifferentiabilityArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DifferentiabilityArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DifferentiabilityArgumentsSyntax) {
  }
  
  /// Visiting ``DifferentiabilityWithRespectToArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DifferentiabilityWithRespectToArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DifferentiabilityWithRespectToArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DifferentiabilityWithRespectToArgumentSyntax) {
  }
  
  /// Visiting ``DifferentiableAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DifferentiableAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DifferentiableAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DifferentiableAttributeArgumentsSyntax) {
  }
  
  /// Visiting ``DiscardAssignmentExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DiscardAssignmentExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DiscardAssignmentExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DiscardAssignmentExprSyntax) {
  }
  
  /// Visiting ``DiscardStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DiscardStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DiscardStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DiscardStmtSyntax) {
  }
  
  /// Visiting ``DoStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DoStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DoStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DoStmtSyntax) {
  }
  
  /// Visiting ``DocumentationAttributeArgumentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DocumentationAttributeArgumentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DocumentationAttributeArgumentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DocumentationAttributeArgumentListSyntax) {
  }
  
  /// Visiting ``DocumentationAttributeArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DocumentationAttributeArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DocumentationAttributeArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DocumentationAttributeArgumentSyntax) {
  }
  
  /// Visiting ``DynamicReplacementAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: DynamicReplacementAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``DynamicReplacementAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: DynamicReplacementAttributeArgumentsSyntax) {
  }
  
  /// Visiting ``EditorPlaceholderDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EditorPlaceholderDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``EditorPlaceholderDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EditorPlaceholderDeclSyntax) {
  }
  
  /// Visiting ``EditorPlaceholderExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EditorPlaceholderExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``EditorPlaceholderExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EditorPlaceholderExprSyntax) {
  }
  
  /// Visiting ``EffectsAttributeArgumentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EffectsAttributeArgumentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``EffectsAttributeArgumentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EffectsAttributeArgumentListSyntax) {
  }
  
  /// Visiting ``EnumCaseDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EnumCaseDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``EnumCaseDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EnumCaseDeclSyntax) {
  }
  
  /// Visiting ``EnumCaseElementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EnumCaseElementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``EnumCaseElementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EnumCaseElementListSyntax) {
  }
  
  /// Visiting ``EnumCaseElementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EnumCaseElementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``EnumCaseElementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EnumCaseElementSyntax) {
  }
  
  /// Visiting ``EnumCaseParameterClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EnumCaseParameterClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``EnumCaseParameterClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EnumCaseParameterClauseSyntax) {
  }
  
  /// Visiting ``EnumCaseParameterListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EnumCaseParameterListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``EnumCaseParameterListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EnumCaseParameterListSyntax) {
  }
  
  /// Visiting ``EnumCaseParameterSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EnumCaseParameterSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``EnumCaseParameterSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EnumCaseParameterSyntax) {
  }
  
  /// Visiting ``EnumDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: EnumDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``EnumDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: EnumDeclSyntax) {
  }
  
  /// Visiting ``ExposeAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ExposeAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ExposeAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ExposeAttributeArgumentsSyntax) {
  }
  
  /// Visiting ``ExprListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ExprListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ExprListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ExprListSyntax) {
  }
  
  /// Visiting ``ExpressionPatternSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ExpressionPatternSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ExpressionPatternSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ExpressionPatternSyntax) {
  }
  
  /// Visiting ``ExpressionSegmentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ExpressionSegmentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ExpressionSegmentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ExpressionSegmentSyntax) {
  }
  
  /// Visiting ``ExpressionStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ExpressionStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ExpressionStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ExpressionStmtSyntax) {
  }
  
  /// Visiting ``ExtensionDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ExtensionDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ExtensionDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ExtensionDeclSyntax) {
  }
  
  /// Visiting ``FallThroughStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FallThroughStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``FallThroughStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FallThroughStmtSyntax) {
  }
  
  /// Visiting ``FloatLiteralExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FloatLiteralExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``FloatLiteralExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FloatLiteralExprSyntax) {
  }
  
  /// Visiting ``ForStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ForStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ForStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ForStmtSyntax) {
  }
  
  /// Visiting ``ForceUnwrapExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ForceUnwrapExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ForceUnwrapExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ForceUnwrapExprSyntax) {
  }
  
  /// Visiting ``FunctionCallExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FunctionCallExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``FunctionCallExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FunctionCallExprSyntax) {
  }
  
  /// Visiting ``FunctionDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FunctionDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``FunctionDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FunctionDeclSyntax) {
  }
  
  /// Visiting ``FunctionEffectSpecifiersSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FunctionEffectSpecifiersSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``FunctionEffectSpecifiersSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FunctionEffectSpecifiersSyntax) {
  }
  
  /// Visiting ``FunctionParameterClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FunctionParameterClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``FunctionParameterClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FunctionParameterClauseSyntax) {
  }
  
  /// Visiting ``FunctionParameterListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FunctionParameterListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``FunctionParameterListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FunctionParameterListSyntax) {
  }
  
  /// Visiting ``FunctionParameterSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FunctionParameterSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``FunctionParameterSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FunctionParameterSyntax) {
  }
  
  /// Visiting ``FunctionSignatureSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FunctionSignatureSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``FunctionSignatureSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FunctionSignatureSyntax) {
  }
  
  /// Visiting ``FunctionTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: FunctionTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``FunctionTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: FunctionTypeSyntax) {
  }
  
  /// Visiting ``GenericArgumentClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericArgumentClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``GenericArgumentClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericArgumentClauseSyntax) {
  }
  
  /// Visiting ``GenericArgumentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericArgumentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``GenericArgumentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericArgumentListSyntax) {
  }
  
  /// Visiting ``GenericArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``GenericArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericArgumentSyntax) {
  }
  
  /// Visiting ``GenericParameterClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericParameterClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``GenericParameterClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericParameterClauseSyntax) {
  }
  
  /// Visiting ``GenericParameterListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericParameterListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``GenericParameterListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericParameterListSyntax) {
  }
  
  /// Visiting ``GenericParameterSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericParameterSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``GenericParameterSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericParameterSyntax) {
  }
  
  /// Visiting ``GenericRequirementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericRequirementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``GenericRequirementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericRequirementListSyntax) {
  }
  
  /// Visiting ``GenericRequirementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericRequirementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``GenericRequirementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericRequirementSyntax) {
  }
  
  /// Visiting ``GenericSpecializationExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericSpecializationExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``GenericSpecializationExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericSpecializationExprSyntax) {
  }
  
  /// Visiting ``GenericWhereClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GenericWhereClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``GenericWhereClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GenericWhereClauseSyntax) {
  }
  
  /// Visiting ``GuardStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: GuardStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``GuardStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: GuardStmtSyntax) {
  }
  
  /// Visiting ``IdentifierPatternSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IdentifierPatternSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``IdentifierPatternSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IdentifierPatternSyntax) {
  }
  
  /// Visiting ``IdentifierTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IdentifierTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``IdentifierTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IdentifierTypeSyntax) {
  }
  
  /// Visiting ``IfConfigClauseListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IfConfigClauseListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``IfConfigClauseListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IfConfigClauseListSyntax) {
  }
  
  /// Visiting ``IfConfigClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IfConfigClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``IfConfigClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IfConfigClauseSyntax) {
  }
  
  /// Visiting ``IfConfigDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IfConfigDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``IfConfigDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IfConfigDeclSyntax) {
  }
  
  /// Visiting ``IfExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IfExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``IfExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IfExprSyntax) {
  }
  
  /// Visiting ``ImplementsAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ImplementsAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ImplementsAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ImplementsAttributeArgumentsSyntax) {
  }
  
  /// Visiting ``ImplicitlyUnwrappedOptionalTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ImplicitlyUnwrappedOptionalTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ImplicitlyUnwrappedOptionalTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ImplicitlyUnwrappedOptionalTypeSyntax) {
  }
  
  /// Visiting ``ImportDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ImportDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ImportDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ImportDeclSyntax) {
  }
  
  /// Visiting ``ImportPathComponentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ImportPathComponentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ImportPathComponentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ImportPathComponentListSyntax) {
  }
  
  /// Visiting ``ImportPathComponentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ImportPathComponentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ImportPathComponentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ImportPathComponentSyntax) {
  }
  
  /// Visiting ``InOutExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: InOutExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``InOutExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: InOutExprSyntax) {
  }
  
  /// Visiting ``InfixOperatorExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: InfixOperatorExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``InfixOperatorExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: InfixOperatorExprSyntax) {
  }
  
  /// Visiting ``InheritanceClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: InheritanceClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``InheritanceClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: InheritanceClauseSyntax) {
  }
  
  /// Visiting ``InheritedTypeListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: InheritedTypeListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``InheritedTypeListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: InheritedTypeListSyntax) {
  }
  
  /// Visiting ``InheritedTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: InheritedTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``InheritedTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: InheritedTypeSyntax) {
  }
  
  /// Visiting ``InitializerClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: InitializerClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``InitializerClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: InitializerClauseSyntax) {
  }
  
  /// Visiting ``InitializerDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: InitializerDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``InitializerDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: InitializerDeclSyntax) {
  }
  
  /// Visiting ``IntegerLiteralExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IntegerLiteralExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``IntegerLiteralExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IntegerLiteralExprSyntax) {
  }
  
  /// Visiting ``IsExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IsExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``IsExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IsExprSyntax) {
  }
  
  /// Visiting ``IsTypePatternSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: IsTypePatternSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``IsTypePatternSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: IsTypePatternSyntax) {
  }
  
  /// Visiting ``KeyPathComponentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: KeyPathComponentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``KeyPathComponentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: KeyPathComponentListSyntax) {
  }
  
  /// Visiting ``KeyPathComponentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: KeyPathComponentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``KeyPathComponentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: KeyPathComponentSyntax) {
  }
  
  /// Visiting ``KeyPathExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: KeyPathExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``KeyPathExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: KeyPathExprSyntax) {
  }
  
  /// Visiting ``KeyPathOptionalComponentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: KeyPathOptionalComponentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``KeyPathOptionalComponentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: KeyPathOptionalComponentSyntax) {
  }
  
  /// Visiting ``KeyPathPropertyComponentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: KeyPathPropertyComponentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``KeyPathPropertyComponentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: KeyPathPropertyComponentSyntax) {
  }
  
  /// Visiting ``KeyPathSubscriptComponentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: KeyPathSubscriptComponentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``KeyPathSubscriptComponentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: KeyPathSubscriptComponentSyntax) {
  }
  
  /// Visiting ``LabeledExprListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: LabeledExprListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``LabeledExprListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: LabeledExprListSyntax) {
  }
  
  /// Visiting ``LabeledExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: LabeledExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``LabeledExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: LabeledExprSyntax) {
  }
  
  /// Visiting ``LabeledSpecializeArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: LabeledSpecializeArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``LabeledSpecializeArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: LabeledSpecializeArgumentSyntax) {
  }
  
  /// Visiting ``LabeledStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: LabeledStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``LabeledStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: LabeledStmtSyntax) {
  }
  
  /// Visiting ``LayoutRequirementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: LayoutRequirementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``LayoutRequirementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: LayoutRequirementSyntax) {
  }
  
  /// Visiting ``MacroDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MacroDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MacroDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MacroDeclSyntax) {
  }
  
  /// Visiting ``MacroExpansionDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MacroExpansionDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MacroExpansionDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MacroExpansionDeclSyntax) {
  }
  
  /// Visiting ``MacroExpansionExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MacroExpansionExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MacroExpansionExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MacroExpansionExprSyntax) {
  }
  
  /// Visiting ``MatchingPatternConditionSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MatchingPatternConditionSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MatchingPatternConditionSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MatchingPatternConditionSyntax) {
  }
  
  /// Visiting ``MemberAccessExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MemberAccessExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MemberAccessExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MemberAccessExprSyntax) {
  }
  
  /// Visiting ``MemberBlockItemListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MemberBlockItemListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MemberBlockItemListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MemberBlockItemListSyntax) {
  }
  
  /// Visiting ``MemberBlockItemSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MemberBlockItemSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MemberBlockItemSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MemberBlockItemSyntax) {
  }
  
  /// Visiting ``MemberBlockSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MemberBlockSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MemberBlockSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MemberBlockSyntax) {
  }
  
  /// Visiting ``MemberTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MemberTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MemberTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MemberTypeSyntax) {
  }
  
  /// Visiting ``MetatypeTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MetatypeTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MetatypeTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MetatypeTypeSyntax) {
  }
  
  /// Visiting ``MissingDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MissingDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MissingDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MissingDeclSyntax) {
  }
  
  /// Visiting ``MissingExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MissingExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MissingExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MissingExprSyntax) {
  }
  
  /// Visiting ``MissingPatternSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MissingPatternSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MissingPatternSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MissingPatternSyntax) {
  }
  
  /// Visiting ``MissingStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MissingStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MissingStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MissingStmtSyntax) {
  }
  
  /// Visiting ``MissingSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MissingSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MissingSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MissingSyntax) {
  }
  
  /// Visiting ``MissingTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MissingTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MissingTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MissingTypeSyntax) {
  }
  
  /// Visiting ``MultipleTrailingClosureElementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MultipleTrailingClosureElementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MultipleTrailingClosureElementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MultipleTrailingClosureElementListSyntax) {
  }
  
  /// Visiting ``MultipleTrailingClosureElementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: MultipleTrailingClosureElementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``MultipleTrailingClosureElementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: MultipleTrailingClosureElementSyntax) {
  }
  
  /// Visiting ``NamedOpaqueReturnTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: NamedOpaqueReturnTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``NamedOpaqueReturnTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: NamedOpaqueReturnTypeSyntax) {
  }
  
  /// Visiting ``NilLiteralExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: NilLiteralExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``NilLiteralExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: NilLiteralExprSyntax) {
  }
  
  /// Visiting ``ObjCSelectorPieceListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ObjCSelectorPieceListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ObjCSelectorPieceListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ObjCSelectorPieceListSyntax) {
  }
  
  /// Visiting ``ObjCSelectorPieceSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ObjCSelectorPieceSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ObjCSelectorPieceSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ObjCSelectorPieceSyntax) {
  }
  
  /// Visiting ``OpaqueReturnTypeOfAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: OpaqueReturnTypeOfAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``OpaqueReturnTypeOfAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: OpaqueReturnTypeOfAttributeArgumentsSyntax) {
  }
  
  /// Visiting ``OperatorDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: OperatorDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``OperatorDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: OperatorDeclSyntax) {
  }
  
  /// Visiting ``OperatorPrecedenceAndTypesSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: OperatorPrecedenceAndTypesSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``OperatorPrecedenceAndTypesSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: OperatorPrecedenceAndTypesSyntax) {
  }
  
  /// Visiting ``OptionalBindingConditionSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: OptionalBindingConditionSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``OptionalBindingConditionSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: OptionalBindingConditionSyntax) {
  }
  
  /// Visiting ``OptionalChainingExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: OptionalChainingExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``OptionalChainingExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: OptionalChainingExprSyntax) {
  }
  
  /// Visiting ``OptionalTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: OptionalTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``OptionalTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: OptionalTypeSyntax) {
  }
  
  /// Visiting ``OriginallyDefinedInAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: OriginallyDefinedInAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``OriginallyDefinedInAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: OriginallyDefinedInAttributeArgumentsSyntax) {
  }
  
  /// Visiting ``PackElementExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PackElementExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PackElementExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PackElementExprSyntax) {
  }
  
  /// Visiting ``PackElementTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PackElementTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PackElementTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PackElementTypeSyntax) {
  }
  
  /// Visiting ``PackExpansionExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PackExpansionExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PackExpansionExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PackExpansionExprSyntax) {
  }
  
  /// Visiting ``PackExpansionTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PackExpansionTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PackExpansionTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PackExpansionTypeSyntax) {
  }
  
  /// Visiting ``PatternBindingListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PatternBindingListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PatternBindingListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PatternBindingListSyntax) {
  }
  
  /// Visiting ``PatternBindingSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PatternBindingSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PatternBindingSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PatternBindingSyntax) {
  }
  
  /// Visiting ``PatternExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PatternExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PatternExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PatternExprSyntax) {
  }
  
  /// Visiting ``PlatformVersionItemListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PlatformVersionItemListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PlatformVersionItemListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PlatformVersionItemListSyntax) {
  }
  
  /// Visiting ``PlatformVersionItemSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PlatformVersionItemSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PlatformVersionItemSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PlatformVersionItemSyntax) {
  }
  
  /// Visiting ``PlatformVersionSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PlatformVersionSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PlatformVersionSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PlatformVersionSyntax) {
  }
  
  /// Visiting ``PostfixIfConfigExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PostfixIfConfigExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PostfixIfConfigExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PostfixIfConfigExprSyntax) {
  }
  
  /// Visiting ``PostfixOperatorExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PostfixOperatorExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PostfixOperatorExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PostfixOperatorExprSyntax) {
  }
  
  /// Visiting ``PoundSourceLocationArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PoundSourceLocationArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PoundSourceLocationArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PoundSourceLocationArgumentsSyntax) {
  }
  
  /// Visiting ``PoundSourceLocationSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PoundSourceLocationSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PoundSourceLocationSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PoundSourceLocationSyntax) {
  }
  
  /// Visiting ``PrecedenceGroupAssignmentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrecedenceGroupAssignmentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PrecedenceGroupAssignmentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrecedenceGroupAssignmentSyntax) {
  }
  
  /// Visiting ``PrecedenceGroupAssociativitySyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrecedenceGroupAssociativitySyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PrecedenceGroupAssociativitySyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrecedenceGroupAssociativitySyntax) {
  }
  
  /// Visiting ``PrecedenceGroupAttributeListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrecedenceGroupAttributeListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PrecedenceGroupAttributeListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrecedenceGroupAttributeListSyntax) {
  }
  
  /// Visiting ``PrecedenceGroupDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrecedenceGroupDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PrecedenceGroupDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrecedenceGroupDeclSyntax) {
  }
  
  /// Visiting ``PrecedenceGroupNameListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrecedenceGroupNameListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PrecedenceGroupNameListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrecedenceGroupNameListSyntax) {
  }
  
  /// Visiting ``PrecedenceGroupNameSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrecedenceGroupNameSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PrecedenceGroupNameSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrecedenceGroupNameSyntax) {
  }
  
  /// Visiting ``PrecedenceGroupRelationSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrecedenceGroupRelationSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PrecedenceGroupRelationSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrecedenceGroupRelationSyntax) {
  }
  
  /// Visiting ``PrefixOperatorExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrefixOperatorExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PrefixOperatorExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrefixOperatorExprSyntax) {
  }
  
  /// Visiting ``PrimaryAssociatedTypeClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrimaryAssociatedTypeClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PrimaryAssociatedTypeClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrimaryAssociatedTypeClauseSyntax) {
  }
  
  /// Visiting ``PrimaryAssociatedTypeListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrimaryAssociatedTypeListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PrimaryAssociatedTypeListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrimaryAssociatedTypeListSyntax) {
  }
  
  /// Visiting ``PrimaryAssociatedTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: PrimaryAssociatedTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``PrimaryAssociatedTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: PrimaryAssociatedTypeSyntax) {
  }
  
  /// Visiting ``ProtocolDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ProtocolDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ProtocolDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ProtocolDeclSyntax) {
  }
  
  /// Visiting ``RegexLiteralExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: RegexLiteralExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``RegexLiteralExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: RegexLiteralExprSyntax) {
  }
  
  /// Visiting ``RepeatStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: RepeatStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``RepeatStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: RepeatStmtSyntax) {
  }
  
  /// Visiting ``ReturnClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ReturnClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ReturnClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ReturnClauseSyntax) {
  }
  
  /// Visiting ``ReturnStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ReturnStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ReturnStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ReturnStmtSyntax) {
  }
  
  /// Visiting ``SameTypeRequirementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SameTypeRequirementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SameTypeRequirementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SameTypeRequirementSyntax) {
  }
  
  /// Visiting ``SequenceExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SequenceExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SequenceExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SequenceExprSyntax) {
  }
  
  /// Visiting ``SimpleStringLiteralExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SimpleStringLiteralExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SimpleStringLiteralExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SimpleStringLiteralExprSyntax) {
  }
  
  /// Visiting ``SimpleStringLiteralSegmentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SimpleStringLiteralSegmentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SimpleStringLiteralSegmentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SimpleStringLiteralSegmentListSyntax) {
  }
  
  /// Visiting ``SomeOrAnyTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SomeOrAnyTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SomeOrAnyTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SomeOrAnyTypeSyntax) {
  }
  
  /// Visiting ``SourceFileSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SourceFileSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SourceFileSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SourceFileSyntax) {
  }
  
  /// Visiting ``SpecializeAttributeArgumentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SpecializeAttributeArgumentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SpecializeAttributeArgumentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SpecializeAttributeArgumentListSyntax) {
  }
  
  /// Visiting ``SpecializeAvailabilityArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SpecializeAvailabilityArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SpecializeAvailabilityArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SpecializeAvailabilityArgumentSyntax) {
  }
  
  /// Visiting ``SpecializeTargetFunctionArgumentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SpecializeTargetFunctionArgumentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SpecializeTargetFunctionArgumentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SpecializeTargetFunctionArgumentSyntax) {
  }
  
  /// Visiting ``StringLiteralExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: StringLiteralExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``StringLiteralExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: StringLiteralExprSyntax) {
  }
  
  /// Visiting ``StringLiteralSegmentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: StringLiteralSegmentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``StringLiteralSegmentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: StringLiteralSegmentListSyntax) {
  }
  
  /// Visiting ``StringSegmentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: StringSegmentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``StringSegmentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: StringSegmentSyntax) {
  }
  
  /// Visiting ``StructDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: StructDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``StructDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: StructDeclSyntax) {
  }
  
  /// Visiting ``SubscriptCallExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SubscriptCallExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SubscriptCallExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SubscriptCallExprSyntax) {
  }
  
  /// Visiting ``SubscriptDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SubscriptDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SubscriptDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SubscriptDeclSyntax) {
  }
  
  /// Visiting ``SuperExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SuperExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SuperExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SuperExprSyntax) {
  }
  
  /// Visiting ``SuppressedTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SuppressedTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SuppressedTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SuppressedTypeSyntax) {
  }
  
  /// Visiting ``SwitchCaseItemListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SwitchCaseItemListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SwitchCaseItemListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SwitchCaseItemListSyntax) {
  }
  
  /// Visiting ``SwitchCaseItemSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SwitchCaseItemSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SwitchCaseItemSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SwitchCaseItemSyntax) {
  }
  
  /// Visiting ``SwitchCaseLabelSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SwitchCaseLabelSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SwitchCaseLabelSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SwitchCaseLabelSyntax) {
  }
  
  /// Visiting ``SwitchCaseListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SwitchCaseListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SwitchCaseListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SwitchCaseListSyntax) {
  }
  
  /// Visiting ``SwitchCaseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SwitchCaseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SwitchCaseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SwitchCaseSyntax) {
  }
  
  /// Visiting ``SwitchDefaultLabelSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SwitchDefaultLabelSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SwitchDefaultLabelSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SwitchDefaultLabelSyntax) {
  }
  
  /// Visiting ``SwitchExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: SwitchExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``SwitchExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: SwitchExprSyntax) {
  }
  
  /// Visiting ``TernaryExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TernaryExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``TernaryExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TernaryExprSyntax) {
  }
  
  /// Visiting ``ThenStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ThenStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ThenStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ThenStmtSyntax) {
  }
  
  /// Visiting ``ThrowStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ThrowStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ThrowStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ThrowStmtSyntax) {
  }
  
  /// Visiting ``TryExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TryExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``TryExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TryExprSyntax) {
  }
  
  /// Visiting ``TupleExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TupleExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``TupleExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TupleExprSyntax) {
  }
  
  /// Visiting ``TuplePatternElementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TuplePatternElementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``TuplePatternElementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TuplePatternElementListSyntax) {
  }
  
  /// Visiting ``TuplePatternElementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TuplePatternElementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``TuplePatternElementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TuplePatternElementSyntax) {
  }
  
  /// Visiting ``TuplePatternSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TuplePatternSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``TuplePatternSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TuplePatternSyntax) {
  }
  
  /// Visiting ``TupleTypeElementListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TupleTypeElementListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``TupleTypeElementListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TupleTypeElementListSyntax) {
  }
  
  /// Visiting ``TupleTypeElementSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TupleTypeElementSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``TupleTypeElementSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TupleTypeElementSyntax) {
  }
  
  /// Visiting ``TupleTypeSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TupleTypeSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``TupleTypeSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TupleTypeSyntax) {
  }
  
  /// Visiting ``TypeAliasDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TypeAliasDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``TypeAliasDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TypeAliasDeclSyntax) {
  }
  
  /// Visiting ``TypeAnnotationSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TypeAnnotationSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``TypeAnnotationSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TypeAnnotationSyntax) {
  }
  
  /// Visiting ``TypeEffectSpecifiersSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TypeEffectSpecifiersSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``TypeEffectSpecifiersSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TypeEffectSpecifiersSyntax) {
  }
  
  /// Visiting ``TypeExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TypeExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``TypeExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TypeExprSyntax) {
  }
  
  /// Visiting ``TypeInitializerClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: TypeInitializerClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``TypeInitializerClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TypeInitializerClauseSyntax) {
  }
  
  /// Visiting ``UnavailableFromAsyncAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: UnavailableFromAsyncAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``UnavailableFromAsyncAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: UnavailableFromAsyncAttributeArgumentsSyntax) {
  }
  
  /// Visiting ``UnderscorePrivateAttributeArgumentsSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: UnderscorePrivateAttributeArgumentsSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``UnderscorePrivateAttributeArgumentsSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: UnderscorePrivateAttributeArgumentsSyntax) {
  }
  
  /// Visiting ``UnexpectedNodesSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: UnexpectedNodesSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``UnexpectedNodesSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: UnexpectedNodesSyntax) {
  }
  
  /// Visiting ``UnresolvedAsExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: UnresolvedAsExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``UnresolvedAsExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: UnresolvedAsExprSyntax) {
  }
  
  /// Visiting ``UnresolvedIsExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: UnresolvedIsExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``UnresolvedIsExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: UnresolvedIsExprSyntax) {
  }
  
  /// Visiting ``UnresolvedTernaryExprSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: UnresolvedTernaryExprSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``UnresolvedTernaryExprSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: UnresolvedTernaryExprSyntax) {
  }
  
  /// Visiting ``ValueBindingPatternSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: ValueBindingPatternSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``ValueBindingPatternSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: ValueBindingPatternSyntax) {
  }
  
  /// Visiting ``VariableDeclSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: VariableDeclSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``VariableDeclSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: VariableDeclSyntax) {
  }
  
  /// Visiting ``VersionComponentListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: VersionComponentListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``VersionComponentListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: VersionComponentListSyntax) {
  }
  
  /// Visiting ``VersionComponentSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: VersionComponentSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``VersionComponentSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: VersionComponentSyntax) {
  }
  
  /// Visiting ``VersionTupleSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: VersionTupleSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``VersionTupleSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: VersionTupleSyntax) {
  }
  
  /// Visiting ``WhereClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: WhereClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``WhereClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: WhereClauseSyntax) {
  }
  
  /// Visiting ``WhileStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: WhileStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``WhileStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: WhileStmtSyntax) {
  }
  
  /// Visiting ``WildcardPatternSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: WildcardPatternSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``WildcardPatternSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: WildcardPatternSyntax) {
  }
  
  /// Visiting ``YieldStmtSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: YieldStmtSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``YieldStmtSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: YieldStmtSyntax) {
  }
  
  /// Visiting ``YieldedExpressionListSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: YieldedExpressionListSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``YieldedExpressionListSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: YieldedExpressionListSyntax) {
  }
  
  /// Visiting ``YieldedExpressionSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: YieldedExpressionSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``YieldedExpressionSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: YieldedExpressionSyntax) {
  }
  
  /// Visiting ``YieldedExpressionsClauseSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ node: YieldedExpressionsClauseSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting ``YieldedExpressionsClauseSyntax`` and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: YieldedExpressionsClauseSyntax) {
  }
  
  /// Visiting ``TokenSyntax`` specifically.
  ///   - Parameter node: the node we are visiting.
  ///   - Returns: how should we continue visiting.
  open func visit(_ token: TokenSyntax) -> SyntaxVisitorContinueKind {
    return .visitChildren
  }
  
  /// The function called after visiting the node and its descendants.
  ///   - node: the node we just finished visiting.
  open func visitPost(_ node: TokenSyntax) {
  }
  
  /// Interpret `data` as a node of type `nodeType`, visit it, calling
  /// the `visit` and `visitPost` functions during visitation.
  private func visitImpl<NodeType: SyntaxProtocol>(
    _ node: Syntax,
    _ nodeType: NodeType.Type,
    _ visit: (NodeType) -> SyntaxVisitorContinueKind,
    _ visitPost: (NodeType) -> Void
  ) {
    let node = node.cast(NodeType.self)
    let needsChildren = (visit(node) == .visitChildren)
    // Avoid calling into visitChildren if possible.
    if needsChildren && !node.raw.layoutView!.children.isEmpty {
      visitChildren(node)
    }
    visitPost(node)
  }
  
  // SwiftSyntax requires a lot of stack space in debug builds for syntax tree
  // visitation. In scenarios with reduced stack space (in particular dispatch
  // queues), this easily results in a stack overflow. To work around this issue,
  // use a less performant but also less stack-hungry version of SwiftSyntax's
  // SyntaxVisitor in debug builds.
  #if DEBUG
  /// Implementation detail of visit(_:). Do not call directly.
  ///
  /// Returns the function that shall be called to visit a specific syntax node.
  ///
  /// To determine the correct specific visitation function for a syntax node,
  /// we need to switch through a huge switch statement that covers all syntax
  /// types. In debug builds, the cases of this switch statement do not share
  /// stack space (rdar://55929175). Because of this, the switch statement
  /// requires about 15KB of stack space. In scenarios with reduced
  /// stack size (in particular dispatch queues), this often results in a stack
  /// overflow during syntax tree rewriting.
  ///
  /// To circumvent this problem, make calling the specific visitation function
  /// a two-step process: First determine the function to call in this function
  /// and return a reference to it, then call it. This way, the stack frame
  /// that determines the correct visitation function will be popped of the
  /// stack before the function is being called, making the switch's stack
  /// space transient instead of having it linger in the call stack.
  private func visitationFunc(for node: Syntax) -> ((Syntax) -> Void) {
    switch node.raw.kind {
    case .token:
      return {
        let node = $0.cast(TokenSyntax.self)
        _ = self.visit(node)
        // No children to visit.
        self.visitPost(node)
      }
    case .accessorBlock:
      return {
        self.visitImpl($0, AccessorBlockSyntax.self, self.visit, self.visitPost)
      }
    case .accessorDeclList:
      return {
        self.visitImpl($0, AccessorDeclListSyntax.self, self.visit, self.visitPost)
      }
    case .accessorDecl:
      return {
        self.visitImpl($0, AccessorDeclSyntax.self, self.visit, self.visitPost)
      }
    case .accessorEffectSpecifiers:
      return {
        self.visitImpl($0, AccessorEffectSpecifiersSyntax.self, self.visit, self.visitPost)
      }
    case .accessorParameters:
      return {
        self.visitImpl($0, AccessorParametersSyntax.self, self.visit, self.visitPost)
      }
    case .actorDecl:
      return {
        self.visitImpl($0, ActorDeclSyntax.self, self.visit, self.visitPost)
      }
    case .arrayElementList:
      return {
        self.visitImpl($0, ArrayElementListSyntax.self, self.visit, self.visitPost)
      }
    case .arrayElement:
      return {
        self.visitImpl($0, ArrayElementSyntax.self, self.visit, self.visitPost)
      }
    case .arrayExpr:
      return {
        self.visitImpl($0, ArrayExprSyntax.self, self.visit, self.visitPost)
      }
    case .arrayType:
      return {
        self.visitImpl($0, ArrayTypeSyntax.self, self.visit, self.visitPost)
      }
    case .arrowExpr:
      return {
        self.visitImpl($0, ArrowExprSyntax.self, self.visit, self.visitPost)
      }
    case .asExpr:
      return {
        self.visitImpl($0, AsExprSyntax.self, self.visit, self.visitPost)
      }
    case .assignmentExpr:
      return {
        self.visitImpl($0, AssignmentExprSyntax.self, self.visit, self.visitPost)
      }
    case .associatedTypeDecl:
      return {
        self.visitImpl($0, AssociatedTypeDeclSyntax.self, self.visit, self.visitPost)
      }
    case .attributeList:
      return {
        self.visitImpl($0, AttributeListSyntax.self, self.visit, self.visitPost)
      }
    case .attribute:
      return {
        self.visitImpl($0, AttributeSyntax.self, self.visit, self.visitPost)
      }
    case .attributedType:
      return {
        self.visitImpl($0, AttributedTypeSyntax.self, self.visit, self.visitPost)
      }
    case .availabilityArgumentList:
      return {
        self.visitImpl($0, AvailabilityArgumentListSyntax.self, self.visit, self.visitPost)
      }
    case .availabilityArgument:
      return {
        self.visitImpl($0, AvailabilityArgumentSyntax.self, self.visit, self.visitPost)
      }
    case .availabilityCondition:
      return {
        self.visitImpl($0, AvailabilityConditionSyntax.self, self.visit, self.visitPost)
      }
    case .availabilityLabeledArgument:
      return {
        self.visitImpl($0, AvailabilityLabeledArgumentSyntax.self, self.visit, self.visitPost)
      }
    case .awaitExpr:
      return {
        self.visitImpl($0, AwaitExprSyntax.self, self.visit, self.visitPost)
      }
    case .backDeployedAttributeArguments:
      return {
        self.visitImpl($0, BackDeployedAttributeArgumentsSyntax.self, self.visit, self.visitPost)
      }
    case .binaryOperatorExpr:
      return {
        self.visitImpl($0, BinaryOperatorExprSyntax.self, self.visit, self.visitPost)
      }
    case .booleanLiteralExpr:
      return {
        self.visitImpl($0, BooleanLiteralExprSyntax.self, self.visit, self.visitPost)
      }
    case .borrowExpr:
      return {
        self.visitImpl($0, BorrowExprSyntax.self, self.visit, self.visitPost)
      }
    case .breakStmt:
      return {
        self.visitImpl($0, BreakStmtSyntax.self, self.visit, self.visitPost)
      }
    case .canImportExpr:
      return {
        self.visitImpl($0, CanImportExprSyntax.self, self.visit, self.visitPost)
      }
    case .canImportVersionInfo:
      return {
        self.visitImpl($0, CanImportVersionInfoSyntax.self, self.visit, self.visitPost)
      }
    case .catchClauseList:
      return {
        self.visitImpl($0, CatchClauseListSyntax.self, self.visit, self.visitPost)
      }
    case .catchClause:
      return {
        self.visitImpl($0, CatchClauseSyntax.self, self.visit, self.visitPost)
      }
    case .catchItemList:
      return {
        self.visitImpl($0, CatchItemListSyntax.self, self.visit, self.visitPost)
      }
    case .catchItem:
      return {
        self.visitImpl($0, CatchItemSyntax.self, self.visit, self.visitPost)
      }
    case .classDecl:
      return {
        self.visitImpl($0, ClassDeclSyntax.self, self.visit, self.visitPost)
      }
    case .classRestrictionType:
      return {
        self.visitImpl($0, ClassRestrictionTypeSyntax.self, self.visit, self.visitPost)
      }
    case .closureCaptureClause:
      return {
        self.visitImpl($0, ClosureCaptureClauseSyntax.self, self.visit, self.visitPost)
      }
    case .closureCaptureList:
      return {
        self.visitImpl($0, ClosureCaptureListSyntax.self, self.visit, self.visitPost)
      }
    case .closureCaptureSpecifier:
      return {
        self.visitImpl($0, ClosureCaptureSpecifierSyntax.self, self.visit, self.visitPost)
      }
    case .closureCapture:
      return {
        self.visitImpl($0, ClosureCaptureSyntax.self, self.visit, self.visitPost)
      }
    case .closureExpr:
      return {
        self.visitImpl($0, ClosureExprSyntax.self, self.visit, self.visitPost)
      }
    case .closureParameterClause:
      return {
        self.visitImpl($0, ClosureParameterClauseSyntax.self, self.visit, self.visitPost)
      }
    case .closureParameterList:
      return {
        self.visitImpl($0, ClosureParameterListSyntax.self, self.visit, self.visitPost)
      }
    case .closureParameter:
      return {
        self.visitImpl($0, ClosureParameterSyntax.self, self.visit, self.visitPost)
      }
    case .closureShorthandParameterList:
      return {
        self.visitImpl($0, ClosureShorthandParameterListSyntax.self, self.visit, self.visitPost)
      }
    case .closureShorthandParameter:
      return {
        self.visitImpl($0, ClosureShorthandParameterSyntax.self, self.visit, self.visitPost)
      }
    case .closureSignature:
      return {
        self.visitImpl($0, ClosureSignatureSyntax.self, self.visit, self.visitPost)
      }
    case .codeBlockItemList:
      return {
        self.visitImpl($0, CodeBlockItemListSyntax.self, self.visit, self.visitPost)
      }
    case .codeBlockItem:
      return {
        self.visitImpl($0, CodeBlockItemSyntax.self, self.visit, self.visitPost)
      }
    case .codeBlock:
      return {
        self.visitImpl($0, CodeBlockSyntax.self, self.visit, self.visitPost)
      }
    case .compositionTypeElementList:
      return {
        self.visitImpl($0, CompositionTypeElementListSyntax.self, self.visit, self.visitPost)
      }
    case .compositionTypeElement:
      return {
        self.visitImpl($0, CompositionTypeElementSyntax.self, self.visit, self.visitPost)
      }
    case .compositionType:
      return {
        self.visitImpl($0, CompositionTypeSyntax.self, self.visit, self.visitPost)
      }
    case .conditionElementList:
      return {
        self.visitImpl($0, ConditionElementListSyntax.self, self.visit, self.visitPost)
      }
    case .conditionElement:
      return {
        self.visitImpl($0, ConditionElementSyntax.self, self.visit, self.visitPost)
      }
    case .conformanceRequirement:
      return {
        self.visitImpl($0, ConformanceRequirementSyntax.self, self.visit, self.visitPost)
      }
    case .consumeExpr:
      return {
        self.visitImpl($0, ConsumeExprSyntax.self, self.visit, self.visitPost)
      }
    case .continueStmt:
      return {
        self.visitImpl($0, ContinueStmtSyntax.self, self.visit, self.visitPost)
      }
    case .conventionAttributeArguments:
      return {
        self.visitImpl($0, ConventionAttributeArgumentsSyntax.self, self.visit, self.visitPost)
      }
    case .conventionWitnessMethodAttributeArguments:
      return {
        self.visitImpl($0, ConventionWitnessMethodAttributeArgumentsSyntax.self, self.visit, self.visitPost)
      }
    case .copyExpr:
      return {
        self.visitImpl($0, CopyExprSyntax.self, self.visit, self.visitPost)
      }
    case .declModifierDetail:
      return {
        self.visitImpl($0, DeclModifierDetailSyntax.self, self.visit, self.visitPost)
      }
    case .declModifierList:
      return {
        self.visitImpl($0, DeclModifierListSyntax.self, self.visit, self.visitPost)
      }
    case .declModifier:
      return {
        self.visitImpl($0, DeclModifierSyntax.self, self.visit, self.visitPost)
      }
    case .declNameArgumentList:
      return {
        self.visitImpl($0, DeclNameArgumentListSyntax.self, self.visit, self.visitPost)
      }
    case .declNameArgument:
      return {
        self.visitImpl($0, DeclNameArgumentSyntax.self, self.visit, self.visitPost)
      }
    case .declNameArguments:
      return {
        self.visitImpl($0, DeclNameArgumentsSyntax.self, self.visit, self.visitPost)
      }
    case .declReferenceExpr:
      return {
        self.visitImpl($0, DeclReferenceExprSyntax.self, self.visit, self.visitPost)
      }
    case .deferStmt:
      return {
        self.visitImpl($0, DeferStmtSyntax.self, self.visit, self.visitPost)
      }
    case .deinitializerDecl:
      return {
        self.visitImpl($0, DeinitializerDeclSyntax.self, self.visit, self.visitPost)
      }
    case .deinitializerEffectSpecifiers:
      return {
        self.visitImpl($0, DeinitializerEffectSpecifiersSyntax.self, self.visit, self.visitPost)
      }
    case .derivativeAttributeArguments:
      return {
        self.visitImpl($0, DerivativeAttributeArgumentsSyntax.self, self.visit, self.visitPost)
      }
    case .designatedTypeList:
      return {
        self.visitImpl($0, DesignatedTypeListSyntax.self, self.visit, self.visitPost)
      }
    case .designatedType:
      return {
        self.visitImpl($0, DesignatedTypeSyntax.self, self.visit, self.visitPost)
      }
    case .dictionaryElementList:
      return {
        self.visitImpl($0, DictionaryElementListSyntax.self, self.visit, self.visitPost)
      }
    case .dictionaryElement:
      return {
        self.visitImpl($0, DictionaryElementSyntax.self, self.visit, self.visitPost)
      }
    case .dictionaryExpr:
      return {
        self.visitImpl($0, DictionaryExprSyntax.self, self.visit, self.visitPost)
      }
    case .dictionaryType:
      return {
        self.visitImpl($0, DictionaryTypeSyntax.self, self.visit, self.visitPost)
      }
    case .differentiabilityArgumentList:
      return {
        self.visitImpl($0, DifferentiabilityArgumentListSyntax.self, self.visit, self.visitPost)
      }
    case .differentiabilityArgument:
      return {
        self.visitImpl($0, DifferentiabilityArgumentSyntax.self, self.visit, self.visitPost)
      }
    case .differentiabilityArguments:
      return {
        self.visitImpl($0, DifferentiabilityArgumentsSyntax.self, self.visit, self.visitPost)
      }
    case .differentiabilityWithRespectToArgument:
      return {
        self.visitImpl($0, DifferentiabilityWithRespectToArgumentSyntax.self, self.visit, self.visitPost)
      }
    case .differentiableAttributeArguments:
      return {
        self.visitImpl($0, DifferentiableAttributeArgumentsSyntax.self, self.visit, self.visitPost)
      }
    case .discardAssignmentExpr:
      return {
        self.visitImpl($0, DiscardAssignmentExprSyntax.self, self.visit, self.visitPost)
      }
    case .discardStmt:
      return {
        self.visitImpl($0, DiscardStmtSyntax.self, self.visit, self.visitPost)
      }
    case .doStmt:
      return {
        self.visitImpl($0, DoStmtSyntax.self, self.visit, self.visitPost)
      }
    case .documentationAttributeArgumentList:
      return {
        self.visitImpl($0, DocumentationAttributeArgumentListSyntax.self, self.visit, self.visitPost)
      }
    case .documentationAttributeArgument:
      return {
        self.visitImpl($0, DocumentationAttributeArgumentSyntax.self, self.visit, self.visitPost)
      }
    case .dynamicReplacementAttributeArguments:
      return {
        self.visitImpl($0, DynamicReplacementAttributeArgumentsSyntax.self, self.visit, self.visitPost)
      }
    case .editorPlaceholderDecl:
      return {
        self.visitImpl($0, EditorPlaceholderDeclSyntax.self, self.visit, self.visitPost)
      }
    case .editorPlaceholderExpr:
      return {
        self.visitImpl($0, EditorPlaceholderExprSyntax.self, self.visit, self.visitPost)
      }
    case .effectsAttributeArgumentList:
      return {
        self.visitImpl($0, EffectsAttributeArgumentListSyntax.self, self.visit, self.visitPost)
      }
    case .enumCaseDecl:
      return {
        self.visitImpl($0, EnumCaseDeclSyntax.self, self.visit, self.visitPost)
      }
    case .enumCaseElementList:
      return {
        self.visitImpl($0, EnumCaseElementListSyntax.self, self.visit, self.visitPost)
      }
    case .enumCaseElement:
      return {
        self.visitImpl($0, EnumCaseElementSyntax.self, self.visit, self.visitPost)
      }
    case .enumCaseParameterClause:
      return {
        self.visitImpl($0, EnumCaseParameterClauseSyntax.self, self.visit, self.visitPost)
      }
    case .enumCaseParameterList:
      return {
        self.visitImpl($0, EnumCaseParameterListSyntax.self, self.visit, self.visitPost)
      }
    case .enumCaseParameter:
      return {
        self.visitImpl($0, EnumCaseParameterSyntax.self, self.visit, self.visitPost)
      }
    case .enumDecl:
      return {
        self.visitImpl($0, EnumDeclSyntax.self, self.visit, self.visitPost)
      }
    case .exposeAttributeArguments:
      return {
        self.visitImpl($0, ExposeAttributeArgumentsSyntax.self, self.visit, self.visitPost)
      }
    case .exprList:
      return {
        self.visitImpl($0, ExprListSyntax.self, self.visit, self.visitPost)
      }
    case .expressionPattern:
      return {
        self.visitImpl($0, ExpressionPatternSyntax.self, self.visit, self.visitPost)
      }
    case .expressionSegment:
      return {
        self.visitImpl($0, ExpressionSegmentSyntax.self, self.visit, self.visitPost)
      }
    case .expressionStmt:
      return {
        self.visitImpl($0, ExpressionStmtSyntax.self, self.visit, self.visitPost)
      }
    case .extensionDecl:
      return {
        self.visitImpl($0, ExtensionDeclSyntax.self, self.visit, self.visitPost)
      }
    case .fallThroughStmt:
      return {
        self.visitImpl($0, FallThroughStmtSyntax.self, self.visit, self.visitPost)
      }
    case .floatLiteralExpr:
      return {
        self.visitImpl($0, FloatLiteralExprSyntax.self, self.visit, self.visitPost)
      }
    case .forStmt:
      return {
        self.visitImpl($0, ForStmtSyntax.self, self.visit, self.visitPost)
      }
    case .forceUnwrapExpr:
      return {
        self.visitImpl($0, ForceUnwrapExprSyntax.self, self.visit, self.visitPost)
      }
    case .functionCallExpr:
      return {
        self.visitImpl($0, FunctionCallExprSyntax.self, self.visit, self.visitPost)
      }
    case .functionDecl:
      return {
        self.visitImpl($0, FunctionDeclSyntax.self, self.visit, self.visitPost)
      }
    case .functionEffectSpecifiers:
      return {
        self.visitImpl($0, FunctionEffectSpecifiersSyntax.self, self.visit, self.visitPost)
      }
    case .functionParameterClause:
      return {
        self.visitImpl($0, FunctionParameterClauseSyntax.self, self.visit, self.visitPost)
      }
    case .functionParameterList:
      return {
        self.visitImpl($0, FunctionParameterListSyntax.self, self.visit, self.visitPost)
      }
    case .functionParameter:
      return {
        self.visitImpl($0, FunctionParameterSyntax.self, self.visit, self.visitPost)
      }
    case .functionSignature:
      return {
        self.visitImpl($0, FunctionSignatureSyntax.self, self.visit, self.visitPost)
      }
    case .functionType:
      return {
        self.visitImpl($0, FunctionTypeSyntax.self, self.visit, self.visitPost)
      }
    case .genericArgumentClause:
      return {
        self.visitImpl($0, GenericArgumentClauseSyntax.self, self.visit, self.visitPost)
      }
    case .genericArgumentList:
      return {
        self.visitImpl($0, GenericArgumentListSyntax.self, self.visit, self.visitPost)
      }
    case .genericArgument:
      return {
        self.visitImpl($0, GenericArgumentSyntax.self, self.visit, self.visitPost)
      }
    case .genericParameterClause:
      return {
        self.visitImpl($0, GenericParameterClauseSyntax.self, self.visit, self.visitPost)
      }
    case .genericParameterList:
      return {
        self.visitImpl($0, GenericParameterListSyntax.self, self.visit, self.visitPost)
      }
    case .genericParameter:
      return {
        self.visitImpl($0, GenericParameterSyntax.self, self.visit, self.visitPost)
      }
    case .genericRequirementList:
      return {
        self.visitImpl($0, GenericRequirementListSyntax.self, self.visit, self.visitPost)
      }
    case .genericRequirement:
      return {
        self.visitImpl($0, GenericRequirementSyntax.self, self.visit, self.visitPost)
      }
    case .genericSpecializationExpr:
      return {
        self.visitImpl($0, GenericSpecializationExprSyntax.self, self.visit, self.visitPost)
      }
    case .genericWhereClause:
      return {
        self.visitImpl($0, GenericWhereClauseSyntax.self, self.visit, self.visitPost)
      }
    case .guardStmt:
      return {
        self.visitImpl($0, GuardStmtSyntax.self, self.visit, self.visitPost)
      }
    case .identifierPattern:
      return {
        self.visitImpl($0, IdentifierPatternSyntax.self, self.visit, self.visitPost)
      }
    case .identifierType:
      return {
        self.visitImpl($0, IdentifierTypeSyntax.self, self.visit, self.visitPost)
      }
    case .ifConfigClauseList:
      return {
        self.visitImpl($0, IfConfigClauseListSyntax.self, self.visit, self.visitPost)
      }
    case .ifConfigClause:
      return {
        self.visitImpl($0, IfConfigClauseSyntax.self, self.visit, self.visitPost)
      }
    case .ifConfigDecl:
      return {
        self.visitImpl($0, IfConfigDeclSyntax.self, self.visit, self.visitPost)
      }
    case .ifExpr:
      return {
        self.visitImpl($0, IfExprSyntax.self, self.visit, self.visitPost)
      }
    case .implementsAttributeArguments:
      return {
        self.visitImpl($0, ImplementsAttributeArgumentsSyntax.self, self.visit, self.visitPost)
      }
    case .implicitlyUnwrappedOptionalType:
      return {
        self.visitImpl($0, ImplicitlyUnwrappedOptionalTypeSyntax.self, self.visit, self.visitPost)
      }
    case .importDecl:
      return {
        self.visitImpl($0, ImportDeclSyntax.self, self.visit, self.visitPost)
      }
    case .importPathComponentList:
      return {
        self.visitImpl($0, ImportPathComponentListSyntax.self, self.visit, self.visitPost)
      }
    case .importPathComponent:
      return {
        self.visitImpl($0, ImportPathComponentSyntax.self, self.visit, self.visitPost)
      }
    case .inOutExpr:
      return {
        self.visitImpl($0, InOutExprSyntax.self, self.visit, self.visitPost)
      }
    case .infixOperatorExpr:
      return {
        self.visitImpl($0, InfixOperatorExprSyntax.self, self.visit, self.visitPost)
      }
    case .inheritanceClause:
      return {
        self.visitImpl($0, InheritanceClauseSyntax.self, self.visit, self.visitPost)
      }
    case .inheritedTypeList:
      return {
        self.visitImpl($0, InheritedTypeListSyntax.self, self.visit, self.visitPost)
      }
    case .inheritedType:
      return {
        self.visitImpl($0, InheritedTypeSyntax.self, self.visit, self.visitPost)
      }
    case .initializerClause:
      return {
        self.visitImpl($0, InitializerClauseSyntax.self, self.visit, self.visitPost)
      }
    case .initializerDecl:
      return {
        self.visitImpl($0, InitializerDeclSyntax.self, self.visit, self.visitPost)
      }
    case .integerLiteralExpr:
      return {
        self.visitImpl($0, IntegerLiteralExprSyntax.self, self.visit, self.visitPost)
      }
    case .isExpr:
      return {
        self.visitImpl($0, IsExprSyntax.self, self.visit, self.visitPost)
      }
    case .isTypePattern:
      return {
        self.visitImpl($0, IsTypePatternSyntax.self, self.visit, self.visitPost)
      }
    case .keyPathComponentList:
      return {
        self.visitImpl($0, KeyPathComponentListSyntax.self, self.visit, self.visitPost)
      }
    case .keyPathComponent:
      return {
        self.visitImpl($0, KeyPathComponentSyntax.self, self.visit, self.visitPost)
      }
    case .keyPathExpr:
      return {
        self.visitImpl($0, KeyPathExprSyntax.self, self.visit, self.visitPost)
      }
    case .keyPathOptionalComponent:
      return {
        self.visitImpl($0, KeyPathOptionalComponentSyntax.self, self.visit, self.visitPost)
      }
    case .keyPathPropertyComponent:
      return {
        self.visitImpl($0, KeyPathPropertyComponentSyntax.self, self.visit, self.visitPost)
      }
    case .keyPathSubscriptComponent:
      return {
        self.visitImpl($0, KeyPathSubscriptComponentSyntax.self, self.visit, self.visitPost)
      }
    case .labeledExprList:
      return {
        self.visitImpl($0, LabeledExprListSyntax.self, self.visit, self.visitPost)
      }
    case .labeledExpr:
      return {
        self.visitImpl($0, LabeledExprSyntax.self, self.visit, self.visitPost)
      }
    case .labeledSpecializeArgument:
      return {
        self.visitImpl($0, LabeledSpecializeArgumentSyntax.self, self.visit, self.visitPost)
      }
    case .labeledStmt:
      return {
        self.visitImpl($0, LabeledStmtSyntax.self, self.visit, self.visitPost)
      }
    case .layoutRequirement:
      return {
        self.visitImpl($0, LayoutRequirementSyntax.self, self.visit, self.visitPost)
      }
    case .macroDecl:
      return {
        self.visitImpl($0, MacroDeclSyntax.self, self.visit, self.visitPost)
      }
    case .macroExpansionDecl:
      return {
        self.visitImpl($0, MacroExpansionDeclSyntax.self, self.visit, self.visitPost)
      }
    case .macroExpansionExpr:
      return {
        self.visitImpl($0, MacroExpansionExprSyntax.self, self.visit, self.visitPost)
      }
    case .matchingPatternCondition:
      return {
        self.visitImpl($0, MatchingPatternConditionSyntax.self, self.visit, self.visitPost)
      }
    case .memberAccessExpr:
      return {
        self.visitImpl($0, MemberAccessExprSyntax.self, self.visit, self.visitPost)
      }
    case .memberBlockItemList:
      return {
        self.visitImpl($0, MemberBlockItemListSyntax.self, self.visit, self.visitPost)
      }
    case .memberBlockItem:
      return {
        self.visitImpl($0, MemberBlockItemSyntax.self, self.visit, self.visitPost)
      }
    case .memberBlock:
      return {
        self.visitImpl($0, MemberBlockSyntax.self, self.visit, self.visitPost)
      }
    case .memberType:
      return {
        self.visitImpl($0, MemberTypeSyntax.self, self.visit, self.visitPost)
      }
    case .metatypeType:
      return {
        self.visitImpl($0, MetatypeTypeSyntax.self, self.visit, self.visitPost)
      }
    case .missingDecl:
      return {
        self.visitImpl($0, MissingDeclSyntax.self, self.visit, self.visitPost)
      }
    case .missingExpr:
      return {
        self.visitImpl($0, MissingExprSyntax.self, self.visit, self.visitPost)
      }
    case .missingPattern:
      return {
        self.visitImpl($0, MissingPatternSyntax.self, self.visit, self.visitPost)
      }
    case .missingStmt:
      return {
        self.visitImpl($0, MissingStmtSyntax.self, self.visit, self.visitPost)
      }
    case .missing:
      return {
        self.visitImpl($0, MissingSyntax.self, self.visit, self.visitPost)
      }
    case .missingType:
      return {
        self.visitImpl($0, MissingTypeSyntax.self, self.visit, self.visitPost)
      }
    case .multipleTrailingClosureElementList:
      return {
        self.visitImpl($0, MultipleTrailingClosureElementListSyntax.self, self.visit, self.visitPost)
      }
    case .multipleTrailingClosureElement:
      return {
        self.visitImpl($0, MultipleTrailingClosureElementSyntax.self, self.visit, self.visitPost)
      }
    case .namedOpaqueReturnType:
      return {
        self.visitImpl($0, NamedOpaqueReturnTypeSyntax.self, self.visit, self.visitPost)
      }
    case .nilLiteralExpr:
      return {
        self.visitImpl($0, NilLiteralExprSyntax.self, self.visit, self.visitPost)
      }
    case .objCSelectorPieceList:
      return {
        self.visitImpl($0, ObjCSelectorPieceListSyntax.self, self.visit, self.visitPost)
      }
    case .objCSelectorPiece:
      return {
        self.visitImpl($0, ObjCSelectorPieceSyntax.self, self.visit, self.visitPost)
      }
    case .opaqueReturnTypeOfAttributeArguments:
      return {
        self.visitImpl($0, OpaqueReturnTypeOfAttributeArgumentsSyntax.self, self.visit, self.visitPost)
      }
    case .operatorDecl:
      return {
        self.visitImpl($0, OperatorDeclSyntax.self, self.visit, self.visitPost)
      }
    case .operatorPrecedenceAndTypes:
      return {
        self.visitImpl($0, OperatorPrecedenceAndTypesSyntax.self, self.visit, self.visitPost)
      }
    case .optionalBindingCondition:
      return {
        self.visitImpl($0, OptionalBindingConditionSyntax.self, self.visit, self.visitPost)
      }
    case .optionalChainingExpr:
      return {
        self.visitImpl($0, OptionalChainingExprSyntax.self, self.visit, self.visitPost)
      }
    case .optionalType:
      return {
        self.visitImpl($0, OptionalTypeSyntax.self, self.visit, self.visitPost)
      }
    case .originallyDefinedInAttributeArguments:
      return {
        self.visitImpl($0, OriginallyDefinedInAttributeArgumentsSyntax.self, self.visit, self.visitPost)
      }
    case .packElementExpr:
      return {
        self.visitImpl($0, PackElementExprSyntax.self, self.visit, self.visitPost)
      }
    case .packElementType:
      return {
        self.visitImpl($0, PackElementTypeSyntax.self, self.visit, self.visitPost)
      }
    case .packExpansionExpr:
      return {
        self.visitImpl($0, PackExpansionExprSyntax.self, self.visit, self.visitPost)
      }
    case .packExpansionType:
      return {
        self.visitImpl($0, PackExpansionTypeSyntax.self, self.visit, self.visitPost)
      }
    case .patternBindingList:
      return {
        self.visitImpl($0, PatternBindingListSyntax.self, self.visit, self.visitPost)
      }
    case .patternBinding:
      return {
        self.visitImpl($0, PatternBindingSyntax.self, self.visit, self.visitPost)
      }
    case .patternExpr:
      return {
        self.visitImpl($0, PatternExprSyntax.self, self.visit, self.visitPost)
      }
    case .platformVersionItemList:
      return {
        self.visitImpl($0, PlatformVersionItemListSyntax.self, self.visit, self.visitPost)
      }
    case .platformVersionItem:
      return {
        self.visitImpl($0, PlatformVersionItemSyntax.self, self.visit, self.visitPost)
      }
    case .platformVersion:
      return {
        self.visitImpl($0, PlatformVersionSyntax.self, self.visit, self.visitPost)
      }
    case .postfixIfConfigExpr:
      return {
        self.visitImpl($0, PostfixIfConfigExprSyntax.self, self.visit, self.visitPost)
      }
    case .postfixOperatorExpr:
      return {
        self.visitImpl($0, PostfixOperatorExprSyntax.self, self.visit, self.visitPost)
      }
    case .poundSourceLocationArguments:
      return {
        self.visitImpl($0, PoundSourceLocationArgumentsSyntax.self, self.visit, self.visitPost)
      }
    case .poundSourceLocation:
      return {
        self.visitImpl($0, PoundSourceLocationSyntax.self, self.visit, self.visitPost)
      }
    case .precedenceGroupAssignment:
      return {
        self.visitImpl($0, PrecedenceGroupAssignmentSyntax.self, self.visit, self.visitPost)
      }
    case .precedenceGroupAssociativity:
      return {
        self.visitImpl($0, PrecedenceGroupAssociativitySyntax.self, self.visit, self.visitPost)
      }
    case .precedenceGroupAttributeList:
      return {
        self.visitImpl($0, PrecedenceGroupAttributeListSyntax.self, self.visit, self.visitPost)
      }
    case .precedenceGroupDecl:
      return {
        self.visitImpl($0, PrecedenceGroupDeclSyntax.self, self.visit, self.visitPost)
      }
    case .precedenceGroupNameList:
      return {
        self.visitImpl($0, PrecedenceGroupNameListSyntax.self, self.visit, self.visitPost)
      }
    case .precedenceGroupName:
      return {
        self.visitImpl($0, PrecedenceGroupNameSyntax.self, self.visit, self.visitPost)
      }
    case .precedenceGroupRelation:
      return {
        self.visitImpl($0, PrecedenceGroupRelationSyntax.self, self.visit, self.visitPost)
      }
    case .prefixOperatorExpr:
      return {
        self.visitImpl($0, PrefixOperatorExprSyntax.self, self.visit, self.visitPost)
      }
    case .primaryAssociatedTypeClause:
      return {
        self.visitImpl($0, PrimaryAssociatedTypeClauseSyntax.self, self.visit, self.visitPost)
      }
    case .primaryAssociatedTypeList:
      return {
        self.visitImpl($0, PrimaryAssociatedTypeListSyntax.self, self.visit, self.visitPost)
      }
    case .primaryAssociatedType:
      return {
        self.visitImpl($0, PrimaryAssociatedTypeSyntax.self, self.visit, self.visitPost)
      }
    case .protocolDecl:
      return {
        self.visitImpl($0, ProtocolDeclSyntax.self, self.visit, self.visitPost)
      }
    case .regexLiteralExpr:
      return {
        self.visitImpl($0, RegexLiteralExprSyntax.self, self.visit, self.visitPost)
      }
    case .repeatStmt:
      return {
        self.visitImpl($0, RepeatStmtSyntax.self, self.visit, self.visitPost)
      }
    case .returnClause:
      return {
        self.visitImpl($0, ReturnClauseSyntax.self, self.visit, self.visitPost)
      }
    case .returnStmt:
      return {
        self.visitImpl($0, ReturnStmtSyntax.self, self.visit, self.visitPost)
      }
    case .sameTypeRequirement:
      return {
        self.visitImpl($0, SameTypeRequirementSyntax.self, self.visit, self.visitPost)
      }
    case .sequenceExpr:
      return {
        self.visitImpl($0, SequenceExprSyntax.self, self.visit, self.visitPost)
      }
    case .simpleStringLiteralExpr:
      return {
        self.visitImpl($0, SimpleStringLiteralExprSyntax.self, self.visit, self.visitPost)
      }
    case .simpleStringLiteralSegmentList:
      return {
        self.visitImpl($0, SimpleStringLiteralSegmentListSyntax.self, self.visit, self.visitPost)
      }
    case .someOrAnyType:
      return {
        self.visitImpl($0, SomeOrAnyTypeSyntax.self, self.visit, self.visitPost)
      }
    case .sourceFile:
      return {
        self.visitImpl($0, SourceFileSyntax.self, self.visit, self.visitPost)
      }
    case .specializeAttributeArgumentList:
      return {
        self.visitImpl($0, SpecializeAttributeArgumentListSyntax.self, self.visit, self.visitPost)
      }
    case .specializeAvailabilityArgument:
      return {
        self.visitImpl($0, SpecializeAvailabilityArgumentSyntax.self, self.visit, self.visitPost)
      }
    case .specializeTargetFunctionArgument:
      return {
        self.visitImpl($0, SpecializeTargetFunctionArgumentSyntax.self, self.visit, self.visitPost)
      }
    case .stringLiteralExpr:
      return {
        self.visitImpl($0, StringLiteralExprSyntax.self, self.visit, self.visitPost)
      }
    case .stringLiteralSegmentList:
      return {
        self.visitImpl($0, StringLiteralSegmentListSyntax.self, self.visit, self.visitPost)
      }
    case .stringSegment:
      return {
        self.visitImpl($0, StringSegmentSyntax.self, self.visit, self.visitPost)
      }
    case .structDecl:
      return {
        self.visitImpl($0, StructDeclSyntax.self, self.visit, self.visitPost)
      }
    case .subscriptCallExpr:
      return {
        self.visitImpl($0, SubscriptCallExprSyntax.self, self.visit, self.visitPost)
      }
    case .subscriptDecl:
      return {
        self.visitImpl($0, SubscriptDeclSyntax.self, self.visit, self.visitPost)
      }
    case .superExpr:
      return {
        self.visitImpl($0, SuperExprSyntax.self, self.visit, self.visitPost)
      }
    case .suppressedType:
      return {
        self.visitImpl($0, SuppressedTypeSyntax.self, self.visit, self.visitPost)
      }
    case .switchCaseItemList:
      return {
        self.visitImpl($0, SwitchCaseItemListSyntax.self, self.visit, self.visitPost)
      }
    case .switchCaseItem:
      return {
        self.visitImpl($0, SwitchCaseItemSyntax.self, self.visit, self.visitPost)
      }
    case .switchCaseLabel:
      return {
        self.visitImpl($0, SwitchCaseLabelSyntax.self, self.visit, self.visitPost)
      }
    case .switchCaseList:
      return {
        self.visitImpl($0, SwitchCaseListSyntax.self, self.visit, self.visitPost)
      }
    case .switchCase:
      return {
        self.visitImpl($0, SwitchCaseSyntax.self, self.visit, self.visitPost)
      }
    case .switchDefaultLabel:
      return {
        self.visitImpl($0, SwitchDefaultLabelSyntax.self, self.visit, self.visitPost)
      }
    case .switchExpr:
      return {
        self.visitImpl($0, SwitchExprSyntax.self, self.visit, self.visitPost)
      }
    case .ternaryExpr:
      return {
        self.visitImpl($0, TernaryExprSyntax.self, self.visit, self.visitPost)
      }
    case .thenStmt:
      return {
        self.visitImpl($0, ThenStmtSyntax.self, self.visit, self.visitPost)
      }
    case .throwStmt:
      return {
        self.visitImpl($0, ThrowStmtSyntax.self, self.visit, self.visitPost)
      }
    case .tryExpr:
      return {
        self.visitImpl($0, TryExprSyntax.self, self.visit, self.visitPost)
      }
    case .tupleExpr:
      return {
        self.visitImpl($0, TupleExprSyntax.self, self.visit, self.visitPost)
      }
    case .tuplePatternElementList:
      return {
        self.visitImpl($0, TuplePatternElementListSyntax.self, self.visit, self.visitPost)
      }
    case .tuplePatternElement:
      return {
        self.visitImpl($0, TuplePatternElementSyntax.self, self.visit, self.visitPost)
      }
    case .tuplePattern:
      return {
        self.visitImpl($0, TuplePatternSyntax.self, self.visit, self.visitPost)
      }
    case .tupleTypeElementList:
      return {
        self.visitImpl($0, TupleTypeElementListSyntax.self, self.visit, self.visitPost)
      }
    case .tupleTypeElement:
      return {
        self.visitImpl($0, TupleTypeElementSyntax.self, self.visit, self.visitPost)
      }
    case .tupleType:
      return {
        self.visitImpl($0, TupleTypeSyntax.self, self.visit, self.visitPost)
      }
    case .typeAliasDecl:
      return {
        self.visitImpl($0, TypeAliasDeclSyntax.self, self.visit, self.visitPost)
      }
    case .typeAnnotation:
      return {
        self.visitImpl($0, TypeAnnotationSyntax.self, self.visit, self.visitPost)
      }
    case .typeEffectSpecifiers:
      return {
        self.visitImpl($0, TypeEffectSpecifiersSyntax.self, self.visit, self.visitPost)
      }
    case .typeExpr:
      return {
        self.visitImpl($0, TypeExprSyntax.self, self.visit, self.visitPost)
      }
    case .typeInitializerClause:
      return {
        self.visitImpl($0, TypeInitializerClauseSyntax.self, self.visit, self.visitPost)
      }
    case .unavailableFromAsyncAttributeArguments:
      return {
        self.visitImpl($0, UnavailableFromAsyncAttributeArgumentsSyntax.self, self.visit, self.visitPost)
      }
    case .underscorePrivateAttributeArguments:
      return {
        self.visitImpl($0, UnderscorePrivateAttributeArgumentsSyntax.self, self.visit, self.visitPost)
      }
    case .unexpectedNodes:
      return {
        self.visitImpl($0, UnexpectedNodesSyntax.self, self.visit, self.visitPost)
      }
    case .unresolvedAsExpr:
      return {
        self.visitImpl($0, UnresolvedAsExprSyntax.self, self.visit, self.visitPost)
      }
    case .unresolvedIsExpr:
      return {
        self.visitImpl($0, UnresolvedIsExprSyntax.self, self.visit, self.visitPost)
      }
    case .unresolvedTernaryExpr:
      return {
        self.visitImpl($0, UnresolvedTernaryExprSyntax.self, self.visit, self.visitPost)
      }
    case .valueBindingPattern:
      return {
        self.visitImpl($0, ValueBindingPatternSyntax.self, self.visit, self.visitPost)
      }
    case .variableDecl:
      return {
        self.visitImpl($0, VariableDeclSyntax.self, self.visit, self.visitPost)
      }
    case .versionComponentList:
      return {
        self.visitImpl($0, VersionComponentListSyntax.self, self.visit, self.visitPost)
      }
    case .versionComponent:
      return {
        self.visitImpl($0, VersionComponentSyntax.self, self.visit, self.visitPost)
      }
    case .versionTuple:
      return {
        self.visitImpl($0, VersionTupleSyntax.self, self.visit, self.visitPost)
      }
    case .whereClause:
      return {
        self.visitImpl($0, WhereClauseSyntax.self, self.visit, self.visitPost)
      }
    case .whileStmt:
      return {
        self.visitImpl($0, WhileStmtSyntax.self, self.visit, self.visitPost)
      }
    case .wildcardPattern:
      return {
        self.visitImpl($0, WildcardPatternSyntax.self, self.visit, self.visitPost)
      }
    case .yieldStmt:
      return {
        self.visitImpl($0, YieldStmtSyntax.self, self.visit, self.visitPost)
      }
    case .yieldedExpressionList:
      return {
        self.visitImpl($0, YieldedExpressionListSyntax.self, self.visit, self.visitPost)
      }
    case .yieldedExpression:
      return {
        self.visitImpl($0, YieldedExpressionSyntax.self, self.visit, self.visitPost)
      }
    case .yieldedExpressionsClause:
      return {
        self.visitImpl($0, YieldedExpressionsClauseSyntax.self, self.visit, self.visitPost)
      }
    }
  }
  private func visit(_ node: Syntax) {
    return visitationFunc(for: node)(node)
  }
  #else
  private func visit(_ node: Syntax) {
    switch node.raw.kind {
    case .token:
      let node = node.cast(TokenSyntax.self)
      _ = visit(node)
      // No children to visit.
      visitPost(node)
    case .accessorBlock:
      visitImpl(node, AccessorBlockSyntax.self, visit, visitPost)
    case .accessorDeclList:
      visitImpl(node, AccessorDeclListSyntax.self, visit, visitPost)
    case .accessorDecl:
      visitImpl(node, AccessorDeclSyntax.self, visit, visitPost)
    case .accessorEffectSpecifiers:
      visitImpl(node, AccessorEffectSpecifiersSyntax.self, visit, visitPost)
    case .accessorParameters:
      visitImpl(node, AccessorParametersSyntax.self, visit, visitPost)
    case .actorDecl:
      visitImpl(node, ActorDeclSyntax.self, visit, visitPost)
    case .arrayElementList:
      visitImpl(node, ArrayElementListSyntax.self, visit, visitPost)
    case .arrayElement:
      visitImpl(node, ArrayElementSyntax.self, visit, visitPost)
    case .arrayExpr:
      visitImpl(node, ArrayExprSyntax.self, visit, visitPost)
    case .arrayType:
      visitImpl(node, ArrayTypeSyntax.self, visit, visitPost)
    case .arrowExpr:
      visitImpl(node, ArrowExprSyntax.self, visit, visitPost)
    case .asExpr:
      visitImpl(node, AsExprSyntax.self, visit, visitPost)
    case .assignmentExpr:
      visitImpl(node, AssignmentExprSyntax.self, visit, visitPost)
    case .associatedTypeDecl:
      visitImpl(node, AssociatedTypeDeclSyntax.self, visit, visitPost)
    case .attributeList:
      visitImpl(node, AttributeListSyntax.self, visit, visitPost)
    case .attribute:
      visitImpl(node, AttributeSyntax.self, visit, visitPost)
    case .attributedType:
      visitImpl(node, AttributedTypeSyntax.self, visit, visitPost)
    case .availabilityArgumentList:
      visitImpl(node, AvailabilityArgumentListSyntax.self, visit, visitPost)
    case .availabilityArgument:
      visitImpl(node, AvailabilityArgumentSyntax.self, visit, visitPost)
    case .availabilityCondition:
      visitImpl(node, AvailabilityConditionSyntax.self, visit, visitPost)
    case .availabilityLabeledArgument:
      visitImpl(node, AvailabilityLabeledArgumentSyntax.self, visit, visitPost)
    case .awaitExpr:
      visitImpl(node, AwaitExprSyntax.self, visit, visitPost)
    case .backDeployedAttributeArguments:
      visitImpl(node, BackDeployedAttributeArgumentsSyntax.self, visit, visitPost)
    case .binaryOperatorExpr:
      visitImpl(node, BinaryOperatorExprSyntax.self, visit, visitPost)
    case .booleanLiteralExpr:
      visitImpl(node, BooleanLiteralExprSyntax.self, visit, visitPost)
    case .borrowExpr:
      visitImpl(node, BorrowExprSyntax.self, visit, visitPost)
    case .breakStmt:
      visitImpl(node, BreakStmtSyntax.self, visit, visitPost)
    case .canImportExpr:
      visitImpl(node, CanImportExprSyntax.self, visit, visitPost)
    case .canImportVersionInfo:
      visitImpl(node, CanImportVersionInfoSyntax.self, visit, visitPost)
    case .catchClauseList:
      visitImpl(node, CatchClauseListSyntax.self, visit, visitPost)
    case .catchClause:
      visitImpl(node, CatchClauseSyntax.self, visit, visitPost)
    case .catchItemList:
      visitImpl(node, CatchItemListSyntax.self, visit, visitPost)
    case .catchItem:
      visitImpl(node, CatchItemSyntax.self, visit, visitPost)
    case .classDecl:
      visitImpl(node, ClassDeclSyntax.self, visit, visitPost)
    case .classRestrictionType:
      visitImpl(node, ClassRestrictionTypeSyntax.self, visit, visitPost)
    case .closureCaptureClause:
      visitImpl(node, ClosureCaptureClauseSyntax.self, visit, visitPost)
    case .closureCaptureList:
      visitImpl(node, ClosureCaptureListSyntax.self, visit, visitPost)
    case .closureCaptureSpecifier:
      visitImpl(node, ClosureCaptureSpecifierSyntax.self, visit, visitPost)
    case .closureCapture:
      visitImpl(node, ClosureCaptureSyntax.self, visit, visitPost)
    case .closureExpr:
      visitImpl(node, ClosureExprSyntax.self, visit, visitPost)
    case .closureParameterClause:
      visitImpl(node, ClosureParameterClauseSyntax.self, visit, visitPost)
    case .closureParameterList:
      visitImpl(node, ClosureParameterListSyntax.self, visit, visitPost)
    case .closureParameter:
      visitImpl(node, ClosureParameterSyntax.self, visit, visitPost)
    case .closureShorthandParameterList:
      visitImpl(node, ClosureShorthandParameterListSyntax.self, visit, visitPost)
    case .closureShorthandParameter:
      visitImpl(node, ClosureShorthandParameterSyntax.self, visit, visitPost)
    case .closureSignature:
      visitImpl(node, ClosureSignatureSyntax.self, visit, visitPost)
    case .codeBlockItemList:
      visitImpl(node, CodeBlockItemListSyntax.self, visit, visitPost)
    case .codeBlockItem:
      visitImpl(node, CodeBlockItemSyntax.self, visit, visitPost)
    case .codeBlock:
      visitImpl(node, CodeBlockSyntax.self, visit, visitPost)
    case .compositionTypeElementList:
      visitImpl(node, CompositionTypeElementListSyntax.self, visit, visitPost)
    case .compositionTypeElement:
      visitImpl(node, CompositionTypeElementSyntax.self, visit, visitPost)
    case .compositionType:
      visitImpl(node, CompositionTypeSyntax.self, visit, visitPost)
    case .conditionElementList:
      visitImpl(node, ConditionElementListSyntax.self, visit, visitPost)
    case .conditionElement:
      visitImpl(node, ConditionElementSyntax.self, visit, visitPost)
    case .conformanceRequirement:
      visitImpl(node, ConformanceRequirementSyntax.self, visit, visitPost)
    case .consumeExpr:
      visitImpl(node, ConsumeExprSyntax.self, visit, visitPost)
    case .continueStmt:
      visitImpl(node, ContinueStmtSyntax.self, visit, visitPost)
    case .conventionAttributeArguments:
      visitImpl(node, ConventionAttributeArgumentsSyntax.self, visit, visitPost)
    case .conventionWitnessMethodAttributeArguments:
      visitImpl(node, ConventionWitnessMethodAttributeArgumentsSyntax.self, visit, visitPost)
    case .copyExpr:
      visitImpl(node, CopyExprSyntax.self, visit, visitPost)
    case .declModifierDetail:
      visitImpl(node, DeclModifierDetailSyntax.self, visit, visitPost)
    case .declModifierList:
      visitImpl(node, DeclModifierListSyntax.self, visit, visitPost)
    case .declModifier:
      visitImpl(node, DeclModifierSyntax.self, visit, visitPost)
    case .declNameArgumentList:
      visitImpl(node, DeclNameArgumentListSyntax.self, visit, visitPost)
    case .declNameArgument:
      visitImpl(node, DeclNameArgumentSyntax.self, visit, visitPost)
    case .declNameArguments:
      visitImpl(node, DeclNameArgumentsSyntax.self, visit, visitPost)
    case .declReferenceExpr:
      visitImpl(node, DeclReferenceExprSyntax.self, visit, visitPost)
    case .deferStmt:
      visitImpl(node, DeferStmtSyntax.self, visit, visitPost)
    case .deinitializerDecl:
      visitImpl(node, DeinitializerDeclSyntax.self, visit, visitPost)
    case .deinitializerEffectSpecifiers:
      visitImpl(node, DeinitializerEffectSpecifiersSyntax.self, visit, visitPost)
    case .derivativeAttributeArguments:
      visitImpl(node, DerivativeAttributeArgumentsSyntax.self, visit, visitPost)
    case .designatedTypeList:
      visitImpl(node, DesignatedTypeListSyntax.self, visit, visitPost)
    case .designatedType:
      visitImpl(node, DesignatedTypeSyntax.self, visit, visitPost)
    case .dictionaryElementList:
      visitImpl(node, DictionaryElementListSyntax.self, visit, visitPost)
    case .dictionaryElement:
      visitImpl(node, DictionaryElementSyntax.self, visit, visitPost)
    case .dictionaryExpr:
      visitImpl(node, DictionaryExprSyntax.self, visit, visitPost)
    case .dictionaryType:
      visitImpl(node, DictionaryTypeSyntax.self, visit, visitPost)
    case .differentiabilityArgumentList:
      visitImpl(node, DifferentiabilityArgumentListSyntax.self, visit, visitPost)
    case .differentiabilityArgument:
      visitImpl(node, DifferentiabilityArgumentSyntax.self, visit, visitPost)
    case .differentiabilityArguments:
      visitImpl(node, DifferentiabilityArgumentsSyntax.self, visit, visitPost)
    case .differentiabilityWithRespectToArgument:
      visitImpl(node, DifferentiabilityWithRespectToArgumentSyntax.self, visit, visitPost)
    case .differentiableAttributeArguments:
      visitImpl(node, DifferentiableAttributeArgumentsSyntax.self, visit, visitPost)
    case .discardAssignmentExpr:
      visitImpl(node, DiscardAssignmentExprSyntax.self, visit, visitPost)
    case .discardStmt:
      visitImpl(node, DiscardStmtSyntax.self, visit, visitPost)
    case .doStmt:
      visitImpl(node, DoStmtSyntax.self, visit, visitPost)
    case .documentationAttributeArgumentList:
      visitImpl(node, DocumentationAttributeArgumentListSyntax.self, visit, visitPost)
    case .documentationAttributeArgument:
      visitImpl(node, DocumentationAttributeArgumentSyntax.self, visit, visitPost)
    case .dynamicReplacementAttributeArguments:
      visitImpl(node, DynamicReplacementAttributeArgumentsSyntax.self, visit, visitPost)
    case .editorPlaceholderDecl:
      visitImpl(node, EditorPlaceholderDeclSyntax.self, visit, visitPost)
    case .editorPlaceholderExpr:
      visitImpl(node, EditorPlaceholderExprSyntax.self, visit, visitPost)
    case .effectsAttributeArgumentList:
      visitImpl(node, EffectsAttributeArgumentListSyntax.self, visit, visitPost)
    case .enumCaseDecl:
      visitImpl(node, EnumCaseDeclSyntax.self, visit, visitPost)
    case .enumCaseElementList:
      visitImpl(node, EnumCaseElementListSyntax.self, visit, visitPost)
    case .enumCaseElement:
      visitImpl(node, EnumCaseElementSyntax.self, visit, visitPost)
    case .enumCaseParameterClause:
      visitImpl(node, EnumCaseParameterClauseSyntax.self, visit, visitPost)
    case .enumCaseParameterList:
      visitImpl(node, EnumCaseParameterListSyntax.self, visit, visitPost)
    case .enumCaseParameter:
      visitImpl(node, EnumCaseParameterSyntax.self, visit, visitPost)
    case .enumDecl:
      visitImpl(node, EnumDeclSyntax.self, visit, visitPost)
    case .exposeAttributeArguments:
      visitImpl(node, ExposeAttributeArgumentsSyntax.self, visit, visitPost)
    case .exprList:
      visitImpl(node, ExprListSyntax.self, visit, visitPost)
    case .expressionPattern:
      visitImpl(node, ExpressionPatternSyntax.self, visit, visitPost)
    case .expressionSegment:
      visitImpl(node, ExpressionSegmentSyntax.self, visit, visitPost)
    case .expressionStmt:
      visitImpl(node, ExpressionStmtSyntax.self, visit, visitPost)
    case .extensionDecl:
      visitImpl(node, ExtensionDeclSyntax.self, visit, visitPost)
    case .fallThroughStmt:
      visitImpl(node, FallThroughStmtSyntax.self, visit, visitPost)
    case .floatLiteralExpr:
      visitImpl(node, FloatLiteralExprSyntax.self, visit, visitPost)
    case .forStmt:
      visitImpl(node, ForStmtSyntax.self, visit, visitPost)
    case .forceUnwrapExpr:
      visitImpl(node, ForceUnwrapExprSyntax.self, visit, visitPost)
    case .functionCallExpr:
      visitImpl(node, FunctionCallExprSyntax.self, visit, visitPost)
    case .functionDecl:
      visitImpl(node, FunctionDeclSyntax.self, visit, visitPost)
    case .functionEffectSpecifiers:
      visitImpl(node, FunctionEffectSpecifiersSyntax.self, visit, visitPost)
    case .functionParameterClause:
      visitImpl(node, FunctionParameterClauseSyntax.self, visit, visitPost)
    case .functionParameterList:
      visitImpl(node, FunctionParameterListSyntax.self, visit, visitPost)
    case .functionParameter:
      visitImpl(node, FunctionParameterSyntax.self, visit, visitPost)
    case .functionSignature:
      visitImpl(node, FunctionSignatureSyntax.self, visit, visitPost)
    case .functionType:
      visitImpl(node, FunctionTypeSyntax.self, visit, visitPost)
    case .genericArgumentClause:
      visitImpl(node, GenericArgumentClauseSyntax.self, visit, visitPost)
    case .genericArgumentList:
      visitImpl(node, GenericArgumentListSyntax.self, visit, visitPost)
    case .genericArgument:
      visitImpl(node, GenericArgumentSyntax.self, visit, visitPost)
    case .genericParameterClause:
      visitImpl(node, GenericParameterClauseSyntax.self, visit, visitPost)
    case .genericParameterList:
      visitImpl(node, GenericParameterListSyntax.self, visit, visitPost)
    case .genericParameter:
      visitImpl(node, GenericParameterSyntax.self, visit, visitPost)
    case .genericRequirementList:
      visitImpl(node, GenericRequirementListSyntax.self, visit, visitPost)
    case .genericRequirement:
      visitImpl(node, GenericRequirementSyntax.self, visit, visitPost)
    case .genericSpecializationExpr:
      visitImpl(node, GenericSpecializationExprSyntax.self, visit, visitPost)
    case .genericWhereClause:
      visitImpl(node, GenericWhereClauseSyntax.self, visit, visitPost)
    case .guardStmt:
      visitImpl(node, GuardStmtSyntax.self, visit, visitPost)
    case .identifierPattern:
      visitImpl(node, IdentifierPatternSyntax.self, visit, visitPost)
    case .identifierType:
      visitImpl(node, IdentifierTypeSyntax.self, visit, visitPost)
    case .ifConfigClauseList:
      visitImpl(node, IfConfigClauseListSyntax.self, visit, visitPost)
    case .ifConfigClause:
      visitImpl(node, IfConfigClauseSyntax.self, visit, visitPost)
    case .ifConfigDecl:
      visitImpl(node, IfConfigDeclSyntax.self, visit, visitPost)
    case .ifExpr:
      visitImpl(node, IfExprSyntax.self, visit, visitPost)
    case .implementsAttributeArguments:
      visitImpl(node, ImplementsAttributeArgumentsSyntax.self, visit, visitPost)
    case .implicitlyUnwrappedOptionalType:
      visitImpl(node, ImplicitlyUnwrappedOptionalTypeSyntax.self, visit, visitPost)
    case .importDecl:
      visitImpl(node, ImportDeclSyntax.self, visit, visitPost)
    case .importPathComponentList:
      visitImpl(node, ImportPathComponentListSyntax.self, visit, visitPost)
    case .importPathComponent:
      visitImpl(node, ImportPathComponentSyntax.self, visit, visitPost)
    case .inOutExpr:
      visitImpl(node, InOutExprSyntax.self, visit, visitPost)
    case .infixOperatorExpr:
      visitImpl(node, InfixOperatorExprSyntax.self, visit, visitPost)
    case .inheritanceClause:
      visitImpl(node, InheritanceClauseSyntax.self, visit, visitPost)
    case .inheritedTypeList:
      visitImpl(node, InheritedTypeListSyntax.self, visit, visitPost)
    case .inheritedType:
      visitImpl(node, InheritedTypeSyntax.self, visit, visitPost)
    case .initializerClause:
      visitImpl(node, InitializerClauseSyntax.self, visit, visitPost)
    case .initializerDecl:
      visitImpl(node, InitializerDeclSyntax.self, visit, visitPost)
    case .integerLiteralExpr:
      visitImpl(node, IntegerLiteralExprSyntax.self, visit, visitPost)
    case .isExpr:
      visitImpl(node, IsExprSyntax.self, visit, visitPost)
    case .isTypePattern:
      visitImpl(node, IsTypePatternSyntax.self, visit, visitPost)
    case .keyPathComponentList:
      visitImpl(node, KeyPathComponentListSyntax.self, visit, visitPost)
    case .keyPathComponent:
      visitImpl(node, KeyPathComponentSyntax.self, visit, visitPost)
    case .keyPathExpr:
      visitImpl(node, KeyPathExprSyntax.self, visit, visitPost)
    case .keyPathOptionalComponent:
      visitImpl(node, KeyPathOptionalComponentSyntax.self, visit, visitPost)
    case .keyPathPropertyComponent:
      visitImpl(node, KeyPathPropertyComponentSyntax.self, visit, visitPost)
    case .keyPathSubscriptComponent:
      visitImpl(node, KeyPathSubscriptComponentSyntax.self, visit, visitPost)
    case .labeledExprList:
      visitImpl(node, LabeledExprListSyntax.self, visit, visitPost)
    case .labeledExpr:
      visitImpl(node, LabeledExprSyntax.self, visit, visitPost)
    case .labeledSpecializeArgument:
      visitImpl(node, LabeledSpecializeArgumentSyntax.self, visit, visitPost)
    case .labeledStmt:
      visitImpl(node, LabeledStmtSyntax.self, visit, visitPost)
    case .layoutRequirement:
      visitImpl(node, LayoutRequirementSyntax.self, visit, visitPost)
    case .macroDecl:
      visitImpl(node, MacroDeclSyntax.self, visit, visitPost)
    case .macroExpansionDecl:
      visitImpl(node, MacroExpansionDeclSyntax.self, visit, visitPost)
    case .macroExpansionExpr:
      visitImpl(node, MacroExpansionExprSyntax.self, visit, visitPost)
    case .matchingPatternCondition:
      visitImpl(node, MatchingPatternConditionSyntax.self, visit, visitPost)
    case .memberAccessExpr:
      visitImpl(node, MemberAccessExprSyntax.self, visit, visitPost)
    case .memberBlockItemList:
      visitImpl(node, MemberBlockItemListSyntax.self, visit, visitPost)
    case .memberBlockItem:
      visitImpl(node, MemberBlockItemSyntax.self, visit, visitPost)
    case .memberBlock:
      visitImpl(node, MemberBlockSyntax.self, visit, visitPost)
    case .memberType:
      visitImpl(node, MemberTypeSyntax.self, visit, visitPost)
    case .metatypeType:
      visitImpl(node, MetatypeTypeSyntax.self, visit, visitPost)
    case .missingDecl:
      visitImpl(node, MissingDeclSyntax.self, visit, visitPost)
    case .missingExpr:
      visitImpl(node, MissingExprSyntax.self, visit, visitPost)
    case .missingPattern:
      visitImpl(node, MissingPatternSyntax.self, visit, visitPost)
    case .missingStmt:
      visitImpl(node, MissingStmtSyntax.self, visit, visitPost)
    case .missing:
      visitImpl(node, MissingSyntax.self, visit, visitPost)
    case .missingType:
      visitImpl(node, MissingTypeSyntax.self, visit, visitPost)
    case .multipleTrailingClosureElementList:
      visitImpl(node, MultipleTrailingClosureElementListSyntax.self, visit, visitPost)
    case .multipleTrailingClosureElement:
      visitImpl(node, MultipleTrailingClosureElementSyntax.self, visit, visitPost)
    case .namedOpaqueReturnType:
      visitImpl(node, NamedOpaqueReturnTypeSyntax.self, visit, visitPost)
    case .nilLiteralExpr:
      visitImpl(node, NilLiteralExprSyntax.self, visit, visitPost)
    case .objCSelectorPieceList:
      visitImpl(node, ObjCSelectorPieceListSyntax.self, visit, visitPost)
    case .objCSelectorPiece:
      visitImpl(node, ObjCSelectorPieceSyntax.self, visit, visitPost)
    case .opaqueReturnTypeOfAttributeArguments:
      visitImpl(node, OpaqueReturnTypeOfAttributeArgumentsSyntax.self, visit, visitPost)
    case .operatorDecl:
      visitImpl(node, OperatorDeclSyntax.self, visit, visitPost)
    case .operatorPrecedenceAndTypes:
      visitImpl(node, OperatorPrecedenceAndTypesSyntax.self, visit, visitPost)
    case .optionalBindingCondition:
      visitImpl(node, OptionalBindingConditionSyntax.self, visit, visitPost)
    case .optionalChainingExpr:
      visitImpl(node, OptionalChainingExprSyntax.self, visit, visitPost)
    case .optionalType:
      visitImpl(node, OptionalTypeSyntax.self, visit, visitPost)
    case .originallyDefinedInAttributeArguments:
      visitImpl(node, OriginallyDefinedInAttributeArgumentsSyntax.self, visit, visitPost)
    case .packElementExpr:
      visitImpl(node, PackElementExprSyntax.self, visit, visitPost)
    case .packElementType:
      visitImpl(node, PackElementTypeSyntax.self, visit, visitPost)
    case .packExpansionExpr:
      visitImpl(node, PackExpansionExprSyntax.self, visit, visitPost)
    case .packExpansionType:
      visitImpl(node, PackExpansionTypeSyntax.self, visit, visitPost)
    case .patternBindingList:
      visitImpl(node, PatternBindingListSyntax.self, visit, visitPost)
    case .patternBinding:
      visitImpl(node, PatternBindingSyntax.self, visit, visitPost)
    case .patternExpr:
      visitImpl(node, PatternExprSyntax.self, visit, visitPost)
    case .platformVersionItemList:
      visitImpl(node, PlatformVersionItemListSyntax.self, visit, visitPost)
    case .platformVersionItem:
      visitImpl(node, PlatformVersionItemSyntax.self, visit, visitPost)
    case .platformVersion:
      visitImpl(node, PlatformVersionSyntax.self, visit, visitPost)
    case .postfixIfConfigExpr:
      visitImpl(node, PostfixIfConfigExprSyntax.self, visit, visitPost)
    case .postfixOperatorExpr:
      visitImpl(node, PostfixOperatorExprSyntax.self, visit, visitPost)
    case .poundSourceLocationArguments:
      visitImpl(node, PoundSourceLocationArgumentsSyntax.self, visit, visitPost)
    case .poundSourceLocation:
      visitImpl(node, PoundSourceLocationSyntax.self, visit, visitPost)
    case .precedenceGroupAssignment:
      visitImpl(node, PrecedenceGroupAssignmentSyntax.self, visit, visitPost)
    case .precedenceGroupAssociativity:
      visitImpl(node, PrecedenceGroupAssociativitySyntax.self, visit, visitPost)
    case .precedenceGroupAttributeList:
      visitImpl(node, PrecedenceGroupAttributeListSyntax.self, visit, visitPost)
    case .precedenceGroupDecl:
      visitImpl(node, PrecedenceGroupDeclSyntax.self, visit, visitPost)
    case .precedenceGroupNameList:
      visitImpl(node, PrecedenceGroupNameListSyntax.self, visit, visitPost)
    case .precedenceGroupName:
      visitImpl(node, PrecedenceGroupNameSyntax.self, visit, visitPost)
    case .precedenceGroupRelation:
      visitImpl(node, PrecedenceGroupRelationSyntax.self, visit, visitPost)
    case .prefixOperatorExpr:
      visitImpl(node, PrefixOperatorExprSyntax.self, visit, visitPost)
    case .primaryAssociatedTypeClause:
      visitImpl(node, PrimaryAssociatedTypeClauseSyntax.self, visit, visitPost)
    case .primaryAssociatedTypeList:
      visitImpl(node, PrimaryAssociatedTypeListSyntax.self, visit, visitPost)
    case .primaryAssociatedType:
      visitImpl(node, PrimaryAssociatedTypeSyntax.self, visit, visitPost)
    case .protocolDecl:
      visitImpl(node, ProtocolDeclSyntax.self, visit, visitPost)
    case .regexLiteralExpr:
      visitImpl(node, RegexLiteralExprSyntax.self, visit, visitPost)
    case .repeatStmt:
      visitImpl(node, RepeatStmtSyntax.self, visit, visitPost)
    case .returnClause:
      visitImpl(node, ReturnClauseSyntax.self, visit, visitPost)
    case .returnStmt:
      visitImpl(node, ReturnStmtSyntax.self, visit, visitPost)
    case .sameTypeRequirement:
      visitImpl(node, SameTypeRequirementSyntax.self, visit, visitPost)
    case .sequenceExpr:
      visitImpl(node, SequenceExprSyntax.self, visit, visitPost)
    case .simpleStringLiteralExpr:
      visitImpl(node, SimpleStringLiteralExprSyntax.self, visit, visitPost)
    case .simpleStringLiteralSegmentList:
      visitImpl(node, SimpleStringLiteralSegmentListSyntax.self, visit, visitPost)
    case .someOrAnyType:
      visitImpl(node, SomeOrAnyTypeSyntax.self, visit, visitPost)
    case .sourceFile:
      visitImpl(node, SourceFileSyntax.self, visit, visitPost)
    case .specializeAttributeArgumentList:
      visitImpl(node, SpecializeAttributeArgumentListSyntax.self, visit, visitPost)
    case .specializeAvailabilityArgument:
      visitImpl(node, SpecializeAvailabilityArgumentSyntax.self, visit, visitPost)
    case .specializeTargetFunctionArgument:
      visitImpl(node, SpecializeTargetFunctionArgumentSyntax.self, visit, visitPost)
    case .stringLiteralExpr:
      visitImpl(node, StringLiteralExprSyntax.self, visit, visitPost)
    case .stringLiteralSegmentList:
      visitImpl(node, StringLiteralSegmentListSyntax.self, visit, visitPost)
    case .stringSegment:
      visitImpl(node, StringSegmentSyntax.self, visit, visitPost)
    case .structDecl:
      visitImpl(node, StructDeclSyntax.self, visit, visitPost)
    case .subscriptCallExpr:
      visitImpl(node, SubscriptCallExprSyntax.self, visit, visitPost)
    case .subscriptDecl:
      visitImpl(node, SubscriptDeclSyntax.self, visit, visitPost)
    case .superExpr:
      visitImpl(node, SuperExprSyntax.self, visit, visitPost)
    case .suppressedType:
      visitImpl(node, SuppressedTypeSyntax.self, visit, visitPost)
    case .switchCaseItemList:
      visitImpl(node, SwitchCaseItemListSyntax.self, visit, visitPost)
    case .switchCaseItem:
      visitImpl(node, SwitchCaseItemSyntax.self, visit, visitPost)
    case .switchCaseLabel:
      visitImpl(node, SwitchCaseLabelSyntax.self, visit, visitPost)
    case .switchCaseList:
      visitImpl(node, SwitchCaseListSyntax.self, visit, visitPost)
    case .switchCase:
      visitImpl(node, SwitchCaseSyntax.self, visit, visitPost)
    case .switchDefaultLabel:
      visitImpl(node, SwitchDefaultLabelSyntax.self, visit, visitPost)
    case .switchExpr:
      visitImpl(node, SwitchExprSyntax.self, visit, visitPost)
    case .ternaryExpr:
      visitImpl(node, TernaryExprSyntax.self, visit, visitPost)
    case .thenStmt:
      visitImpl(node, ThenStmtSyntax.self, visit, visitPost)
    case .throwStmt:
      visitImpl(node, ThrowStmtSyntax.self, visit, visitPost)
    case .tryExpr:
      visitImpl(node, TryExprSyntax.self, visit, visitPost)
    case .tupleExpr:
      visitImpl(node, TupleExprSyntax.self, visit, visitPost)
    case .tuplePatternElementList:
      visitImpl(node, TuplePatternElementListSyntax.self, visit, visitPost)
    case .tuplePatternElement:
      visitImpl(node, TuplePatternElementSyntax.self, visit, visitPost)
    case .tuplePattern:
      visitImpl(node, TuplePatternSyntax.self, visit, visitPost)
    case .tupleTypeElementList:
      visitImpl(node, TupleTypeElementListSyntax.self, visit, visitPost)
    case .tupleTypeElement:
      visitImpl(node, TupleTypeElementSyntax.self, visit, visitPost)
    case .tupleType:
      visitImpl(node, TupleTypeSyntax.self, visit, visitPost)
    case .typeAliasDecl:
      visitImpl(node, TypeAliasDeclSyntax.self, visit, visitPost)
    case .typeAnnotation:
      visitImpl(node, TypeAnnotationSyntax.self, visit, visitPost)
    case .typeEffectSpecifiers:
      visitImpl(node, TypeEffectSpecifiersSyntax.self, visit, visitPost)
    case .typeExpr:
      visitImpl(node, TypeExprSyntax.self, visit, visitPost)
    case .typeInitializerClause:
      visitImpl(node, TypeInitializerClauseSyntax.self, visit, visitPost)
    case .unavailableFromAsyncAttributeArguments:
      visitImpl(node, UnavailableFromAsyncAttributeArgumentsSyntax.self, visit, visitPost)
    case .underscorePrivateAttributeArguments:
      visitImpl(node, UnderscorePrivateAttributeArgumentsSyntax.self, visit, visitPost)
    case .unexpectedNodes:
      visitImpl(node, UnexpectedNodesSyntax.self, visit, visitPost)
    case .unresolvedAsExpr:
      visitImpl(node, UnresolvedAsExprSyntax.self, visit, visitPost)
    case .unresolvedIsExpr:
      visitImpl(node, UnresolvedIsExprSyntax.self, visit, visitPost)
    case .unresolvedTernaryExpr:
      visitImpl(node, UnresolvedTernaryExprSyntax.self, visit, visitPost)
    case .valueBindingPattern:
      visitImpl(node, ValueBindingPatternSyntax.self, visit, visitPost)
    case .variableDecl:
      visitImpl(node, VariableDeclSyntax.self, visit, visitPost)
    case .versionComponentList:
      visitImpl(node, VersionComponentListSyntax.self, visit, visitPost)
    case .versionComponent:
      visitImpl(node, VersionComponentSyntax.self, visit, visitPost)
    case .versionTuple:
      visitImpl(node, VersionTupleSyntax.self, visit, visitPost)
    case .whereClause:
      visitImpl(node, WhereClauseSyntax.self, visit, visitPost)
    case .whileStmt:
      visitImpl(node, WhileStmtSyntax.self, visit, visitPost)
    case .wildcardPattern:
      visitImpl(node, WildcardPatternSyntax.self, visit, visitPost)
    case .yieldStmt:
      visitImpl(node, YieldStmtSyntax.self, visit, visitPost)
    case .yieldedExpressionList:
      visitImpl(node, YieldedExpressionListSyntax.self, visit, visitPost)
    case .yieldedExpression:
      visitImpl(node, YieldedExpressionSyntax.self, visit, visitPost)
    case .yieldedExpressionsClause:
      visitImpl(node, YieldedExpressionsClauseSyntax.self, visit, visitPost)
    }
  }
  #endif
  
  private func visitChildren(_ node: some SyntaxProtocol) {
    let syntaxNode = Syntax(node)
    for childRaw in NonNilRawSyntaxChildren(syntaxNode, viewMode: viewMode) {
      visit(Syntax(childRaw, parent: syntaxNode))
    }
  }
}
