//// Automatically generated by generate-swift-syntax
//// Do not edit directly!
//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2014 - 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

/// ### Children
/// 
/// ``AccessorDeclSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``AccessorBlockSyntax``.``AccessorBlockSyntax/accessors``
public struct AccessorDeclListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = AccessorDeclSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .accessorDeclList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.accessorDeclList
}

/// ### Children
/// 
/// ``ArrayElementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``ArrayExprSyntax``.``ArrayExprSyntax/elements``
public struct ArrayElementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = ArrayElementSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .arrayElementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.arrayElementList
}

/// A list of attributes that can be attached to a declaration.
/// 
/// An element in this collection can either be an attribute itself or an ``IfConfigDeclSyntax``
/// that contains attributes. This is because attributes can be added conditional on compilcation
/// conditions, for example.
/// 
/// ```swift
/// #if !DISABLE_DEPRECATIONS
/// @available(*, deprecated)
/// #endif
/// func myFunction() {}
/// ```
///
/// ### Children
/// 
/// (``AttributeSyntax`` | ``IfConfigDeclSyntax``) `*`
///
/// ### Contained in
/// 
///  - ``AccessorDeclSyntax``.``AccessorDeclSyntax/attributes``
///  - ``ActorDeclSyntax``.``ActorDeclSyntax/attributes``
///  - ``AssociatedTypeDeclSyntax``.``AssociatedTypeDeclSyntax/attributes``
///  - ``AttributedTypeSyntax``.``AttributedTypeSyntax/attributes``
///  - ``ClassDeclSyntax``.``ClassDeclSyntax/attributes``
///  - ``ClosureParameterSyntax``.``ClosureParameterSyntax/attributes``
///  - ``ClosureSignatureSyntax``.``ClosureSignatureSyntax/attributes``
///  - ``DeinitializerDeclSyntax``.``DeinitializerDeclSyntax/attributes``
///  - ``EditorPlaceholderDeclSyntax``.``EditorPlaceholderDeclSyntax/attributes``
///  - ``EnumCaseDeclSyntax``.``EnumCaseDeclSyntax/attributes``
///  - ``EnumDeclSyntax``.``EnumDeclSyntax/attributes``
///  - ``ExtensionDeclSyntax``.``ExtensionDeclSyntax/attributes``
///  - ``FunctionDeclSyntax``.``FunctionDeclSyntax/attributes``
///  - ``FunctionParameterSyntax``.``FunctionParameterSyntax/attributes``
///  - ``GenericParameterSyntax``.``GenericParameterSyntax/attributes``
///  - ``IfConfigClauseSyntax``.``IfConfigClauseSyntax/elements``
///  - ``ImportDeclSyntax``.``ImportDeclSyntax/attributes``
///  - ``InitializerDeclSyntax``.``InitializerDeclSyntax/attributes``
///  - ``MacroDeclSyntax``.``MacroDeclSyntax/attributes``
///  - ``MacroExpansionDeclSyntax``.``MacroExpansionDeclSyntax/attributes``
///  - ``MissingDeclSyntax``.``MissingDeclSyntax/attributes``
///  - ``PrecedenceGroupDeclSyntax``.``PrecedenceGroupDeclSyntax/attributes``
///  - ``ProtocolDeclSyntax``.``ProtocolDeclSyntax/attributes``
///  - ``StructDeclSyntax``.``StructDeclSyntax/attributes``
///  - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/attributes``
///  - ``TypeAliasDeclSyntax``.``TypeAliasDeclSyntax/attributes``
///  - ``VariableDeclSyntax``.``VariableDeclSyntax/attributes``
public struct AttributeListSyntax: SyntaxCollection, SyntaxHashable {
  public enum Element: SyntaxChildChoices, SyntaxHashable {
    case `attribute`(AttributeSyntax)
    case `ifConfigDecl`(IfConfigDeclSyntax)
    
    public var _syntaxNode: Syntax {
      switch self {
      case .attribute(let node):
        return node._syntaxNode
      case .ifConfigDecl(let node):
        return node._syntaxNode
      }
    }
    
    public init(_ node: AttributeSyntax) {
      self = .attribute(node)
    }
    
    public init(_ node: IfConfigDeclSyntax) {
      self = .ifConfigDecl(node)
    }
    
    public init?(_ node: some SyntaxProtocol) {
      if let node = node.as(AttributeSyntax.self) {
        self = .attribute(node)
        return
      }
      if let node = node.as(IfConfigDeclSyntax.self) {
        self = .ifConfigDecl(node)
        return
      }
      return nil
    }
    
    public static var structure: SyntaxNodeStructure {
      return .choices([
          .node(AttributeSyntax.self),
          .node(IfConfigDeclSyntax.self)])
    }
  }
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .attributeList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.attributeList
}

/// ### Children
/// 
/// ``AvailabilityArgumentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
///  - ``AvailabilityConditionSyntax``.``AvailabilityConditionSyntax/availabilityArguments``
///  - ``SpecializeAvailabilityArgumentSyntax``.``SpecializeAvailabilityArgumentSyntax/availabilityArguments``
public struct AvailabilityArgumentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = AvailabilityArgumentSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .availabilityArgumentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.availabilityArgumentList
}

/// ### Children
/// 
/// ``CatchClauseSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``DoStmtSyntax``.``DoStmtSyntax/catchClauses``
public struct CatchClauseListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = CatchClauseSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .catchClauseList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.catchClauseList
}

/// ### Children
/// 
/// ``CatchItemSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``CatchClauseSyntax``.``CatchClauseSyntax/catchItems``
public struct CatchItemListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = CatchItemSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .catchItemList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.catchItemList
}

/// ### Children
/// 
/// ``ClosureCaptureSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``ClosureCaptureClauseSyntax``.``ClosureCaptureClauseSyntax/items``
public struct ClosureCaptureListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = ClosureCaptureSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .closureCaptureList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.closureCaptureList
}

/// ### Children
/// 
/// ``ClosureParameterSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``ClosureParameterClauseSyntax``.``ClosureParameterClauseSyntax/parameters``
public struct ClosureParameterListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = ClosureParameterSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .closureParameterList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.closureParameterList
}

/// ### Children
/// 
/// ``ClosureShorthandParameterSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``ClosureSignatureSyntax``.``ClosureSignatureSyntax/parameterClause``
public struct ClosureShorthandParameterListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = ClosureShorthandParameterSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .closureShorthandParameterList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.closureShorthandParameterList
}

/// ### Children
/// 
/// ``CodeBlockItemSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``AccessorBlockSyntax``.``AccessorBlockSyntax/accessors``
///  - ``ClosureExprSyntax``.``ClosureExprSyntax/statements``
///  - ``CodeBlockSyntax``.``CodeBlockSyntax/statements``
///  - ``IfConfigClauseSyntax``.``IfConfigClauseSyntax/elements``
///  - ``SourceFileSyntax``.``SourceFileSyntax/statements``
///  - ``SwitchCaseSyntax``.``SwitchCaseSyntax/statements``
public struct CodeBlockItemListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = CodeBlockItemSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .codeBlockItemList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.codeBlockItemList
}

/// ### Children
/// 
/// ``CompositionTypeElementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``CompositionTypeSyntax``.``CompositionTypeSyntax/elements``
public struct CompositionTypeElementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = CompositionTypeElementSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .compositionTypeElementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.compositionTypeElementList
}

/// ### Children
/// 
/// ``ConditionElementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``GuardStmtSyntax``.``GuardStmtSyntax/conditions``
///  - ``IfExprSyntax``.``IfExprSyntax/conditions``
///  - ``WhileStmtSyntax``.``WhileStmtSyntax/conditions``
public struct ConditionElementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = ConditionElementSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .conditionElementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.conditionElementList
}

/// ### Children
/// 
/// ``DeclModifierSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``ActorDeclSyntax``.``ActorDeclSyntax/modifiers``
///  - ``AssociatedTypeDeclSyntax``.``AssociatedTypeDeclSyntax/modifiers``
///  - ``ClassDeclSyntax``.``ClassDeclSyntax/modifiers``
///  - ``ClosureParameterSyntax``.``ClosureParameterSyntax/modifiers``
///  - ``DeinitializerDeclSyntax``.``DeinitializerDeclSyntax/modifiers``
///  - ``EditorPlaceholderDeclSyntax``.``EditorPlaceholderDeclSyntax/modifiers``
///  - ``EnumCaseDeclSyntax``.``EnumCaseDeclSyntax/modifiers``
///  - ``EnumCaseParameterSyntax``.``EnumCaseParameterSyntax/modifiers``
///  - ``EnumDeclSyntax``.``EnumDeclSyntax/modifiers``
///  - ``ExtensionDeclSyntax``.``ExtensionDeclSyntax/modifiers``
///  - ``FunctionDeclSyntax``.``FunctionDeclSyntax/modifiers``
///  - ``FunctionParameterSyntax``.``FunctionParameterSyntax/modifiers``
///  - ``ImportDeclSyntax``.``ImportDeclSyntax/modifiers``
///  - ``InitializerDeclSyntax``.``InitializerDeclSyntax/modifiers``
///  - ``MacroDeclSyntax``.``MacroDeclSyntax/modifiers``
///  - ``MacroExpansionDeclSyntax``.``MacroExpansionDeclSyntax/modifiers``
///  - ``MissingDeclSyntax``.``MissingDeclSyntax/modifiers``
///  - ``PrecedenceGroupDeclSyntax``.``PrecedenceGroupDeclSyntax/modifiers``
///  - ``ProtocolDeclSyntax``.``ProtocolDeclSyntax/modifiers``
///  - ``StructDeclSyntax``.``StructDeclSyntax/modifiers``
///  - ``SubscriptDeclSyntax``.``SubscriptDeclSyntax/modifiers``
///  - ``TypeAliasDeclSyntax``.``TypeAliasDeclSyntax/modifiers``
///  - ``VariableDeclSyntax``.``VariableDeclSyntax/modifiers``
public struct DeclModifierListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = DeclModifierSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .declModifierList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.declModifierList
}

/// ### Children
/// 
/// ``DeclNameArgumentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``DeclNameArgumentsSyntax``.``DeclNameArgumentsSyntax/arguments``
public struct DeclNameArgumentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = DeclNameArgumentSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .declNameArgumentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.declNameArgumentList
}

/// ### Children
/// 
/// ``DesignatedTypeSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``OperatorPrecedenceAndTypesSyntax``.``OperatorPrecedenceAndTypesSyntax/designatedTypes``
public struct DesignatedTypeListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = DesignatedTypeSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .designatedTypeList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.designatedTypeList
}

/// ### Children
/// 
/// ``DictionaryElementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``DictionaryExprSyntax``.``DictionaryExprSyntax/content``
public struct DictionaryElementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = DictionaryElementSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .dictionaryElementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.dictionaryElementList
}

/// ### Children
/// 
/// ``DifferentiabilityArgumentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``DifferentiabilityArgumentsSyntax``.``DifferentiabilityArgumentsSyntax/arguments``
public struct DifferentiabilityArgumentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = DifferentiabilityArgumentSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .differentiabilityArgumentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.differentiabilityArgumentList
}

/// The arguments of the '@_documentation' attribute
///
/// ### Children
/// 
/// ``DocumentationAttributeArgumentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct DocumentationAttributeArgumentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = DocumentationAttributeArgumentSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .documentationAttributeArgumentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.documentationAttributeArgumentList
}

/// The arguments of the '@_effects' attribute. These will be parsed during the SIL stage.
///
/// ### Children
/// 
/// ``TokenSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct EffectsAttributeArgumentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = TokenSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .effectsAttributeArgumentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.effectsAttributeArgumentList
}

/// A collection of 0 or more `EnumCaseElement`s.
///
/// ### Children
/// 
/// ``EnumCaseElementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``EnumCaseDeclSyntax``.``EnumCaseDeclSyntax/elements``
public struct EnumCaseElementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = EnumCaseElementSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .enumCaseElementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.enumCaseElementList
}

/// ### Children
/// 
/// ``EnumCaseParameterSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``EnumCaseParameterClauseSyntax``.``EnumCaseParameterClauseSyntax/parameters``
public struct EnumCaseParameterListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = EnumCaseParameterSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .enumCaseParameterList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.enumCaseParameterList
}

/// A list of expressions connected by operators. This list is contained by a ``SequenceExprSyntax``.
///
/// ### Children
/// 
/// ``ExprSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``SequenceExprSyntax``.``SequenceExprSyntax/elements``
public struct ExprListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = ExprSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .exprList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.exprList
}

/// ### Children
/// 
/// ``FunctionParameterSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``FunctionParameterClauseSyntax``.``FunctionParameterClauseSyntax/parameters``
public struct FunctionParameterListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = FunctionParameterSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .functionParameterList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.functionParameterList
}

/// ### Children
/// 
/// ``GenericArgumentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``GenericArgumentClauseSyntax``.``GenericArgumentClauseSyntax/arguments``
public struct GenericArgumentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = GenericArgumentSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .genericArgumentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.genericArgumentList
}

/// ### Children
/// 
/// ``GenericParameterSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``GenericParameterClauseSyntax``.``GenericParameterClauseSyntax/parameters``
public struct GenericParameterListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = GenericParameterSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .genericParameterList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.genericParameterList
}

/// ### Children
/// 
/// ``GenericRequirementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``GenericWhereClauseSyntax``.``GenericWhereClauseSyntax/requirements``
public struct GenericRequirementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = GenericRequirementSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .genericRequirementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.genericRequirementList
}

/// ### Children
/// 
/// ``IfConfigClauseSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``IfConfigDeclSyntax``.``IfConfigDeclSyntax/clauses``
public struct IfConfigClauseListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = IfConfigClauseSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .ifConfigClauseList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.ifConfigClauseList
}

/// ### Children
/// 
/// ``ImportPathComponentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``ImportDeclSyntax``.``ImportDeclSyntax/path``
public struct ImportPathComponentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = ImportPathComponentSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .importPathComponentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.importPathComponentList
}

/// ### Children
/// 
/// ``InheritedTypeSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``InheritanceClauseSyntax``.``InheritanceClauseSyntax/inheritedTypes``
public struct InheritedTypeListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = InheritedTypeSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .inheritedTypeList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.inheritedTypeList
}

/// ### Children
/// 
/// ``KeyPathComponentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``KeyPathExprSyntax``.``KeyPathExprSyntax/components``
public struct KeyPathComponentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = KeyPathComponentSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .keyPathComponentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.keyPathComponentList
}

/// ### Children
/// 
/// ``LabeledExprSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
///  - ``ExpressionSegmentSyntax``.``ExpressionSegmentSyntax/expressions``
///  - ``FunctionCallExprSyntax``.``FunctionCallExprSyntax/arguments``
///  - ``KeyPathSubscriptComponentSyntax``.``KeyPathSubscriptComponentSyntax/arguments``
///  - ``MacroExpansionDeclSyntax``.``MacroExpansionDeclSyntax/arguments``
///  - ``MacroExpansionExprSyntax``.``MacroExpansionExprSyntax/arguments``
///  - ``SubscriptCallExprSyntax``.``SubscriptCallExprSyntax/arguments``
///  - ``TupleExprSyntax``.``TupleExprSyntax/elements``
public struct LabeledExprListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = LabeledExprSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .labeledExprList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.labeledExprList
}

/// ### Children
/// 
/// ``MemberBlockItemSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``IfConfigClauseSyntax``.``IfConfigClauseSyntax/elements``
///  - ``MemberBlockSyntax``.``MemberBlockSyntax/members``
public struct MemberBlockItemListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = MemberBlockItemSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .memberBlockItemList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.memberBlockItemList
}

/// ### Children
/// 
/// ``MultipleTrailingClosureElementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``FunctionCallExprSyntax``.``FunctionCallExprSyntax/additionalTrailingClosures``
///  - ``MacroExpansionDeclSyntax``.``MacroExpansionDeclSyntax/additionalTrailingClosures``
///  - ``MacroExpansionExprSyntax``.``MacroExpansionExprSyntax/additionalTrailingClosures``
///  - ``SubscriptCallExprSyntax``.``SubscriptCallExprSyntax/additionalTrailingClosures``
public struct MultipleTrailingClosureElementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = MultipleTrailingClosureElementSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .multipleTrailingClosureElementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.multipleTrailingClosureElementList
}

/// ### Children
/// 
/// ``ObjCSelectorPieceSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct ObjCSelectorPieceListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = ObjCSelectorPieceSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .objCSelectorPieceList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.objCSelectorPieceList
}

/// ### Children
/// 
/// ``PatternBindingSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``VariableDeclSyntax``.``VariableDeclSyntax/bindings``
public struct PatternBindingListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = PatternBindingSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .patternBindingList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.patternBindingList
}

/// ### Children
/// 
/// ``PlatformVersionItemSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``BackDeployedAttributeArgumentsSyntax``.``BackDeployedAttributeArgumentsSyntax/platforms``
///  - ``OriginallyDefinedInAttributeArgumentsSyntax``.``OriginallyDefinedInAttributeArgumentsSyntax/platforms``
public struct PlatformVersionItemListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = PlatformVersionItemSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .platformVersionItemList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.platformVersionItemList
}

/// ### Children
/// 
/// (``PrecedenceGroupRelationSyntax`` | ``PrecedenceGroupAssignmentSyntax`` | ``PrecedenceGroupAssociativitySyntax``) `*`
///
/// ### Contained in
/// 
///  - ``PrecedenceGroupDeclSyntax``.``PrecedenceGroupDeclSyntax/groupAttributes``
public struct PrecedenceGroupAttributeListSyntax: SyntaxCollection, SyntaxHashable {
  public enum Element: SyntaxChildChoices, SyntaxHashable {
    case `precedenceGroupRelation`(PrecedenceGroupRelationSyntax)
    case `precedenceGroupAssignment`(PrecedenceGroupAssignmentSyntax)
    case `precedenceGroupAssociativity`(PrecedenceGroupAssociativitySyntax)
    
    public var _syntaxNode: Syntax {
      switch self {
      case .precedenceGroupRelation(let node):
        return node._syntaxNode
      case .precedenceGroupAssignment(let node):
        return node._syntaxNode
      case .precedenceGroupAssociativity(let node):
        return node._syntaxNode
      }
    }
    
    public init(_ node: PrecedenceGroupRelationSyntax) {
      self = .precedenceGroupRelation(node)
    }
    
    public init(_ node: PrecedenceGroupAssignmentSyntax) {
      self = .precedenceGroupAssignment(node)
    }
    
    public init(_ node: PrecedenceGroupAssociativitySyntax) {
      self = .precedenceGroupAssociativity(node)
    }
    
    public init?(_ node: some SyntaxProtocol) {
      if let node = node.as(PrecedenceGroupRelationSyntax.self) {
        self = .precedenceGroupRelation(node)
        return
      }
      if let node = node.as(PrecedenceGroupAssignmentSyntax.self) {
        self = .precedenceGroupAssignment(node)
        return
      }
      if let node = node.as(PrecedenceGroupAssociativitySyntax.self) {
        self = .precedenceGroupAssociativity(node)
        return
      }
      return nil
    }
    
    public static var structure: SyntaxNodeStructure {
      return .choices([
          .node(PrecedenceGroupRelationSyntax.self),
          .node(PrecedenceGroupAssignmentSyntax.self),
          .node(PrecedenceGroupAssociativitySyntax.self)])
    }
  }
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .precedenceGroupAttributeList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.precedenceGroupAttributeList
}

/// ### Children
/// 
/// ``PrecedenceGroupNameSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``PrecedenceGroupRelationSyntax``.``PrecedenceGroupRelationSyntax/precedenceGroups``
public struct PrecedenceGroupNameListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = PrecedenceGroupNameSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .precedenceGroupNameList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.precedenceGroupNameList
}

/// ### Children
/// 
/// ``PrimaryAssociatedTypeSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``PrimaryAssociatedTypeClauseSyntax``.``PrimaryAssociatedTypeClauseSyntax/primaryAssociatedTypes``
public struct PrimaryAssociatedTypeListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = PrimaryAssociatedTypeSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .primaryAssociatedTypeList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.primaryAssociatedTypeList
}

/// String literal segments that only can contain non string interpolated or extended escaped strings
///
/// ### Children
/// 
/// ``StringSegmentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``SimpleStringLiteralExprSyntax``.``SimpleStringLiteralExprSyntax/segments``
public struct SimpleStringLiteralSegmentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = StringSegmentSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .simpleStringLiteralSegmentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.simpleStringLiteralSegmentList
}

/// A collection of arguments for the `@_specialize` attribute
///
/// ### Children
/// 
/// (``LabeledSpecializeArgumentSyntax`` | ``SpecializeAvailabilityArgumentSyntax`` | ``SpecializeTargetFunctionArgumentSyntax`` | ``GenericWhereClauseSyntax``) `*`
///
/// ### Contained in
/// 
///  - ``AttributeSyntax``.``AttributeSyntax/arguments``
public struct SpecializeAttributeArgumentListSyntax: SyntaxCollection, SyntaxHashable {
  public enum Element: SyntaxChildChoices, SyntaxHashable {
    case `labeledSpecializeArgument`(LabeledSpecializeArgumentSyntax)
    case `specializeAvailabilityArgument`(SpecializeAvailabilityArgumentSyntax)
    case `specializeTargetFunctionArgument`(SpecializeTargetFunctionArgumentSyntax)
    case `genericWhereClause`(GenericWhereClauseSyntax)
    
    public var _syntaxNode: Syntax {
      switch self {
      case .labeledSpecializeArgument(let node):
        return node._syntaxNode
      case .specializeAvailabilityArgument(let node):
        return node._syntaxNode
      case .specializeTargetFunctionArgument(let node):
        return node._syntaxNode
      case .genericWhereClause(let node):
        return node._syntaxNode
      }
    }
    
    public init(_ node: LabeledSpecializeArgumentSyntax) {
      self = .labeledSpecializeArgument(node)
    }
    
    public init(_ node: SpecializeAvailabilityArgumentSyntax) {
      self = .specializeAvailabilityArgument(node)
    }
    
    public init(_ node: SpecializeTargetFunctionArgumentSyntax) {
      self = .specializeTargetFunctionArgument(node)
    }
    
    public init(_ node: GenericWhereClauseSyntax) {
      self = .genericWhereClause(node)
    }
    
    public init?(_ node: some SyntaxProtocol) {
      if let node = node.as(LabeledSpecializeArgumentSyntax.self) {
        self = .labeledSpecializeArgument(node)
        return
      }
      if let node = node.as(SpecializeAvailabilityArgumentSyntax.self) {
        self = .specializeAvailabilityArgument(node)
        return
      }
      if let node = node.as(SpecializeTargetFunctionArgumentSyntax.self) {
        self = .specializeTargetFunctionArgument(node)
        return
      }
      if let node = node.as(GenericWhereClauseSyntax.self) {
        self = .genericWhereClause(node)
        return
      }
      return nil
    }
    
    public static var structure: SyntaxNodeStructure {
      return .choices([
            .node(LabeledSpecializeArgumentSyntax.self),
            .node(SpecializeAvailabilityArgumentSyntax.self),
            .node(SpecializeTargetFunctionArgumentSyntax.self),
            .node(GenericWhereClauseSyntax.self)
          ])
    }
  }
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .specializeAttributeArgumentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.specializeAttributeArgumentList
}

/// ### Children
/// 
/// (``StringSegmentSyntax`` | ``ExpressionSegmentSyntax``) `*`
///
/// ### Contained in
/// 
///  - ``StringLiteralExprSyntax``.``StringLiteralExprSyntax/segments``
public struct StringLiteralSegmentListSyntax: SyntaxCollection, SyntaxHashable {
  public enum Element: SyntaxChildChoices, SyntaxHashable {
    case `stringSegment`(StringSegmentSyntax)
    case `expressionSegment`(ExpressionSegmentSyntax)
    
    public var _syntaxNode: Syntax {
      switch self {
      case .stringSegment(let node):
        return node._syntaxNode
      case .expressionSegment(let node):
        return node._syntaxNode
      }
    }
    
    public init(_ node: StringSegmentSyntax) {
      self = .stringSegment(node)
    }
    
    public init(_ node: ExpressionSegmentSyntax) {
      self = .expressionSegment(node)
    }
    
    public init?(_ node: some SyntaxProtocol) {
      if let node = node.as(StringSegmentSyntax.self) {
        self = .stringSegment(node)
        return
      }
      if let node = node.as(ExpressionSegmentSyntax.self) {
        self = .expressionSegment(node)
        return
      }
      return nil
    }
    
    public static var structure: SyntaxNodeStructure {
      return .choices([
          .node(StringSegmentSyntax.self),
          .node(ExpressionSegmentSyntax.self)])
    }
  }
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .stringLiteralSegmentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.stringLiteralSegmentList
}

/// ### Children
/// 
/// ``SwitchCaseItemSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``SwitchCaseLabelSyntax``.``SwitchCaseLabelSyntax/caseItems``
public struct SwitchCaseItemListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = SwitchCaseItemSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .switchCaseItemList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.switchCaseItemList
}

/// ### Children
/// 
/// (``SwitchCaseSyntax`` | ``IfConfigDeclSyntax``) `*`
///
/// ### Contained in
/// 
///  - ``IfConfigClauseSyntax``.``IfConfigClauseSyntax/elements``
///  - ``SwitchExprSyntax``.``SwitchExprSyntax/cases``
public struct SwitchCaseListSyntax: SyntaxCollection, SyntaxHashable {
  public enum Element: SyntaxChildChoices, SyntaxHashable {
    case `switchCase`(SwitchCaseSyntax)
    case `ifConfigDecl`(IfConfigDeclSyntax)
    
    public var _syntaxNode: Syntax {
      switch self {
      case .switchCase(let node):
        return node._syntaxNode
      case .ifConfigDecl(let node):
        return node._syntaxNode
      }
    }
    
    public init(_ node: SwitchCaseSyntax) {
      self = .switchCase(node)
    }
    
    public init(_ node: IfConfigDeclSyntax) {
      self = .ifConfigDecl(node)
    }
    
    public init?(_ node: some SyntaxProtocol) {
      if let node = node.as(SwitchCaseSyntax.self) {
        self = .switchCase(node)
        return
      }
      if let node = node.as(IfConfigDeclSyntax.self) {
        self = .ifConfigDecl(node)
        return
      }
      return nil
    }
    
    public static var structure: SyntaxNodeStructure {
      return .choices([
          .node(SwitchCaseSyntax.self),
          .node(IfConfigDeclSyntax.self)])
    }
  }
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .switchCaseList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.switchCaseList
}

/// ### Children
/// 
/// ``TuplePatternElementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``TuplePatternSyntax``.``TuplePatternSyntax/elements``
public struct TuplePatternElementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = TuplePatternElementSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .tuplePatternElementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.tuplePatternElementList
}

/// ### Children
/// 
/// ``TupleTypeElementSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``FunctionTypeSyntax``.``FunctionTypeSyntax/parameters``
///  - ``TupleTypeSyntax``.``TupleTypeSyntax/elements``
public struct TupleTypeElementListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = TupleTypeElementSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .tupleTypeElementList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.tupleTypeElementList
}

/// A collection of syntax nodes that occurred in the source code but could not be used to form a valid syntax tree.
///
/// ### Children
/// 
/// ``Syntax`` `*`
public struct UnexpectedNodesSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = Syntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .unexpectedNodes else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.unexpectedNodes
}

/// ### Children
/// 
/// ``VersionComponentSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``VersionTupleSyntax``.``VersionTupleSyntax/components``
public struct VersionComponentListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = VersionComponentSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .versionComponentList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.versionComponentList
}

/// ### Children
/// 
/// ``YieldedExpressionSyntax`` `*`
///
/// ### Contained in
/// 
///  - ``YieldedExpressionsClauseSyntax``.``YieldedExpressionsClauseSyntax/elements``
public struct YieldedExpressionListSyntax: SyntaxCollection, SyntaxHashable {
  public typealias Element = YieldedExpressionSyntax
  
  public let _syntaxNode: Syntax
  
  public init?(_ node: some SyntaxProtocol) {
    guard node.raw.kind == .yieldedExpressionList else {
      return nil
    }
    self._syntaxNode = node._syntaxNode
  }
  
  public static let syntaxKind = SyntaxKind.yieldedExpressionList
}
