/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service.pdfjson.type3;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.PDFGraphicsStreamEngine;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType3CharProc;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Type3GraphicsEngine
extends PDFGraphicsStreamEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Type3GraphicsEngine.class);
    private final GeneralPath accumulatedPath = new GeneralPath();
    private final GeneralPath linePath = new GeneralPath();
    private final Point2D.Float currentPoint = new Point2D.Float();
    private boolean hasCurrentPoint;
    private boolean sawStroke;
    private boolean sawFill;
    private boolean sawImage;
    private boolean sawText;
    private boolean sawShading;
    private String warnings;

    protected Type3GraphicsEngine(PDPage page) {
        super(page);
    }

    public GeneralPath getAccumulatedPath() {
        return (GeneralPath)this.accumulatedPath.clone();
    }

    public void process(PDType3CharProc charProc) throws IOException {
        this.accumulatedPath.reset();
        this.linePath.reset();
        this.sawStroke = false;
        this.sawFill = false;
        this.sawImage = false;
        this.sawText = false;
        this.sawShading = false;
        this.warnings = null;
        if (charProc != null) {
            this.processChildStream((PDContentStream)charProc, this.getPage());
        }
    }

    public void appendRectangle(Point2D p0, Point2D p1, Point2D p2, Point2D p3) throws IOException {
        this.moveTo((float)p0.getX(), (float)p0.getY());
        this.lineTo((float)p1.getX(), (float)p1.getY());
        this.lineTo((float)p2.getX(), (float)p2.getY());
        this.lineTo((float)p3.getX(), (float)p3.getY());
        this.closePath();
    }

    public void drawImage(PDImage pdImage) throws IOException {
        this.sawImage = true;
    }

    public void shadingFill(COSName shadingName) throws IOException {
        this.sawShading = true;
    }

    public void strokePath() throws IOException {
        this.accumulatedPath.append(this.linePath, false);
        this.linePath.reset();
        this.sawStroke = true;
    }

    public void fillPath(int windingRule) throws IOException {
        this.linePath.setWindingRule(windingRule == 0 ? 0 : 1);
        this.accumulatedPath.append(this.linePath, false);
        this.linePath.reset();
        this.sawFill = true;
    }

    public void fillAndStrokePath(int windingRule) throws IOException {
        this.fillPath(windingRule);
        this.sawStroke = true;
    }

    public void clip(int windingRule) throws IOException {
    }

    public void moveTo(float x, float y) throws IOException {
        this.linePath.moveTo(x, y);
        this.currentPoint.setLocation(x, y);
        this.hasCurrentPoint = true;
    }

    public void lineTo(float x, float y) throws IOException {
        this.linePath.lineTo(x, y);
        this.currentPoint.setLocation(x, y);
        this.hasCurrentPoint = true;
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        this.linePath.curveTo(x1, y1, x2, y2, x3, y3);
        this.currentPoint.setLocation(x3, y3);
        this.hasCurrentPoint = true;
    }

    public Point2D getCurrentPoint() throws IOException {
        return this.hasCurrentPoint ? (Point2D)this.currentPoint.clone() : null;
    }

    public void closePath() throws IOException {
        this.linePath.closePath();
    }

    public void endPath() throws IOException {
        this.linePath.reset();
        this.hasCurrentPoint = false;
    }

    protected void showText(byte[] string) throws IOException {
        this.sawText = true;
        super.showText(string);
    }

    protected void showFontGlyph(Matrix textRenderingMatrix, PDFont font, int code, Vector displacement) throws IOException {
        this.sawText = true;
        super.showFontGlyph(textRenderingMatrix, font, code, displacement);
    }

    protected void processOperator(Operator operator, List<COSBase> operands) throws IOException {
        if ("cm".equals(operator.getName())) {
            this.warnings = this.warnings == null ? "Encountered CTM concatenation" : this.warnings + "; CTM concat";
        }
        super.processOperator(operator, operands);
    }

    @Generated
    public boolean isSawStroke() {
        return this.sawStroke;
    }

    @Generated
    public boolean isSawFill() {
        return this.sawFill;
    }

    @Generated
    public boolean isSawImage() {
        return this.sawImage;
    }

    @Generated
    public boolean isSawText() {
        return this.sawText;
    }

    @Generated
    public boolean isSawShading() {
        return this.sawShading;
    }

    @Generated
    public String getWarnings() {
        return this.warnings;
    }
}

