/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service;

import jakarta.annotation.PostConstruct;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;
import stirling.software.SPDF.model.json.PdfJsonFont;
import stirling.software.SPDF.service.PdfJsonFallbackFontService;
import stirling.software.common.model.ApplicationProperties;

@Component
public class PdfJsonFallbackFontService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfJsonFallbackFontService.class);
    public static final String FALLBACK_FONT_ID = "fallback-noto-sans";
    public static final String DEFAULT_FALLBACK_FONT_LOCATION = "classpath:/static/fonts/NotoSans-Regular.ttf";
    public static final String FALLBACK_FONT_CJK_ID = "fallback-noto-cjk";
    public static final String FALLBACK_FONT_JP_ID = "fallback-noto-jp";
    public static final String FALLBACK_FONT_KR_ID = "fallback-noto-korean";
    public static final String FALLBACK_FONT_TC_ID = "fallback-noto-tc";
    public static final String FALLBACK_FONT_AR_ID = "fallback-noto-arabic";
    public static final String FALLBACK_FONT_TH_ID = "fallback-noto-thai";
    public static final String FALLBACK_FONT_DEVANAGARI_ID = "fallback-noto-devanagari";
    public static final String FALLBACK_FONT_MALAYALAM_ID = "fallback-noto-malayalam";
    public static final String FALLBACK_FONT_TIBETAN_ID = "fallback-noto-tibetan";
    private static final Map<String, String> FONT_NAME_ALIASES = Map.ofEntries(Map.entry("arial", "fallback-liberation-sans"), Map.entry("helvetica", "fallback-liberation-sans"), Map.entry("arimo", "fallback-liberation-sans"), Map.entry("liberationsans", "fallback-liberation-sans"), Map.entry("times", "fallback-liberation-serif"), Map.entry("timesnewroman", "fallback-liberation-serif"), Map.entry("tinos", "fallback-liberation-serif"), Map.entry("liberationserif", "fallback-liberation-serif"), Map.entry("courier", "fallback-liberation-mono"), Map.entry("couriernew", "fallback-liberation-mono"), Map.entry("cousine", "fallback-liberation-mono"), Map.entry("liberationmono", "fallback-liberation-mono"), Map.entry("dejavu", "fallback-dejavu-sans"), Map.entry("dejavusans", "fallback-dejavu-sans"), Map.entry("dejavuserif", "fallback-dejavu-serif"), Map.entry("dejavumono", "fallback-dejavu-mono"), Map.entry("dejavusansmono", "fallback-dejavu-mono"), Map.entry("mingliu", "fallback-noto-tc"), Map.entry("pmingliu", "fallback-noto-tc"), Map.entry("microsoftjhenghei", "fallback-noto-tc"), Map.entry("jhenghei", "fallback-noto-tc"), Map.entry("kaiti", "fallback-noto-tc"), Map.entry("kaiu", "fallback-noto-tc"), Map.entry("dfkaib5", "fallback-noto-tc"), Map.entry("dfkai", "fallback-noto-tc"), Map.entry("simsun", "fallback-noto-cjk"), Map.entry("simhei", "fallback-noto-cjk"), Map.entry("microsoftyahei", "fallback-noto-cjk"), Map.entry("yahei", "fallback-noto-cjk"), Map.entry("songti", "fallback-noto-cjk"), Map.entry("heiti", "fallback-noto-cjk"), Map.entry("noto", "fallback-noto-sans"), Map.entry("notosans", "fallback-noto-sans"));
    private static final Map<String, FallbackFontSpec> BUILT_IN_FALLBACK_FONTS = Map.ofEntries(Map.entry("fallback-noto-cjk", new FallbackFontSpec("classpath:/static/fonts/NotoSansSC-Regular.ttf", "NotoSansSC-Regular", "ttf")), Map.entry("fallback-noto-jp", new FallbackFontSpec("classpath:/static/fonts/NotoSansJP-Regular.ttf", "NotoSansJP-Regular", "ttf")), Map.entry("fallback-noto-korean", new FallbackFontSpec("classpath:/static/fonts/NotoSansKR-Regular.ttf", "NotoSansKR-Regular", "ttf")), Map.entry("fallback-noto-tc", new FallbackFontSpec("classpath:/static/fonts/NotoSansTC-Regular.ttf", "NotoSansTC-Regular", "ttf")), Map.entry("fallback-noto-arabic", new FallbackFontSpec("classpath:/static/fonts/NotoSansArabic-Regular.ttf", "NotoSansArabic-Regular", "ttf")), Map.entry("fallback-noto-thai", new FallbackFontSpec("classpath:/static/fonts/NotoSansThai-Regular.ttf", "NotoSansThai-Regular", "ttf")), Map.entry("fallback-noto-devanagari", new FallbackFontSpec("classpath:/static/fonts/NotoSansDevanagari-Regular.ttf", "NotoSansDevanagari-Regular", "ttf")), Map.entry("fallback-noto-malayalam", new FallbackFontSpec("classpath:/static/fonts/NotoSansMalayalam-Regular.ttf", "NotoSansMalayalam-Regular", "ttf")), Map.entry("fallback-noto-tibetan", new FallbackFontSpec("classpath:/static/fonts/NotoSerifTibetan-Regular.ttf", "NotoSerifTibetan-Regular", "ttf")), Map.entry("fallback-liberation-sans", new FallbackFontSpec("classpath:/static/fonts/LiberationSans-Regular.ttf", "LiberationSans-Regular", "ttf")), Map.entry("fallback-liberation-sans-bold", new FallbackFontSpec("classpath:/static/fonts/LiberationSans-Bold.ttf", "LiberationSans-Bold", "ttf")), Map.entry("fallback-liberation-sans-italic", new FallbackFontSpec("classpath:/static/fonts/LiberationSans-Italic.ttf", "LiberationSans-Italic", "ttf")), Map.entry("fallback-liberation-sans-bolditalic", new FallbackFontSpec("classpath:/static/fonts/LiberationSans-BoldItalic.ttf", "LiberationSans-BoldItalic", "ttf")), Map.entry("fallback-liberation-serif", new FallbackFontSpec("classpath:/static/fonts/LiberationSerif-Regular.ttf", "LiberationSerif-Regular", "ttf")), Map.entry("fallback-liberation-serif-bold", new FallbackFontSpec("classpath:/static/fonts/LiberationSerif-Bold.ttf", "LiberationSerif-Bold", "ttf")), Map.entry("fallback-liberation-serif-italic", new FallbackFontSpec("classpath:/static/fonts/LiberationSerif-Italic.ttf", "LiberationSerif-Italic", "ttf")), Map.entry("fallback-liberation-serif-bolditalic", new FallbackFontSpec("classpath:/static/fonts/LiberationSerif-BoldItalic.ttf", "LiberationSerif-BoldItalic", "ttf")), Map.entry("fallback-liberation-mono", new FallbackFontSpec("classpath:/static/fonts/LiberationMono-Regular.ttf", "LiberationMono-Regular", "ttf")), Map.entry("fallback-liberation-mono-bold", new FallbackFontSpec("classpath:/static/fonts/LiberationMono-Bold.ttf", "LiberationMono-Bold", "ttf")), Map.entry("fallback-liberation-mono-italic", new FallbackFontSpec("classpath:/static/fonts/LiberationMono-Italic.ttf", "LiberationMono-Italic", "ttf")), Map.entry("fallback-liberation-mono-bolditalic", new FallbackFontSpec("classpath:/static/fonts/LiberationMono-BoldItalic.ttf", "LiberationMono-BoldItalic", "ttf")), Map.entry("fallback-noto-sans", new FallbackFontSpec("classpath:/static/fonts/NotoSans-Regular.ttf", "NotoSans-Regular", "ttf")), Map.entry("fallback-noto-sans-bold", new FallbackFontSpec("classpath:/static/fonts/NotoSans-Bold.ttf", "NotoSans-Bold", "ttf")), Map.entry("fallback-noto-sans-italic", new FallbackFontSpec("classpath:/static/fonts/NotoSans-Italic.ttf", "NotoSans-Italic", "ttf")), Map.entry("fallback-noto-sans-bolditalic", new FallbackFontSpec("classpath:/static/fonts/NotoSans-BoldItalic.ttf", "NotoSans-BoldItalic", "ttf")), Map.entry("fallback-dejavu-sans", new FallbackFontSpec("classpath:/static/fonts/DejaVuSans.ttf", "DejaVuSans", "ttf")), Map.entry("fallback-dejavu-sans-bold", new FallbackFontSpec("classpath:/static/fonts/DejaVuSans-Bold.ttf", "DejaVuSans-Bold", "ttf")), Map.entry("fallback-dejavu-sans-oblique", new FallbackFontSpec("classpath:/static/fonts/DejaVuSans-Oblique.ttf", "DejaVuSans-Oblique", "ttf")), Map.entry("fallback-dejavu-sans-boldoblique", new FallbackFontSpec("classpath:/static/fonts/DejaVuSans-BoldOblique.ttf", "DejaVuSans-BoldOblique", "ttf")), Map.entry("fallback-dejavu-serif", new FallbackFontSpec("classpath:/static/fonts/DejaVuSerif.ttf", "DejaVuSerif", "ttf")), Map.entry("fallback-dejavu-serif-bold", new FallbackFontSpec("classpath:/static/fonts/DejaVuSerif-Bold.ttf", "DejaVuSerif-Bold", "ttf")), Map.entry("fallback-dejavu-serif-italic", new FallbackFontSpec("classpath:/static/fonts/DejaVuSerif-Italic.ttf", "DejaVuSerif-Italic", "ttf")), Map.entry("fallback-dejavu-serif-bolditalic", new FallbackFontSpec("classpath:/static/fonts/DejaVuSerif-BoldItalic.ttf", "DejaVuSerif-BoldItalic", "ttf")), Map.entry("fallback-dejavu-mono", new FallbackFontSpec("classpath:/static/fonts/DejaVuSansMono.ttf", "DejaVuSansMono", "ttf")), Map.entry("fallback-dejavu-mono-bold", new FallbackFontSpec("classpath:/static/fonts/DejaVuSansMono-Bold.ttf", "DejaVuSansMono-Bold", "ttf")), Map.entry("fallback-dejavu-mono-oblique", new FallbackFontSpec("classpath:/static/fonts/DejaVuSansMono-Oblique.ttf", "DejaVuSansMono-Oblique", "ttf")), Map.entry("fallback-dejavu-mono-boldoblique", new FallbackFontSpec("classpath:/static/fonts/DejaVuSansMono-BoldOblique.ttf", "DejaVuSansMono-BoldOblique", "ttf")));
    private final ResourceLoader resourceLoader;
    private final ApplicationProperties applicationProperties;
    @Value(value="${stirling.pdf.fallback-font:classpath:/static/fonts/NotoSans-Regular.ttf}")
    private String legacyFallbackFontLocation;
    private String fallbackFontLocation;
    private final Map<String, byte[]> fallbackFontCache = new ConcurrentHashMap();

    @PostConstruct
    private void loadConfig() {
        String configured = null;
        if (this.applicationProperties.getPdfEditor() != null) {
            configured = this.applicationProperties.getPdfEditor().getFallbackFont();
        }
        this.fallbackFontLocation = configured != null && !configured.isBlank() ? configured : this.legacyFallbackFontLocation;
        log.info("Using fallback font location: {}", (Object)this.fallbackFontLocation);
    }

    public PdfJsonFont buildFallbackFontModel() throws IOException {
        return this.buildFallbackFontModel(FALLBACK_FONT_ID);
    }

    public PdfJsonFont buildFallbackFontModel(String fallbackId) throws IOException {
        FallbackFontSpec spec = this.getFallbackFontSpec(fallbackId);
        if (spec == null) {
            throw new IOException("Unknown fallback font id " + fallbackId);
        }
        byte[] bytes = this.loadFallbackFontBytes(fallbackId, spec);
        String base64 = Base64.getEncoder().encodeToString(bytes);
        return PdfJsonFont.builder().id(fallbackId).uid(fallbackId).baseName(spec.baseName()).subtype("TrueType").embedded(Boolean.valueOf(true)).program(base64).programFormat(spec.format()).build();
    }

    public PDFont loadFallbackPdfFont(PDDocument document) throws IOException {
        return this.loadFallbackPdfFont(document, FALLBACK_FONT_ID);
    }

    public PDFont loadFallbackPdfFont(PDDocument document, String fallbackId) throws IOException {
        FallbackFontSpec spec = this.getFallbackFontSpec(fallbackId);
        if (spec == null) {
            throw new IOException("Unknown fallback font id " + fallbackId);
        }
        byte[] bytes = this.loadFallbackFontBytes(fallbackId, spec);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            PDType0Font pDType0Font = PDType0Font.load((PDDocument)document, (InputStream)stream, (boolean)false);
            return pDType0Font;
        }
    }

    public boolean canEncodeFully(PDFont font, String text) {
        return this.canEncode(font, text);
    }

    public boolean canEncode(PDFont font, int codePoint) {
        return this.canEncode(font, new String(Character.toChars(codePoint)));
    }

    public boolean canEncode(PDFont font, String text) {
        if (font == null || text == null || text.isEmpty()) {
            return false;
        }
        if (font instanceof PDType3Font) {
            return false;
        }
        try {
            font.encode(text);
            return true;
        }
        catch (IOException | IllegalArgumentException | UnsupportedOperationException ex) {
            log.debug("[FONT-DEBUG] Font {} cannot encode text '{}' ({}): {}", new Object[]{font != null ? font.getName() : "null", text, font != null ? font.getClass().getSimpleName() : "null", ex.getMessage()});
            return false;
        }
    }

    public String resolveFallbackFontId(String originalFontName, int codePoint) {
        String normalized;
        String baseName;
        String aliasedFontId;
        if (originalFontName != null && !originalFontName.isEmpty() && (aliasedFontId = (String)FONT_NAME_ALIASES.get(baseName = (normalized = originalFontName.replaceAll("^[A-Z]{6}\\+", "").toLowerCase().replaceAll("\\s+", "")).split("[-_,+]")[0])) != null) {
            boolean isBold = this.detectBold(normalized);
            boolean isItalic = this.detectItalic(normalized);
            String styledFontId = this.applyWeightStyle(aliasedFontId, isBold, isItalic);
            log.debug("Matched font '{}' (normalized: '{}', base: '{}', bold: {}, italic: {}) to fallback '{}'", new Object[]{originalFontName, normalized, baseName, isBold, isItalic, styledFontId});
            return styledFontId;
        }
        return this.resolveFallbackFontId(codePoint);
    }

    private boolean detectBold(String normalizedFontName) {
        if (normalizedFontName.contains("bold") || normalizedFontName.contains("heavy") || normalizedFontName.contains("black")) {
            return true;
        }
        return normalizedFontName.matches(".*[_-]?[6-9]00(wght)?.*");
    }

    private boolean detectItalic(String normalizedFontName) {
        return normalizedFontName.contains("italic") || normalizedFontName.contains("oblique");
    }

    private String applyWeightStyle(String baseFontId, boolean isBold, boolean isItalic) {
        boolean useOblique;
        boolean isSupported;
        boolean bl = isSupported = baseFontId.startsWith("fallback-liberation-") || baseFontId.equals(FALLBACK_FONT_ID) || baseFontId.startsWith("fallback-dejavu-");
        if (!isSupported) {
            return baseFontId;
        }
        boolean bl2 = useOblique = baseFontId.equals("fallback-dejavu-sans") || baseFontId.equals("fallback-dejavu-mono");
        if (isBold && isItalic) {
            return baseFontId + (useOblique ? "-boldoblique" : "-bolditalic");
        }
        if (isBold) {
            return baseFontId + "-bold";
        }
        if (isItalic) {
            return baseFontId + (useOblique ? "-oblique" : "-italic");
        }
        return baseFontId;
    }

    public String resolveFallbackFontId(int codePoint) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(codePoint);
        if (block == Character.UnicodeBlock.BOPOMOFO || block == Character.UnicodeBlock.BOPOMOFO_EXTENDED) {
            return FALLBACK_FONT_TC_ID;
        }
        if (block == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || block == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT) {
            return FALLBACK_FONT_TC_ID;
        }
        if (block == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || block == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || block == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || block == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C || block == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D || block == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E || block == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_F || block == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || block == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
            return FALLBACK_FONT_CJK_ID;
        }
        Character.UnicodeScript script = Character.UnicodeScript.of(codePoint);
        return switch (1.$SwitchMap$java$lang$Character$UnicodeScript[script.ordinal()]) {
            case 1 -> FALLBACK_FONT_CJK_ID;
            case 2, 3 -> FALLBACK_FONT_JP_ID;
            case 4 -> FALLBACK_FONT_KR_ID;
            case 5 -> FALLBACK_FONT_AR_ID;
            case 6 -> FALLBACK_FONT_TH_ID;
            case 7 -> FALLBACK_FONT_DEVANAGARI_ID;
            case 8 -> FALLBACK_FONT_MALAYALAM_ID;
            case 9 -> FALLBACK_FONT_TIBETAN_ID;
            default -> FALLBACK_FONT_ID;
        };
    }

    public String mapUnsupportedGlyph(int codePoint) {
        return switch (codePoint) {
            case 10094 -> "<";
            case 10095 -> ">";
            default -> null;
        };
    }

    private FallbackFontSpec getFallbackFontSpec(String fallbackId) {
        if (FALLBACK_FONT_ID.equals(fallbackId)) {
            String baseName = this.inferBaseName(this.fallbackFontLocation, "NotoSans-Regular");
            String format = this.inferFormat(this.fallbackFontLocation, "ttf");
            return new FallbackFontSpec(this.fallbackFontLocation, baseName, format);
        }
        return (FallbackFontSpec)BUILT_IN_FALLBACK_FONTS.get(fallbackId);
    }

    private byte[] loadFallbackFontBytes(String fallbackId, FallbackFontSpec spec) throws IOException {
        if (spec == null) {
            throw new IOException("No fallback font specification for " + fallbackId);
        }
        byte[] cached = (byte[])this.fallbackFontCache.get(fallbackId);
        if (cached != null) {
            return cached;
        }
        Resource resource = this.resourceLoader.getResource(spec.resourceLocation());
        if (!resource.exists()) {
            throw new IOException("Fallback font resource not found at " + spec.resourceLocation());
        }
        try (InputStream inputStream = resource.getInputStream();){
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                inputStream.transferTo(baos);
                byte[] bytes = baos.toByteArray();
                this.fallbackFontCache.put(fallbackId, bytes);
                byArray = bytes;
            }
            return byArray;
        }
    }

    private String inferBaseName(String location, String defaultName) {
        if (location == null || location.isBlank()) {
            return defaultName;
        }
        int slash = location.lastIndexOf(47);
        String fileName = slash >= 0 ? location.substring(slash + 1) : location;
        int dot = fileName.lastIndexOf(46);
        if (dot > 0) {
            fileName = fileName.substring(0, dot);
        }
        return fileName.isEmpty() ? defaultName : fileName;
    }

    private String inferFormat(String location, String defaultFormat) {
        if (location == null || location.isBlank()) {
            return defaultFormat;
        }
        int dot = location.lastIndexOf(46);
        if (dot >= 0 && dot < location.length() - 1) {
            return location.substring(dot + 1).toLowerCase(Locale.ROOT);
        }
        return defaultFormat;
    }

    @Generated
    public PdfJsonFallbackFontService(ResourceLoader resourceLoader, ApplicationProperties applicationProperties) {
        this.resourceLoader = resourceLoader;
        this.applicationProperties = applicationProperties;
    }
}

