/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.search.Search;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import stirling.software.SPDF.config.EndpointInspector;
import stirling.software.common.service.PostHogService;

@Service
public class MetricsAggregatorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsAggregatorService.class);
    private final MeterRegistry meterRegistry;
    private final PostHogService postHogService;
    private final EndpointInspector endpointInspector;
    private final Map<String, Double> lastSentMetrics = new ConcurrentHashMap();

    @Scheduled(fixedRate=0x6DDD00L)
    public void aggregateAndSendMetrics() {
        HashMap metrics = new HashMap();
        boolean validateGetEndpoints = !this.endpointInspector.getValidGetEndpoints().isEmpty();
        Search.in((MeterRegistry)this.meterRegistry).name("http.requests").counters().forEach(counter -> {
            double lastCount;
            String method = counter.getId().getTag("method");
            String uri = counter.getId().getTag("uri");
            if (method == null || uri == null) {
                return;
            }
            if (uri.length() <= 2) {
                return;
            }
            if (!"GET".equals(method) && !"POST".equals(method)) {
                return;
            }
            if ("POST".equals(method) && !uri.contains("api/v1")) {
                return;
            }
            if (uri.contains(".txt")) {
                return;
            }
            if ("GET".equals(method) && validateGetEndpoints && !this.endpointInspector.isValidGetEndpoint(uri)) {
                log.debug("Skipping invalid GET endpoint: {}", (Object)uri);
                return;
            }
            String key = String.format(Locale.ROOT, "http_requests_%s_%s", method, uri.replace("/", "_"));
            double currentCount = counter.count();
            double difference = currentCount - (lastCount = this.lastSentMetrics.getOrDefault(key, 0.0).doubleValue());
            if (difference > 0.0) {
                log.debug("{}, {}", (Object)key, (Object)difference);
                metrics.put(key, difference);
                this.lastSentMetrics.put(key, currentCount);
            }
        });
        if (!metrics.isEmpty()) {
            this.postHogService.captureEvent("aggregated_metrics", metrics);
        }
    }

    @Generated
    public MetricsAggregatorService(MeterRegistry meterRegistry, PostHogService postHogService, EndpointInspector endpointInspector) {
        this.meterRegistry = meterRegistry;
        this.postHogService = postHogService;
        this.endpointInspector = endpointInspector;
    }
}

