/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.exception;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.nio.file.NoSuchFileException;
import java.time.Instant;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.NoHandlerFoundException;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.RegexPatternUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RestControllerAdvice
public class GlobalExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private final MessageSource messageSource;
    private final Environment environment;
    private static final MediaType PROBLEM_JSON = MediaType.APPLICATION_PROBLEM_JSON;
    private Boolean isDevelopmentMode;

    private static ProblemDetail createBaseProblemDetail(HttpStatus status, String detail, HttpServletRequest request) {
        ProblemDetail problemDetail = ProblemDetail.forStatusAndDetail((HttpStatusCode)status, (String)detail);
        problemDetail.setProperty("timestamp", (Object)Instant.now());
        problemDetail.setProperty("path", (Object)request.getRequestURI());
        return problemDetail;
    }

    private static ResponseEntity<ProblemDetail> createProblemDetailResponse(ExceptionUtils.ErrorCodeProvider ex, HttpStatus status, String typeUri, String title, HttpServletRequest request) {
        ProblemDetail problemDetail = GlobalExceptionHandler.createBaseProblemDetail((HttpStatus)status, (String)ex.getMessage(), (HttpServletRequest)request);
        problemDetail.setType(URI.create(typeUri));
        problemDetail.setTitle(title);
        problemDetail.setProperty("title", (Object)title);
        problemDetail.setProperty("errorCode", (Object)ex.getErrorCode());
        GlobalExceptionHandler.enrichWithErrorMetadata((ProblemDetail)problemDetail, (String)ex.getErrorCode());
        return ResponseEntity.status((HttpStatusCode)status).contentType(PROBLEM_JSON).body((Object)problemDetail);
    }

    private static void logException(String level, String category, HttpServletRequest request, Exception ex, String errorCode) {
        String message = errorCode != null ? String.format("%s error at %s: %s (%s)", category, request.getRequestURI(), ex.getMessage(), errorCode) : String.format("%s error at %s: %s", category, request.getRequestURI(), ex.getMessage());
        switch (level.toLowerCase()) {
            case "warn": {
                log.warn(message);
                break;
            }
            case "error": {
                log.error(message, (Throwable)ex);
                break;
            }
            default: {
                log.debug(message);
            }
        }
    }

    private static void enrichWithErrorMetadata(ProblemDetail problemDetail, String errorCode) {
        String actionRequired;
        List hints = ExceptionUtils.getHintsForErrorCode((String)errorCode);
        if (!hints.isEmpty()) {
            problemDetail.setProperty("hints", (Object)hints);
        }
        if ((actionRequired = ExceptionUtils.getActionRequiredForErrorCode((String)errorCode)) != null && !actionRequired.isBlank()) {
            problemDetail.setProperty("actionRequired", (Object)actionRequired);
        }
    }

    @ExceptionHandler(value={ExceptionUtils.PdfPasswordException.class})
    public ResponseEntity<ProblemDetail> handlePdfPassword(ExceptionUtils.PdfPasswordException ex, HttpServletRequest request) {
        GlobalExceptionHandler.logException((String)"warn", (String)"PDF password", (HttpServletRequest)request, (Exception)ex, (String)ex.getErrorCode());
        String title = this.getLocalizedMessage("error.pdfPassword.title", "PDF Password Required");
        return GlobalExceptionHandler.createProblemDetailResponse((ExceptionUtils.ErrorCodeProvider)ex, (HttpStatus)HttpStatus.BAD_REQUEST, (String)"/errors/pdf-password", (String)title, (HttpServletRequest)request);
    }

    @ExceptionHandler(value={ExceptionUtils.GhostscriptException.class})
    public ResponseEntity<ProblemDetail> handleGhostscriptException(ExceptionUtils.GhostscriptException ex, HttpServletRequest request) {
        GlobalExceptionHandler.logException((String)"warn", (String)"Ghostscript", (HttpServletRequest)request, (Exception)ex, (String)ex.getErrorCode());
        String title = this.getLocalizedMessage("error.ghostscriptCompression.title", "Ghostscript Processing Error");
        return GlobalExceptionHandler.createProblemDetailResponse((ExceptionUtils.ErrorCodeProvider)ex, (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (String)"/errors/ghostscript", (String)title, (HttpServletRequest)request);
    }

    @ExceptionHandler(value={ExceptionUtils.FfmpegRequiredException.class})
    public ResponseEntity<ProblemDetail> handleFfmpegRequired(ExceptionUtils.FfmpegRequiredException ex, HttpServletRequest request) {
        GlobalExceptionHandler.logException((String)"warn", (String)"FFmpeg unavailable", (HttpServletRequest)request, (Exception)ex, (String)ex.getErrorCode());
        String title = this.getLocalizedMessage("error.ffmpegRequired.title", "FFmpeg Required");
        return GlobalExceptionHandler.createProblemDetailResponse((ExceptionUtils.ErrorCodeProvider)ex, (HttpStatus)HttpStatus.SERVICE_UNAVAILABLE, (String)"/errors/ffmpeg-required", (String)title, (HttpServletRequest)request);
    }

    @ExceptionHandler(value={ExceptionUtils.PdfCorruptedException.class, ExceptionUtils.PdfEncryptionException.class, ExceptionUtils.OutOfMemoryDpiException.class})
    public ResponseEntity<ProblemDetail> handlePdfAndDpiExceptions(ExceptionUtils.BaseAppException ex, HttpServletRequest request) {
        String category;
        String title;
        String type;
        HttpStatus status;
        if (ex instanceof ExceptionUtils.OutOfMemoryDpiException) {
            status = HttpStatus.BAD_REQUEST;
            type = "/errors/out-of-memory-dpi";
            title = this.getLocalizedMessage("error.outOfMemoryDpi.title", "Insufficient Memory for Image Rendering");
            category = "Out of Memory DPI";
        } else if (ex instanceof ExceptionUtils.PdfCorruptedException) {
            status = HttpStatus.BAD_REQUEST;
            type = "/errors/pdf-corrupted";
            title = this.getLocalizedMessage("error.pdfCorrupted.title", "PDF File Corrupted");
            category = "PDF Corrupted";
        } else if (ex instanceof ExceptionUtils.PdfEncryptionException) {
            status = HttpStatus.BAD_REQUEST;
            type = "/errors/pdf-encryption";
            title = this.getLocalizedMessage("error.pdfEncryption.title", "PDF Encryption Error");
            category = "PDF Encryption";
        } else {
            status = HttpStatus.BAD_REQUEST;
            type = "/errors/app-error";
            title = this.getLocalizedMessage("error.application.title", "Application Error");
            category = "Application";
        }
        GlobalExceptionHandler.logException((String)"error", (String)category, (HttpServletRequest)request, (Exception)ex, (String)ex.getErrorCode());
        return GlobalExceptionHandler.createProblemDetailResponse((ExceptionUtils.ErrorCodeProvider)ex, (HttpStatus)status, (String)type, (String)title, (HttpServletRequest)request);
    }

    @ExceptionHandler(value={ExceptionUtils.CbrFormatException.class, ExceptionUtils.CbzFormatException.class, ExceptionUtils.EmlFormatException.class})
    public ResponseEntity<ProblemDetail> handleFormatExceptions(ExceptionUtils.BaseValidationException ex, HttpServletRequest request) {
        String category;
        String title;
        String type;
        if (ex instanceof ExceptionUtils.CbrFormatException) {
            type = "/errors/cbr-format";
            title = this.getLocalizedMessage("error.cbrFormat.title", "Invalid CBR File Format");
            category = "CBR format";
        } else if (ex instanceof ExceptionUtils.CbzFormatException) {
            type = "/errors/cbz-format";
            title = this.getLocalizedMessage("error.cbzFormat.title", "Invalid CBZ File Format");
            category = "CBZ format";
        } else if (ex instanceof ExceptionUtils.EmlFormatException) {
            type = "/errors/eml-format";
            title = this.getLocalizedMessage("error.emlFormat.title", "Invalid EML File Format");
            category = "EML format";
        } else {
            type = "/errors/format-error";
            title = this.getLocalizedMessage("error.formatError.title", "Invalid File Format");
            category = "Format";
        }
        GlobalExceptionHandler.logException((String)"warn", (String)category, (HttpServletRequest)request, (Exception)ex, (String)ex.getErrorCode());
        return GlobalExceptionHandler.createProblemDetailResponse((ExceptionUtils.ErrorCodeProvider)ex, (HttpStatus)HttpStatus.BAD_REQUEST, (String)type, (String)title, (HttpServletRequest)request);
    }

    @ExceptionHandler(value={ExceptionUtils.BaseValidationException.class})
    public ResponseEntity<ProblemDetail> handleValidation(ExceptionUtils.BaseValidationException ex, HttpServletRequest request) {
        GlobalExceptionHandler.logException((String)"warn", (String)"Validation", (HttpServletRequest)request, (Exception)ex, (String)ex.getErrorCode());
        String title = this.getLocalizedMessage("error.validation.title", "Validation Error");
        return GlobalExceptionHandler.createProblemDetailResponse((ExceptionUtils.ErrorCodeProvider)ex, (HttpStatus)HttpStatus.BAD_REQUEST, (String)"/errors/validation", (String)title, (HttpServletRequest)request);
    }

    @ExceptionHandler(value={ExceptionUtils.BaseAppException.class})
    public ResponseEntity<ProblemDetail> handleBaseApp(ExceptionUtils.BaseAppException ex, HttpServletRequest request) {
        GlobalExceptionHandler.logException((String)"error", (String)"Application", (HttpServletRequest)request, (Exception)ex, (String)ex.getErrorCode());
        String title = this.getLocalizedMessage("error.application.title", "Application Error");
        return GlobalExceptionHandler.createProblemDetailResponse((ExceptionUtils.ErrorCodeProvider)ex, (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (String)"/errors/application", (String)title, (HttpServletRequest)request);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ProblemDetail> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpServletRequest request) {
        log.warn("Bean validation error at {}: {} field errors", (Object)request.getRequestURI(), (Object)ex.getBindingResult().getErrorCount());
        List<String> errors = ex.getBindingResult().getFieldErrors().stream().map(error -> String.format("%s: %s", error.getField(), error.getDefaultMessage())).toList();
        String title = this.getLocalizedMessage("error.validation.title", "Request Validation Failed");
        String detail = this.getLocalizedMessage("error.validation.detail", "Validation failed");
        ProblemDetail problemDetail = GlobalExceptionHandler.createBaseProblemDetail((HttpStatus)HttpStatus.BAD_REQUEST, (String)detail, (HttpServletRequest)request);
        problemDetail.setType(URI.create("/errors/validation"));
        problemDetail.setTitle(title);
        problemDetail.setProperty("title", (Object)title);
        problemDetail.setProperty("errors", errors);
        this.addStandardHints(problemDetail, "error.validation.hints", List.of("Review the 'errors' list and correct the specified fields.", "Ensure data types and formats match the API schema.", "Resend the request after fixing validation issues."));
        problemDetail.setProperty("actionRequired", (Object)"Correct the invalid fields and resend the request.");
        return ResponseEntity.badRequest().contentType(PROBLEM_JSON).body((Object)problemDetail);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseEntity<ProblemDetail> handleMissingParameter(MissingServletRequestParameterException ex, HttpServletRequest request) {
        log.warn("Missing parameter at {}: {}", (Object)request.getRequestURI(), (Object)ex.getParameterName());
        String message = this.getLocalizedMessage("error.missingParameter.detail", String.format("Required parameter '%s' of type '%s' is missing", ex.getParameterName(), ex.getParameterType()), new Object[]{ex.getParameterName(), ex.getParameterType()});
        String title = this.getLocalizedMessage("error.missingParameter.title", "Missing Request Parameter");
        ProblemDetail problemDetail = GlobalExceptionHandler.createBaseProblemDetail((HttpStatus)HttpStatus.BAD_REQUEST, (String)message, (HttpServletRequest)request);
        problemDetail.setType(URI.create("/errors/missing-parameter"));
        problemDetail.setTitle(title);
        problemDetail.setProperty("title", (Object)title);
        problemDetail.setProperty("parameterName", (Object)ex.getParameterName());
        problemDetail.setProperty("parameterType", (Object)ex.getParameterType());
        this.addStandardHints(problemDetail, "error.missingParameter.hints", List.of("Add the missing parameter to the query string or form data.", "Verify the parameter name is spelled correctly.", "Provide a value matching the required type."));
        problemDetail.setProperty("actionRequired", (Object)String.format("Add the required '%s' parameter and retry.", ex.getParameterName()));
        return ResponseEntity.badRequest().contentType(PROBLEM_JSON).body((Object)problemDetail);
    }

    @ExceptionHandler(value={MissingServletRequestPartException.class})
    public ResponseEntity<ProblemDetail> handleMissingPart(MissingServletRequestPartException ex, HttpServletRequest request) {
        log.warn("Missing file part at {}: {}", (Object)request.getRequestURI(), (Object)ex.getRequestPartName());
        String message = this.getLocalizedMessage("error.missingFile.detail", String.format("Required file part '%s' is missing", ex.getRequestPartName()), new Object[]{ex.getRequestPartName()});
        String title = this.getLocalizedMessage("error.missingFile.title", "Missing File Upload");
        ProblemDetail problemDetail = GlobalExceptionHandler.createBaseProblemDetail((HttpStatus)HttpStatus.BAD_REQUEST, (String)message, (HttpServletRequest)request);
        problemDetail.setType(URI.create("/errors/missing-file"));
        problemDetail.setTitle(title);
        problemDetail.setProperty("title", (Object)title);
        problemDetail.setProperty("partName", (Object)ex.getRequestPartName());
        this.addStandardHints(problemDetail, "error.missingFile.hints", List.of("Attach the missing file part to the multipart/form-data request.", "Ensure the field name matches the API specification.", "Check that your client is sending multipart data correctly."));
        problemDetail.setProperty("actionRequired", (Object)String.format("Attach the '%s' file part and retry.", ex.getRequestPartName()));
        return ResponseEntity.badRequest().contentType(PROBLEM_JSON).body((Object)problemDetail);
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ResponseEntity<ProblemDetail> handleMaxUploadSize(MaxUploadSizeExceededException ex, HttpServletRequest request) {
        log.warn("File upload size exceeded at {}", (Object)request.getRequestURI());
        long maxSize = ex.getMaxUploadSize();
        String message = maxSize > 0L ? this.getLocalizedMessage("error.fileTooLarge.detail", String.format("File size exceeds maximum allowed limit of %d MB", maxSize / 0x100000L), new Object[]{maxSize / 0x100000L}) : this.getLocalizedMessage("error.fileTooLarge.detailUnknown", "File size exceeds maximum allowed limit");
        String title = this.getLocalizedMessage("error.fileTooLarge.title", "File Too Large");
        ProblemDetail problemDetail = GlobalExceptionHandler.createBaseProblemDetail((HttpStatus)HttpStatus.PAYLOAD_TOO_LARGE, (String)message, (HttpServletRequest)request);
        problemDetail.setType(URI.create("/errors/file-too-large"));
        problemDetail.setTitle(title);
        problemDetail.setProperty("title", (Object)title);
        if (maxSize > 0L) {
            problemDetail.setProperty("maxSizeBytes", (Object)maxSize);
            problemDetail.setProperty("maxSizeMB", (Object)(maxSize / 0x100000L));
        }
        this.addStandardHints(problemDetail, "error.fileTooLarge.hints", List.of("Compress or reduce the resolution of the file before uploading.", "Split the file into smaller parts if possible.", "Contact the administrator to increase the upload limit if necessary."));
        problemDetail.setProperty("actionRequired", (Object)"Reduce the file size to be within the upload limit.");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.PAYLOAD_TOO_LARGE).contentType(PROBLEM_JSON).body((Object)problemDetail);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResponseEntity<ProblemDetail> handleMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpServletRequest request) {
        log.warn("Method not supported at {}: {} not allowed", (Object)request.getRequestURI(), (Object)ex.getMethod());
        String message = this.getLocalizedMessage("error.methodNotAllowed.detail", String.format("HTTP method '%s' is not supported for this endpoint. Supported methods: %s", ex.getMethod(), String.join((CharSequence)", ", ex.getSupportedMethods())), new Object[]{ex.getMethod(), String.join((CharSequence)", ", ex.getSupportedMethods())});
        String title = this.getLocalizedMessage("error.methodNotAllowed.title", "HTTP Method Not Allowed");
        ProblemDetail problemDetail = GlobalExceptionHandler.createBaseProblemDetail((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED, (String)message, (HttpServletRequest)request);
        problemDetail.setType(URI.create("/errors/method-not-allowed"));
        problemDetail.setTitle(title);
        problemDetail.setProperty("title", (Object)title);
        problemDetail.setProperty("method", (Object)ex.getMethod());
        problemDetail.setProperty("supportedMethods", (Object)ex.getSupportedMethods());
        this.addStandardHints(problemDetail, "error.methodNotAllowed.hints", List.of("Change the HTTP method to one of the supported methods.", "Consult the API documentation for the correct method.", "If using a tool like curl or Postman, update the method accordingly."));
        problemDetail.setProperty("actionRequired", (Object)"Use one of the supported HTTP methods.");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED).contentType(PROBLEM_JSON).body((Object)problemDetail);
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public ResponseEntity<ProblemDetail> handleMediaTypeNotSupported(HttpMediaTypeNotSupportedException ex, HttpServletRequest request) {
        log.warn("Media type not supported at {}: {}", (Object)request.getRequestURI(), (Object)ex.getContentType());
        String message = this.getLocalizedMessage("error.unsupportedMediaType.detail", String.format("Media type '%s' is not supported. Supported media types: %s", ex.getContentType(), ex.getSupportedMediaTypes()), new Object[]{String.valueOf(ex.getContentType()), ex.getSupportedMediaTypes().toString()});
        String title = this.getLocalizedMessage("error.unsupportedMediaType.title", "Unsupported Media Type");
        ProblemDetail problemDetail = GlobalExceptionHandler.createBaseProblemDetail((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE, (String)message, (HttpServletRequest)request);
        problemDetail.setType(URI.create("/errors/unsupported-media-type"));
        problemDetail.setTitle(title);
        problemDetail.setProperty("title", (Object)title);
        problemDetail.setProperty("contentType", (Object)String.valueOf(ex.getContentType()));
        problemDetail.setProperty("supportedMediaTypes", (Object)ex.getSupportedMediaTypes());
        this.addStandardHints(problemDetail, "error.unsupportedMediaType.hints", List.of("Set the Content-Type header to a supported media type.", "When sending JSON, use 'application/json'.", "Check that the request body matches the declared Content-Type."));
        problemDetail.setProperty("actionRequired", (Object)"Change the Content-Type to a supported value.");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE).contentType(PROBLEM_JSON).body((Object)problemDetail);
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public void handleMediaTypeNotAcceptable(HttpMediaTypeNotAcceptableException ex, HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.warn("Media type not acceptable at {}: client accepts {}, server supports {}", new Object[]{request.getRequestURI(), request.getHeader("Accept"), ex.getSupportedMediaTypes()});
        response.setStatus(HttpStatus.NOT_ACCEPTABLE.value());
        response.setContentType("application/problem+json");
        response.setCharacterEncoding("UTF-8");
        String errorJson = String.format("{\n    \"type\": \"about:blank\",\n    \"title\": \"Not Acceptable\",\n    \"status\": 406,\n    \"detail\": \"The requested resource could not be returned in an acceptable format. Error responses are returned as JSON.\",\n    \"instance\": \"%s\",\n    \"timestamp\": \"%s\",\n    \"hints\": [\"Error responses are always returned as application/json or application/problem+json\", \"Set Accept header to include application/json for proper error handling\"]\n}\n", request.getRequestURI(), Instant.now().toString());
        response.getWriter().write(errorJson);
        response.getWriter().flush();
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<ProblemDetail> handleMessageNotReadable(HttpMessageNotReadableException ex, HttpServletRequest request) {
        log.warn("Malformed request body at {}: {}", (Object)request.getRequestURI(), (Object)ex.getMessage());
        String message = this.getLocalizedMessage("error.malformedRequest.detail", "Malformed JSON request or invalid request body format");
        Throwable cause = ex.getCause();
        if (cause != null && cause.getMessage() != null) {
            message = this.getLocalizedMessage("error.malformedRequest.detailWithCause", "Invalid request body: " + cause.getMessage(), new Object[]{cause.getMessage()});
        }
        String title = this.getLocalizedMessage("error.malformedRequest.title", "Malformed Request Body");
        ProblemDetail problemDetail = GlobalExceptionHandler.createBaseProblemDetail((HttpStatus)HttpStatus.BAD_REQUEST, (String)message, (HttpServletRequest)request);
        problemDetail.setType(URI.create("/errors/malformed-request"));
        problemDetail.setTitle(title);
        problemDetail.setProperty("title", (Object)title);
        this.addStandardHints(problemDetail, "error.malformedRequest.hints", List.of("Validate the JSON or request body format before sending.", "Ensure field names and types match the API contract.", "Remove trailing commas and ensure proper quoting in JSON."));
        problemDetail.setProperty("actionRequired", (Object)"Fix the request body format and retry.");
        return ResponseEntity.badRequest().contentType(PROBLEM_JSON).body((Object)problemDetail);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResponseEntity<ProblemDetail> handleNotFound(NoHandlerFoundException ex, HttpServletRequest request) {
        log.warn("Endpoint not found: {} {}", (Object)ex.getHttpMethod(), (Object)ex.getRequestURL());
        String message = this.getLocalizedMessage("error.notFound.detail", String.format("No endpoint found for %s %s", ex.getHttpMethod(), ex.getRequestURL()), new Object[]{ex.getHttpMethod(), ex.getRequestURL()});
        String title = this.getLocalizedMessage("error.notFound.title", "Endpoint Not Found");
        ProblemDetail problemDetail = GlobalExceptionHandler.createBaseProblemDetail((HttpStatus)HttpStatus.NOT_FOUND, (String)message, (HttpServletRequest)request);
        problemDetail.setType(URI.create("/errors/not-found"));
        problemDetail.setTitle(title);
        problemDetail.setProperty("title", (Object)title);
        problemDetail.setProperty("method", (Object)ex.getHttpMethod());
        this.addStandardHints(problemDetail, "error.notFound.hints", List.of("Verify the URL path and HTTP method are correct.", "Check the API base path and version if applicable.", "Ensure there are no typos in the endpoint path."));
        problemDetail.setProperty("actionRequired", (Object)"Use a valid endpoint URL and method.");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).contentType(PROBLEM_JSON).body((Object)problemDetail);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<ProblemDetail> handleIllegalArgument(IllegalArgumentException ex, HttpServletRequest request) {
        log.warn("Invalid argument at {}: {}", (Object)request.getRequestURI(), (Object)ex.getMessage());
        String title = this.getLocalizedMessage("error.invalidArgument.title", "Invalid Argument");
        ProblemDetail problemDetail = GlobalExceptionHandler.createBaseProblemDetail((HttpStatus)HttpStatus.BAD_REQUEST, (String)ex.getMessage(), (HttpServletRequest)request);
        problemDetail.setType(URI.create("/errors/invalid-argument"));
        problemDetail.setTitle(title);
        problemDetail.setProperty("title", (Object)title);
        this.addStandardHints(problemDetail, "error.invalidArgument.hints", List.of("Review the error message and adjust the parameter value.", "Consult the API docs for accepted ranges and formats.", "Ensure required parameters are present."));
        problemDetail.setProperty("actionRequired", (Object)"Correct the invalid argument and retry.");
        return ResponseEntity.badRequest().contentType(PROBLEM_JSON).body((Object)problemDetail);
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<ProblemDetail> handleRuntimeException(RuntimeException ex, HttpServletRequest request) {
        Throwable cause = ex.getCause();
        if (cause instanceof ExceptionUtils.BaseAppException) {
            ExceptionUtils.BaseAppException appEx = (ExceptionUtils.BaseAppException)cause;
            if (appEx instanceof ExceptionUtils.PdfPasswordException) {
                return this.handlePdfPassword((ExceptionUtils.PdfPasswordException)appEx, request);
            }
            if (appEx instanceof ExceptionUtils.PdfCorruptedException || appEx instanceof ExceptionUtils.PdfEncryptionException || appEx instanceof ExceptionUtils.OutOfMemoryDpiException) {
                return this.handlePdfAndDpiExceptions(appEx, request);
            }
            if (appEx instanceof ExceptionUtils.GhostscriptException) {
                return this.handleGhostscriptException((ExceptionUtils.GhostscriptException)appEx, request);
            }
            if (appEx instanceof ExceptionUtils.FfmpegRequiredException) {
                return this.handleFfmpegRequired((ExceptionUtils.FfmpegRequiredException)appEx, request);
            }
            return this.handleBaseApp(appEx, request);
        }
        if (cause instanceof ExceptionUtils.BaseValidationException) {
            ExceptionUtils.BaseValidationException valEx = (ExceptionUtils.BaseValidationException)cause;
            if (valEx instanceof ExceptionUtils.CbrFormatException || valEx instanceof ExceptionUtils.CbzFormatException || valEx instanceof ExceptionUtils.EmlFormatException) {
                return this.handleFormatExceptions(valEx, request);
            }
            return this.handleValidation(valEx, request);
        }
        if (cause instanceof IOException) {
            return this.handleIOException((IOException)cause, request);
        }
        if (cause instanceof IllegalArgumentException) {
            return this.handleIllegalArgument((IllegalArgumentException)cause, request);
        }
        log.error("Unexpected RuntimeException at {}: {}", new Object[]{request.getRequestURI(), ex.getMessage(), ex});
        String userMessage = this.getLocalizedMessage("error.unexpected", "An unexpected error occurred. Please try again later.");
        String title = this.getLocalizedMessage("error.unexpected.title", "Internal Server Error");
        ProblemDetail problemDetail = GlobalExceptionHandler.createBaseProblemDetail((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (String)userMessage, (HttpServletRequest)request);
        problemDetail.setType(URI.create("/errors/unexpected"));
        problemDetail.setTitle(title);
        problemDetail.setProperty("title", (Object)title);
        this.addStandardHints(problemDetail, "error.unexpected.hints", List.of("Retry the request after a short delay.", "If the problem persists, contact support with the timestamp and path.", "Check service status or logs for outages."));
        problemDetail.setProperty("actionRequired", (Object)"Retry later; if persistent, contact support with the error details.");
        if (this.isDevelopmentMode()) {
            problemDetail.setProperty("debugMessage", (Object)ex.getMessage());
            problemDetail.setProperty("exceptionType", (Object)ex.getClass().getName());
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(PROBLEM_JSON).body((Object)problemDetail);
    }

    @ExceptionHandler(value={IOException.class})
    public ResponseEntity<ProblemDetail> handleIOException(IOException ex, HttpServletRequest request) {
        IOException processedException = ExceptionUtils.handlePdfException((IOException)ex, (String)request.getRequestURI());
        if (processedException instanceof ExceptionUtils.BaseAppException) {
            return this.handleBaseApp((ExceptionUtils.BaseAppException)processedException, request);
        }
        if (ex instanceof NoSuchFileException) {
            log.error("Temporary file not found at {}: {}", new Object[]{request.getRequestURI(), ex.getMessage(), ex});
            String message = this.getLocalizedMessage("error.tempFileNotFound.detail", "The temporary file was not found. This may indicate a processing error or cleanup issue. Please try again.");
            String title = this.getLocalizedMessage("error.tempFileNotFound.title", "Temporary File Not Found");
            ProblemDetail problemDetail = GlobalExceptionHandler.createBaseProblemDetail((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (String)message, (HttpServletRequest)request);
            problemDetail.setType(URI.create("https://stirlingpdf.com/errors/temp-file-not-found"));
            problemDetail.setTitle(title);
            problemDetail.setProperty("title", (Object)title);
            problemDetail.setProperty("errorCode", (Object)"E999");
            problemDetail.setProperty("hint.1", (Object)"This error usually occurs when temporary files are cleaned up before processing completes.");
            problemDetail.setProperty("hint.2", (Object)"Try submitting your request again.");
            return new ResponseEntity((Object)problemDetail, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        log.error("IO error at {}: {}", new Object[]{request.getRequestURI(), ex.getMessage(), ex});
        String message = this.getLocalizedMessage("error.ioError.detail", "An error occurred while processing the file");
        if (ex.getMessage() != null && !ex.getMessage().isBlank()) {
            message = ex.getMessage();
        }
        String title = this.getLocalizedMessage("error.ioError.title", "File Processing Error");
        ProblemDetail problemDetail = GlobalExceptionHandler.createBaseProblemDetail((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (String)message, (HttpServletRequest)request);
        problemDetail.setType(URI.create("/errors/io-error"));
        problemDetail.setTitle(title);
        problemDetail.setProperty("title", (Object)title);
        this.addStandardHints(problemDetail, "error.ioError.hints", List.of("Confirm the file exists and is accessible.", "Ensure the file is not corrupted and is of a supported type.", "Retry the operation in case of transient I/O issues."));
        problemDetail.setProperty("actionRequired", (Object)"Verify the file and try the request again.");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(PROBLEM_JSON).body((Object)problemDetail);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ProblemDetail> handleGenericException(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        log.error("Unexpected error at {}: {}", new Object[]{request.getRequestURI(), ex.getMessage(), ex});
        if (response.isCommitted()) {
            log.warn("Cannot send error response because response is already committed for URI: {}", (Object)request.getRequestURI());
            return null;
        }
        String userMessage = this.getLocalizedMessage("error.unexpected", "An unexpected error occurred. Please try again later.");
        String title = this.getLocalizedMessage("error.unexpected.title", "Internal Server Error");
        ProblemDetail problemDetail = GlobalExceptionHandler.createBaseProblemDetail((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (String)userMessage, (HttpServletRequest)request);
        problemDetail.setType(URI.create("/errors/unexpected"));
        problemDetail.setTitle(title);
        problemDetail.setProperty("title", (Object)title);
        this.addStandardHints(problemDetail, "error.unexpected.hints", List.of("Retry the request after a short delay.", "If the problem persists, contact support with the timestamp and path.", "Check service status or logs for outages."));
        problemDetail.setProperty("actionRequired", (Object)"Retry later; if persistent, contact support with the error details.");
        if (this.isDevelopmentMode()) {
            problemDetail.setProperty("debugMessage", (Object)ex.getMessage());
            problemDetail.setProperty("exceptionType", (Object)ex.getClass().getName());
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(PROBLEM_JSON).body((Object)problemDetail);
    }

    private String getLocalizedMessage(String key, String defaultMessage) {
        return this.messageSource.getMessage(key, null, defaultMessage, LocaleContextHolder.getLocale());
    }

    private String getLocalizedMessage(String key, String defaultMessage, Object ... args) {
        return this.messageSource.getMessage(key, args, defaultMessage, LocaleContextHolder.getLocale());
    }

    private boolean isDevelopmentMode() {
        if (this.isDevelopmentMode == null) {
            String[] activeProfiles = this.environment.getActiveProfiles();
            this.isDevelopmentMode = false;
            for (String profile : activeProfiles) {
                if (!"dev".equalsIgnoreCase(profile) && !"development".equalsIgnoreCase(profile)) continue;
                this.isDevelopmentMode = true;
                break;
            }
        }
        return this.isDevelopmentMode;
    }

    private void addStandardHints(ProblemDetail problemDetail, String hintKey, List<String> defaultHints) {
        String localizedHints = this.getLocalizedMessage(hintKey, null);
        if (localizedHints != null) {
            problemDetail.setProperty("hints", List.of(RegexPatternUtils.getInstance().getPipeDelimiterPattern().split(localizedHints)));
        } else {
            problemDetail.setProperty("hints", defaultHints);
        }
    }

    @Generated
    public GlobalExceptionHandler(MessageSource messageSource, Environment environment) {
        this.messageSource = messageSource;
        this.environment = environment;
    }
}

