/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.web;

import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import stirling.software.SPDF.service.SharedSignatureService;
import stirling.software.common.service.PersonalSignatureServiceInterface;
import stirling.software.common.service.UserServiceInterface;

@RestController
@RequestMapping(value={"/api/v1/general"})
public class SignatureImageController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SignatureImageController.class);
    private final SharedSignatureService sharedSignatureService;
    private final PersonalSignatureServiceInterface personalSignatureService;
    private final UserServiceInterface userService;

    public SignatureImageController(SharedSignatureService sharedSignatureService, @Autowired(required=false) PersonalSignatureServiceInterface personalSignatureService, @Autowired(required=false) UserServiceInterface userService) {
        this.sharedSignatureService = sharedSignatureService;
        this.personalSignatureService = personalSignatureService;
        this.userService = userService;
    }

    @GetMapping(value={"/signatures/{fileName}"})
    public ResponseEntity<byte[]> getSignature(@PathVariable(name="fileName") String fileName) {
        try {
            byte[] imageBytes = null;
            if (this.personalSignatureService != null && this.userService != null) {
                try {
                    String username = this.userService.getCurrentUsername();
                    imageBytes = this.personalSignatureService.getPersonalSignatureBytes(username, fileName);
                }
                catch (Exception e) {
                    log.debug("Personal signature not found, trying shared: {}", (Object)e.getMessage());
                }
            }
            if (imageBytes == null) {
                imageBytes = this.sharedSignatureService.getSharedSignatureBytes(fileName);
            }
            MediaType contentType = MediaType.IMAGE_PNG;
            String lowerFileName = fileName.toLowerCase();
            if (lowerFileName.endsWith(".jpg") || lowerFileName.endsWith(".jpeg")) {
                contentType = MediaType.IMAGE_JPEG;
            }
            return ResponseEntity.ok().contentType(contentType).body((Object)imageBytes);
        }
        catch (IOException e) {
            log.debug("Signature not found: {}", (Object)fileName);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
        }
    }
}

