/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.web;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.JavaScriptUtils;
import stirling.software.common.configuration.InstallationPathConfig;

@Controller
public class ReactRoutingController {
    private static final Logger log = LoggerFactory.getLogger(ReactRoutingController.class);
    @Value(value="${server.servlet.context-path:/}")
    private String contextPath;
    private String cachedIndexHtml;
    private String cachedCallbackHtml;
    private boolean indexHtmlExists = false;
    private boolean useExternalIndexHtml = false;
    private boolean loggedMissingIndex = false;

    @PostConstruct
    public void init() {
        log.info("Static files custom path: {}", (Object)InstallationPathConfig.getStaticPath());
        this.cachedCallbackHtml = this.buildCallbackHtml();
        Path externalIndexPath = Paths.get(InstallationPathConfig.getStaticPath(), "index.html");
        log.debug("Checking for custom index.html at: {}", (Object)externalIndexPath);
        if (Files.exists(externalIndexPath, new LinkOption[0]) && Files.isReadable(externalIndexPath)) {
            log.info("Using custom index.html from: {}", (Object)externalIndexPath);
            this.cachedIndexHtml = this.processIndexHtml();
            this.indexHtmlExists = true;
            this.useExternalIndexHtml = true;
            return;
        }
        ClassPathResource resource = new ClassPathResource("static/index.html");
        if (resource.exists()) {
            this.cachedIndexHtml = this.processIndexHtml();
            this.indexHtmlExists = true;
            this.useExternalIndexHtml = false;
            return;
        }
        this.cachedIndexHtml = this.buildFallbackHtml();
        this.indexHtmlExists = true;
        this.useExternalIndexHtml = false;
        this.loggedMissingIndex = true;
        log.warn("index.html not found in classpath or custom path; using lightweight fallback page");
    }

    private String processIndexHtml() {
        String string;
        block11: {
            Resource resource = this.getIndexHtmlResource();
            if (!resource.exists()) {
                if (!this.loggedMissingIndex) {
                    log.warn("index.html not found, using lightweight fallback page");
                    this.loggedMissingIndex = true;
                }
                return this.buildFallbackHtml();
            }
            InputStream inputStream = resource.getInputStream();
            try {
                String html = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                Object baseUrl = this.contextPath.endsWith("/") ? this.contextPath : this.contextPath + "/";
                html = html.replace("%BASE_URL%", (CharSequence)baseUrl);
                html = html.replaceFirst("<base href=\\\"[^\\\"]*\\\"\\s*/?>", "<base href=\\\"" + (String)baseUrl + "\\\" />");
                String contextPathScript = "<script>window.STIRLING_PDF_API_BASE_URL = '" + (String)baseUrl + "';</script>";
                string = html = html.replace("</head>", contextPathScript + "</head>");
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    if (!this.loggedMissingIndex) {
                        log.warn("index.html not found, using lightweight fallback page", (Throwable)ex);
                        this.loggedMissingIndex = true;
                    }
                    return this.buildFallbackHtml();
                }
            }
            inputStream.close();
        }
        return string;
    }

    private Resource getIndexHtmlResource() {
        Path externalIndexPath = Paths.get(InstallationPathConfig.getStaticPath(), "index.html");
        if (Files.exists(externalIndexPath, new LinkOption[0]) && Files.isReadable(externalIndexPath)) {
            return new FileSystemResource(externalIndexPath.toFile());
        }
        return new ClassPathResource("static/index.html");
    }

    @GetMapping(value={"/", "/index.html"}, produces={"text/html"})
    public ResponseEntity<String> serveIndexHtml(HttpServletRequest request) {
        try {
            if (this.indexHtmlExists && this.cachedIndexHtml != null) {
                return ResponseEntity.ok().contentType(MediaType.TEXT_HTML).body((Object)this.cachedIndexHtml);
            }
            return ResponseEntity.ok().contentType(MediaType.TEXT_HTML).body((Object)this.processIndexHtml());
        }
        catch (Exception ex) {
            log.error("Failed to serve index.html, returning fallback", (Throwable)ex);
            return ResponseEntity.ok().contentType(MediaType.TEXT_HTML).body((Object)this.buildFallbackHtml());
        }
    }

    @GetMapping(value={"/auth/callback"}, produces={"text/html"})
    public ResponseEntity<String> serveAuthCallback(HttpServletRequest request) {
        return this.serveIndexHtml(request);
    }

    @GetMapping(value={"/auth/callback/tauri"}, produces={"text/html"})
    public ResponseEntity<String> serveTauriAuthCallback(HttpServletRequest request) {
        return ResponseEntity.ok().contentType(MediaType.TEXT_HTML).body((Object)this.cachedCallbackHtml);
    }

    @GetMapping(value={"/{path:^(?!api|static|robots\\.txt|favicon\\.ico|manifest.*\\.json|pipeline|pdfjs|pdfjs-legacy|pdfium|vendor|fonts|images|files|css|js|assets|locales|modern-logo|classic-logo|Login|og_images|samples)[^\\.]*$}"})
    public ResponseEntity<String> forwardRootPaths(HttpServletRequest request) throws IOException {
        return this.serveIndexHtml(request);
    }

    @GetMapping(value={"/{path:^(?!api|static|pipeline|pdfjs|pdfjs-legacy|pdfium|vendor|fonts|images|files|css|js|assets|locales|modern-logo|classic-logo|Login|og_images|samples)[^\\.]*}/{subpath:^(?!.*\\.).*$}"})
    public ResponseEntity<String> forwardNestedPaths(HttpServletRequest request) throws IOException {
        return this.serveIndexHtml(request);
    }

    private String buildFallbackHtml() {
        Object baseUrl = this.contextPath.endsWith("/") ? this.contextPath : this.contextPath + "/";
        String escapedBaseUrlHtml = HtmlUtils.htmlEscape((String)baseUrl);
        String escapedBaseUrlJs = JavaScriptUtils.javaScriptEscape((String)baseUrl);
        String serverUrl = "(window.location.origin + '" + escapedBaseUrlJs + "')";
        return "<!doctype html>\n<html>\n  <head>\n    <meta charset=\"utf-8\" />\n    <base href=\"%s\" />\n    <title>Stirling PDF</title>\n    <script>\n      // Minimal handler for SSO callback when index.html is missing (desktop fallback)\n      (function() {\n        const baseUrl = '%s';\n        window.STIRLING_PDF_API_BASE_URL = baseUrl;\n        const hashParams = new URLSearchParams(window.location.hash.replace(/^#/, ''));\n        const searchParams = new URLSearchParams(window.location.search);\n        const token = hashParams.get('access_token') || hashParams.get('token') || searchParams.get('access_token');\n        const serverUrl = %s;\n\n        if (token) {\n          // Extract nonce from URL to send back to desktop app for validation\n          const nonceFromUrl = hashParams.get('nonce') || searchParams.get('nonce');\n\n          console.log('[Fallback Auth] Token received, sending to desktop app via deep link');\n\n          // Send token + nonce via deep link to desktop app\n          // Desktop app will validate nonce before accepting token\n          try {\n            const encodedToken = encodeURIComponent(token);\n            const encodedServer = encodeURIComponent(serverUrl);\n            const encodedNonce = nonceFromUrl ? encodeURIComponent(nonceFromUrl) : '';\n            const deepLink = `stirlingpdf://auth/sso-complete?server=${encodedServer}#access_token=${encodedToken}&nonce=${encodedNonce}&type=sso-selfhosted`;\n            window.location.href = deepLink;\n            return;\n          } catch (_) {\n            // ignore deep link errors\n          }\n        }\n\n        // No redirect to avoid loops when index.html is missing\n      })();\n    </script>\n  </head>\n  <body>\n    <p>Stirling PDF is running.</p>\n  </body>\n</html>\n".formatted(escapedBaseUrlHtml, escapedBaseUrlJs, serverUrl);
    }

    private String buildCallbackHtml() {
        Object baseUrl = this.contextPath.endsWith("/") ? this.contextPath : this.contextPath + "/";
        String escapedBaseUrlHtml = HtmlUtils.htmlEscape((String)baseUrl);
        String escapedBaseUrlJs = JavaScriptUtils.javaScriptEscape((String)baseUrl);
        String serverUrl = "(window.location.origin + '" + escapedBaseUrlJs + "')";
        return "<!doctype html>\n<html>\n  <head>\n    <meta charset=\"utf-8\" />\n    <base href=\"%s\" />\n    <title>Authentication Complete</title>\n    <style>\n      * {\n        margin: 0;\n        padding: 0;\n        box-sizing: border-box;\n      }\n\n      body {\n        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;\n        text-align: center;\n        padding: 50px 20px;\n        background: #f5f5f5;\n        min-height: 100vh;\n        display: flex;\n        align-items: center;\n        justify-content: center;\n      }\n\n      .container {\n        background: #ffffff;\n        border-radius: 12px;\n        padding: 40px;\n        max-width: 420px;\n        width: 100%%;\n        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);\n        border: 1px solid #e5e7eb;\n        color: #1a1a1a;\n      }\n\n      .icon {\n        font-size: 48px;\n        margin-bottom: 16px;\n        color: #2e7d32;\n      }\n\n      .icon.error {\n        color: #d32f2f;\n      }\n\n      h1 {\n        font-size: 24px;\n        font-weight: 600;\n        margin-bottom: 12px;\n        color: #1a1a1a;\n      }\n\n      p {\n        color: #666;\n        line-height: 1.6;\n        font-size: 15px;\n      }\n\n      .error-details {\n        background: #ffebee;\n        border: 1px solid #ffcdd2;\n        padding: 16px;\n        border-radius: 8px;\n        margin-top: 20px;\n        font-size: 14px;\n        color: #c62828;\n        word-break: break-word;\n        text-align: left;\n        line-height: 1.5;\n        display: none;\n      }\n\n      @media (prefers-color-scheme: dark) {\n        body {\n          background: #1a1a1a;\n          color: #e0e0e0;\n        }\n\n        .container {\n          background: #2d2d2d;\n          box-shadow: 0 2px 8px rgba(0, 0, 0, 0.3);\n          border-color: #374151;\n          color: #e5e7eb;\n        }\n\n        .icon {\n          color: #66bb6a;\n        }\n\n        .icon.error {\n          color: #ef5350;\n        }\n\n        h1 {\n          color: #f5f5f5;\n        }\n\n        p {\n          color: #b0b0b0;\n        }\n\n        .error-details {\n          background: #3d2020;\n          border: 1px solid #5d3030;\n          color: #ef9a9a;\n        }\n      }\n\n      @media (max-width: 480px) {\n        body {\n          padding: 20px 16px;\n        }\n\n        .container {\n          padding: 32px 24px;\n        }\n\n        h1 {\n          font-size: 20px;\n        }\n\n        .icon {\n          font-size: 40px;\n        }\n      }\n    </style>\n    <script>\n      (function() {\n        const run = () => {\n          const hashParams = new URLSearchParams(window.location.hash.replace(/^#/, ''));\n          const searchParams = new URLSearchParams(window.location.search);\n          const token = hashParams.get('access_token') || hashParams.get('token') || searchParams.get('access_token');\n          const errorCode = searchParams.get('errorOAuth')\n            || searchParams.get('error')\n            || hashParams.get('error')\n            || searchParams.get('error_description')\n            || hashParams.get('error_description');\n          const serverUrl = %s;\n          const iconEl = document.getElementById('auth-icon');\n          const titleEl = document.getElementById('auth-title');\n          const messageEl = document.getElementById('auth-message');\n          const detailsEl = document.getElementById('auth-error-details');\n\n          const sendDeepLink = (type, value, key) => {\n            try {\n              const encodedValue = encodeURIComponent(value || '');\n              const encodedServer = encodeURIComponent(serverUrl);\n              const hashKey = key || 'access_token';\n              const deepLink = `stirlingpdf://auth/sso-complete?server=${encodedServer}#${hashKey}=${encodedValue}&type=${type}`;\n              window.location.href = deepLink;\n            } catch (_) {\n              // ignore deep link errors\n            }\n          };\n\n          const showError = (message, details) => {\n            if (iconEl) {\n              iconEl.textContent = '\u2717';\n              iconEl.classList.add('error');\n            }\n            if (titleEl) {\n              titleEl.textContent = 'Authentication failed';\n            }\n            if (messageEl) {\n              messageEl.textContent = message;\n            }\n            if (detailsEl && details) {\n              detailsEl.textContent = details;\n              detailsEl.style.display = 'block';\n            }\n          };\n\n          if (token) {\n            // Extract nonce from URL to send back to desktop app for validation\n            // (System browser doesn't have access to desktop app's sessionStorage)\n            const nonceFromUrl = hashParams.get('nonce') || searchParams.get('nonce');\n\n            console.log('[Auth Callback] Token received, sending to desktop app via deep link');\n\n            // Send token + nonce via deep link to desktop app\n            // Desktop app will validate nonce before accepting token\n            setTimeout(() => {\n              try {\n                const encodedToken = encodeURIComponent(token);\n                const encodedServer = encodeURIComponent(serverUrl);\n                const encodedNonce = nonceFromUrl ? encodeURIComponent(nonceFromUrl) : '';\n                const deepLink = `stirlingpdf://auth/sso-complete?server=${encodedServer}#access_token=${encodedToken}&nonce=${encodedNonce}&type=sso-selfhosted`;\n                window.location.href = deepLink;\n              } catch (err) {\n                console.error('[Auth Callback] Failed to trigger deep link:', err);\n              }\n            }, 200);\n\n            return;\n          }\n\n          if (errorCode) {\n            const isCancelled = errorCode === 'access_denied';\n            sendDeepLink('sso-error', errorCode, 'error');\n            showError(\n              isCancelled\n                ? 'Authentication was cancelled. You can close this window and return to the app.'\n                : 'Authentication was not successful. You can close this window and return to the app.',\n              errorCode\n            );\n            return;\n          }\n\n          showError(\n            'Authentication did not complete. You can close this window and try again.',\n            'missing_token'\n          );\n        };\n\n        if (document.readyState === 'loading') {\n          document.addEventListener('DOMContentLoaded', run);\n        } else {\n          run();\n        }\n      })();\n    </script>\n  </head>\n  <body>\n    <div class=\"container\">\n      <div class=\"icon\" id=\"auth-icon\">&#10003;</div>\n      <h1 id=\"auth-title\">Authentication complete</h1>\n      <p id=\"auth-message\">You can close this window and return to Stirling PDF.</p>\n      <div class=\"error-details\" id=\"auth-error-details\"></div>\n    </div>\n  </body>\n</html>\n".formatted(escapedBaseUrlHtml, serverUrl);
    }
}

