/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.web;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import stirling.software.SPDF.config.EndpointInspector;
import stirling.software.SPDF.config.StartupApplicationListener;
import stirling.software.SPDF.controller.web.MetricsController;
import stirling.software.SPDF.service.WeeklyActiveUsersService;
import stirling.software.common.annotations.api.InfoApi;
import stirling.software.common.model.ApplicationProperties;

@InfoApi
public class MetricsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsController.class);
    private final ApplicationProperties applicationProperties;
    private final MeterRegistry meterRegistry;
    private final EndpointInspector endpointInspector;
    private final Optional<WeeklyActiveUsersService> wauService;
    private boolean metricsEnabled;

    @PostConstruct
    public void init() {
        this.metricsEnabled = this.applicationProperties.getMetrics().isEnabled();
    }

    @GetMapping(value={"/status"})
    @Operation(summary="Application status and version", description="This endpoint returns the status of the application and its version number.")
    public ResponseEntity<?> getStatus() {
        if (!this.metricsEnabled) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"This endpoint is disabled.");
        }
        HashMap<String, String> status = new HashMap<String, String>();
        status.put("status", "UP");
        status.put("version", this.getClass().getPackage().getImplementationVersion());
        return ResponseEntity.ok(status);
    }

    @GetMapping(value={"/load"})
    @Operation(summary="GET request count", description="This endpoint returns the total count of GET requests for a specific endpoint or all endpoints.")
    public ResponseEntity<?> getPageLoads(@RequestParam(required=false, name="endpoint") @Parameter(description="endpoint") Optional<String> endpoint) {
        if (!this.metricsEnabled) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"This endpoint is disabled.");
        }
        try {
            double count = this.getRequestCount("GET", endpoint);
            return ResponseEntity.ok((Object)count);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/load/unique"})
    @Operation(summary="Unique users count for GET requests", description="This endpoint returns the count of unique users for GET requests for a specific endpoint or all endpoints.")
    public ResponseEntity<?> getUniquePageLoads(@RequestParam(required=false, name="endpoint") @Parameter(description="endpoint") Optional<String> endpoint) {
        if (!this.metricsEnabled) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"This endpoint is disabled.");
        }
        try {
            double count = this.getUniqueUserCount("GET", endpoint);
            return ResponseEntity.ok((Object)count);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/load/all"})
    @Operation(summary="GET requests count for all endpoints", description="This endpoint returns the count of GET requests for each endpoint.")
    public ResponseEntity<?> getAllEndpointLoads() {
        if (!this.metricsEnabled) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"This endpoint is disabled.");
        }
        try {
            List results = this.getEndpointCounts("GET");
            return ResponseEntity.ok((Object)results);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/load/all/unique"})
    @Operation(summary="Unique users count for GET requests for all endpoints", description="This endpoint returns the count of unique users for GET requests for each endpoint.")
    public ResponseEntity<?> getAllUniqueEndpointLoads() {
        if (!this.metricsEnabled) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"This endpoint is disabled.");
        }
        try {
            List results = this.getUniqueUserCounts("GET");
            return ResponseEntity.ok((Object)results);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/requests"})
    @Operation(summary="POST request count", description="This endpoint returns the total count of POST requests for a specific endpoint or all endpoints.")
    public ResponseEntity<?> getTotalRequests(@RequestParam(required=false, name="endpoint") @Parameter(description="endpoint") Optional<String> endpoint) {
        if (!this.metricsEnabled) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"This endpoint is disabled.");
        }
        try {
            double count = this.getRequestCount("POST", endpoint);
            return ResponseEntity.ok((Object)count);
        }
        catch (Exception e) {
            return ResponseEntity.ok((Object)-1);
        }
    }

    @GetMapping(value={"/requests/unique"})
    @Operation(summary="Unique users count for POST requests", description="This endpoint returns the count of unique users for POST requests for a specific endpoint or all endpoints.")
    public ResponseEntity<?> getUniqueTotalRequests(@RequestParam(required=false, name="endpoint") @Parameter(description="endpoint") Optional<String> endpoint) {
        if (!this.metricsEnabled) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"This endpoint is disabled.");
        }
        try {
            double count = this.getUniqueUserCount("POST", endpoint);
            return ResponseEntity.ok((Object)count);
        }
        catch (Exception e) {
            return ResponseEntity.ok((Object)-1);
        }
    }

    @GetMapping(value={"/requests/all"})
    @Operation(summary="POST requests count for all endpoints", description="This endpoint returns the count of POST requests for each endpoint.")
    public ResponseEntity<?> getAllPostRequests() {
        if (!this.metricsEnabled) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"This endpoint is disabled.");
        }
        try {
            List results = this.getEndpointCounts("POST");
            return ResponseEntity.ok((Object)results);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/requests/all/unique"})
    @Operation(summary="Unique users count for POST requests for all endpoints", description="This endpoint returns the count of unique users for POST requests for each endpoint.")
    public ResponseEntity<?> getAllUniquePostRequests() {
        if (!this.metricsEnabled) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"This endpoint is disabled.");
        }
        try {
            List results = this.getUniqueUserCounts("POST");
            return ResponseEntity.ok((Object)results);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private double getRequestCount(String method, Optional<String> endpoint) {
        return this.meterRegistry.find("http.requests").tag("method", method).counters().stream().filter(counter -> {
            boolean validateGetEndpoints;
            String uri = counter.getId().getTag("uri");
            if (uri == null) {
                return false;
            }
            if ("POST".equals(method) && !uri.contains("api/v1")) {
                return false;
            }
            if (uri.contains(".txt")) {
                return false;
            }
            boolean bl = validateGetEndpoints = this.endpointInspector.getValidGetEndpoints().size() != 0;
            if ("GET".equals(method) && validateGetEndpoints && !this.endpointInspector.isValidGetEndpoint(uri)) {
                log.debug("Skipping invalid GET endpoint: {}", (Object)uri);
                return false;
            }
            return !endpoint.isPresent() || ((String)endpoint.get()).equals(uri);
        }).mapToDouble(Counter::count).sum();
    }

    private List<EndpointCount> getEndpointCounts(String method) {
        HashMap counts = new HashMap();
        this.meterRegistry.find("http.requests").tag("method", method).counters().forEach(counter -> {
            boolean validateGetEndpoints;
            String uri = counter.getId().getTag("uri");
            if (uri == null) {
                return;
            }
            if ("POST".equals(method) && !uri.contains("api/v1")) {
                return;
            }
            if (uri.contains(".txt")) {
                return;
            }
            boolean bl = validateGetEndpoints = this.endpointInspector.getValidGetEndpoints().size() != 0;
            if ("GET".equals(method) && validateGetEndpoints && !this.endpointInspector.isValidGetEndpoint(uri)) {
                log.debug("Skipping invalid GET endpoint: {}", (Object)uri);
                return;
            }
            counts.merge(uri, counter.count(), Double::sum);
        });
        return counts.entrySet().stream().map(entry -> new EndpointCount((String)entry.getKey(), ((Double)entry.getValue()).doubleValue())).sorted(Comparator.comparing(EndpointCount::getCount).reversed()).toList();
    }

    private double getUniqueUserCount(String method, Optional<String> endpoint) {
        HashSet uniqueUsers = new HashSet();
        this.meterRegistry.find("http.requests").tag("method", method).counters().stream().filter(counter -> {
            boolean validateGetEndpoints;
            String uri = counter.getId().getTag("uri");
            if (uri == null) {
                return false;
            }
            if ("POST".equals(method) && !uri.contains("api/v1")) {
                return false;
            }
            if (uri.contains(".txt")) {
                return false;
            }
            boolean bl = validateGetEndpoints = this.endpointInspector.getValidGetEndpoints().size() != 0;
            if ("GET".equals(method) && validateGetEndpoints && !this.endpointInspector.isValidGetEndpoint(uri)) {
                log.debug("Skipping invalid GET endpoint: {}", (Object)uri);
                return false;
            }
            return !endpoint.isPresent() || ((String)endpoint.get()).equals(uri);
        }).forEach(counter -> {
            String session = counter.getId().getTag("session");
            if (session != null) {
                uniqueUsers.add(session);
            }
        });
        return uniqueUsers.size();
    }

    private List<EndpointCount> getUniqueUserCounts(String method) {
        HashMap uniqueUsers = new HashMap();
        this.meterRegistry.find("http.requests").tag("method", method).counters().forEach(counter -> {
            String uri = counter.getId().getTag("uri");
            String session = counter.getId().getTag("session");
            if (uri != null && session != null) {
                uniqueUsers.computeIfAbsent(uri, k -> new HashSet()).add(session);
            }
        });
        return uniqueUsers.entrySet().stream().map(entry -> new EndpointCount((String)entry.getKey(), (double)((Set)entry.getValue()).size())).sorted(Comparator.comparing(EndpointCount::getCount).reversed()).toList();
    }

    @GetMapping(value={"/uptime"})
    public ResponseEntity<?> getUptime() {
        if (!this.metricsEnabled) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"This endpoint is disabled.");
        }
        LocalDateTime now = LocalDateTime.now();
        Duration uptime = Duration.between(StartupApplicationListener.startTime, now);
        return ResponseEntity.ok((Object)this.formatDuration(uptime));
    }

    @GetMapping(value={"/wau"})
    @Operation(summary="Weekly Active Users statistics", description="Returns WAU (Weekly Active Users) count and total unique browsers. Only available when security is disabled (no-login mode). Tracks unique browsers via client-generated UUID in localStorage.")
    public ResponseEntity<?> getWeeklyActiveUsers() {
        if (!this.metricsEnabled) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"This endpoint is disabled.");
        }
        if (this.wauService.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"WAU tracking is only available when security is disabled (no-login mode)");
        }
        WeeklyActiveUsersService service = (WeeklyActiveUsersService)this.wauService.get();
        HashMap<String, Object> wauStats = new HashMap<String, Object>();
        wauStats.put("weeklyActiveUsers", service.getWeeklyActiveUsers());
        wauStats.put("totalUniqueBrowsers", service.getTotalUniqueBrowsers());
        wauStats.put("daysOnline", service.getDaysOnline());
        wauStats.put("trackingSince", service.getStartTime().toString());
        return ResponseEntity.ok(wauStats);
    }

    private String formatDuration(Duration duration) {
        long days = duration.toDays();
        long hours = duration.toHoursPart();
        long minutes = duration.toMinutesPart();
        long seconds = duration.toSecondsPart();
        return String.format(Locale.ROOT, "%dd %dh %dm %ds", days, hours, minutes, seconds);
    }

    @Generated
    public MetricsController(ApplicationProperties applicationProperties, MeterRegistry meterRegistry, EndpointInspector endpointInspector, Optional<WeeklyActiveUsersService> wauService) {
        this.applicationProperties = applicationProperties;
        this.meterRegistry = meterRegistry;
        this.endpointInspector = endpointInspector;
        this.wauService = wauService;
    }
}

