/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.security;

import io.swagger.v3.oas.annotations.Operation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionLaunch;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.action.PDDocumentCatalogAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.action.PDPageAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.security.SanitizePdfRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.SecurityApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@SecurityApi
public class SanitizeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SanitizeController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/sanitize-pdf"})
    @StandardPdfResponse
    @Operation(summary="Sanitize a PDF file", description="This endpoint processes a PDF file and removes specific elements based on the provided options. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> sanitizePDF(@ModelAttribute SanitizePdfRequest request) throws IOException {
        MultipartFile inputFile = request.getFileInput();
        boolean removeJavaScript = Boolean.TRUE.equals(request.getRemoveJavaScript());
        boolean removeEmbeddedFiles = Boolean.TRUE.equals(request.getRemoveEmbeddedFiles());
        boolean removeXMPMetadata = Boolean.TRUE.equals(request.getRemoveXMPMetadata());
        boolean removeMetadata = Boolean.TRUE.equals(request.getRemoveMetadata());
        boolean removeLinks = Boolean.TRUE.equals(request.getRemoveLinks());
        boolean removeFonts = Boolean.TRUE.equals(request.getRemoveFonts());
        try (PDDocument document = this.pdfDocumentFactory.load(inputFile, true);){
            if (removeJavaScript) {
                SanitizeController.sanitizeJavaScript((PDDocument)document);
            }
            if (removeEmbeddedFiles) {
                SanitizeController.sanitizeEmbeddedFiles((PDDocument)document);
            }
            if (removeXMPMetadata) {
                SanitizeController.sanitizeXMPMetadata((PDDocument)document);
            }
            if (removeMetadata) {
                SanitizeController.sanitizeDocumentInfoMetadata((PDDocument)document);
            }
            if (removeLinks) {
                SanitizeController.sanitizeLinks((PDDocument)document);
            }
            if (removeFonts) {
                SanitizeController.sanitizeFonts((PDDocument)document);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            document.save((OutputStream)outputStream);
            ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])outputStream.toByteArray(), (String)GeneralUtils.generateFilename((String)inputFile.getOriginalFilename(), (String)"_sanitized.pdf"));
            return responseEntity;
        }
    }

    private static void sanitizeJavaScript(PDDocument document) throws IOException {
        PDAcroForm acroForm;
        PDDocumentCatalogAdditionalActions catalogActions;
        COSDictionary javaScriptDict;
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        COSDictionary namesDict = (COSDictionary)catalog.getCOSObject().getDictionaryObject(COSName.NAMES);
        if (namesDict != null && (javaScriptDict = (COSDictionary)namesDict.getDictionaryObject(COSName.getPDFName((String)"JavaScript"))) != null) {
            namesDict.removeItem(COSName.getPDFName((String)"JavaScript"));
        }
        if (catalog.getOpenAction() instanceof PDActionJavaScript) {
            catalog.setOpenAction(null);
        }
        if ((catalogActions = catalog.getActions()) != null) {
            if (catalogActions.getWC() instanceof PDActionJavaScript) {
                catalogActions.setWC(null);
            }
            if (catalogActions.getWS() instanceof PDActionJavaScript) {
                catalogActions.setWS(null);
            }
            if (catalogActions.getDS() instanceof PDActionJavaScript) {
                catalogActions.setDS(null);
            }
            if (catalogActions.getWP() instanceof PDActionJavaScript) {
                catalogActions.setWP(null);
            }
            if (catalogActions.getDP() instanceof PDActionJavaScript) {
                catalogActions.setDP(null);
            }
        }
        if ((acroForm = catalog.getAcroForm()) != null) {
            for (PDField field : acroForm.getFields()) {
                PDFormFieldAdditionalActions actions = field.getActions();
                if (actions == null) continue;
                if (actions.getC() instanceof PDActionJavaScript) {
                    actions.setC(null);
                }
                if (actions.getF() instanceof PDActionJavaScript) {
                    actions.setF(null);
                }
                if (actions.getK() instanceof PDActionJavaScript) {
                    actions.setK(null);
                }
                if (!(actions.getV() instanceof PDActionJavaScript)) continue;
                actions.setV(null);
            }
        }
        for (PDPage page : document.getPages()) {
            PDPageAdditionalActions pageActions = page.getActions();
            if (pageActions != null) {
                if (pageActions.getO() instanceof PDActionJavaScript) {
                    pageActions.setO(null);
                }
                if (pageActions.getC() instanceof PDActionJavaScript) {
                    pageActions.setC(null);
                }
            }
            for (PDAnnotation annotation : page.getAnnotations()) {
                PDAnnotationWidget widget;
                PDAction action;
                if (!(annotation instanceof PDAnnotationWidget) || !((action = (widget = (PDAnnotationWidget)annotation).getAction()) instanceof PDActionJavaScript)) continue;
                widget.setAction(null);
            }
        }
    }

    private static void sanitizeEmbeddedFiles(PDDocument document) throws IOException {
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        PDDocumentNameDictionary names = catalog.getNames();
        if (names != null) {
            names.setEmbeddedFiles(null);
        }
        for (PDPage page : document.getPages()) {
            List annotations = page.getAnnotations();
            if (annotations == null || annotations.isEmpty()) continue;
            annotations.removeIf(annotation -> annotation instanceof PDAnnotationFileAttachment);
        }
    }

    private static void sanitizeXMPMetadata(PDDocument document) {
        PDMetadata metadata;
        if (document.getDocumentCatalog() != null && (metadata = document.getDocumentCatalog().getMetadata()) != null) {
            document.getDocumentCatalog().setMetadata(null);
        }
    }

    private static void sanitizeDocumentInfoMetadata(PDDocument document) {
        PDDocumentInformation docInfo = document.getDocumentInformation();
        if (docInfo != null) {
            PDDocumentInformation newInfo = new PDDocumentInformation();
            document.setDocumentInformation(newInfo);
        }
    }

    private static void sanitizeLinks(PDDocument document) throws IOException {
        for (PDPage page : document.getPages()) {
            for (PDAnnotation annotation : page.getAnnotations()) {
                PDAnnotationLink linkAnnotation;
                PDAction action;
                if (!(annotation instanceof PDAnnotationLink) || !((action = (linkAnnotation = (PDAnnotationLink)annotation).getAction()) instanceof PDActionLaunch) && !(action instanceof PDActionURI)) continue;
                linkAnnotation.setAction(null);
            }
        }
    }

    private static void sanitizeFonts(PDDocument document) {
        for (PDPage page : document.getPages()) {
            if (page == null || page.getResources() == null || page.getResources().getCOSObject() == null) continue;
            page.getResources().getCOSObject().removeItem(COSName.getPDFName((String)"Font"));
        }
    }

    @Generated
    public SanitizeController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

