/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.security;

import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.security.AddPasswordRequest;
import stirling.software.SPDF.model.api.security.PDFPasswordRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.SecurityApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@SecurityApi
public class PasswordController {
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/remove-password"})
    @StandardPdfResponse
    @Operation(summary="Remove password from a PDF file", description="This endpoint removes the password from a protected PDF file. Users need to provide the existing password. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> removePassword(@ModelAttribute PDFPasswordRequest request) throws IOException {
        ResponseEntity responseEntity;
        block9: {
            MultipartFile fileInput = request.getFileInput();
            String password = request.getPassword();
            PDDocument document = this.pdfDocumentFactory.load(fileInput, password);
            try {
                document.setAllSecurityToBeRemoved(true);
                responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)GeneralUtils.generateFilename((String)fileInput.getOriginalFilename(), (String)"_password_removed.pdf"));
                if (document == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    if (ExceptionUtils.isPasswordError((IOException)e)) {
                        throw ExceptionUtils.createPdfPasswordException((Exception)e);
                    }
                    ExceptionUtils.logException((String)"password removal", (Exception)e);
                    throw ExceptionUtils.handlePdfException((IOException)e);
                }
            }
            document.close();
        }
        return responseEntity;
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/add-password"})
    @StandardPdfResponse
    @Operation(summary="Add password to a PDF file", description="This endpoint adds password protection to a PDF file. Users can specify a set of permissions that should be applied to the file. Input:PDF Output:PDF")
    public ResponseEntity<byte[]> addPassword(@ModelAttribute AddPasswordRequest request) throws IOException {
        MultipartFile fileInput = request.getFileInput();
        String ownerPassword = request.getOwnerPassword();
        String password = request.getPassword();
        int keyLength = request.getKeyLength();
        boolean preventAssembly = Boolean.TRUE.equals(request.getPreventAssembly());
        boolean preventExtractContent = Boolean.TRUE.equals(request.getPreventExtractContent());
        boolean preventExtractForAccessibility = Boolean.TRUE.equals(request.getPreventExtractForAccessibility());
        boolean preventFillInForm = Boolean.TRUE.equals(request.getPreventFillInForm());
        boolean preventModify = Boolean.TRUE.equals(request.getPreventModify());
        boolean preventModifyAnnotations = Boolean.TRUE.equals(request.getPreventModifyAnnotations());
        boolean preventPrinting = Boolean.TRUE.equals(request.getPreventPrinting());
        boolean preventPrintingFaithful = Boolean.TRUE.equals(request.getPreventPrintingFaithful());
        try (PDDocument document = this.pdfDocumentFactory.load(fileInput);){
            AccessPermission ap = new AccessPermission();
            ap.setCanAssembleDocument(!preventAssembly);
            ap.setCanExtractContent(!preventExtractContent);
            ap.setCanExtractForAccessibility(!preventExtractForAccessibility);
            ap.setCanFillInForm(!preventFillInForm);
            ap.setCanModify(!preventModify);
            ap.setCanModifyAnnotations(!preventModifyAnnotations);
            ap.setCanPrint(!preventPrinting);
            ap.setCanPrintFaithful(!preventPrintingFaithful);
            StandardProtectionPolicy spp = new StandardProtectionPolicy(ownerPassword, password, ap);
            if (ownerPassword != null && ownerPassword.length() > 0 || password != null && password.length() > 0) {
                spp.setEncryptionKeyLength(keyLength);
            }
            spp.setPermissions(ap);
            document.protect((ProtectionPolicy)spp);
            if (!(ownerPassword != null && ownerPassword.length() != 0 || password != null && password.length() != 0)) {
                ResponseEntity responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)GeneralUtils.generateFilename((String)fileInput.getOriginalFilename(), (String)"_permissions.pdf"));
                return responseEntity;
            }
            ResponseEntity responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)GeneralUtils.generateFilename((String)fileInput.getOriginalFilename(), (String)"_passworded.pdf"));
            return responseEntity;
        }
    }

    @Generated
    public PasswordController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

