/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.MiscApi;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.RegexPatternUtils;
import stirling.software.common.util.WebResponseUtils;

@MiscApi
public class UnlockPDFFormsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnlockPDFFormsController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    public UnlockPDFFormsController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/unlock-pdf-forms"})
    @StandardPdfResponse
    @Operation(summary="Remove read-only property from form fields", description="Removing read-only property from form fields making them fillableInput:PDF, Output:PDF. Type:SISO")
    public ResponseEntity<byte[]> unlockPDFForms(@ModelAttribute PDFFile file) {
        ResponseEntity responseEntity;
        block18: {
            PDDocument document = this.pdfDocumentFactory.load(file);
            try {
                PDAcroForm acroForm = document.getDocumentCatalog().getAcroForm();
                if (acroForm != null) {
                    acroForm.setNeedAppearances(Boolean.valueOf(true));
                    for (PDField field : acroForm.getFieldTree()) {
                        int currentFlags;
                        COSDictionary dict = field.getCOSObject();
                        if (dict.containsKey(COSName.getPDFName((String)"Lock"))) {
                            dict.removeItem(COSName.getPDFName((String)"Lock"));
                        }
                        if (((currentFlags = field.getFieldFlags()) & 1) != 1) continue;
                        int newFlags = currentFlags & 0xFFFFFFFE;
                        field.setFieldFlags(newFlags);
                    }
                    COSBase xfaBase = acroForm.getCOSObject().getDictionaryObject(COSName.XFA);
                    if (xfaBase != null) {
                        try {
                            Pattern accessReadOnlyPattern = RegexPatternUtils.getInstance().getAccessReadOnlyPattern();
                            if (xfaBase instanceof COSStream) {
                                COSStream xfaStream = (COSStream)xfaBase;
                                COSInputStream is = xfaStream.createInputStream();
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                is.transferTo(baos);
                                String xml = baos.toString(StandardCharsets.UTF_8);
                                xml = accessReadOnlyPattern.matcher(xml).replaceAll("access=\"open\"");
                                PDStream newStream = new PDStream(document, (InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
                                acroForm.getCOSObject().setItem(COSName.XFA, (COSBase)newStream.getCOSObject());
                            } else if (xfaBase instanceof COSArray) {
                                COSArray xfaArray = (COSArray)xfaBase;
                                for (int i = 0; i < xfaArray.size(); i += 2) {
                                    COSBase namePart = xfaArray.getObject(i);
                                    COSBase streamPart = xfaArray.getObject(i + 1);
                                    if (!(namePart instanceof COSString) || !(streamPart instanceof COSStream)) continue;
                                    COSStream stream = (COSStream)streamPart;
                                    COSInputStream is = stream.createInputStream();
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                    is.transferTo(baos);
                                    String xml = baos.toString(StandardCharsets.UTF_8);
                                    xml = accessReadOnlyPattern.matcher(xml).replaceAll("access=\"open\"");
                                    PDStream newStream = new PDStream(document, (InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
                                    xfaArray.set(i + 1, (COSBase)newStream.getCOSObject());
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error("exception", (Throwable)e);
                        }
                    }
                }
                String mergedFileName = GeneralUtils.generateFilename((String)file.getFileInput().getOriginalFilename(), (String)"_unlocked_forms.pdf");
                responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)Filenames.toSimpleFileName((String)mergedFileName));
                if (document == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            document.close();
        }
        return responseEntity;
    }
}

