/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.misc.MetadataRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.MiscApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.service.PdfMetadataService;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.RegexPatternUtils;
import stirling.software.common.util.WebResponseUtils;
import stirling.software.common.util.propertyeditor.StringToMapPropertyEditor;

@MiscApi
public class MetadataController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    private String checkUndefined(String entry) {
        if ("undefined".equals(entry)) {
            return null;
        }
        return entry;
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Map.class, "allRequestParams", (PropertyEditor)new StringToMapPropertyEditor());
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/update-metadata"})
    @StandardPdfResponse
    @Operation(summary="Update metadata of a PDF file", description="This endpoint allows you to update the metadata of a given PDF file. You can add, modify, or delete standard and custom metadata fields. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> metadata(@ModelAttribute MetadataRequest request) throws IOException {
        MultipartFile pdfFile = request.getFileInput();
        boolean deleteAll = Boolean.TRUE.equals(request.getDeleteAll());
        String author = request.getAuthor();
        String creationDate = request.getCreationDate();
        String creator = request.getCreator();
        String keywords = request.getKeywords();
        String modificationDate = request.getModificationDate();
        String producer = request.getProducer();
        String subject = request.getSubject();
        String title = request.getTitle();
        String trapped = request.getTrapped();
        HashMap allRequestParams = request.getAllRequestParams();
        if (allRequestParams == null) {
            allRequestParams = new HashMap();
        }
        try (PDDocument document = this.pdfDocumentFactory.load(pdfFile, true);){
            PDDocumentInformation info = document.getDocumentInformation();
            author = this.checkUndefined(author);
            creationDate = this.checkUndefined(creationDate);
            creator = this.checkUndefined(creator);
            keywords = this.checkUndefined(keywords);
            modificationDate = this.checkUndefined(modificationDate);
            producer = this.checkUndefined(producer);
            subject = this.checkUndefined(subject);
            title = this.checkUndefined(title);
            trapped = this.checkUndefined(trapped);
            if (deleteAll) {
                for (String string : info.getMetadataKeys()) {
                    info.setCustomMetadataValue(string, null);
                }
                document.getDocumentCatalog().getCOSObject().removeItem(COSName.getPDFName((String)"Metadata"));
                document.getDocumentCatalog().getCOSObject().removeItem(COSName.getPDFName((String)"PieceInfo"));
                author = null;
                creationDate = null;
                creator = null;
                keywords = null;
                modificationDate = null;
                producer = null;
                subject = null;
                title = null;
                trapped = null;
            } else {
                for (Map.Entry entry : allRequestParams.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!("Author".equalsIgnoreCase(key) || "CreationDate".equalsIgnoreCase(key) || "Creator".equalsIgnoreCase(key) || "Keywords".equalsIgnoreCase(key) || "modificationDate".equalsIgnoreCase(key) || "Producer".equalsIgnoreCase(key) || "Subject".equalsIgnoreCase(key) || "Title".equalsIgnoreCase(key) || "Trapped".equalsIgnoreCase(key) || key.contains("customKey") || key.contains("customValue"))) {
                        info.setCustomMetadataValue(key, (String)entry.getValue());
                        continue;
                    }
                    if (!key.contains("customKey")) continue;
                    try {
                        int number = Integer.parseInt(RegexPatternUtils.getInstance().getNumericExtractionPattern().matcher(key).replaceAll(""));
                        String customKey = (String)entry.getValue();
                        String customValue = (String)allRequestParams.get("customValue" + number);
                        info.setCustomMetadataValue(customKey, customValue);
                    }
                    catch (NumberFormatException e) {
                        log.warn("Skipping invalid custom key '{}': {}", (Object)key, (Object)e.getMessage());
                    }
                }
            }
            Calendar creationDateCal = PdfMetadataService.parseToCalendar((String)creationDate);
            info.setCreationDate(creationDateCal);
            Calendar calendar = PdfMetadataService.parseToCalendar((String)modificationDate);
            info.setModificationDate(calendar);
            info.setCreator(creator);
            info.setKeywords(keywords);
            info.setAuthor(author);
            info.setProducer(producer);
            info.setSubject(subject);
            info.setTitle(title);
            info.setTrapped(trapped);
            document.setDocumentInformation(info);
            ResponseEntity responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)(GeneralUtils.removeExtension((String)Filenames.toSimpleFileName((String)pdfFile.getOriginalFilename())) + "_metadata.pdf"));
            return responseEntity;
        }
    }

    @Generated
    public MetadataController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

