/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.swagger.v3.oas.annotations.Hidden;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.SPDF.config.ExternalAppDepConfig;
import stirling.software.SPDF.config.InitialSetup;
import stirling.software.common.annotations.api.ConfigApi;
import stirling.software.common.configuration.AppConfig;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.service.ServerCertificateServiceInterface;
import stirling.software.common.service.UserServiceInterface;

@ConfigApi
@Hidden
public class ConfigController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigController.class);
    private final ApplicationProperties applicationProperties;
    private final ApplicationContext applicationContext;
    private final EndpointConfiguration endpointConfiguration;
    private final ServerCertificateServiceInterface serverCertificateService;
    private final UserServiceInterface userService;
    private final ExternalAppDepConfig externalAppDepConfig;

    public ConfigController(ApplicationProperties applicationProperties, ApplicationContext applicationContext, EndpointConfiguration endpointConfiguration, @Autowired(required=false) ServerCertificateServiceInterface serverCertificateService, @Autowired(required=false) UserServiceInterface userService, ExternalAppDepConfig externalAppDepConfig) {
        this.applicationProperties = applicationProperties;
        this.applicationContext = applicationContext;
        this.endpointConfiguration = endpointConfiguration;
        this.serverCertificateService = serverCertificateService;
        this.userService = userService;
        this.externalAppDepConfig = externalAppDepConfig;
    }

    @GetMapping(value={"/app-config"})
    public ResponseEntity<Map<String, Object>> getAppConfig() {
        HashMap<String, Object> configData = new HashMap<String, Object>();
        try {
            configData.put("dependenciesReady", this.externalAppDepConfig.isDependenciesChecked());
            AppConfig appConfig = (AppConfig)this.applicationContext.getBean(AppConfig.class);
            configData.put("baseUrl", appConfig.getBackendUrl());
            configData.put("contextPath", appConfig.getContextPath());
            configData.put("serverPort", appConfig.getServerPort());
            String frontendUrl = this.applicationProperties.getSystem().getFrontendUrl();
            configData.put("frontendUrl", frontendUrl != null ? frontendUrl : "");
            configData.put("enableMobileScanner", this.applicationProperties.getSystem().isEnableMobileScanner());
            configData.put("mobileScannerConvertToPdf", this.applicationProperties.getSystem().getMobileScannerSettings().isConvertToPdf());
            configData.put("mobileScannerImageResolution", this.applicationProperties.getSystem().getMobileScannerSettings().getImageResolution());
            configData.put("mobileScannerPageFormat", this.applicationProperties.getSystem().getMobileScannerSettings().getPageFormat());
            configData.put("mobileScannerStretchToFit", this.applicationProperties.getSystem().getMobileScannerSettings().isStretchToFit());
            configData.put("appNameNavbar", this.applicationProperties.getUi().getAppNameNavbar());
            configData.put("languages", this.applicationProperties.getUi().getLanguages());
            configData.put("logoStyle", this.applicationProperties.getUi().getLogoStyle());
            configData.put("defaultLocale", this.applicationProperties.getSystem().getDefaultLocale());
            boolean enableLogin = this.applicationProperties.getSecurity().isEnableLogin() && this.userService != null;
            configData.put("enableLogin", enableLogin);
            configData.put("showSettingsWhenNoLogin", this.applicationProperties.getSystem().isShowSettingsWhenNoLogin());
            boolean smtpEnabled = this.applicationProperties.getMail().isEnabled();
            boolean invitesEnabled = this.applicationProperties.getMail().isEnableInvites();
            configData.put("enableEmailInvites", smtpEnabled && invitesEnabled);
            boolean isAdmin = false;
            if (this.userService != null) {
                try {
                    isAdmin = this.userService.isCurrentUserAdmin();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            configData.put("isAdmin", isAdmin);
            configData.put("isNewServer", InitialSetup.isNewServer());
            boolean isNewUser = false;
            if (this.userService != null) {
                try {
                    isNewUser = this.userService.isCurrentUserFirstLogin();
                }
                catch (Exception e) {
                    isNewUser = false;
                }
            }
            configData.put("isNewUser", isNewUser);
            configData.put("enableAlphaFunctionality", this.applicationProperties.getSystem().isEnableAlphaFunctionality());
            configData.put("enableAnalytics", this.applicationProperties.getSystem().getEnableAnalytics());
            configData.put("enablePosthog", this.applicationProperties.getSystem().getEnablePosthog());
            configData.put("enableScarf", this.applicationProperties.getSystem().getEnableScarf());
            configData.put("enableDesktopInstallSlide", this.applicationProperties.getSystem().getEnableDesktopInstallSlide());
            configData.put("premiumEnabled", this.applicationProperties.getPremium().isEnabled());
            configData.put("serverCertificateEnabled", this.serverCertificateService != null && this.serverCertificateService.isEnabled());
            configData.put("termsAndConditions", this.applicationProperties.getLegal().getTermsAndConditions());
            configData.put("privacyPolicy", this.applicationProperties.getLegal().getPrivacyPolicy());
            configData.put("cookiePolicy", this.applicationProperties.getLegal().getCookiePolicy());
            configData.put("impressum", this.applicationProperties.getLegal().getImpressum());
            configData.put("accessibilityStatement", this.applicationProperties.getLegal().getAccessibilityStatement());
            try {
                if (this.applicationContext.containsBean("runningProOrHigher")) {
                    configData.put("runningProOrHigher", this.applicationContext.getBean("runningProOrHigher", Boolean.class));
                }
                if (this.applicationContext.containsBean("runningEE")) {
                    configData.put("runningEE", this.applicationContext.getBean("runningEE", Boolean.class));
                }
                if (this.applicationContext.containsBean("license")) {
                    configData.put("license", this.applicationContext.getBean("license", String.class));
                }
                if (this.applicationContext.containsBean("SSOAutoLogin")) {
                    configData.put("SSOAutoLogin", this.applicationContext.getBean("SSOAutoLogin", Boolean.class));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.applicationContext.containsBean("appVersion")) {
                    configData.put("appVersion", this.applicationContext.getBean("appVersion", String.class));
                }
                if (this.applicationContext.containsBean("machineType")) {
                    configData.put("machineType", this.applicationContext.getBean("machineType", String.class));
                }
                if (this.applicationContext.containsBean("activeSecurity")) {
                    configData.put("activeSecurity", this.applicationContext.getBean("activeSecurity", Boolean.class));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ResponseEntity.ok(configData);
        }
        catch (Exception e) {
            configData.put("error", "Unable to retrieve full configuration");
            return ResponseEntity.ok(configData);
        }
    }

    @GetMapping(value={"/endpoint-enabled"})
    public ResponseEntity<Boolean> isEndpointEnabled(@RequestParam(name="endpoint") String endpoint) {
        boolean enabled = this.endpointConfiguration.isEndpointEnabled(endpoint);
        return ResponseEntity.ok((Object)enabled);
    }

    @GetMapping(value={"/endpoints-enabled"})
    public ResponseEntity<Map<String, Boolean>> areEndpointsEnabled(@RequestParam(name="endpoints") String endpoints) {
        String[] endpointArray;
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (String endpoint : endpointArray = endpoints.split(",")) {
            String trimmedEndpoint = endpoint.trim();
            result.put(trimmedEndpoint, this.endpointConfiguration.isEndpointEnabled(trimmedEndpoint));
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/endpoints-availability"})
    public ResponseEntity<Map<String, EndpointConfiguration.EndpointAvailability>> getEndpointAvailability(@RequestParam(name="endpoints") @Size(min=1, max=100, message="Must provide between 1 and 100 endpoints") @Size(min=1, max=100, message="Must provide between 1 and 100 endpoints") List<@NotBlank String> endpoints) {
        HashMap<String, EndpointConfiguration.EndpointAvailability> result = new HashMap<String, EndpointConfiguration.EndpointAvailability>();
        for (String endpoint : endpoints) {
            String trimmedEndpoint = endpoint.trim();
            result.put(trimmedEndpoint, this.endpointConfiguration.getEndpointAvailability(trimmedEndpoint));
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/group-enabled"})
    public ResponseEntity<Boolean> isGroupEnabled(@RequestParam(name="group") String group) {
        boolean enabled = this.endpointConfiguration.isGroupEnabled(group);
        return ResponseEntity.ok((Object)enabled);
    }
}

