/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.swagger.v3.oas.annotations.Operation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.ImageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.SPDF.config.swagger.MultiFileResponse;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.converters.ConvertCbrToPdfRequest;
import stirling.software.SPDF.model.api.converters.ConvertCbzToPdfRequest;
import stirling.software.SPDF.model.api.converters.ConvertPdfToCbrRequest;
import stirling.software.SPDF.model.api.converters.ConvertPdfToCbzRequest;
import stirling.software.SPDF.model.api.converters.ConvertToImageRequest;
import stirling.software.SPDF.model.api.converters.ConvertToPdfRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.ConvertApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.CbrUtils;
import stirling.software.common.util.CbzUtils;
import stirling.software.common.util.CheckProgramInstall;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.PdfToCbrUtils;
import stirling.software.common.util.PdfToCbzUtils;
import stirling.software.common.util.PdfUtils;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.RegexPatternUtils;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

@ConvertApi
public class ConvertImgPDFController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConvertImgPDFController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final TempFileManager tempFileManager;
    private final EndpointConfiguration endpointConfiguration;
    private static final Pattern EXTENSION_PATTERN = RegexPatternUtils.getInstance().getPattern(RegexPatternUtils.getExtensionRegex());
    private static final String DEFAULT_COMIC_NAME = "comic";

    private boolean isGhostscriptEnabled() {
        return this.endpointConfiguration.isGroupEnabled("Ghostscript");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/pdf/img"})
    @MultiFileResponse
    @Operation(summary="Convert PDF to image(s)", description="This endpoint converts a PDF file to image(s) with the specified image format, color type, and DPI. Users can choose to get a single image or multiple images.  Input:PDF Output:Image Type:SI-Conditional")
    public ResponseEntity<byte[]> convertToImage(@ModelAttribute ConvertToImageRequest request) throws Exception {
        String filename;
        byte[] result;
        Path tempPdfPath;
        Path tempOutputDir;
        Path tempFile;
        block57: {
            Object command;
            String[] stringArray;
            MultipartFile file = request.getFileInput();
            String imageFormat = request.getImageFormat();
            String singleOrMultiple = request.getSingleOrMultiple();
            String colorType = request.getColorType();
            int dpi = request.getDpi();
            String pageNumbers = request.getPageNumbers();
            boolean includeAnnotations = Boolean.TRUE.equals(request.getIncludeAnnotations());
            tempFile = null;
            tempOutputDir = null;
            tempPdfPath = null;
            result = null;
            if (pageNumbers != null && !pageNumbers.trim().isEmpty()) {
                stringArray = pageNumbers.split(",");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "all";
            }
            String[] pageOrderArr = stringArray;
            try {
                byte[] newPdfBytes = this.rearrangePdfPages(file, pageOrderArr);
                ImageType colorTypeResult = ImageType.RGB;
                if ("greyscale".equals(colorType)) {
                    colorTypeResult = ImageType.GRAY;
                } else if ("blackwhite".equals(colorType)) {
                    colorTypeResult = ImageType.BINARY;
                }
                boolean singleImage = "single".equals(singleOrMultiple);
                filename = GeneralUtils.generateFilename((String)file.getOriginalFilename(), (String)"");
                result = PdfUtils.convertFromPdf((CustomPDFDocumentFactory)this.pdfDocumentFactory, (byte[])newPdfBytes, (String)("webp".equalsIgnoreCase(imageFormat) ? "png" : imageFormat.toUpperCase(Locale.ROOT)), (ImageType)colorTypeResult, (boolean)singleImage, (int)dpi, (String)filename, (boolean)includeAnnotations);
                if (result == null || result.length == 0) {
                    log.error("resultant bytes for {} is null, error converting ", (Object)filename);
                }
                if ("webp".equalsIgnoreCase(imageFormat) && !CheckProgramInstall.isPythonAvailable()) {
                    throw ExceptionUtils.createPythonRequiredForWebpException();
                }
                if ("webp".equalsIgnoreCase(imageFormat) && CheckProgramInstall.isPythonAvailable()) {
                    List<Path> webpFiles;
                    tempFile = Files.createTempFile("temp_png", ".png", new FileAttribute[0]);
                    try (FileOutputStream fos = new FileOutputStream(tempFile.toFile());){
                        fos.write(result);
                        fos.flush();
                    }
                    String pythonVersion = CheckProgramInstall.getAvailablePythonCommand();
                    Path pngToWebpScript = GeneralUtils.extractScript((String)"png_to_webp.py");
                    command = new ArrayList();
                    command.add(pythonVersion);
                    command.add(pngToWebpScript.toAbsolutePath().toString());
                    tempOutputDir = Files.createTempDirectory("webp_output", new FileAttribute[0]);
                    if (singleImage) {
                        command.add(tempFile.toString());
                        command.add(tempOutputDir.toString());
                        command.add("--single");
                    } else {
                        tempPdfPath = Files.createTempFile("temp_pdf", ".pdf", new FileAttribute[0]);
                        file.transferTo(tempPdfPath.toFile());
                        command.add(tempPdfPath.toString());
                        command.add(tempOutputDir.toString());
                    }
                    command.add("--dpi");
                    command.add(String.valueOf(dpi));
                    ProcessExecutor.ProcessExecutorResult resultProcess = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.PYTHON_OPENCV).runCommandWithOutputHandling((List)command);
                    try (Stream<Path> walkStream = Files.walk(tempOutputDir, new FileVisitOption[0]);){
                        webpFiles = walkStream.filter(path -> path.toString().endsWith(".webp")).toList();
                    }
                    if (webpFiles.isEmpty()) {
                        log.error("No WebP files were created in: {}", (Object)tempOutputDir.toString());
                        throw new IOException("No WebP files were created. " + resultProcess.getMessages());
                    }
                    byte[] bodyBytes = new byte[]{};
                    if (webpFiles.size() == 1) {
                        Path webpFilePath = webpFiles.get(0);
                        bodyBytes = Files.readAllBytes(webpFilePath);
                    } else {
                        try (ByteArrayOutputStream zipOutputStream = new ByteArrayOutputStream();
                             ZipOutputStream zos = new ZipOutputStream(zipOutputStream);){
                            for (Path webpFile : webpFiles) {
                                zos.putNextEntry(new ZipEntry(webpFile.getFileName().toString()));
                                Files.copy(webpFile, zos);
                                zos.closeEntry();
                            }
                            bodyBytes = zipOutputStream.toByteArray();
                        }
                    }
                    Files.deleteIfExists(tempFile);
                    if (tempOutputDir != null) {
                        FileUtils.deleteDirectory((File)tempOutputDir.toFile());
                    }
                    result = bodyBytes;
                }
                if (!singleImage) break block57;
                String docName = filename + "." + imageFormat;
                MediaType mediaType = MediaType.parseMediaType((String)this.getMediaType(imageFormat));
                command = WebResponseUtils.bytesToWebResponse((byte[])result, (String)docName, (MediaType)mediaType);
            }
            catch (Throwable throwable) {
                try {
                    if (tempFile != null) {
                        Files.deleteIfExists(tempFile);
                    }
                    if (tempPdfPath != null) {
                        Files.deleteIfExists(tempPdfPath);
                    }
                    if (tempOutputDir != null) {
                        FileUtils.deleteDirectory((File)tempOutputDir.toFile());
                    }
                }
                catch (Exception e) {
                    log.error("Error cleaning up temporary files", (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (tempFile != null) {
                    Files.deleteIfExists(tempFile);
                }
                if (tempPdfPath != null) {
                    Files.deleteIfExists(tempPdfPath);
                }
                if (tempOutputDir != null) {
                    FileUtils.deleteDirectory((File)tempOutputDir.toFile());
                }
            }
            catch (Exception e) {
                log.error("Error cleaning up temporary files", (Throwable)e);
            }
            return command;
        }
        String zipFilename = filename + "_convertedToImages.zip";
        ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])result, (String)zipFilename, (MediaType)MediaType.APPLICATION_OCTET_STREAM);
        try {
            if (tempFile != null) {
                Files.deleteIfExists(tempFile);
            }
            if (tempPdfPath != null) {
                Files.deleteIfExists(tempPdfPath);
            }
            if (tempOutputDir != null) {
                FileUtils.deleteDirectory((File)tempOutputDir.toFile());
            }
        }
        catch (Exception e) {
            log.error("Error cleaning up temporary files", (Throwable)e);
        }
        return responseEntity;
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/img/pdf"})
    @StandardPdfResponse
    @Operation(summary="Convert images to a PDF file", description="This endpoint converts one or more images to a PDF file. Users can specify whether to stretch the images to fit the PDF page, and whether to automatically rotate the images. Input:Image Output:PDF Type:MISO")
    public ResponseEntity<byte[]> convertToPdf(@ModelAttribute ConvertToPdfRequest request) throws IOException {
        MultipartFile[] file = request.getFileInput();
        String fitOption = request.getFitOption();
        String colorType = request.getColorType();
        boolean autoRotate = Boolean.TRUE.equals(request.getAutoRotate());
        if (colorType == null || colorType.isBlank()) {
            colorType = "color";
        }
        if (fitOption == null || fitOption.isEmpty()) {
            fitOption = "fillPage";
        }
        byte[] bytes = PdfUtils.imageToPdf((MultipartFile[])file, (String)fitOption, (boolean)autoRotate, (String)colorType, (CustomPDFDocumentFactory)this.pdfDocumentFactory);
        return WebResponseUtils.bytesToWebResponse((byte[])bytes, (String)GeneralUtils.generateFilename((String)file[0].getOriginalFilename(), (String)"_converted.pdf"));
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/cbz/pdf"})
    @Operation(summary="Convert CBZ comic book archive to PDF", description="This endpoint converts a CBZ (ZIP) comic book archive to a PDF file. Input:CBZ Output:PDF Type:SISO")
    public ResponseEntity<?> convertCbzToPdf(@ModelAttribute ConvertCbzToPdfRequest request) throws IOException {
        MultipartFile file = request.getFileInput();
        boolean optimizeForEbook = request.isOptimizeForEbook();
        if (optimizeForEbook && !this.isGhostscriptEnabled()) {
            log.warn("Ghostscript optimization requested but Ghostscript is not enabled/available");
            optimizeForEbook = false;
        }
        byte[] pdfBytes = CbzUtils.convertCbzToPdf((MultipartFile)file, (CustomPDFDocumentFactory)this.pdfDocumentFactory, (TempFileManager)this.tempFileManager, (boolean)optimizeForEbook);
        String filename = this.createConvertedFilename(file.getOriginalFilename(), "_converted.pdf");
        return WebResponseUtils.bytesToWebResponse((byte[])pdfBytes, (String)filename);
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/pdf/cbz"})
    @Operation(summary="Convert PDF to CBZ comic book archive", description="This endpoint converts a PDF file to a CBZ (ZIP) comic book archive. Input:PDF Output:CBZ Type:SISO")
    public ResponseEntity<?> convertPdfToCbz(@ModelAttribute ConvertPdfToCbzRequest request) throws IOException {
        MultipartFile file = request.getFileInput();
        int dpi = request.getDpi();
        if (dpi <= 0) {
            dpi = 300;
        }
        byte[] cbzBytes = PdfToCbzUtils.convertPdfToCbz((MultipartFile)file, (int)dpi, (CustomPDFDocumentFactory)this.pdfDocumentFactory);
        String filename = this.createConvertedFilename(file.getOriginalFilename(), "_converted.cbz");
        return WebResponseUtils.bytesToWebResponse((byte[])cbzBytes, (String)filename, (MediaType)MediaType.APPLICATION_OCTET_STREAM);
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/cbr/pdf"})
    @Operation(summary="Convert CBR comic book archive to PDF", description="This endpoint converts a CBR (RAR) comic book archive to a PDF file. Input:CBR Output:PDF Type:SISO")
    public ResponseEntity<?> convertCbrToPdf(@ModelAttribute ConvertCbrToPdfRequest request) throws IOException {
        MultipartFile file = request.getFileInput();
        boolean optimizeForEbook = request.isOptimizeForEbook();
        if (optimizeForEbook && !this.isGhostscriptEnabled()) {
            log.warn("Ghostscript optimization requested but Ghostscript is not enabled/available");
            optimizeForEbook = false;
        }
        byte[] pdfBytes = CbrUtils.convertCbrToPdf((MultipartFile)file, (CustomPDFDocumentFactory)this.pdfDocumentFactory, (TempFileManager)this.tempFileManager, (boolean)optimizeForEbook);
        String filename = this.createConvertedFilename(file.getOriginalFilename(), "_converted.pdf");
        return WebResponseUtils.bytesToWebResponse((byte[])pdfBytes, (String)filename);
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/pdf/cbr"})
    @Operation(summary="Convert PDF to CBR comic book archive", description="This endpoint converts a PDF file to a CBR comic book archive using the local RAR CLI. Input:PDF Output:CBR Type:SISO")
    public ResponseEntity<?> convertPdfToCbr(@ModelAttribute ConvertPdfToCbrRequest request) throws IOException {
        MultipartFile file = request.getFileInput();
        int dpi = request.getDpi();
        if (dpi <= 0) {
            dpi = 300;
        }
        byte[] cbrBytes = PdfToCbrUtils.convertPdfToCbr((MultipartFile)file, (int)dpi, (CustomPDFDocumentFactory)this.pdfDocumentFactory);
        String filename = this.createConvertedFilename(file.getOriginalFilename(), "_converted.cbr");
        return WebResponseUtils.bytesToWebResponse((byte[])cbrBytes, (String)filename, (MediaType)MediaType.APPLICATION_OCTET_STREAM);
    }

    private String createConvertedFilename(String originalFilename, String suffix) {
        if (originalFilename == null) {
            return GeneralUtils.generateFilename((String)DEFAULT_COMIC_NAME, (String)suffix);
        }
        String baseName = EXTENSION_PATTERN.matcher(originalFilename).replaceFirst("");
        if (baseName.isBlank()) {
            baseName = DEFAULT_COMIC_NAME;
        }
        return GeneralUtils.generateFilename((String)baseName, (String)suffix);
    }

    private String getMediaType(String imageFormat) {
        String mimeType = URLConnection.guessContentTypeFromName("." + imageFormat);
        return "null".equals(mimeType) ? "application/octet-stream" : mimeType;
    }

    private byte[] rearrangePdfPages(MultipartFile pdfFile, String[] pageOrderArr) throws IOException {
        try (PDDocument document = this.pdfDocumentFactory.load(pdfFile);){
            Object object;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int totalPages = document.getNumberOfPages();
                List newPageOrder = GeneralUtils.parsePageList((String[])pageOrderArr, (int)totalPages, (boolean)false);
                ArrayList<PDPage> newPages = new ArrayList<PDPage>();
                Iterator iterator = newPageOrder.iterator();
                while (iterator.hasNext()) {
                    int pageIndex = (Integer)iterator.next();
                    newPages.add(document.getPage(pageIndex));
                }
                for (int i = document.getNumberOfPages() - 1; i >= 0; --i) {
                    document.removePage(i);
                }
                for (PDPage page : newPages) {
                    document.addPage(page);
                }
                document.save((OutputStream)baos);
                object = baos.toByteArray();
            }
            return object;
        }
    }

    @Generated
    public ConvertImgPDFController(CustomPDFDocumentFactory pdfDocumentFactory, TempFileManager tempFileManager, EndpointConfiguration endpointConfiguration) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.tempFileManager = tempFileManager;
        this.endpointConfiguration = endpointConfiguration;
    }
}

