/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.pdfbox.multipdf.LayerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.MultiFileResponse;
import stirling.software.SPDF.controller.api.SplitPdfBySectionsController;
import stirling.software.SPDF.model.SplitTypes;
import stirling.software.SPDF.model.api.SplitPdfBySectionsRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.GeneralApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

@GeneralApi
public class SplitPdfBySectionsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SplitPdfBySectionsController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final TempFileManager tempFileManager;

    /*
     * Enabled aggressive exception aggregation
     */
    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/split-pdf-by-sections"})
    @MultiFileResponse
    @Operation(summary="Split PDF pages into smaller sections", description="Split each page of a PDF into smaller sections based on the user's choice which page to split, and how to split ( halves, thirds, quarters, etc.), both vertically and horizontally. Input:PDF Output:ZIP-PDF Type:SISO")
    public ResponseEntity<byte[]> splitPdf(@ModelAttribute SplitPdfBySectionsRequest request) throws Exception {
        MultipartFile file = request.getFileInput();
        String pageNumbers = request.getPageNumbers();
        SplitTypes splitMode = Optional.ofNullable(request.getSplitMode()).map(SplitTypes::valueOf).orElse(SplitTypes.SPLIT_ALL);
        try {
            PDDocument sourceDocument = this.pdfDocumentFactory.load(file);
            Set pagesToSplit = this.getPagesToSplit(pageNumbers, splitMode, sourceDocument.getNumberOfPages());
            int horiz = request.getHorizontalDivisions() + 1;
            int verti = request.getVerticalDivisions() + 1;
            boolean merge = Boolean.TRUE.equals(request.getMerge());
            String filename = GeneralUtils.generateFilename((String)file.getOriginalFilename(), (String)"_split");
            if (merge) {
                try (PDDocument mergedDoc = this.pdfDocumentFactory.createNewDocumentBasedOnOldDocument(sourceDocument);){
                    ResponseEntity pageIndex2;
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                        LayerUtility layerUtility = new LayerUtility(mergedDoc);
                        for (int pageIndex2 = 0; pageIndex2 < sourceDocument.getNumberOfPages(); ++pageIndex2) {
                            if (pagesToSplit.contains(pageIndex2)) {
                                this.addSplitPageToTarget(sourceDocument, pageIndex2, mergedDoc, layerUtility, horiz, verti);
                                continue;
                            }
                            this.addPageToTarget(sourceDocument, pageIndex2, mergedDoc, layerUtility);
                        }
                        mergedDoc.save((OutputStream)baos);
                        pageIndex2 = WebResponseUtils.baosToWebResponse((ByteArrayOutputStream)baos, (String)(filename + ".pdf"));
                    }
                    return pageIndex2;
                }
            }
            TempFile zipTempFile = new TempFile(this.tempFileManager, ".zip");
            try (ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(zipTempFile.getPath(), new OpenOption[0]));){
                for (int pageIndex = 0; pageIndex < sourceDocument.getNumberOfPages(); ++pageIndex) {
                    int pageNum = pageIndex + 1;
                    if (pagesToSplit.contains(pageIndex)) {
                        for (int i = 0; i < horiz; ++i) {
                            for (int j = 0; j < verti; ++j) {
                                try (PDDocument subDoc = this.pdfDocumentFactory.createNewDocument();){
                                    LayerUtility subLayerUtility = new LayerUtility(subDoc);
                                    this.addSingleSectionToTarget(sourceDocument, pageIndex, subDoc, subLayerUtility, i, j, horiz, verti);
                                    int sectionNum = i * verti + j + 1;
                                    String entryName = filename + "_" + pageNum + "_" + sectionNum + ".pdf";
                                    this.saveDocToZip(subDoc, zipOut, entryName);
                                    continue;
                                }
                                catch (IOException e) {
                                    log.error("Error creating section {} for page {}", new Object[]{i * verti + j + 1, pageNum, e});
                                    throw e;
                                }
                            }
                        }
                        continue;
                    }
                    try (PDDocument subDoc = this.pdfDocumentFactory.createNewDocument();){
                        LayerUtility subLayerUtility = new LayerUtility(subDoc);
                        this.addPageToTarget(sourceDocument, pageIndex, subDoc, subLayerUtility);
                        String entryName = filename + "_" + pageNum + "_1.pdf";
                        this.saveDocToZip(subDoc, zipOut, entryName);
                        continue;
                    }
                    catch (IOException e) {
                        log.error("Error processing unsplit page {}", (Object)pageNum, (Object)e);
                        throw e;
                    }
                }
            }
            catch (IOException e) {
                log.error("Error creating ZIP file with split PDF sections", (Throwable)e);
                throw e;
            }
            byte[] zipBytes = Files.readAllBytes(zipTempFile.getPath());
            ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])zipBytes, (String)(filename + ".zip"), (MediaType)MediaType.APPLICATION_OCTET_STREAM);
            return responseEntity;
            finally {
                if (sourceDocument != null) {
                    sourceDocument.close();
                }
            }
        }
        catch (Exception e) {
            log.error("Error splitting PDF file: {}", (Object)file.getOriginalFilename(), (Object)e);
            throw e;
        }
    }

    private void addPageToTarget(PDDocument sourceDoc, int pageIndex, PDDocument targetDoc, LayerUtility layerUtility) throws IOException {
        PDPage sourcePage = sourceDoc.getPage(pageIndex);
        PDPage newPage = new PDPage(sourcePage.getMediaBox());
        targetDoc.addPage(newPage);
        PDFormXObject form = layerUtility.importPageAsForm(sourceDoc, pageIndex);
        try (PDPageContentStream contentStream = new PDPageContentStream(targetDoc, newPage, PDPageContentStream.AppendMode.APPEND, true, true);){
            contentStream.drawForm(form);
        }
        catch (IOException e) {
            log.error("Error adding page {} to target document", (Object)pageIndex, (Object)e);
            throw e;
        }
    }

    private void addSplitPageToTarget(PDDocument sourceDoc, int pageIndex, PDDocument targetDoc, LayerUtility layerUtility, int totalHoriz, int totalVert) throws IOException {
        PDPage sourcePage = sourceDoc.getPage(pageIndex);
        PDRectangle mediaBox = sourcePage.getMediaBox();
        float width = mediaBox.getWidth();
        float height = mediaBox.getHeight();
        float subPageWidth = width / (float)totalHoriz;
        float subPageHeight = height / (float)totalVert;
        PDFormXObject form = layerUtility.importPageAsForm(sourceDoc, pageIndex);
        for (int i = 0; i < totalHoriz; ++i) {
            for (int j = 0; j < totalVert; ++j) {
                PDPage subPage = new PDPage(new PDRectangle(subPageWidth, subPageHeight));
                targetDoc.addPage(subPage);
                try (PDPageContentStream contentStream = new PDPageContentStream(targetDoc, subPage, PDPageContentStream.AppendMode.APPEND, true, true);){
                    float translateX = -subPageWidth * (float)i;
                    float translateY = -subPageHeight * (float)(totalVert - 1 - j);
                    contentStream.saveGraphicsState();
                    contentStream.addRect(0.0f, 0.0f, subPageWidth, subPageHeight);
                    contentStream.clip();
                    contentStream.transform(new Matrix(1.0f, 0.0f, 0.0f, 1.0f, translateX, translateY));
                    contentStream.drawForm(form);
                    contentStream.restoreGraphicsState();
                    continue;
                }
                catch (IOException e) {
                    log.error("Error adding split section ({}, {}) for page {}", new Object[]{i, j, pageIndex, e});
                    throw e;
                }
            }
        }
    }

    private void addSingleSectionToTarget(PDDocument sourceDoc, int pageIndex, PDDocument targetDoc, LayerUtility layerUtility, int horizIndex, int vertIndex, int totalHoriz, int totalVert) throws IOException {
        PDPage sourcePage = sourceDoc.getPage(pageIndex);
        PDRectangle mediaBox = sourcePage.getMediaBox();
        float subPageWidth = mediaBox.getWidth() / (float)totalHoriz;
        float subPageHeight = mediaBox.getHeight() / (float)totalVert;
        PDPage subPage = new PDPage(new PDRectangle(subPageWidth, subPageHeight));
        targetDoc.addPage(subPage);
        PDFormXObject form = layerUtility.importPageAsForm(sourceDoc, pageIndex);
        try (PDPageContentStream contentStream = new PDPageContentStream(targetDoc, subPage, PDPageContentStream.AppendMode.APPEND, true, true);){
            float translateX = -subPageWidth * (float)horizIndex;
            float translateY = -subPageHeight * (float)(totalVert - 1 - vertIndex);
            contentStream.saveGraphicsState();
            contentStream.addRect(0.0f, 0.0f, subPageWidth, subPageHeight);
            contentStream.clip();
            contentStream.transform(new Matrix(1.0f, 0.0f, 0.0f, 1.0f, translateX, translateY));
            contentStream.drawForm(form);
            contentStream.restoreGraphicsState();
        }
        catch (IOException e) {
            log.error("Error adding single section ({}, {}) for page {} to target", new Object[]{horizIndex, vertIndex, pageIndex, e});
            throw e;
        }
    }

    private void saveDocToZip(PDDocument doc, ZipOutputStream zipOut, String entryName) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        zipOut.putNextEntry(entry);
        doc.save((OutputStream)zipOut);
        zipOut.closeEntry();
    }

    private Set<Integer> getPagesToSplit(String pageNumbers, SplitTypes splitMode, int totalPages) {
        HashSet<Integer> pagesToSplit = new HashSet<Integer>();
        switch (1.$SwitchMap$stirling$software$SPDF$model$SplitTypes[splitMode.ordinal()]) {
            case 1: {
                if (pageNumbers == null || pageNumbers.isBlank()) {
                    throw ExceptionUtils.createIllegalArgumentException((String)"error.argumentRequired", (String)"{0} is required for {1} mode", (Object[])new Object[]{"page numbers", "custom"});
                }
                String[] pageOrderArr = pageNumbers.split(",");
                List pageListToSplit = GeneralUtils.parsePageList((String[])pageOrderArr, (int)totalPages, (boolean)false);
                pagesToSplit.addAll(pageListToSplit);
                break;
            }
            case 2: {
                pagesToSplit.addAll(IntStream.range(0, totalPages).boxed().toList());
                break;
            }
            case 3: {
                pagesToSplit.addAll(IntStream.range(1, totalPages).boxed().toList());
                break;
            }
            case 4: {
                pagesToSplit.addAll(IntStream.range(0, totalPages - 1).boxed().toList());
                break;
            }
            case 5: {
                pagesToSplit.addAll(IntStream.range(1, totalPages - 1).boxed().toList());
                break;
            }
            default: {
                throw ExceptionUtils.createIllegalArgumentException((String)"error.invalidFormat", (String)"Invalid {0} format: {1}", (Object[])new Object[]{"split mode", splitMode});
            }
        }
        return pagesToSplit;
    }

    @Generated
    public SplitPdfBySectionsController(CustomPDFDocumentFactory pdfDocumentFactory, TempFileManager tempFileManager) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.tempFileManager = tempFileManager;
    }
}

