/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.util.Iterator;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.general.RotatePDFRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.GeneralApi;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@GeneralApi
public class RotationController {
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/rotate-pdf"})
    @StandardPdfResponse
    @Operation(summary="Rotate a PDF file", description="This endpoint rotates a given PDF file by a specified angle. The angle must be a multiple of 90. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> rotatePDF(@ModelAttribute RotatePDFRequest request) throws IOException {
        MultipartFile pdfFile = request.getFileInput();
        Integer angle = request.getAngle();
        if (angle % 90 != 0) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.angleNotMultipleOf90", (String)"Angle must be a multiple of 90", (Object[])new Object[0]);
        }
        try (PDDocument document = this.pdfDocumentFactory.load((PDFFile)request);){
            PDPageTree pages = document.getPages();
            for (PDPage page : pages) {
                page.setRotation(page.getRotation() + angle);
            }
            Iterator iterator = WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)GeneralUtils.generateFilename((String)pdfFile.getOriginalFilename(), (String)"_rotated.pdf"));
            return iterator;
        }
    }

    @Generated
    public RotationController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

