/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import lombok.Generated;
import org.apache.pdfbox.multipdf.LayerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.model.api.general.MergeMultiplePagesRequest;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralFormCopyUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@RestController
@RequestMapping(value={"/api/v1/general"})
@Tag(name="General", description="General APIs")
public class MultiPageLayoutController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiPageLayoutController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @PostMapping(value={"/multi-page-layout"}, consumes={"multipart/form-data"})
    @Operation(summary="Merge multiple pages of a PDF document into a single page", description="This operation takes an input PDF file and the number of pages to merge into a single sheet in the output PDF file. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> mergeMultiplePagesIntoOne(@ModelAttribute MergeMultiplePagesRequest request) throws IOException {
        int pagesPerSheet = request.getPagesPerSheet();
        MultipartFile file = request.getFileInput();
        boolean addBorder = Boolean.TRUE.equals(request.getAddBorder());
        if (pagesPerSheet != 2 && pagesPerSheet != 3 && (double)pagesPerSheet != (double)((int)Math.sqrt(pagesPerSheet)) * Math.sqrt(pagesPerSheet)) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.invalidFormat", (String)"Invalid {0} format: {1}", (Object[])new Object[]{"pagesPerSheet", "must be 2, 3 or a perfect square"});
        }
        int cols = pagesPerSheet == 2 || pagesPerSheet == 3 ? pagesPerSheet : (int)Math.sqrt(pagesPerSheet);
        int rows = pagesPerSheet == 2 || pagesPerSheet == 3 ? 1 : (int)Math.sqrt(pagesPerSheet);
        try (PDDocument sourceDocument = this.pdfDocumentFactory.load(file);){
            ResponseEntity responseEntity;
            block24: {
                PDDocument newDocument = this.pdfDocumentFactory.createNewDocumentBasedOnOldDocument(sourceDocument);
                try {
                    int totalPages = sourceDocument.getNumberOfPages();
                    LayerUtility layerUtility = new LayerUtility(newDocument);
                    float cellWidth = PDRectangle.A4.getWidth() / (float)cols;
                    float cellHeight = PDRectangle.A4.getHeight() / (float)rows;
                    for (int i = 0; i < totalPages; i += pagesPerSheet) {
                        PDPage newPage = new PDPage(PDRectangle.A4);
                        newDocument.addPage(newPage);
                        try (PDPageContentStream contentStream = new PDPageContentStream(newDocument, newPage, PDPageContentStream.AppendMode.APPEND, true, true);){
                            float borderThickness = 1.5f;
                            contentStream.setLineWidth(borderThickness);
                            contentStream.setStrokingColor(Color.BLACK);
                            for (int j = 0; j < pagesPerSheet && i + j < totalPages; ++j) {
                                int pageIndex = i + j;
                                PDPage sourcePage = sourceDocument.getPage(pageIndex);
                                PDRectangle rect = sourcePage.getMediaBox();
                                float scaleWidth = cellWidth / rect.getWidth();
                                float scaleHeight = cellHeight / rect.getHeight();
                                float scale = Math.min(scaleWidth, scaleHeight);
                                int adjustedPageIndex = j % pagesPerSheet;
                                int rowIndex = adjustedPageIndex / cols;
                                int colIndex = adjustedPageIndex % cols;
                                float x = (float)colIndex * cellWidth + (cellWidth - rect.getWidth() * scale) / 2.0f;
                                float y = newPage.getMediaBox().getHeight() - ((float)(rowIndex + 1) * cellHeight - (cellHeight - rect.getHeight() * scale) / 2.0f);
                                contentStream.saveGraphicsState();
                                contentStream.transform(Matrix.getTranslateInstance((float)x, (float)y));
                                contentStream.transform(Matrix.getScaleInstance((float)scale, (float)scale));
                                PDFormXObject formXObject = layerUtility.importPageAsForm(sourceDocument, pageIndex);
                                contentStream.drawForm(formXObject);
                                contentStream.restoreGraphicsState();
                                if (!addBorder) continue;
                                float borderX = (float)colIndex * cellWidth;
                                float borderY = newPage.getMediaBox().getHeight() - (float)(rowIndex + 1) * cellHeight;
                                contentStream.addRect(borderX, borderY, cellWidth, cellHeight);
                                contentStream.stroke();
                            }
                            continue;
                        }
                    }
                    boolean hasRotation = GeneralFormCopyUtils.hasAnyRotatedPage((PDDocument)sourceDocument);
                    if (hasRotation) {
                        log.info("Source document has rotated pages; skipping form field copying.");
                    } else {
                        try {
                            GeneralFormCopyUtils.copyAndTransformFormFields((PDDocument)sourceDocument, (PDDocument)newDocument, (int)totalPages, (int)pagesPerSheet, (int)cols, (int)rows, (float)cellWidth, (float)cellHeight);
                        }
                        catch (Exception e) {
                            log.warn("Failed to copy and transform form fields: {}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    newDocument.save((OutputStream)baos);
                    byte[] result = baos.toByteArray();
                    responseEntity = WebResponseUtils.bytesToWebResponse((byte[])result, (String)GeneralUtils.generateFilename((String)file.getOriginalFilename(), (String)"_multi_page_layout.pdf"));
                    if (newDocument == null) break block24;
                }
                catch (Throwable throwable) {
                    if (newDocument != null) {
                        try {
                            newDocument.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                newDocument.close();
            }
            return responseEntity;
        }
    }

    @Generated
    public MultiPageLayoutController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

