/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import stirling.software.SPDF.config.EndpointConfiguration;

@Component
public class EndpointInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EndpointInterceptor.class);
    private final EndpointConfiguration endpointConfiguration;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean isEnabled;
        String requestURI = request.getRequestURI();
        if (requestURI.contains("/api/v1") && requestURI.split("/").length > 4) {
            String[] requestURIParts = requestURI.split("/");
            Object requestEndpoint = "convert".equals(requestURIParts[3]) && requestURIParts.length > 5 ? requestURIParts[4] + "-to-" + requestURIParts[5] : requestURIParts[4];
            log.debug("Request endpoint: {}", requestEndpoint);
            isEnabled = this.endpointConfiguration.isEndpointEnabled((String)requestEndpoint);
            log.debug("Is endpoint enabled: {}", (Object)isEnabled);
        } else {
            isEnabled = this.endpointConfiguration.isEndpointEnabled(requestURI);
        }
        if (!isEnabled) {
            response.sendError(403, "This endpoint is disabled");
            return false;
        }
        return true;
    }

    @Generated
    public EndpointInterceptor(EndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }
}

