/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service.pdfjson.type3;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import stirling.software.SPDF.model.json.PdfJsonFontConversionCandidate;
import stirling.software.SPDF.model.json.PdfJsonFontConversionStatus;
import stirling.software.SPDF.service.pdfjson.type3.Type3ConversionRequest;
import stirling.software.SPDF.service.pdfjson.type3.Type3ConversionStrategy;
import stirling.software.SPDF.service.pdfjson.type3.Type3GlyphContext;
import stirling.software.SPDF.service.pdfjson.type3.library.Type3FontLibrary;
import stirling.software.SPDF.service.pdfjson.type3.library.Type3FontLibraryEntry;
import stirling.software.SPDF.service.pdfjson.type3.library.Type3FontLibraryMatch;
import stirling.software.SPDF.service.pdfjson.type3.library.Type3FontLibraryPayload;
import stirling.software.common.model.ApplicationProperties;

@Component
@Order(value=0)
public class Type3LibraryStrategy
implements Type3ConversionStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Type3LibraryStrategy.class);
    private final Type3FontLibrary fontLibrary;
    private final ApplicationProperties applicationProperties;
    private boolean enabled;

    public String getId() {
        return "type3-library";
    }

    public String getLabel() {
        return "Type3 Font Library";
    }

    public boolean isAvailable() {
        return this.enabled && this.fontLibrary != null && this.fontLibrary.isLoaded();
    }

    @PostConstruct
    private void loadConfiguration() {
        if (this.applicationProperties.getPdfEditor() != null && this.applicationProperties.getPdfEditor().getType3() != null && this.applicationProperties.getPdfEditor().getType3().getLibrary() != null) {
            ApplicationProperties.PdfEditor.Type3.Library cfg = this.applicationProperties.getPdfEditor().getType3().getLibrary();
            this.enabled = cfg.isEnabled();
        } else {
            this.enabled = false;
            log.warn("PdfEditor Type3 library configuration not available, disabled");
        }
    }

    public PdfJsonFontConversionCandidate convert(Type3ConversionRequest request, Type3GlyphContext context) throws IOException {
        if (request == null || request.getFont() == null) {
            return PdfJsonFontConversionCandidate.builder().strategyId(this.getId()).strategyLabel(this.getLabel()).status(PdfJsonFontConversionStatus.FAILURE).message("No font supplied").build();
        }
        if (!this.isAvailable()) {
            return PdfJsonFontConversionCandidate.builder().strategyId(this.getId()).strategyLabel(this.getLabel()).status(PdfJsonFontConversionStatus.SKIPPED).message("Library disabled").build();
        }
        Type3FontLibraryMatch match = this.fontLibrary.match(request.getFont(), request.getFontUid());
        if (match == null || match.getEntry() == null) {
            return PdfJsonFontConversionCandidate.builder().strategyId(this.getId()).strategyLabel(this.getLabel()).status(PdfJsonFontConversionStatus.UNSUPPORTED).message("No library entry found").build();
        }
        Type3FontLibraryEntry entry = match.getEntry();
        if (!entry.hasAnyPayload()) {
            return PdfJsonFontConversionCandidate.builder().strategyId(this.getId()).strategyLabel(this.getLabel()).status(PdfJsonFontConversionStatus.FAILURE).message("Library entry has no payloads").build();
        }
        String message = String.format("Matched %s via %s", entry.getLabel(), match.getMatchType() != null ? match.getMatchType() : "alias");
        return PdfJsonFontConversionCandidate.builder().strategyId(this.getId()).strategyLabel(this.getLabel()).status(PdfJsonFontConversionStatus.SUCCESS).program(this.toBase64(entry.getProgram())).programFormat(this.toFormat(entry.getProgram())).webProgram(this.toBase64(entry.getWebProgram())).webProgramFormat(this.toFormat(entry.getWebProgram())).pdfProgram(this.toBase64(entry.getPdfProgram())).pdfProgramFormat(this.toFormat(entry.getPdfProgram())).glyphCoverage(entry.getGlyphCoverage()).message(message).build();
    }

    private String toBase64(Type3FontLibraryPayload payload) {
        return payload != null ? payload.getBase64() : null;
    }

    private String toFormat(Type3FontLibraryPayload payload) {
        return payload != null ? payload.getFormat() : null;
    }

    @Generated
    public Type3LibraryStrategy(Type3FontLibrary fontLibrary, ApplicationProperties applicationProperties) {
        this.fontLibrary = fontLibrary;
        this.applicationProperties = applicationProperties;
    }
}

