/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PageMode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.service.AttachmentServiceInterface;
import stirling.software.common.util.AttachmentUtils;

@Service
public class AttachmentService
implements AttachmentServiceInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttachmentService.class);

    public PDDocument addAttachment(PDDocument document, List<MultipartFile> attachments) throws IOException {
        HashMap existingNames;
        PDEmbeddedFilesNameTreeNode embeddedFilesTree = this.getEmbeddedFilesTree(document);
        try {
            Map names = embeddedFilesTree.getNames();
            if (names == null) {
                log.debug("No existing embedded files found, creating new names map.");
                existingNames = new HashMap();
            } else {
                existingNames = new HashMap(names);
                log.debug("Embedded files: {}", existingNames.keySet());
            }
        }
        catch (IOException e) {
            log.error("Could not retrieve existing embedded files", (Throwable)e);
            throw e;
        }
        attachments.forEach(attachment -> {
            String filename = attachment.getOriginalFilename();
            try {
                PDEmbeddedFile embeddedFile = new PDEmbeddedFile(document, attachment.getInputStream());
                embeddedFile.setSize((int)attachment.getSize());
                Instant now = Instant.now();
                GregorianCalendar nowCal = GregorianCalendar.from(ZonedDateTime.ofInstant(now, ZoneId.systemDefault()));
                embeddedFile.setCreationDate((Calendar)nowCal);
                embeddedFile.setModDate((Calendar)nowCal);
                String contentType = attachment.getContentType();
                if (StringUtils.isNotBlank((CharSequence)contentType)) {
                    embeddedFile.setSubtype(contentType);
                }
                PDComplexFileSpecification fileSpecification = new PDComplexFileSpecification();
                fileSpecification.setFile(filename);
                fileSpecification.setFileUnicode(filename);
                fileSpecification.setFileDescription("Embedded attachment: " + filename);
                fileSpecification.setEmbeddedFile(embeddedFile);
                fileSpecification.setEmbeddedFileUnicode(embeddedFile);
                existingNames.put(filename, fileSpecification);
                log.info("Added attachment: {} ({} bytes)", (Object)filename, (Object)attachment.getSize());
            }
            catch (IOException e) {
                log.warn("Failed to create embedded file for attachment: {}", (Object)filename, (Object)e);
            }
        });
        embeddedFilesTree.setNames(existingNames);
        AttachmentUtils.setCatalogViewerPreferences((PDDocument)document, (PageMode)PageMode.USE_ATTACHMENTS);
        return document;
    }

    private PDEmbeddedFilesNameTreeNode getEmbeddedFilesTree(PDDocument document) {
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        PDDocumentNameDictionary documentNames = catalog.getNames();
        if (documentNames == null) {
            documentNames = new PDDocumentNameDictionary(catalog);
        }
        catalog.setNames(documentNames);
        PDEmbeddedFilesNameTreeNode embeddedFilesTree = documentNames.getEmbeddedFiles();
        if (embeddedFilesTree == null) {
            embeddedFilesTree = new PDEmbeddedFilesNameTreeNode();
            documentNames.setEmbeddedFiles(embeddedFilesTree);
        }
        return embeddedFilesTree;
    }
}

