/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.web;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import stirling.software.common.configuration.InstallationPathConfig;

@Controller
public class ReactRoutingController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactRoutingController.class);
    @Value(value="${server.servlet.context-path:/}")
    private String contextPath;
    private String cachedIndexHtml;
    private boolean indexHtmlExists = false;
    private boolean useExternalIndexHtml = false;

    @PostConstruct
    public void init() {
        ClassPathResource resource;
        log.info("Static files custom path: {}", (Object)InstallationPathConfig.getStaticPath());
        Path externalIndexPath = Paths.get(InstallationPathConfig.getStaticPath(), "index.html");
        log.debug("Checking for custom index.html at: {}", (Object)externalIndexPath);
        if (Files.exists(externalIndexPath, new LinkOption[0]) && Files.isReadable(externalIndexPath)) {
            log.info("Using custom index.html from: {}", (Object)externalIndexPath);
            try {
                this.cachedIndexHtml = this.processIndexHtml();
                this.indexHtmlExists = true;
                this.useExternalIndexHtml = true;
                return;
            }
            catch (IOException e) {
                log.warn("Failed to load custom index.html, falling back to classpath", (Throwable)e);
            }
        }
        if ((resource = new ClassPathResource("static/index.html")).exists()) {
            try {
                this.cachedIndexHtml = this.processIndexHtml();
                this.indexHtmlExists = true;
                this.useExternalIndexHtml = false;
            }
            catch (IOException e) {
                log.warn("Failed to cache index.html", (Throwable)e);
                this.indexHtmlExists = false;
            }
        }
    }

    private String processIndexHtml() throws IOException {
        Resource resource = this.getIndexHtmlResource();
        try (InputStream inputStream = resource.getInputStream();){
            String html = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            Object baseUrl = this.contextPath.endsWith("/") ? this.contextPath : this.contextPath + "/";
            html = html.replace("%BASE_URL%", (CharSequence)baseUrl);
            html = html.replaceFirst("<base href=\\\"[^\\\"]*\\\"\\s*/?>", "<base href=\\\"" + (String)baseUrl + "\\\" />");
            String contextPathScript = "<script>window.STIRLING_PDF_API_BASE_URL = '" + (String)baseUrl + "';</script>";
            String string = html = html.replace("</head>", contextPathScript + "</head>");
            return string;
        }
    }

    private Resource getIndexHtmlResource() throws IOException {
        Path externalIndexPath = Paths.get(InstallationPathConfig.getStaticPath(), "index.html");
        if (Files.exists(externalIndexPath, new LinkOption[0]) && Files.isReadable(externalIndexPath)) {
            return new FileSystemResource(externalIndexPath.toFile());
        }
        return new ClassPathResource("static/index.html");
    }

    @GetMapping(value={"/", "/index.html"}, produces={"text/html"})
    public ResponseEntity<String> serveIndexHtml(HttpServletRequest request) throws IOException {
        if (this.indexHtmlExists && this.cachedIndexHtml != null) {
            return ResponseEntity.ok().contentType(MediaType.TEXT_HTML).body((Object)this.cachedIndexHtml);
        }
        return ResponseEntity.ok().contentType(MediaType.TEXT_HTML).body((Object)this.processIndexHtml());
    }

    @GetMapping(value={"/{path:^(?!api|static|robots\\.txt|favicon\\.ico|manifest.*\\.json|pipeline|pdfjs|pdfjs-legacy|pdfium|fonts|images|files|css|js|assets|locales|modern-logo|classic-logo|Login|og_images|samples)[^\\.]*$}"})
    public ResponseEntity<String> forwardRootPaths(HttpServletRequest request) throws IOException {
        return this.serveIndexHtml(request);
    }

    @GetMapping(value={"/{path:^(?!api|static|pipeline|pdfjs|pdfjs-legacy|pdfium|fonts|images|files|css|js|assets|locales|modern-logo|classic-logo|Login|og_images|samples)[^\\.]*}/{subpath:^(?!.*\\.).*$}"})
    public ResponseEntity<String> forwardNestedPaths(HttpServletRequest request) throws IOException {
        return this.serveIndexHtml(request);
    }
}

