/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.security;

import io.swagger.v3.oas.annotations.Operation;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.security.AddWatermarkRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.SecurityApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.PdfUtils;
import stirling.software.common.util.RegexPatternUtils;
import stirling.software.common.util.WebResponseUtils;

@SecurityApi
public class WatermarkController {
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(MultipartFile.class, (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/add-watermark"})
    @StandardPdfResponse
    @Operation(summary="Add watermark to a PDF file", description="This endpoint adds a watermark to a given PDF file. Users can specify the watermark type (text or image), rotation, opacity, width spacer, and height spacer. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> addWatermark(@ModelAttribute AddWatermarkRequest request) throws IOException, Exception {
        String watermarkImageFileName;
        MultipartFile pdfFile = request.getFileInput();
        String pdfFileName = pdfFile.getOriginalFilename();
        if (pdfFileName != null && (pdfFileName.contains("..") || pdfFileName.startsWith("/"))) {
            throw new SecurityException("Invalid file path in pdfFile");
        }
        String watermarkType = request.getWatermarkType();
        String watermarkText = request.getWatermarkText();
        MultipartFile watermarkImage = request.getWatermarkImage();
        if (watermarkImage != null && (watermarkImageFileName = watermarkImage.getOriginalFilename()) != null && (watermarkImageFileName.contains("..") || watermarkImageFileName.startsWith("/"))) {
            throw new SecurityException("Invalid file path in watermarkImage");
        }
        String alphabet = request.getAlphabet();
        float fontSize = request.getFontSize();
        float rotation = request.getRotation();
        float opacity = request.getOpacity();
        int widthSpacer = request.getWidthSpacer();
        int heightSpacer = request.getHeightSpacer();
        String customColor = request.getCustomColor();
        boolean convertPdfToImage = Boolean.TRUE.equals(request.getConvertPDFToImage());
        PDDocument document = this.pdfDocumentFactory.load(pdfFile);
        for (PDPage page : document.getPages()) {
            PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);
            PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
            graphicsState.setNonStrokingAlphaConstant(Float.valueOf(opacity));
            contentStream.setGraphicsStateParameters(graphicsState);
            if ("text".equalsIgnoreCase(watermarkType)) {
                this.addTextWatermark(contentStream, watermarkText, document, page, rotation, widthSpacer, heightSpacer, fontSize, alphabet, customColor);
            } else if ("image".equalsIgnoreCase(watermarkType)) {
                this.addImageWatermark(contentStream, watermarkImage, document, page, rotation, widthSpacer, heightSpacer, fontSize);
            }
            contentStream.close();
        }
        if (convertPdfToImage) {
            PDDocument convertedPdf = PdfUtils.convertPdfToPdfImage((PDDocument)document);
            document.close();
            document = convertedPdf;
        }
        return WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)GeneralUtils.generateFilename((String)pdfFile.getOriginalFilename(), (String)"_watermarked.pdf"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTextWatermark(PDPageContentStream contentStream, String watermarkText, PDDocument document, PDPage page, float rotation, int widthSpacer, int heightSpacer, float fontSize, String alphabet, String colorString) throws IOException {
        Color redactColor;
        String resourceDir = "";
        PDType1Font font = new PDType1Font(Standard14Fonts.FontName.HELVETICA);
        resourceDir = switch (alphabet) {
            case "arabic" -> "static/fonts/NotoSansArabic-Regular.ttf";
            case "japanese" -> "static/fonts/NotoSansJP-Regular.ttf";
            case "korean" -> "static/fonts/NotoSansKR-Regular.ttf";
            case "chinese" -> "static/fonts/NotoSansSC-Regular.ttf";
            case "thai" -> "static/fonts/NotoSansThai-Regular.ttf";
            default -> "static/fonts/NotoSans-Regular.ttf";
        };
        ClassPathResource classPathResource = new ClassPathResource(resourceDir);
        String fileExtension = resourceDir.substring(resourceDir.lastIndexOf("."));
        File tempFile = Files.createTempFile("NotoSansFont", fileExtension, new FileAttribute[0]).toFile();
        try (InputStream is = classPathResource.getInputStream();
             FileOutputStream os = new FileOutputStream(tempFile);){
            IOUtils.copy((InputStream)is, (OutputStream)os);
            font = PDType0Font.load((PDDocument)document, (File)tempFile);
        }
        finally {
            Files.deleteIfExists(tempFile.toPath());
        }
        contentStream.setFont((PDFont)font, fontSize);
        try {
            if (!((String)colorString).startsWith("#")) {
                colorString = "#" + (String)colorString;
            }
            redactColor = Color.decode((String)colorString);
        }
        catch (NumberFormatException e) {
            redactColor = Color.LIGHT_GRAY;
        }
        contentStream.setNonStrokingColor(redactColor);
        String[] textLines = RegexPatternUtils.getInstance().getEscapedNewlinePattern().split(watermarkText);
        float maxLineWidth = 0.0f;
        for (int i = 0; i < textLines.length; ++i) {
            maxLineWidth = Math.max(maxLineWidth, font.getStringWidth(textLines[i]));
        }
        float watermarkWidth = (float)widthSpacer + maxLineWidth * fontSize / 1000.0f;
        float watermarkHeight = (float)heightSpacer + fontSize * (float)textLines.length;
        float pageWidth = page.getMediaBox().getWidth();
        float pageHeight = page.getMediaBox().getHeight();
        float radians = (float)Math.toRadians(rotation);
        float newWatermarkWidth = (float)(Math.abs((double)watermarkWidth * Math.cos(radians)) + Math.abs((double)watermarkHeight * Math.sin(radians)));
        float newWatermarkHeight = (float)(Math.abs((double)watermarkWidth * Math.sin(radians)) + Math.abs((double)watermarkHeight * Math.cos(radians)));
        int watermarkRows = (int)(pageHeight / newWatermarkHeight + 1.0f);
        int watermarkCols = (int)(pageWidth / newWatermarkWidth + 1.0f);
        for (int i = 0; i <= watermarkRows; ++i) {
            for (int j = 0; j <= watermarkCols; ++j) {
                contentStream.beginText();
                contentStream.setTextMatrix(Matrix.getRotateInstance((double)((float)Math.toRadians(rotation)), (float)((float)j * newWatermarkWidth), (float)((float)i * newWatermarkHeight)));
                for (int k = 0; k < textLines.length; ++k) {
                    contentStream.showText(textLines[k]);
                    contentStream.newLineAtOffset(0.0f, -fontSize);
                }
                contentStream.endText();
            }
        }
    }

    private void addImageWatermark(PDPageContentStream contentStream, MultipartFile watermarkImage, PDDocument document, PDPage page, float rotation, int widthSpacer, int heightSpacer, float fontSize) throws IOException {
        BufferedImage image = ImageIO.read(watermarkImage.getInputStream());
        float aspectRatio = (float)image.getWidth() / (float)image.getHeight();
        float desiredPhysicalHeight = fontSize;
        float desiredPhysicalWidth = desiredPhysicalHeight * aspectRatio;
        PDImageXObject xobject = LosslessFactory.createFromImage((PDDocument)document, (BufferedImage)image);
        float pageWidth = page.getMediaBox().getWidth();
        float pageHeight = page.getMediaBox().getHeight();
        int watermarkRows = (int)((pageHeight + (float)heightSpacer) / (desiredPhysicalHeight + (float)heightSpacer));
        int watermarkCols = (int)((pageWidth + (float)widthSpacer) / (desiredPhysicalWidth + (float)widthSpacer));
        for (int i = 0; i < watermarkRows; ++i) {
            for (int j = 0; j < watermarkCols; ++j) {
                float x = (float)j * (desiredPhysicalWidth + (float)widthSpacer);
                float y = (float)i * (desiredPhysicalHeight + (float)heightSpacer);
                contentStream.saveGraphicsState();
                contentStream.transform(Matrix.getTranslateInstance((float)(x + desiredPhysicalWidth / 2.0f), (float)(y + desiredPhysicalHeight / 2.0f)));
                contentStream.transform(Matrix.getRotateInstance((double)Math.toRadians(rotation), (float)0.0f, (float)0.0f));
                contentStream.transform(Matrix.getTranslateInstance((float)(-desiredPhysicalWidth / 2.0f), (float)(-desiredPhysicalHeight / 2.0f)));
                contentStream.drawImage(xobject, 0.0f, 0.0f, desiredPhysicalWidth, desiredPhysicalHeight);
                contentStream.restoreGraphicsState();
            }
        }
    }

    @Generated
    public WatermarkController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

