/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.MiscApi;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

@MiscApi
public class RepairController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RepairController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final TempFileManager tempFileManager;
    private final EndpointConfiguration endpointConfiguration;

    private boolean isGhostscriptEnabled() {
        return this.endpointConfiguration.isGroupEnabled("Ghostscript");
    }

    private boolean isQpdfEnabled() {
        return this.endpointConfiguration.isGroupEnabled("qpdf");
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/repair"})
    @StandardPdfResponse
    @Operation(summary="Repair a PDF file", description="This endpoint repairs a given PDF file by running Ghostscript (primary), qpdf (fallback), or PDFBox (if no external tools available). The PDF is first saved to a temporary location, repaired, read back, and then returned as a response. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> repairPdf(@ModelAttribute PDFFile file) throws IOException, InterruptedException {
        MultipartFile inputFile = file.getFileInput();
        try (TempFile tempInputFile = new TempFile(this.tempFileManager, ".pdf");){
            ResponseEntity responseEntity;
            try (TempFile tempOutputFile = new TempFile(this.tempFileManager, ".pdf");){
                inputFile.transferTo(tempInputFile.getFile());
                boolean repairSuccess = false;
                if (this.isGhostscriptEnabled()) {
                    try {
                        ArrayList<String> gsCommand = new ArrayList<String>();
                        gsCommand.add("gs");
                        gsCommand.add("-o");
                        gsCommand.add(tempOutputFile.getPath().toString());
                        gsCommand.add("-sDEVICE=pdfwrite");
                        gsCommand.add(tempInputFile.getPath().toString());
                        ProcessExecutor.ProcessExecutorResult gsResult = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.GHOSTSCRIPT).runCommandWithOutputHandling(gsCommand);
                        if (gsResult.getRc() == 0) {
                            repairSuccess = true;
                        }
                    }
                    catch (Exception e) {
                        log.warn("Ghostscript repair failed, trying QPDF fallback: ", (Throwable)e);
                    }
                }
                if (!repairSuccess && this.isQpdfEnabled()) {
                    ArrayList<String> qpdfCommand = new ArrayList<String>();
                    qpdfCommand.add("qpdf");
                    qpdfCommand.add("--replace-input");
                    qpdfCommand.add("--qdf");
                    qpdfCommand.add("--object-streams=disable");
                    qpdfCommand.add(tempInputFile.getPath().toString());
                    qpdfCommand.add(tempOutputFile.getPath().toString());
                    ProcessExecutor.ProcessExecutorResult qpdfResult = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.QPDF).runCommandWithOutputHandling(qpdfCommand);
                    repairSuccess = true;
                }
                if (!repairSuccess) {
                    if (!this.isGhostscriptEnabled() && !this.isQpdfEnabled()) {
                        try (PDDocument document = this.pdfDocumentFactory.load(tempInputFile.getFile());){
                            document.save(tempOutputFile.getFile());
                            repairSuccess = true;
                        }
                    } else {
                        throw new IOException("PDF repair failed with available tools");
                    }
                }
                byte[] pdfBytes = this.pdfDocumentFactory.loadToBytes(tempOutputFile.getFile());
                responseEntity = WebResponseUtils.bytesToWebResponse((byte[])pdfBytes, (String)GeneralUtils.generateFilename((String)inputFile.getOriginalFilename(), (String)"_repaired.pdf"));
            }
            return responseEntity;
        }
    }

    @Generated
    public RepairController(CustomPDFDocumentFactory pdfDocumentFactory, TempFileManager tempFileManager, EndpointConfiguration endpointConfiguration) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.tempFileManager = tempFileManager;
        this.endpointConfiguration = endpointConfiguration;
    }
}

