/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import java.awt.image.BufferedImage;
import java.io.IOException;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.misc.FlattenRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.MiscApi;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ApplicationContextProvider;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.WebResponseUtils;

@MiscApi
public class FlattenController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlattenController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/flatten"})
    @StandardPdfResponse
    @Operation(summary="Flatten PDF form fields or full page", description="Flattening just PDF form fields or converting each page to images to make text unselectable. Input:PDF, Output:PDF. Type:SISO")
    public ResponseEntity<byte[]> flatten(@ModelAttribute FlattenRequest request) throws Exception {
        MultipartFile file = request.getFileInput();
        PDDocument document = this.pdfDocumentFactory.load(file);
        Boolean flattenOnlyForms = request.getFlattenOnlyForms();
        if (Boolean.TRUE.equals(flattenOnlyForms)) {
            PDAcroForm acroForm = document.getDocumentCatalog().getAcroForm();
            if (acroForm != null) {
                acroForm.flatten();
            }
            return WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)Filenames.toSimpleFileName((String)file.getOriginalFilename()));
        }
        PDFRenderer pdfRenderer = new PDFRenderer(document);
        PDDocument newDocument = this.pdfDocumentFactory.createNewDocumentBasedOnOldDocument(document);
        int numPages = document.getNumberOfPages();
        for (int i = 0; i < numPages; ++i) {
            try {
                BufferedImage image;
                int renderDpi = 300;
                ApplicationProperties properties = (ApplicationProperties)ApplicationContextProvider.getBean(ApplicationProperties.class);
                if (properties != null && properties.getSystem() != null) {
                    renderDpi = properties.getSystem().getMaxDPI();
                }
                try {
                    image = pdfRenderer.renderImageWithDPI(i, (float)renderDpi, ImageType.RGB);
                }
                catch (OutOfMemoryError e) {
                    throw ExceptionUtils.createOutOfMemoryDpiException((int)(i + 1), (int)renderDpi, (OutOfMemoryError)e);
                }
                catch (NegativeArraySizeException e) {
                    throw ExceptionUtils.createOutOfMemoryDpiException((int)(i + 1), (int)renderDpi, (Throwable)e);
                }
                PDPage page = new PDPage();
                page.setMediaBox(document.getPage(i).getMediaBox());
                newDocument.addPage(page);
                try (PDPageContentStream contentStream = new PDPageContentStream(newDocument, page);){
                    PDImageXObject pdImage = JPEGFactory.createFromImage((PDDocument)newDocument, (BufferedImage)image);
                    float pageWidth = page.getMediaBox().getWidth();
                    float pageHeight = page.getMediaBox().getHeight();
                    contentStream.drawImage(pdImage, 0.0f, 0.0f, pageWidth, pageHeight);
                    continue;
                }
            }
            catch (IOException e) {
                log.error("exception", (Throwable)e);
            }
        }
        return WebResponseUtils.pdfDocToWebResponse((PDDocument)newDocument, (String)Filenames.toSimpleFileName((String)file.getOriginalFilename()));
    }

    @Generated
    public FlattenController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

