/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.swagger.v3.oas.annotations.Operation;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import lombok.Generated;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;
import stirling.software.SPDF.config.EndpointConfiguration;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.controller.api.misc.CompressController;
import stirling.software.SPDF.model.api.misc.OptimizePdfRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.MiscApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.service.LineArtConversionService;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.WebResponseUtils;

@MiscApi
public class CompressController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompressController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final EndpointConfiguration endpointConfiguration;
    @Autowired(required=false)
    private LineArtConversionService lineArtConversionService;

    private boolean isQpdfEnabled() {
        return this.endpointConfiguration.isGroupEnabled("qpdf");
    }

    private boolean isGhostscriptEnabled() {
        return this.endpointConfiguration.isGroupEnabled("Ghostscript");
    }

    private boolean isImageMagickEnabled() {
        return this.endpointConfiguration.isGroupEnabled("ImageMagick");
    }

    public Path compressImagesInPDF(Path pdfFile, double scaleFactor, float jpegQuality, boolean convertToGrayscale) throws Exception {
        Path newCompressedPDF = Files.createTempFile("compressedPDF", ".pdf", new FileAttribute[0]);
        long originalFileSize = Files.size(pdfFile);
        log.info("Starting image compression with scale factor: {}, JPEG quality: {}, grayscale: {} on file size: {}", new Object[]{scaleFactor, Float.valueOf(jpegQuality), convertToGrayscale, GeneralUtils.formatBytes((long)originalFileSize)});
        try (PDDocument doc = this.pdfDocumentFactory.load(pdfFile);){
            Map uniqueImages = this.findImages(doc);
            CompressionStats stats = new CompressionStats();
            stats.uniqueImagesCount = uniqueImages.size();
            this.calculateImageStats(uniqueImages, stats);
            Map compressedVersions = this.createCompressedImages(doc, uniqueImages, scaleFactor, jpegQuality, convertToGrayscale, stats);
            this.replaceImages(doc, uniqueImages, compressedVersions, stats);
            this.logCompressionStats(stats, originalFileSize);
            compressedVersions.clear();
            uniqueImages.clear();
            log.info("Saving compressed PDF to {}", (Object)newCompressedPDF.toString());
            doc.save(newCompressedPDF.toString());
            long compressedFileSize = Files.size(newCompressedPDF);
            double overallReduction = 100.0 - (double)compressedFileSize * 100.0 / (double)originalFileSize;
            log.info("Overall PDF compression: {} \u2192 {} (reduced by {}%)", new Object[]{GeneralUtils.formatBytes((long)originalFileSize), GeneralUtils.formatBytes((long)compressedFileSize), String.format("%.1f", overallReduction)});
            Path path = newCompressedPDF;
            return path;
        }
    }

    private Map<String, List<ImageReference>> findImages(PDDocument doc) throws IOException {
        HashMap<String, List<ImageReference>> uniqueImages = new HashMap<String, List<ImageReference>>();
        for (int pageNum = 0; pageNum < doc.getNumberOfPages(); ++pageNum) {
            PDPage page = doc.getPage(pageNum);
            PDResources res = page.getResources();
            if (res == null || res.getXObjectNames() == null) continue;
            for (COSName name : res.getXObjectNames()) {
                PDXObject xobj = res.getXObject(name);
                if (this.isImage(xobj)) {
                    this.addDirectImage(pageNum, name, (PDImageXObject)xobj, uniqueImages);
                    log.info("Found direct image '{}' on page {} - {}x{}", new Object[]{name.getName(), pageNum + 1, ((PDImageXObject)xobj).getWidth(), ((PDImageXObject)xobj).getHeight()});
                    continue;
                }
                if (!this.isForm(xobj)) continue;
                this.checkFormForImages(pageNum, name, (PDFormXObject)xobj, uniqueImages);
            }
        }
        return uniqueImages;
    }

    private boolean isImage(PDXObject xobj) {
        return xobj instanceof PDImageXObject;
    }

    private boolean isForm(PDXObject xobj) {
        return xobj instanceof PDFormXObject;
    }

    private ImageReference addDirectImage(int pageNum, COSName name, PDImageXObject image, Map<String, List<ImageReference>> uniqueImages) throws IOException {
        ImageReference ref = new ImageReference();
        ref.pageNum = pageNum;
        ref.name = name;
        String imageHash = this.generateImageHash(image);
        uniqueImages.computeIfAbsent(imageHash, k -> new ArrayList()).add(ref);
        return ref;
    }

    private void checkFormForImages(int pageNum, COSName formName, PDFormXObject formXObj, Map<String, List<ImageReference>> uniqueImages) throws IOException {
        PDResources formResources = formXObj.getResources();
        if (formResources == null || formResources.getXObjectNames() == null) {
            return;
        }
        log.info("Checking form XObject '{}' on page {} for nested images", (Object)formName.getName(), (Object)(pageNum + 1));
        for (COSName nestedName : formResources.getXObjectNames()) {
            PDXObject nestedXobj = formResources.getXObject(nestedName);
            if (!this.isImage(nestedXobj)) continue;
            PDImageXObject nestedImage = (PDImageXObject)nestedXobj;
            log.info("Found nested image '{}' in form '{}' on page {} - {}x{}", new Object[]{nestedName.getName(), formName.getName(), pageNum + 1, nestedImage.getWidth(), nestedImage.getHeight()});
            NestedImageReference nestedRef = new NestedImageReference();
            nestedRef.pageNum = pageNum;
            nestedRef.formName = formName;
            nestedRef.imageName = nestedName;
            String imageHash = this.generateImageHash(nestedImage);
            uniqueImages.computeIfAbsent(imageHash, k -> new ArrayList()).add(nestedRef);
        }
    }

    private void calculateImageStats(Map<String, List<ImageReference>> uniqueImages, CompressionStats stats) {
        for (List<ImageReference> references : uniqueImages.values()) {
            for (ImageReference ref : references) {
                ++stats.totalImages;
                if (!(ref instanceof NestedImageReference)) continue;
                ++stats.nestedImages;
            }
        }
    }

    private Map<String, PDImageXObject> createCompressedImages(PDDocument doc, Map<String, List<ImageReference>> uniqueImages, double scaleFactor, float jpegQuality, boolean convertToGrayscale, CompressionStats stats) throws IOException {
        HashMap<String, PDImageXObject> compressedVersions = new HashMap<String, PDImageXObject>();
        for (Map.Entry<String, List<ImageReference>> entry : uniqueImages.entrySet()) {
            String imageHash = entry.getKey();
            List<ImageReference> references = entry.getValue();
            if (references.isEmpty()) continue;
            PDImageXObject originalImage = this.getOriginalImage(doc, references.get(0));
            int originalSize = (int)originalImage.getCOSObject().getLength();
            stats.totalOriginalBytes += (long)originalSize;
            PDImageXObject compressedImage = this.compressImage(doc, originalImage, originalSize, scaleFactor, jpegQuality, convertToGrayscale);
            if (compressedImage != null) {
                compressedVersions.put(imageHash, compressedImage);
                ++stats.compressedImages;
                int compressedSize = (int)compressedImage.getCOSObject().getLength();
                stats.totalCompressedBytes += (long)(compressedSize * references.size());
                double reductionPercentage = 100.0 - (double)compressedSize * 100.0 / (double)originalSize;
                log.info("Image hash {}: Compressed from {} to {} (reduced by {}%)", new Object[]{imageHash, GeneralUtils.formatBytes((long)originalSize), GeneralUtils.formatBytes((long)compressedSize), String.format("%.1f", reductionPercentage)});
                continue;
            }
            log.info("Image hash {}: Not suitable for compression, skipping", (Object)imageHash);
            stats.totalCompressedBytes += (long)(originalSize * references.size());
            ++stats.skippedImages;
        }
        return compressedVersions;
    }

    private PDImageXObject getOriginalImage(PDDocument doc, ImageReference ref) throws IOException {
        if (ref instanceof NestedImageReference) {
            NestedImageReference nestedRef = (NestedImageReference)ref;
            PDPage page = doc.getPage(nestedRef.pageNum);
            PDResources pageResources = page.getResources();
            PDFormXObject formXObj = (PDFormXObject)pageResources.getXObject(nestedRef.formName);
            PDResources formResources = formXObj.getResources();
            return (PDImageXObject)formResources.getXObject(nestedRef.imageName);
        }
        PDPage page = doc.getPage(ref.pageNum);
        PDResources resources = page.getResources();
        return (PDImageXObject)resources.getXObject(ref.name);
    }

    private PDImageXObject compressImage(PDDocument doc, PDImageXObject originalImage, int originalSize, double scaleFactor, float jpegQuality, boolean convertToGrayscale) throws IOException {
        BufferedImage processedImage = this.processAndCompressImage(originalImage, scaleFactor, jpegQuality, convertToGrayscale);
        if (processedImage == null) {
            return null;
        }
        byte[] compressedData = this.convertToBytes(processedImage, jpegQuality);
        if (compressedData.length < originalSize || convertToGrayscale) {
            return PDImageXObject.createFromByteArray((PDDocument)doc, (byte[])compressedData, (String)originalImage.getCOSObject().toString());
        }
        return null;
    }

    private void replaceImages(PDDocument doc, Map<String, List<ImageReference>> uniqueImages, Map<String, PDImageXObject> compressedVersions, CompressionStats stats) throws IOException {
        for (Map.Entry<String, List<ImageReference>> entry : uniqueImages.entrySet()) {
            String imageHash = entry.getKey();
            List<ImageReference> references = entry.getValue();
            PDImageXObject compressedImage = compressedVersions.get(imageHash);
            if (compressedImage == null) continue;
            for (ImageReference ref : references) {
                this.replaceImageReference(doc, ref, compressedImage);
            }
        }
    }

    private void replaceImageReference(PDDocument doc, ImageReference ref, PDImageXObject compressedImage) throws IOException {
        if (ref instanceof NestedImageReference) {
            NestedImageReference nestedRef = (NestedImageReference)ref;
            PDPage page = doc.getPage(nestedRef.pageNum);
            PDResources pageResources = page.getResources();
            PDFormXObject formXObj = (PDFormXObject)pageResources.getXObject(nestedRef.formName);
            PDResources formResources = formXObj.getResources();
            formResources.put(nestedRef.imageName, (PDXObject)compressedImage);
            log.info("Replaced nested image '{}' in form '{}' on page {} with compressed version", new Object[]{nestedRef.imageName.getName(), nestedRef.formName.getName(), nestedRef.pageNum + 1});
        } else {
            PDPage page = doc.getPage(ref.pageNum);
            PDResources resources = page.getResources();
            resources.put(ref.name, (PDXObject)compressedImage);
            log.info("Replaced direct image on page {} with compressed version", (Object)(ref.pageNum + 1));
        }
    }

    private void logCompressionStats(CompressionStats stats, long originalFileSize) {
        double overallImageReduction = stats.totalOriginalBytes > 0L ? 100.0 - (double)stats.totalCompressedBytes * 100.0 / (double)stats.totalOriginalBytes : 0.0;
        int duplicatedImages = stats.totalImages - stats.uniqueImagesCount;
        log.info("Image compression summary - Total unique: {}, Compressed: {}, Skipped: {}, Duplicates: {}, Nested: {}", new Object[]{stats.uniqueImagesCount, stats.compressedImages, stats.skippedImages, duplicatedImages, stats.nestedImages});
        log.info("Total original image size: {}, compressed: {} (reduced by {}%)", new Object[]{GeneralUtils.formatBytes((long)stats.totalOriginalBytes), GeneralUtils.formatBytes((long)stats.totalCompressedBytes), String.format("%.1f", overallImageReduction)});
    }

    private BufferedImage convertToGrayscale(BufferedImage image) {
        BufferedImage grayImage = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        Graphics2D g = grayImage.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return grayImage;
    }

    private BufferedImage processAndCompressImage(PDImageXObject image, double scaleFactor, float jpegQuality, boolean convertToGrayscale) throws IOException {
        BufferedImage bufferedImage = image.getImage();
        int originalWidth = bufferedImage.getWidth();
        int originalHeight = bufferedImage.getHeight();
        int MIN_WIDTH = 400;
        int MIN_HEIGHT = 400;
        log.info("Original dimensions: {}x{}", (Object)originalWidth, (Object)originalHeight);
        if (!(originalWidth > MIN_WIDTH && originalHeight > MIN_HEIGHT || convertToGrayscale)) {
            log.info("Skipping - below minimum dimensions threshold");
            return null;
        }
        if (convertToGrayscale) {
            bufferedImage = this.convertToGrayscale(bufferedImage);
            log.info("Converted image to grayscale");
        }
        double adjustedScaleFactor = scaleFactor;
        if (originalWidth > 3000 || originalHeight > 3000) {
            adjustedScaleFactor = Math.min(scaleFactor, 0.75);
            log.info("Very large image, using more aggressive scale: {}", (Object)adjustedScaleFactor);
        } else if (originalWidth < 1000 || originalHeight < 1000) {
            adjustedScaleFactor = Math.max(scaleFactor, 0.9);
            log.info("Smaller image, using conservative scale: {}", (Object)adjustedScaleFactor);
        }
        int newWidth = (int)((double)originalWidth * adjustedScaleFactor);
        int newHeight = (int)((double)originalHeight * adjustedScaleFactor);
        newWidth = Math.max(newWidth, MIN_WIDTH);
        newHeight = Math.max(newHeight, MIN_HEIGHT);
        if ((double)newWidth / (double)originalWidth > 0.95 && (double)newHeight / (double)originalHeight > 0.95 && !convertToGrayscale) {
            log.info("Change too small, skipping compression");
            return null;
        }
        log.info("Resizing to {}x{} ({}% of original)", new Object[]{newWidth, newHeight, Math.round((double)newWidth * 100.0 / (double)originalWidth)});
        BufferedImage scaledImage = convertToGrayscale ? new BufferedImage(newWidth, newHeight, 10) : new BufferedImage(newWidth, newHeight, bufferedImage.getColorModel().hasAlpha() ? 2 : 1);
        Graphics2D g2d = scaledImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawImage(bufferedImage, 0, 0, newWidth, newHeight, null);
        g2d.dispose();
        return scaledImage;
    }

    private byte[] convertToBytes(BufferedImage scaledImage, float jpegQuality) throws IOException {
        String format = scaledImage.getColorModel().hasAlpha() ? "png" : "jpeg";
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if ("jpeg".equals(format)) {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter writer = writers.next();
            JPEGImageWriteParam param = (JPEGImageWriteParam)writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(jpegQuality);
            param.setOptimizeHuffmanTables(true);
            param.setProgressiveMode(1);
            try (ImageOutputStream ios = ImageIO.createImageOutputStream(outputStream);){
                writer.setOutput(ios);
                writer.write(null, new IIOImage(scaledImage, null, null), param);
            }
            writer.dispose();
        } else {
            ImageIO.write((RenderedImage)scaledImage, format, outputStream);
        }
        return outputStream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String generateImageHash(PDImageXObject image) {
        try (InputStream stream = image.getCOSObject().createRawInputStream();){
            byte[] buffer = new byte[8192];
            int bytesRead = stream.read(buffer);
            if (bytesRead > 0) {
                byte[] dataToHash = bytesRead == buffer.length ? buffer : Arrays.copyOf(buffer, bytesRead);
                String string2 = this.bytesToHexString(this.generateMD5(dataToHash));
                return string2;
            }
            String string = "empty-stream";
            return string;
        }
        catch (Exception e) {
            ExceptionUtils.logException((String)"image hash generation", (Exception)e);
            return "fallback-" + System.identityHashCode(image);
        }
    }

    private String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private byte[] generateMD5(byte[] data) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw ExceptionUtils.createMd5AlgorithmException((Exception)e);
        }
    }

    private double getScaleFactorForLevel(int optimizeLevel) {
        return switch (optimizeLevel) {
            case 3 -> 0.85;
            case 4 -> 0.75;
            case 5 -> 0.65;
            case 6 -> 0.55;
            case 7 -> 0.45;
            case 8 -> 0.35;
            case 9 -> 0.25;
            case 10 -> 0.15;
            default -> 1.0;
        };
    }

    private float getJpegQualityForLevel(int optimizeLevel) {
        return switch (optimizeLevel) {
            case 3 -> 0.85f;
            case 4 -> 0.8f;
            case 5 -> 0.75f;
            case 6 -> 0.7f;
            case 7 -> 0.6f;
            case 8 -> 0.5f;
            case 9 -> 0.35f;
            case 10 -> 0.2f;
            default -> 0.7f;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/compress-pdf"})
    @StandardPdfResponse
    @Operation(summary="Optimize PDF file", description="This endpoint accepts a PDF file and optimizes it based on the provided parameters. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> optimizePdf(@ModelAttribute OptimizePdfRequest request) throws Exception {
        MultipartFile inputFile = request.getFileInput();
        Integer optimizeLevel = request.getOptimizeLevel();
        String expectedOutputSizeString = request.getExpectedOutputSize();
        Boolean convertToGrayscale = request.getGrayscale();
        Boolean convertToLineArt = request.getLineArt();
        Double lineArtThreshold = request.getLineArtThreshold();
        Integer lineArtEdgeLevel = request.getLineArtEdgeLevel();
        if (expectedOutputSizeString == null && optimizeLevel == null) {
            throw new Exception("Both expected output size and optimize level are not specified");
        }
        Long expectedOutputSize = 0L;
        boolean autoMode = false;
        if (expectedOutputSizeString != null && expectedOutputSizeString.length() > 1) {
            expectedOutputSize = GeneralUtils.convertSizeToBytes((String)expectedOutputSizeString);
            autoMode = true;
        }
        Path originalFile = Files.createTempFile("original_", ".pdf", new FileAttribute[0]);
        inputFile.transferTo(originalFile.toFile());
        long inputFileSize = Files.size(originalFile);
        Path currentFile = Files.createTempFile("working_", ".pdf", new FileAttribute[0]);
        Files.copy(originalFile, currentFile, StandardCopyOption.REPLACE_EXISTING);
        ArrayList<Path> tempFiles = new ArrayList<Path>();
        tempFiles.add(originalFile);
        tempFiles.add(currentFile);
        try {
            if (autoMode) {
                double sizeReductionRatio = (double)expectedOutputSize.longValue() / (double)inputFileSize;
                optimizeLevel = this.determineOptimizeLevel(sizeReductionRatio);
            }
            if (Boolean.TRUE.equals(convertToLineArt)) {
                if (this.lineArtConversionService == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, "Line art conversion is unavailable - ImageMagick service not found");
                }
                if (!this.isImageMagickEnabled()) {
                    throw new IOException("ImageMagick is not enabled but line art conversion was requested");
                }
                double thresholdValue = lineArtThreshold == null ? 55.0 : Math.min(100.0, Math.max(0.0, lineArtThreshold));
                int edgeLevel = lineArtEdgeLevel == null ? 1 : Math.min(3, Math.max(1, lineArtEdgeLevel));
                currentFile = this.applyLineArtConversion(currentFile, tempFiles, thresholdValue, edgeLevel);
            }
            boolean sizeMet = false;
            boolean imageCompressionApplied = false;
            boolean externalCompressionApplied = false;
            while (!sizeMet && optimizeLevel <= 9) {
                long outputFileSize;
                if (!externalCompressionApplied) {
                    boolean ghostscriptSuccess = false;
                    if (this.isGhostscriptEnabled()) {
                        try {
                            this.applyGhostscriptCompression(request, optimizeLevel.intValue(), currentFile, tempFiles);
                            log.info("Ghostscript compression applied successfully");
                            ghostscriptSuccess = true;
                        }
                        catch (IOException e) {
                            log.warn("Ghostscript compression failed, trying fallback methods");
                        }
                    }
                    if (!ghostscriptSuccess && this.isQpdfEnabled() && optimizeLevel <= 3) {
                        try {
                            this.applyQpdfCompression(request, optimizeLevel.intValue(), currentFile, tempFiles);
                            log.info("QPDF compression applied successfully");
                        }
                        catch (IOException e) {
                            log.warn("QPDF compression also failed");
                        }
                    }
                    if (!ghostscriptSuccess && !this.isQpdfEnabled()) {
                        log.info("No external compression tools available, using image compression only");
                    }
                    externalCompressionApplied = true;
                    if (ghostscriptSuccess) {
                        imageCompressionApplied = true;
                    }
                }
                if ((optimizeLevel >= 4 || Boolean.TRUE.equals(convertToGrayscale)) && !imageCompressionApplied) {
                    double scaleFactor = switch (optimizeLevel) {
                        case 4 -> 0.95;
                        case 5 -> 0.9;
                        case 6 -> 0.8;
                        case 7 -> 0.7;
                        case 8 -> 0.65;
                        case 9 -> 0.5;
                        default -> 1.0;
                    };
                    log.info("Applying image compression with scale factor: {}", (Object)scaleFactor);
                    Path compressedImageFile = this.compressImagesInPDF(currentFile, scaleFactor, 0.7f, Boolean.TRUE.equals(convertToGrayscale));
                    tempFiles.add(compressedImageFile);
                    currentFile = compressedImageFile;
                    imageCompressionApplied = true;
                }
                if ((outputFileSize = Files.size(currentFile)) <= expectedOutputSize || !autoMode) {
                    sizeMet = true;
                    continue;
                }
                int newOptimizeLevel = this.incrementOptimizeLevel(optimizeLevel.intValue(), outputFileSize, expectedOutputSize.longValue());
                if (newOptimizeLevel == optimizeLevel) {
                    log.info("Maximum optimization level reached without meeting target size.");
                    sizeMet = true;
                    continue;
                }
                imageCompressionApplied = false;
                externalCompressionApplied = false;
                optimizeLevel = newOptimizeLevel;
            }
            long finalFileSize = Files.size(currentFile);
            if (finalFileSize >= inputFileSize) {
                log.warn("Optimized file is larger than the original. Using the original file instead.");
                currentFile = originalFile;
            }
            String outputFilename = GeneralUtils.generateFilename((String)inputFile.getOriginalFilename(), (String)"_Optimized.pdf");
            ResponseEntity responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)this.pdfDocumentFactory.load(currentFile.toFile()), (String)outputFilename);
            return responseEntity;
        }
        finally {
            for (Path tempFile : tempFiles) {
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (IOException e) {
                    log.warn("Failed to delete temporary file: {}", (Object)tempFile, (Object)e);
                }
            }
        }
    }

    private Path applyLineArtConversion(Path currentFile, List<Path> tempFiles, double threshold, int edgeLevel) throws IOException {
        Path lineArtFile = Files.createTempFile("lineart_output_", ".pdf", new FileAttribute[0]);
        tempFiles.add(lineArtFile);
        try (PDDocument doc = this.pdfDocumentFactory.load(currentFile.toFile());){
            Map uniqueImages = this.findImages(doc);
            CompressionStats stats = new CompressionStats();
            stats.uniqueImagesCount = uniqueImages.size();
            this.calculateImageStats(uniqueImages, stats);
            Map convertedImages = this.createLineArtImages(doc, uniqueImages, stats, threshold, edgeLevel);
            this.replaceImages(doc, uniqueImages, convertedImages, stats);
            log.info("Applied line art conversion to {} unique images ({} total references)", (Object)stats.uniqueImagesCount, (Object)stats.totalImages);
            doc.save(lineArtFile.toString());
            Path path = lineArtFile;
            return path;
        }
    }

    private Map<String, PDImageXObject> createLineArtImages(PDDocument doc, Map<String, List<ImageReference>> uniqueImages, CompressionStats stats, double threshold, int edgeLevel) throws IOException {
        HashMap<String, PDImageXObject> convertedImages = new HashMap<String, PDImageXObject>();
        for (Map.Entry<String, List<ImageReference>> entry : uniqueImages.entrySet()) {
            String imageHash = entry.getKey();
            List<ImageReference> references = entry.getValue();
            if (references.isEmpty()) continue;
            PDImageXObject originalImage = this.getOriginalImage(doc, references.get(0));
            int originalSize = (int)originalImage.getCOSObject().getLength();
            stats.totalOriginalBytes += (long)originalSize;
            PDImageXObject converted = this.lineArtConversionService.convertImageToLineArt(doc, originalImage, threshold, edgeLevel);
            convertedImages.put(imageHash, converted);
            ++stats.compressedImages;
            int convertedSize = (int)converted.getCOSObject().getLength();
            stats.totalCompressedBytes += (long)(convertedSize * references.size());
            double reductionPercentage = 100.0 - (double)convertedSize * 100.0 / (double)originalSize;
            log.info("Image hash {}: Line art conversion {} \u2192 {} (reduced by {}%)", new Object[]{imageHash, GeneralUtils.formatBytes((long)originalSize), GeneralUtils.formatBytes((long)convertedSize), String.format("%.1f", reductionPercentage)});
        }
        return convertedImages;
    }

    private void applyGhostscriptCompression(OptimizePdfRequest request, int optimizeLevel, Path currentFile, List<Path> tempFiles) throws IOException {
        long preGsSize = Files.size(currentFile);
        log.info("Pre-Ghostscript file size: {}", (Object)GeneralUtils.formatBytes((long)preGsSize));
        Path gsOutputFile = Files.createTempFile("gs_output_", ".pdf", new FileAttribute[0]);
        tempFiles.add(gsOutputFile);
        ArrayList<Object> command = new ArrayList<Object>();
        command.add("gs");
        command.add("-sDEVICE=pdfwrite");
        command.add("-dCompatibilityLevel=1.5");
        command.add("-dNOPAUSE");
        command.add("-dQUIET");
        command.add("-dBATCH");
        switch (optimizeLevel) {
            case 1: {
                command.add("-dPDFSETTINGS=/prepress");
                break;
            }
            case 2: {
                command.add("-dPDFSETTINGS=/printer");
                break;
            }
            case 3: {
                command.add("-dPDFSETTINGS=/ebook");
                break;
            }
            case 4: 
            case 5: {
                command.add("-dPDFSETTINGS=/screen");
                break;
            }
            case 6: 
            case 7: {
                command.add("-dPDFSETTINGS=/screen");
                command.add("-dColorImageResolution=150");
                command.add("-dGrayImageResolution=150");
                command.add("-dMonoImageResolution=300");
                break;
            }
            case 8: 
            case 9: {
                command.add("-dPDFSETTINGS=/screen");
                command.add("-dColorImageResolution=100");
                command.add("-dGrayImageResolution=100");
                command.add("-dMonoImageResolution=200");
                break;
            }
            case 10: {
                command.add("-dPDFSETTINGS=/screen");
                command.add("-dColorImageResolution=72");
                command.add("-dGrayImageResolution=72");
                command.add("-dMonoImageResolution=150");
                break;
            }
            default: {
                command.add("-dPDFSETTINGS=/screen");
            }
        }
        command.add("-sOutputFile=" + gsOutputFile.toString());
        command.add(currentFile.toString());
        try {
            ProcessExecutor.ProcessExecutorResult returnCode = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.GHOSTSCRIPT).runCommandWithOutputHandling(command);
            if (returnCode.getRc() != 0) {
                log.warn("Ghostscript compression failed with return code: {}", (Object)returnCode.getRc());
                throw new IOException("Ghostscript compression failed");
            }
            Files.copy(gsOutputFile, currentFile, StandardCopyOption.REPLACE_EXISTING);
            long postGsSize = Files.size(currentFile);
            double gsReduction = 100.0 - (double)postGsSize * 100.0 / (double)preGsSize;
            log.info("Post-Ghostscript file size: {} (reduced by {}%)", (Object)GeneralUtils.formatBytes((long)postGsSize), (Object)String.format("%.1f", gsReduction));
        }
        catch (Exception e) {
            log.warn("Ghostscript compression failed, will fallback to other methods", (Throwable)e);
            throw new IOException("Ghostscript compression failed", e);
        }
    }

    private void applyQpdfCompression(OptimizePdfRequest request, int optimizeLevel, Path currentFile, List<Path> tempFiles) throws IOException {
        long preQpdfSize = Files.size(currentFile);
        log.info("Pre-QPDF file size: {}", (Object)GeneralUtils.formatBytes((long)preQpdfSize));
        int qpdfCompressionLevel = optimizeLevel == 1 ? 5 : (optimizeLevel == 2 ? 9 : 9);
        Path qpdfOutputFile = Files.createTempFile("qpdf_output_", ".pdf", new FileAttribute[0]);
        tempFiles.add(qpdfOutputFile);
        ArrayList<Object> command = new ArrayList<Object>();
        command.add("qpdf");
        if (request.getNormalize().booleanValue()) {
            command.add("--normalize-content=y");
        }
        if (request.getLinearize().booleanValue()) {
            command.add("--linearize");
        }
        command.add("--recompress-flate");
        command.add("--compression-level=" + qpdfCompressionLevel);
        command.add("--compress-streams=y");
        command.add("--object-streams=generate");
        command.add(currentFile.toString());
        command.add(qpdfOutputFile.toString());
        ProcessExecutor.ProcessExecutorResult returnCode = null;
        try {
            returnCode = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.QPDF).runCommandWithOutputHandling(command);
            Files.copy(qpdfOutputFile, currentFile, StandardCopyOption.REPLACE_EXISTING);
            long postQpdfSize = Files.size(currentFile);
            double qpdfReduction = 100.0 - (double)postQpdfSize * 100.0 / (double)preQpdfSize;
            log.info("Post-QPDF file size: {} (reduced by {}%)", (Object)GeneralUtils.formatBytes((long)postQpdfSize), (Object)String.format("%.1f", qpdfReduction));
        }
        catch (Exception e) {
            if (returnCode != null && returnCode.getRc() != 3) {
                throw new IOException("QPDF command failed", e);
            }
            log.warn("QPDF compression failed, continuing with current file", (Throwable)e);
        }
    }

    private int determineOptimizeLevel(double sizeReductionRatio) {
        if (sizeReductionRatio > 0.9) {
            return 1;
        }
        if (sizeReductionRatio > 0.8) {
            return 2;
        }
        if (sizeReductionRatio > 0.7) {
            return 3;
        }
        if (sizeReductionRatio > 0.6) {
            return 4;
        }
        if (sizeReductionRatio > 0.3) {
            return 5;
        }
        if (sizeReductionRatio > 0.2) {
            return 6;
        }
        if (sizeReductionRatio > 0.15) {
            return 7;
        }
        if (sizeReductionRatio > 0.1) {
            return 8;
        }
        return 9;
    }

    private int incrementOptimizeLevel(int currentLevel, long currentSize, long targetSize) {
        double currentRatio = (double)currentSize / (double)targetSize;
        log.info("Current compression ratio: {}", (Object)String.format("%.2f", currentRatio));
        if (currentRatio > 2.0) {
            return Math.min(9, currentLevel + 3);
        }
        if (currentRatio > 1.5) {
            return Math.min(9, currentLevel + 2);
        }
        return Math.min(9, currentLevel + 1);
    }

    @Generated
    public CompressController(CustomPDFDocumentFactory pdfDocumentFactory, EndpointConfiguration endpointConfiguration) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.endpointConfiguration = endpointConfiguration;
    }
}

