/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfwriter.compress.CompressParameters;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationTextMarkup;
import org.apache.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.converters.PdfToPdfARequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.ConvertApi;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.ProcessExecutor;
import stirling.software.common.util.WebResponseUtils;

@ConvertApi
public class ConvertPDFToPDFA {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConvertPDFToPDFA.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/pdf/pdfa"})
    @StandardPdfResponse
    @Operation(summary="Convert a PDF to a PDF/A", description="This endpoint converts a PDF file to a PDF/A file using LibreOffice. PDF/A is a format designed for long-term archiving of digital documents. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> pdfToPdfA(@ModelAttribute PdfToPdfARequest request) throws Exception {
        MultipartFile inputFile = request.getFileInput();
        String outputFormat = request.getOutputFormat();
        if (!"application/pdf".equals(inputFile.getContentType())) {
            log.error("Invalid input file type: {}", (Object)inputFile.getContentType());
            throw ExceptionUtils.createPdfFileRequiredException();
        }
        String originalFileName = Filenames.toSimpleFileName((String)inputFile.getOriginalFilename());
        if (originalFileName == null || originalFileName.trim().isEmpty()) {
            originalFileName = "output.pdf";
        }
        String baseFileName = originalFileName.contains(".") ? originalFileName.substring(0, originalFileName.lastIndexOf(46)) : originalFileName;
        Path tempInputFile = null;
        Path loPdfPath = null;
        File preProcessedFile = null;
        int pdfaPart = 2;
        try {
            boolean needImgs;
            tempInputFile = Files.createTempFile("input_", ".pdf", new FileAttribute[0]);
            inputFile.transferTo(tempInputFile);
            if ("pdfa".equals(outputFormat)) {
                preProcessedFile = tempInputFile.toFile();
            } else {
                pdfaPart = 1;
                preProcessedFile = this.preProcessHighlights(tempInputFile.toFile());
            }
            Set missingFonts = new HashSet();
            try (PDDocument doc = Loader.loadPDF((File)preProcessedFile);){
                missingFonts = this.findUnembeddedFontNames(doc);
                boolean bl = needImgs = pdfaPart == 1 && this.hasTransparentImages(doc);
                if (!missingFonts.isEmpty() || needImgs) {
                    loPdfPath = this.runLibreOfficeConversion(preProcessedFile.toPath(), pdfaPart);
                }
            }
            byte[] fileBytes = this.convertToPdfA(preProcessedFile.toPath(), loPdfPath, pdfaPart, missingFonts, needImgs);
            String outputFilename = baseFileName + "_PDFA.pdf";
            ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])fileBytes, (String)outputFilename, (MediaType)MediaType.APPLICATION_PDF);
            return responseEntity;
        }
        finally {
            if (tempInputFile != null) {
                Files.deleteIfExists(tempInputFile);
            }
            if (loPdfPath != null && loPdfPath.getParent() != null) {
                FileUtils.deleteDirectory((File)loPdfPath.getParent().toFile());
            }
            if (preProcessedFile != null) {
                Files.deleteIfExists(preProcessedFile.toPath());
            }
        }
    }

    private byte[] convertToPdfA(Path basePdfPath, Path loPdfPath, int pdfaPart, Set<String> missingFonts, boolean importImages) throws Exception {
        try (PDDocument baseDoc = Loader.loadPDF((File)basePdfPath.toFile());){
            if (loPdfPath != null) {
                try (PDDocument loDoc = Loader.loadPDF((File)loPdfPath.toFile());){
                    if (!missingFonts.isEmpty()) {
                        this.embedMissingFonts(loDoc, baseDoc, missingFonts);
                    }
                    if (importImages) {
                        this.importFlattenedImages(loDoc, baseDoc);
                    }
                }
            }
            byte[] byArray = this.processWithPDFBox(baseDoc, pdfaPart);
            return byArray;
        }
    }

    private byte[] processWithPDFBox(PDDocument document, int pdfaPart) throws Exception {
        this.removeElementsForPdfA(document, pdfaPart);
        this.mergeAndAddXmpMetadata(document, pdfaPart);
        this.addICCProfileIfNotPresent(document);
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        catalog.setMetadata(document.getDocumentCatalog().getMetadata());
        catalog.setViewerPreferences(new PDViewerPreferences(catalog.getCOSObject()));
        document.getDocument().setVersion(pdfaPart == 1 ? 1.4f : 1.7f);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (pdfaPart == 1) {
            document.save((OutputStream)baos, CompressParameters.NO_COMPRESSION);
        } else {
            document.save((OutputStream)baos);
        }
        return baos.toByteArray();
    }

    private Path runLibreOfficeConversion(Path tempInputFile, int pdfaPart) throws Exception {
        Path tempOutputDir = Files.createTempDirectory("output_", new FileAttribute[0]);
        String pdfFilter = pdfaPart == 2 ? "pdf:writer_pdf_Export:{\"SelectPdfVersion\":{\"type\":\"long\",\"value\":\"2\"}}" : "pdf:writer_pdf_Export:{\"SelectPdfVersion\":{\"type\":\"long\",\"value\":\"1\"}}";
        ArrayList<String> command = new ArrayList<String>(Arrays.asList("soffice", "--headless", "--nologo", "--convert-to", pdfFilter, "--outdir", tempOutputDir.toString(), tempInputFile.toString()));
        ProcessExecutor.ProcessExecutorResult returnCode = ProcessExecutor.getInstance((ProcessExecutor.Processes)ProcessExecutor.Processes.LIBRE_OFFICE).runCommandWithOutputHandling(command);
        if (returnCode.getRc() != 0) {
            log.error("PDF/A conversion failed with return code: {}", (Object)returnCode.getRc());
            throw ExceptionUtils.createPdfaConversionFailedException();
        }
        File[] outputFiles = tempOutputDir.toFile().listFiles();
        if (outputFiles == null || outputFiles.length != 1) {
            throw ExceptionUtils.createPdfaConversionFailedException();
        }
        return outputFiles[0].toPath();
    }

    private void embedMissingFonts(PDDocument loDoc, PDDocument baseDoc, Set<String> missingFonts) throws IOException {
        ArrayList loPages = new ArrayList();
        loDoc.getPages().forEach(loPages::add);
        ArrayList basePages = new ArrayList();
        baseDoc.getPages().forEach(basePages::add);
        for (int i = 0; i < loPages.size(); ++i) {
            PDResources loRes = ((PDPage)loPages.get(i)).getResources();
            PDResources baseRes = ((PDPage)basePages.get(i)).getResources();
            for (COSName fontKey : loRes.getFontNames()) {
                PDType0Font newFont;
                PDFontDescriptor desc;
                String psName;
                PDFont loFont = loRes.getFont(fontKey);
                if (loFont == null || !missingFonts.contains(psName = loFont.getName()) || (desc = loFont.getFontDescriptor()) == null) continue;
                PDStream fontStream = null;
                if (desc.getFontFile() != null) {
                    fontStream = desc.getFontFile();
                } else if (desc.getFontFile2() != null) {
                    fontStream = desc.getFontFile2();
                } else if (desc.getFontFile3() != null) {
                    fontStream = desc.getFontFile3();
                }
                if (fontStream == null) continue;
                COSInputStream in = fontStream.createInputStream();
                try {
                    newFont = PDType0Font.load((PDDocument)baseDoc, (InputStream)in, (boolean)false);
                }
                catch (IOException e1) {
                    try {
                        newFont = PDTrueTypeFont.load((PDDocument)baseDoc, (InputStream)in, null);
                    }
                    catch (IOException | IllegalArgumentException e2) {
                        log.error("Could not embed font {}: {}", (Object)psName, (Object)e2.getMessage());
                        if (in == null) continue;
                        in.close();
                        continue;
                    }
                }
                try {
                    if (newFont == null) continue;
                    baseRes.put(fontKey, (PDFont)newFont);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }

    private Set<String> findUnembeddedFontNames(PDDocument doc) throws IOException {
        HashSet<String> missing = new HashSet<String>();
        for (PDPage page : doc.getPages()) {
            PDResources res = page.getResources();
            for (COSName name : res.getFontNames()) {
                PDFont font = res.getFont(name);
                if (font == null || font.isEmbedded()) continue;
                missing.add(font.getName());
            }
        }
        return missing;
    }

    private void importFlattenedImages(PDDocument loDoc, PDDocument baseDoc) throws IOException {
        ArrayList loPages = new ArrayList();
        loDoc.getPages().forEach(loPages::add);
        ArrayList basePages = new ArrayList();
        baseDoc.getPages().forEach(basePages::add);
        for (int i = 0; i < loPages.size(); ++i) {
            PDPage loPage = (PDPage)loPages.get(i);
            PDPage basePage = (PDPage)basePages.get(i);
            PDResources loRes = loPage.getResources();
            PDResources baseRes = basePage.getResources();
            Set toReplace = this.detectTransparentXObjects(basePage);
            for (COSName name : toReplace) {
                PDXObject loXo = loRes.getXObject(name);
                if (!(loXo instanceof PDImageXObject)) continue;
                PDImageXObject img = (PDImageXObject)loXo;
                PDImageXObject newImg = LosslessFactory.createFromImage((PDDocument)baseDoc, (BufferedImage)img.getImage());
                baseRes.put(name, (PDXObject)newImg);
            }
        }
    }

    private Set<COSName> detectTransparentXObjects(PDPage page) {
        HashSet<COSName> transparentObjects = new HashSet<COSName>();
        PDResources res = page.getResources();
        if (res == null) {
            return transparentObjects;
        }
        for (COSName name : res.getXObjectNames()) {
            try {
                PDImageXObject img;
                COSStream d;
                PDXObject xo = res.getXObject(name);
                if (!(xo instanceof PDImageXObject) || !(d = (img = (PDImageXObject)xo).getCOSObject()).containsKey(COSName.SMASK) && !this.isTransparencyGroup((COSDictionary)d) && !d.getBoolean(COSName.INTERPOLATE, false)) continue;
                transparentObjects.add(name);
            }
            catch (IOException ioe) {
                log.error("Error processing XObject {}: {}", (Object)name.getName(), (Object)ioe.getMessage());
            }
        }
        return transparentObjects;
    }

    private boolean isTransparencyGroup(COSDictionary dict) {
        COSDictionary gd;
        COSBase g = dict.getDictionaryObject(COSName.GROUP);
        return g instanceof COSDictionary && COSName.TRANSPARENCY.equals((Object)(gd = (COSDictionary)g).getCOSName(COSName.S));
    }

    private boolean hasTransparentImages(PDDocument doc) {
        for (PDPage page : doc.getPages()) {
            PDResources res = page.getResources();
            if (res == null) continue;
            for (COSName name : res.getXObjectNames()) {
                try {
                    COSDictionary gd;
                    PDXObject xo = res.getXObject(name);
                    if (!(xo instanceof PDImageXObject)) continue;
                    PDImageXObject img = (PDImageXObject)xo;
                    COSStream dict = img.getCOSObject();
                    if (dict.containsKey(COSName.SMASK)) {
                        return true;
                    }
                    COSBase g = dict.getDictionaryObject(COSName.GROUP);
                    if (g instanceof COSDictionary && COSName.TRANSPARENCY.equals((Object)(gd = (COSDictionary)g).getCOSName(COSName.S))) {
                        return true;
                    }
                    if (!dict.getBoolean(COSName.INTERPOLATE, false)) continue;
                    return true;
                }
                catch (IOException ioe) {
                    log.error("Error processing XObject {}: {}", (Object)name.getName(), (Object)ioe.getMessage());
                }
            }
        }
        return false;
    }

    private void sanitizePdfA(COSBase base, PDResources resources, int pdfaPart) {
        block6: {
            block5: {
                if (!(base instanceof COSDictionary)) break block5;
                COSDictionary dict = (COSDictionary)base;
                if (pdfaPart == 1) {
                    COSDictionary gDict;
                    COSBase group = dict.getDictionaryObject(COSName.GROUP);
                    if (group instanceof COSDictionary && COSName.TRANSPARENCY.equals((Object)(gDict = (COSDictionary)group).getCOSName(COSName.S))) {
                        dict.removeItem(COSName.GROUP);
                    }
                    dict.removeItem(COSName.SMASK);
                    dict.removeItem(COSName.CA);
                    dict.removeItem(COSName.getPDFName((String)"ca"));
                }
                if (dict.containsKey(COSName.INTERPOLATE) && dict.getBoolean(COSName.INTERPOLATE, true)) {
                    dict.setBoolean(COSName.INTERPOLATE, false);
                }
                dict.removeItem(COSName.JAVA_SCRIPT);
                dict.removeItem(COSName.getPDFName((String)"JS"));
                dict.removeItem(COSName.getPDFName((String)"RichMedia"));
                dict.removeItem(COSName.getPDFName((String)"Movie"));
                dict.removeItem(COSName.getPDFName((String)"Sound"));
                dict.removeItem(COSName.getPDFName((String)"Launch"));
                dict.removeItem(COSName.URI);
                dict.removeItem(COSName.getPDFName((String)"GoToR"));
                dict.removeItem(COSName.EMBEDDED_FILES);
                dict.removeItem(COSName.FILESPEC);
                for (Map.Entry entry : dict.entrySet()) {
                    this.sanitizePdfA((COSBase)entry.getValue(), resources, pdfaPart);
                }
                break block6;
            }
            if (!(base instanceof COSArray)) break block6;
            COSArray arr = (COSArray)base;
            for (COSBase item : arr) {
                this.sanitizePdfA(item, resources, pdfaPart);
            }
        }
    }

    private void removeElementsForPdfA(PDDocument doc, int pdfaPart) {
        if (pdfaPart == 1) {
            doc.getDocumentCatalog().getCOSObject().removeItem(COSName.getPDFName((String)"OCProperties"));
        }
        for (PDPage page : doc.getPages()) {
            if (pdfaPart == 1) {
                page.setAnnotations(Collections.emptyList());
            }
            PDResources res = page.getResources();
            this.sanitizePdfA((COSBase)page.getCOSObject(), res, pdfaPart);
            if (res == null) continue;
            for (COSName name : res.getXObjectNames()) {
                try {
                    PDXObject xo = res.getXObject(name);
                    if (xo instanceof PDFormXObject) {
                        PDFormXObject form = (PDFormXObject)xo;
                        this.sanitizePdfA((COSBase)form.getCOSObject(), res, pdfaPart);
                        continue;
                    }
                    if (!(xo instanceof PDImageXObject)) continue;
                    PDImageXObject img = (PDImageXObject)xo;
                    this.sanitizePdfA((COSBase)img.getCOSObject(), res, pdfaPart);
                }
                catch (IOException ioe) {
                    log.error("Cannot load XObject {}: {}", (Object)name.getName(), (Object)ioe.getMessage());
                }
            }
        }
    }

    private void mergeAndAddXmpMetadata(PDDocument document, int pdfaPart) throws Exception {
        String keywords;
        String subject;
        String title;
        AdobePDFSchema adobePdfSchema;
        PDDocumentInformation docInfo;
        XMPMetadata xmp;
        PDMetadata existingMetadata = document.getDocumentCatalog().getMetadata();
        if (existingMetadata != null) {
            try (COSInputStream xmpStream = existingMetadata.createInputStream();){
                DomXmpParser parser = new DomXmpParser();
                parser.setStrictParsing(false);
                xmp = parser.parse((InputStream)xmpStream);
            }
            catch (Exception e) {
                xmp = XMPMetadata.createXMPMetadata();
            }
        } else {
            xmp = XMPMetadata.createXMPMetadata();
        }
        if ((docInfo = document.getDocumentInformation()) == null) {
            docInfo = new PDDocumentInformation();
        }
        String originalCreator = Optional.ofNullable(docInfo.getCreator()).orElse("Unknown");
        String originalProducer = Optional.ofNullable(docInfo.getProducer()).orElse("Unknown");
        DublinCoreSchema dcSchema = xmp.getDublinCoreSchema();
        if (dcSchema != null) {
            List existingCreators = dcSchema.getCreators();
            if (existingCreators != null) {
                for (String creator : new ArrayList(existingCreators)) {
                    dcSchema.removeCreator(creator);
                }
            }
        } else {
            dcSchema = xmp.createAndAddDublinCoreSchema();
        }
        dcSchema.addCreator(originalCreator);
        PDFAIdentificationSchema pdfaSchema = (PDFAIdentificationSchema)xmp.getSchema(PDFAIdentificationSchema.class);
        if (pdfaSchema == null) {
            pdfaSchema = xmp.createAndAddPDFAIdentificationSchema();
        }
        pdfaSchema.setPart(Integer.valueOf(pdfaPart));
        pdfaSchema.setConformance("B");
        XMPBasicSchema xmpBasicSchema = xmp.getXMPBasicSchema();
        if (xmpBasicSchema == null) {
            xmpBasicSchema = xmp.createAndAddXMPBasicSchema();
        }
        if ((adobePdfSchema = xmp.getAdobePDFSchema()) == null) {
            adobePdfSchema = xmp.createAndAddAdobePDFSchema();
        }
        docInfo.setCreator(originalCreator);
        xmpBasicSchema.setCreatorTool(originalCreator);
        docInfo.setProducer(originalProducer);
        adobePdfSchema.setProducer(originalProducer);
        String originalAuthor = docInfo.getAuthor();
        if (originalAuthor != null && !originalAuthor.isBlank()) {
            docInfo.setAuthor(null);
            if (!originalCreator.equals(originalAuthor)) {
                dcSchema.addCreator(originalAuthor);
            }
        }
        if ((title = docInfo.getTitle()) != null && !title.isBlank()) {
            dcSchema.setTitle(title);
        }
        if ((subject = docInfo.getSubject()) != null && !subject.isBlank()) {
            dcSchema.addSubject(subject);
        }
        if ((keywords = docInfo.getKeywords()) != null && !keywords.isBlank()) {
            adobePdfSchema.setKeywords(keywords);
        }
        Instant nowInstant = Instant.now();
        ZonedDateTime nowZdt = ZonedDateTime.ofInstant(nowInstant, ZoneId.of("UTC"));
        GregorianCalendar nowCal = GregorianCalendar.from(nowZdt);
        Calendar originalCreationDate = docInfo.getCreationDate();
        GregorianCalendar creationCal = originalCreationDate == null ? nowCal : (originalCreationDate instanceof GregorianCalendar ? (GregorianCalendar)originalCreationDate : GregorianCalendar.from(ZonedDateTime.ofInstant(originalCreationDate.toInstant(), ZoneId.of("UTC"))));
        docInfo.setCreationDate((Calendar)creationCal);
        xmpBasicSchema.setCreateDate((Calendar)creationCal);
        docInfo.setModificationDate((Calendar)nowCal);
        xmpBasicSchema.setModifyDate((Calendar)nowCal);
        xmpBasicSchema.setMetadataDate((Calendar)nowCal);
        ByteArrayOutputStream xmpOut = new ByteArrayOutputStream();
        new XmpSerializer().serialize(xmp, (OutputStream)xmpOut, true);
        PDMetadata newMetadata = new PDMetadata(document);
        newMetadata.importXMPMetadata(xmpOut.toByteArray());
        document.getDocumentCatalog().setMetadata(newMetadata);
    }

    private void addICCProfileIfNotPresent(PDDocument document) throws Exception {
        if (document.getDocumentCatalog().getOutputIntents().isEmpty()) {
            try (InputStream colorProfile = this.getClass().getResourceAsStream("/icc/sRGB2014.icc");){
                PDOutputIntent outputIntent = new PDOutputIntent(document, colorProfile);
                outputIntent.setInfo("sRGB IEC61966-2.1");
                outputIntent.setOutputCondition("sRGB IEC61966-2.1");
                outputIntent.setOutputConditionIdentifier("sRGB IEC61966-2.1");
                outputIntent.setRegistryName("http://www.color.org");
                document.getDocumentCatalog().addOutputIntent(outputIntent);
            }
            catch (Exception e) {
                log.error("Failed to load ICC profile: {}", (Object)e.getMessage());
            }
        }
    }

    private File preProcessHighlights(File inputPdf) throws Exception {
        try (PDDocument document = Loader.loadPDF((File)inputPdf);){
            for (PDPage page : document.getPages()) {
                List annotations = page.getAnnotations();
                for (PDAnnotation annot : annotations) {
                    COSDictionary groupDict;
                    float[] fArray;
                    if (!"Highlight".equals(annot.getSubtype()) || !(annot instanceof PDAnnotationTextMarkup)) continue;
                    PDAnnotationTextMarkup highlight = (PDAnnotationTextMarkup)annot;
                    if (highlight.getColor() != null) {
                        fArray = highlight.getColor().getComponents();
                    } else {
                        float[] fArray2 = new float[3];
                        fArray2[0] = 1.0f;
                        fArray2[1] = 1.0f;
                        fArray = fArray2;
                        fArray2[2] = 0.0f;
                    }
                    float[] colorComponents = fArray;
                    Color highlightColor = new Color(colorComponents[0], colorComponents[1], colorComponents[2]);
                    float[] quadPoints = highlight.getQuadPoints();
                    if (quadPoints != null) {
                        try (PDPageContentStream cs = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.PREPEND, true, true);){
                            cs.setStrokingColor(highlightColor);
                            cs.setLineWidth(0.05f);
                            float spacing = 2.0f;
                            for (int i = 0; i < quadPoints.length; i += 8) {
                                float len;
                                float minX = Math.min(Math.min(quadPoints[i], quadPoints[i + 2]), Math.min(quadPoints[i + 4], quadPoints[i + 6]));
                                float maxX = Math.max(Math.max(quadPoints[i], quadPoints[i + 2]), Math.max(quadPoints[i + 4], quadPoints[i + 6]));
                                float minY = Math.min(Math.min(quadPoints[i + 1], quadPoints[i + 3]), Math.min(quadPoints[i + 5], quadPoints[i + 7]));
                                float maxY = Math.max(Math.max(quadPoints[i + 1], quadPoints[i + 3]), Math.max(quadPoints[i + 5], quadPoints[i + 7]));
                                float width = maxX - minX;
                                float height = maxY - minY;
                                for (float y = minY; y <= maxY; y += spacing) {
                                    len = Math.min(width, maxY - y);
                                    cs.moveTo(minX, y);
                                    cs.lineTo(minX + len, y + len);
                                }
                                for (float x = minX + spacing; x <= maxX; x += spacing) {
                                    len = Math.min(maxX - x, height);
                                    cs.moveTo(x, minY);
                                    cs.lineTo(x + len, minY + len);
                                }
                            }
                            cs.stroke();
                        }
                    }
                    page.getAnnotations().remove(highlight);
                    COSDictionary pageDict = page.getCOSObject();
                    if (!pageDict.containsKey(COSName.GROUP) || (groupDict = (COSDictionary)pageDict.getDictionaryObject(COSName.GROUP)) == null || !COSName.TRANSPARENCY.getName().equalsIgnoreCase(groupDict.getNameAsString(COSName.S))) continue;
                    pageDict.removeItem(COSName.GROUP);
                }
            }
            File preProcessedFile = Files.createTempFile("preprocessed_", ".pdf", new FileAttribute[0]).toFile();
            document.save(preProcessedFile);
            File file = preProcessedFile;
            return file;
        }
    }
}

