/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import stirling.software.SPDF.controller.api.UIDataController;
import stirling.software.SPDF.service.SharedSignatureService;
import stirling.software.common.annotations.api.UiDataApi;
import stirling.software.common.configuration.InstallationPathConfig;
import stirling.software.common.configuration.RuntimePathConfig;
import stirling.software.common.model.ApplicationProperties;
import stirling.software.common.service.UserServiceInterface;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;

@UiDataApi
public class UIDataController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UIDataController.class);
    private final ApplicationProperties applicationProperties;
    private final SharedSignatureService signatureService;
    private final UserServiceInterface userService;
    private final ResourceLoader resourceLoader;
    private final RuntimePathConfig runtimePathConfig;

    public UIDataController(ApplicationProperties applicationProperties, SharedSignatureService signatureService, @Autowired(required=false) UserServiceInterface userService, ResourceLoader resourceLoader, RuntimePathConfig runtimePathConfig) {
        this.applicationProperties = applicationProperties;
        this.signatureService = signatureService;
        this.userService = userService;
        this.resourceLoader = resourceLoader;
        this.runtimePathConfig = runtimePathConfig;
    }

    @GetMapping(value={"/footer-info"})
    @Operation(summary="Get public footer configuration data")
    public ResponseEntity<FooterData> getFooterData() {
        FooterData data = new FooterData();
        data.setAnalyticsEnabled(this.applicationProperties.getSystem().getEnableAnalytics());
        data.setTermsAndConditions(this.applicationProperties.getLegal().getTermsAndConditions());
        data.setPrivacyPolicy(this.applicationProperties.getLegal().getPrivacyPolicy());
        data.setAccessibilityStatement(this.applicationProperties.getLegal().getAccessibilityStatement());
        data.setCookiePolicy(this.applicationProperties.getLegal().getCookiePolicy());
        data.setImpressum(this.applicationProperties.getLegal().getImpressum());
        return ResponseEntity.ok((Object)data);
    }

    @GetMapping(value={"/home"})
    @Operation(summary="Get home page data")
    public ResponseEntity<HomeData> getHomeData() {
        String showSurvey = System.getenv("SHOW_SURVEY");
        boolean showSurveyValue = showSurvey == null || "true".equalsIgnoreCase(showSurvey);
        HomeData data = new HomeData();
        data.setShowSurveyFromDocker(showSurveyValue);
        return ResponseEntity.ok((Object)data);
    }

    @GetMapping(value={"/licenses"})
    @Operation(summary="Get third-party licenses data")
    public ResponseEntity<LicensesData> getLicensesData() {
        LicensesData data = new LicensesData();
        ClassPathResource resource = new ClassPathResource("static/3rdPartyLicenses.json");
        try {
            InputStream is = resource.getInputStream();
            String json = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            ObjectMapper mapper = new ObjectMapper();
            Map licenseData = (Map)mapper.readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            data.setDependencies((List)licenseData.get("dependencies"));
        }
        catch (IOException e) {
            log.error("Failed to load licenses data", (Throwable)e);
            data.setDependencies(Collections.emptyList());
        }
        return ResponseEntity.ok((Object)data);
    }

    @GetMapping(value={"/pipeline"})
    @Operation(summary="Get pipeline configuration data")
    public ResponseEntity<PipelineData> getPipelineData() {
        PipelineData data = new PipelineData();
        ArrayList<String> pipelineConfigs = new ArrayList<String>();
        ArrayList pipelineConfigsWithNames = new ArrayList();
        if (new File(this.runtimePathConfig.getPipelineDefaultWebUiConfigs()).exists()) {
            try (Stream<Path> paths = Files.walk(Paths.get(this.runtimePathConfig.getPipelineDefaultWebUiConfigs(), new String[0]), new FileVisitOption[0]);){
                List<Path> jsonFiles = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".json")).toList();
                for (Path jsonFile : jsonFiles) {
                    String content = Files.readString(jsonFile, StandardCharsets.UTF_8);
                    pipelineConfigs.add(content);
                }
                for (String config : pipelineConfigs) {
                    Map jsonContent = (Map)new ObjectMapper().readValue(config, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    String name = (String)jsonContent.get("name");
                    if (name == null || name.length() < 1) {
                        String filename = jsonFiles.get(pipelineConfigs.indexOf(config)).getFileName().toString();
                        name = filename.substring(0, filename.lastIndexOf(46));
                    }
                    HashMap<String, String> configWithName = new HashMap<String, String>();
                    configWithName.put("json", config);
                    configWithName.put("name", name);
                    pipelineConfigsWithNames.add(configWithName);
                }
            }
            catch (IOException e) {
                log.error("Failed to load pipeline configs", (Throwable)e);
            }
        }
        if (pipelineConfigsWithNames.isEmpty()) {
            HashMap<String, String> configWithName = new HashMap<String, String>();
            configWithName.put("json", "");
            configWithName.put("name", "No preloaded configs found");
            pipelineConfigsWithNames.add(configWithName);
        }
        data.setPipelineConfigsWithNames(pipelineConfigsWithNames);
        data.setPipelineConfigs(pipelineConfigs);
        return ResponseEntity.ok((Object)data);
    }

    @GetMapping(value={"/sign"})
    @Operation(summary="Get signature form data")
    public ResponseEntity<SignData> getSignData() {
        String username = "";
        if (this.userService != null) {
            username = this.userService.getCurrentUsername();
        }
        List signatures = this.signatureService.getAvailableSignatures(username);
        List fonts = this.getFontNames();
        SignData data = new SignData();
        data.setSignatures(signatures);
        data.setFonts(fonts);
        return ResponseEntity.ok((Object)data);
    }

    @GetMapping(value={"/ocr-pdf"})
    @Operation(summary="Get OCR PDF data")
    public ResponseEntity<OcrData> getOcrPdfData() {
        List languages = this.getAvailableTesseractLanguages();
        OcrData data = new OcrData();
        data.setLanguages(languages);
        return ResponseEntity.ok((Object)data);
    }

    private List<String> getAvailableTesseractLanguages() {
        String tessdataDir = this.applicationProperties.getSystem().getTessdataDir();
        File[] files = new File(tessdataDir).listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).filter(file -> file.getName().endsWith(".traineddata")).map(file -> file.getName().replace(".traineddata", "")).filter(lang -> !"osd".equalsIgnoreCase((String)lang)).sorted().toList();
    }

    private List<FontResource> getFontNames() {
        ArrayList<FontResource> fontNames = new ArrayList<FontResource>();
        fontNames.addAll(this.getFontNamesFromLocation("classpath:static/fonts/*.woff2"));
        fontNames.addAll(this.getFontNamesFromLocation("file:" + InstallationPathConfig.getStaticPath() + "fonts" + File.separator + "*"));
        return fontNames;
    }

    private List<FontResource> getFontNamesFromLocation(String locationPattern) {
        try {
            Resource[] resources = GeneralUtils.getResourcesFromLocationPattern((String)locationPattern, (ResourceLoader)this.resourceLoader);
            return Arrays.stream(resources).map(resource -> {
                try {
                    int lastDotIndex;
                    String filename = resource.getFilename();
                    if (filename != null && (lastDotIndex = filename.lastIndexOf(46)) != -1) {
                        String name = filename.substring(0, lastDotIndex);
                        String extension = filename.substring(lastDotIndex + 1);
                        return new FontResource(name, extension);
                    }
                    return null;
                }
                catch (Exception e) {
                    throw ExceptionUtils.createRuntimeException((String)"error.fontLoadingFailed", (String)"Error processing font file", (Exception)e, (Object[])new Object[0]);
                }
            }).filter(Objects::nonNull).toList();
        }
        catch (Exception e) {
            throw ExceptionUtils.createRuntimeException((String)"error.fontDirectoryReadFailed", (String)"Failed to read font directory", (Exception)e, (Object[])new Object[0]);
        }
    }
}

