/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.pdfbox.multipdf.LayerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.util.Matrix;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;
import stirling.software.SPDF.config.swagger.MultiFileResponse;
import stirling.software.SPDF.model.api.SplitPdfBySectionsRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.GeneralApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.PDFService;
import stirling.software.common.util.TempFile;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

@GeneralApi
public class SplitPdfBySectionsController {
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final TempFileManager tempFileManager;
    private final PDFService pdfService;

    @AutoJobPostMapping(value={"/split-pdf-by-sections"}, consumes={"multipart/form-data"})
    @MultiFileResponse
    @Operation(summary="Split PDF pages into smaller sections", description="Split each page of a PDF into smaller sections based on the user's choice (halves, thirds, quarters, etc.), both vertically and horizontally. Input:PDF Output:ZIP-PDF Type:SISO")
    public ResponseEntity<StreamingResponseBody> splitPdf(@ModelAttribute SplitPdfBySectionsRequest request) throws Exception {
        ArrayList<ByteArrayOutputStream> splitDocumentsBoas = new ArrayList<ByteArrayOutputStream>();
        MultipartFile file = request.getFileInput();
        PDDocument sourceDocument = this.pdfDocumentFactory.load(file);
        int horiz = request.getHorizontalDivisions() + 1;
        int verti = request.getVerticalDivisions() + 1;
        boolean merge = Boolean.TRUE.equals(request.getMerge());
        List splitDocuments = this.splitPdfPages(sourceDocument, verti, horiz);
        String filename = GeneralUtils.generateFilename((String)file.getOriginalFilename(), (String)"_split.pdf");
        if (merge) {
            TempFile tempFile = new TempFile(this.tempFileManager, ".pdf");
            try (PDDocument merged = this.pdfService.mergeDocuments(splitDocuments);
                 OutputStream out = Files.newOutputStream(tempFile.getPath(), new OpenOption[0]);){
                merged.save(out);
                for (PDDocument d : splitDocuments) {
                    d.close();
                }
                sourceDocument.close();
            }
            return WebResponseUtils.pdfFileToWebResponse((TempFile)tempFile, (String)(filename + "_split.pdf"));
        }
        for (PDDocument doc : splitDocuments) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            doc.save((OutputStream)baos);
            doc.close();
            splitDocumentsBoas.add(baos);
        }
        sourceDocument.close();
        TempFile zipTempFile = new TempFile(this.tempFileManager, ".zip");
        try (ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(zipTempFile.getPath(), new OpenOption[0]));){
            int pageNum = 1;
            for (int i = 0; i < splitDocumentsBoas.size(); ++i) {
                ByteArrayOutputStream baos = (ByteArrayOutputStream)splitDocumentsBoas.get(i);
                int sectionNum = i % (horiz * verti) + 1;
                String fileName = filename + "_" + pageNum + "_" + sectionNum + ".pdf";
                byte[] pdf = baos.toByteArray();
                ZipEntry pdfEntry = new ZipEntry(fileName);
                zipOut.putNextEntry(pdfEntry);
                zipOut.write(pdf);
                zipOut.closeEntry();
                if (sectionNum != horiz * verti) continue;
                ++pageNum;
            }
        }
        return WebResponseUtils.zipFileToWebResponse((TempFile)zipTempFile, (String)(filename + "_split.zip"));
    }

    public List<PDDocument> splitPdfPages(PDDocument document, int horizontalDivisions, int verticalDivisions) throws IOException {
        ArrayList<PDDocument> splitDocuments = new ArrayList<PDDocument>();
        for (PDPage originalPage : document.getPages()) {
            PDRectangle originalMediaBox = originalPage.getMediaBox();
            float width = originalMediaBox.getWidth();
            float height = originalMediaBox.getHeight();
            float subPageWidth = width / (float)horizontalDivisions;
            float subPageHeight = height / (float)verticalDivisions;
            LayerUtility layerUtility = new LayerUtility(document);
            for (int i = 0; i < horizontalDivisions; ++i) {
                for (int j = 0; j < verticalDivisions; ++j) {
                    PDDocument subDoc = new PDDocument();
                    PDPage subPage = new PDPage(new PDRectangle(subPageWidth, subPageHeight));
                    subDoc.addPage(subPage);
                    PDFormXObject form = layerUtility.importPageAsForm(document, document.getPages().indexOf(originalPage));
                    try (PDPageContentStream contentStream = new PDPageContentStream(subDoc, subPage, PDPageContentStream.AppendMode.APPEND, true, true);){
                        float translateX = -subPageWidth * (float)i;
                        float translateY = -subPageHeight * (float)(verticalDivisions - 1 - j);
                        contentStream.saveGraphicsState();
                        contentStream.addRect(0.0f, 0.0f, subPageWidth, subPageHeight);
                        contentStream.clip();
                        contentStream.transform(new Matrix(1.0f, 0.0f, 0.0f, 1.0f, translateX, translateY));
                        contentStream.drawForm(form);
                        contentStream.restoreGraphicsState();
                    }
                    splitDocuments.add(subDoc);
                }
            }
        }
        return splitDocuments;
    }

    @Generated
    public SplitPdfBySectionsController(CustomPDFDocumentFactory pdfDocumentFactory, TempFileManager tempFileManager, PDFService pdfService) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.tempFileManager = tempFileManager;
        this.pdfService = pdfService;
    }
}

