/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.pdfbox.multipdf.LayerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.util.Matrix;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.general.ScalePagesRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.GeneralApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@GeneralApi
public class ScalePagesController {
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(value={"/scale-pages"}, consumes={"multipart/form-data"})
    @StandardPdfResponse
    @Operation(summary="Change the size of a PDF page/document", description="This operation takes an input PDF file and the size to scale the pages to in the output PDF file. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> scalePages(@ModelAttribute ScalePagesRequest request) throws IOException {
        MultipartFile file = request.getFileInput();
        String targetPDRectangle = request.getPageSize();
        float scaleFactor = request.getScaleFactor();
        PDDocument sourceDocument = this.pdfDocumentFactory.load(file);
        PDDocument outputDocument = this.pdfDocumentFactory.createNewDocumentBasedOnOldDocument(sourceDocument);
        PDRectangle targetSize = this.getTargetSize(targetPDRectangle, sourceDocument);
        int totalPages = sourceDocument.getNumberOfPages();
        for (int i = 0; i < totalPages; ++i) {
            PDPage sourcePage = sourceDocument.getPage(i);
            PDRectangle sourceSize = sourcePage.getMediaBox();
            float scaleWidth = targetSize.getWidth() / sourceSize.getWidth();
            float scaleHeight = targetSize.getHeight() / sourceSize.getHeight();
            float scale = Math.min(scaleWidth, scaleHeight) * scaleFactor;
            PDPage newPage = new PDPage(targetSize);
            outputDocument.addPage(newPage);
            PDPageContentStream contentStream = new PDPageContentStream(outputDocument, newPage, PDPageContentStream.AppendMode.APPEND, true, true);
            float x = (targetSize.getWidth() - sourceSize.getWidth() * scale) / 2.0f;
            float y = (targetSize.getHeight() - sourceSize.getHeight() * scale) / 2.0f;
            contentStream.saveGraphicsState();
            contentStream.transform(Matrix.getTranslateInstance((float)x, (float)y));
            contentStream.transform(Matrix.getScaleInstance((float)scale, (float)scale));
            LayerUtility layerUtility = new LayerUtility(outputDocument);
            PDFormXObject form = layerUtility.importPageAsForm(sourceDocument, i);
            contentStream.drawForm(form);
            contentStream.restoreGraphicsState();
            contentStream.close();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        outputDocument.save((OutputStream)baos);
        outputDocument.close();
        sourceDocument.close();
        return WebResponseUtils.bytesToWebResponse((byte[])baos.toByteArray(), (String)GeneralUtils.generateFilename((String)file.getOriginalFilename(), (String)"_scaled.pdf"));
    }

    private PDRectangle getTargetSize(String targetPDRectangle, PDDocument sourceDocument) {
        if ("KEEP".equals(targetPDRectangle)) {
            if (sourceDocument.getNumberOfPages() == 0) {
                throw ExceptionUtils.createInvalidPageSizeException((String)"KEEP");
            }
            PDPage sourcePage = sourceDocument.getPage(0);
            PDRectangle sourceSize = sourcePage.getMediaBox();
            if (sourceSize == null) {
                throw ExceptionUtils.createInvalidPageSizeException((String)"KEEP");
            }
            return sourceSize;
        }
        Map sizeMap = this.getSizeMap();
        if (sizeMap.containsKey(targetPDRectangle)) {
            return (PDRectangle)sizeMap.get(targetPDRectangle);
        }
        throw ExceptionUtils.createInvalidPageSizeException((String)targetPDRectangle);
    }

    private Map<String, PDRectangle> getSizeMap() {
        HashMap<String, PDRectangle> sizeMap = new HashMap<String, PDRectangle>();
        sizeMap.put("A0", PDRectangle.A0);
        sizeMap.put("A1", PDRectangle.A1);
        sizeMap.put("A2", PDRectangle.A2);
        sizeMap.put("A3", PDRectangle.A3);
        sizeMap.put("A4", PDRectangle.A4);
        sizeMap.put("A5", PDRectangle.A5);
        sizeMap.put("A6", PDRectangle.A6);
        sizeMap.put("LETTER", PDRectangle.LETTER);
        sizeMap.put("LEGAL", PDRectangle.LEGAL);
        return sizeMap;
    }

    @Generated
    public ScalePagesController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

