/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import lombok.Generated;
import org.apache.pdfbox.multipdf.LayerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.model.api.general.MergeMultiplePagesRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.GeneralApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@GeneralApi
public class MultiPageLayoutController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiPageLayoutController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(value={"/multi-page-layout"}, consumes={"multipart/form-data"})
    @StandardPdfResponse
    @Operation(summary="Merge multiple pages of a PDF document into a single page", description="This operation takes an input PDF file and the number of pages to merge into a single sheet in the output PDF file. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> mergeMultiplePagesIntoOne(@ModelAttribute MergeMultiplePagesRequest request) throws IOException {
        int pagesPerSheet = request.getPagesPerSheet();
        MultipartFile file = request.getFileInput();
        boolean addBorder = Boolean.TRUE.equals(request.getAddBorder());
        if (pagesPerSheet != 2 && pagesPerSheet != 3 && (double)pagesPerSheet != (double)((int)Math.sqrt(pagesPerSheet)) * Math.sqrt(pagesPerSheet)) {
            throw new IllegalArgumentException("pagesPerSheet must be 2, 3 or a perfect square");
        }
        int cols = pagesPerSheet == 2 || pagesPerSheet == 3 ? pagesPerSheet : (int)Math.sqrt(pagesPerSheet);
        int rows = pagesPerSheet == 2 || pagesPerSheet == 3 ? 1 : (int)Math.sqrt(pagesPerSheet);
        PDDocument sourceDocument = this.pdfDocumentFactory.load(file);
        PDDocument newDocument = this.pdfDocumentFactory.createNewDocumentBasedOnOldDocument(sourceDocument);
        PDPage newPage = new PDPage(PDRectangle.A4);
        newDocument.addPage(newPage);
        int totalPages = sourceDocument.getNumberOfPages();
        float cellWidth = newPage.getMediaBox().getWidth() / (float)cols;
        float cellHeight = newPage.getMediaBox().getHeight() / (float)rows;
        PDPageContentStream contentStream = new PDPageContentStream(newDocument, newPage, PDPageContentStream.AppendMode.APPEND, true, true);
        LayerUtility layerUtility = new LayerUtility(newDocument);
        float borderThickness = 1.5f;
        contentStream.setLineWidth(borderThickness);
        contentStream.setStrokingColor(Color.BLACK);
        for (int i = 0; i < totalPages; ++i) {
            if (i != 0 && i % pagesPerSheet == 0) {
                contentStream.close();
                newPage = new PDPage(PDRectangle.A4);
                newDocument.addPage(newPage);
                contentStream = new PDPageContentStream(newDocument, newPage, PDPageContentStream.AppendMode.APPEND, true, true);
            }
            PDPage sourcePage = sourceDocument.getPage(i);
            PDRectangle rect = sourcePage.getMediaBox();
            float scaleWidth = cellWidth / rect.getWidth();
            float scaleHeight = cellHeight / rect.getHeight();
            float scale = Math.min(scaleWidth, scaleHeight);
            int adjustedPageIndex = i % pagesPerSheet;
            int rowIndex = adjustedPageIndex / cols;
            int colIndex = adjustedPageIndex % cols;
            float x = (float)colIndex * cellWidth + (cellWidth - rect.getWidth() * scale) / 2.0f;
            float y = newPage.getMediaBox().getHeight() - ((float)(rowIndex + 1) * cellHeight - (cellHeight - rect.getHeight() * scale) / 2.0f);
            contentStream.saveGraphicsState();
            contentStream.transform(Matrix.getTranslateInstance((float)x, (float)y));
            contentStream.transform(Matrix.getScaleInstance((float)scale, (float)scale));
            PDFormXObject formXObject = layerUtility.importPageAsForm(sourceDocument, i);
            contentStream.drawForm(formXObject);
            contentStream.restoreGraphicsState();
            if (!addBorder) continue;
            float borderX = (float)colIndex * cellWidth;
            float borderY = newPage.getMediaBox().getHeight() - (float)(rowIndex + 1) * cellHeight;
            contentStream.addRect(borderX, borderY, cellWidth, cellHeight);
            contentStream.stroke();
        }
        contentStream.close();
        sourceDocument.close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        newDocument.save((OutputStream)baos);
        newDocument.close();
        byte[] result = baos.toByteArray();
        return WebResponseUtils.bytesToWebResponse((byte[])result, (String)GeneralUtils.generateFilename((String)file.getOriginalFilename(), (String)"_multi_page_layout.pdf"));
    }

    @Generated
    public MultiPageLayoutController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

