/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;

public class TSAClient {
    private static final Logger LOG = LogManager.getLogger(TSAClient.class);
    private static final DigestAlgorithmIdentifierFinder ALGORITHM_OID_FINDER = new DefaultDigestAlgorithmIdentifierFinder();
    private static final Random RANDOM = new SecureRandom();
    private final URL url;
    private final String username;
    private final String password;
    private final MessageDigest digest;

    public TSAClient(URL url, String username, String password, MessageDigest digest) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.digest = digest;
    }

    public TimeStampToken getTimeStampToken(InputStream content) throws IOException {
        TimeStampResponse response;
        this.digest.reset();
        DigestInputStream dis = new DigestInputStream(content, this.digest);
        while (dis.read() != -1) {
        }
        byte[] hash = this.digest.digest();
        int nonce = RANDOM.nextInt();
        TimeStampRequestGenerator tsaGenerator = new TimeStampRequestGenerator();
        tsaGenerator.setCertReq(true);
        ASN1ObjectIdentifier oid = ALGORITHM_OID_FINDER.find(this.digest.getAlgorithm()).getAlgorithm();
        TimeStampRequest request = tsaGenerator.generate(oid, hash, BigInteger.valueOf(nonce));
        byte[] tsaResponse = this.getTSAResponse(request.getEncoded());
        try {
            response = new TimeStampResponse(tsaResponse);
            response.validate(request);
        }
        catch (TSPException e) {
            throw new IOException(e);
        }
        TimeStampToken timeStampToken = response.getTimeStampToken();
        if (timeStampToken == null) {
            throw new IOException("Response from " + String.valueOf(this.url) + " does not have a time stamp token, status: " + response.getStatus() + " (" + response.getStatusString() + ")");
        }
        return timeStampToken;
    }

    private byte[] getTSAResponse(byte[] request) throws IOException {
        byte[] response;
        LOG.debug("Opening connection to TSA server");
        URLConnection connection = this.url.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-Type", "application/timestamp-query");
        LOG.debug("Established connection to TSA server");
        if (this.username != null && this.password != null && !this.username.isEmpty() && !this.password.isEmpty()) {
            String contentEncoding = connection.getContentEncoding();
            if (contentEncoding == null) {
                contentEncoding = StandardCharsets.UTF_8.name();
            }
            connection.setRequestProperty("Authorization", "Basic " + new String(Base64.getEncoder().encode((this.username + ":" + this.password).getBytes(contentEncoding))));
        }
        try (OutputStream output = connection.getOutputStream();){
            output.write(request);
        }
        catch (IOException ex) {
            LOG.error("Exception when writing to {}", (Object)this.url, (Object)ex);
            throw ex;
        }
        LOG.debug("Waiting for response from TSA server");
        try (InputStream input = connection.getInputStream();){
            response = input.readAllBytes();
        }
        catch (IOException ex) {
            LOG.error("Exception when reading from {}", (Object)this.url, (Object)ex);
            throw ex;
        }
        LOG.debug("Received response from TSA server");
        return response;
    }
}

