/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WeeklyActiveUsersService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WeeklyActiveUsersService.class);
    private final Map<String, Instant> activeBrowsers = new ConcurrentHashMap();
    private long totalUniqueBrowsers = 0L;
    private final Instant startTime = Instant.now();

    public void recordBrowserAccess(String browserId) {
        if (browserId == null || browserId.trim().isEmpty()) {
            return;
        }
        boolean isNewBrowser = !this.activeBrowsers.containsKey(browserId);
        this.activeBrowsers.put(browserId, Instant.now());
        if (isNewBrowser) {
            ++this.totalUniqueBrowsers;
            log.debug("New browser recorded: {} (Total: {})", (Object)browserId, (Object)this.totalUniqueBrowsers);
        }
    }

    public long getWeeklyActiveUsers() {
        this.cleanupOldEntries();
        return this.activeBrowsers.size();
    }

    public long getTotalUniqueBrowsers() {
        return this.totalUniqueBrowsers;
    }

    public long getDaysOnline() {
        return ChronoUnit.DAYS.between(this.startTime, Instant.now());
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    private void cleanupOldEntries() {
        Instant sevenDaysAgo = Instant.now().minus(7L, ChronoUnit.DAYS);
        this.activeBrowsers.entrySet().removeIf(entry -> ((Instant)entry.getValue()).isBefore(sevenDaysAgo));
    }

    public void performCleanup() {
        int sizeBefore = this.activeBrowsers.size();
        this.cleanupOldEntries();
        int sizeAfter = this.activeBrowsers.size();
        if (sizeBefore != sizeAfter) {
            log.debug("Cleaned up {} old browser entries", (Object)(sizeBefore - sizeAfter));
        }
    }
}

