/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.filters;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.FilterResponse;
import stirling.software.SPDF.model.api.PDFComparisonAndCount;
import stirling.software.SPDF.model.api.PDFWithPageNums;
import stirling.software.SPDF.model.api.filter.ContainsTextRequest;
import stirling.software.SPDF.model.api.filter.FileSizeRequest;
import stirling.software.SPDF.model.api.filter.PageRotationRequest;
import stirling.software.SPDF.model.api.filter.PageSizeRequest;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.FilterApi;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.PdfUtils;
import stirling.software.common.util.WebResponseUtils;

@FilterApi
public class FilterController {
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/filter-contains-text"})
    @FilterResponse
    @Operation(summary="Checks if a PDF contains set text, returns true if does", description="Input:PDF Output:Boolean Type:SISO")
    public ResponseEntity<byte[]> containsText(@ModelAttribute ContainsTextRequest request) throws IOException, InterruptedException {
        MultipartFile inputFile = request.getFileInput();
        String text = request.getText();
        String pageNumber = request.getPageNumbers();
        try (PDDocument pdfDocument = this.pdfDocumentFactory.load(inputFile);){
            if (PdfUtils.hasText((PDDocument)pdfDocument, (String)pageNumber, (String)text)) {
                ResponseEntity responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)pdfDocument, (String)Filenames.toSimpleFileName((String)inputFile.getOriginalFilename()));
                return responseEntity;
            }
        }
        return null;
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/filter-contains-image"})
    @FilterResponse
    @Operation(summary="Checks if a PDF contains an image", description="Input:PDF Output:Boolean Type:SISO")
    public ResponseEntity<byte[]> containsImage(@ModelAttribute PDFWithPageNums request) throws IOException, InterruptedException {
        MultipartFile inputFile = request.getFileInput();
        String pageNumber = request.getPageNumbers();
        PDDocument pdfDocument = this.pdfDocumentFactory.load(inputFile);
        if (PdfUtils.hasImages((PDDocument)pdfDocument, (String)pageNumber)) {
            return WebResponseUtils.pdfDocToWebResponse((PDDocument)pdfDocument, (String)Filenames.toSimpleFileName((String)inputFile.getOriginalFilename()));
        }
        return null;
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/filter-page-count"})
    @FilterResponse
    @Operation(summary="Checks if a PDF is greater, less or equal to a setPageCount", description="Input:PDF Output:Boolean Type:SISO")
    public ResponseEntity<byte[]> pageCount(@ModelAttribute PDFComparisonAndCount request) throws IOException, InterruptedException {
        MultipartFile inputFile = request.getFileInput();
        int pageCount = request.getPageCount();
        String comparator = request.getComparator();
        PDDocument document = this.pdfDocumentFactory.load(inputFile);
        int actualPageCount = document.getNumberOfPages();
        boolean valid = switch (comparator) {
            case "Greater" -> {
                if (actualPageCount > pageCount) {
                    yield true;
                }
                yield false;
            }
            case "Equal" -> {
                if (actualPageCount == pageCount) {
                    yield true;
                }
                yield false;
            }
            case "Less" -> {
                if (actualPageCount < pageCount) {
                    yield true;
                }
                yield false;
            }
            default -> throw ExceptionUtils.createInvalidArgumentException((String)"comparator", (String)comparator);
        };
        if (valid) {
            return WebResponseUtils.multiPartFileToWebResponse((MultipartFile)inputFile);
        }
        return null;
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/filter-page-size"})
    @FilterResponse
    @Operation(summary="Checks if a PDF is of a certain size", description="Input:PDF Output:Boolean Type:SISO")
    public ResponseEntity<byte[]> pageSize(@ModelAttribute PageSizeRequest request) throws IOException, InterruptedException {
        MultipartFile inputFile = request.getFileInput();
        String standardPageSize = request.getStandardPageSize();
        String comparator = request.getComparator();
        PDDocument document = this.pdfDocumentFactory.load(inputFile);
        PDPage firstPage = document.getPage(0);
        PDRectangle actualPageSize = firstPage.getMediaBox();
        float actualArea = actualPageSize.getWidth() * actualPageSize.getHeight();
        PDRectangle standardSize = PdfUtils.textToPageSize((String)standardPageSize);
        float standardArea = standardSize.getWidth() * standardSize.getHeight();
        boolean valid = switch (comparator) {
            case "Greater" -> {
                if (actualArea > standardArea) {
                    yield true;
                }
                yield false;
            }
            case "Equal" -> {
                if (actualArea == standardArea) {
                    yield true;
                }
                yield false;
            }
            case "Less" -> {
                if (actualArea < standardArea) {
                    yield true;
                }
                yield false;
            }
            default -> throw ExceptionUtils.createInvalidArgumentException((String)"comparator", (String)comparator);
        };
        if (valid) {
            return WebResponseUtils.multiPartFileToWebResponse((MultipartFile)inputFile);
        }
        return null;
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/filter-file-size"})
    @FilterResponse
    @Operation(summary="Checks if a PDF is a set file size", description="Input:PDF Output:Boolean Type:SISO")
    public ResponseEntity<byte[]> fileSize(@ModelAttribute FileSizeRequest request) throws IOException, InterruptedException {
        MultipartFile inputFile = request.getFileInput();
        long fileSize = request.getFileSize();
        String comparator = request.getComparator();
        long actualFileSize = inputFile.getSize();
        boolean valid = switch (comparator) {
            case "Greater" -> {
                if (actualFileSize > fileSize) {
                    yield true;
                }
                yield false;
            }
            case "Equal" -> {
                if (actualFileSize == fileSize) {
                    yield true;
                }
                yield false;
            }
            case "Less" -> {
                if (actualFileSize < fileSize) {
                    yield true;
                }
                yield false;
            }
            default -> throw ExceptionUtils.createInvalidArgumentException((String)"comparator", (String)comparator);
        };
        if (valid) {
            return WebResponseUtils.multiPartFileToWebResponse((MultipartFile)inputFile);
        }
        return null;
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/filter-page-rotation"})
    @FilterResponse
    @Operation(summary="Checks if a PDF is of a certain rotation", description="Input:PDF Output:Boolean Type:SISO")
    public ResponseEntity<byte[]> pageRotation(@ModelAttribute PageRotationRequest request) throws IOException, InterruptedException {
        MultipartFile inputFile = request.getFileInput();
        int rotation = request.getRotation();
        String comparator = request.getComparator();
        PDDocument document = this.pdfDocumentFactory.load(inputFile);
        PDPage firstPage = document.getPage(0);
        int actualRotation = firstPage.getRotation();
        boolean valid = switch (comparator) {
            case "Greater" -> {
                if (actualRotation > rotation) {
                    yield true;
                }
                yield false;
            }
            case "Equal" -> {
                if (actualRotation == rotation) {
                    yield true;
                }
                yield false;
            }
            case "Less" -> {
                if (actualRotation < rotation) {
                    yield true;
                }
                yield false;
            }
            default -> throw ExceptionUtils.createInvalidArgumentException((String)"comparator", (String)comparator);
        };
        if (valid) {
            return WebResponseUtils.multiPartFileToWebResponse((MultipartFile)inputFile);
        }
        return null;
    }

    @Generated
    public FilterController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

